/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef DIAGLOG_MAINFITYPES_HEADER
#define DIAGLOG_MAINFITYPES_HEADER


class diaglog_mainfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for diaglog_main_fi message types

fi_tclMessageBase* diaglog_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class diaglog_mainfi_tclMsgBaseMessage : public diaglog_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   diaglog_mainfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class diaglog_mainfi_tclMsgSaveTestResultMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSaveTestResultMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSaveTestResultMethodStart& operator=(const diaglog_mainfi_tclMsgSaveTestResultMethodStart& coRef);
   diaglog_mainfi_tclMsgSaveTestResultMethodStart(const diaglog_mainfi_tclMsgSaveTestResultMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_TestResultList TestResultList;
   virtual ~diaglog_mainfi_tclMsgSaveTestResultMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSaveTestResultMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSaveTestResultMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSaveTestResultMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSaveTestResultMethodResult& operator=(const diaglog_mainfi_tclMsgSaveTestResultMethodResult& coRef);
   diaglog_mainfi_tclMsgSaveTestResultMethodResult(const diaglog_mainfi_tclMsgSaveTestResultMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgSaveTestResultMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSaveTestResultMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& operator=(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef);
   diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_TestResultList TestResultList;
   virtual ~diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& operator=(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef);
   diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgProductionReadRequestMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgProductionReadRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgProductionReadRequestMethodStart& operator=(const diaglog_mainfi_tclMsgProductionReadRequestMethodStart& coRef);
   diaglog_mainfi_tclMsgProductionReadRequestMethodStart(const diaglog_mainfi_tclMsgProductionReadRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_Protocol Protocol;
   tU8 StatusMask;
   tU32 ITCMask;
   tU32 Option;
   virtual ~diaglog_mainfi_tclMsgProductionReadRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgProductionReadRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgProductionReadRequestMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgProductionReadRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgProductionReadRequestMethodResult& operator=(const diaglog_mainfi_tclMsgProductionReadRequestMethodResult& coRef);
   diaglog_mainfi_tclMsgProductionReadRequestMethodResult(const diaglog_mainfi_tclMsgProductionReadRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_ProductionReadResultList ProductionReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgProductionReadRequestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgProductionReadRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgCustomerReadRequestMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgCustomerReadRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& operator=(const diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& coRef);
   diaglog_mainfi_tclMsgCustomerReadRequestMethodStart(const diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_Protocol Protocol;
   tU8 StatusMask;
   tU32 DTCMask;
   tU32 Option;
   virtual ~diaglog_mainfi_tclMsgCustomerReadRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgCustomerReadRequestMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgCustomerReadRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& operator=(const diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& coRef);
   diaglog_mainfi_tclMsgCustomerReadRequestMethodResult(const diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_CustomerReadResultList CustomerReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgCustomerReadRequestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetItcInformationMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetItcInformationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetItcInformationMethodStart& operator=(const diaglog_mainfi_tclMsggetItcInformationMethodStart& coRef);
   diaglog_mainfi_tclMsggetItcInformationMethodStart(const diaglog_mainfi_tclMsggetItcInformationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   std::vector<tU16, std::allocator<tU16> > ITCList;
   virtual ~diaglog_mainfi_tclMsggetItcInformationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetItcInformationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetItcInformationMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetItcInformationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetItcInformationMethodResult& operator=(const diaglog_mainfi_tclMsggetItcInformationMethodResult& coRef);
   diaglog_mainfi_tclMsggetItcInformationMethodResult(const diaglog_mainfi_tclMsggetItcInformationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<diaglog_fi_tcl_ITC_Information, std::allocator<diaglog_fi_tcl_ITC_Information> > ItcInformationList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetItcInformationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetItcInformationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgProductionClearRequestMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgProductionClearRequestMethodStart();

   virtual ~diaglog_mainfi_tclMsgProductionClearRequestMethodStart();

   inline tBool operator==(const diaglog_mainfi_tclMsgProductionClearRequestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgProductionClearRequestMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgProductionClearRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgProductionClearRequestMethodResult& operator=(const diaglog_mainfi_tclMsgProductionClearRequestMethodResult& coRef);
   diaglog_mainfi_tclMsgProductionClearRequestMethodResult(const diaglog_mainfi_tclMsgProductionClearRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgProductionClearRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgProductionClearRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgCustomerClearRequestMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgCustomerClearRequestMethodStart();

   virtual ~diaglog_mainfi_tclMsgCustomerClearRequestMethodStart();

   inline tBool operator==(const diaglog_mainfi_tclMsgCustomerClearRequestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgCustomerClearRequestMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgCustomerClearRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& operator=(const diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& coRef);
   diaglog_mainfi_tclMsgCustomerClearRequestMethodResult(const diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgCustomerClearRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgWriteToMediaMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgWriteToMediaMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgWriteToMediaMethodStart& operator=(const diaglog_mainfi_tclMsgWriteToMediaMethodStart& coRef);
   diaglog_mainfi_tclMsgWriteToMediaMethodStart(const diaglog_mainfi_tclMsgWriteToMediaMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_VDLMediaType Media;
   virtual ~diaglog_mainfi_tclMsgWriteToMediaMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgWriteToMediaMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgWriteToMediaMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgWriteToMediaMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgWriteToMediaMethodResult& operator=(const diaglog_mainfi_tclMsgWriteToMediaMethodResult& coRef);
   diaglog_mainfi_tclMsgWriteToMediaMethodResult(const diaglog_mainfi_tclMsgWriteToMediaMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgWriteToMediaMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgWriteToMediaMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& operator=(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& coRef);
   diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU8 StatusMask;
   tU32 DTCMask;
   virtual ~diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& operator=(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& coRef);
   diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   diaglog_fi_tcl_ReadResultList ReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& operator=(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& coRef);
   diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   virtual ~diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& operator=(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& coRef);
   diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   diaglog_fi_tcl_ReadResultList ReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetSupportedDTCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetSupportedDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetSupportedDTCMethodStart& operator=(const diaglog_mainfi_tclMsggetSupportedDTCMethodStart& coRef);
   diaglog_mainfi_tclMsggetSupportedDTCMethodStart(const diaglog_mainfi_tclMsggetSupportedDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   virtual ~diaglog_mainfi_tclMsggetSupportedDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetSupportedDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetSupportedDTCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetSupportedDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetSupportedDTCMethodResult& operator=(const diaglog_mainfi_tclMsggetSupportedDTCMethodResult& coRef);
   diaglog_mainfi_tclMsggetSupportedDTCMethodResult(const diaglog_mainfi_tclMsggetSupportedDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   diaglog_fi_tcl_ReadResultList ReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetSupportedDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetSupportedDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& operator=(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef);
   diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU8 StatusMask;
   tU32 DTCMask;
   virtual ~diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& operator=(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef);
   diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   tU32 NumberOfDTC;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetStatusByDTCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetStatusByDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetStatusByDTCMethodStart& operator=(const diaglog_mainfi_tclMsggetStatusByDTCMethodStart& coRef);
   diaglog_mainfi_tclMsggetStatusByDTCMethodStart(const diaglog_mainfi_tclMsggetStatusByDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCMask;
   virtual ~diaglog_mainfi_tclMsggetStatusByDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetStatusByDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetStatusByDTCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetStatusByDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetStatusByDTCMethodResult& operator=(const diaglog_mainfi_tclMsggetStatusByDTCMethodResult& coRef);
   diaglog_mainfi_tclMsggetStatusByDTCMethodResult(const diaglog_mainfi_tclMsggetStatusByDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 StatusAvailabilityMask;
   diaglog_fi_tcl_ReadResultList ReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetStatusByDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetStatusByDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& operator=(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& coRef);
   diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTC;
   tU8 DTCExtDataRecordNumber;
   virtual ~diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& operator=(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& coRef);
   diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 StatusOfDtc;
   diaglog_fi_tcl_FreezeFrameList FreezeFrameList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetStatusByITCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetStatusByITCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetStatusByITCMethodStart& operator=(const diaglog_mainfi_tclMsggetStatusByITCMethodStart& coRef);
   diaglog_mainfi_tclMsggetStatusByITCMethodStart(const diaglog_mainfi_tclMsggetStatusByITCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 ITCMask;
   virtual ~diaglog_mainfi_tclMsggetStatusByITCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetStatusByITCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsggetStatusByITCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsggetStatusByITCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsggetStatusByITCMethodResult& operator=(const diaglog_mainfi_tclMsggetStatusByITCMethodResult& coRef);
   diaglog_mainfi_tclMsggetStatusByITCMethodResult(const diaglog_mainfi_tclMsggetStatusByITCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_ReadResultList ReadResultList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsggetStatusByITCMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsggetStatusByITCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef);
   diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   virtual ~diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef);
   diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_SnapshotIdentificationList SnapshotIdentificationList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef);
   diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTC;
   tU8 DTCSnapshotRecordNumber;
   virtual ~diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef);
   diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DTC;
   tU8 StatusOfDtc;
   diaglog_fi_tcl_SnapshotDataList SnapshotDataList;
   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgclearDTCMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgclearDTCMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgclearDTCMethodStart& operator=(const diaglog_mainfi_tclMsgclearDTCMethodStart& coRef);
   diaglog_mainfi_tclMsgclearDTCMethodStart(const diaglog_mainfi_tclMsgclearDTCMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCMask;
   virtual ~diaglog_mainfi_tclMsgclearDTCMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgclearDTCMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgclearDTCMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgclearDTCMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgclearDTCMethodResult& operator=(const diaglog_mainfi_tclMsgclearDTCMethodResult& coRef);
   diaglog_mainfi_tclMsgclearDTCMethodResult(const diaglog_mainfi_tclMsgclearDTCMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgclearDTCMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgclearDTCMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgControlMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgControlMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgControlMethodStart& operator=(const diaglog_mainfi_tclMsgControlMethodStart& coRef);
   diaglog_mainfi_tclMsgControlMethodStart(const diaglog_mainfi_tclMsgControlMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_ControlParameter ControlParameter;
   virtual ~diaglog_mainfi_tclMsgControlMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgControlMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgControlMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgControlMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgControlMethodResult& operator=(const diaglog_mainfi_tclMsgControlMethodResult& coRef);
   diaglog_mainfi_tclMsgControlMethodResult(const diaglog_mainfi_tclMsgControlMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgControlMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgControlMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgControlDtcSettingMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgControlDtcSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgControlDtcSettingMethodStart& operator=(const diaglog_mainfi_tclMsgControlDtcSettingMethodStart& coRef);
   diaglog_mainfi_tclMsgControlDtcSettingMethodStart(const diaglog_mainfi_tclMsgControlDtcSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_ControlParameter ControlParameter;
   diaglog_fi_tcl_ControlList DTC_List;
   virtual ~diaglog_mainfi_tclMsgControlDtcSettingMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgControlDtcSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgControlDtcSettingMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgControlDtcSettingMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgControlDtcSettingMethodResult& operator=(const diaglog_mainfi_tclMsgControlDtcSettingMethodResult& coRef);
   diaglog_mainfi_tclMsgControlDtcSettingMethodResult(const diaglog_mainfi_tclMsgControlDtcSettingMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_MethodResultReply Status;
   virtual ~diaglog_mainfi_tclMsgControlDtcSettingMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgControlDtcSettingMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& operator=(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& coRef);
   diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_DiaglogDefsetType DefSetStateGroup;
   diaglog_fi_tcl_e8_DefSetMode DefSetStateMode;
   virtual ~diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& operator=(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& coRef);
   diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_e8_DiaglogDefsetType DefSetStateGroup;
   diaglog_fi_tcl_e8_DefSetMode DefSetStateMode;
   tBool DefSetStateSuccessful;
   tU16 DefSetStateFirstDifferentParameterId;
   virtual ~diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCActiveGet : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCActiveGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgDTCActiveGet& operator=(const diaglog_mainfi_tclMsgDTCActiveGet& coRef);
   diaglog_mainfi_tclMsgDTCActiveGet(const diaglog_mainfi_tclMsgDTCActiveGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsDTCActive;
   virtual ~diaglog_mainfi_tclMsgDTCActiveGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgDTCActiveGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCActiveUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCActiveUpReg();

   virtual ~diaglog_mainfi_tclMsgDTCActiveUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgDTCActiveUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCActiveRelUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCActiveRelUpReg();

   virtual ~diaglog_mainfi_tclMsgDTCActiveRelUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgDTCActiveRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCActiveStatus : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCActiveStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgDTCActiveStatus& operator=(const diaglog_mainfi_tclMsgDTCActiveStatus& coRef);
   diaglog_mainfi_tclMsgDTCActiveStatus(const diaglog_mainfi_tclMsgDTCActiveStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool IsDTCActive;
   tU32 DTC;
   tU8 DTCStatus;
   tU8 DTCFailureType;
   virtual ~diaglog_mainfi_tclMsgDTCActiveStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgDTCActiveStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSendNextTestResultUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSendNextTestResultUpReg();

   virtual ~diaglog_mainfi_tclMsgSendNextTestResultUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgSendNextTestResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSendNextTestResultRelUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSendNextTestResultRelUpReg();

   virtual ~diaglog_mainfi_tclMsgSendNextTestResultRelUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgSendNextTestResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSendNextTestResultStatus : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSendNextTestResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSendNextTestResultStatus& operator=(const diaglog_mainfi_tclMsgSendNextTestResultStatus& coRef);
   diaglog_mainfi_tclMsgSendNextTestResultStatus(const diaglog_mainfi_tclMsgSendNextTestResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_SendNextTestResultStructure NextTestResultStruct;
   tBool Status;
   virtual ~diaglog_mainfi_tclMsgSendNextTestResultStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSendNextTestResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCTriggeredUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCTriggeredUpReg();

   virtual ~diaglog_mainfi_tclMsgDTCTriggeredUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgDTCTriggeredUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCTriggeredRelUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCTriggeredRelUpReg();

   virtual ~diaglog_mainfi_tclMsgDTCTriggeredRelUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgDTCTriggeredRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCTriggeredGet : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCTriggeredGet();

   virtual ~diaglog_mainfi_tclMsgDTCTriggeredGet();

   inline tBool operator==(const diaglog_mainfi_tclMsgDTCTriggeredGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDTCTriggeredStatus : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDTCTriggeredStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgDTCTriggeredStatus& operator=(const diaglog_mainfi_tclMsgDTCTriggeredStatus& coRef);
   diaglog_mainfi_tclMsgDTCTriggeredStatus(const diaglog_mainfi_tclMsgDTCTriggeredStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDTCTriggeredFlag;
   tU8 u8DTCSource;
   tU16 u16DTCNumber;
   tU8 u8DTCFailureType;
   tBool bDTCWarningIndicatorRequestedStatus;
   tBool bDTCTestFailedSincePowerUpStatus;
   tBool bDTCTestNotPassedSincePowerUpStatus;
   tBool bDTCHistoryStatus;
   tBool bDTCTestFailedSinceCodeClearedStatus;
   tBool bDTCTestNotPassedSinceCodeClearedStatus;
   tBool bDTCCurrentStatus;
   tBool bDTCCodeSupported;
   diaglog_fi_tcl_e8_GMLnGWDTCFaultType e8DTCFaultType;
   virtual ~diaglog_mainfi_tclMsgDTCTriggeredStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgDTCTriggeredStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSendActiveDTCListUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSendActiveDTCListUpReg();

   virtual ~diaglog_mainfi_tclMsgSendActiveDTCListUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgSendActiveDTCListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg();

   virtual ~diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg();

   inline tBool operator==(const diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgSendActiveDTCListStatus : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgSendActiveDTCListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgSendActiveDTCListStatus& operator=(const diaglog_mainfi_tclMsgSendActiveDTCListStatus& coRef);
   diaglog_mainfi_tclMsgSendActiveDTCListStatus(const diaglog_mainfi_tclMsgSendActiveDTCListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_ActiveDTCList ActiveDTCList;
   virtual ~diaglog_mainfi_tclMsgSendActiveDTCListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgSendActiveDTCListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDtcStatusChangedUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDtcStatusChangedUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgDtcStatusChangedUpReg& operator=(const diaglog_mainfi_tclMsgDtcStatusChangedUpReg& coRef);
   diaglog_mainfi_tclMsgDtcStatusChangedUpReg(const diaglog_mainfi_tclMsgDtcStatusChangedUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCNumber;
   tU8 DTCStatusBitMask;
   virtual ~diaglog_mainfi_tclMsgDtcStatusChangedUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgDtcStatusChangedUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& operator=(const diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& coRef);
   diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg(const diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Group;
   tU32 DTCNumber;
   tU8 DTCStatusBitMask;
   virtual ~diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class diaglog_mainfi_tclMsgDtcStatusChangedStatus : public diaglog_mainfi_tclMsgBaseMessage
{
public:

   diaglog_mainfi_tclMsgDtcStatusChangedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   diaglog_mainfi_tclMsgDtcStatusChangedStatus& operator=(const diaglog_mainfi_tclMsgDtcStatusChangedStatus& coRef);
   diaglog_mainfi_tclMsgDtcStatusChangedStatus(const diaglog_mainfi_tclMsgDtcStatusChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   diaglog_fi_tcl_ReadResultStructure DTCResponse;
   virtual ~diaglog_mainfi_tclMsgDtcStatusChangedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const diaglog_mainfi_tclMsgDtcStatusChangedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
