#ifndef _DP_FI_VEHDATAPROFILE_H
#define _DP_FI_VEHDATAPROFILE_H

extern tVoid vInitVehDataProfile(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclVehDataProfileLanguageSyncSource{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguageSyncSource;
   
public:
   dp_tclVehDataProfileLanguageSyncSource(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataProfileLanguageSyncSource() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageSyncSourceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageSyncSourceParam);
   tS32  s32SetData(const tU8 &tLanguageSyncSourceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageSyncSourceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageSyncSourceParam);
   tVoid vSetData(const tU8& tLanguageSyncSourceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataProfileLanguage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguage;
   
public:
   dp_tclVehDataProfileLanguage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataProfileLanguage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageParam);
   tS32  s32SetData(const tU8 &tLanguageParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageParam);
   tVoid vSetData(const tU8& tLanguageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
