#ifndef _DP_FI_VEHDATA_H
#define _DP_FI_VEHDATA_H

extern tVoid vInitVehData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define VEHICLEDATA_S_IMPORT_INTERFACE_DP 
#include "../../di_cfc/components/vd_VehicleData/interfaces/vehicledata_dp_if.h"
//lint +e750




class dp_tclVehDataHMILanguage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tHMILanguage;
   
public:
   dp_tclVehDataHMILanguage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataHMILanguage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tHMILanguageParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tHMILanguageParam);
   tS32  s32SetData(const tU8 &tHMILanguageParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tHMILanguageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tHMILanguageParam);
   tVoid vSetData(const tU8& tHMILanguageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataMeterLanguage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMeterLanguage;
   
public:
   dp_tclVehDataMeterLanguage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataMeterLanguage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMeterLanguageParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMeterLanguageParam);
   tS32  s32SetData(const tU8 &tMeterLanguageParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMeterLanguageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMeterLanguageParam);
   tVoid vSetData(const tU8& tMeterLanguageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataSDSLanguage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSDSLanguage;
   
public:
   dp_tclVehDataSDSLanguage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataSDSLanguage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSDSLanguageParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSDSLanguageParam);
   tS32  s32SetData(const tU8 &tSDSLanguageParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSDSLanguageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSDSLanguageParam);
   tVoid vSetData(const tU8& tSDSLanguageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataDiagLanguage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDiagLanguage;
   
public:
   dp_tclVehDataDiagLanguage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataDiagLanguage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDiagLanguageParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDiagLanguageParam);
   tS32  s32SetData(const tU8 &tDiagLanguageParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDiagLanguageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDiagLanguageParam);
   tVoid vSetData(const tU8& tDiagLanguageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataTemperatureUnit{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTemperatureUnit;
   
public:
   dp_tclVehDataTemperatureUnit(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataTemperatureUnit() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTemperatureUnitParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTemperatureUnitParam);
   tS32  s32SetData(const tU8 &tTemperatureUnitParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTemperatureUnitParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTemperatureUnitParam);
   tVoid vSetData(const tU8& tTemperatureUnitParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataDistanceUnit{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDistanceUnit;
   
public:
   dp_tclVehDataDistanceUnit(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataDistanceUnit() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDistanceUnitParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDistanceUnitParam);
   tS32  s32SetData(const tU8 &tDistanceUnitParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDistanceUnitParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDistanceUnitParam);
   tVoid vSetData(const tU8& tDistanceUnitParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataFuelConsumptionUnit{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tFuelConsumptionUnit;
   
public:
   dp_tclVehDataFuelConsumptionUnit(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataFuelConsumptionUnit() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tFuelConsumptionUnitParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tFuelConsumptionUnitParam);
   tS32  s32SetData(const tU8 &tFuelConsumptionUnitParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tFuelConsumptionUnitParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tFuelConsumptionUnitParam);
   tVoid vSetData(const tU8& tFuelConsumptionUnitParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehDataDistanceTotalizer{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDistanceTotalizer;
   
public:
   dp_tclVehDataDistanceTotalizer(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehDataDistanceTotalizer() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDistanceTotalizerParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDistanceTotalizerParam);
   tS32  s32SetData(const tU32 &tDistanceTotalizerParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDistanceTotalizerParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDistanceTotalizerParam);
   tVoid vSetData(const tU32& tDistanceTotalizerParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
