
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclVehData.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HMILanguage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataHMILanguage::dp_tclVehDataHMILanguage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tHMILanguage,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataHMILanguage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("HMILanguage",(tS32) 0x350af396);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tHMILanguage = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataHMILanguage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("HMILanguage", (tS32)0x350af396);
   (tVoid)myDpElem.bFillData((tVoid*)&tHMILanguage, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataHMILanguage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataHMILanguage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataHMILanguage::tGetData() {
   vUpdate();
   return tHMILanguage;
};
tS32 dp_tclVehDataHMILanguage::s32GetData(tU8& tHMILanguageParam) { 
   vUpdate();
   tHMILanguageParam = tHMILanguage;
   return _s32Status;
}
tS32 dp_tclVehDataHMILanguage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("HMILanguage", (tS32)0x350af396);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataHMILanguage::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataHMILanguage::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataHMILanguage::s32SetData(tU8 &tHMILanguageParam) {
   //init parameter
   (tVoid)memcpy(&tHMILanguage,(tVoid*)&tHMILanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHMILanguageParam' in function 'dp_tclVehDataHMILanguage::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataHMILanguage::s32SetData(const tU8 &tHMILanguageParam) {
   //init parameter
   (tVoid)memcpy(&tHMILanguage,(tVoid*)&tHMILanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHMILanguageParam' in function 'dp_tclVehDataHMILanguage::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataHMILanguage::u8GetData(tU8& tHMILanguageParam) {  
   vUpdate();
   tHMILanguageParam = tHMILanguage;
   return _u8DataStatus;
}
tVoid dp_tclVehDataHMILanguage::vSetData(tU8 &tHMILanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tHMILanguage,(tVoid*)&tHMILanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHMILanguageParam' in function 'dp_tclVehDataHMILanguage::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataHMILanguage::vSetData(const tU8 &tHMILanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tHMILanguage,(tVoid*)&tHMILanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHMILanguageParam' in function 'dp_tclVehDataHMILanguage::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataHMILanguage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataHMILanguage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "HMILanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataHMILanguage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "HMILanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataHMILanguage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HMILanguage", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element HMILanguage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MeterLanguage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataMeterLanguage::dp_tclVehDataMeterLanguage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMeterLanguage,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataMeterLanguage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MeterLanguage",(tS32) 0xd8d95071);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMeterLanguage = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataMeterLanguage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MeterLanguage", (tS32)0xd8d95071);
   (tVoid)myDpElem.bFillData((tVoid*)&tMeterLanguage, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataMeterLanguage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataMeterLanguage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataMeterLanguage::tGetData() {
   vUpdate();
   return tMeterLanguage;
};
tS32 dp_tclVehDataMeterLanguage::s32GetData(tU8& tMeterLanguageParam) { 
   vUpdate();
   tMeterLanguageParam = tMeterLanguage;
   return _s32Status;
}
tS32 dp_tclVehDataMeterLanguage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MeterLanguage", (tS32)0xd8d95071);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataMeterLanguage::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataMeterLanguage::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataMeterLanguage::s32SetData(tU8 &tMeterLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tMeterLanguage,(tVoid*)&tMeterLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMeterLanguageParam' in function 'dp_tclVehDataMeterLanguage::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataMeterLanguage::s32SetData(const tU8 &tMeterLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tMeterLanguage,(tVoid*)&tMeterLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMeterLanguageParam' in function 'dp_tclVehDataMeterLanguage::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataMeterLanguage::u8GetData(tU8& tMeterLanguageParam) {  
   vUpdate();
   tMeterLanguageParam = tMeterLanguage;
   return _u8DataStatus;
}
tVoid dp_tclVehDataMeterLanguage::vSetData(tU8 &tMeterLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tMeterLanguage,(tVoid*)&tMeterLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMeterLanguageParam' in function 'dp_tclVehDataMeterLanguage::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataMeterLanguage::vSetData(const tU8 &tMeterLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tMeterLanguage,(tVoid*)&tMeterLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMeterLanguageParam' in function 'dp_tclVehDataMeterLanguage::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataMeterLanguage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataMeterLanguage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "MeterLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataMeterLanguage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "MeterLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataMeterLanguage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MeterLanguage", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element MeterLanguage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SDSLanguage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataSDSLanguage::dp_tclVehDataSDSLanguage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSDSLanguage,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataSDSLanguage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SDSLanguage",(tS32) 0x3aa17686);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSDSLanguage = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataSDSLanguage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SDSLanguage", (tS32)0x3aa17686);
   (tVoid)myDpElem.bFillData((tVoid*)&tSDSLanguage, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataSDSLanguage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataSDSLanguage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataSDSLanguage::tGetData() {
   vUpdate();
   return tSDSLanguage;
};
tS32 dp_tclVehDataSDSLanguage::s32GetData(tU8& tSDSLanguageParam) { 
   vUpdate();
   tSDSLanguageParam = tSDSLanguage;
   return _s32Status;
}
tS32 dp_tclVehDataSDSLanguage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SDSLanguage", (tS32)0x3aa17686);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataSDSLanguage::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataSDSLanguage::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataSDSLanguage::s32SetData(tU8 &tSDSLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tSDSLanguage,(tVoid*)&tSDSLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSDSLanguageParam' in function 'dp_tclVehDataSDSLanguage::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataSDSLanguage::s32SetData(const tU8 &tSDSLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tSDSLanguage,(tVoid*)&tSDSLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSDSLanguageParam' in function 'dp_tclVehDataSDSLanguage::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataSDSLanguage::u8GetData(tU8& tSDSLanguageParam) {  
   vUpdate();
   tSDSLanguageParam = tSDSLanguage;
   return _u8DataStatus;
}
tVoid dp_tclVehDataSDSLanguage::vSetData(tU8 &tSDSLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tSDSLanguage,(tVoid*)&tSDSLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSDSLanguageParam' in function 'dp_tclVehDataSDSLanguage::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataSDSLanguage::vSetData(const tU8 &tSDSLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tSDSLanguage,(tVoid*)&tSDSLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSDSLanguageParam' in function 'dp_tclVehDataSDSLanguage::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataSDSLanguage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataSDSLanguage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "SDSLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataSDSLanguage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "SDSLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataSDSLanguage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SDSLanguage", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element SDSLanguage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DiagLanguage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataDiagLanguage::dp_tclVehDataDiagLanguage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDiagLanguage,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataDiagLanguage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DiagLanguage",(tS32) 0x112f24a5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDiagLanguage = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataDiagLanguage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DiagLanguage", (tS32)0x112f24a5);
   (tVoid)myDpElem.bFillData((tVoid*)&tDiagLanguage, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataDiagLanguage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataDiagLanguage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataDiagLanguage::tGetData() {
   vUpdate();
   return tDiagLanguage;
};
tS32 dp_tclVehDataDiagLanguage::s32GetData(tU8& tDiagLanguageParam) { 
   vUpdate();
   tDiagLanguageParam = tDiagLanguage;
   return _s32Status;
}
tS32 dp_tclVehDataDiagLanguage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DiagLanguage", (tS32)0x112f24a5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataDiagLanguage::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataDiagLanguage::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataDiagLanguage::s32SetData(tU8 &tDiagLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tDiagLanguage,(tVoid*)&tDiagLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDiagLanguageParam' in function 'dp_tclVehDataDiagLanguage::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataDiagLanguage::s32SetData(const tU8 &tDiagLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tDiagLanguage,(tVoid*)&tDiagLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDiagLanguageParam' in function 'dp_tclVehDataDiagLanguage::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataDiagLanguage::u8GetData(tU8& tDiagLanguageParam) {  
   vUpdate();
   tDiagLanguageParam = tDiagLanguage;
   return _u8DataStatus;
}
tVoid dp_tclVehDataDiagLanguage::vSetData(tU8 &tDiagLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tDiagLanguage,(tVoid*)&tDiagLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDiagLanguageParam' in function 'dp_tclVehDataDiagLanguage::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataDiagLanguage::vSetData(const tU8 &tDiagLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tDiagLanguage,(tVoid*)&tDiagLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDiagLanguageParam' in function 'dp_tclVehDataDiagLanguage::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataDiagLanguage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataDiagLanguage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "DiagLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataDiagLanguage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "DiagLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataDiagLanguage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DiagLanguage", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element DiagLanguage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TemperatureUnit"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataTemperatureUnit::dp_tclVehDataTemperatureUnit(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTemperatureUnit,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataTemperatureUnit::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TemperatureUnit",(tS32) 0xd6daf752);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTemperatureUnit = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataTemperatureUnit::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TemperatureUnit", (tS32)0xd6daf752);
   (tVoid)myDpElem.bFillData((tVoid*)&tTemperatureUnit, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataTemperatureUnit::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataTemperatureUnit::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataTemperatureUnit::tGetData() {
   vUpdate();
   return tTemperatureUnit;
};
tS32 dp_tclVehDataTemperatureUnit::s32GetData(tU8& tTemperatureUnitParam) { 
   vUpdate();
   tTemperatureUnitParam = tTemperatureUnit;
   return _s32Status;
}
tS32 dp_tclVehDataTemperatureUnit::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TemperatureUnit", (tS32)0xd6daf752);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataTemperatureUnit::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataTemperatureUnit::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataTemperatureUnit::s32SetData(tU8 &tTemperatureUnitParam) {
   //init parameter
   (tVoid)memcpy(&tTemperatureUnit,(tVoid*)&tTemperatureUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTemperatureUnitParam' in function 'dp_tclVehDataTemperatureUnit::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataTemperatureUnit::s32SetData(const tU8 &tTemperatureUnitParam) {
   //init parameter
   (tVoid)memcpy(&tTemperatureUnit,(tVoid*)&tTemperatureUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTemperatureUnitParam' in function 'dp_tclVehDataTemperatureUnit::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataTemperatureUnit::u8GetData(tU8& tTemperatureUnitParam) {  
   vUpdate();
   tTemperatureUnitParam = tTemperatureUnit;
   return _u8DataStatus;
}
tVoid dp_tclVehDataTemperatureUnit::vSetData(tU8 &tTemperatureUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tTemperatureUnit,(tVoid*)&tTemperatureUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTemperatureUnitParam' in function 'dp_tclVehDataTemperatureUnit::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataTemperatureUnit::vSetData(const tU8 &tTemperatureUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tTemperatureUnit,(tVoid*)&tTemperatureUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTemperatureUnitParam' in function 'dp_tclVehDataTemperatureUnit::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataTemperatureUnit::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataTemperatureUnit::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "TemperatureUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataTemperatureUnit::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "TemperatureUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataTemperatureUnit::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TemperatureUnit", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element TemperatureUnit has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DistanceUnit"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataDistanceUnit::dp_tclVehDataDistanceUnit(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDistanceUnit,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataDistanceUnit::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DistanceUnit",(tS32) 0x13b09ae7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDistanceUnit = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataDistanceUnit::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DistanceUnit", (tS32)0x13b09ae7);
   (tVoid)myDpElem.bFillData((tVoid*)&tDistanceUnit, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataDistanceUnit::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataDistanceUnit::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataDistanceUnit::tGetData() {
   vUpdate();
   return tDistanceUnit;
};
tS32 dp_tclVehDataDistanceUnit::s32GetData(tU8& tDistanceUnitParam) { 
   vUpdate();
   tDistanceUnitParam = tDistanceUnit;
   return _s32Status;
}
tS32 dp_tclVehDataDistanceUnit::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DistanceUnit", (tS32)0x13b09ae7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataDistanceUnit::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataDistanceUnit::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataDistanceUnit::s32SetData(tU8 &tDistanceUnitParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclVehDataDistanceUnit::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataDistanceUnit::s32SetData(const tU8 &tDistanceUnitParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclVehDataDistanceUnit::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataDistanceUnit::u8GetData(tU8& tDistanceUnitParam) {  
   vUpdate();
   tDistanceUnitParam = tDistanceUnit;
   return _u8DataStatus;
}
tVoid dp_tclVehDataDistanceUnit::vSetData(tU8 &tDistanceUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclVehDataDistanceUnit::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataDistanceUnit::vSetData(const tU8 &tDistanceUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclVehDataDistanceUnit::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataDistanceUnit::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataDistanceUnit::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "DistanceUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataDistanceUnit::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "DistanceUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataDistanceUnit::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DistanceUnit", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element DistanceUnit has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelConsumptionUnit"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataFuelConsumptionUnit::dp_tclVehDataFuelConsumptionUnit(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFuelConsumptionUnit,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataFuelConsumptionUnit::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FuelConsumptionUnit",(tS32) 0x2407ab47);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFuelConsumptionUnit = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataFuelConsumptionUnit::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FuelConsumptionUnit", (tS32)0x2407ab47);
   (tVoid)myDpElem.bFillData((tVoid*)&tFuelConsumptionUnit, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataFuelConsumptionUnit::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataFuelConsumptionUnit::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataFuelConsumptionUnit::tGetData() {
   vUpdate();
   return tFuelConsumptionUnit;
};
tS32 dp_tclVehDataFuelConsumptionUnit::s32GetData(tU8& tFuelConsumptionUnitParam) { 
   vUpdate();
   tFuelConsumptionUnitParam = tFuelConsumptionUnit;
   return _s32Status;
}
tS32 dp_tclVehDataFuelConsumptionUnit::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FuelConsumptionUnit", (tS32)0x2407ab47);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataFuelConsumptionUnit::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataFuelConsumptionUnit::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataFuelConsumptionUnit::s32SetData(tU8 &tFuelConsumptionUnitParam) {
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionUnit,(tVoid*)&tFuelConsumptionUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelConsumptionUnitParam' in function 'dp_tclVehDataFuelConsumptionUnit::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataFuelConsumptionUnit::s32SetData(const tU8 &tFuelConsumptionUnitParam) {
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionUnit,(tVoid*)&tFuelConsumptionUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelConsumptionUnitParam' in function 'dp_tclVehDataFuelConsumptionUnit::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataFuelConsumptionUnit::u8GetData(tU8& tFuelConsumptionUnitParam) {  
   vUpdate();
   tFuelConsumptionUnitParam = tFuelConsumptionUnit;
   return _u8DataStatus;
}
tVoid dp_tclVehDataFuelConsumptionUnit::vSetData(tU8 &tFuelConsumptionUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionUnit,(tVoid*)&tFuelConsumptionUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFuelConsumptionUnitParam' in function 'dp_tclVehDataFuelConsumptionUnit::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataFuelConsumptionUnit::vSetData(const tU8 &tFuelConsumptionUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionUnit,(tVoid*)&tFuelConsumptionUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFuelConsumptionUnitParam' in function 'dp_tclVehDataFuelConsumptionUnit::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataFuelConsumptionUnit::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataFuelConsumptionUnit::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "FuelConsumptionUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataFuelConsumptionUnit::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "FuelConsumptionUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataFuelConsumptionUnit::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelConsumptionUnit", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element FuelConsumptionUnit has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DistanceTotalizer"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataDistanceTotalizer::dp_tclVehDataDistanceTotalizer(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDistanceTotalizer,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataDistanceTotalizer::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DistanceTotalizer",(tS32) 0x5ad121d9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDistanceTotalizer = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataDistanceTotalizer::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DistanceTotalizer", (tS32)0x5ad121d9);
   (tVoid)myDpElem.bFillData((tVoid*)&tDistanceTotalizer, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataDistanceTotalizer::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataDistanceTotalizer::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclVehDataDistanceTotalizer::tGetData() {
   vUpdate();
   return tDistanceTotalizer;
};
tS32 dp_tclVehDataDistanceTotalizer::s32GetData(tU32& tDistanceTotalizerParam) { 
   vUpdate();
   tDistanceTotalizerParam = tDistanceTotalizer;
   return _s32Status;
}
tS32 dp_tclVehDataDistanceTotalizer::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DistanceTotalizer", (tS32)0x5ad121d9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataDistanceTotalizer::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataDistanceTotalizer::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataDistanceTotalizer::s32SetData(tU32 &tDistanceTotalizerParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceTotalizer,(tVoid*)&tDistanceTotalizerParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceTotalizerParam' in function 'dp_tclVehDataDistanceTotalizer::vSetData(tU32)' could be made const reference
tS32 dp_tclVehDataDistanceTotalizer::s32SetData(const tU32 &tDistanceTotalizerParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceTotalizer,(tVoid*)&tDistanceTotalizerParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceTotalizerParam' in function 'dp_tclVehDataDistanceTotalizer::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataDistanceTotalizer::u8GetData(tU32& tDistanceTotalizerParam) {  
   vUpdate();
   tDistanceTotalizerParam = tDistanceTotalizer;
   return _u8DataStatus;
}
tVoid dp_tclVehDataDistanceTotalizer::vSetData(tU32 &tDistanceTotalizerParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceTotalizer,(tVoid*)&tDistanceTotalizerParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDistanceTotalizerParam' in function 'dp_tclVehDataDistanceTotalizer::vSetData(tU32)' could be made const reference
tVoid dp_tclVehDataDistanceTotalizer::vSetData(const tU32 &tDistanceTotalizerParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceTotalizer,(tVoid*)&tDistanceTotalizerParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDistanceTotalizerParam' in function 'dp_tclVehDataDistanceTotalizer::vSetData(tU32)' could be made const reference
tU8   dp_tclVehDataDistanceTotalizer::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataDistanceTotalizer::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATA, "DistanceTotalizer", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataDistanceTotalizer::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATA, "DistanceTotalizer", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataDistanceTotalizer::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DistanceTotalizer", DP_U32_POOL_ID_VEHDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATA);
   }
   else
   {
      fprintf(stdout,"Element DistanceTotalizer has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
