
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclInputDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KeyMatrixData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclInputDPKeyMatrixData::dp_tclInputDPKeyMatrixData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclInputDPKeyMatrixData::s32SetData( tU32* tKeyMatrixDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("KeyMatrixData", (tS32)0xbbaac6ac);
   (tVoid)myDpElem.bFillData((tVoid*)tKeyMatrixDataParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclInputDPKeyMatrixData::s32GetData(tU32* tKeyMatrixDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("KeyMatrixData", (tS32)0xbbaac6ac);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tKeyMatrixDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclInputDPKeyMatrixData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclInputDPKeyMatrixData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclInputDPKeyMatrixData::u16GetData(tU32* tKeyMatrixDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tKeyMatrixDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclInputDPKeyMatrixData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_INPUTDP, "KeyMatrixData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclInputDPKeyMatrixData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_INPUTDP, "KeyMatrixData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclInputDPKeyMatrixData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KeyMatrixData", DP_U32_POOL_ID_INPUTDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_INPUTDP);
		}
		else
		{
			fprintf(stdout,"Element KeyMatrixData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SystemKeyData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclInputDPSystemKeyData::dp_tclInputDPSystemKeyData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclInputDPSystemKeyData::s32SetData( tU32* tSystemKeyDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SystemKeyData", (tS32)0x6b5c7f8c);
   (tVoid)myDpElem.bFillData((tVoid*)tSystemKeyDataParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclInputDPSystemKeyData::s32GetData(tU32* tSystemKeyDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SystemKeyData", (tS32)0x6b5c7f8c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSystemKeyDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclInputDPSystemKeyData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclInputDPSystemKeyData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclInputDPSystemKeyData::u16GetData(tU32* tSystemKeyDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSystemKeyDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclInputDPSystemKeyData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_INPUTDP, "SystemKeyData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclInputDPSystemKeyData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_INPUTDP, "SystemKeyData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclInputDPSystemKeyData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SystemKeyData", DP_U32_POOL_ID_INPUTDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_INPUTDP);
		}
		else
		{
			fprintf(stdout,"Element SystemKeyData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CarBusData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclInputDPCarBusData::dp_tclInputDPCarBusData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclInputDPCarBusData::s32SetData( tU32* tCarBusDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("CarBusData", (tS32)0xaad685a);
   (tVoid)myDpElem.bFillData((tVoid*)tCarBusDataParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclInputDPCarBusData::s32GetData(tU32* tCarBusDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("CarBusData", (tS32)0xaad685a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tCarBusDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclInputDPCarBusData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclInputDPCarBusData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclInputDPCarBusData::u16GetData(tU32* tCarBusDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tCarBusDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclInputDPCarBusData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_INPUTDP, "CarBusData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclInputDPCarBusData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_INPUTDP, "CarBusData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclInputDPCarBusData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CarBusData", DP_U32_POOL_ID_INPUTDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_INPUTDP);
		}
		else
		{
			fprintf(stdout,"Element CarBusData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ITCommanderData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclInputDPITCommanderData::dp_tclInputDPITCommanderData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclInputDPITCommanderData::s32SetData( tU32* tITCommanderDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("ITCommanderData", (tS32)0xfe1a8d09);
   (tVoid)myDpElem.bFillData((tVoid*)tITCommanderDataParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclInputDPITCommanderData::s32GetData(tU32* tITCommanderDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("ITCommanderData", (tS32)0xfe1a8d09);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tITCommanderDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclInputDPITCommanderData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclInputDPITCommanderData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclInputDPITCommanderData::u16GetData(tU32* tITCommanderDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tITCommanderDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclInputDPITCommanderData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_INPUTDP, "ITCommanderData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclInputDPITCommanderData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_INPUTDP, "ITCommanderData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclInputDPITCommanderData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ITCommanderData", DP_U32_POOL_ID_INPUTDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_INPUTDP);
		}
		else
		{
			fprintf(stdout,"Element ITCommanderData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RSCData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclInputDPRSCData::dp_tclInputDPRSCData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclInputDPRSCData::s32SetData( tU32* tRSCDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("RSCData", (tS32)0x1852f6);
   (tVoid)myDpElem.bFillData((tVoid*)tRSCDataParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclInputDPRSCData::s32GetData(tU32* tRSCDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("RSCData", (tS32)0x1852f6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_INPUTDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tRSCDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclInputDPRSCData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclInputDPRSCData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclInputDPRSCData::u16GetData(tU32* tRSCDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tRSCDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclInputDPRSCData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_INPUTDP, "RSCData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclInputDPRSCData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_INPUTDP, "RSCData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclInputDPRSCData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RSCData", DP_U32_POOL_ID_INPUTDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_INPUTDP);
		}
		else
		{
			fprintf(stdout,"Element RSCData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

