
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclVDClockDp.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MasterModeOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpMasterModeOffset::dp_tclVDClockDpMasterModeOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMasterModeOffset,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpMasterModeOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MasterModeOffset",(tS32) 0xb2628c50);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tMasterModeOffset = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpMasterModeOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MasterModeOffset", (tS32)0xb2628c50);
   (tVoid)myDpElem.bFillData((tVoid*)&tMasterModeOffset, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpMasterModeOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpMasterModeOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpMasterModeOffset::tGetData() {
   vUpdate();
   return tMasterModeOffset;
};
tS32 dp_tclVDClockDpMasterModeOffset::s32GetData(tS64& tMasterModeOffsetParam) { 
   vUpdate();
   tMasterModeOffsetParam = tMasterModeOffset;
   return _s32Status;
}
tS32 dp_tclVDClockDpMasterModeOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MasterModeOffset", (tS32)0xb2628c50);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpMasterModeOffset::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpMasterModeOffset::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpMasterModeOffset::s32SetData(tS64 &tMasterModeOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tMasterModeOffset,(tVoid*)&tMasterModeOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMasterModeOffsetParam' in function 'dp_tclVDClockDpMasterModeOffset::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpMasterModeOffset::s32SetData(const tS64 &tMasterModeOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tMasterModeOffset,(tVoid*)&tMasterModeOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMasterModeOffsetParam' in function 'dp_tclVDClockDpMasterModeOffset::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpMasterModeOffset::u8GetData(tS64& tMasterModeOffsetParam) {  
   vUpdate();
   tMasterModeOffsetParam = tMasterModeOffset;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpMasterModeOffset::vSetData(tS64 &tMasterModeOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tMasterModeOffset,(tVoid*)&tMasterModeOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tMasterModeOffsetParam' in function 'dp_tclVDClockDpMasterModeOffset::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpMasterModeOffset::vSetData(const tS64 &tMasterModeOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tMasterModeOffset,(tVoid*)&tMasterModeOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tMasterModeOffsetParam' in function 'dp_tclVDClockDpMasterModeOffset::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpMasterModeOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpMasterModeOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "MasterModeOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpMasterModeOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "MasterModeOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpMasterModeOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MasterModeOffset", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element MasterModeOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AutoModeOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpAutoModeOffset::dp_tclVDClockDpAutoModeOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAutoModeOffset,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpAutoModeOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AutoModeOffset",(tS32) 0xbe4a00dd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tAutoModeOffset = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpAutoModeOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AutoModeOffset", (tS32)0xbe4a00dd);
   (tVoid)myDpElem.bFillData((tVoid*)&tAutoModeOffset, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpAutoModeOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpAutoModeOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpAutoModeOffset::tGetData() {
   vUpdate();
   return tAutoModeOffset;
};
tS32 dp_tclVDClockDpAutoModeOffset::s32GetData(tS64& tAutoModeOffsetParam) { 
   vUpdate();
   tAutoModeOffsetParam = tAutoModeOffset;
   return _s32Status;
}
tS32 dp_tclVDClockDpAutoModeOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AutoModeOffset", (tS32)0xbe4a00dd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpAutoModeOffset::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpAutoModeOffset::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpAutoModeOffset::s32SetData(tS64 &tAutoModeOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tAutoModeOffset,(tVoid*)&tAutoModeOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutoModeOffsetParam' in function 'dp_tclVDClockDpAutoModeOffset::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpAutoModeOffset::s32SetData(const tS64 &tAutoModeOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tAutoModeOffset,(tVoid*)&tAutoModeOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutoModeOffsetParam' in function 'dp_tclVDClockDpAutoModeOffset::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpAutoModeOffset::u8GetData(tS64& tAutoModeOffsetParam) {  
   vUpdate();
   tAutoModeOffsetParam = tAutoModeOffset;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpAutoModeOffset::vSetData(tS64 &tAutoModeOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tAutoModeOffset,(tVoid*)&tAutoModeOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tAutoModeOffsetParam' in function 'dp_tclVDClockDpAutoModeOffset::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpAutoModeOffset::vSetData(const tS64 &tAutoModeOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tAutoModeOffset,(tVoid*)&tAutoModeOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tAutoModeOffsetParam' in function 'dp_tclVDClockDpAutoModeOffset::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpAutoModeOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpAutoModeOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "AutoModeOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpAutoModeOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "AutoModeOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpAutoModeOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AutoModeOffset", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element AutoModeOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TimezoneIndex"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpTimezoneIndex::dp_tclVDClockDpTimezoneIndex(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTimezoneIndex,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpTimezoneIndex::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TimezoneIndex",(tS32) 0x46a346bf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tTimezoneIndex = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpTimezoneIndex::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TimezoneIndex", (tS32)0x46a346bf);
   (tVoid)myDpElem.bFillData((tVoid*)&tTimezoneIndex, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpTimezoneIndex::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpTimezoneIndex::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclVDClockDpTimezoneIndex::tGetData() {
   vUpdate();
   return tTimezoneIndex;
};
tS32 dp_tclVDClockDpTimezoneIndex::s32GetData(tU16& tTimezoneIndexParam) { 
   vUpdate();
   tTimezoneIndexParam = tTimezoneIndex;
   return _s32Status;
}
tS32 dp_tclVDClockDpTimezoneIndex::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TimezoneIndex", (tS32)0x46a346bf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpTimezoneIndex::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpTimezoneIndex::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpTimezoneIndex::s32SetData(tU16 &tTimezoneIndexParam) {
   //init parameter
   (tVoid)memcpy(&tTimezoneIndex,(tVoid*)&tTimezoneIndexParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimezoneIndexParam' in function 'dp_tclVDClockDpTimezoneIndex::vSetData(tU16)' could be made const reference
tS32 dp_tclVDClockDpTimezoneIndex::s32SetData(const tU16 &tTimezoneIndexParam) {
   //init parameter
   (tVoid)memcpy(&tTimezoneIndex,(tVoid*)&tTimezoneIndexParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimezoneIndexParam' in function 'dp_tclVDClockDpTimezoneIndex::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpTimezoneIndex::u8GetData(tU16& tTimezoneIndexParam) {  
   vUpdate();
   tTimezoneIndexParam = tTimezoneIndex;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpTimezoneIndex::vSetData(tU16 &tTimezoneIndexParam) { 
   //init parameter
   (tVoid)memcpy(&tTimezoneIndex,(tVoid*)&tTimezoneIndexParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tTimezoneIndexParam' in function 'dp_tclVDClockDpTimezoneIndex::vSetData(tU16)' could be made const reference
tVoid dp_tclVDClockDpTimezoneIndex::vSetData(const tU16 &tTimezoneIndexParam) { 
   //init parameter
   (tVoid)memcpy(&tTimezoneIndex,(tVoid*)&tTimezoneIndexParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tTimezoneIndexParam' in function 'dp_tclVDClockDpTimezoneIndex::vSetData(tU16)' could be made const reference
tU8   dp_tclVDClockDpTimezoneIndex::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpTimezoneIndex::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "TimezoneIndex", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpTimezoneIndex::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "TimezoneIndex", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpTimezoneIndex::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TimezoneIndex", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element TimezoneIndex has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "bGPSAutoSync"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpbGPSAutoSync::dp_tclVDClockDpbGPSAutoSync(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tbGPSAutoSync,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpbGPSAutoSync::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("bGPSAutoSync",(tS32) 0x523a9a9a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tbGPSAutoSync = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpbGPSAutoSync::vStore(tVoid) {
   dp_tclBaseElement myDpElem("bGPSAutoSync", (tS32)0x523a9a9a);
   (tVoid)myDpElem.bFillData((tVoid*)&tbGPSAutoSync, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpbGPSAutoSync::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpbGPSAutoSync::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVDClockDpbGPSAutoSync::tGetData() {
   vUpdate();
   return tbGPSAutoSync;
};
tS32 dp_tclVDClockDpbGPSAutoSync::s32GetData(tBool& tbGPSAutoSyncParam) { 
   vUpdate();
   tbGPSAutoSyncParam = tbGPSAutoSync;
   return _s32Status;
}
tS32 dp_tclVDClockDpbGPSAutoSync::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("bGPSAutoSync", (tS32)0x523a9a9a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpbGPSAutoSync::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpbGPSAutoSync::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpbGPSAutoSync::s32SetData(tBool &tbGPSAutoSyncParam) {
   //init parameter
   (tVoid)memcpy(&tbGPSAutoSync,(tVoid*)&tbGPSAutoSyncParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbGPSAutoSyncParam' in function 'dp_tclVDClockDpbGPSAutoSync::vSetData(tBool)' could be made const reference
tS32 dp_tclVDClockDpbGPSAutoSync::s32SetData(const tBool &tbGPSAutoSyncParam) {
   //init parameter
   (tVoid)memcpy(&tbGPSAutoSync,(tVoid*)&tbGPSAutoSyncParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbGPSAutoSyncParam' in function 'dp_tclVDClockDpbGPSAutoSync::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpbGPSAutoSync::u8GetData(tBool& tbGPSAutoSyncParam) {  
   vUpdate();
   tbGPSAutoSyncParam = tbGPSAutoSync;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpbGPSAutoSync::vSetData(tBool &tbGPSAutoSyncParam) { 
   //init parameter
   (tVoid)memcpy(&tbGPSAutoSync,(tVoid*)&tbGPSAutoSyncParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbGPSAutoSyncParam' in function 'dp_tclVDClockDpbGPSAutoSync::vSetData(tBool)' could be made const reference
tVoid dp_tclVDClockDpbGPSAutoSync::vSetData(const tBool &tbGPSAutoSyncParam) { 
   //init parameter
   (tVoid)memcpy(&tbGPSAutoSync,(tVoid*)&tbGPSAutoSyncParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbGPSAutoSyncParam' in function 'dp_tclVDClockDpbGPSAutoSync::vSetData(tBool)' could be made const reference
tU8   dp_tclVDClockDpbGPSAutoSync::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpbGPSAutoSync::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "bGPSAutoSync", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbGPSAutoSync::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "bGPSAutoSync", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbGPSAutoSync::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: bGPSAutoSync", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element bGPSAutoSync has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "bAutoEnabled"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpbAutoEnabled::dp_tclVDClockDpbAutoEnabled(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tbAutoEnabled,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpbAutoEnabled::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("bAutoEnabled",(tS32) 0x53fae93a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tbAutoEnabled = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpbAutoEnabled::vStore(tVoid) {
   dp_tclBaseElement myDpElem("bAutoEnabled", (tS32)0x53fae93a);
   (tVoid)myDpElem.bFillData((tVoid*)&tbAutoEnabled, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpbAutoEnabled::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpbAutoEnabled::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVDClockDpbAutoEnabled::tGetData() {
   vUpdate();
   return tbAutoEnabled;
};
tS32 dp_tclVDClockDpbAutoEnabled::s32GetData(tBool& tbAutoEnabledParam) { 
   vUpdate();
   tbAutoEnabledParam = tbAutoEnabled;
   return _s32Status;
}
tS32 dp_tclVDClockDpbAutoEnabled::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("bAutoEnabled", (tS32)0x53fae93a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpbAutoEnabled::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpbAutoEnabled::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpbAutoEnabled::s32SetData(tBool &tbAutoEnabledParam) {
   //init parameter
   (tVoid)memcpy(&tbAutoEnabled,(tVoid*)&tbAutoEnabledParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbAutoEnabledParam' in function 'dp_tclVDClockDpbAutoEnabled::vSetData(tBool)' could be made const reference
tS32 dp_tclVDClockDpbAutoEnabled::s32SetData(const tBool &tbAutoEnabledParam) {
   //init parameter
   (tVoid)memcpy(&tbAutoEnabled,(tVoid*)&tbAutoEnabledParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbAutoEnabledParam' in function 'dp_tclVDClockDpbAutoEnabled::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpbAutoEnabled::u8GetData(tBool& tbAutoEnabledParam) {  
   vUpdate();
   tbAutoEnabledParam = tbAutoEnabled;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpbAutoEnabled::vSetData(tBool &tbAutoEnabledParam) { 
   //init parameter
   (tVoid)memcpy(&tbAutoEnabled,(tVoid*)&tbAutoEnabledParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbAutoEnabledParam' in function 'dp_tclVDClockDpbAutoEnabled::vSetData(tBool)' could be made const reference
tVoid dp_tclVDClockDpbAutoEnabled::vSetData(const tBool &tbAutoEnabledParam) { 
   //init parameter
   (tVoid)memcpy(&tbAutoEnabled,(tVoid*)&tbAutoEnabledParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbAutoEnabledParam' in function 'dp_tclVDClockDpbAutoEnabled::vSetData(tBool)' could be made const reference
tU8   dp_tclVDClockDpbAutoEnabled::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpbAutoEnabled::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "bAutoEnabled", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbAutoEnabled::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "bAutoEnabled", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbAutoEnabled::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: bAutoEnabled", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element bAutoEnabled has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "bDST"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpbDST::dp_tclVDClockDpbDST(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tbDST,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpbDST::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("bDST",(tS32) 0x3871);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tbDST = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpbDST::vStore(tVoid) {
   dp_tclBaseElement myDpElem("bDST", (tS32)0x3871);
   (tVoid)myDpElem.bFillData((tVoid*)&tbDST, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpbDST::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpbDST::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVDClockDpbDST::tGetData() {
   vUpdate();
   return tbDST;
};
tS32 dp_tclVDClockDpbDST::s32GetData(tBool& tbDSTParam) { 
   vUpdate();
   tbDSTParam = tbDST;
   return _s32Status;
}
tS32 dp_tclVDClockDpbDST::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("bDST", (tS32)0x3871);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpbDST::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpbDST::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpbDST::s32SetData(tBool &tbDSTParam) {
   //init parameter
   (tVoid)memcpy(&tbDST,(tVoid*)&tbDSTParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbDSTParam' in function 'dp_tclVDClockDpbDST::vSetData(tBool)' could be made const reference
tS32 dp_tclVDClockDpbDST::s32SetData(const tBool &tbDSTParam) {
   //init parameter
   (tVoid)memcpy(&tbDST,(tVoid*)&tbDSTParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbDSTParam' in function 'dp_tclVDClockDpbDST::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpbDST::u8GetData(tBool& tbDSTParam) {  
   vUpdate();
   tbDSTParam = tbDST;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpbDST::vSetData(tBool &tbDSTParam) { 
   //init parameter
   (tVoid)memcpy(&tbDST,(tVoid*)&tbDSTParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbDSTParam' in function 'dp_tclVDClockDpbDST::vSetData(tBool)' could be made const reference
tVoid dp_tclVDClockDpbDST::vSetData(const tBool &tbDSTParam) { 
   //init parameter
   (tVoid)memcpy(&tbDST,(tVoid*)&tbDSTParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbDSTParam' in function 'dp_tclVDClockDpbDST::vSetData(tBool)' could be made const reference
tU8   dp_tclVDClockDpbDST::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpbDST::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "bDST", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbDST::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "bDST", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbDST::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: bDST", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element bDST has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "bDSTAutoSet"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpbDSTAutoSet::dp_tclVDClockDpbDSTAutoSet(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tbDSTAutoSet,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpbDSTAutoSet::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("bDSTAutoSet",(tS32) 0x435efc4e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tbDSTAutoSet = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpbDSTAutoSet::vStore(tVoid) {
   dp_tclBaseElement myDpElem("bDSTAutoSet", (tS32)0x435efc4e);
   (tVoid)myDpElem.bFillData((tVoid*)&tbDSTAutoSet, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpbDSTAutoSet::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpbDSTAutoSet::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVDClockDpbDSTAutoSet::tGetData() {
   vUpdate();
   return tbDSTAutoSet;
};
tS32 dp_tclVDClockDpbDSTAutoSet::s32GetData(tBool& tbDSTAutoSetParam) { 
   vUpdate();
   tbDSTAutoSetParam = tbDSTAutoSet;
   return _s32Status;
}
tS32 dp_tclVDClockDpbDSTAutoSet::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("bDSTAutoSet", (tS32)0x435efc4e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpbDSTAutoSet::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpbDSTAutoSet::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpbDSTAutoSet::s32SetData(tBool &tbDSTAutoSetParam) {
   //init parameter
   (tVoid)memcpy(&tbDSTAutoSet,(tVoid*)&tbDSTAutoSetParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbDSTAutoSetParam' in function 'dp_tclVDClockDpbDSTAutoSet::vSetData(tBool)' could be made const reference
tS32 dp_tclVDClockDpbDSTAutoSet::s32SetData(const tBool &tbDSTAutoSetParam) {
   //init parameter
   (tVoid)memcpy(&tbDSTAutoSet,(tVoid*)&tbDSTAutoSetParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbDSTAutoSetParam' in function 'dp_tclVDClockDpbDSTAutoSet::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpbDSTAutoSet::u8GetData(tBool& tbDSTAutoSetParam) {  
   vUpdate();
   tbDSTAutoSetParam = tbDSTAutoSet;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpbDSTAutoSet::vSetData(tBool &tbDSTAutoSetParam) { 
   //init parameter
   (tVoid)memcpy(&tbDSTAutoSet,(tVoid*)&tbDSTAutoSetParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbDSTAutoSetParam' in function 'dp_tclVDClockDpbDSTAutoSet::vSetData(tBool)' could be made const reference
tVoid dp_tclVDClockDpbDSTAutoSet::vSetData(const tBool &tbDSTAutoSetParam) { 
   //init parameter
   (tVoid)memcpy(&tbDSTAutoSet,(tVoid*)&tbDSTAutoSetParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbDSTAutoSetParam' in function 'dp_tclVDClockDpbDSTAutoSet::vSetData(tBool)' could be made const reference
tU8   dp_tclVDClockDpbDSTAutoSet::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpbDSTAutoSet::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "bDSTAutoSet", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbDSTAutoSet::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "bDSTAutoSet", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbDSTAutoSet::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: bDSTAutoSet", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element bDSTAutoSet has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Timeformat"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpTimeformat::dp_tclVDClockDpTimeformat(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTimeformat,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpTimeformat::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Timeformat",(tS32) 0xcd973e8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTimeformat = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpTimeformat::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Timeformat", (tS32)0xcd973e8);
   (tVoid)myDpElem.bFillData((tVoid*)&tTimeformat, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpTimeformat::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpTimeformat::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVDClockDpTimeformat::tGetData() {
   vUpdate();
   return tTimeformat;
};
tS32 dp_tclVDClockDpTimeformat::s32GetData(tU8& tTimeformatParam) { 
   vUpdate();
   tTimeformatParam = tTimeformat;
   return _s32Status;
}
tS32 dp_tclVDClockDpTimeformat::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Timeformat", (tS32)0xcd973e8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpTimeformat::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpTimeformat::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpTimeformat::s32SetData(tU8 &tTimeformatParam) {
   //init parameter
   (tVoid)memcpy(&tTimeformat,(tVoid*)&tTimeformatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimeformatParam' in function 'dp_tclVDClockDpTimeformat::vSetData(tU8)' could be made const reference
tS32 dp_tclVDClockDpTimeformat::s32SetData(const tU8 &tTimeformatParam) {
   //init parameter
   (tVoid)memcpy(&tTimeformat,(tVoid*)&tTimeformatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimeformatParam' in function 'dp_tclVDClockDpTimeformat::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpTimeformat::u8GetData(tU8& tTimeformatParam) {  
   vUpdate();
   tTimeformatParam = tTimeformat;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpTimeformat::vSetData(tU8 &tTimeformatParam) { 
   //init parameter
   (tVoid)memcpy(&tTimeformat,(tVoid*)&tTimeformatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTimeformatParam' in function 'dp_tclVDClockDpTimeformat::vSetData(tU8)' could be made const reference
tVoid dp_tclVDClockDpTimeformat::vSetData(const tU8 &tTimeformatParam) { 
   //init parameter
   (tVoid)memcpy(&tTimeformat,(tVoid*)&tTimeformatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTimeformatParam' in function 'dp_tclVDClockDpTimeformat::vSetData(tU8)' could be made const reference
tU8   dp_tclVDClockDpTimeformat::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpTimeformat::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Timeformat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpTimeformat::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Timeformat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpTimeformat::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Timeformat", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Timeformat has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Dateformat"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpDateformat::dp_tclVDClockDpDateformat(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDateformat,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpDateformat::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Dateformat",(tS32) 0xad546cb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDateformat = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpDateformat::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Dateformat", (tS32)0xad546cb);
   (tVoid)myDpElem.bFillData((tVoid*)&tDateformat, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpDateformat::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpDateformat::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVDClockDpDateformat::tGetData() {
   vUpdate();
   return tDateformat;
};
tS32 dp_tclVDClockDpDateformat::s32GetData(tU8& tDateformatParam) { 
   vUpdate();
   tDateformatParam = tDateformat;
   return _s32Status;
}
tS32 dp_tclVDClockDpDateformat::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Dateformat", (tS32)0xad546cb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpDateformat::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpDateformat::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpDateformat::s32SetData(tU8 &tDateformatParam) {
   //init parameter
   (tVoid)memcpy(&tDateformat,(tVoid*)&tDateformatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDateformatParam' in function 'dp_tclVDClockDpDateformat::vSetData(tU8)' could be made const reference
tS32 dp_tclVDClockDpDateformat::s32SetData(const tU8 &tDateformatParam) {
   //init parameter
   (tVoid)memcpy(&tDateformat,(tVoid*)&tDateformatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDateformatParam' in function 'dp_tclVDClockDpDateformat::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpDateformat::u8GetData(tU8& tDateformatParam) {  
   vUpdate();
   tDateformatParam = tDateformat;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpDateformat::vSetData(tU8 &tDateformatParam) { 
   //init parameter
   (tVoid)memcpy(&tDateformat,(tVoid*)&tDateformatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDateformatParam' in function 'dp_tclVDClockDpDateformat::vSetData(tU8)' could be made const reference
tVoid dp_tclVDClockDpDateformat::vSetData(const tU8 &tDateformatParam) { 
   //init parameter
   (tVoid)memcpy(&tDateformat,(tVoid*)&tDateformatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDateformatParam' in function 'dp_tclVDClockDpDateformat::vSetData(tU8)' could be made const reference
tU8   dp_tclVDClockDpDateformat::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpDateformat::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Dateformat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDateformat::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Dateformat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDateformat::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Dateformat", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Dateformat has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Syncmode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpSyncmode::dp_tclVDClockDpSyncmode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSyncmode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpSyncmode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Syncmode",(tS32) 0x863dba);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSyncmode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpSyncmode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Syncmode", (tS32)0x863dba);
   (tVoid)myDpElem.bFillData((tVoid*)&tSyncmode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpSyncmode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpSyncmode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVDClockDpSyncmode::tGetData() {
   vUpdate();
   return tSyncmode;
};
tS32 dp_tclVDClockDpSyncmode::s32GetData(tU8& tSyncmodeParam) { 
   vUpdate();
   tSyncmodeParam = tSyncmode;
   return _s32Status;
}
tS32 dp_tclVDClockDpSyncmode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Syncmode", (tS32)0x863dba);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpSyncmode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpSyncmode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpSyncmode::s32SetData(tU8 &tSyncmodeParam) {
   //init parameter
   (tVoid)memcpy(&tSyncmode,(tVoid*)&tSyncmodeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSyncmodeParam' in function 'dp_tclVDClockDpSyncmode::vSetData(tU8)' could be made const reference
tS32 dp_tclVDClockDpSyncmode::s32SetData(const tU8 &tSyncmodeParam) {
   //init parameter
   (tVoid)memcpy(&tSyncmode,(tVoid*)&tSyncmodeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSyncmodeParam' in function 'dp_tclVDClockDpSyncmode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpSyncmode::u8GetData(tU8& tSyncmodeParam) {  
   vUpdate();
   tSyncmodeParam = tSyncmode;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpSyncmode::vSetData(tU8 &tSyncmodeParam) { 
   //init parameter
   (tVoid)memcpy(&tSyncmode,(tVoid*)&tSyncmodeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSyncmodeParam' in function 'dp_tclVDClockDpSyncmode::vSetData(tU8)' could be made const reference
tVoid dp_tclVDClockDpSyncmode::vSetData(const tU8 &tSyncmodeParam) { 
   //init parameter
   (tVoid)memcpy(&tSyncmode,(tVoid*)&tSyncmodeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSyncmodeParam' in function 'dp_tclVDClockDpSyncmode::vSetData(tU8)' could be made const reference
tU8   dp_tclVDClockDpSyncmode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpSyncmode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Syncmode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpSyncmode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Syncmode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpSyncmode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Syncmode", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Syncmode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "bInitialStartup"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpbInitialStartup::dp_tclVDClockDpbInitialStartup(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tbInitialStartup,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpbInitialStartup::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("bInitialStartup",(tS32) 0xc88d3d17);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tbInitialStartup = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpbInitialStartup::vStore(tVoid) {
   dp_tclBaseElement myDpElem("bInitialStartup", (tS32)0xc88d3d17);
   (tVoid)myDpElem.bFillData((tVoid*)&tbInitialStartup, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpbInitialStartup::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpbInitialStartup::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVDClockDpbInitialStartup::tGetData() {
   vUpdate();
   return tbInitialStartup;
};
tS32 dp_tclVDClockDpbInitialStartup::s32GetData(tBool& tbInitialStartupParam) { 
   vUpdate();
   tbInitialStartupParam = tbInitialStartup;
   return _s32Status;
}
tS32 dp_tclVDClockDpbInitialStartup::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("bInitialStartup", (tS32)0xc88d3d17);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpbInitialStartup::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpbInitialStartup::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpbInitialStartup::s32SetData(tBool &tbInitialStartupParam) {
   //init parameter
   (tVoid)memcpy(&tbInitialStartup,(tVoid*)&tbInitialStartupParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbInitialStartupParam' in function 'dp_tclVDClockDpbInitialStartup::vSetData(tBool)' could be made const reference
tS32 dp_tclVDClockDpbInitialStartup::s32SetData(const tBool &tbInitialStartupParam) {
   //init parameter
   (tVoid)memcpy(&tbInitialStartup,(tVoid*)&tbInitialStartupParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbInitialStartupParam' in function 'dp_tclVDClockDpbInitialStartup::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpbInitialStartup::u8GetData(tBool& tbInitialStartupParam) {  
   vUpdate();
   tbInitialStartupParam = tbInitialStartup;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpbInitialStartup::vSetData(tBool &tbInitialStartupParam) { 
   //init parameter
   (tVoid)memcpy(&tbInitialStartup,(tVoid*)&tbInitialStartupParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbInitialStartupParam' in function 'dp_tclVDClockDpbInitialStartup::vSetData(tBool)' could be made const reference
tVoid dp_tclVDClockDpbInitialStartup::vSetData(const tBool &tbInitialStartupParam) { 
   //init parameter
   (tVoid)memcpy(&tbInitialStartup,(tVoid*)&tbInitialStartupParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbInitialStartupParam' in function 'dp_tclVDClockDpbInitialStartup::vSetData(tBool)' could be made const reference
tU8   dp_tclVDClockDpbInitialStartup::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpbInitialStartup::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "bInitialStartup", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbInitialStartup::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "bInitialStartup", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbInitialStartup::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: bInitialStartup", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element bInitialStartup has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "bDefaultSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpbDefaultSetting::dp_tclVDClockDpbDefaultSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tbDefaultSetting,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpbDefaultSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("bDefaultSetting",(tS32) 0xc7af2b15);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tbDefaultSetting = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpbDefaultSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("bDefaultSetting", (tS32)0xc7af2b15);
   (tVoid)myDpElem.bFillData((tVoid*)&tbDefaultSetting, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpbDefaultSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpbDefaultSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVDClockDpbDefaultSetting::tGetData() {
   vUpdate();
   return tbDefaultSetting;
};
tS32 dp_tclVDClockDpbDefaultSetting::s32GetData(tBool& tbDefaultSettingParam) { 
   vUpdate();
   tbDefaultSettingParam = tbDefaultSetting;
   return _s32Status;
}
tS32 dp_tclVDClockDpbDefaultSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("bDefaultSetting", (tS32)0xc7af2b15);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpbDefaultSetting::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpbDefaultSetting::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpbDefaultSetting::s32SetData(tBool &tbDefaultSettingParam) {
   //init parameter
   (tVoid)memcpy(&tbDefaultSetting,(tVoid*)&tbDefaultSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbDefaultSettingParam' in function 'dp_tclVDClockDpbDefaultSetting::vSetData(tBool)' could be made const reference
tS32 dp_tclVDClockDpbDefaultSetting::s32SetData(const tBool &tbDefaultSettingParam) {
   //init parameter
   (tVoid)memcpy(&tbDefaultSetting,(tVoid*)&tbDefaultSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tbDefaultSettingParam' in function 'dp_tclVDClockDpbDefaultSetting::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpbDefaultSetting::u8GetData(tBool& tbDefaultSettingParam) {  
   vUpdate();
   tbDefaultSettingParam = tbDefaultSetting;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpbDefaultSetting::vSetData(tBool &tbDefaultSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tbDefaultSetting,(tVoid*)&tbDefaultSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbDefaultSettingParam' in function 'dp_tclVDClockDpbDefaultSetting::vSetData(tBool)' could be made const reference
tVoid dp_tclVDClockDpbDefaultSetting::vSetData(const tBool &tbDefaultSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tbDefaultSetting,(tVoid*)&tbDefaultSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tbDefaultSettingParam' in function 'dp_tclVDClockDpbDefaultSetting::vSetData(tBool)' could be made const reference
tU8   dp_tclVDClockDpbDefaultSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpbDefaultSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "bDefaultSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbDefaultSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "bDefaultSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpbDefaultSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: bDefaultSetting", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element bDefaultSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Offset_Hour"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpOffset_Hour::dp_tclVDClockDpOffset_Hour(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tOffset_Hour,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpOffset_Hour::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Offset_Hour",(tS32) 0x3ce3852c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tOffset_Hour = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpOffset_Hour::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Offset_Hour", (tS32)0x3ce3852c);
   (tVoid)myDpElem.bFillData((tVoid*)&tOffset_Hour, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpOffset_Hour::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpOffset_Hour::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpOffset_Hour::tGetData() {
   vUpdate();
   return tOffset_Hour;
};
tS32 dp_tclVDClockDpOffset_Hour::s32GetData(tS64& tOffset_HourParam) { 
   vUpdate();
   tOffset_HourParam = tOffset_Hour;
   return _s32Status;
}
tS32 dp_tclVDClockDpOffset_Hour::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Offset_Hour", (tS32)0x3ce3852c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpOffset_Hour::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpOffset_Hour::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpOffset_Hour::s32SetData(tS64 &tOffset_HourParam) {
   //init parameter
   (tVoid)memcpy(&tOffset_Hour,(tVoid*)&tOffset_HourParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOffset_HourParam' in function 'dp_tclVDClockDpOffset_Hour::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpOffset_Hour::s32SetData(const tS64 &tOffset_HourParam) {
   //init parameter
   (tVoid)memcpy(&tOffset_Hour,(tVoid*)&tOffset_HourParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOffset_HourParam' in function 'dp_tclVDClockDpOffset_Hour::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpOffset_Hour::u8GetData(tS64& tOffset_HourParam) {  
   vUpdate();
   tOffset_HourParam = tOffset_Hour;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpOffset_Hour::vSetData(tS64 &tOffset_HourParam) { 
   //init parameter
   (tVoid)memcpy(&tOffset_Hour,(tVoid*)&tOffset_HourParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tOffset_HourParam' in function 'dp_tclVDClockDpOffset_Hour::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpOffset_Hour::vSetData(const tS64 &tOffset_HourParam) { 
   //init parameter
   (tVoid)memcpy(&tOffset_Hour,(tVoid*)&tOffset_HourParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tOffset_HourParam' in function 'dp_tclVDClockDpOffset_Hour::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpOffset_Hour::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpOffset_Hour::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Offset_Hour", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpOffset_Hour::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Offset_Hour", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpOffset_Hour::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Offset_Hour", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Offset_Hour has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Offset_Minute"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpOffset_Minute::dp_tclVDClockDpOffset_Minute(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tOffset_Minute,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpOffset_Minute::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Offset_Minute",(tS32) 0xf2382f38);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tOffset_Minute = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpOffset_Minute::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Offset_Minute", (tS32)0xf2382f38);
   (tVoid)myDpElem.bFillData((tVoid*)&tOffset_Minute, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpOffset_Minute::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpOffset_Minute::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpOffset_Minute::tGetData() {
   vUpdate();
   return tOffset_Minute;
};
tS32 dp_tclVDClockDpOffset_Minute::s32GetData(tS64& tOffset_MinuteParam) { 
   vUpdate();
   tOffset_MinuteParam = tOffset_Minute;
   return _s32Status;
}
tS32 dp_tclVDClockDpOffset_Minute::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Offset_Minute", (tS32)0xf2382f38);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpOffset_Minute::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpOffset_Minute::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpOffset_Minute::s32SetData(tS64 &tOffset_MinuteParam) {
   //init parameter
   (tVoid)memcpy(&tOffset_Minute,(tVoid*)&tOffset_MinuteParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOffset_MinuteParam' in function 'dp_tclVDClockDpOffset_Minute::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpOffset_Minute::s32SetData(const tS64 &tOffset_MinuteParam) {
   //init parameter
   (tVoid)memcpy(&tOffset_Minute,(tVoid*)&tOffset_MinuteParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOffset_MinuteParam' in function 'dp_tclVDClockDpOffset_Minute::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpOffset_Minute::u8GetData(tS64& tOffset_MinuteParam) {  
   vUpdate();
   tOffset_MinuteParam = tOffset_Minute;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpOffset_Minute::vSetData(tS64 &tOffset_MinuteParam) { 
   //init parameter
   (tVoid)memcpy(&tOffset_Minute,(tVoid*)&tOffset_MinuteParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tOffset_MinuteParam' in function 'dp_tclVDClockDpOffset_Minute::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpOffset_Minute::vSetData(const tS64 &tOffset_MinuteParam) { 
   //init parameter
   (tVoid)memcpy(&tOffset_Minute,(tVoid*)&tOffset_MinuteParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tOffset_MinuteParam' in function 'dp_tclVDClockDpOffset_Minute::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpOffset_Minute::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpOffset_Minute::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Offset_Minute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpOffset_Minute::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Offset_Minute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpOffset_Minute::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Offset_Minute", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Offset_Minute has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Domain_AutoOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpDomain_AutoOffset::dp_tclVDClockDpDomain_AutoOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDomain_AutoOffset,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpDomain_AutoOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Domain_AutoOffset",(tS32) 0x7e36aa43);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tDomain_AutoOffset = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpDomain_AutoOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Domain_AutoOffset", (tS32)0x7e36aa43);
   (tVoid)myDpElem.bFillData((tVoid*)&tDomain_AutoOffset, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpDomain_AutoOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpDomain_AutoOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpDomain_AutoOffset::tGetData() {
   vUpdate();
   return tDomain_AutoOffset;
};
tS32 dp_tclVDClockDpDomain_AutoOffset::s32GetData(tS64& tDomain_AutoOffsetParam) { 
   vUpdate();
   tDomain_AutoOffsetParam = tDomain_AutoOffset;
   return _s32Status;
}
tS32 dp_tclVDClockDpDomain_AutoOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Domain_AutoOffset", (tS32)0x7e36aa43);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpDomain_AutoOffset::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpDomain_AutoOffset::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpDomain_AutoOffset::s32SetData(tS64 &tDomain_AutoOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDomain_AutoOffset,(tVoid*)&tDomain_AutoOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDomain_AutoOffsetParam' in function 'dp_tclVDClockDpDomain_AutoOffset::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpDomain_AutoOffset::s32SetData(const tS64 &tDomain_AutoOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDomain_AutoOffset,(tVoid*)&tDomain_AutoOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDomain_AutoOffsetParam' in function 'dp_tclVDClockDpDomain_AutoOffset::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpDomain_AutoOffset::u8GetData(tS64& tDomain_AutoOffsetParam) {  
   vUpdate();
   tDomain_AutoOffsetParam = tDomain_AutoOffset;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpDomain_AutoOffset::vSetData(tS64 &tDomain_AutoOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDomain_AutoOffset,(tVoid*)&tDomain_AutoOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tDomain_AutoOffsetParam' in function 'dp_tclVDClockDpDomain_AutoOffset::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpDomain_AutoOffset::vSetData(const tS64 &tDomain_AutoOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDomain_AutoOffset,(tVoid*)&tDomain_AutoOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tDomain_AutoOffsetParam' in function 'dp_tclVDClockDpDomain_AutoOffset::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpDomain_AutoOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpDomain_AutoOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Domain_AutoOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDomain_AutoOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Domain_AutoOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDomain_AutoOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Domain_AutoOffset", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Domain_AutoOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Domain_ManualOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpDomain_ManualOffset::dp_tclVDClockDpDomain_ManualOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDomain_ManualOffset,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpDomain_ManualOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Domain_ManualOffset",(tS32) 0x6a25b80c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tDomain_ManualOffset = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpDomain_ManualOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Domain_ManualOffset", (tS32)0x6a25b80c);
   (tVoid)myDpElem.bFillData((tVoid*)&tDomain_ManualOffset, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpDomain_ManualOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpDomain_ManualOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpDomain_ManualOffset::tGetData() {
   vUpdate();
   return tDomain_ManualOffset;
};
tS32 dp_tclVDClockDpDomain_ManualOffset::s32GetData(tS64& tDomain_ManualOffsetParam) { 
   vUpdate();
   tDomain_ManualOffsetParam = tDomain_ManualOffset;
   return _s32Status;
}
tS32 dp_tclVDClockDpDomain_ManualOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Domain_ManualOffset", (tS32)0x6a25b80c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpDomain_ManualOffset::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpDomain_ManualOffset::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpDomain_ManualOffset::s32SetData(tS64 &tDomain_ManualOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDomain_ManualOffset,(tVoid*)&tDomain_ManualOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDomain_ManualOffsetParam' in function 'dp_tclVDClockDpDomain_ManualOffset::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpDomain_ManualOffset::s32SetData(const tS64 &tDomain_ManualOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDomain_ManualOffset,(tVoid*)&tDomain_ManualOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDomain_ManualOffsetParam' in function 'dp_tclVDClockDpDomain_ManualOffset::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpDomain_ManualOffset::u8GetData(tS64& tDomain_ManualOffsetParam) {  
   vUpdate();
   tDomain_ManualOffsetParam = tDomain_ManualOffset;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpDomain_ManualOffset::vSetData(tS64 &tDomain_ManualOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDomain_ManualOffset,(tVoid*)&tDomain_ManualOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tDomain_ManualOffsetParam' in function 'dp_tclVDClockDpDomain_ManualOffset::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpDomain_ManualOffset::vSetData(const tS64 &tDomain_ManualOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDomain_ManualOffset,(tVoid*)&tDomain_ManualOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tDomain_ManualOffsetParam' in function 'dp_tclVDClockDpDomain_ManualOffset::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpDomain_ManualOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpDomain_ManualOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Domain_ManualOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDomain_ManualOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Domain_ManualOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDomain_ManualOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Domain_ManualOffset", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Domain_ManualOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Domain_TZOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpDomain_TZOffset::dp_tclVDClockDpDomain_TZOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDomain_TZOffset,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpDomain_TZOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Domain_TZOffset",(tS32) 0xc7aa3284);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tDomain_TZOffset = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpDomain_TZOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Domain_TZOffset", (tS32)0xc7aa3284);
   (tVoid)myDpElem.bFillData((tVoid*)&tDomain_TZOffset, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpDomain_TZOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpDomain_TZOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpDomain_TZOffset::tGetData() {
   vUpdate();
   return tDomain_TZOffset;
};
tS32 dp_tclVDClockDpDomain_TZOffset::s32GetData(tS64& tDomain_TZOffsetParam) { 
   vUpdate();
   tDomain_TZOffsetParam = tDomain_TZOffset;
   return _s32Status;
}
tS32 dp_tclVDClockDpDomain_TZOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Domain_TZOffset", (tS32)0xc7aa3284);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpDomain_TZOffset::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpDomain_TZOffset::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpDomain_TZOffset::s32SetData(tS64 &tDomain_TZOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDomain_TZOffset,(tVoid*)&tDomain_TZOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDomain_TZOffsetParam' in function 'dp_tclVDClockDpDomain_TZOffset::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpDomain_TZOffset::s32SetData(const tS64 &tDomain_TZOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDomain_TZOffset,(tVoid*)&tDomain_TZOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDomain_TZOffsetParam' in function 'dp_tclVDClockDpDomain_TZOffset::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpDomain_TZOffset::u8GetData(tS64& tDomain_TZOffsetParam) {  
   vUpdate();
   tDomain_TZOffsetParam = tDomain_TZOffset;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpDomain_TZOffset::vSetData(tS64 &tDomain_TZOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDomain_TZOffset,(tVoid*)&tDomain_TZOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tDomain_TZOffsetParam' in function 'dp_tclVDClockDpDomain_TZOffset::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpDomain_TZOffset::vSetData(const tS64 &tDomain_TZOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDomain_TZOffset,(tVoid*)&tDomain_TZOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tDomain_TZOffsetParam' in function 'dp_tclVDClockDpDomain_TZOffset::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpDomain_TZOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpDomain_TZOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "Domain_TZOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDomain_TZOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "Domain_TZOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpDomain_TZOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Domain_TZOffset", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element Domain_TZOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AutoTZOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVDClockDpAutoTZOffset::dp_tclVDClockDpAutoTZOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAutoTZOffset,0,sizeof(tS64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVDClockDpAutoTZOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AutoTZOffset",(tS32) 0x11dc6502);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS64)) 
      {
         tAutoTZOffset = *((tS64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVDClockDpAutoTZOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AutoTZOffset", (tS32)0x11dc6502);
   (tVoid)myDpElem.bFillData((tVoid*)&tAutoTZOffset, (tU32)sizeof(tS64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVDClockDpAutoTZOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVDClockDpAutoTZOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS64 dp_tclVDClockDpAutoTZOffset::tGetData() {
   vUpdate();
   return tAutoTZOffset;
};
tS32 dp_tclVDClockDpAutoTZOffset::s32GetData(tS64& tAutoTZOffsetParam) { 
   vUpdate();
   tAutoTZOffsetParam = tAutoTZOffset;
   return _s32Status;
}
tS32 dp_tclVDClockDpAutoTZOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AutoTZOffset", (tS32)0x11dc6502);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VDCLOCKDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVDClockDpAutoTZOffset::operator>>(tS64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVDClockDpAutoTZOffset::operator<<(tS64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVDClockDpAutoTZOffset::s32SetData(tS64 &tAutoTZOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tAutoTZOffset,(tVoid*)&tAutoTZOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutoTZOffsetParam' in function 'dp_tclVDClockDpAutoTZOffset::vSetData(tS64)' could be made const reference
tS32 dp_tclVDClockDpAutoTZOffset::s32SetData(const tS64 &tAutoTZOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tAutoTZOffset,(tVoid*)&tAutoTZOffsetParam, sizeof(tS64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutoTZOffsetParam' in function 'dp_tclVDClockDpAutoTZOffset::vSetData(tS64)' could be made const reference
// do not use --> old interface
tU8 dp_tclVDClockDpAutoTZOffset::u8GetData(tS64& tAutoTZOffsetParam) {  
   vUpdate();
   tAutoTZOffsetParam = tAutoTZOffset;
   return _u8DataStatus;
}
tVoid dp_tclVDClockDpAutoTZOffset::vSetData(tS64 &tAutoTZOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tAutoTZOffset,(tVoid*)&tAutoTZOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tAutoTZOffsetParam' in function 'dp_tclVDClockDpAutoTZOffset::vSetData(tS64)' could be made const reference
tVoid dp_tclVDClockDpAutoTZOffset::vSetData(const tS64 &tAutoTZOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tAutoTZOffset,(tVoid*)&tAutoTZOffsetParam, sizeof(tS64));
   vStore();
}//lint !e1746: parameter 'tAutoTZOffsetParam' in function 'dp_tclVDClockDpAutoTZOffset::vSetData(tS64)' could be made const reference
tU8   dp_tclVDClockDpAutoTZOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVDClockDpAutoTZOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VDCLOCKDP, "AutoTZOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpAutoTZOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VDCLOCKDP, "AutoTZOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVDClockDpAutoTZOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AutoTZOffset", DP_U32_POOL_ID_VDCLOCKDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VDCLOCKDP);
   }
   else
   {
      fprintf(stdout,"Element AutoTZOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
