#ifndef _DP_FI_PROFILEDATA_H
#define _DP_FI_PROFILEDATA_H

extern tVoid vInitprofileData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclprofileDataaccountNames{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclprofileDataaccountNames(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDataaccountNames() {};

   //read access for pool element 
   tS32  s32GetData(tU8* taccountNamesParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* taccountNamesParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* taccountNamesParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclprofileDataaccountNamesLength{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 taccountNamesLength;
   
public:
   dp_tclprofileDataaccountNamesLength(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDataaccountNamesLength() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& taccountNamesLengthParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &taccountNamesLengthParam);
   tS32  s32SetData(const tU32 &taccountNamesLengthParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& taccountNamesLengthParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& taccountNamesLengthParam);
   tVoid vSetData(const tU32& taccountNamesLengthParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileDataKID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclprofileDataKID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDataKID() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tKIDParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tKIDParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tKIDParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclprofileDataKIDLength{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tKIDLength;
   
public:
   dp_tclprofileDataKIDLength(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDataKIDLength() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tKIDLengthParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tKIDLengthParam);
   tS32  s32SetData(const tU32 &tKIDLengthParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tKIDLengthParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tKIDLengthParam);
   tVoid vSetData(const tU32& tKIDLengthParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileDatalocalLinkOrderTimeout{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tlocalLinkOrderTimeout;
   
public:
   dp_tclprofileDatalocalLinkOrderTimeout(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDatalocalLinkOrderTimeout() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tlocalLinkOrderTimeoutParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tlocalLinkOrderTimeoutParam);
   tS32  s32SetData(const tU32 &tlocalLinkOrderTimeoutParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tlocalLinkOrderTimeoutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tlocalLinkOrderTimeoutParam);
   tVoid vSetData(const tU32& tlocalLinkOrderTimeoutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileDatamaxSecuredProfiles{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tmaxSecuredProfiles;
   
public:
   dp_tclprofileDatamaxSecuredProfiles(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDatamaxSecuredProfiles() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tmaxSecuredProfilesParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tmaxSecuredProfilesParam);
   tS32  s32SetData(const tU8 &tmaxSecuredProfilesParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tmaxSecuredProfilesParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tmaxSecuredProfilesParam);
   tVoid vSetData(const tU8& tmaxSecuredProfilesParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileDataremoteVehicleSettingsActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   bool tremoteVehicleSettingsActivation;
   
public:
   dp_tclprofileDataremoteVehicleSettingsActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileDataremoteVehicleSettingsActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   bool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(bool& tremoteVehicleSettingsActivationParam);
   tVoid operator>>(bool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(bool &tremoteVehicleSettingsActivationParam);
   tS32  s32SetData(const bool &tremoteVehicleSettingsActivationParam);
   tVoid operator<<(bool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(bool& tremoteVehicleSettingsActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(bool& tremoteVehicleSettingsActivationParam);
   tVoid vSetData(const bool& tremoteVehicleSettingsActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
