
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclprofileData.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "accountNames"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDataaccountNames::dp_tclprofileDataaccountNames(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclprofileDataaccountNames::s32SetData( tU8* taccountNamesParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("accountNames", (tS32)0x62b708f5);
   (tVoid)myDpElem.bFillData((tVoid*)taccountNamesParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclprofileDataaccountNames::s32GetData(tU8* taccountNamesParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("accountNames", (tS32)0x62b708f5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)taccountNamesParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclprofileDataaccountNames::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclprofileDataaccountNames::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclprofileDataaccountNames::u16GetData(tU8* taccountNamesParam, tU32 u32ArraySize){
       return (tU16) s32GetData(taccountNamesParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclprofileDataaccountNames::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "accountNames", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclprofileDataaccountNames::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "accountNames", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclprofileDataaccountNames::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: accountNames", DP_U32_POOL_ID_PROFILEDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
		}
		else
		{
			fprintf(stdout,"Element accountNames has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "accountNamesLength"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDataaccountNamesLength::dp_tclprofileDataaccountNamesLength(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&taccountNamesLength,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileDataaccountNamesLength::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("accountNamesLength",(tS32) 0x15968a5f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         taccountNamesLength = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileDataaccountNamesLength::vStore(tVoid) {
   dp_tclBaseElement myDpElem("accountNamesLength", (tS32)0x15968a5f);
   (tVoid)myDpElem.bFillData((tVoid*)&taccountNamesLength, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileDataaccountNamesLength::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileDataaccountNamesLength::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileDataaccountNamesLength::tGetData() {
   vUpdate();
   return taccountNamesLength;
};
tS32 dp_tclprofileDataaccountNamesLength::s32GetData(tU32& taccountNamesLengthParam) { 
   vUpdate();
   taccountNamesLengthParam = taccountNamesLength;
   return _s32Status;
}
tS32 dp_tclprofileDataaccountNamesLength::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("accountNamesLength", (tS32)0x15968a5f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileDataaccountNamesLength::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileDataaccountNamesLength::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileDataaccountNamesLength::s32SetData(tU32 &taccountNamesLengthParam) {
   //init parameter
   (tVoid)memcpy(&taccountNamesLength,(tVoid*)&taccountNamesLengthParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'taccountNamesLengthParam' in function 'dp_tclprofileDataaccountNamesLength::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileDataaccountNamesLength::s32SetData(const tU32 &taccountNamesLengthParam) {
   //init parameter
   (tVoid)memcpy(&taccountNamesLength,(tVoid*)&taccountNamesLengthParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'taccountNamesLengthParam' in function 'dp_tclprofileDataaccountNamesLength::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileDataaccountNamesLength::u8GetData(tU32& taccountNamesLengthParam) {  
   vUpdate();
   taccountNamesLengthParam = taccountNamesLength;
   return _u8DataStatus;
}
tVoid dp_tclprofileDataaccountNamesLength::vSetData(tU32 &taccountNamesLengthParam) { 
   //init parameter
   (tVoid)memcpy(&taccountNamesLength,(tVoid*)&taccountNamesLengthParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'taccountNamesLengthParam' in function 'dp_tclprofileDataaccountNamesLength::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileDataaccountNamesLength::vSetData(const tU32 &taccountNamesLengthParam) { 
   //init parameter
   (tVoid)memcpy(&taccountNamesLength,(tVoid*)&taccountNamesLengthParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'taccountNamesLengthParam' in function 'dp_tclprofileDataaccountNamesLength::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileDataaccountNamesLength::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileDataaccountNamesLength::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "accountNamesLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDataaccountNamesLength::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "accountNamesLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDataaccountNamesLength::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: accountNamesLength", DP_U32_POOL_ID_PROFILEDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
   }
   else
   {
      fprintf(stdout,"Element accountNamesLength has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDataKID::dp_tclprofileDataKID(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclprofileDataKID::s32SetData( tU8* tKIDParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("KID", (tS32)0x904);
   (tVoid)myDpElem.bFillData((tVoid*)tKIDParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclprofileDataKID::s32GetData(tU8* tKIDParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("KID", (tS32)0x904);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tKIDParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclprofileDataKID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclprofileDataKID::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclprofileDataKID::u16GetData(tU8* tKIDParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tKIDParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclprofileDataKID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "KID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclprofileDataKID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "KID", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclprofileDataKID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KID", DP_U32_POOL_ID_PROFILEDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
		}
		else
		{
			fprintf(stdout,"Element KID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KIDLength"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDataKIDLength::dp_tclprofileDataKIDLength(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tKIDLength,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileDataKIDLength::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("KIDLength",(tS32) 0x22b1de6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tKIDLength = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileDataKIDLength::vStore(tVoid) {
   dp_tclBaseElement myDpElem("KIDLength", (tS32)0x22b1de6);
   (tVoid)myDpElem.bFillData((tVoid*)&tKIDLength, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileDataKIDLength::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileDataKIDLength::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileDataKIDLength::tGetData() {
   vUpdate();
   return tKIDLength;
};
tS32 dp_tclprofileDataKIDLength::s32GetData(tU32& tKIDLengthParam) { 
   vUpdate();
   tKIDLengthParam = tKIDLength;
   return _s32Status;
}
tS32 dp_tclprofileDataKIDLength::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("KIDLength", (tS32)0x22b1de6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileDataKIDLength::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileDataKIDLength::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileDataKIDLength::s32SetData(tU32 &tKIDLengthParam) {
   //init parameter
   (tVoid)memcpy(&tKIDLength,(tVoid*)&tKIDLengthParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKIDLengthParam' in function 'dp_tclprofileDataKIDLength::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileDataKIDLength::s32SetData(const tU32 &tKIDLengthParam) {
   //init parameter
   (tVoid)memcpy(&tKIDLength,(tVoid*)&tKIDLengthParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKIDLengthParam' in function 'dp_tclprofileDataKIDLength::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileDataKIDLength::u8GetData(tU32& tKIDLengthParam) {  
   vUpdate();
   tKIDLengthParam = tKIDLength;
   return _u8DataStatus;
}
tVoid dp_tclprofileDataKIDLength::vSetData(tU32 &tKIDLengthParam) { 
   //init parameter
   (tVoid)memcpy(&tKIDLength,(tVoid*)&tKIDLengthParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tKIDLengthParam' in function 'dp_tclprofileDataKIDLength::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileDataKIDLength::vSetData(const tU32 &tKIDLengthParam) { 
   //init parameter
   (tVoid)memcpy(&tKIDLength,(tVoid*)&tKIDLengthParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tKIDLengthParam' in function 'dp_tclprofileDataKIDLength::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileDataKIDLength::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileDataKIDLength::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "KIDLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDataKIDLength::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "KIDLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDataKIDLength::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KIDLength", DP_U32_POOL_ID_PROFILEDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
   }
   else
   {
      fprintf(stdout,"Element KIDLength has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "localLinkOrderTimeout"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDatalocalLinkOrderTimeout::dp_tclprofileDatalocalLinkOrderTimeout(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tlocalLinkOrderTimeout,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileDatalocalLinkOrderTimeout::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("localLinkOrderTimeout",(tS32) 0xcc809974);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tlocalLinkOrderTimeout = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileDatalocalLinkOrderTimeout::vStore(tVoid) {
   dp_tclBaseElement myDpElem("localLinkOrderTimeout", (tS32)0xcc809974);
   (tVoid)myDpElem.bFillData((tVoid*)&tlocalLinkOrderTimeout, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileDatalocalLinkOrderTimeout::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileDatalocalLinkOrderTimeout::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileDatalocalLinkOrderTimeout::tGetData() {
   vUpdate();
   return tlocalLinkOrderTimeout;
};
tS32 dp_tclprofileDatalocalLinkOrderTimeout::s32GetData(tU32& tlocalLinkOrderTimeoutParam) { 
   vUpdate();
   tlocalLinkOrderTimeoutParam = tlocalLinkOrderTimeout;
   return _s32Status;
}
tS32 dp_tclprofileDatalocalLinkOrderTimeout::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("localLinkOrderTimeout", (tS32)0xcc809974);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileDatalocalLinkOrderTimeout::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileDatalocalLinkOrderTimeout::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileDatalocalLinkOrderTimeout::s32SetData(tU32 &tlocalLinkOrderTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tlocalLinkOrderTimeout,(tVoid*)&tlocalLinkOrderTimeoutParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tlocalLinkOrderTimeoutParam' in function 'dp_tclprofileDatalocalLinkOrderTimeout::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileDatalocalLinkOrderTimeout::s32SetData(const tU32 &tlocalLinkOrderTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tlocalLinkOrderTimeout,(tVoid*)&tlocalLinkOrderTimeoutParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tlocalLinkOrderTimeoutParam' in function 'dp_tclprofileDatalocalLinkOrderTimeout::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileDatalocalLinkOrderTimeout::u8GetData(tU32& tlocalLinkOrderTimeoutParam) {  
   vUpdate();
   tlocalLinkOrderTimeoutParam = tlocalLinkOrderTimeout;
   return _u8DataStatus;
}
tVoid dp_tclprofileDatalocalLinkOrderTimeout::vSetData(tU32 &tlocalLinkOrderTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tlocalLinkOrderTimeout,(tVoid*)&tlocalLinkOrderTimeoutParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tlocalLinkOrderTimeoutParam' in function 'dp_tclprofileDatalocalLinkOrderTimeout::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileDatalocalLinkOrderTimeout::vSetData(const tU32 &tlocalLinkOrderTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tlocalLinkOrderTimeout,(tVoid*)&tlocalLinkOrderTimeoutParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tlocalLinkOrderTimeoutParam' in function 'dp_tclprofileDatalocalLinkOrderTimeout::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileDatalocalLinkOrderTimeout::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileDatalocalLinkOrderTimeout::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "localLinkOrderTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDatalocalLinkOrderTimeout::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "localLinkOrderTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDatalocalLinkOrderTimeout::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: localLinkOrderTimeout", DP_U32_POOL_ID_PROFILEDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
   }
   else
   {
      fprintf(stdout,"Element localLinkOrderTimeout has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "maxSecuredProfiles"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDatamaxSecuredProfiles::dp_tclprofileDatamaxSecuredProfiles(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tmaxSecuredProfiles,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileDatamaxSecuredProfiles::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("maxSecuredProfiles",(tS32) 0xc1b4b1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tmaxSecuredProfiles = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileDatamaxSecuredProfiles::vStore(tVoid) {
   dp_tclBaseElement myDpElem("maxSecuredProfiles", (tS32)0xc1b4b1);
   (tVoid)myDpElem.bFillData((tVoid*)&tmaxSecuredProfiles, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileDatamaxSecuredProfiles::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileDatamaxSecuredProfiles::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclprofileDatamaxSecuredProfiles::tGetData() {
   vUpdate();
   return tmaxSecuredProfiles;
};
tS32 dp_tclprofileDatamaxSecuredProfiles::s32GetData(tU8& tmaxSecuredProfilesParam) { 
   vUpdate();
   tmaxSecuredProfilesParam = tmaxSecuredProfiles;
   return _s32Status;
}
tS32 dp_tclprofileDatamaxSecuredProfiles::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("maxSecuredProfiles", (tS32)0xc1b4b1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileDatamaxSecuredProfiles::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileDatamaxSecuredProfiles::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileDatamaxSecuredProfiles::s32SetData(tU8 &tmaxSecuredProfilesParam) {
   //init parameter
   (tVoid)memcpy(&tmaxSecuredProfiles,(tVoid*)&tmaxSecuredProfilesParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tmaxSecuredProfilesParam' in function 'dp_tclprofileDatamaxSecuredProfiles::vSetData(tU8)' could be made const reference
tS32 dp_tclprofileDatamaxSecuredProfiles::s32SetData(const tU8 &tmaxSecuredProfilesParam) {
   //init parameter
   (tVoid)memcpy(&tmaxSecuredProfiles,(tVoid*)&tmaxSecuredProfilesParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tmaxSecuredProfilesParam' in function 'dp_tclprofileDatamaxSecuredProfiles::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileDatamaxSecuredProfiles::u8GetData(tU8& tmaxSecuredProfilesParam) {  
   vUpdate();
   tmaxSecuredProfilesParam = tmaxSecuredProfiles;
   return _u8DataStatus;
}
tVoid dp_tclprofileDatamaxSecuredProfiles::vSetData(tU8 &tmaxSecuredProfilesParam) { 
   //init parameter
   (tVoid)memcpy(&tmaxSecuredProfiles,(tVoid*)&tmaxSecuredProfilesParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tmaxSecuredProfilesParam' in function 'dp_tclprofileDatamaxSecuredProfiles::vSetData(tU8)' could be made const reference
tVoid dp_tclprofileDatamaxSecuredProfiles::vSetData(const tU8 &tmaxSecuredProfilesParam) { 
   //init parameter
   (tVoid)memcpy(&tmaxSecuredProfiles,(tVoid*)&tmaxSecuredProfilesParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tmaxSecuredProfilesParam' in function 'dp_tclprofileDatamaxSecuredProfiles::vSetData(tU8)' could be made const reference
tU8   dp_tclprofileDatamaxSecuredProfiles::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileDatamaxSecuredProfiles::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "maxSecuredProfiles", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDatamaxSecuredProfiles::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "maxSecuredProfiles", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDatamaxSecuredProfiles::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: maxSecuredProfiles", DP_U32_POOL_ID_PROFILEDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
   }
   else
   {
      fprintf(stdout,"Element maxSecuredProfiles has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "remoteVehicleSettingsActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileDataremoteVehicleSettingsActivation::dp_tclprofileDataremoteVehicleSettingsActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tremoteVehicleSettingsActivation,0,sizeof(bool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileDataremoteVehicleSettingsActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("remoteVehicleSettingsActivation",(tS32) 0x2a298037L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(bool)) 
      {
         tremoteVehicleSettingsActivation = *((bool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileDataremoteVehicleSettingsActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("remoteVehicleSettingsActivation", (tS32)0x2a298037L);
   (tVoid)myDpElem.bFillData((tVoid*)&tremoteVehicleSettingsActivation, (tU32)sizeof(bool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileDataremoteVehicleSettingsActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileDataremoteVehicleSettingsActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
bool dp_tclprofileDataremoteVehicleSettingsActivation::tGetData() {
   vUpdate();
   return tremoteVehicleSettingsActivation;
};
tS32 dp_tclprofileDataremoteVehicleSettingsActivation::s32GetData(bool& tremoteVehicleSettingsActivationParam) { 
   vUpdate();
   tremoteVehicleSettingsActivationParam = tremoteVehicleSettingsActivation;
   return _s32Status;
}
tS32 dp_tclprofileDataremoteVehicleSettingsActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("remoteVehicleSettingsActivation", (tS32)0x2a298037L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileDataremoteVehicleSettingsActivation::operator>>(bool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileDataremoteVehicleSettingsActivation::operator<<(bool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileDataremoteVehicleSettingsActivation::s32SetData(bool &tremoteVehicleSettingsActivationParam) {
   //init parameter
   (tVoid)memcpy(&tremoteVehicleSettingsActivation,(tVoid*)&tremoteVehicleSettingsActivationParam, sizeof(bool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tremoteVehicleSettingsActivationParam' in function 'dp_tclprofileDataremoteVehicleSettingsActivation::vSetData(bool)' could be made const reference
tS32 dp_tclprofileDataremoteVehicleSettingsActivation::s32SetData(const bool &tremoteVehicleSettingsActivationParam) {
   //init parameter
   (tVoid)memcpy(&tremoteVehicleSettingsActivation,(tVoid*)&tremoteVehicleSettingsActivationParam, sizeof(bool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tremoteVehicleSettingsActivationParam' in function 'dp_tclprofileDataremoteVehicleSettingsActivation::vSetData(bool)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileDataremoteVehicleSettingsActivation::u8GetData(bool& tremoteVehicleSettingsActivationParam) {  
   vUpdate();
   tremoteVehicleSettingsActivationParam = tremoteVehicleSettingsActivation;
   return _u8DataStatus;
}
tVoid dp_tclprofileDataremoteVehicleSettingsActivation::vSetData(bool &tremoteVehicleSettingsActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tremoteVehicleSettingsActivation,(tVoid*)&tremoteVehicleSettingsActivationParam, sizeof(bool));
   vStore();
}//lint !e1746: parameter 'tremoteVehicleSettingsActivationParam' in function 'dp_tclprofileDataremoteVehicleSettingsActivation::vSetData(bool)' could be made const reference
tVoid dp_tclprofileDataremoteVehicleSettingsActivation::vSetData(const bool &tremoteVehicleSettingsActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tremoteVehicleSettingsActivation,(tVoid*)&tremoteVehicleSettingsActivationParam, sizeof(bool));
   vStore();
}//lint !e1746: parameter 'tremoteVehicleSettingsActivationParam' in function 'dp_tclprofileDataremoteVehicleSettingsActivation::vSetData(bool)' could be made const reference
tU8   dp_tclprofileDataremoteVehicleSettingsActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileDataremoteVehicleSettingsActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEDATA, "remoteVehicleSettingsActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDataremoteVehicleSettingsActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEDATA, "remoteVehicleSettingsActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileDataremoteVehicleSettingsActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: remoteVehicleSettingsActivation", DP_U32_POOL_ID_PROFILEDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEDATA);
   }
   else
   {
      fprintf(stdout,"Element remoteVehicleSettingsActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
