#ifndef _DP_FI_TMCTUNERDP_H
#define _DP_FI_TMCTUNERDP_H

extern tVoid vInitTmcTunerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclTmcTunerDPADRConfigCRC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tADRConfigCRC;
   
public:
   dp_tclTmcTunerDPADRConfigCRC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPADRConfigCRC() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tADRConfigCRCParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tADRConfigCRCParam);
   tS32  s32SetData(const tU32 &tADRConfigCRCParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tADRConfigCRCParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tADRConfigCRCParam);
   tVoid vSetData(const tU32& tADRConfigCRCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPKDSConfigCRC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tKDSConfigCRC;
   
public:
   dp_tclTmcTunerDPKDSConfigCRC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPKDSConfigCRC() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tKDSConfigCRCParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tKDSConfigCRCParam);
   tS32  s32SetData(const tU32 &tKDSConfigCRCParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tKDSConfigCRCParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tKDSConfigCRCParam);
   tVoid vSetData(const tU32& tKDSConfigCRCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPCurrentDate{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclTmcTunerDPCurrentDate(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPCurrentDate() {};

   //read access for pool element 
   tS32  s32GetData(tString &tCurrentDateParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tCurrentDateParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tCurrentDateParam);
   tS32 s32SetData(const tString &tCurrentDateParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tCurrentDateParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tCurrentDateParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tCurrentDateParam);
   tVoid vSetData(const tString &tCurrentDateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPAdrConfigCheckSum{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdrConfigCheckSum;
   
public:
   dp_tclTmcTunerDPAdrConfigCheckSum(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPAdrConfigCheckSum() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdrConfigCheckSumParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdrConfigCheckSumParam);
   tS32  s32SetData(const tU8 &tAdrConfigCheckSumParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdrConfigCheckSumParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdrConfigCheckSumParam);
   tVoid vSetData(const tU8& tAdrConfigCheckSumParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPAdrConfigCRC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tAdrConfigCRC;
   
public:
   dp_tclTmcTunerDPAdrConfigCRC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPAdrConfigCRC() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tAdrConfigCRCParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tAdrConfigCRCParam);
   tS32  s32SetData(const tU32 &tAdrConfigCRCParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tAdrConfigCRCParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tAdrConfigCRCParam);
   tVoid vSetData(const tU32& tAdrConfigCRCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPHWConfigCRC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tHWConfigCRC;
   
public:
   dp_tclTmcTunerDPHWConfigCRC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPHWConfigCRC() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tHWConfigCRCParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tHWConfigCRCParam);
   tS32  s32SetData(const tU8 &tHWConfigCRCParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tHWConfigCRCParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tHWConfigCRCParam);
   tVoid vSetData(const tU8& tHWConfigCRCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPConfigVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclTmcTunerDPConfigVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPConfigVersion() {};

   //read access for pool element 
   tS32  s32GetData(tString &tConfigVersionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tConfigVersionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tConfigVersionParam);
   tS32 s32SetData(const tString &tConfigVersionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tConfigVersionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tConfigVersionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tConfigVersionParam);
   tVoid vSetData(const tString &tConfigVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPVersionIdIsUpdated{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tVersionIdIsUpdated;
   
public:
   dp_tclTmcTunerDPVersionIdIsUpdated(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPVersionIdIsUpdated() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tVersionIdIsUpdatedParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tVersionIdIsUpdatedParam);
   tS32  s32SetData(const tBool &tVersionIdIsUpdatedParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tVersionIdIsUpdatedParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tVersionIdIsUpdatedParam);
   tVoid vSetData(const tBool& tVersionIdIsUpdatedParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPPresetListID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPresetListID;
   
public:
   dp_tclTmcTunerDPPresetListID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPPresetListID() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPresetListIDParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPresetListIDParam);
   tS32  s32SetData(const tU16 &tPresetListIDParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPresetListIDParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPresetListIDParam);
   tVoid vSetData(const tU16& tPresetListIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPManualJapanAreaCode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tManualJapanAreaCode;
   
public:
   dp_tclTmcTunerDPManualJapanAreaCode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPManualJapanAreaCode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tManualJapanAreaCodeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tManualJapanAreaCodeParam);
   tS32  s32SetData(const tU8 &tManualJapanAreaCodeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tManualJapanAreaCodeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tManualJapanAreaCodeParam);
   tVoid vSetData(const tU8& tManualJapanAreaCodeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPAutomaticJapanAreaCode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAutomaticJapanAreaCode;
   
public:
   dp_tclTmcTunerDPAutomaticJapanAreaCode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPAutomaticJapanAreaCode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAutomaticJapanAreaCodeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAutomaticJapanAreaCodeParam);
   tS32  s32SetData(const tU8 &tAutomaticJapanAreaCodeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAutomaticJapanAreaCodeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAutomaticJapanAreaCodeParam);
   tVoid vSetData(const tU8& tAutomaticJapanAreaCodeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPJapanSelectionMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tJapanSelectionMode;
   
public:
   dp_tclTmcTunerDPJapanSelectionMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPJapanSelectionMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tJapanSelectionModeParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tJapanSelectionModeParam);
   tS32  s32SetData(const tBool &tJapanSelectionModeParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tJapanSelectionModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tJapanSelectionModeParam);
   tVoid vSetData(const tBool& tJapanSelectionModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPLatitudeOnShutdown{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   double tLatitudeOnShutdown;
   
public:
   dp_tclTmcTunerDPLatitudeOnShutdown(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPLatitudeOnShutdown() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   double tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(double& tLatitudeOnShutdownParam);
   tVoid operator>>(double& oParam);
   
   //write access for pool element 
   tS32  s32SetData(double &tLatitudeOnShutdownParam);
   tS32  s32SetData(const double &tLatitudeOnShutdownParam);
   tVoid operator<<(double oParam);
   
   // do not use --> old interface
   tU8   u8GetData(double& tLatitudeOnShutdownParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(double& tLatitudeOnShutdownParam);
   tVoid vSetData(const double& tLatitudeOnShutdownParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclTmcTunerDPLongitudeOnShutdown{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   double tLongitudeOnShutdown;
   
public:
   dp_tclTmcTunerDPLongitudeOnShutdown(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerDPLongitudeOnShutdown() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   double tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(double& tLongitudeOnShutdownParam);
   tVoid operator>>(double& oParam);
   
   //write access for pool element 
   tS32  s32SetData(double &tLongitudeOnShutdownParam);
   tS32  s32SetData(const double &tLongitudeOnShutdownParam);
   tVoid operator<<(double oParam);
   
   // do not use --> old interface
   tU8   u8GetData(double& tLongitudeOnShutdownParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(double& tLongitudeOnShutdownParam);
   tVoid vSetData(const double& tLongitudeOnShutdownParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
