// -----------------------------------------------------------------------
// FILE:
// PROJECT:      NissanLCN2Kai
// SW-COMPONENT:
// ----------------------------------------------------------------------
//
// DESCRIPTION: Convert function for DP
//
// ----------------------------------------------------------------------
// COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
// HISTORY:
// Date      | Author                | Modification
// 06.08.12  | kol2hi                | initial version
// -----------------------------------------------------------------------

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

tS32 s32SpmConvertShutCounter( tU8   u8OldVersion,
                               tU8   u8NewVersion,
                               tU8  *pu8OldData,
                               tU32  u32OldDataLen,
                               tU8 **pu8NewData,
                               tU32 *pu32NewDataLen ){
   tS32   s32Ret = DP_S32_ERR_NO_CONVERSION;

   (tVoid)u32OldDataLen;

   tVoid *pData  = (tVoid*)pu8OldData;

   * pu8NewData = NULL;
   if ( ( u8OldVersion == 0x00 ) && ( u8NewVersion == 0x01 ) ){
      // convert data from Version 0x00 to 0x01
      tU32 *pu32OldData = (tU32*)pData;
      tU32 *pu32NewData = new tU32; // allocated memory will be deleted by datapool after conversion

      if ( pu32NewData != NULL ){
         * pu32NewDataLen = sizeof( tU32 );
         * pu32NewData    = * pu32OldData + 0x4711;

         * pu8NewData     = (tU8*)pu32NewData;
         s32Ret           = DP_S32_NO_ERR;
      }
   } else if ( ( u8OldVersion == 0x01 ) && ( u8NewVersion == 0x00 ) ){
      // convert data from Version 0x01 to 0x00
      tU32 *pu32OldData = (tU32*)pData;
      tU32 *pu32NewData = new tU32; // allocated memory will be deleted by datapool after conversion

      if ( pu32NewData != NULL ){
         * pu32NewDataLen = sizeof( tU32 );
         * pu32NewData    = * pu32OldData - 0x4711;

         * pu8NewData     = (tU8*)pu32NewData;
         s32Ret           = DP_S32_NO_ERR;
      }
   }

   return( s32Ret );
} // s32SpmConvertShutCounter

// EOF

