
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpThread.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SpmThreadConfPrioWorker"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadSpmThreadConfPrioWorker::dp_tclSpmDpThreadSpmThreadConfPrioWorker() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tSpmThreadConfPrioWorker(56)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadSpmThreadConfPrioWorker::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WORK_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tSpmThreadConfPrioWorker = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadSpmThreadConfPrioWorker::u8GetData(tU32& tSpmThreadConfPrioWorkerParam) {
   vUpdate();
   tSpmThreadConfPrioWorkerParam = tSpmThreadConfPrioWorker;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadSpmThreadConfPrioWorker::tGetData() {
   vUpdate();
   return tSpmThreadConfPrioWorker;
};

tU8 dp_tclSpmDpThreadSpmThreadConfPrioWorker::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadSpmThreadConfPrioWorker::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioWorkerLow"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioWorkerLow::dp_tclSpmDpThreadThreadConfPrioWorkerLow() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioWorkerLow(140)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioWorkerLow::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WORK_PRIO_LOW",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioWorkerLow = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioWorkerLow::u8GetData(tU32& tThreadConfPrioWorkerLowParam) {
   vUpdate();
   tThreadConfPrioWorkerLowParam = tThreadConfPrioWorkerLow;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioWorkerLow::tGetData() {
   vUpdate();
   return tThreadConfPrioWorkerLow;
};

tU8 dp_tclSpmDpThreadThreadConfPrioWorkerLow::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioWorkerLow::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SpmThreadConfStackWorker"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadSpmThreadConfStackWorker::dp_tclSpmDpThreadSpmThreadConfStackWorker() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tSpmThreadConfStackWorker(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadSpmThreadConfStackWorker::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WORK_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tSpmThreadConfStackWorker = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadSpmThreadConfStackWorker::u8GetData(tU32& tSpmThreadConfStackWorkerParam) {
   vUpdate();
   tSpmThreadConfStackWorkerParam = tSpmThreadConfStackWorker;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadSpmThreadConfStackWorker::tGetData() {
   vUpdate();
   return tSpmThreadConfStackWorker;
};

tU8 dp_tclSpmDpThreadSpmThreadConfStackWorker::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadSpmThreadConfStackWorker::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioSubState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioSubState::dp_tclSpmDpThreadThreadConfPrioSubState() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioSubState(56)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioSubState::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_SUBSTATE_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioSubState = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioSubState::u8GetData(tU32& tThreadConfPrioSubStateParam) {
   vUpdate();
   tThreadConfPrioSubStateParam = tThreadConfPrioSubState;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioSubState::tGetData() {
   vUpdate();
   return tThreadConfPrioSubState;
};

tU8 dp_tclSpmDpThreadThreadConfPrioSubState::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioSubState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackSubState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackSubState::dp_tclSpmDpThreadThreadConfStackSubState() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackSubState(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackSubState::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_SUBSTATE_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackSubState = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackSubState::u8GetData(tU32& tThreadConfStackSubStateParam) {
   vUpdate();
   tThreadConfStackSubStateParam = tThreadConfStackSubState;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackSubState::tGetData() {
   vUpdate();
   return tThreadConfStackSubState;
};

tU8 dp_tclSpmDpThreadThreadConfStackSubState::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackSubState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioCcaRequest"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioCcaRequest::dp_tclSpmDpThreadThreadConfPrioCcaRequest() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioCcaRequest(57)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioCcaRequest::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_CCAREQUEST_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioCcaRequest = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioCcaRequest::u8GetData(tU32& tThreadConfPrioCcaRequestParam) {
   vUpdate();
   tThreadConfPrioCcaRequestParam = tThreadConfPrioCcaRequest;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioCcaRequest::tGetData() {
   vUpdate();
   return tThreadConfPrioCcaRequest;
};

tU8 dp_tclSpmDpThreadThreadConfPrioCcaRequest::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioCcaRequest::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackCcaRequest"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackCcaRequest::dp_tclSpmDpThreadThreadConfStackCcaRequest() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackCcaRequest(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackCcaRequest::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_CCAREQUEST_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackCcaRequest = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackCcaRequest::u8GetData(tU32& tThreadConfStackCcaRequestParam) {
   vUpdate();
   tThreadConfStackCcaRequestParam = tThreadConfStackCcaRequest;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackCcaRequest::tGetData() {
   vUpdate();
   return tThreadConfStackCcaRequest;
};

tU8 dp_tclSpmDpThreadThreadConfStackCcaRequest::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackCcaRequest::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioCcaIn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioCcaIn::dp_tclSpmDpThreadThreadConfPrioCcaIn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioCcaIn(57)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioCcaIn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_CCAIN_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioCcaIn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioCcaIn::u8GetData(tU32& tThreadConfPrioCcaInParam) {
   vUpdate();
   tThreadConfPrioCcaInParam = tThreadConfPrioCcaIn;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioCcaIn::tGetData() {
   vUpdate();
   return tThreadConfPrioCcaIn;
};

tU8 dp_tclSpmDpThreadThreadConfPrioCcaIn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioCcaIn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackCcaIn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackCcaIn::dp_tclSpmDpThreadThreadConfStackCcaIn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackCcaIn(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackCcaIn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_CCAIN_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackCcaIn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackCcaIn::u8GetData(tU32& tThreadConfStackCcaInParam) {
   vUpdate();
   tThreadConfStackCcaInParam = tThreadConfStackCcaIn;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackCcaIn::tGetData() {
   vUpdate();
   return tThreadConfStackCcaIn;
};

tU8 dp_tclSpmDpThreadThreadConfStackCcaIn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackCcaIn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioWdtLow"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioWdtLow::dp_tclSpmDpThreadThreadConfPrioWdtLow() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioWdtLow(140)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioWdtLow::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_LOW_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioWdtLow = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioWdtLow::u8GetData(tU32& tThreadConfPrioWdtLowParam) {
   vUpdate();
   tThreadConfPrioWdtLowParam = tThreadConfPrioWdtLow;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioWdtLow::tGetData() {
   vUpdate();
   return tThreadConfPrioWdtLow;
};

tU8 dp_tclSpmDpThreadThreadConfPrioWdtLow::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioWdtLow::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackWdtLow"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackWdtLow::dp_tclSpmDpThreadThreadConfStackWdtLow() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackWdtLow(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackWdtLow::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_LOW_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackWdtLow = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackWdtLow::u8GetData(tU32& tThreadConfStackWdtLowParam) {
   vUpdate();
   tThreadConfStackWdtLowParam = tThreadConfStackWdtLow;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackWdtLow::tGetData() {
   vUpdate();
   return tThreadConfStackWdtLow;
};

tU8 dp_tclSpmDpThreadThreadConfStackWdtLow::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackWdtLow::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioWdtMid"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioWdtMid::dp_tclSpmDpThreadThreadConfPrioWdtMid() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioWdtMid(100)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioWdtMid::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_MID_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioWdtMid = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioWdtMid::u8GetData(tU32& tThreadConfPrioWdtMidParam) {
   vUpdate();
   tThreadConfPrioWdtMidParam = tThreadConfPrioWdtMid;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioWdtMid::tGetData() {
   vUpdate();
   return tThreadConfPrioWdtMid;
};

tU8 dp_tclSpmDpThreadThreadConfPrioWdtMid::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioWdtMid::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackWdtMid"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackWdtMid::dp_tclSpmDpThreadThreadConfStackWdtMid() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackWdtMid(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackWdtMid::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_MID_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackWdtMid = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackWdtMid::u8GetData(tU32& tThreadConfStackWdtMidParam) {
   vUpdate();
   tThreadConfStackWdtMidParam = tThreadConfStackWdtMid;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackWdtMid::tGetData() {
   vUpdate();
   return tThreadConfStackWdtMid;
};

tU8 dp_tclSpmDpThreadThreadConfStackWdtMid::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackWdtMid::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioWdtHigh"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioWdtHigh::dp_tclSpmDpThreadThreadConfPrioWdtHigh() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioWdtHigh(54)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioWdtHigh::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_HIGH_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioWdtHigh = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioWdtHigh::u8GetData(tU32& tThreadConfPrioWdtHighParam) {
   vUpdate();
   tThreadConfPrioWdtHighParam = tThreadConfPrioWdtHigh;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioWdtHigh::tGetData() {
   vUpdate();
   return tThreadConfPrioWdtHigh;
};

tU8 dp_tclSpmDpThreadThreadConfPrioWdtHigh::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioWdtHigh::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackWdtHigh"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackWdtHigh::dp_tclSpmDpThreadThreadConfStackWdtHigh() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackWdtHigh(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackWdtHigh::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_HIGH_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackWdtHigh = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackWdtHigh::u8GetData(tU32& tThreadConfStackWdtHighParam) {
   vUpdate();
   tThreadConfStackWdtHighParam = tThreadConfStackWdtHigh;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackWdtHigh::tGetData() {
   vUpdate();
   return tThreadConfStackWdtHigh;
};

tU8 dp_tclSpmDpThreadThreadConfStackWdtHigh::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackWdtHigh::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioWdtHw"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioWdtHw::dp_tclSpmDpThreadThreadConfPrioWdtHw() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioWdtHw(5)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioWdtHw::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_HW_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioWdtHw = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioWdtHw::u8GetData(tU32& tThreadConfPrioWdtHwParam) {
   vUpdate();
   tThreadConfPrioWdtHwParam = tThreadConfPrioWdtHw;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioWdtHw::tGetData() {
   vUpdate();
   return tThreadConfPrioWdtHw;
};

tU8 dp_tclSpmDpThreadThreadConfPrioWdtHw::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioWdtHw::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackWdtHw"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackWdtHw::dp_tclSpmDpThreadThreadConfStackWdtHw() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackWdtHw(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackWdtHw::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_WDT_HW_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackWdtHw = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackWdtHw::u8GetData(tU32& tThreadConfStackWdtHwParam) {
   vUpdate();
   tThreadConfStackWdtHwParam = tThreadConfStackWdtHw;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackWdtHw::tGetData() {
   vUpdate();
   return tThreadConfStackWdtHw;
};

tU8 dp_tclSpmDpThreadThreadConfStackWdtHw::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackWdtHw::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioSCCRx"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioSCCRx::dp_tclSpmDpThreadThreadConfPrioSCCRx() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioSCCRx(56)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioSCCRx::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_SCC_RX_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioSCCRx = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioSCCRx::u8GetData(tU32& tThreadConfPrioSCCRxParam) {
   vUpdate();
   tThreadConfPrioSCCRxParam = tThreadConfPrioSCCRx;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioSCCRx::tGetData() {
   vUpdate();
   return tThreadConfPrioSCCRx;
};

tU8 dp_tclSpmDpThreadThreadConfPrioSCCRx::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioSCCRx::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackSCCRx"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackSCCRx::dp_tclSpmDpThreadThreadConfStackSCCRx() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackSCCRx(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackSCCRx::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_SCC_RX_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackSCCRx = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackSCCRx::u8GetData(tU32& tThreadConfStackSCCRxParam) {
   vUpdate();
   tThreadConfStackSCCRxParam = tThreadConfStackSCCRx;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackSCCRx::tGetData() {
   vUpdate();
   return tThreadConfStackSCCRx;
};

tU8 dp_tclSpmDpThreadThreadConfStackSCCRx::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackSCCRx::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioDevVoltHdlr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr::dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioDevVoltHdlr(56)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_DEV_VOLT_HDLR_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioDevVoltHdlr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr::u8GetData(tU32& tThreadConfPrioDevVoltHdlrParam) {
   vUpdate();
   tThreadConfPrioDevVoltHdlrParam = tThreadConfPrioDevVoltHdlr;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr::tGetData() {
   vUpdate();
   return tThreadConfPrioDevVoltHdlr;
};

tU8 dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioDevVoltHdlr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackDevVoltHdlr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackDevVoltHdlr::dp_tclSpmDpThreadThreadConfStackDevVoltHdlr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackDevVoltHdlr(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackDevVoltHdlr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_DEV_VOLT_HDLR_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackDevVoltHdlr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackDevVoltHdlr::u8GetData(tU32& tThreadConfStackDevVoltHdlrParam) {
   vUpdate();
   tThreadConfStackDevVoltHdlrParam = tThreadConfStackDevVoltHdlr;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackDevVoltHdlr::tGetData() {
   vUpdate();
   return tThreadConfStackDevVoltHdlr;
};

tU8 dp_tclSpmDpThreadThreadConfStackDevVoltHdlr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackDevVoltHdlr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfPrioDevWupHdlr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfPrioDevWupHdlr::dp_tclSpmDpThreadThreadConfPrioDevWupHdlr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfPrioDevWupHdlr(56)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfPrioDevWupHdlr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_DEV_WUP_HDLR_PRIO",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfPrioDevWupHdlr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfPrioDevWupHdlr::u8GetData(tU32& tThreadConfPrioDevWupHdlrParam) {
   vUpdate();
   tThreadConfPrioDevWupHdlrParam = tThreadConfPrioDevWupHdlr;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfPrioDevWupHdlr::tGetData() {
   vUpdate();
   return tThreadConfPrioDevWupHdlr;
};

tU8 dp_tclSpmDpThreadThreadConfPrioDevWupHdlr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfPrioDevWupHdlr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadConfStackDevWupHdlr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpThreadThreadConfStackDevWupHdlr::dp_tclSpmDpThreadThreadConfStackDevWupHdlr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadConfStackDevWupHdlr(4096)
{
   vUpdate();
}

tVoid dp_tclSpmDpThreadThreadConfStackDevWupHdlr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_THREAD";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_SPM_DEV_WUP_HDLR_STACK",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadConfStackDevWupHdlr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpThreadThreadConfStackDevWupHdlr::u8GetData(tU32& tThreadConfStackDevWupHdlrParam) {
   vUpdate();
   tThreadConfStackDevWupHdlrParam = tThreadConfStackDevWupHdlr;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpThreadThreadConfStackDevWupHdlr::tGetData() {
   vUpdate();
   return tThreadConfStackDevWupHdlr;
};

tU8 dp_tclSpmDpThreadThreadConfStackDevWupHdlr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpThreadThreadConfStackDevWupHdlr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

