#ifndef _DP_FI_SPMDPRNAIVI_H
#define _DP_FI_SPMDPRNAIVI_H

extern tVoid vInitSpmDpRnAivi(tU8 u8Bank=DP_U8_NO_BANK_ACTION);





//lint -e750
#define SPM_S_IMPORT_INTERFACE_DP_SPM 
#include "spm_if.h"
//lint +e750




class dp_tclSpmDpRnAiviSecurityEnabled{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSecurityEnabled;
   
public:
   dp_tclSpmDpRnAiviSecurityEnabled(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviSecurityEnabled() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSecurityEnabledParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSecurityEnabledParam);
   tS32  s32SetData(const tBool &tSecurityEnabledParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSecurityEnabledParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSecurityEnabledParam);
   tVoid vSetData(const tBool& tSecurityEnabledParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviWakeupVCan{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tWakeupVCan;
   
public:
   dp_tclSpmDpRnAiviWakeupVCan(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviWakeupVCan() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tWakeupVCanParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tWakeupVCanParam);
   tS32  s32SetData(const tBool &tWakeupVCanParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tWakeupVCanParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tWakeupVCanParam);
   tVoid vSetData(const tBool& tWakeupVCanParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviUnballastTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tUnballastTime;
   
public:
   dp_tclSpmDpRnAiviUnballastTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviUnballastTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tUnballastTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tUnballastTimeParam);
   tS32  s32SetData(const tU32 &tUnballastTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tUnballastTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tUnballastTimeParam);
   tVoid vSetData(const tU32& tUnballastTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviUnballastWarningTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tUnballastWarningTime;
   
public:
   dp_tclSpmDpRnAiviUnballastWarningTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviUnballastWarningTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tUnballastWarningTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tUnballastWarningTimeParam);
   tS32  s32SetData(const tU32 &tUnballastWarningTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tUnballastWarningTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tUnballastWarningTimeParam);
   tVoid vSetData(const tU32& tUnballastWarningTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviTimeFromEngineStopped{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tTimeFromEngineStopped;
   
public:
   dp_tclSpmDpRnAiviTimeFromEngineStopped(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviTimeFromEngineStopped() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tTimeFromEngineStoppedParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tTimeFromEngineStoppedParam);
   tS32  s32SetData(const tU32 &tTimeFromEngineStoppedParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tTimeFromEngineStoppedParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tTimeFromEngineStoppedParam);
   tVoid vSetData(const tU32& tTimeFromEngineStoppedParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviDegradedCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDegradedCount;
   
public:
   dp_tclSpmDpRnAiviDegradedCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviDegradedCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDegradedCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDegradedCountParam);
   tS32  s32SetData(const tU32 &tDegradedCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDegradedCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDegradedCountParam);
   tVoid vSetData(const tU32& tDegradedCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviDegradedTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDegradedTime;
   
public:
   dp_tclSpmDpRnAiviDegradedTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviDegradedTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDegradedTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDegradedTimeParam);
   tS32  s32SetData(const tU32 &tDegradedTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDegradedTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDegradedTimeParam);
   tVoid vSetData(const tU32& tDegradedTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviSecurityMasterOld{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSecurityMasterOld;
   
public:
   dp_tclSpmDpRnAiviSecurityMasterOld(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviSecurityMasterOld() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSecurityMasterOldParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSecurityMasterOldParam);
   tS32  s32SetData(const tBool &tSecurityMasterOldParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSecurityMasterOldParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSecurityMasterOldParam);
   tVoid vSetData(const tBool& tSecurityMasterOldParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviSecurityPassed{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSecurityPassed;
   
public:
   dp_tclSpmDpRnAiviSecurityPassed(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviSecurityPassed() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSecurityPassedParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSecurityPassedParam);
   tS32  s32SetData(const tBool &tSecurityPassedParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSecurityPassedParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSecurityPassedParam);
   tVoid vSetData(const tBool& tSecurityPassedParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviSecurityAltCarCode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSecurityAltCarCode;
   
public:
   dp_tclSpmDpRnAiviSecurityAltCarCode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviSecurityAltCarCode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSecurityAltCarCodeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSecurityAltCarCodeParam);
   tS32  s32SetData(const tU32 &tSecurityAltCarCodeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSecurityAltCarCodeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSecurityAltCarCodeParam);
   tVoid vSetData(const tU32& tSecurityAltCarCodeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviSecurityACode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSecurityACode;
   
public:
   dp_tclSpmDpRnAiviSecurityACode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviSecurityACode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSecurityACodeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSecurityACodeParam);
   tS32  s32SetData(const tU32 &tSecurityACodeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSecurityACodeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSecurityACodeParam);
   tVoid vSetData(const tU32& tSecurityACodeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviWdtLowWithGetp{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tWdtLowWithGetp;
   
public:
   dp_tclSpmDpRnAiviWdtLowWithGetp(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviWdtLowWithGetp() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tWdtLowWithGetpParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tWdtLowWithGetpParam);
   tS32  s32SetData(const tBool &tWdtLowWithGetpParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tWdtLowWithGetpParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tWdtLowWithGetpParam);
   tVoid vSetData(const tBool& tWdtLowWithGetpParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviCurrentPowerPlatform{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCurrentPowerPlatform;
   
public:
   dp_tclSpmDpRnAiviCurrentPowerPlatform(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpRnAiviCurrentPowerPlatform() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCurrentPowerPlatformParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCurrentPowerPlatformParam);
   tS32  s32SetData(const tU8 &tCurrentPowerPlatformParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCurrentPowerPlatformParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCurrentPowerPlatformParam);
   tVoid vSetData(const tU8& tCurrentPowerPlatformParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpRnAiviPowerPlatform{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU8 tPowerPlatform;
   
public:
   dp_tclSpmDpRnAiviPowerPlatform();
   virtual ~dp_tclSpmDpRnAiviPowerPlatform(){};
   
   tU8 tGetData();
   tU8   u8GetData(tU8& tPowerPlatformParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU8& oParam);

    tVoid vSetData(tU8 &tPowerPlatformParam) const;
   tVoid vSetData(const tU8 &tPowerPlatformParam) const;
   tVoid operator<<(tU8 oParam);

};

class dp_tclSpmDpRnAiviEnduringLowTimeout{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tEnduringLowTimeout;
   
public:
   dp_tclSpmDpRnAiviEnduringLowTimeout();
   virtual ~dp_tclSpmDpRnAiviEnduringLowTimeout(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tEnduringLowTimeoutParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);

    tVoid vSetData(tU32 &tEnduringLowTimeoutParam) const;
   tVoid vSetData(const tU32 &tEnduringLowTimeoutParam) const;
   tVoid operator<<(tU32 oParam);

};

class dp_tclSpmDpRnAiviProductionConfigId{
private:
   tU8 _u8DataStatus;
public:
   dp_tclSpmDpRnAiviProductionConfigId(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclSpmDpRnAiviProductionConfigId(){
   };
   
   tU8   u8GetData(tString &tProductionConfigIdParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tProductionConfigIdParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tProductionConfigIdParam);
    tVoid vSetData(const tString &tProductionConfigIdParam);
    tVoid vSetData(tString &tProductionConfigIdParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tProductionConfigIdParam, tU16 u16Len);

};

class dp_tclSpmDpRnAiviCustomerDefConfigId{
private:
   tU8 _u8DataStatus;
public:
   dp_tclSpmDpRnAiviCustomerDefConfigId(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclSpmDpRnAiviCustomerDefConfigId(){
   };
   
   tU8   u8GetData(tString &tCustomerDefConfigIdParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tCustomerDefConfigIdParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tCustomerDefConfigIdParam);
    tVoid vSetData(const tString &tCustomerDefConfigIdParam);
    tVoid vSetData(tString &tCustomerDefConfigIdParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tCustomerDefConfigIdParam, tU16 u16Len);

};

class dp_tclSpmDpRnAiviCustomerConfigId{
private:
   tU8 _u8DataStatus;
public:
   dp_tclSpmDpRnAiviCustomerConfigId(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclSpmDpRnAiviCustomerConfigId(){
   };
   
   tU8   u8GetData(tString &tCustomerConfigIdParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tCustomerConfigIdParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tCustomerConfigIdParam);
    tVoid vSetData(const tString &tCustomerConfigIdParam);
    tVoid vSetData(tString &tCustomerConfigIdParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tCustomerConfigIdParam, tU16 u16Len);

};

class dp_tclSpmDpRnAiviNaviRegionCode{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU16 tNaviRegionCode;
   
public:
   dp_tclSpmDpRnAiviNaviRegionCode();
   virtual ~dp_tclSpmDpRnAiviNaviRegionCode(){};
   
   tU16 tGetData();
   tU8   u8GetData(tU16& tNaviRegionCodeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU16& oParam);

    tVoid vSetData(tU16 &tNaviRegionCodeParam) const;
   tVoid vSetData(const tU16 &tNaviRegionCodeParam) const;
   tVoid operator<<(tU16 oParam);

};

class dp_tclSpmDpRnAiviBluetoothVersion{
private:
   tU8 _u8DataStatus;
public:
   dp_tclSpmDpRnAiviBluetoothVersion(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclSpmDpRnAiviBluetoothVersion(){
   };
   
   tU8   u8GetData(tString &tBluetoothVersionParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tBluetoothVersionParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tBluetoothVersionParam);
    tVoid vSetData(const tString &tBluetoothVersionParam);
    tVoid vSetData(tString &tBluetoothVersionParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tBluetoothVersionParam, tU16 u16Len);

};

class dp_tclSpmDpRnAiviUsbPortDisconnect{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU16 tUsbPortDisconnect;
   
public:
   dp_tclSpmDpRnAiviUsbPortDisconnect();
   virtual ~dp_tclSpmDpRnAiviUsbPortDisconnect(){};
   
   tU16 tGetData();
   tU8   u8GetData(tU16& tUsbPortDisconnectParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU16& oParam);

    tVoid vSetData(tU16 &tUsbPortDisconnectParam) const;
   tVoid vSetData(const tU16 &tUsbPortDisconnectParam) const;
   tVoid operator<<(tU16 oParam);

};

#endif
