
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpRnAivi.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SecurityEnabled"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviSecurityEnabled::dp_tclSpmDpRnAiviSecurityEnabled(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSecurityEnabled,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviSecurityEnabled::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SecurityEnabled",(tS32) 0xef0795f7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSecurityEnabled = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviSecurityEnabled::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SecurityEnabled", (tS32)0xef0795f7);
   (tVoid)myDpElem.bFillData((tVoid*)&tSecurityEnabled, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviSecurityEnabled::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviSecurityEnabled::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpRnAiviSecurityEnabled::tGetData() {
   vUpdate();
   return tSecurityEnabled;
};
tS32 dp_tclSpmDpRnAiviSecurityEnabled::s32GetData(tBool& tSecurityEnabledParam) { 
   vUpdate();
   tSecurityEnabledParam = tSecurityEnabled;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviSecurityEnabled::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SecurityEnabled", (tS32)0xef0795f7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviSecurityEnabled::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviSecurityEnabled::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviSecurityEnabled::s32SetData(tBool &tSecurityEnabledParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityEnabled,(tVoid*)&tSecurityEnabledParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityEnabledParam' in function 'dp_tclSpmDpRnAiviSecurityEnabled::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpRnAiviSecurityEnabled::s32SetData(const tBool &tSecurityEnabledParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityEnabled,(tVoid*)&tSecurityEnabledParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityEnabledParam' in function 'dp_tclSpmDpRnAiviSecurityEnabled::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviSecurityEnabled::u8GetData(tBool& tSecurityEnabledParam) {  
   vUpdate();
   tSecurityEnabledParam = tSecurityEnabled;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviSecurityEnabled::vSetData(tBool &tSecurityEnabledParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityEnabled,(tVoid*)&tSecurityEnabledParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSecurityEnabledParam' in function 'dp_tclSpmDpRnAiviSecurityEnabled::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpRnAiviSecurityEnabled::vSetData(const tBool &tSecurityEnabledParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityEnabled,(tVoid*)&tSecurityEnabledParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSecurityEnabledParam' in function 'dp_tclSpmDpRnAiviSecurityEnabled::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpRnAiviSecurityEnabled::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviSecurityEnabled::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityEnabled", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityEnabled::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityEnabled", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityEnabled::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SecurityEnabled", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element SecurityEnabled has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WakeupVCan"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviWakeupVCan::dp_tclSpmDpRnAiviWakeupVCan(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tWakeupVCan,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviWakeupVCan::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("WakeupVCan",(tS32) 0xd017275);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tWakeupVCan = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviWakeupVCan::vStore(tVoid) {
   dp_tclBaseElement myDpElem("WakeupVCan", (tS32)0xd017275);
   (tVoid)myDpElem.bFillData((tVoid*)&tWakeupVCan, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviWakeupVCan::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviWakeupVCan::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpRnAiviWakeupVCan::tGetData() {
   vUpdate();
   return tWakeupVCan;
};
tS32 dp_tclSpmDpRnAiviWakeupVCan::s32GetData(tBool& tWakeupVCanParam) { 
   vUpdate();
   tWakeupVCanParam = tWakeupVCan;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviWakeupVCan::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("WakeupVCan", (tS32)0xd017275);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviWakeupVCan::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviWakeupVCan::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviWakeupVCan::s32SetData(tBool &tWakeupVCanParam) {
   //init parameter
   (tVoid)memcpy(&tWakeupVCan,(tVoid*)&tWakeupVCanParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tWakeupVCanParam' in function 'dp_tclSpmDpRnAiviWakeupVCan::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpRnAiviWakeupVCan::s32SetData(const tBool &tWakeupVCanParam) {
   //init parameter
   (tVoid)memcpy(&tWakeupVCan,(tVoid*)&tWakeupVCanParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tWakeupVCanParam' in function 'dp_tclSpmDpRnAiviWakeupVCan::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviWakeupVCan::u8GetData(tBool& tWakeupVCanParam) {  
   vUpdate();
   tWakeupVCanParam = tWakeupVCan;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviWakeupVCan::vSetData(tBool &tWakeupVCanParam) { 
   //init parameter
   (tVoid)memcpy(&tWakeupVCan,(tVoid*)&tWakeupVCanParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tWakeupVCanParam' in function 'dp_tclSpmDpRnAiviWakeupVCan::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpRnAiviWakeupVCan::vSetData(const tBool &tWakeupVCanParam) { 
   //init parameter
   (tVoid)memcpy(&tWakeupVCan,(tVoid*)&tWakeupVCanParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tWakeupVCanParam' in function 'dp_tclSpmDpRnAiviWakeupVCan::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpRnAiviWakeupVCan::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviWakeupVCan::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "WakeupVCan", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviWakeupVCan::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "WakeupVCan", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviWakeupVCan::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: WakeupVCan", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element WakeupVCan has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UnballastTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviUnballastTime::dp_tclSpmDpRnAiviUnballastTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUnballastTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviUnballastTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UnballastTime",(tS32) 0x5c866d91);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tUnballastTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviUnballastTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UnballastTime", (tS32)0x5c866d91);
   (tVoid)myDpElem.bFillData((tVoid*)&tUnballastTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviUnballastTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviUnballastTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviUnballastTime::tGetData() {
   vUpdate();
   return tUnballastTime;
};
tS32 dp_tclSpmDpRnAiviUnballastTime::s32GetData(tU32& tUnballastTimeParam) { 
   vUpdate();
   tUnballastTimeParam = tUnballastTime;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviUnballastTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UnballastTime", (tS32)0x5c866d91);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviUnballastTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviUnballastTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviUnballastTime::s32SetData(tU32 &tUnballastTimeParam) {
   //init parameter
   (tVoid)memcpy(&tUnballastTime,(tVoid*)&tUnballastTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUnballastTimeParam' in function 'dp_tclSpmDpRnAiviUnballastTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviUnballastTime::s32SetData(const tU32 &tUnballastTimeParam) {
   //init parameter
   (tVoid)memcpy(&tUnballastTime,(tVoid*)&tUnballastTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUnballastTimeParam' in function 'dp_tclSpmDpRnAiviUnballastTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviUnballastTime::u8GetData(tU32& tUnballastTimeParam) {  
   vUpdate();
   tUnballastTimeParam = tUnballastTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviUnballastTime::vSetData(tU32 &tUnballastTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tUnballastTime,(tVoid*)&tUnballastTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tUnballastTimeParam' in function 'dp_tclSpmDpRnAiviUnballastTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviUnballastTime::vSetData(const tU32 &tUnballastTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tUnballastTime,(tVoid*)&tUnballastTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tUnballastTimeParam' in function 'dp_tclSpmDpRnAiviUnballastTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviUnballastTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviUnballastTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "UnballastTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviUnballastTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "UnballastTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviUnballastTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UnballastTime", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element UnballastTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UnballastWarningTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviUnballastWarningTime::dp_tclSpmDpRnAiviUnballastWarningTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUnballastWarningTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviUnballastWarningTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UnballastWarningTime",(tS32) 0x6d43a1f3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tUnballastWarningTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviUnballastWarningTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UnballastWarningTime", (tS32)0x6d43a1f3);
   (tVoid)myDpElem.bFillData((tVoid*)&tUnballastWarningTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviUnballastWarningTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviUnballastWarningTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviUnballastWarningTime::tGetData() {
   vUpdate();
   return tUnballastWarningTime;
};
tS32 dp_tclSpmDpRnAiviUnballastWarningTime::s32GetData(tU32& tUnballastWarningTimeParam) { 
   vUpdate();
   tUnballastWarningTimeParam = tUnballastWarningTime;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviUnballastWarningTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UnballastWarningTime", (tS32)0x6d43a1f3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviUnballastWarningTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviUnballastWarningTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviUnballastWarningTime::s32SetData(tU32 &tUnballastWarningTimeParam) {
   //init parameter
   (tVoid)memcpy(&tUnballastWarningTime,(tVoid*)&tUnballastWarningTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUnballastWarningTimeParam' in function 'dp_tclSpmDpRnAiviUnballastWarningTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviUnballastWarningTime::s32SetData(const tU32 &tUnballastWarningTimeParam) {
   //init parameter
   (tVoid)memcpy(&tUnballastWarningTime,(tVoid*)&tUnballastWarningTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUnballastWarningTimeParam' in function 'dp_tclSpmDpRnAiviUnballastWarningTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviUnballastWarningTime::u8GetData(tU32& tUnballastWarningTimeParam) {  
   vUpdate();
   tUnballastWarningTimeParam = tUnballastWarningTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviUnballastWarningTime::vSetData(tU32 &tUnballastWarningTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tUnballastWarningTime,(tVoid*)&tUnballastWarningTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tUnballastWarningTimeParam' in function 'dp_tclSpmDpRnAiviUnballastWarningTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviUnballastWarningTime::vSetData(const tU32 &tUnballastWarningTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tUnballastWarningTime,(tVoid*)&tUnballastWarningTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tUnballastWarningTimeParam' in function 'dp_tclSpmDpRnAiviUnballastWarningTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviUnballastWarningTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviUnballastWarningTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "UnballastWarningTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviUnballastWarningTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "UnballastWarningTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviUnballastWarningTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UnballastWarningTime", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element UnballastWarningTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TimeFromEngineStopped"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviTimeFromEngineStopped::dp_tclSpmDpRnAiviTimeFromEngineStopped(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTimeFromEngineStopped,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviTimeFromEngineStopped::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TimeFromEngineStopped",(tS32) 0x1be28700);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tTimeFromEngineStopped = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviTimeFromEngineStopped::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TimeFromEngineStopped", (tS32)0x1be28700);
   (tVoid)myDpElem.bFillData((tVoid*)&tTimeFromEngineStopped, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviTimeFromEngineStopped::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviTimeFromEngineStopped::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviTimeFromEngineStopped::tGetData() {
   vUpdate();
   return tTimeFromEngineStopped;
};
tS32 dp_tclSpmDpRnAiviTimeFromEngineStopped::s32GetData(tU32& tTimeFromEngineStoppedParam) { 
   vUpdate();
   tTimeFromEngineStoppedParam = tTimeFromEngineStopped;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviTimeFromEngineStopped::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TimeFromEngineStopped", (tS32)0x1be28700);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviTimeFromEngineStopped::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviTimeFromEngineStopped::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviTimeFromEngineStopped::s32SetData(tU32 &tTimeFromEngineStoppedParam) {
   //init parameter
   (tVoid)memcpy(&tTimeFromEngineStopped,(tVoid*)&tTimeFromEngineStoppedParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimeFromEngineStoppedParam' in function 'dp_tclSpmDpRnAiviTimeFromEngineStopped::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviTimeFromEngineStopped::s32SetData(const tU32 &tTimeFromEngineStoppedParam) {
   //init parameter
   (tVoid)memcpy(&tTimeFromEngineStopped,(tVoid*)&tTimeFromEngineStoppedParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimeFromEngineStoppedParam' in function 'dp_tclSpmDpRnAiviTimeFromEngineStopped::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviTimeFromEngineStopped::u8GetData(tU32& tTimeFromEngineStoppedParam) {  
   vUpdate();
   tTimeFromEngineStoppedParam = tTimeFromEngineStopped;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviTimeFromEngineStopped::vSetData(tU32 &tTimeFromEngineStoppedParam) { 
   //init parameter
   (tVoid)memcpy(&tTimeFromEngineStopped,(tVoid*)&tTimeFromEngineStoppedParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tTimeFromEngineStoppedParam' in function 'dp_tclSpmDpRnAiviTimeFromEngineStopped::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviTimeFromEngineStopped::vSetData(const tU32 &tTimeFromEngineStoppedParam) { 
   //init parameter
   (tVoid)memcpy(&tTimeFromEngineStopped,(tVoid*)&tTimeFromEngineStoppedParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tTimeFromEngineStoppedParam' in function 'dp_tclSpmDpRnAiviTimeFromEngineStopped::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviTimeFromEngineStopped::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviTimeFromEngineStopped::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "TimeFromEngineStopped", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviTimeFromEngineStopped::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "TimeFromEngineStopped", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviTimeFromEngineStopped::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TimeFromEngineStopped", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element TimeFromEngineStopped has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DegradedCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviDegradedCount::dp_tclSpmDpRnAiviDegradedCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDegradedCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviDegradedCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DegradedCount",(tS32) 0x4f8b64c1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDegradedCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviDegradedCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DegradedCount", (tS32)0x4f8b64c1);
   (tVoid)myDpElem.bFillData((tVoid*)&tDegradedCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviDegradedCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviDegradedCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviDegradedCount::tGetData() {
   vUpdate();
   return tDegradedCount;
};
tS32 dp_tclSpmDpRnAiviDegradedCount::s32GetData(tU32& tDegradedCountParam) { 
   vUpdate();
   tDegradedCountParam = tDegradedCount;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviDegradedCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DegradedCount", (tS32)0x4f8b64c1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviDegradedCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviDegradedCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviDegradedCount::s32SetData(tU32 &tDegradedCountParam) {
   //init parameter
   (tVoid)memcpy(&tDegradedCount,(tVoid*)&tDegradedCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDegradedCountParam' in function 'dp_tclSpmDpRnAiviDegradedCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviDegradedCount::s32SetData(const tU32 &tDegradedCountParam) {
   //init parameter
   (tVoid)memcpy(&tDegradedCount,(tVoid*)&tDegradedCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDegradedCountParam' in function 'dp_tclSpmDpRnAiviDegradedCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviDegradedCount::u8GetData(tU32& tDegradedCountParam) {  
   vUpdate();
   tDegradedCountParam = tDegradedCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviDegradedCount::vSetData(tU32 &tDegradedCountParam) { 
   //init parameter
   (tVoid)memcpy(&tDegradedCount,(tVoid*)&tDegradedCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDegradedCountParam' in function 'dp_tclSpmDpRnAiviDegradedCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviDegradedCount::vSetData(const tU32 &tDegradedCountParam) { 
   //init parameter
   (tVoid)memcpy(&tDegradedCount,(tVoid*)&tDegradedCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDegradedCountParam' in function 'dp_tclSpmDpRnAiviDegradedCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviDegradedCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviDegradedCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "DegradedCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviDegradedCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "DegradedCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviDegradedCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DegradedCount", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element DegradedCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DegradedTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviDegradedTime::dp_tclSpmDpRnAiviDegradedTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDegradedTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviDegradedTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DegradedTime",(tS32) 0xfe8b52f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDegradedTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviDegradedTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DegradedTime", (tS32)0xfe8b52f);
   (tVoid)myDpElem.bFillData((tVoid*)&tDegradedTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviDegradedTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviDegradedTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviDegradedTime::tGetData() {
   vUpdate();
   return tDegradedTime;
};
tS32 dp_tclSpmDpRnAiviDegradedTime::s32GetData(tU32& tDegradedTimeParam) { 
   vUpdate();
   tDegradedTimeParam = tDegradedTime;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviDegradedTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DegradedTime", (tS32)0xfe8b52f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviDegradedTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviDegradedTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviDegradedTime::s32SetData(tU32 &tDegradedTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDegradedTime,(tVoid*)&tDegradedTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDegradedTimeParam' in function 'dp_tclSpmDpRnAiviDegradedTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviDegradedTime::s32SetData(const tU32 &tDegradedTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDegradedTime,(tVoid*)&tDegradedTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDegradedTimeParam' in function 'dp_tclSpmDpRnAiviDegradedTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviDegradedTime::u8GetData(tU32& tDegradedTimeParam) {  
   vUpdate();
   tDegradedTimeParam = tDegradedTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviDegradedTime::vSetData(tU32 &tDegradedTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDegradedTime,(tVoid*)&tDegradedTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDegradedTimeParam' in function 'dp_tclSpmDpRnAiviDegradedTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviDegradedTime::vSetData(const tU32 &tDegradedTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDegradedTime,(tVoid*)&tDegradedTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDegradedTimeParam' in function 'dp_tclSpmDpRnAiviDegradedTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviDegradedTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviDegradedTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "DegradedTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviDegradedTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "DegradedTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviDegradedTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DegradedTime", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element DegradedTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SecurityMasterOld"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviSecurityMasterOld::dp_tclSpmDpRnAiviSecurityMasterOld(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSecurityMasterOld,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviSecurityMasterOld::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SecurityMasterOld",(tS32) 0x57e2f0ef);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSecurityMasterOld = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviSecurityMasterOld::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SecurityMasterOld", (tS32)0x57e2f0ef);
   (tVoid)myDpElem.bFillData((tVoid*)&tSecurityMasterOld, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviSecurityMasterOld::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviSecurityMasterOld::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpRnAiviSecurityMasterOld::tGetData() {
   vUpdate();
   return tSecurityMasterOld;
};
tS32 dp_tclSpmDpRnAiviSecurityMasterOld::s32GetData(tBool& tSecurityMasterOldParam) { 
   vUpdate();
   tSecurityMasterOldParam = tSecurityMasterOld;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviSecurityMasterOld::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SecurityMasterOld", (tS32)0x57e2f0ef);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviSecurityMasterOld::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviSecurityMasterOld::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviSecurityMasterOld::s32SetData(tBool &tSecurityMasterOldParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityMasterOld,(tVoid*)&tSecurityMasterOldParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityMasterOldParam' in function 'dp_tclSpmDpRnAiviSecurityMasterOld::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpRnAiviSecurityMasterOld::s32SetData(const tBool &tSecurityMasterOldParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityMasterOld,(tVoid*)&tSecurityMasterOldParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityMasterOldParam' in function 'dp_tclSpmDpRnAiviSecurityMasterOld::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviSecurityMasterOld::u8GetData(tBool& tSecurityMasterOldParam) {  
   vUpdate();
   tSecurityMasterOldParam = tSecurityMasterOld;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviSecurityMasterOld::vSetData(tBool &tSecurityMasterOldParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityMasterOld,(tVoid*)&tSecurityMasterOldParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSecurityMasterOldParam' in function 'dp_tclSpmDpRnAiviSecurityMasterOld::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpRnAiviSecurityMasterOld::vSetData(const tBool &tSecurityMasterOldParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityMasterOld,(tVoid*)&tSecurityMasterOldParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSecurityMasterOldParam' in function 'dp_tclSpmDpRnAiviSecurityMasterOld::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpRnAiviSecurityMasterOld::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviSecurityMasterOld::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityMasterOld", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityMasterOld::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityMasterOld", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityMasterOld::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SecurityMasterOld", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element SecurityMasterOld has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SecurityPassed"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviSecurityPassed::dp_tclSpmDpRnAiviSecurityPassed(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSecurityPassed,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviSecurityPassed::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SecurityPassed",(tS32) 0xc9685b90);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSecurityPassed = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviSecurityPassed::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SecurityPassed", (tS32)0xc9685b90);
   (tVoid)myDpElem.bFillData((tVoid*)&tSecurityPassed, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviSecurityPassed::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviSecurityPassed::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpRnAiviSecurityPassed::tGetData() {
   vUpdate();
   return tSecurityPassed;
};
tS32 dp_tclSpmDpRnAiviSecurityPassed::s32GetData(tBool& tSecurityPassedParam) { 
   vUpdate();
   tSecurityPassedParam = tSecurityPassed;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviSecurityPassed::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SecurityPassed", (tS32)0xc9685b90);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviSecurityPassed::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviSecurityPassed::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviSecurityPassed::s32SetData(tBool &tSecurityPassedParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityPassed,(tVoid*)&tSecurityPassedParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityPassedParam' in function 'dp_tclSpmDpRnAiviSecurityPassed::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpRnAiviSecurityPassed::s32SetData(const tBool &tSecurityPassedParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityPassed,(tVoid*)&tSecurityPassedParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityPassedParam' in function 'dp_tclSpmDpRnAiviSecurityPassed::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviSecurityPassed::u8GetData(tBool& tSecurityPassedParam) {  
   vUpdate();
   tSecurityPassedParam = tSecurityPassed;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviSecurityPassed::vSetData(tBool &tSecurityPassedParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityPassed,(tVoid*)&tSecurityPassedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSecurityPassedParam' in function 'dp_tclSpmDpRnAiviSecurityPassed::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpRnAiviSecurityPassed::vSetData(const tBool &tSecurityPassedParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityPassed,(tVoid*)&tSecurityPassedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSecurityPassedParam' in function 'dp_tclSpmDpRnAiviSecurityPassed::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpRnAiviSecurityPassed::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviSecurityPassed::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityPassed", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityPassed::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityPassed", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityPassed::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SecurityPassed", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element SecurityPassed has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SecurityAltCarCode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviSecurityAltCarCode::dp_tclSpmDpRnAiviSecurityAltCarCode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSecurityAltCarCode,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviSecurityAltCarCode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SecurityAltCarCode",(tS32) 0xb63ff10e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSecurityAltCarCode = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviSecurityAltCarCode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SecurityAltCarCode", (tS32)0xb63ff10e);
   (tVoid)myDpElem.bFillData((tVoid*)&tSecurityAltCarCode, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviSecurityAltCarCode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviSecurityAltCarCode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviSecurityAltCarCode::tGetData() {
   vUpdate();
   return tSecurityAltCarCode;
};
tS32 dp_tclSpmDpRnAiviSecurityAltCarCode::s32GetData(tU32& tSecurityAltCarCodeParam) { 
   vUpdate();
   tSecurityAltCarCodeParam = tSecurityAltCarCode;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviSecurityAltCarCode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SecurityAltCarCode", (tS32)0xb63ff10e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviSecurityAltCarCode::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviSecurityAltCarCode::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviSecurityAltCarCode::s32SetData(tU32 &tSecurityAltCarCodeParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityAltCarCode,(tVoid*)&tSecurityAltCarCodeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityAltCarCodeParam' in function 'dp_tclSpmDpRnAiviSecurityAltCarCode::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviSecurityAltCarCode::s32SetData(const tU32 &tSecurityAltCarCodeParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityAltCarCode,(tVoid*)&tSecurityAltCarCodeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityAltCarCodeParam' in function 'dp_tclSpmDpRnAiviSecurityAltCarCode::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviSecurityAltCarCode::u8GetData(tU32& tSecurityAltCarCodeParam) {  
   vUpdate();
   tSecurityAltCarCodeParam = tSecurityAltCarCode;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviSecurityAltCarCode::vSetData(tU32 &tSecurityAltCarCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityAltCarCode,(tVoid*)&tSecurityAltCarCodeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSecurityAltCarCodeParam' in function 'dp_tclSpmDpRnAiviSecurityAltCarCode::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviSecurityAltCarCode::vSetData(const tU32 &tSecurityAltCarCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityAltCarCode,(tVoid*)&tSecurityAltCarCodeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSecurityAltCarCodeParam' in function 'dp_tclSpmDpRnAiviSecurityAltCarCode::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviSecurityAltCarCode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviSecurityAltCarCode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityAltCarCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityAltCarCode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityAltCarCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityAltCarCode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SecurityAltCarCode", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element SecurityAltCarCode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SecurityACode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviSecurityACode::dp_tclSpmDpRnAiviSecurityACode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSecurityACode,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviSecurityACode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SecurityACode",(tS32) 0x2847de48);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSecurityACode = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviSecurityACode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SecurityACode", (tS32)0x2847de48);
   (tVoid)myDpElem.bFillData((tVoid*)&tSecurityACode, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviSecurityACode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviSecurityACode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpRnAiviSecurityACode::tGetData() {
   vUpdate();
   return tSecurityACode;
};
tS32 dp_tclSpmDpRnAiviSecurityACode::s32GetData(tU32& tSecurityACodeParam) { 
   vUpdate();
   tSecurityACodeParam = tSecurityACode;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviSecurityACode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SecurityACode", (tS32)0x2847de48);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviSecurityACode::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviSecurityACode::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviSecurityACode::s32SetData(tU32 &tSecurityACodeParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityACode,(tVoid*)&tSecurityACodeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityACodeParam' in function 'dp_tclSpmDpRnAiviSecurityACode::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpRnAiviSecurityACode::s32SetData(const tU32 &tSecurityACodeParam) {
   //init parameter
   (tVoid)memcpy(&tSecurityACode,(tVoid*)&tSecurityACodeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSecurityACodeParam' in function 'dp_tclSpmDpRnAiviSecurityACode::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviSecurityACode::u8GetData(tU32& tSecurityACodeParam) {  
   vUpdate();
   tSecurityACodeParam = tSecurityACode;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviSecurityACode::vSetData(tU32 &tSecurityACodeParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityACode,(tVoid*)&tSecurityACodeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSecurityACodeParam' in function 'dp_tclSpmDpRnAiviSecurityACode::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpRnAiviSecurityACode::vSetData(const tU32 &tSecurityACodeParam) { 
   //init parameter
   (tVoid)memcpy(&tSecurityACode,(tVoid*)&tSecurityACodeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSecurityACodeParam' in function 'dp_tclSpmDpRnAiviSecurityACode::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpRnAiviSecurityACode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviSecurityACode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityACode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityACode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "SecurityACode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviSecurityACode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SecurityACode", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element SecurityACode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WdtLowWithGetp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviWdtLowWithGetp::dp_tclSpmDpRnAiviWdtLowWithGetp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tWdtLowWithGetp,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviWdtLowWithGetp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("WdtLowWithGetp",(tS32) 0xf756bbdd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tWdtLowWithGetp = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviWdtLowWithGetp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("WdtLowWithGetp", (tS32)0xf756bbdd);
   (tVoid)myDpElem.bFillData((tVoid*)&tWdtLowWithGetp, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviWdtLowWithGetp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviWdtLowWithGetp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpRnAiviWdtLowWithGetp::tGetData() {
   vUpdate();
   return tWdtLowWithGetp;
};
tS32 dp_tclSpmDpRnAiviWdtLowWithGetp::s32GetData(tBool& tWdtLowWithGetpParam) { 
   vUpdate();
   tWdtLowWithGetpParam = tWdtLowWithGetp;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviWdtLowWithGetp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("WdtLowWithGetp", (tS32)0xf756bbdd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviWdtLowWithGetp::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviWdtLowWithGetp::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviWdtLowWithGetp::s32SetData(tBool &tWdtLowWithGetpParam) {
   //init parameter
   (tVoid)memcpy(&tWdtLowWithGetp,(tVoid*)&tWdtLowWithGetpParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tWdtLowWithGetpParam' in function 'dp_tclSpmDpRnAiviWdtLowWithGetp::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpRnAiviWdtLowWithGetp::s32SetData(const tBool &tWdtLowWithGetpParam) {
   //init parameter
   (tVoid)memcpy(&tWdtLowWithGetp,(tVoid*)&tWdtLowWithGetpParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tWdtLowWithGetpParam' in function 'dp_tclSpmDpRnAiviWdtLowWithGetp::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviWdtLowWithGetp::u8GetData(tBool& tWdtLowWithGetpParam) {  
   vUpdate();
   tWdtLowWithGetpParam = tWdtLowWithGetp;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviWdtLowWithGetp::vSetData(tBool &tWdtLowWithGetpParam) { 
   //init parameter
   (tVoid)memcpy(&tWdtLowWithGetp,(tVoid*)&tWdtLowWithGetpParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tWdtLowWithGetpParam' in function 'dp_tclSpmDpRnAiviWdtLowWithGetp::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpRnAiviWdtLowWithGetp::vSetData(const tBool &tWdtLowWithGetpParam) { 
   //init parameter
   (tVoid)memcpy(&tWdtLowWithGetp,(tVoid*)&tWdtLowWithGetpParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tWdtLowWithGetpParam' in function 'dp_tclSpmDpRnAiviWdtLowWithGetp::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpRnAiviWdtLowWithGetp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviWdtLowWithGetp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "WdtLowWithGetp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviWdtLowWithGetp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "WdtLowWithGetp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviWdtLowWithGetp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: WdtLowWithGetp", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element WdtLowWithGetp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentPowerPlatform"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpRnAiviCurrentPowerPlatform::dp_tclSpmDpRnAiviCurrentPowerPlatform(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentPowerPlatform,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpRnAiviCurrentPowerPlatform::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentPowerPlatform",(tS32) 0x483fdd71);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCurrentPowerPlatform = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpRnAiviCurrentPowerPlatform::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentPowerPlatform", (tS32)0x483fdd71);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentPowerPlatform, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpRnAiviCurrentPowerPlatform::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpRnAiviCurrentPowerPlatform::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpmDpRnAiviCurrentPowerPlatform::tGetData() {
   vUpdate();
   return tCurrentPowerPlatform;
};
tS32 dp_tclSpmDpRnAiviCurrentPowerPlatform::s32GetData(tU8& tCurrentPowerPlatformParam) { 
   vUpdate();
   tCurrentPowerPlatformParam = tCurrentPowerPlatform;
   return _s32Status;
}
tS32 dp_tclSpmDpRnAiviCurrentPowerPlatform::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentPowerPlatform", (tS32)0x483fdd71);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPRNAIVI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpRnAiviCurrentPowerPlatform::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpRnAiviCurrentPowerPlatform::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpRnAiviCurrentPowerPlatform::s32SetData(tU8 &tCurrentPowerPlatformParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentPowerPlatform,(tVoid*)&tCurrentPowerPlatformParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentPowerPlatformParam' in function 'dp_tclSpmDpRnAiviCurrentPowerPlatform::vSetData(tU8)' could be made const reference
tS32 dp_tclSpmDpRnAiviCurrentPowerPlatform::s32SetData(const tU8 &tCurrentPowerPlatformParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentPowerPlatform,(tVoid*)&tCurrentPowerPlatformParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentPowerPlatformParam' in function 'dp_tclSpmDpRnAiviCurrentPowerPlatform::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpRnAiviCurrentPowerPlatform::u8GetData(tU8& tCurrentPowerPlatformParam) {  
   vUpdate();
   tCurrentPowerPlatformParam = tCurrentPowerPlatform;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpRnAiviCurrentPowerPlatform::vSetData(tU8 &tCurrentPowerPlatformParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentPowerPlatform,(tVoid*)&tCurrentPowerPlatformParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCurrentPowerPlatformParam' in function 'dp_tclSpmDpRnAiviCurrentPowerPlatform::vSetData(tU8)' could be made const reference
tVoid dp_tclSpmDpRnAiviCurrentPowerPlatform::vSetData(const tU8 &tCurrentPowerPlatformParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentPowerPlatform,(tVoid*)&tCurrentPowerPlatformParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCurrentPowerPlatformParam' in function 'dp_tclSpmDpRnAiviCurrentPowerPlatform::vSetData(tU8)' could be made const reference
tU8   dp_tclSpmDpRnAiviCurrentPowerPlatform::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpRnAiviCurrentPowerPlatform::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "CurrentPowerPlatform", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviCurrentPowerPlatform::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPRNAIVI, "CurrentPowerPlatform", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpRnAiviCurrentPowerPlatform::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentPowerPlatform", DP_U32_POOL_ID_SPMDPRNAIVI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPRNAIVI);
   }
   else
   {
      fprintf(stdout,"Element CurrentPowerPlatform has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PowerPlatform"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpRnAiviPowerPlatform::dp_tclSpmDpRnAiviPowerPlatform() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPowerPlatform(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpRnAiviPowerPlatform::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("POWERPLATFORM",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPowerPlatform = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpRnAiviPowerPlatform::u8GetData(tU8& tPowerPlatformParam) {
   vUpdate();
   tPowerPlatformParam = tPowerPlatform;
   return _u8DataStatus;
}
tU8 dp_tclSpmDpRnAiviPowerPlatform::tGetData() {
   vUpdate();
   return tPowerPlatform;
};

tU8 dp_tclSpmDpRnAiviPowerPlatform::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpRnAiviPowerPlatform::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpRnAiviPowerPlatform::vSetData(tU8 &tPowerPlatformParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("POWERPLATFORM", tPowerPlatformParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviPowerPlatform::vSetData(const tU8 &tPowerPlatformParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("POWERPLATFORM", tPowerPlatformParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviPowerPlatform::operator<<(tU8 oParam) {return vSetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EnduringLowTimeout"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpRnAiviEnduringLowTimeout::dp_tclSpmDpRnAiviEnduringLowTimeout() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tEnduringLowTimeout(60000)
{
   vUpdate();
}

tVoid dp_tclSpmDpRnAiviEnduringLowTimeout::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("AIVI_LOW_SHUTD_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tEnduringLowTimeout = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpRnAiviEnduringLowTimeout::u8GetData(tU32& tEnduringLowTimeoutParam) {
   vUpdate();
   tEnduringLowTimeoutParam = tEnduringLowTimeout;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpRnAiviEnduringLowTimeout::tGetData() {
   vUpdate();
   return tEnduringLowTimeout;
};

tU8 dp_tclSpmDpRnAiviEnduringLowTimeout::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpRnAiviEnduringLowTimeout::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpRnAiviEnduringLowTimeout::vSetData(tU32 &tEnduringLowTimeoutParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("AIVI_LOW_SHUTD_TIME", tEnduringLowTimeoutParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviEnduringLowTimeout::vSetData(const tU32 &tEnduringLowTimeoutParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("AIVI_LOW_SHUTD_TIME", tEnduringLowTimeoutParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviEnduringLowTimeout::operator<<(tU32 oParam) {return vSetData(oParam);};


tU8 dp_tclSpmDpRnAiviProductionConfigId::u8GetData(tString &tProductionConfigIdParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOSCH_CONFIGURATION_ID", tProductionConfigIdParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclSpmDpRnAiviProductionConfigId::u8GetData(const tString &tProductionConfigIdParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOSCH_CONFIGURATION_ID", tProductionConfigIdParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclSpmDpRnAiviProductionConfigId::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclSpmDpRnAiviProductionConfigId::vSetData(tString &tProductionConfigIdParam) {
   tU32 u32Len = (tU32)strlen(tProductionConfigIdParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BOSCH_CONFIGURATION_ID", tProductionConfigIdParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviProductionConfigId::vSetData(const tString &tProductionConfigIdParam) {
   tU32 u32Len = (tU32)strlen(tProductionConfigIdParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BOSCH_CONFIGURATION_ID", tProductionConfigIdParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviProductionConfigId::vSetData(tString &tProductionConfigIdParam, tU16 u16Len) 
{
    vSetData(tProductionConfigIdParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclSpmDpRnAiviProductionConfigId::vSetData(const tString &tProductionConfigIdParam, tU16 u16Len) 
{
    vSetData(tProductionConfigIdParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclSpmDpRnAiviCustomerDefConfigId::u8GetData(tString &tCustomerDefConfigIdParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_DEFAULT_CONFIG_ID", tCustomerDefConfigIdParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclSpmDpRnAiviCustomerDefConfigId::u8GetData(const tString &tCustomerDefConfigIdParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_DEFAULT_CONFIG_ID", tCustomerDefConfigIdParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclSpmDpRnAiviCustomerDefConfigId::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclSpmDpRnAiviCustomerDefConfigId::vSetData(tString &tCustomerDefConfigIdParam) {
   tU32 u32Len = (tU32)strlen(tCustomerDefConfigIdParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("CUSTOMER_DEFAULT_CONFIG_ID", tCustomerDefConfigIdParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviCustomerDefConfigId::vSetData(const tString &tCustomerDefConfigIdParam) {
   tU32 u32Len = (tU32)strlen(tCustomerDefConfigIdParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("CUSTOMER_DEFAULT_CONFIG_ID", tCustomerDefConfigIdParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviCustomerDefConfigId::vSetData(tString &tCustomerDefConfigIdParam, tU16 u16Len) 
{
    vSetData(tCustomerDefConfigIdParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclSpmDpRnAiviCustomerDefConfigId::vSetData(const tString &tCustomerDefConfigIdParam, tU16 u16Len) 
{
    vSetData(tCustomerDefConfigIdParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclSpmDpRnAiviCustomerConfigId::u8GetData(tString &tCustomerConfigIdParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_CONFIG_FINGERPRINT", tCustomerConfigIdParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclSpmDpRnAiviCustomerConfigId::u8GetData(const tString &tCustomerConfigIdParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_CONFIG_FINGERPRINT", tCustomerConfigIdParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclSpmDpRnAiviCustomerConfigId::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclSpmDpRnAiviCustomerConfigId::vSetData(tString &tCustomerConfigIdParam) {
   tU32 u32Len = (tU32)strlen(tCustomerConfigIdParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("CUSTOMER_CONFIG_FINGERPRINT", tCustomerConfigIdParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviCustomerConfigId::vSetData(const tString &tCustomerConfigIdParam) {
   tU32 u32Len = (tU32)strlen(tCustomerConfigIdParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("CUSTOMER_CONFIG_FINGERPRINT", tCustomerConfigIdParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviCustomerConfigId::vSetData(tString &tCustomerConfigIdParam, tU16 u16Len) 
{
    vSetData(tCustomerConfigIdParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclSpmDpRnAiviCustomerConfigId::vSetData(const tString &tCustomerConfigIdParam, tU16 u16Len) 
{
    vSetData(tCustomerConfigIdParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NaviRegionCode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpRnAiviNaviRegionCode::dp_tclSpmDpRnAiviNaviRegionCode() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tNaviRegionCode(65535)
{
   vUpdate();
}

tVoid dp_tclSpmDpRnAiviNaviRegionCode::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("NAVI_REGION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tNaviRegionCode = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpRnAiviNaviRegionCode::u8GetData(tU16& tNaviRegionCodeParam) {
   vUpdate();
   tNaviRegionCodeParam = tNaviRegionCode;
   return _u8DataStatus;
}
tU16 dp_tclSpmDpRnAiviNaviRegionCode::tGetData() {
   vUpdate();
   return tNaviRegionCode;
};

tU8 dp_tclSpmDpRnAiviNaviRegionCode::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpRnAiviNaviRegionCode::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpRnAiviNaviRegionCode::vSetData(tU16 &tNaviRegionCodeParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("NAVI_REGION", tNaviRegionCodeParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviNaviRegionCode::vSetData(const tU16 &tNaviRegionCodeParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("NAVI_REGION", tNaviRegionCodeParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviNaviRegionCode::operator<<(tU16 oParam) {return vSetData(oParam);};


tU8 dp_tclSpmDpRnAiviBluetoothVersion::u8GetData(tString &tBluetoothVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("Bluetooth_SW_Version", tBluetoothVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclSpmDpRnAiviBluetoothVersion::u8GetData(const tString &tBluetoothVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("Bluetooth_SW_Version", tBluetoothVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclSpmDpRnAiviBluetoothVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclSpmDpRnAiviBluetoothVersion::vSetData(tString &tBluetoothVersionParam) {
   tU32 u32Len = (tU32)strlen(tBluetoothVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("Bluetooth_SW_Version", tBluetoothVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviBluetoothVersion::vSetData(const tString &tBluetoothVersionParam) {
   tU32 u32Len = (tU32)strlen(tBluetoothVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("Bluetooth_SW_Version", tBluetoothVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviBluetoothVersion::vSetData(tString &tBluetoothVersionParam, tU16 u16Len) 
{
    vSetData(tBluetoothVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclSpmDpRnAiviBluetoothVersion::vSetData(const tString &tBluetoothVersionParam, tU16 u16Len) 
{
    vSetData(tBluetoothVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UsbPortDisconnect"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpRnAiviUsbPortDisconnect::dp_tclSpmDpRnAiviUsbPortDisconnect() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tUsbPortDisconnect(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpRnAiviUsbPortDisconnect::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("USB_DISABLE_DISCONNECT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tUsbPortDisconnect = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpRnAiviUsbPortDisconnect::u8GetData(tU16& tUsbPortDisconnectParam) {
   vUpdate();
   tUsbPortDisconnectParam = tUsbPortDisconnect;
   return _u8DataStatus;
}
tU16 dp_tclSpmDpRnAiviUsbPortDisconnect::tGetData() {
   vUpdate();
   return tUsbPortDisconnect;
};

tU8 dp_tclSpmDpRnAiviUsbPortDisconnect::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpRnAiviUsbPortDisconnect::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpRnAiviUsbPortDisconnect::vSetData(tU16 &tUsbPortDisconnectParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("USB_DISABLE_DISCONNECT", tUsbPortDisconnectParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviUsbPortDisconnect::vSetData(const tU16 &tUsbPortDisconnectParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("USB_DISABLE_DISCONNECT", tUsbPortDisconnectParam)) {
      }
   }
   return;
}
tVoid dp_tclSpmDpRnAiviUsbPortDisconnect::operator<<(tU16 oParam) {return vSetData(oParam);};

