
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpPowOn.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PowerOnCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpPowOnPowerOnCount::dp_tclSpmDpPowOnPowerOnCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPowerOnCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpPowOnPowerOnCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PowerOnCount",(tS32) 0x3a464d23);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tPowerOnCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpPowOnPowerOnCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PowerOnCount", (tS32)0x3a464d23);
   (tVoid)myDpElem.bFillData((tVoid*)&tPowerOnCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpPowOnPowerOnCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpPowOnPowerOnCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpPowOnPowerOnCount::tGetData() {
   vUpdate();
   return tPowerOnCount;
};
tS32 dp_tclSpmDpPowOnPowerOnCount::s32GetData(tU32& tPowerOnCountParam) { 
   vUpdate();
   tPowerOnCountParam = tPowerOnCount;
   return _s32Status;
}
tS32 dp_tclSpmDpPowOnPowerOnCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PowerOnCount", (tS32)0x3a464d23);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpPowOnPowerOnCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpPowOnPowerOnCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpPowOnPowerOnCount::s32SetData(tU32 &tPowerOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tPowerOnCount,(tVoid*)&tPowerOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPowerOnCountParam' in function 'dp_tclSpmDpPowOnPowerOnCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpPowOnPowerOnCount::s32SetData(const tU32 &tPowerOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tPowerOnCount,(tVoid*)&tPowerOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPowerOnCountParam' in function 'dp_tclSpmDpPowOnPowerOnCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpPowOnPowerOnCount::u8GetData(tU32& tPowerOnCountParam) {  
   vUpdate();
   tPowerOnCountParam = tPowerOnCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpPowOnPowerOnCount::vSetData(tU32 &tPowerOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tPowerOnCount,(tVoid*)&tPowerOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPowerOnCountParam' in function 'dp_tclSpmDpPowOnPowerOnCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpPowOnPowerOnCount::vSetData(const tU32 &tPowerOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tPowerOnCount,(tVoid*)&tPowerOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPowerOnCountParam' in function 'dp_tclSpmDpPowOnPowerOnCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpPowOnPowerOnCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpPowOnPowerOnCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPPOWON, "PowerOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnPowerOnCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPPOWON, "PowerOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnPowerOnCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PowerOnCount", DP_U32_POOL_ID_SPMDPPOWON);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPPOWON);
   }
   else
   {
      fprintf(stdout,"Element PowerOnCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastSystemRunTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpPowOnLastSystemRunTime::dp_tclSpmDpPowOnLastSystemRunTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastSystemRunTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpPowOnLastSystemRunTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastSystemRunTime",(tS32) 0x1a2ee2a1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLastSystemRunTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpPowOnLastSystemRunTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastSystemRunTime", (tS32)0x1a2ee2a1);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastSystemRunTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpPowOnLastSystemRunTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpPowOnLastSystemRunTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpPowOnLastSystemRunTime::tGetData() {
   vUpdate();
   return tLastSystemRunTime;
};
tS32 dp_tclSpmDpPowOnLastSystemRunTime::s32GetData(tU32& tLastSystemRunTimeParam) { 
   vUpdate();
   tLastSystemRunTimeParam = tLastSystemRunTime;
   return _s32Status;
}
tS32 dp_tclSpmDpPowOnLastSystemRunTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastSystemRunTime", (tS32)0x1a2ee2a1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpPowOnLastSystemRunTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpPowOnLastSystemRunTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpPowOnLastSystemRunTime::s32SetData(tU32 &tLastSystemRunTimeParam) {
   //init parameter
   (tVoid)memcpy(&tLastSystemRunTime,(tVoid*)&tLastSystemRunTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnLastSystemRunTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpPowOnLastSystemRunTime::s32SetData(const tU32 &tLastSystemRunTimeParam) {
   //init parameter
   (tVoid)memcpy(&tLastSystemRunTime,(tVoid*)&tLastSystemRunTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnLastSystemRunTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpPowOnLastSystemRunTime::u8GetData(tU32& tLastSystemRunTimeParam) {  
   vUpdate();
   tLastSystemRunTimeParam = tLastSystemRunTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpPowOnLastSystemRunTime::vSetData(tU32 &tLastSystemRunTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tLastSystemRunTime,(tVoid*)&tLastSystemRunTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnLastSystemRunTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpPowOnLastSystemRunTime::vSetData(const tU32 &tLastSystemRunTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tLastSystemRunTime,(tVoid*)&tLastSystemRunTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnLastSystemRunTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpPowOnLastSystemRunTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpPowOnLastSystemRunTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPPOWON, "LastSystemRunTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnLastSystemRunTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPPOWON, "LastSystemRunTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnLastSystemRunTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastSystemRunTime", DP_U32_POOL_ID_SPMDPPOWON);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPPOWON);
   }
   else
   {
      fprintf(stdout,"Element LastSystemRunTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionPowerOnCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionPowerOnCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionPowerOnCount",(tS32) 0xd9225156L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentSWVersionPowerOnCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionPowerOnCount", (tS32)0xd9225156L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionPowerOnCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::tGetData() {
   vUpdate();
   return tCurrentSWVersionPowerOnCount;
};
tS32 dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::s32GetData(tU32& tCurrentSWVersionPowerOnCountParam) { 
   vUpdate();
   tCurrentSWVersionPowerOnCountParam = tCurrentSWVersionPowerOnCount;
   return _s32Status;
}
tS32 dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionPowerOnCount", (tS32)0xd9225156L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::s32SetData(tU32 &tCurrentSWVersionPowerOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionPowerOnCount,(tVoid*)&tCurrentSWVersionPowerOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionPowerOnCountParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::s32SetData(const tU32 &tCurrentSWVersionPowerOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionPowerOnCount,(tVoid*)&tCurrentSWVersionPowerOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionPowerOnCountParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::u8GetData(tU32& tCurrentSWVersionPowerOnCountParam) {  
   vUpdate();
   tCurrentSWVersionPowerOnCountParam = tCurrentSWVersionPowerOnCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vSetData(tU32 &tCurrentSWVersionPowerOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionPowerOnCount,(tVoid*)&tCurrentSWVersionPowerOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionPowerOnCountParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vSetData(const tU32 &tCurrentSWVersionPowerOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionPowerOnCount,(tVoid*)&tCurrentSWVersionPowerOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionPowerOnCountParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPPOWON, "CurrentSWVersionPowerOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPPOWON, "CurrentSWVersionPowerOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionPowerOnCount", DP_U32_POOL_ID_SPMDPPOWON);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPPOWON);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionPowerOnCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionLastSystemRunTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionLastSystemRunTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionLastSystemRunTime",(tS32) 0x4dee2530L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentSWVersionLastSystemRunTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionLastSystemRunTime", (tS32)0x4dee2530L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionLastSystemRunTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::tGetData() {
   vUpdate();
   return tCurrentSWVersionLastSystemRunTime;
};
tS32 dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::s32GetData(tU32& tCurrentSWVersionLastSystemRunTimeParam) { 
   vUpdate();
   tCurrentSWVersionLastSystemRunTimeParam = tCurrentSWVersionLastSystemRunTime;
   return _s32Status;
}
tS32 dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionLastSystemRunTime", (tS32)0x4dee2530L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPPOWON, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::s32SetData(tU32 &tCurrentSWVersionLastSystemRunTimeParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastSystemRunTime,(tVoid*)&tCurrentSWVersionLastSystemRunTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::s32SetData(const tU32 &tCurrentSWVersionLastSystemRunTimeParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastSystemRunTime,(tVoid*)&tCurrentSWVersionLastSystemRunTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::u8GetData(tU32& tCurrentSWVersionLastSystemRunTimeParam) {  
   vUpdate();
   tCurrentSWVersionLastSystemRunTimeParam = tCurrentSWVersionLastSystemRunTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vSetData(tU32 &tCurrentSWVersionLastSystemRunTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastSystemRunTime,(tVoid*)&tCurrentSWVersionLastSystemRunTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vSetData(const tU32 &tCurrentSWVersionLastSystemRunTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastSystemRunTime,(tVoid*)&tCurrentSWVersionLastSystemRunTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionLastSystemRunTimeParam' in function 'dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPPOWON, "CurrentSWVersionLastSystemRunTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPPOWON, "CurrentSWVersionLastSystemRunTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionLastSystemRunTime", DP_U32_POOL_ID_SPMDPPOWON);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPPOWON);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionLastSystemRunTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
