#ifndef _DP_FI_SPMDPFEATURE_H
#define _DP_FI_SPMDPFEATURE_H

extern tVoid vInitSpmDpFeature(tU8 u8Bank=DP_U8_NO_BANK_ACTION);





//lint -e750
#define SPM_S_IMPORT_INTERFACE_DP_SPM 
#include "spm_if.h"
//lint +e750




class dp_tclSpmDpFeatureFriendlyUser{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tFriendlyUser;
   
public:
   dp_tclSpmDpFeatureFriendlyUser(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpFeatureFriendlyUser() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tFriendlyUserParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tFriendlyUserParam);
   tS32  s32SetData(const tBool &tFriendlyUserParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tFriendlyUserParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tFriendlyUserParam);
   tVoid vSetData(const tBool& tFriendlyUserParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpFeatureHwIgnition{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tHwIgnition;
   
public:
   dp_tclSpmDpFeatureHwIgnition();
   virtual ~dp_tclSpmDpFeatureHwIgnition(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tHwIgnitionParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpFeatureDevelopEarlyFunc{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tDevelopEarlyFunc;
   
public:
   dp_tclSpmDpFeatureDevelopEarlyFunc(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpFeatureDevelopEarlyFunc() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tDevelopEarlyFuncParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tDevelopEarlyFuncParam);
   tS32  s32SetData(const tBool &tDevelopEarlyFuncParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tDevelopEarlyFuncParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tDevelopEarlyFuncParam);
   tVoid vSetData(const tBool& tDevelopEarlyFuncParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpFeatureDisableHwWatchdog{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tDisableHwWatchdog;
   
public:
   dp_tclSpmDpFeatureDisableHwWatchdog();
   virtual ~dp_tclSpmDpFeatureDisableHwWatchdog(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tDisableHwWatchdogParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpFeatureDisableSupervision{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDisableSupervision;
   
public:
   dp_tclSpmDpFeatureDisableSupervision(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpFeatureDisableSupervision() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDisableSupervisionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDisableSupervisionParam);
   tS32  s32SetData(const tU8 &tDisableSupervisionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDisableSupervisionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDisableSupervisionParam);
   tVoid vSetData(const tU8& tDisableSupervisionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
