
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpFeature.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FriendlyUser"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpFeatureFriendlyUser::dp_tclSpmDpFeatureFriendlyUser(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFriendlyUser,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpFeatureFriendlyUser::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FriendlyUser",(tS32) 0x1d4a2148);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tFriendlyUser = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpFeatureFriendlyUser::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FriendlyUser", (tS32)0x1d4a2148);
   (tVoid)myDpElem.bFillData((tVoid*)&tFriendlyUser, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpFeatureFriendlyUser::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpFeatureFriendlyUser::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpFeatureFriendlyUser::tGetData() {
   vUpdate();
   return tFriendlyUser;
};
tS32 dp_tclSpmDpFeatureFriendlyUser::s32GetData(tBool& tFriendlyUserParam) { 
   vUpdate();
   tFriendlyUserParam = tFriendlyUser;
   return _s32Status;
}
tS32 dp_tclSpmDpFeatureFriendlyUser::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FriendlyUser", (tS32)0x1d4a2148);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpFeatureFriendlyUser::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpFeatureFriendlyUser::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpFeatureFriendlyUser::s32SetData(tBool &tFriendlyUserParam) {
   //init parameter
   (tVoid)memcpy(&tFriendlyUser,(tVoid*)&tFriendlyUserParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFriendlyUserParam' in function 'dp_tclSpmDpFeatureFriendlyUser::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpFeatureFriendlyUser::s32SetData(const tBool &tFriendlyUserParam) {
   //init parameter
   (tVoid)memcpy(&tFriendlyUser,(tVoid*)&tFriendlyUserParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFriendlyUserParam' in function 'dp_tclSpmDpFeatureFriendlyUser::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpFeatureFriendlyUser::u8GetData(tBool& tFriendlyUserParam) {  
   vUpdate();
   tFriendlyUserParam = tFriendlyUser;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpFeatureFriendlyUser::vSetData(tBool &tFriendlyUserParam) { 
   //init parameter
   (tVoid)memcpy(&tFriendlyUser,(tVoid*)&tFriendlyUserParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tFriendlyUserParam' in function 'dp_tclSpmDpFeatureFriendlyUser::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpFeatureFriendlyUser::vSetData(const tBool &tFriendlyUserParam) { 
   //init parameter
   (tVoid)memcpy(&tFriendlyUser,(tVoid*)&tFriendlyUserParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tFriendlyUserParam' in function 'dp_tclSpmDpFeatureFriendlyUser::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpFeatureFriendlyUser::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpFeatureFriendlyUser::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPFEATURE, "FriendlyUser", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpFeatureFriendlyUser::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPFEATURE, "FriendlyUser", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpFeatureFriendlyUser::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FriendlyUser", DP_U32_POOL_ID_SPMDPFEATURE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPFEATURE);
   }
   else
   {
      fprintf(stdout,"Element FriendlyUser has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HwIgnition"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpFeatureHwIgnition::dp_tclSpmDpFeatureHwIgnition() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tHwIgnition(1)
{
   vUpdate();
}

tVoid dp_tclSpmDpFeatureHwIgnition::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HW_IGNITION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tHwIgnition = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpFeatureHwIgnition::u8GetData(tU32& tHwIgnitionParam) {
   vUpdate();
   tHwIgnitionParam = tHwIgnition;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpFeatureHwIgnition::tGetData() {
   vUpdate();
   return tHwIgnition;
};

tU8 dp_tclSpmDpFeatureHwIgnition::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpFeatureHwIgnition::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DevelopEarlyFunc"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpFeatureDevelopEarlyFunc::dp_tclSpmDpFeatureDevelopEarlyFunc(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDevelopEarlyFunc,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpFeatureDevelopEarlyFunc::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DevelopEarlyFunc",(tS32) 0x84662204);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tDevelopEarlyFunc = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpFeatureDevelopEarlyFunc::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DevelopEarlyFunc", (tS32)0x84662204);
   (tVoid)myDpElem.bFillData((tVoid*)&tDevelopEarlyFunc, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpFeatureDevelopEarlyFunc::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpFeatureDevelopEarlyFunc::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpFeatureDevelopEarlyFunc::tGetData() {
   vUpdate();
   return tDevelopEarlyFunc;
};
tS32 dp_tclSpmDpFeatureDevelopEarlyFunc::s32GetData(tBool& tDevelopEarlyFuncParam) { 
   vUpdate();
   tDevelopEarlyFuncParam = tDevelopEarlyFunc;
   return _s32Status;
}
tS32 dp_tclSpmDpFeatureDevelopEarlyFunc::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DevelopEarlyFunc", (tS32)0x84662204);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpFeatureDevelopEarlyFunc::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpFeatureDevelopEarlyFunc::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpFeatureDevelopEarlyFunc::s32SetData(tBool &tDevelopEarlyFuncParam) {
   //init parameter
   (tVoid)memcpy(&tDevelopEarlyFunc,(tVoid*)&tDevelopEarlyFuncParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDevelopEarlyFuncParam' in function 'dp_tclSpmDpFeatureDevelopEarlyFunc::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpFeatureDevelopEarlyFunc::s32SetData(const tBool &tDevelopEarlyFuncParam) {
   //init parameter
   (tVoid)memcpy(&tDevelopEarlyFunc,(tVoid*)&tDevelopEarlyFuncParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDevelopEarlyFuncParam' in function 'dp_tclSpmDpFeatureDevelopEarlyFunc::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpFeatureDevelopEarlyFunc::u8GetData(tBool& tDevelopEarlyFuncParam) {  
   vUpdate();
   tDevelopEarlyFuncParam = tDevelopEarlyFunc;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpFeatureDevelopEarlyFunc::vSetData(tBool &tDevelopEarlyFuncParam) { 
   //init parameter
   (tVoid)memcpy(&tDevelopEarlyFunc,(tVoid*)&tDevelopEarlyFuncParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDevelopEarlyFuncParam' in function 'dp_tclSpmDpFeatureDevelopEarlyFunc::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpFeatureDevelopEarlyFunc::vSetData(const tBool &tDevelopEarlyFuncParam) { 
   //init parameter
   (tVoid)memcpy(&tDevelopEarlyFunc,(tVoid*)&tDevelopEarlyFuncParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDevelopEarlyFuncParam' in function 'dp_tclSpmDpFeatureDevelopEarlyFunc::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpFeatureDevelopEarlyFunc::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpFeatureDevelopEarlyFunc::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPFEATURE, "DevelopEarlyFunc", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpFeatureDevelopEarlyFunc::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPFEATURE, "DevelopEarlyFunc", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpFeatureDevelopEarlyFunc::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DevelopEarlyFunc", DP_U32_POOL_ID_SPMDPFEATURE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPFEATURE);
   }
   else
   {
      fprintf(stdout,"Element DevelopEarlyFunc has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DisableHwWatchdog"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpFeatureDisableHwWatchdog::dp_tclSpmDpFeatureDisableHwWatchdog() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDisableHwWatchdog(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpFeatureDisableHwWatchdog::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DISABLE_WDT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDisableHwWatchdog = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpFeatureDisableHwWatchdog::u8GetData(tU32& tDisableHwWatchdogParam) {
   vUpdate();
   tDisableHwWatchdogParam = tDisableHwWatchdog;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpFeatureDisableHwWatchdog::tGetData() {
   vUpdate();
   return tDisableHwWatchdog;
};

tU8 dp_tclSpmDpFeatureDisableHwWatchdog::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpFeatureDisableHwWatchdog::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DisableSupervision"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpFeatureDisableSupervision::dp_tclSpmDpFeatureDisableSupervision(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDisableSupervision,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpFeatureDisableSupervision::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DisableSupervision",(tS32) 0xf0bc9f63);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDisableSupervision = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpFeatureDisableSupervision::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DisableSupervision", (tS32)0xf0bc9f63);
   (tVoid)myDpElem.bFillData((tVoid*)&tDisableSupervision, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpFeatureDisableSupervision::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpFeatureDisableSupervision::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpmDpFeatureDisableSupervision::tGetData() {
   vUpdate();
   return tDisableSupervision;
};
tS32 dp_tclSpmDpFeatureDisableSupervision::s32GetData(tU8& tDisableSupervisionParam) { 
   vUpdate();
   tDisableSupervisionParam = tDisableSupervision;
   return _s32Status;
}
tS32 dp_tclSpmDpFeatureDisableSupervision::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DisableSupervision", (tS32)0xf0bc9f63);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPFEATURE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpFeatureDisableSupervision::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpFeatureDisableSupervision::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpFeatureDisableSupervision::s32SetData(tU8 &tDisableSupervisionParam) {
   //init parameter
   (tVoid)memcpy(&tDisableSupervision,(tVoid*)&tDisableSupervisionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDisableSupervisionParam' in function 'dp_tclSpmDpFeatureDisableSupervision::vSetData(tU8)' could be made const reference
tS32 dp_tclSpmDpFeatureDisableSupervision::s32SetData(const tU8 &tDisableSupervisionParam) {
   //init parameter
   (tVoid)memcpy(&tDisableSupervision,(tVoid*)&tDisableSupervisionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDisableSupervisionParam' in function 'dp_tclSpmDpFeatureDisableSupervision::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpFeatureDisableSupervision::u8GetData(tU8& tDisableSupervisionParam) {  
   vUpdate();
   tDisableSupervisionParam = tDisableSupervision;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpFeatureDisableSupervision::vSetData(tU8 &tDisableSupervisionParam) { 
   //init parameter
   (tVoid)memcpy(&tDisableSupervision,(tVoid*)&tDisableSupervisionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDisableSupervisionParam' in function 'dp_tclSpmDpFeatureDisableSupervision::vSetData(tU8)' could be made const reference
tVoid dp_tclSpmDpFeatureDisableSupervision::vSetData(const tU8 &tDisableSupervisionParam) { 
   //init parameter
   (tVoid)memcpy(&tDisableSupervision,(tVoid*)&tDisableSupervisionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDisableSupervisionParam' in function 'dp_tclSpmDpFeatureDisableSupervision::vSetData(tU8)' could be made const reference
tU8   dp_tclSpmDpFeatureDisableSupervision::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpFeatureDisableSupervision::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPFEATURE, "DisableSupervision", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpFeatureDisableSupervision::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPFEATURE, "DisableSupervision", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpFeatureDisableSupervision::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DisableSupervision", DP_U32_POOL_ID_SPMDPFEATURE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPFEATURE);
   }
   else
   {
      fprintf(stdout,"Element DisableSupervision has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
