#ifndef _DP_FI_SPMDPENGSTATE_H
#define _DP_FI_SPMDPENGSTATE_H

extern tVoid vInitSpmDpEngState(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define SPM_S_IMPORT_INTERFACE_DP_SPM 
#include "spm_if.h"
//lint +e750



#define SYSTEM_S_IMPORT_INTERFACE_DEQUE
#include "stl_pif.h"


class dp_tclSpmDpEngStateHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListHistory;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateHistoryStack01{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListHistoryStack01;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListHistoryStack01;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHistoryStack01 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateHistoryStack01(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateHistoryStack01() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateHistoryStack02{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListHistoryStack02;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListHistoryStack02;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHistoryStack02 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateHistoryStack02(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateHistoryStack02() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateHistoryStack03{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListHistoryStack03;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListHistoryStack03;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHistoryStack03 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateHistoryStack03(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateHistoryStack03() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateHistoryStack04{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListHistoryStack04;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListHistoryStack04;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHistoryStack04 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateHistoryStack04(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateHistoryStack04() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateHistoryStack05{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListHistoryStack05;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListHistoryStack05;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHistoryStack05 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateHistoryStack05(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateHistoryStack05() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateLastHistoryStack{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tLastHistoryStack;
   
public:
   dp_tclSpmDpEngStateLastHistoryStack(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngStateLastHistoryStack() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tLastHistoryStackParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tLastHistoryStackParam);
   tS32  s32SetData(const tU32 &tLastHistoryStackParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tLastHistoryStackParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tLastHistoryStackParam);
   tVoid vSetData(const tU32& tLastHistoryStackParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngStateCurrentSWVersionHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistory;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateCurrentSWVersionHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateCurrentSWVersionHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack01;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack01;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionHistoryStack01 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack02;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack02;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionHistoryStack02 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack03;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack03;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionHistoryStack03 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack04;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack04;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionHistoryStack04 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack05;
    #else
    typedef std::deque<TSpmSystemStateStatisticsData> TListCurrentSWVersionHistoryStack05;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionHistoryStack05 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSystemStateStatisticsData &tElem);
    tVoid vPushBack(const TSpmSystemStateStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCurrentSWVersionLastHistoryStack;
   
public:
   dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCurrentSWVersionLastHistoryStackParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCurrentSWVersionLastHistoryStackParam);
   tS32  s32SetData(const tU32 &tCurrentSWVersionLastHistoryStackParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCurrentSWVersionLastHistoryStackParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCurrentSWVersionLastHistoryStackParam);
   tVoid vSetData(const tU32& tCurrentSWVersionLastHistoryStackParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
