#ifndef _DP_FI_SPMDPENGDATA_H
#define _DP_FI_SPMDPENGDATA_H

extern tVoid vInitSpmDpEngData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define SPM_S_IMPORT_INTERFACE_DP_SPM 
#include "spm_if.h"
//lint +e750



#define SYSTEM_S_IMPORT_INTERFACE_DEQUE
#include "stl_pif.h"


class dp_tclSpmDpEngDataResetStatistic{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmResetStatisticsData tResetStatistic;
   
public:
   dp_tclSpmDpEngDataResetStatistic(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataResetStatistic() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmResetStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmResetStatisticsData& tResetStatisticParam);
   tVoid operator>>(TSpmResetStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmResetStatisticsData &tResetStatisticParam);
   tS32  s32SetData(const TSpmResetStatisticsData &tResetStatisticParam);
   tVoid operator<<(TSpmResetStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmResetStatisticsData& tResetStatisticParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmResetStatisticsData& tResetStatisticParam);
   tVoid vSetData(const TSpmResetStatisticsData& tResetStatisticParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataResetHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmResetElem> TListResetHistory;
    #else
    typedef std::deque<TSpmResetElem> TListResetHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListResetHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataResetHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataResetHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmResetElem& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmResetElem &tElem);
    tVoid vPushBack(const TSpmResetElem &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataResetCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tResetCount;
   
public:
   dp_tclSpmDpEngDataResetCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataResetCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tResetCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tResetCountParam);
   tS32  s32SetData(const tU32 &tResetCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tResetCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tResetCountParam);
   tVoid vSetData(const tU32& tResetCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataStatisticEng{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSubStatesStatisticsData tStatisticEng;
   
public:
   dp_tclSpmDpEngDataStatisticEng(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataStatisticEng() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSubStatesStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSubStatesStatisticsData& tStatisticEngParam);
   tVoid operator>>(TSpmSubStatesStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSubStatesStatisticsData &tStatisticEngParam);
   tS32  s32SetData(const TSpmSubStatesStatisticsData &tStatisticEngParam);
   tVoid operator<<(TSpmSubStatesStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSubStatesStatisticsData& tStatisticEngParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSubStatesStatisticsData& tStatisticEngParam);
   tVoid vSetData(const TSpmSubStatesStatisticsData& tStatisticEngParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataTpHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<tU32> TListTpHistory;
    #else
    typedef std::deque<tU32> TListTpHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListTpHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataTpHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataTpHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, tU32& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(tU32 &tElem);
    tVoid vPushBack(const tU32 &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataWupHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmWakeupStatisticsData> TListWupHistory;
    #else
    typedef std::deque<TSpmWakeupStatisticsData> TListWupHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListWupHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataWupHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataWupHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmWakeupStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmWakeupStatisticsData &tElem);
    tVoid vPushBack(const TSpmWakeupStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataSwitchOnHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSwitchOnStatisticsData> TListSwitchOnHistory;
    #else
    typedef std::deque<TSpmSwitchOnStatisticsData> TListSwitchOnHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListSwitchOnHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataSwitchOnHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataSwitchOnHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSwitchOnStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSwitchOnStatisticsData &tElem);
    tVoid vPushBack(const TSpmSwitchOnStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataDeviceWakeupCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDeviceWakeupCount;
   
public:
   dp_tclSpmDpEngDataDeviceWakeupCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataDeviceWakeupCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDeviceWakeupCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDeviceWakeupCountParam);
   tS32  s32SetData(const tU32 &tDeviceWakeupCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDeviceWakeupCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDeviceWakeupCountParam);
   tVoid vSetData(const tU32& tDeviceWakeupCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataDeviceOnCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDeviceOnCount;
   
public:
   dp_tclSpmDpEngDataDeviceOnCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataDeviceOnCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDeviceOnCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDeviceOnCountParam);
   tS32  s32SetData(const tU32 &tDeviceOnCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDeviceOnCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDeviceOnCountParam);
   tVoid vSetData(const tU32& tDeviceOnCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataVoltageRangeHistogram{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmVoltageHistogramRangeStatisticsData> TListVoltageRangeHistogram;
    #else
    typedef std::deque<TSpmVoltageHistogramRangeStatisticsData> TListVoltageRangeHistogram;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListVoltageRangeHistogram _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataVoltageRangeHistogram(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataVoltageRangeHistogram() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmVoltageHistogramRangeStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmVoltageHistogramRangeStatisticsData &tElem);
    tVoid vPushBack(const TSpmVoltageHistogramRangeStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataCpuUsageStatistics{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSystemLoadStatisticsData tCpuUsageStatistics;
   
public:
   dp_tclSpmDpEngDataCpuUsageStatistics(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCpuUsageStatistics() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSystemLoadStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSystemLoadStatisticsData& tCpuUsageStatisticsParam);
   tVoid operator>>(TSpmSystemLoadStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSystemLoadStatisticsData &tCpuUsageStatisticsParam);
   tS32  s32SetData(const TSpmSystemLoadStatisticsData &tCpuUsageStatisticsParam);
   tVoid operator<<(TSpmSystemLoadStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSystemLoadStatisticsData& tCpuUsageStatisticsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSystemLoadStatisticsData& tCpuUsageStatisticsParam);
   tVoid vSetData(const TSpmSystemLoadStatisticsData& tCpuUsageStatisticsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataRamUsageStatistics{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSystemLoadStatisticsData tRamUsageStatistics;
   
public:
   dp_tclSpmDpEngDataRamUsageStatistics(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataRamUsageStatistics() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSystemLoadStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSystemLoadStatisticsData& tRamUsageStatisticsParam);
   tVoid operator>>(TSpmSystemLoadStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSystemLoadStatisticsData &tRamUsageStatisticsParam);
   tS32  s32SetData(const TSpmSystemLoadStatisticsData &tRamUsageStatisticsParam);
   tVoid operator<<(TSpmSystemLoadStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSystemLoadStatisticsData& tRamUsageStatisticsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSystemLoadStatisticsData& tRamUsageStatisticsParam);
   tVoid vSetData(const TSpmSystemLoadStatisticsData& tRamUsageStatisticsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataStartupTimeStatistics{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSystemLoadStatisticsData tStartupTimeStatistics;
   
public:
   dp_tclSpmDpEngDataStartupTimeStatistics(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataStartupTimeStatistics() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSystemLoadStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSystemLoadStatisticsData& tStartupTimeStatisticsParam);
   tVoid operator>>(TSpmSystemLoadStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSystemLoadStatisticsData &tStartupTimeStatisticsParam);
   tS32  s32SetData(const TSpmSystemLoadStatisticsData &tStartupTimeStatisticsParam);
   tVoid operator<<(TSpmSystemLoadStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSystemLoadStatisticsData& tStartupTimeStatisticsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSystemLoadStatisticsData& tStartupTimeStatisticsParam);
   tVoid vSetData(const TSpmSystemLoadStatisticsData& tStartupTimeStatisticsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSystemLoadStatisticsData tCurrentSWVersionCpuUsageStatistics;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSystemLoadStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionCpuUsageStatisticsParam);
   tVoid operator>>(TSpmSystemLoadStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionCpuUsageStatisticsParam);
   tS32  s32SetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionCpuUsageStatisticsParam);
   tVoid operator<<(TSpmSystemLoadStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionCpuUsageStatisticsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionCpuUsageStatisticsParam);
   tVoid vSetData(const TSpmSystemLoadStatisticsData& tCurrentSWVersionCpuUsageStatisticsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSystemLoadStatisticsData tCurrentSWVersionRamUsageStatistics;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSystemLoadStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionRamUsageStatisticsParam);
   tVoid operator>>(TSpmSystemLoadStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionRamUsageStatisticsParam);
   tS32  s32SetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionRamUsageStatisticsParam);
   tVoid operator<<(TSpmSystemLoadStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionRamUsageStatisticsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionRamUsageStatisticsParam);
   tVoid vSetData(const TSpmSystemLoadStatisticsData& tCurrentSWVersionRamUsageStatisticsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSystemLoadStatisticsData tCurrentSWVersionStartupTimeStatistics;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSystemLoadStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionStartupTimeStatisticsParam);
   tVoid operator>>(TSpmSystemLoadStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionStartupTimeStatisticsParam);
   tS32  s32SetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionStartupTimeStatisticsParam);
   tVoid operator<<(TSpmSystemLoadStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionStartupTimeStatisticsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionStartupTimeStatisticsParam);
   tVoid vSetData(const TSpmSystemLoadStatisticsData& tCurrentSWVersionStartupTimeStatisticsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersionResetStatistic{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmResetStatisticsData tCurrentSWVersionResetStatistic;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersionResetStatistic(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersionResetStatistic() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmResetStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmResetStatisticsData& tCurrentSWVersionResetStatisticParam);
   tVoid operator>>(TSpmResetStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmResetStatisticsData &tCurrentSWVersionResetStatisticParam);
   tS32  s32SetData(const TSpmResetStatisticsData &tCurrentSWVersionResetStatisticParam);
   tVoid operator<<(TSpmResetStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmResetStatisticsData& tCurrentSWVersionResetStatisticParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmResetStatisticsData& tCurrentSWVersionResetStatisticParam);
   tVoid vSetData(const TSpmResetStatisticsData& tCurrentSWVersionResetStatisticParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersionResetHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmResetElem> TListCurrentSWVersionResetHistory;
    #else
    typedef std::deque<TSpmResetElem> TListCurrentSWVersionResetHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionResetHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataCurrentSWVersionResetHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataCurrentSWVersionResetHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmResetElem& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmResetElem &tElem);
    tVoid vPushBack(const TSpmResetElem &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataCurrentSWVersionWupHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmWakeupStatisticsData> TListCurrentSWVersionWupHistory;
    #else
    typedef std::deque<TSpmWakeupStatisticsData> TListCurrentSWVersionWupHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWVersionWupHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataCurrentSWVersionWupHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataCurrentSWVersionWupHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmWakeupStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmWakeupStatisticsData &tElem);
    tVoid vPushBack(const TSpmWakeupStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCurrentSWVersionDeviceWakeupCount;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCurrentSWVersionDeviceWakeupCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCurrentSWVersionDeviceWakeupCountParam);
   tS32  s32SetData(const tU32 &tCurrentSWVersionDeviceWakeupCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCurrentSWVersionDeviceWakeupCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCurrentSWVersionDeviceWakeupCountParam);
   tVoid vSetData(const tU32& tCurrentSWVersionDeviceWakeupCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSubStatesStatisticsData tCurrentSWVersionSubStatesStatisticEng;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSubStatesStatisticsData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSubStatesStatisticsData& tCurrentSWVersionSubStatesStatisticEngParam);
   tVoid operator>>(TSpmSubStatesStatisticsData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSubStatesStatisticsData &tCurrentSWVersionSubStatesStatisticEngParam);
   tS32  s32SetData(const TSpmSubStatesStatisticsData &tCurrentSWVersionSubStatesStatisticEngParam);
   tVoid operator<<(TSpmSubStatesStatisticsData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSubStatesStatisticsData& tCurrentSWVersionSubStatesStatisticEngParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSubStatesStatisticsData& tCurrentSWVersionSubStatesStatisticEngParam);
   tVoid vSetData(const TSpmSubStatesStatisticsData& tCurrentSWVersionSubStatesStatisticEngParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataSoftwareVersionStatistics0{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSoftwareVersionStatisticsData> TListSoftwareVersionStatistics0;
    #else
    typedef std::deque<TSpmSoftwareVersionStatisticsData> TListSoftwareVersionStatistics0;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListSoftwareVersionStatistics0 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataSoftwareVersionStatistics0(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataSoftwareVersionStatistics0() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSoftwareVersionStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSoftwareVersionStatisticsData &tElem);
    tVoid vPushBack(const TSpmSoftwareVersionStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataSoftwareVersionStatistics1{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSoftwareVersionStatisticsData> TListSoftwareVersionStatistics1;
    #else
    typedef std::deque<TSpmSoftwareVersionStatisticsData> TListSoftwareVersionStatistics1;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListSoftwareVersionStatistics1 _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataSoftwareVersionStatistics1(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataSoftwareVersionStatistics1() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSoftwareVersionStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSoftwareVersionStatisticsData &tElem);
    tVoid vPushBack(const TSpmSoftwareVersionStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpEngDataSWVersionUpdateCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSWVersionUpdateCount;
   
public:
   dp_tclSpmDpEngDataSWVersionUpdateCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataSWVersionUpdateCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSWVersionUpdateCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSWVersionUpdateCountParam);
   tS32  s32SetData(const tU32 &tSWVersionUpdateCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSWVersionUpdateCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSWVersionUpdateCountParam);
   tVoid vSetData(const tU32& tSWVersionUpdateCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSpmSoftwareVersion tCurrentSWVersion;
   
public:
   dp_tclSpmDpEngDataCurrentSWVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSpmSoftwareVersion tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSpmSoftwareVersion& tCurrentSWVersionParam);
   tVoid operator>>(TSpmSoftwareVersion& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSpmSoftwareVersion &tCurrentSWVersionParam);
   tS32  s32SetData(const TSpmSoftwareVersion &tCurrentSWVersionParam);
   tVoid operator<<(TSpmSoftwareVersion oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSpmSoftwareVersion& tCurrentSWVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSpmSoftwareVersion& tCurrentSWVersionParam);
   tVoid vSetData(const TSpmSoftwareVersion& tCurrentSWVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWDeviceOnCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCurrentSWDeviceOnCount;
   
public:
   dp_tclSpmDpEngDataCurrentSWDeviceOnCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpEngDataCurrentSWDeviceOnCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCurrentSWDeviceOnCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCurrentSWDeviceOnCountParam);
   tS32  s32SetData(const tU32 &tCurrentSWDeviceOnCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCurrentSWDeviceOnCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCurrentSWDeviceOnCountParam);
   tVoid vSetData(const tU32& tCurrentSWDeviceOnCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpEngDataCurrentSWSwitchOnHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TSpmSwitchOnStatisticsData> TListCurrentSWSwitchOnHistory;
    #else
    typedef std::deque<TSpmSwitchOnStatisticsData> TListCurrentSWSwitchOnHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCurrentSWSwitchOnHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpEngDataCurrentSWSwitchOnHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpEngDataCurrentSWSwitchOnHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TSpmSwitchOnStatisticsData& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TSpmSwitchOnStatisticsData &tElem);
    tVoid vPushBack(const TSpmSwitchOnStatisticsData &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

#endif
