
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpEngData.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ResetStatistic"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataResetStatistic::dp_tclSpmDpEngDataResetStatistic(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tResetStatistic,0,sizeof(TSpmResetStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataResetStatistic::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ResetStatistic",(tS32) 0xa59b31ff);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmResetStatisticsData)) 
      {
         tResetStatistic = *((TSpmResetStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataResetStatistic::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ResetStatistic", (tS32)0xa59b31ff);
   (tVoid)myDpElem.bFillData((tVoid*)&tResetStatistic, (tU32)sizeof(TSpmResetStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataResetStatistic::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataResetStatistic::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmResetStatisticsData dp_tclSpmDpEngDataResetStatistic::tGetData() {
   vUpdate();
   return tResetStatistic;
};
tS32 dp_tclSpmDpEngDataResetStatistic::s32GetData(TSpmResetStatisticsData& tResetStatisticParam) { 
   vUpdate();
   tResetStatisticParam = tResetStatistic;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataResetStatistic::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ResetStatistic", (tS32)0xa59b31ff);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataResetStatistic::operator>>(TSpmResetStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataResetStatistic::operator<<(TSpmResetStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataResetStatistic::s32SetData(TSpmResetStatisticsData &tResetStatisticParam) {
   //init parameter
   (tVoid)memcpy(&tResetStatistic,(tVoid*)&tResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tResetStatisticParam' in function 'dp_tclSpmDpEngDataResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataResetStatistic::s32SetData(const TSpmResetStatisticsData &tResetStatisticParam) {
   //init parameter
   (tVoid)memcpy(&tResetStatistic,(tVoid*)&tResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tResetStatisticParam' in function 'dp_tclSpmDpEngDataResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataResetStatistic::u8GetData(TSpmResetStatisticsData& tResetStatisticParam) {  
   vUpdate();
   tResetStatisticParam = tResetStatistic;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataResetStatistic::vSetData(TSpmResetStatisticsData &tResetStatisticParam) { 
   //init parameter
   (tVoid)memcpy(&tResetStatistic,(tVoid*)&tResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
}//lint !e1746: parameter 'tResetStatisticParam' in function 'dp_tclSpmDpEngDataResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataResetStatistic::vSetData(const TSpmResetStatisticsData &tResetStatisticParam) { 
   //init parameter
   (tVoid)memcpy(&tResetStatistic,(tVoid*)&tResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
}//lint !e1746: parameter 'tResetStatisticParam' in function 'dp_tclSpmDpEngDataResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataResetStatistic::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataResetStatistic::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "ResetStatistic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataResetStatistic::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "ResetStatistic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataResetStatistic::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ResetStatistic", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element ResetStatistic has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ResetHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataResetHistory::dp_tclSpmDpEngDataResetHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 20;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataResetHistory::vStore() {
    dp_tclBaseElement myDpElem("ResetHistory", (tS32)0x39d008c5);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmResetElem)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListResetHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmResetElem));
                pCurPos += sizeof(TSpmResetElem);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmResetElem))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataResetHistory::vUpdate() {
   dp_tclBaseElement myDpElem("ResetHistory", (tS32)0x39d008c5);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmResetElem)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmResetElem));
         TSpmResetElem* pBuffer = (TSpmResetElem*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataResetHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataResetHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataResetHistory::s32GetElem(tU32 u32NbElem, TSpmResetElem& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataResetHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataResetHistory::vPushBack(TSpmResetElem &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataResetHistory::vPushBack(const TSpmResetElem &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataResetHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataResetHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "ResetHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataResetHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "ResetHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataResetHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ResetHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element ResetHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ResetCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataResetCount::dp_tclSpmDpEngDataResetCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tResetCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataResetCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ResetCount",(tS32) 0xc8d67b4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tResetCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataResetCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ResetCount", (tS32)0xc8d67b4);
   (tVoid)myDpElem.bFillData((tVoid*)&tResetCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataResetCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataResetCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngDataResetCount::tGetData() {
   vUpdate();
   return tResetCount;
};
tS32 dp_tclSpmDpEngDataResetCount::s32GetData(tU32& tResetCountParam) { 
   vUpdate();
   tResetCountParam = tResetCount;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataResetCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ResetCount", (tS32)0xc8d67b4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataResetCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataResetCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataResetCount::s32SetData(tU32 &tResetCountParam) {
   //init parameter
   (tVoid)memcpy(&tResetCount,(tVoid*)&tResetCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tResetCountParam' in function 'dp_tclSpmDpEngDataResetCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngDataResetCount::s32SetData(const tU32 &tResetCountParam) {
   //init parameter
   (tVoid)memcpy(&tResetCount,(tVoid*)&tResetCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tResetCountParam' in function 'dp_tclSpmDpEngDataResetCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataResetCount::u8GetData(tU32& tResetCountParam) {  
   vUpdate();
   tResetCountParam = tResetCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataResetCount::vSetData(tU32 &tResetCountParam) { 
   //init parameter
   (tVoid)memcpy(&tResetCount,(tVoid*)&tResetCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tResetCountParam' in function 'dp_tclSpmDpEngDataResetCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngDataResetCount::vSetData(const tU32 &tResetCountParam) { 
   //init parameter
   (tVoid)memcpy(&tResetCount,(tVoid*)&tResetCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tResetCountParam' in function 'dp_tclSpmDpEngDataResetCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngDataResetCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataResetCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "ResetCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataResetCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "ResetCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataResetCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ResetCount", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element ResetCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StatisticEng"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataStatisticEng::dp_tclSpmDpEngDataStatisticEng(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStatisticEng,0,sizeof(TSpmSubStatesStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataStatisticEng::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StatisticEng",(tS32) 0x43b2c032);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSubStatesStatisticsData)) 
      {
         tStatisticEng = *((TSpmSubStatesStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataStatisticEng::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StatisticEng", (tS32)0x43b2c032);
   (tVoid)myDpElem.bFillData((tVoid*)&tStatisticEng, (tU32)sizeof(TSpmSubStatesStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataStatisticEng::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataStatisticEng::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSubStatesStatisticsData dp_tclSpmDpEngDataStatisticEng::tGetData() {
   vUpdate();
   return tStatisticEng;
};
tS32 dp_tclSpmDpEngDataStatisticEng::s32GetData(TSpmSubStatesStatisticsData& tStatisticEngParam) { 
   vUpdate();
   tStatisticEngParam = tStatisticEng;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataStatisticEng::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StatisticEng", (tS32)0x43b2c032);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataStatisticEng::operator>>(TSpmSubStatesStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataStatisticEng::operator<<(TSpmSubStatesStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataStatisticEng::s32SetData(TSpmSubStatesStatisticsData &tStatisticEngParam) {
   //init parameter
   (tVoid)memcpy(&tStatisticEng,(tVoid*)&tStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStatisticEngParam' in function 'dp_tclSpmDpEngDataStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataStatisticEng::s32SetData(const TSpmSubStatesStatisticsData &tStatisticEngParam) {
   //init parameter
   (tVoid)memcpy(&tStatisticEng,(tVoid*)&tStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStatisticEngParam' in function 'dp_tclSpmDpEngDataStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataStatisticEng::u8GetData(TSpmSubStatesStatisticsData& tStatisticEngParam) {  
   vUpdate();
   tStatisticEngParam = tStatisticEng;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataStatisticEng::vSetData(TSpmSubStatesStatisticsData &tStatisticEngParam) { 
   //init parameter
   (tVoid)memcpy(&tStatisticEng,(tVoid*)&tStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
}//lint !e1746: parameter 'tStatisticEngParam' in function 'dp_tclSpmDpEngDataStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataStatisticEng::vSetData(const TSpmSubStatesStatisticsData &tStatisticEngParam) { 
   //init parameter
   (tVoid)memcpy(&tStatisticEng,(tVoid*)&tStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
}//lint !e1746: parameter 'tStatisticEngParam' in function 'dp_tclSpmDpEngDataStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataStatisticEng::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataStatisticEng::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "StatisticEng", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataStatisticEng::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "StatisticEng", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataStatisticEng::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StatisticEng", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element StatisticEng has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TpHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataTpHistory::dp_tclSpmDpEngDataTpHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataTpHistory::vStore() {
    dp_tclBaseElement myDpElem("TpHistory", (tS32)0x291bcba);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(tU32)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListTpHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(tU32));
                pCurPos += sizeof(tU32);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(tU32))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataTpHistory::vUpdate() {
   dp_tclBaseElement myDpElem("TpHistory", (tS32)0x291bcba);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         tU32* pBuffer = (tU32*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataTpHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataTpHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataTpHistory::s32GetElem(tU32 u32NbElem, tU32& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataTpHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataTpHistory::vPushBack(tU32 &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataTpHistory::vPushBack(const tU32 &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataTpHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataTpHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "TpHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataTpHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "TpHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataTpHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TpHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element TpHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WupHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataWupHistory::dp_tclSpmDpEngDataWupHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataWupHistory::vStore() {
    dp_tclBaseElement myDpElem("WupHistory", (tS32)0xd773c0e);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmWakeupStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListWupHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmWakeupStatisticsData));
                pCurPos += sizeof(TSpmWakeupStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmWakeupStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataWupHistory::vUpdate() {
   dp_tclBaseElement myDpElem("WupHistory", (tS32)0xd773c0e);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmWakeupStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmWakeupStatisticsData));
         TSpmWakeupStatisticsData* pBuffer = (TSpmWakeupStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataWupHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataWupHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataWupHistory::s32GetElem(tU32 u32NbElem, TSpmWakeupStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataWupHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataWupHistory::vPushBack(TSpmWakeupStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataWupHistory::vPushBack(const TSpmWakeupStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataWupHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataWupHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "WupHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataWupHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "WupHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataWupHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: WupHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element WupHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SwitchOnHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataSwitchOnHistory::dp_tclSpmDpEngDataSwitchOnHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataSwitchOnHistory::vStore() {
    dp_tclBaseElement myDpElem("SwitchOnHistory", (tS32)0x57587479);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSwitchOnStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListSwitchOnHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSwitchOnStatisticsData));
                pCurPos += sizeof(TSpmSwitchOnStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSwitchOnStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataSwitchOnHistory::vUpdate() {
   dp_tclBaseElement myDpElem("SwitchOnHistory", (tS32)0x57587479);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSwitchOnStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSwitchOnStatisticsData));
         TSpmSwitchOnStatisticsData* pBuffer = (TSpmSwitchOnStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataSwitchOnHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataSwitchOnHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataSwitchOnHistory::s32GetElem(tU32 u32NbElem, TSpmSwitchOnStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataSwitchOnHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataSwitchOnHistory::vPushBack(TSpmSwitchOnStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataSwitchOnHistory::vPushBack(const TSpmSwitchOnStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataSwitchOnHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataSwitchOnHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SwitchOnHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataSwitchOnHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SwitchOnHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataSwitchOnHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SwitchOnHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element SwitchOnHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DeviceWakeupCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataDeviceWakeupCount::dp_tclSpmDpEngDataDeviceWakeupCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDeviceWakeupCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataDeviceWakeupCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DeviceWakeupCount",(tS32) 0xdd93db6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDeviceWakeupCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataDeviceWakeupCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DeviceWakeupCount", (tS32)0xdd93db6);
   (tVoid)myDpElem.bFillData((tVoid*)&tDeviceWakeupCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataDeviceWakeupCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataDeviceWakeupCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngDataDeviceWakeupCount::tGetData() {
   vUpdate();
   return tDeviceWakeupCount;
};
tS32 dp_tclSpmDpEngDataDeviceWakeupCount::s32GetData(tU32& tDeviceWakeupCountParam) { 
   vUpdate();
   tDeviceWakeupCountParam = tDeviceWakeupCount;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataDeviceWakeupCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DeviceWakeupCount", (tS32)0xdd93db6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataDeviceWakeupCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataDeviceWakeupCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataDeviceWakeupCount::s32SetData(tU32 &tDeviceWakeupCountParam) {
   //init parameter
   (tVoid)memcpy(&tDeviceWakeupCount,(tVoid*)&tDeviceWakeupCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataDeviceWakeupCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngDataDeviceWakeupCount::s32SetData(const tU32 &tDeviceWakeupCountParam) {
   //init parameter
   (tVoid)memcpy(&tDeviceWakeupCount,(tVoid*)&tDeviceWakeupCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataDeviceWakeupCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataDeviceWakeupCount::u8GetData(tU32& tDeviceWakeupCountParam) {  
   vUpdate();
   tDeviceWakeupCountParam = tDeviceWakeupCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataDeviceWakeupCount::vSetData(tU32 &tDeviceWakeupCountParam) { 
   //init parameter
   (tVoid)memcpy(&tDeviceWakeupCount,(tVoid*)&tDeviceWakeupCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataDeviceWakeupCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngDataDeviceWakeupCount::vSetData(const tU32 &tDeviceWakeupCountParam) { 
   //init parameter
   (tVoid)memcpy(&tDeviceWakeupCount,(tVoid*)&tDeviceWakeupCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataDeviceWakeupCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngDataDeviceWakeupCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataDeviceWakeupCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "DeviceWakeupCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataDeviceWakeupCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "DeviceWakeupCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataDeviceWakeupCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DeviceWakeupCount", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element DeviceWakeupCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DeviceOnCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataDeviceOnCount::dp_tclSpmDpEngDataDeviceOnCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDeviceOnCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataDeviceOnCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DeviceOnCount",(tS32) 0x5742b106);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDeviceOnCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataDeviceOnCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DeviceOnCount", (tS32)0x5742b106);
   (tVoid)myDpElem.bFillData((tVoid*)&tDeviceOnCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataDeviceOnCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataDeviceOnCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngDataDeviceOnCount::tGetData() {
   vUpdate();
   return tDeviceOnCount;
};
tS32 dp_tclSpmDpEngDataDeviceOnCount::s32GetData(tU32& tDeviceOnCountParam) { 
   vUpdate();
   tDeviceOnCountParam = tDeviceOnCount;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataDeviceOnCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DeviceOnCount", (tS32)0x5742b106);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataDeviceOnCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataDeviceOnCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataDeviceOnCount::s32SetData(tU32 &tDeviceOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tDeviceOnCount,(tVoid*)&tDeviceOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDeviceOnCountParam' in function 'dp_tclSpmDpEngDataDeviceOnCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngDataDeviceOnCount::s32SetData(const tU32 &tDeviceOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tDeviceOnCount,(tVoid*)&tDeviceOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDeviceOnCountParam' in function 'dp_tclSpmDpEngDataDeviceOnCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataDeviceOnCount::u8GetData(tU32& tDeviceOnCountParam) {  
   vUpdate();
   tDeviceOnCountParam = tDeviceOnCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataDeviceOnCount::vSetData(tU32 &tDeviceOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tDeviceOnCount,(tVoid*)&tDeviceOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDeviceOnCountParam' in function 'dp_tclSpmDpEngDataDeviceOnCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngDataDeviceOnCount::vSetData(const tU32 &tDeviceOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tDeviceOnCount,(tVoid*)&tDeviceOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDeviceOnCountParam' in function 'dp_tclSpmDpEngDataDeviceOnCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngDataDeviceOnCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataDeviceOnCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "DeviceOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataDeviceOnCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "DeviceOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataDeviceOnCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DeviceOnCount", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element DeviceOnCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VoltageRangeHistogram"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataVoltageRangeHistogram::dp_tclSpmDpEngDataVoltageRangeHistogram(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 51;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataVoltageRangeHistogram::vStore() {
    dp_tclBaseElement myDpElem("VoltageRangeHistogram", (tS32)0x839f1875);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmVoltageHistogramRangeStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListVoltageRangeHistogram::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmVoltageHistogramRangeStatisticsData));
                pCurPos += sizeof(TSpmVoltageHistogramRangeStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmVoltageHistogramRangeStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataVoltageRangeHistogram::vUpdate() {
   dp_tclBaseElement myDpElem("VoltageRangeHistogram", (tS32)0x839f1875);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmVoltageHistogramRangeStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmVoltageHistogramRangeStatisticsData));
         TSpmVoltageHistogramRangeStatisticsData* pBuffer = (TSpmVoltageHistogramRangeStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataVoltageRangeHistogram::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataVoltageRangeHistogram::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataVoltageRangeHistogram::s32GetElem(tU32 u32NbElem, TSpmVoltageHistogramRangeStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataVoltageRangeHistogram::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataVoltageRangeHistogram::vPushBack(TSpmVoltageHistogramRangeStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataVoltageRangeHistogram::vPushBack(const TSpmVoltageHistogramRangeStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataVoltageRangeHistogram::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataVoltageRangeHistogram::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "VoltageRangeHistogram", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataVoltageRangeHistogram::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "VoltageRangeHistogram", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataVoltageRangeHistogram::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VoltageRangeHistogram", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element VoltageRangeHistogram has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuUsageStatistics"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCpuUsageStatistics::dp_tclSpmDpEngDataCpuUsageStatistics(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCpuUsageStatistics,0,sizeof(TSpmSystemLoadStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCpuUsageStatistics::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CpuUsageStatistics",(tS32) 0x684a8930);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSystemLoadStatisticsData)) 
      {
         tCpuUsageStatistics = *((TSpmSystemLoadStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCpuUsageStatistics::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CpuUsageStatistics", (tS32)0x684a8930);
   (tVoid)myDpElem.bFillData((tVoid*)&tCpuUsageStatistics, (tU32)sizeof(TSpmSystemLoadStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCpuUsageStatistics::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCpuUsageStatistics::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSystemLoadStatisticsData dp_tclSpmDpEngDataCpuUsageStatistics::tGetData() {
   vUpdate();
   return tCpuUsageStatistics;
};
tS32 dp_tclSpmDpEngDataCpuUsageStatistics::s32GetData(TSpmSystemLoadStatisticsData& tCpuUsageStatisticsParam) { 
   vUpdate();
   tCpuUsageStatisticsParam = tCpuUsageStatistics;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCpuUsageStatistics::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CpuUsageStatistics", (tS32)0x684a8930);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCpuUsageStatistics::operator>>(TSpmSystemLoadStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCpuUsageStatistics::operator<<(TSpmSystemLoadStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCpuUsageStatistics::s32SetData(TSpmSystemLoadStatisticsData &tCpuUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCpuUsageStatistics,(tVoid*)&tCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataCpuUsageStatistics::s32SetData(const TSpmSystemLoadStatisticsData &tCpuUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCpuUsageStatistics,(tVoid*)&tCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCpuUsageStatistics::u8GetData(TSpmSystemLoadStatisticsData& tCpuUsageStatisticsParam) {  
   vUpdate();
   tCpuUsageStatisticsParam = tCpuUsageStatistics;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData &tCpuUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCpuUsageStatistics,(tVoid*)&tCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataCpuUsageStatistics::vSetData(const TSpmSystemLoadStatisticsData &tCpuUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCpuUsageStatistics,(tVoid*)&tCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataCpuUsageStatistics::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCpuUsageStatistics::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CpuUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCpuUsageStatistics::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CpuUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCpuUsageStatistics::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CpuUsageStatistics", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CpuUsageStatistics has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RamUsageStatistics"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataRamUsageStatistics::dp_tclSpmDpEngDataRamUsageStatistics(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRamUsageStatistics,0,sizeof(TSpmSystemLoadStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataRamUsageStatistics::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RamUsageStatistics",(tS32) 0x31326e04);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSystemLoadStatisticsData)) 
      {
         tRamUsageStatistics = *((TSpmSystemLoadStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataRamUsageStatistics::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RamUsageStatistics", (tS32)0x31326e04);
   (tVoid)myDpElem.bFillData((tVoid*)&tRamUsageStatistics, (tU32)sizeof(TSpmSystemLoadStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataRamUsageStatistics::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataRamUsageStatistics::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSystemLoadStatisticsData dp_tclSpmDpEngDataRamUsageStatistics::tGetData() {
   vUpdate();
   return tRamUsageStatistics;
};
tS32 dp_tclSpmDpEngDataRamUsageStatistics::s32GetData(TSpmSystemLoadStatisticsData& tRamUsageStatisticsParam) { 
   vUpdate();
   tRamUsageStatisticsParam = tRamUsageStatistics;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataRamUsageStatistics::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RamUsageStatistics", (tS32)0x31326e04);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataRamUsageStatistics::operator>>(TSpmSystemLoadStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataRamUsageStatistics::operator<<(TSpmSystemLoadStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataRamUsageStatistics::s32SetData(TSpmSystemLoadStatisticsData &tRamUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tRamUsageStatistics,(tVoid*)&tRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataRamUsageStatistics::s32SetData(const TSpmSystemLoadStatisticsData &tRamUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tRamUsageStatistics,(tVoid*)&tRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataRamUsageStatistics::u8GetData(TSpmSystemLoadStatisticsData& tRamUsageStatisticsParam) {  
   vUpdate();
   tRamUsageStatisticsParam = tRamUsageStatistics;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData &tRamUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tRamUsageStatistics,(tVoid*)&tRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataRamUsageStatistics::vSetData(const TSpmSystemLoadStatisticsData &tRamUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tRamUsageStatistics,(tVoid*)&tRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataRamUsageStatistics::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataRamUsageStatistics::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "RamUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataRamUsageStatistics::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "RamUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataRamUsageStatistics::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RamUsageStatistics", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element RamUsageStatistics has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StartupTimeStatistics"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataStartupTimeStatistics::dp_tclSpmDpEngDataStartupTimeStatistics(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStartupTimeStatistics,0,sizeof(TSpmSystemLoadStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataStartupTimeStatistics::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StartupTimeStatistics",(tS32) 0x7c525b5d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSystemLoadStatisticsData)) 
      {
         tStartupTimeStatistics = *((TSpmSystemLoadStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataStartupTimeStatistics::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StartupTimeStatistics", (tS32)0x7c525b5d);
   (tVoid)myDpElem.bFillData((tVoid*)&tStartupTimeStatistics, (tU32)sizeof(TSpmSystemLoadStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataStartupTimeStatistics::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataStartupTimeStatistics::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSystemLoadStatisticsData dp_tclSpmDpEngDataStartupTimeStatistics::tGetData() {
   vUpdate();
   return tStartupTimeStatistics;
};
tS32 dp_tclSpmDpEngDataStartupTimeStatistics::s32GetData(TSpmSystemLoadStatisticsData& tStartupTimeStatisticsParam) { 
   vUpdate();
   tStartupTimeStatisticsParam = tStartupTimeStatistics;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataStartupTimeStatistics::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StartupTimeStatistics", (tS32)0x7c525b5d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataStartupTimeStatistics::operator>>(TSpmSystemLoadStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataStartupTimeStatistics::operator<<(TSpmSystemLoadStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataStartupTimeStatistics::s32SetData(TSpmSystemLoadStatisticsData &tStartupTimeStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tStartupTimeStatistics,(tVoid*)&tStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataStartupTimeStatistics::s32SetData(const TSpmSystemLoadStatisticsData &tStartupTimeStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tStartupTimeStatistics,(tVoid*)&tStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataStartupTimeStatistics::u8GetData(TSpmSystemLoadStatisticsData& tStartupTimeStatisticsParam) {  
   vUpdate();
   tStartupTimeStatisticsParam = tStartupTimeStatistics;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData &tStartupTimeStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tStartupTimeStatistics,(tVoid*)&tStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataStartupTimeStatistics::vSetData(const TSpmSystemLoadStatisticsData &tStartupTimeStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tStartupTimeStatistics,(tVoid*)&tStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataStartupTimeStatistics::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataStartupTimeStatistics::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "StartupTimeStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataStartupTimeStatistics::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "StartupTimeStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataStartupTimeStatistics::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StartupTimeStatistics", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element StartupTimeStatistics has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionCpuUsageStatistics"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionCpuUsageStatistics,0,sizeof(TSpmSystemLoadStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionCpuUsageStatistics",(tS32) 0x6b06d5fbL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSystemLoadStatisticsData)) 
      {
         tCurrentSWVersionCpuUsageStatistics = *((TSpmSystemLoadStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionCpuUsageStatistics", (tS32)0x6b06d5fbL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionCpuUsageStatistics, (tU32)sizeof(TSpmSystemLoadStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSystemLoadStatisticsData dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::tGetData() {
   vUpdate();
   return tCurrentSWVersionCpuUsageStatistics;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::s32GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionCpuUsageStatisticsParam) { 
   vUpdate();
   tCurrentSWVersionCpuUsageStatisticsParam = tCurrentSWVersionCpuUsageStatistics;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionCpuUsageStatistics", (tS32)0x6b06d5fbL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::operator>>(TSpmSystemLoadStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::operator<<(TSpmSystemLoadStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::s32SetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionCpuUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionCpuUsageStatistics,(tVoid*)&tCurrentSWVersionCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::s32SetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionCpuUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionCpuUsageStatistics,(tVoid*)&tCurrentSWVersionCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::u8GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionCpuUsageStatisticsParam) {  
   vUpdate();
   tCurrentSWVersionCpuUsageStatisticsParam = tCurrentSWVersionCpuUsageStatistics;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionCpuUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionCpuUsageStatistics,(tVoid*)&tCurrentSWVersionCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vSetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionCpuUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionCpuUsageStatistics,(tVoid*)&tCurrentSWVersionCpuUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionCpuUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionCpuUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionCpuUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionCpuUsageStatistics", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionCpuUsageStatistics has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionRamUsageStatistics"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionRamUsageStatistics,0,sizeof(TSpmSystemLoadStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionRamUsageStatistics",(tS32) 0x33eebacfL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSystemLoadStatisticsData)) 
      {
         tCurrentSWVersionRamUsageStatistics = *((TSpmSystemLoadStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionRamUsageStatistics", (tS32)0x33eebacfL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionRamUsageStatistics, (tU32)sizeof(TSpmSystemLoadStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSystemLoadStatisticsData dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::tGetData() {
   vUpdate();
   return tCurrentSWVersionRamUsageStatistics;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::s32GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionRamUsageStatisticsParam) { 
   vUpdate();
   tCurrentSWVersionRamUsageStatisticsParam = tCurrentSWVersionRamUsageStatistics;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionRamUsageStatistics", (tS32)0x33eebacfL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::operator>>(TSpmSystemLoadStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::operator<<(TSpmSystemLoadStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::s32SetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionRamUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionRamUsageStatistics,(tVoid*)&tCurrentSWVersionRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::s32SetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionRamUsageStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionRamUsageStatistics,(tVoid*)&tCurrentSWVersionRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::u8GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionRamUsageStatisticsParam) {  
   vUpdate();
   tCurrentSWVersionRamUsageStatisticsParam = tCurrentSWVersionRamUsageStatistics;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionRamUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionRamUsageStatistics,(tVoid*)&tCurrentSWVersionRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vSetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionRamUsageStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionRamUsageStatistics,(tVoid*)&tCurrentSWVersionRamUsageStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionRamUsageStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionRamUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionRamUsageStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionRamUsageStatistics", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionRamUsageStatistics has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionStartupTimeStatistics"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionStartupTimeStatistics,0,sizeof(TSpmSystemLoadStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionStartupTimeStatistics",(tS32) 0xd243da7cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSystemLoadStatisticsData)) 
      {
         tCurrentSWVersionStartupTimeStatistics = *((TSpmSystemLoadStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionStartupTimeStatistics", (tS32)0xd243da7cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionStartupTimeStatistics, (tU32)sizeof(TSpmSystemLoadStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSystemLoadStatisticsData dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::tGetData() {
   vUpdate();
   return tCurrentSWVersionStartupTimeStatistics;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::s32GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionStartupTimeStatisticsParam) { 
   vUpdate();
   tCurrentSWVersionStartupTimeStatisticsParam = tCurrentSWVersionStartupTimeStatistics;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionStartupTimeStatistics", (tS32)0xd243da7cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::operator>>(TSpmSystemLoadStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::operator<<(TSpmSystemLoadStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::s32SetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionStartupTimeStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionStartupTimeStatistics,(tVoid*)&tCurrentSWVersionStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::s32SetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionStartupTimeStatisticsParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionStartupTimeStatistics,(tVoid*)&tCurrentSWVersionStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::u8GetData(TSpmSystemLoadStatisticsData& tCurrentSWVersionStartupTimeStatisticsParam) {  
   vUpdate();
   tCurrentSWVersionStartupTimeStatisticsParam = tCurrentSWVersionStartupTimeStatistics;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData &tCurrentSWVersionStartupTimeStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionStartupTimeStatistics,(tVoid*)&tCurrentSWVersionStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vSetData(const TSpmSystemLoadStatisticsData &tCurrentSWVersionStartupTimeStatisticsParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionStartupTimeStatistics,(tVoid*)&tCurrentSWVersionStartupTimeStatisticsParam, sizeof(TSpmSystemLoadStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionStartupTimeStatisticsParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::vSetData(TSpmSystemLoadStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionStartupTimeStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionStartupTimeStatistics", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionStartupTimeStatistics", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionStartupTimeStatistics has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionResetStatistic"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::dp_tclSpmDpEngDataCurrentSWVersionResetStatistic(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionResetStatistic,0,sizeof(TSpmResetStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionResetStatistic",(tS32) 0x29179afaL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmResetStatisticsData)) 
      {
         tCurrentSWVersionResetStatistic = *((TSpmResetStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionResetStatistic", (tS32)0x29179afaL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionResetStatistic, (tU32)sizeof(TSpmResetStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmResetStatisticsData dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::tGetData() {
   vUpdate();
   return tCurrentSWVersionResetStatistic;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::s32GetData(TSpmResetStatisticsData& tCurrentSWVersionResetStatisticParam) { 
   vUpdate();
   tCurrentSWVersionResetStatisticParam = tCurrentSWVersionResetStatistic;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionResetStatistic", (tS32)0x29179afaL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::operator>>(TSpmResetStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::operator<<(TSpmResetStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::s32SetData(TSpmResetStatisticsData &tCurrentSWVersionResetStatisticParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionResetStatistic,(tVoid*)&tCurrentSWVersionResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionResetStatisticParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::s32SetData(const TSpmResetStatisticsData &tCurrentSWVersionResetStatisticParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionResetStatistic,(tVoid*)&tCurrentSWVersionResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionResetStatisticParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::u8GetData(TSpmResetStatisticsData& tCurrentSWVersionResetStatisticParam) {  
   vUpdate();
   tCurrentSWVersionResetStatisticParam = tCurrentSWVersionResetStatistic;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vSetData(TSpmResetStatisticsData &tCurrentSWVersionResetStatisticParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionResetStatistic,(tVoid*)&tCurrentSWVersionResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionResetStatisticParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vSetData(const TSpmResetStatisticsData &tCurrentSWVersionResetStatisticParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionResetStatistic,(tVoid*)&tCurrentSWVersionResetStatisticParam, sizeof(TSpmResetStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionResetStatisticParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::vSetData(TSpmResetStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionResetStatistic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionResetStatistic", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionResetStatistic::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionResetStatistic", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionResetStatistic has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionResetHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionResetHistory::dp_tclSpmDpEngDataCurrentSWVersionResetHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 20;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionResetHistory::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionResetHistory", (tS32)0xd8ac0cf8L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmResetElem)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionResetHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmResetElem));
                pCurPos += sizeof(TSpmResetElem);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmResetElem))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionResetHistory::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionResetHistory", (tS32)0xd8ac0cf8L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmResetElem)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmResetElem));
         TSpmResetElem* pBuffer = (TSpmResetElem*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataCurrentSWVersionResetHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataCurrentSWVersionResetHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataCurrentSWVersionResetHistory::s32GetElem(tU32 u32NbElem, TSpmResetElem& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataCurrentSWVersionResetHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataCurrentSWVersionResetHistory::vPushBack(TSpmResetElem &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataCurrentSWVersionResetHistory::vPushBack(const TSpmResetElem &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataCurrentSWVersionResetHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataCurrentSWVersionResetHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionResetHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataCurrentSWVersionResetHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionResetHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataCurrentSWVersionResetHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionResetHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionResetHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionWupHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionWupHistory::dp_tclSpmDpEngDataCurrentSWVersionWupHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionWupHistory::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionWupHistory", (tS32)0x8eb33c39L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmWakeupStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionWupHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmWakeupStatisticsData));
                pCurPos += sizeof(TSpmWakeupStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmWakeupStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionWupHistory::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionWupHistory", (tS32)0x8eb33c39L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmWakeupStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmWakeupStatisticsData));
         TSpmWakeupStatisticsData* pBuffer = (TSpmWakeupStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataCurrentSWVersionWupHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataCurrentSWVersionWupHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataCurrentSWVersionWupHistory::s32GetElem(tU32 u32NbElem, TSpmWakeupStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataCurrentSWVersionWupHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataCurrentSWVersionWupHistory::vPushBack(TSpmWakeupStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataCurrentSWVersionWupHistory::vPushBack(const TSpmWakeupStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataCurrentSWVersionWupHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataCurrentSWVersionWupHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionWupHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataCurrentSWVersionWupHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionWupHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataCurrentSWVersionWupHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionWupHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionWupHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionDeviceWakeupCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionDeviceWakeupCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionDeviceWakeupCount",(tS32) 0x41988045L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentSWVersionDeviceWakeupCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionDeviceWakeupCount", (tS32)0x41988045L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionDeviceWakeupCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::tGetData() {
   vUpdate();
   return tCurrentSWVersionDeviceWakeupCount;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::s32GetData(tU32& tCurrentSWVersionDeviceWakeupCountParam) { 
   vUpdate();
   tCurrentSWVersionDeviceWakeupCountParam = tCurrentSWVersionDeviceWakeupCount;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionDeviceWakeupCount", (tS32)0x41988045L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::s32SetData(tU32 &tCurrentSWVersionDeviceWakeupCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionDeviceWakeupCount,(tVoid*)&tCurrentSWVersionDeviceWakeupCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::s32SetData(const tU32 &tCurrentSWVersionDeviceWakeupCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionDeviceWakeupCount,(tVoid*)&tCurrentSWVersionDeviceWakeupCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::u8GetData(tU32& tCurrentSWVersionDeviceWakeupCountParam) {  
   vUpdate();
   tCurrentSWVersionDeviceWakeupCountParam = tCurrentSWVersionDeviceWakeupCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vSetData(tU32 &tCurrentSWVersionDeviceWakeupCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionDeviceWakeupCount,(tVoid*)&tCurrentSWVersionDeviceWakeupCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vSetData(const tU32 &tCurrentSWVersionDeviceWakeupCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionDeviceWakeupCount,(tVoid*)&tCurrentSWVersionDeviceWakeupCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionDeviceWakeupCountParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionDeviceWakeupCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionDeviceWakeupCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionDeviceWakeupCount", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionDeviceWakeupCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionSubStatesStatisticEng"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionSubStatesStatisticEng,0,sizeof(TSpmSubStatesStatisticsData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionSubStatesStatisticEng",(tS32) 0xe8181ca7L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSubStatesStatisticsData)) 
      {
         tCurrentSWVersionSubStatesStatisticEng = *((TSpmSubStatesStatisticsData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionSubStatesStatisticEng", (tS32)0xe8181ca7L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionSubStatesStatisticEng, (tU32)sizeof(TSpmSubStatesStatisticsData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSubStatesStatisticsData dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::tGetData() {
   vUpdate();
   return tCurrentSWVersionSubStatesStatisticEng;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::s32GetData(TSpmSubStatesStatisticsData& tCurrentSWVersionSubStatesStatisticEngParam) { 
   vUpdate();
   tCurrentSWVersionSubStatesStatisticEngParam = tCurrentSWVersionSubStatesStatisticEng;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionSubStatesStatisticEng", (tS32)0xe8181ca7L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::operator>>(TSpmSubStatesStatisticsData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::operator<<(TSpmSubStatesStatisticsData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::s32SetData(TSpmSubStatesStatisticsData &tCurrentSWVersionSubStatesStatisticEngParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionSubStatesStatisticEng,(tVoid*)&tCurrentSWVersionSubStatesStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionSubStatesStatisticEngParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::s32SetData(const TSpmSubStatesStatisticsData &tCurrentSWVersionSubStatesStatisticEngParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionSubStatesStatisticEng,(tVoid*)&tCurrentSWVersionSubStatesStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionSubStatesStatisticEngParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::u8GetData(TSpmSubStatesStatisticsData& tCurrentSWVersionSubStatesStatisticEngParam) {  
   vUpdate();
   tCurrentSWVersionSubStatesStatisticEngParam = tCurrentSWVersionSubStatesStatisticEng;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vSetData(TSpmSubStatesStatisticsData &tCurrentSWVersionSubStatesStatisticEngParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionSubStatesStatisticEng,(tVoid*)&tCurrentSWVersionSubStatesStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionSubStatesStatisticEngParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vSetData(const TSpmSubStatesStatisticsData &tCurrentSWVersionSubStatesStatisticEngParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionSubStatesStatisticEng,(tVoid*)&tCurrentSWVersionSubStatesStatisticEngParam, sizeof(TSpmSubStatesStatisticsData));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionSubStatesStatisticEngParam' in function 'dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::vSetData(TSpmSubStatesStatisticsData)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionSubStatesStatisticEng", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersionSubStatesStatisticEng", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionSubStatesStatisticEng", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionSubStatesStatisticEng has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SoftwareVersionStatistics0"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataSoftwareVersionStatistics0::dp_tclSpmDpEngDataSoftwareVersionStatistics0(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 5;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics0::vStore() {
    dp_tclBaseElement myDpElem("SoftwareVersionStatistics0", (tS32)0x1eed4bcL);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSoftwareVersionStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListSoftwareVersionStatistics0::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSoftwareVersionStatisticsData));
                pCurPos += sizeof(TSpmSoftwareVersionStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSoftwareVersionStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics0::vUpdate() {
   dp_tclBaseElement myDpElem("SoftwareVersionStatistics0", (tS32)0x1eed4bcL);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSoftwareVersionStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSoftwareVersionStatisticsData));
         TSpmSoftwareVersionStatisticsData* pBuffer = (TSpmSoftwareVersionStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataSoftwareVersionStatistics0::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataSoftwareVersionStatistics0::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataSoftwareVersionStatistics0::s32GetElem(tU32 u32NbElem, TSpmSoftwareVersionStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataSoftwareVersionStatistics0::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics0::vPushBack(TSpmSoftwareVersionStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics0::vPushBack(const TSpmSoftwareVersionStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics0::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataSoftwareVersionStatistics0::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SoftwareVersionStatistics0", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataSoftwareVersionStatistics0::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SoftwareVersionStatistics0", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataSoftwareVersionStatistics0::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SoftwareVersionStatistics0", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element SoftwareVersionStatistics0 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SoftwareVersionStatistics1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataSoftwareVersionStatistics1::dp_tclSpmDpEngDataSoftwareVersionStatistics1(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 15;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics1::vStore() {
    dp_tclBaseElement myDpElem("SoftwareVersionStatistics1", (tS32)0x1eed4bdL);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSoftwareVersionStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListSoftwareVersionStatistics1::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSoftwareVersionStatisticsData));
                pCurPos += sizeof(TSpmSoftwareVersionStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSoftwareVersionStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics1::vUpdate() {
   dp_tclBaseElement myDpElem("SoftwareVersionStatistics1", (tS32)0x1eed4bdL);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSoftwareVersionStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSoftwareVersionStatisticsData));
         TSpmSoftwareVersionStatisticsData* pBuffer = (TSpmSoftwareVersionStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataSoftwareVersionStatistics1::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataSoftwareVersionStatistics1::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataSoftwareVersionStatistics1::s32GetElem(tU32 u32NbElem, TSpmSoftwareVersionStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataSoftwareVersionStatistics1::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics1::vPushBack(TSpmSoftwareVersionStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics1::vPushBack(const TSpmSoftwareVersionStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataSoftwareVersionStatistics1::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataSoftwareVersionStatistics1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SoftwareVersionStatistics1", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataSoftwareVersionStatistics1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SoftwareVersionStatistics1", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataSoftwareVersionStatistics1::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SoftwareVersionStatistics1", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element SoftwareVersionStatistics1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SWVersionUpdateCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataSWVersionUpdateCount::dp_tclSpmDpEngDataSWVersionUpdateCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSWVersionUpdateCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataSWVersionUpdateCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SWVersionUpdateCount",(tS32) 0x9412a518);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSWVersionUpdateCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataSWVersionUpdateCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SWVersionUpdateCount", (tS32)0x9412a518);
   (tVoid)myDpElem.bFillData((tVoid*)&tSWVersionUpdateCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataSWVersionUpdateCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataSWVersionUpdateCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngDataSWVersionUpdateCount::tGetData() {
   vUpdate();
   return tSWVersionUpdateCount;
};
tS32 dp_tclSpmDpEngDataSWVersionUpdateCount::s32GetData(tU32& tSWVersionUpdateCountParam) { 
   vUpdate();
   tSWVersionUpdateCountParam = tSWVersionUpdateCount;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataSWVersionUpdateCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SWVersionUpdateCount", (tS32)0x9412a518);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataSWVersionUpdateCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataSWVersionUpdateCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataSWVersionUpdateCount::s32SetData(tU32 &tSWVersionUpdateCountParam) {
   //init parameter
   (tVoid)memcpy(&tSWVersionUpdateCount,(tVoid*)&tSWVersionUpdateCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSWVersionUpdateCountParam' in function 'dp_tclSpmDpEngDataSWVersionUpdateCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngDataSWVersionUpdateCount::s32SetData(const tU32 &tSWVersionUpdateCountParam) {
   //init parameter
   (tVoid)memcpy(&tSWVersionUpdateCount,(tVoid*)&tSWVersionUpdateCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSWVersionUpdateCountParam' in function 'dp_tclSpmDpEngDataSWVersionUpdateCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataSWVersionUpdateCount::u8GetData(tU32& tSWVersionUpdateCountParam) {  
   vUpdate();
   tSWVersionUpdateCountParam = tSWVersionUpdateCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataSWVersionUpdateCount::vSetData(tU32 &tSWVersionUpdateCountParam) { 
   //init parameter
   (tVoid)memcpy(&tSWVersionUpdateCount,(tVoid*)&tSWVersionUpdateCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSWVersionUpdateCountParam' in function 'dp_tclSpmDpEngDataSWVersionUpdateCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngDataSWVersionUpdateCount::vSetData(const tU32 &tSWVersionUpdateCountParam) { 
   //init parameter
   (tVoid)memcpy(&tSWVersionUpdateCount,(tVoid*)&tSWVersionUpdateCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSWVersionUpdateCountParam' in function 'dp_tclSpmDpEngDataSWVersionUpdateCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngDataSWVersionUpdateCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataSWVersionUpdateCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SWVersionUpdateCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataSWVersionUpdateCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "SWVersionUpdateCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataSWVersionUpdateCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SWVersionUpdateCount", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element SWVersionUpdateCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWVersion::dp_tclSpmDpEngDataCurrentSWVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersion,0,sizeof(TSpmSoftwareVersion));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersion",(tS32) 0xac134143);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSpmSoftwareVersion)) 
      {
         tCurrentSWVersion = *((TSpmSoftwareVersion*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersion", (tS32)0xac134143);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersion, (tU32)sizeof(TSpmSoftwareVersion));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSpmSoftwareVersion dp_tclSpmDpEngDataCurrentSWVersion::tGetData() {
   vUpdate();
   return tCurrentSWVersion;
};
tS32 dp_tclSpmDpEngDataCurrentSWVersion::s32GetData(TSpmSoftwareVersion& tCurrentSWVersionParam) { 
   vUpdate();
   tCurrentSWVersionParam = tCurrentSWVersion;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersion", (tS32)0xac134143);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersion::operator>>(TSpmSoftwareVersion& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWVersion::operator<<(TSpmSoftwareVersion oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWVersion::s32SetData(TSpmSoftwareVersion &tCurrentSWVersionParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersion,(tVoid*)&tCurrentSWVersionParam, sizeof(TSpmSoftwareVersion));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionParam' in function 'dp_tclSpmDpEngDataCurrentSWVersion::vSetData(TSpmSoftwareVersion)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWVersion::s32SetData(const TSpmSoftwareVersion &tCurrentSWVersionParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersion,(tVoid*)&tCurrentSWVersionParam, sizeof(TSpmSoftwareVersion));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionParam' in function 'dp_tclSpmDpEngDataCurrentSWVersion::vSetData(TSpmSoftwareVersion)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWVersion::u8GetData(TSpmSoftwareVersion& tCurrentSWVersionParam) {  
   vUpdate();
   tCurrentSWVersionParam = tCurrentSWVersion;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWVersion::vSetData(TSpmSoftwareVersion &tCurrentSWVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersion,(tVoid*)&tCurrentSWVersionParam, sizeof(TSpmSoftwareVersion));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionParam' in function 'dp_tclSpmDpEngDataCurrentSWVersion::vSetData(TSpmSoftwareVersion)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWVersion::vSetData(const TSpmSoftwareVersion &tCurrentSWVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersion,(tVoid*)&tCurrentSWVersionParam, sizeof(TSpmSoftwareVersion));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionParam' in function 'dp_tclSpmDpEngDataCurrentSWVersion::vSetData(TSpmSoftwareVersion)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersion", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWDeviceOnCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWDeviceOnCount::dp_tclSpmDpEngDataCurrentSWDeviceOnCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWDeviceOnCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWDeviceOnCount",(tS32) 0x9e44220f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentSWDeviceOnCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWDeviceOnCount", (tS32)0x9e44220f);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWDeviceOnCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngDataCurrentSWDeviceOnCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngDataCurrentSWDeviceOnCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngDataCurrentSWDeviceOnCount::tGetData() {
   vUpdate();
   return tCurrentSWDeviceOnCount;
};
tS32 dp_tclSpmDpEngDataCurrentSWDeviceOnCount::s32GetData(tU32& tCurrentSWDeviceOnCountParam) { 
   vUpdate();
   tCurrentSWDeviceOnCountParam = tCurrentSWDeviceOnCount;
   return _s32Status;
}
tS32 dp_tclSpmDpEngDataCurrentSWDeviceOnCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWDeviceOnCount", (tS32)0x9e44220f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngDataCurrentSWDeviceOnCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngDataCurrentSWDeviceOnCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngDataCurrentSWDeviceOnCount::s32SetData(tU32 &tCurrentSWDeviceOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWDeviceOnCount,(tVoid*)&tCurrentSWDeviceOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWDeviceOnCountParam' in function 'dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngDataCurrentSWDeviceOnCount::s32SetData(const tU32 &tCurrentSWDeviceOnCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWDeviceOnCount,(tVoid*)&tCurrentSWDeviceOnCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWDeviceOnCountParam' in function 'dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngDataCurrentSWDeviceOnCount::u8GetData(tU32& tCurrentSWDeviceOnCountParam) {  
   vUpdate();
   tCurrentSWDeviceOnCountParam = tCurrentSWDeviceOnCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vSetData(tU32 &tCurrentSWDeviceOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWDeviceOnCount,(tVoid*)&tCurrentSWDeviceOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWDeviceOnCountParam' in function 'dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vSetData(const tU32 &tCurrentSWDeviceOnCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWDeviceOnCount,(tVoid*)&tCurrentSWDeviceOnCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWDeviceOnCountParam' in function 'dp_tclSpmDpEngDataCurrentSWDeviceOnCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngDataCurrentSWDeviceOnCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngDataCurrentSWDeviceOnCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWDeviceOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWDeviceOnCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWDeviceOnCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngDataCurrentSWDeviceOnCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWDeviceOnCount", DP_U32_POOL_ID_SPMDPENGDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWDeviceOnCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWSwitchOnHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::dp_tclSpmDpEngDataCurrentSWSwitchOnHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWSwitchOnHistory", (tS32)0x467c7e5a);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSwitchOnStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWSwitchOnHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSwitchOnStatisticsData));
                pCurPos += sizeof(TSpmSwitchOnStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSwitchOnStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWSwitchOnHistory", (tS32)0x467c7e5a);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSwitchOnStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSwitchOnStatisticsData));
         TSpmSwitchOnStatisticsData* pBuffer = (TSpmSwitchOnStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::s32GetElem(tU32 u32NbElem, TSpmSwitchOnStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::vPushBack(TSpmSwitchOnStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::vPushBack(const TSpmSwitchOnStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWSwitchOnHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGDATA, "CurrentSWSwitchOnHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngDataCurrentSWSwitchOnHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWSwitchOnHistory", DP_U32_POOL_ID_SPMDPENGDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGDATA);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWSwitchOnHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 

