
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpConfig.h"

#include "dp_tclSramAccessSPM.h"

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StandbyTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigStandbyTime::dp_tclSpmDpConfigStandbyTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStandbyTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigStandbyTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StandbyTime",(tS32) 0x40b43518);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tStandbyTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigStandbyTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StandbyTime", (tS32)0x40b43518);
   (tVoid)myDpElem.bFillData((tVoid*)&tStandbyTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigStandbyTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigStandbyTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigStandbyTime::tGetData() {
   vUpdate();
   return tStandbyTime;
};
tS32 dp_tclSpmDpConfigStandbyTime::s32GetData(tU32& tStandbyTimeParam) { 
   vUpdate();
   tStandbyTimeParam = tStandbyTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigStandbyTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StandbyTime", (tS32)0x40b43518);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigStandbyTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigStandbyTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigStandbyTime::s32SetData(tU32 &tStandbyTimeParam) {
   //init parameter
   (tVoid)memcpy(&tStandbyTime,(tVoid*)&tStandbyTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStandbyTimeParam' in function 'dp_tclSpmDpConfigStandbyTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigStandbyTime::s32SetData(const tU32 &tStandbyTimeParam) {
   //init parameter
   (tVoid)memcpy(&tStandbyTime,(tVoid*)&tStandbyTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStandbyTimeParam' in function 'dp_tclSpmDpConfigStandbyTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigStandbyTime::u8GetData(tU32& tStandbyTimeParam) {  
   vUpdate();
   tStandbyTimeParam = tStandbyTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigStandbyTime::vSetData(tU32 &tStandbyTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tStandbyTime,(tVoid*)&tStandbyTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStandbyTimeParam' in function 'dp_tclSpmDpConfigStandbyTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigStandbyTime::vSetData(const tU32 &tStandbyTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tStandbyTime,(tVoid*)&tStandbyTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStandbyTimeParam' in function 'dp_tclSpmDpConfigStandbyTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigStandbyTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigStandbyTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "StandbyTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigStandbyTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "StandbyTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigStandbyTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StandbyTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element StandbyTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DevStandbyTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigDevStandbyTime::dp_tclSpmDpConfigDevStandbyTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDevStandbyTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigDevStandbyTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DevStandbyTime",(tS32) 0xa986147f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDevStandbyTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigDevStandbyTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DevStandbyTime", (tS32)0xa986147f);
   (tVoid)myDpElem.bFillData((tVoid*)&tDevStandbyTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigDevStandbyTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigDevStandbyTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigDevStandbyTime::tGetData() {
   vUpdate();
   return tDevStandbyTime;
};
tS32 dp_tclSpmDpConfigDevStandbyTime::s32GetData(tU32& tDevStandbyTimeParam) { 
   vUpdate();
   tDevStandbyTimeParam = tDevStandbyTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigDevStandbyTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DevStandbyTime", (tS32)0xa986147f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigDevStandbyTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigDevStandbyTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigDevStandbyTime::s32SetData(tU32 &tDevStandbyTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDevStandbyTime,(tVoid*)&tDevStandbyTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDevStandbyTimeParam' in function 'dp_tclSpmDpConfigDevStandbyTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigDevStandbyTime::s32SetData(const tU32 &tDevStandbyTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDevStandbyTime,(tVoid*)&tDevStandbyTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDevStandbyTimeParam' in function 'dp_tclSpmDpConfigDevStandbyTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigDevStandbyTime::u8GetData(tU32& tDevStandbyTimeParam) {  
   vUpdate();
   tDevStandbyTimeParam = tDevStandbyTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigDevStandbyTime::vSetData(tU32 &tDevStandbyTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDevStandbyTime,(tVoid*)&tDevStandbyTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDevStandbyTimeParam' in function 'dp_tclSpmDpConfigDevStandbyTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigDevStandbyTime::vSetData(const tU32 &tDevStandbyTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDevStandbyTime,(tVoid*)&tDevStandbyTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDevStandbyTimeParam' in function 'dp_tclSpmDpConfigDevStandbyTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigDevStandbyTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigDevStandbyTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DevStandbyTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDevStandbyTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DevStandbyTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDevStandbyTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DevStandbyTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element DevStandbyTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StateProfileStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigStateProfileStatus::dp_tclSpmDpConfigStateProfileStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStateProfileStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigStateProfileStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StateProfileStatus",(tS32) 0xd79815ae);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tStateProfileStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigStateProfileStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StateProfileStatus", (tS32)0xd79815ae);
   (tVoid)myDpElem.bFillData((tVoid*)&tStateProfileStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigStateProfileStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigStateProfileStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpConfigStateProfileStatus::tGetData() {
   vUpdate();
   return tStateProfileStatus;
};
tS32 dp_tclSpmDpConfigStateProfileStatus::s32GetData(tBool& tStateProfileStatusParam) { 
   vUpdate();
   tStateProfileStatusParam = tStateProfileStatus;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigStateProfileStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StateProfileStatus", (tS32)0xd79815ae);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigStateProfileStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigStateProfileStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigStateProfileStatus::s32SetData(tBool &tStateProfileStatusParam) {
   //init parameter
   (tVoid)memcpy(&tStateProfileStatus,(tVoid*)&tStateProfileStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStateProfileStatusParam' in function 'dp_tclSpmDpConfigStateProfileStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpConfigStateProfileStatus::s32SetData(const tBool &tStateProfileStatusParam) {
   //init parameter
   (tVoid)memcpy(&tStateProfileStatus,(tVoid*)&tStateProfileStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStateProfileStatusParam' in function 'dp_tclSpmDpConfigStateProfileStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigStateProfileStatus::u8GetData(tBool& tStateProfileStatusParam) {  
   vUpdate();
   tStateProfileStatusParam = tStateProfileStatus;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigStateProfileStatus::vSetData(tBool &tStateProfileStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tStateProfileStatus,(tVoid*)&tStateProfileStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tStateProfileStatusParam' in function 'dp_tclSpmDpConfigStateProfileStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpConfigStateProfileStatus::vSetData(const tBool &tStateProfileStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tStateProfileStatus,(tVoid*)&tStateProfileStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tStateProfileStatusParam' in function 'dp_tclSpmDpConfigStateProfileStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpConfigStateProfileStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigStateProfileStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "StateProfileStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigStateProfileStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "StateProfileStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigStateProfileStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StateProfileStatus", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element StateProfileStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StateProfileTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigStateProfileTime::dp_tclSpmDpConfigStateProfileTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStateProfileTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigStateProfileTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StateProfileTime",(tS32) 0x27580059);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tStateProfileTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigStateProfileTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StateProfileTime", (tS32)0x27580059);
   (tVoid)myDpElem.bFillData((tVoid*)&tStateProfileTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigStateProfileTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigStateProfileTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigStateProfileTime::tGetData() {
   vUpdate();
   return tStateProfileTime;
};
tS32 dp_tclSpmDpConfigStateProfileTime::s32GetData(tU32& tStateProfileTimeParam) { 
   vUpdate();
   tStateProfileTimeParam = tStateProfileTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigStateProfileTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StateProfileTime", (tS32)0x27580059);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigStateProfileTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigStateProfileTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigStateProfileTime::s32SetData(tU32 &tStateProfileTimeParam) {
   //init parameter
   (tVoid)memcpy(&tStateProfileTime,(tVoid*)&tStateProfileTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStateProfileTimeParam' in function 'dp_tclSpmDpConfigStateProfileTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigStateProfileTime::s32SetData(const tU32 &tStateProfileTimeParam) {
   //init parameter
   (tVoid)memcpy(&tStateProfileTime,(tVoid*)&tStateProfileTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStateProfileTimeParam' in function 'dp_tclSpmDpConfigStateProfileTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigStateProfileTime::u8GetData(tU32& tStateProfileTimeParam) {  
   vUpdate();
   tStateProfileTimeParam = tStateProfileTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigStateProfileTime::vSetData(tU32 &tStateProfileTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tStateProfileTime,(tVoid*)&tStateProfileTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStateProfileTimeParam' in function 'dp_tclSpmDpConfigStateProfileTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigStateProfileTime::vSetData(const tU32 &tStateProfileTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tStateProfileTime,(tVoid*)&tStateProfileTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStateProfileTimeParam' in function 'dp_tclSpmDpConfigStateProfileTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigStateProfileTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigStateProfileTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "StateProfileTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigStateProfileTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "StateProfileTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigStateProfileTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StateProfileTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element StateProfileTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "IgnitionOffTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigIgnitionOffTime::dp_tclSpmDpConfigIgnitionOffTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tIgnitionOffTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigIgnitionOffTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("IgnitionOffTime",(tS32) 0xc8b88ab3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tIgnitionOffTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigIgnitionOffTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("IgnitionOffTime", (tS32)0xc8b88ab3);
   (tVoid)myDpElem.bFillData((tVoid*)&tIgnitionOffTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigIgnitionOffTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigIgnitionOffTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigIgnitionOffTime::tGetData() {
   vUpdate();
   return tIgnitionOffTime;
};
tS32 dp_tclSpmDpConfigIgnitionOffTime::s32GetData(tU32& tIgnitionOffTimeParam) { 
   vUpdate();
   tIgnitionOffTimeParam = tIgnitionOffTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigIgnitionOffTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("IgnitionOffTime", (tS32)0xc8b88ab3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigIgnitionOffTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigIgnitionOffTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigIgnitionOffTime::s32SetData(tU32 &tIgnitionOffTimeParam) {
   //init parameter
   (tVoid)memcpy(&tIgnitionOffTime,(tVoid*)&tIgnitionOffTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tIgnitionOffTimeParam' in function 'dp_tclSpmDpConfigIgnitionOffTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigIgnitionOffTime::s32SetData(const tU32 &tIgnitionOffTimeParam) {
   //init parameter
   (tVoid)memcpy(&tIgnitionOffTime,(tVoid*)&tIgnitionOffTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tIgnitionOffTimeParam' in function 'dp_tclSpmDpConfigIgnitionOffTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigIgnitionOffTime::u8GetData(tU32& tIgnitionOffTimeParam) {  
   vUpdate();
   tIgnitionOffTimeParam = tIgnitionOffTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigIgnitionOffTime::vSetData(tU32 &tIgnitionOffTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tIgnitionOffTime,(tVoid*)&tIgnitionOffTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tIgnitionOffTimeParam' in function 'dp_tclSpmDpConfigIgnitionOffTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigIgnitionOffTime::vSetData(const tU32 &tIgnitionOffTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tIgnitionOffTime,(tVoid*)&tIgnitionOffTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tIgnitionOffTimeParam' in function 'dp_tclSpmDpConfigIgnitionOffTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigIgnitionOffTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigIgnitionOffTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "IgnitionOffTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigIgnitionOffTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "IgnitionOffTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigIgnitionOffTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: IgnitionOffTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element IgnitionOffTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DisableCyclicResetHandling"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigDisableCyclicResetHandling::dp_tclSpmDpConfigDisableCyclicResetHandling(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDisableCyclicResetHandling,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigDisableCyclicResetHandling::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DisableCyclicResetHandling",(tS32) 0x27322a8bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tDisableCyclicResetHandling = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigDisableCyclicResetHandling::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DisableCyclicResetHandling", (tS32)0x27322a8bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDisableCyclicResetHandling, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigDisableCyclicResetHandling::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigDisableCyclicResetHandling::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpConfigDisableCyclicResetHandling::tGetData() {
   vUpdate();
   return tDisableCyclicResetHandling;
};
tS32 dp_tclSpmDpConfigDisableCyclicResetHandling::s32GetData(tBool& tDisableCyclicResetHandlingParam) { 
   vUpdate();
   tDisableCyclicResetHandlingParam = tDisableCyclicResetHandling;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigDisableCyclicResetHandling::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DisableCyclicResetHandling", (tS32)0x27322a8bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigDisableCyclicResetHandling::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigDisableCyclicResetHandling::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigDisableCyclicResetHandling::s32SetData(tBool &tDisableCyclicResetHandlingParam) {
   //init parameter
   (tVoid)memcpy(&tDisableCyclicResetHandling,(tVoid*)&tDisableCyclicResetHandlingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDisableCyclicResetHandlingParam' in function 'dp_tclSpmDpConfigDisableCyclicResetHandling::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpConfigDisableCyclicResetHandling::s32SetData(const tBool &tDisableCyclicResetHandlingParam) {
   //init parameter
   (tVoid)memcpy(&tDisableCyclicResetHandling,(tVoid*)&tDisableCyclicResetHandlingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDisableCyclicResetHandlingParam' in function 'dp_tclSpmDpConfigDisableCyclicResetHandling::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigDisableCyclicResetHandling::u8GetData(tBool& tDisableCyclicResetHandlingParam) {  
   vUpdate();
   tDisableCyclicResetHandlingParam = tDisableCyclicResetHandling;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigDisableCyclicResetHandling::vSetData(tBool &tDisableCyclicResetHandlingParam) { 
   //init parameter
   (tVoid)memcpy(&tDisableCyclicResetHandling,(tVoid*)&tDisableCyclicResetHandlingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDisableCyclicResetHandlingParam' in function 'dp_tclSpmDpConfigDisableCyclicResetHandling::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpConfigDisableCyclicResetHandling::vSetData(const tBool &tDisableCyclicResetHandlingParam) { 
   //init parameter
   (tVoid)memcpy(&tDisableCyclicResetHandling,(tVoid*)&tDisableCyclicResetHandlingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDisableCyclicResetHandlingParam' in function 'dp_tclSpmDpConfigDisableCyclicResetHandling::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpConfigDisableCyclicResetHandling::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigDisableCyclicResetHandling::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DisableCyclicResetHandling", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDisableCyclicResetHandling::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DisableCyclicResetHandling", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDisableCyclicResetHandling::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DisableCyclicResetHandling", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element DisableCyclicResetHandling has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SystemStateMachine"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigSystemStateMachine::dp_tclSpmDpConfigSystemStateMachine(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSystemStateMachine,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigSystemStateMachine::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SystemStateMachine",(tS32) 0xae741dcf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSystemStateMachine = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigSystemStateMachine::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SystemStateMachine", (tS32)0xae741dcf);
   (tVoid)myDpElem.bFillData((tVoid*)&tSystemStateMachine, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigSystemStateMachine::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigSystemStateMachine::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigSystemStateMachine::tGetData() {
   vUpdate();
   return tSystemStateMachine;
};
tS32 dp_tclSpmDpConfigSystemStateMachine::s32GetData(tU32& tSystemStateMachineParam) { 
   vUpdate();
   tSystemStateMachineParam = tSystemStateMachine;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigSystemStateMachine::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SystemStateMachine", (tS32)0xae741dcf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigSystemStateMachine::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigSystemStateMachine::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigSystemStateMachine::s32SetData(tU32 &tSystemStateMachineParam) {
   //init parameter
   (tVoid)memcpy(&tSystemStateMachine,(tVoid*)&tSystemStateMachineParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSystemStateMachineParam' in function 'dp_tclSpmDpConfigSystemStateMachine::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigSystemStateMachine::s32SetData(const tU32 &tSystemStateMachineParam) {
   //init parameter
   (tVoid)memcpy(&tSystemStateMachine,(tVoid*)&tSystemStateMachineParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSystemStateMachineParam' in function 'dp_tclSpmDpConfigSystemStateMachine::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigSystemStateMachine::u8GetData(tU32& tSystemStateMachineParam) {  
   vUpdate();
   tSystemStateMachineParam = tSystemStateMachine;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigSystemStateMachine::vSetData(tU32 &tSystemStateMachineParam) { 
   //init parameter
   (tVoid)memcpy(&tSystemStateMachine,(tVoid*)&tSystemStateMachineParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSystemStateMachineParam' in function 'dp_tclSpmDpConfigSystemStateMachine::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigSystemStateMachine::vSetData(const tU32 &tSystemStateMachineParam) { 
   //init parameter
   (tVoid)memcpy(&tSystemStateMachine,(tVoid*)&tSystemStateMachineParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSystemStateMachineParam' in function 'dp_tclSpmDpConfigSystemStateMachine::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigSystemStateMachine::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigSystemStateMachine::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "SystemStateMachine", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigSystemStateMachine::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "SystemStateMachine", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigSystemStateMachine::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SystemStateMachine", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element SystemStateMachine has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NaviStandbyTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigNaviStandbyTime::dp_tclSpmDpConfigNaviStandbyTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNaviStandbyTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigNaviStandbyTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NaviStandbyTime",(tS32) 0x91556f86);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tNaviStandbyTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigNaviStandbyTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NaviStandbyTime", (tS32)0x91556f86);
   (tVoid)myDpElem.bFillData((tVoid*)&tNaviStandbyTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigNaviStandbyTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigNaviStandbyTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigNaviStandbyTime::tGetData() {
   vUpdate();
   return tNaviStandbyTime;
};
tS32 dp_tclSpmDpConfigNaviStandbyTime::s32GetData(tU32& tNaviStandbyTimeParam) { 
   vUpdate();
   tNaviStandbyTimeParam = tNaviStandbyTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigNaviStandbyTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NaviStandbyTime", (tS32)0x91556f86);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigNaviStandbyTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigNaviStandbyTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigNaviStandbyTime::s32SetData(tU32 &tNaviStandbyTimeParam) {
   //init parameter
   (tVoid)memcpy(&tNaviStandbyTime,(tVoid*)&tNaviStandbyTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviStandbyTimeParam' in function 'dp_tclSpmDpConfigNaviStandbyTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigNaviStandbyTime::s32SetData(const tU32 &tNaviStandbyTimeParam) {
   //init parameter
   (tVoid)memcpy(&tNaviStandbyTime,(tVoid*)&tNaviStandbyTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviStandbyTimeParam' in function 'dp_tclSpmDpConfigNaviStandbyTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigNaviStandbyTime::u8GetData(tU32& tNaviStandbyTimeParam) {  
   vUpdate();
   tNaviStandbyTimeParam = tNaviStandbyTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigNaviStandbyTime::vSetData(tU32 &tNaviStandbyTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviStandbyTime,(tVoid*)&tNaviStandbyTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tNaviStandbyTimeParam' in function 'dp_tclSpmDpConfigNaviStandbyTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigNaviStandbyTime::vSetData(const tU32 &tNaviStandbyTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviStandbyTime,(tVoid*)&tNaviStandbyTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tNaviStandbyTimeParam' in function 'dp_tclSpmDpConfigNaviStandbyTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigNaviStandbyTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigNaviStandbyTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "NaviStandbyTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigNaviStandbyTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "NaviStandbyTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigNaviStandbyTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NaviStandbyTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element NaviStandbyTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BackgroundTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigBackgroundTime::dp_tclSpmDpConfigBackgroundTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBackgroundTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigBackgroundTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BackgroundTime",(tS32) 0xb35fb4cf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tBackgroundTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigBackgroundTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BackgroundTime", (tS32)0xb35fb4cf);
   (tVoid)myDpElem.bFillData((tVoid*)&tBackgroundTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigBackgroundTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigBackgroundTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigBackgroundTime::tGetData() {
   vUpdate();
   return tBackgroundTime;
};
tS32 dp_tclSpmDpConfigBackgroundTime::s32GetData(tU32& tBackgroundTimeParam) { 
   vUpdate();
   tBackgroundTimeParam = tBackgroundTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigBackgroundTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BackgroundTime", (tS32)0xb35fb4cf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigBackgroundTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigBackgroundTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigBackgroundTime::s32SetData(tU32 &tBackgroundTimeParam) {
   //init parameter
   (tVoid)memcpy(&tBackgroundTime,(tVoid*)&tBackgroundTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBackgroundTimeParam' in function 'dp_tclSpmDpConfigBackgroundTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigBackgroundTime::s32SetData(const tU32 &tBackgroundTimeParam) {
   //init parameter
   (tVoid)memcpy(&tBackgroundTime,(tVoid*)&tBackgroundTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBackgroundTimeParam' in function 'dp_tclSpmDpConfigBackgroundTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigBackgroundTime::u8GetData(tU32& tBackgroundTimeParam) {  
   vUpdate();
   tBackgroundTimeParam = tBackgroundTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigBackgroundTime::vSetData(tU32 &tBackgroundTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tBackgroundTime,(tVoid*)&tBackgroundTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tBackgroundTimeParam' in function 'dp_tclSpmDpConfigBackgroundTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigBackgroundTime::vSetData(const tU32 &tBackgroundTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tBackgroundTime,(tVoid*)&tBackgroundTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tBackgroundTimeParam' in function 'dp_tclSpmDpConfigBackgroundTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigBackgroundTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigBackgroundTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "BackgroundTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigBackgroundTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "BackgroundTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigBackgroundTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BackgroundTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element BackgroundTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DoorOpenTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigDoorOpenTime::dp_tclSpmDpConfigDoorOpenTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDoorOpenTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigDoorOpenTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DoorOpenTime",(tS32) 0x1696bdbd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDoorOpenTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigDoorOpenTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DoorOpenTime", (tS32)0x1696bdbd);
   (tVoid)myDpElem.bFillData((tVoid*)&tDoorOpenTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigDoorOpenTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigDoorOpenTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigDoorOpenTime::tGetData() {
   vUpdate();
   return tDoorOpenTime;
};
tS32 dp_tclSpmDpConfigDoorOpenTime::s32GetData(tU32& tDoorOpenTimeParam) { 
   vUpdate();
   tDoorOpenTimeParam = tDoorOpenTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigDoorOpenTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DoorOpenTime", (tS32)0x1696bdbd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigDoorOpenTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigDoorOpenTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigDoorOpenTime::s32SetData(tU32 &tDoorOpenTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDoorOpenTime,(tVoid*)&tDoorOpenTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDoorOpenTimeParam' in function 'dp_tclSpmDpConfigDoorOpenTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigDoorOpenTime::s32SetData(const tU32 &tDoorOpenTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDoorOpenTime,(tVoid*)&tDoorOpenTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDoorOpenTimeParam' in function 'dp_tclSpmDpConfigDoorOpenTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigDoorOpenTime::u8GetData(tU32& tDoorOpenTimeParam) {  
   vUpdate();
   tDoorOpenTimeParam = tDoorOpenTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigDoorOpenTime::vSetData(tU32 &tDoorOpenTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDoorOpenTime,(tVoid*)&tDoorOpenTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDoorOpenTimeParam' in function 'dp_tclSpmDpConfigDoorOpenTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigDoorOpenTime::vSetData(const tU32 &tDoorOpenTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDoorOpenTime,(tVoid*)&tDoorOpenTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDoorOpenTimeParam' in function 'dp_tclSpmDpConfigDoorOpenTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigDoorOpenTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigDoorOpenTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DoorOpenTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDoorOpenTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DoorOpenTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDoorOpenTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DoorOpenTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element DoorOpenTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ClockDisplayTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigClockDisplayTime::dp_tclSpmDpConfigClockDisplayTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tClockDisplayTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigClockDisplayTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ClockDisplayTime",(tS32) 0x25f3dce9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tClockDisplayTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigClockDisplayTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ClockDisplayTime", (tS32)0x25f3dce9);
   (tVoid)myDpElem.bFillData((tVoid*)&tClockDisplayTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigClockDisplayTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigClockDisplayTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigClockDisplayTime::tGetData() {
   vUpdate();
   return tClockDisplayTime;
};
tS32 dp_tclSpmDpConfigClockDisplayTime::s32GetData(tU32& tClockDisplayTimeParam) { 
   vUpdate();
   tClockDisplayTimeParam = tClockDisplayTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigClockDisplayTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ClockDisplayTime", (tS32)0x25f3dce9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigClockDisplayTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigClockDisplayTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigClockDisplayTime::s32SetData(tU32 &tClockDisplayTimeParam) {
   //init parameter
   (tVoid)memcpy(&tClockDisplayTime,(tVoid*)&tClockDisplayTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tClockDisplayTimeParam' in function 'dp_tclSpmDpConfigClockDisplayTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigClockDisplayTime::s32SetData(const tU32 &tClockDisplayTimeParam) {
   //init parameter
   (tVoid)memcpy(&tClockDisplayTime,(tVoid*)&tClockDisplayTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tClockDisplayTimeParam' in function 'dp_tclSpmDpConfigClockDisplayTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigClockDisplayTime::u8GetData(tU32& tClockDisplayTimeParam) {  
   vUpdate();
   tClockDisplayTimeParam = tClockDisplayTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigClockDisplayTime::vSetData(tU32 &tClockDisplayTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tClockDisplayTime,(tVoid*)&tClockDisplayTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tClockDisplayTimeParam' in function 'dp_tclSpmDpConfigClockDisplayTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigClockDisplayTime::vSetData(const tU32 &tClockDisplayTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tClockDisplayTime,(tVoid*)&tClockDisplayTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tClockDisplayTimeParam' in function 'dp_tclSpmDpConfigClockDisplayTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigClockDisplayTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigClockDisplayTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "ClockDisplayTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigClockDisplayTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "ClockDisplayTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigClockDisplayTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ClockDisplayTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element ClockDisplayTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DownloadTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigDownloadTime::dp_tclSpmDpConfigDownloadTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDownloadTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigDownloadTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DownloadTime",(tS32) 0x178f5d33);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tDownloadTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigDownloadTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DownloadTime", (tS32)0x178f5d33);
   (tVoid)myDpElem.bFillData((tVoid*)&tDownloadTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigDownloadTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigDownloadTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpConfigDownloadTime::tGetData() {
   vUpdate();
   return tDownloadTime;
};
tS32 dp_tclSpmDpConfigDownloadTime::s32GetData(tU32& tDownloadTimeParam) { 
   vUpdate();
   tDownloadTimeParam = tDownloadTime;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigDownloadTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DownloadTime", (tS32)0x178f5d33);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigDownloadTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigDownloadTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigDownloadTime::s32SetData(tU32 &tDownloadTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDownloadTime,(tVoid*)&tDownloadTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDownloadTimeParam' in function 'dp_tclSpmDpConfigDownloadTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpConfigDownloadTime::s32SetData(const tU32 &tDownloadTimeParam) {
   //init parameter
   (tVoid)memcpy(&tDownloadTime,(tVoid*)&tDownloadTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDownloadTimeParam' in function 'dp_tclSpmDpConfigDownloadTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigDownloadTime::u8GetData(tU32& tDownloadTimeParam) {  
   vUpdate();
   tDownloadTimeParam = tDownloadTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigDownloadTime::vSetData(tU32 &tDownloadTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDownloadTime,(tVoid*)&tDownloadTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDownloadTimeParam' in function 'dp_tclSpmDpConfigDownloadTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpConfigDownloadTime::vSetData(const tU32 &tDownloadTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tDownloadTime,(tVoid*)&tDownloadTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tDownloadTimeParam' in function 'dp_tclSpmDpConfigDownloadTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpConfigDownloadTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigDownloadTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DownloadTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDownloadTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "DownloadTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigDownloadTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DownloadTime", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element DownloadTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ShutdownLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigShutdownLevel::dp_tclSpmDpConfigShutdownLevel() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tShutdownLevel(1)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigShutdownLevel::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SHUTDOWN_LEVEL",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tShutdownLevel = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigShutdownLevel::u8GetData(tU32& tShutdownLevelParam) {
   vUpdate();
   tShutdownLevelParam = tShutdownLevel;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigShutdownLevel::tGetData() {
   vUpdate();
   return tShutdownLevel;
};

tU8 dp_tclSpmDpConfigShutdownLevel::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigShutdownLevel::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MissingProcRst"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigMissingProcRst::dp_tclSpmDpConfigMissingProcRst() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tMissingProcRst(1)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigMissingProcRst::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MISSING_PROC_RST",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tMissingProcRst = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigMissingProcRst::u8GetData(tU32& tMissingProcRstParam) {
   vUpdate();
   tMissingProcRstParam = tMissingProcRst;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigMissingProcRst::tGetData() {
   vUpdate();
   return tMissingProcRst;
};

tU8 dp_tclSpmDpConfigMissingProcRst::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigMissingProcRst::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyFuncAllowed"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigEarlyFuncAllowed::dp_tclSpmDpConfigEarlyFuncAllowed() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tEarlyFuncAllowed(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigEarlyFuncAllowed::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EARLY_FUNC_ALLOWED",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tEarlyFuncAllowed = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigEarlyFuncAllowed::u8GetData(tU32& tEarlyFuncAllowedParam) {
   vUpdate();
   tEarlyFuncAllowedParam = tEarlyFuncAllowed;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigEarlyFuncAllowed::tGetData() {
   vUpdate();
   return tEarlyFuncAllowed;
};

tU8 dp_tclSpmDpConfigEarlyFuncAllowed::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigEarlyFuncAllowed::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StartupSystemUp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigStartupSystemUp::dp_tclSpmDpConfigStartupSystemUp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tStartupSystemUp(90)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigStartupSystemUp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("STARTUP_SYSTEM_UP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tStartupSystemUp = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigStartupSystemUp::u8GetData(tU32& tStartupSystemUpParam) {
   vUpdate();
   tStartupSystemUpParam = tStartupSystemUp;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigStartupSystemUp::tGetData() {
   vUpdate();
   return tStartupSystemUp;
};

tU8 dp_tclSpmDpConfigStartupSystemUp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigStartupSystemUp::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StartupSystemRunning"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigStartupSystemRunning::dp_tclSpmDpConfigStartupSystemRunning() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tStartupSystemRunning(180)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigStartupSystemRunning::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("STARTUP_SYSTEM_RUNNING",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tStartupSystemRunning = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigStartupSystemRunning::u8GetData(tU32& tStartupSystemRunningParam) {
   vUpdate();
   tStartupSystemRunningParam = tStartupSystemRunning;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigStartupSystemRunning::tGetData() {
   vUpdate();
   return tStartupSystemRunning;
};

tU8 dp_tclSpmDpConfigStartupSystemRunning::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigStartupSystemRunning::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MaxResetCount2StartMinTargetLcm"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm::dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tMaxResetCount2StartMinTargetLcm(8)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_LCM_RST_START_MIN_TARGET",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tMaxResetCount2StartMinTargetLcm = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm::u8GetData(tU32& tMaxResetCount2StartMinTargetLcmParam) {
   vUpdate();
   tMaxResetCount2StartMinTargetLcmParam = tMaxResetCount2StartMinTargetLcm;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm::tGetData() {
   vUpdate();
   return tMaxResetCount2StartMinTargetLcm;
};

tU8 dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MaxResetCount2StartMinTargetBootloader"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader::dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tMaxResetCount2StartMinTargetBootloader(6)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_BOOTLOADER_RST_START_MIN_TARGET",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tMaxResetCount2StartMinTargetBootloader = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader::u8GetData(tU32& tMaxResetCount2StartMinTargetBootloaderParam) {
   vUpdate();
   tMaxResetCount2StartMinTargetBootloaderParam = tMaxResetCount2StartMinTargetBootloader;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader::tGetData() {
   vUpdate();
   return tMaxResetCount2StartMinTargetBootloader;
};

tU8 dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LowVoltageShutdownTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigLowVoltageShutdownTime::dp_tclSpmDpConfigLowVoltageShutdownTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tLowVoltageShutdownTime(60000)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigLowVoltageShutdownTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW_SHUTD_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tLowVoltageShutdownTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigLowVoltageShutdownTime::u8GetData(tU32& tLowVoltageShutdownTimeParam) {
   vUpdate();
   tLowVoltageShutdownTimeParam = tLowVoltageShutdownTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigLowVoltageShutdownTime::tGetData() {
   vUpdate();
   return tLowVoltageShutdownTime;
};

tU8 dp_tclSpmDpConfigLowVoltageShutdownTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigLowVoltageShutdownTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CriticalLowVoltageShutdownTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigCriticalLowVoltageShutdownTime::dp_tclSpmDpConfigCriticalLowVoltageShutdownTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCriticalLowVoltageShutdownTime(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigCriticalLowVoltageShutdownTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CR_LOW_SHUTD_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCriticalLowVoltageShutdownTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigCriticalLowVoltageShutdownTime::u8GetData(tU32& tCriticalLowVoltageShutdownTimeParam) {
   vUpdate();
   tCriticalLowVoltageShutdownTimeParam = tCriticalLowVoltageShutdownTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigCriticalLowVoltageShutdownTime::tGetData() {
   vUpdate();
   return tCriticalLowVoltageShutdownTime;
};

tU8 dp_tclSpmDpConfigCriticalLowVoltageShutdownTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigCriticalLowVoltageShutdownTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "InitialSystemState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigInitialSystemState::dp_tclSpmDpConfigInitialSystemState() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tInitialSystemState(5)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigInitialSystemState::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SYSTEM_STATE_INIT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tInitialSystemState = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigInitialSystemState::u8GetData(tU32& tInitialSystemStateParam) {
   vUpdate();
   tInitialSystemStateParam = tInitialSystemState;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigInitialSystemState::tGetData() {
   vUpdate();
   return tInitialSystemState;
};

tU8 dp_tclSpmDpConfigInitialSystemState::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigInitialSystemState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "InitialTrigger"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigInitialTrigger::dp_tclSpmDpConfigInitialTrigger() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tInitialTrigger(0xffffffff)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigInitialTrigger::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("TRIGGER_INIT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tInitialTrigger = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigInitialTrigger::u8GetData(tU32& tInitialTriggerParam) {
   vUpdate();
   tInitialTriggerParam = tInitialTrigger;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigInitialTrigger::tGetData() {
   vUpdate();
   return tInitialTrigger;
};

tU8 dp_tclSpmDpConfigInitialTrigger::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigInitialTrigger::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LongPressEject"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigLongPressEject::dp_tclSpmDpConfigLongPressEject() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tLongPressEject(5)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigLongPressEject::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LONGPRESS_EJECT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tLongPressEject = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigLongPressEject::u8GetData(tU32& tLongPressEjectParam) {
   vUpdate();
   tLongPressEjectParam = tLongPressEject;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigLongPressEject::tGetData() {
   vUpdate();
   return tLongPressEject;
};

tU8 dp_tclSpmDpConfigLongPressEject::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigLongPressEject::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuLoadOverallThreshold"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigCpuLoadOverallThreshold::dp_tclSpmDpConfigCpuLoadOverallThreshold() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuLoadOverallThreshold(90)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigCpuLoadOverallThreshold::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SVM_LOAD_OVERALL_THRESHOLD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuLoadOverallThreshold = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigCpuLoadOverallThreshold::u8GetData(tU32& tCpuLoadOverallThresholdParam) {
   vUpdate();
   tCpuLoadOverallThresholdParam = tCpuLoadOverallThreshold;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigCpuLoadOverallThreshold::tGetData() {
   vUpdate();
   return tCpuLoadOverallThreshold;
};

tU8 dp_tclSpmDpConfigCpuLoadOverallThreshold::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigCpuLoadOverallThreshold::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuLoadProcessThreshold"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigCpuLoadProcessThreshold::dp_tclSpmDpConfigCpuLoadProcessThreshold() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuLoadProcessThreshold(30)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigCpuLoadProcessThreshold::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SVM_LOAD_PROC_THRESHOLD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuLoadProcessThreshold = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigCpuLoadProcessThreshold::u8GetData(tU32& tCpuLoadProcessThresholdParam) {
   vUpdate();
   tCpuLoadProcessThresholdParam = tCpuLoadProcessThreshold;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigCpuLoadProcessThreshold::tGetData() {
   vUpdate();
   return tCpuLoadProcessThreshold;
};

tU8 dp_tclSpmDpConfigCpuLoadProcessThreshold::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigCpuLoadProcessThreshold::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuLoadPerWarnTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigCpuLoadPerWarnTime::dp_tclSpmDpConfigCpuLoadPerWarnTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuLoadPerWarnTime(60)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigCpuLoadPerWarnTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SVM_LOAD_PREWARN_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuLoadPerWarnTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigCpuLoadPerWarnTime::u8GetData(tU32& tCpuLoadPerWarnTimeParam) {
   vUpdate();
   tCpuLoadPerWarnTimeParam = tCpuLoadPerWarnTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigCpuLoadPerWarnTime::tGetData() {
   vUpdate();
   return tCpuLoadPerWarnTime;
};

tU8 dp_tclSpmDpConfigCpuLoadPerWarnTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigCpuLoadPerWarnTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuLoadWarnTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigCpuLoadWarnTime::dp_tclSpmDpConfigCpuLoadWarnTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuLoadWarnTime(300)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigCpuLoadWarnTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SVM_LOAD_WARN_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuLoadWarnTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigCpuLoadWarnTime::u8GetData(tU32& tCpuLoadWarnTimeParam) {
   vUpdate();
   tCpuLoadWarnTimeParam = tCpuLoadWarnTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigCpuLoadWarnTime::tGetData() {
   vUpdate();
   return tCpuLoadWarnTime;
};

tU8 dp_tclSpmDpConfigCpuLoadWarnTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigCpuLoadWarnTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuLoadWarnInfo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigCpuLoadWarnInfo::dp_tclSpmDpConfigCpuLoadWarnInfo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCpuLoadWarnInfo,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpConfigCpuLoadWarnInfo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CpuLoadWarnInfo",(tS32) 0xde0bde98);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tCpuLoadWarnInfo = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpConfigCpuLoadWarnInfo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CpuLoadWarnInfo", (tS32)0xde0bde98);
   (tVoid)myDpElem.bFillData((tVoid*)&tCpuLoadWarnInfo, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpConfigCpuLoadWarnInfo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpConfigCpuLoadWarnInfo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpConfigCpuLoadWarnInfo::tGetData() {
   vUpdate();
   return tCpuLoadWarnInfo;
};
tS32 dp_tclSpmDpConfigCpuLoadWarnInfo::s32GetData(tBool& tCpuLoadWarnInfoParam) { 
   vUpdate();
   tCpuLoadWarnInfoParam = tCpuLoadWarnInfo;
   return _s32Status;
}
tS32 dp_tclSpmDpConfigCpuLoadWarnInfo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CpuLoadWarnInfo", (tS32)0xde0bde98);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpConfigCpuLoadWarnInfo::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpConfigCpuLoadWarnInfo::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpConfigCpuLoadWarnInfo::s32SetData(tBool &tCpuLoadWarnInfoParam) {
   //init parameter
   (tVoid)memcpy(&tCpuLoadWarnInfo,(tVoid*)&tCpuLoadWarnInfoParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCpuLoadWarnInfoParam' in function 'dp_tclSpmDpConfigCpuLoadWarnInfo::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpConfigCpuLoadWarnInfo::s32SetData(const tBool &tCpuLoadWarnInfoParam) {
   //init parameter
   (tVoid)memcpy(&tCpuLoadWarnInfo,(tVoid*)&tCpuLoadWarnInfoParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCpuLoadWarnInfoParam' in function 'dp_tclSpmDpConfigCpuLoadWarnInfo::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpConfigCpuLoadWarnInfo::u8GetData(tBool& tCpuLoadWarnInfoParam) {  
   vUpdate();
   tCpuLoadWarnInfoParam = tCpuLoadWarnInfo;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigCpuLoadWarnInfo::vSetData(tBool &tCpuLoadWarnInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tCpuLoadWarnInfo,(tVoid*)&tCpuLoadWarnInfoParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tCpuLoadWarnInfoParam' in function 'dp_tclSpmDpConfigCpuLoadWarnInfo::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpConfigCpuLoadWarnInfo::vSetData(const tBool &tCpuLoadWarnInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tCpuLoadWarnInfo,(tVoid*)&tCpuLoadWarnInfoParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tCpuLoadWarnInfoParam' in function 'dp_tclSpmDpConfigCpuLoadWarnInfo::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpConfigCpuLoadWarnInfo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpConfigCpuLoadWarnInfo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPCONFIG, "CpuLoadWarnInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigCpuLoadWarnInfo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPCONFIG, "CpuLoadWarnInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpConfigCpuLoadWarnInfo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CpuLoadWarnInfo", DP_U32_POOL_ID_SPMDPCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPCONFIG);
   }
   else
   {
      fprintf(stdout,"Element CpuLoadWarnInfo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WdtHeartbeatResetTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigWdtHeartbeatResetTime::dp_tclSpmDpConfigWdtHeartbeatResetTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tWdtHeartbeatResetTime(10)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigWdtHeartbeatResetTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HEARTBEAT_RESET_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tWdtHeartbeatResetTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigWdtHeartbeatResetTime::u8GetData(tU32& tWdtHeartbeatResetTimeParam) {
   vUpdate();
   tWdtHeartbeatResetTimeParam = tWdtHeartbeatResetTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigWdtHeartbeatResetTime::tGetData() {
   vUpdate();
   return tWdtHeartbeatResetTime;
};

tU8 dp_tclSpmDpConfigWdtHeartbeatResetTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigWdtHeartbeatResetTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WdtCcaHeartbeatTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigWdtCcaHeartbeatTime::dp_tclSpmDpConfigWdtCcaHeartbeatTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tWdtCcaHeartbeatTime(5)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigWdtCcaHeartbeatTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CCA_HEARTBEAT_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tWdtCcaHeartbeatTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigWdtCcaHeartbeatTime::u8GetData(tU32& tWdtCcaHeartbeatTimeParam) {
   vUpdate();
   tWdtCcaHeartbeatTimeParam = tWdtCcaHeartbeatTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigWdtCcaHeartbeatTime::tGetData() {
   vUpdate();
   return tWdtCcaHeartbeatTime;
};

tU8 dp_tclSpmDpConfigWdtCcaHeartbeatTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigWdtCcaHeartbeatTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CcaMsgWaitTimeout"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigCcaMsgWaitTimeout::dp_tclSpmDpConfigCcaMsgWaitTimeout() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCcaMsgWaitTimeout(1000)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigCcaMsgWaitTimeout::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CCA_MSGQ_WAIT_TIMEOUT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCcaMsgWaitTimeout = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigCcaMsgWaitTimeout::u8GetData(tU32& tCcaMsgWaitTimeoutParam) {
   vUpdate();
   tCcaMsgWaitTimeoutParam = tCcaMsgWaitTimeout;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigCcaMsgWaitTimeout::tGetData() {
   vUpdate();
   return tCcaMsgWaitTimeout;
};

tU8 dp_tclSpmDpConfigCcaMsgWaitTimeout::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigCcaMsgWaitTimeout::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


tU8 dp_tclSpmDpConfigWatermarkConfigFile::u8GetData(tString &tWatermarkConfigFileParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("WATERMARK_CONFIG", tWatermarkConfigFileParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclSpmDpConfigWatermarkConfigFile::u8GetData(const tString &tWatermarkConfigFileParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("WATERMARK_CONFIG", tWatermarkConfigFileParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclSpmDpConfigWatermarkConfigFile::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NetworkTimeoutErrorCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigNetworkTimeoutErrorCount::dp_tclSpmDpConfigNetworkTimeoutErrorCount() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tNetworkTimeoutErrorCount(10)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigNetworkTimeoutErrorCount::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("NETWORK_TO_ERR_CNT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tNetworkTimeoutErrorCount = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigNetworkTimeoutErrorCount::u8GetData(tU32& tNetworkTimeoutErrorCountParam) {
   vUpdate();
   tNetworkTimeoutErrorCountParam = tNetworkTimeoutErrorCount;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigNetworkTimeoutErrorCount::tGetData() {
   vUpdate();
   return tNetworkTimeoutErrorCount;
};

tU8 dp_tclSpmDpConfigNetworkTimeoutErrorCount::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigNetworkTimeoutErrorCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NetworkTimeoutErrorTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigNetworkTimeoutErrorTime::dp_tclSpmDpConfigNetworkTimeoutErrorTime() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tNetworkTimeoutErrorTime(900)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigNetworkTimeoutErrorTime::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("NETWORK_TO_ERR_TIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tNetworkTimeoutErrorTime = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigNetworkTimeoutErrorTime::u8GetData(tU32& tNetworkTimeoutErrorTimeParam) {
   vUpdate();
   tNetworkTimeoutErrorTimeParam = tNetworkTimeoutErrorTime;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigNetworkTimeoutErrorTime::tGetData() {
   vUpdate();
   return tNetworkTimeoutErrorTime;
};

tU8 dp_tclSpmDpConfigNetworkTimeoutErrorTime::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigNetworkTimeoutErrorTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ResetDisable"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigResetDisable::dp_tclSpmDpConfigResetDisable() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tResetDisable(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigResetDisable::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("RESET_DISABLED",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tResetDisable = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigResetDisable::u8GetData(tU32& tResetDisableParam) {
   vUpdate();
   tResetDisableParam = tResetDisable;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigResetDisable::tGetData() {
   vUpdate();
   return tResetDisable;
};

tU8 dp_tclSpmDpConfigResetDisable::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigResetDisable::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StartupControllerFinish"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpConfigStartupControllerFinish::dp_tclSpmDpConfigStartupControllerFinish() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tStartupControllerFinish(30000)
{
   vUpdate();
}

tVoid dp_tclSpmDpConfigStartupControllerFinish::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("STARTUPCONTROLLER",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tStartupControllerFinish = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpConfigStartupControllerFinish::u8GetData(tU32& tStartupControllerFinishParam) {
   vUpdate();
   tStartupControllerFinishParam = tStartupControllerFinish;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpConfigStartupControllerFinish::tGetData() {
   vUpdate();
   return tStartupControllerFinish;
};

tU8 dp_tclSpmDpConfigStartupControllerFinish::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpConfigStartupControllerFinish::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FakeDeviceConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpConfigFakeDeviceConfig::dp_tclSpmDpConfigFakeDeviceConfig(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tFakeDeviceConfig,0,sizeof(tBool));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpConfigFakeDeviceConfig::vSetData(tBool &tFakeDeviceConfigParam) {
   //init parameter
   (tVoid)memcpy(&tFakeDeviceConfig,(tVoid*)&tFakeDeviceConfigParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tFakeDeviceConfigParam' in function 'dp_tclSpmDpConfigFakeDeviceConfig::vSetData(tBool)' could be made const reference

tVoid dp_tclSpmDpConfigFakeDeviceConfig::vSetData(const tBool &tFakeDeviceConfigParam) {
   //init parameter
   (tVoid)memcpy(&tFakeDeviceConfig,(tVoid*)&tFakeDeviceConfigParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tFakeDeviceConfigParam' in function 'dp_tclSpmDpConfigFakeDeviceConfig::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpConfigFakeDeviceConfig::operator<<(tBool oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpConfigFakeDeviceConfig::u8GetData(tBool& tFakeDeviceConfigParam) {
   vUpdate();
   tFakeDeviceConfigParam = tFakeDeviceConfig;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpConfigFakeDeviceConfig::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpConfigFakeDeviceConfig::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tFakeDeviceConfig, &VtspSram->tFakeDeviceConfig,sizeof(tBool))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpConfigFakeDeviceConfig::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tFakeDeviceConfig,&VtspSram->tFakeDeviceConfig, sizeof(tBool));
}
tU8 dp_tclSpmDpConfigFakeDeviceConfig::u8DataValid() const {return _u8DataStatus;};

tBool dp_tclSpmDpConfigFakeDeviceConfig::tGetData() {
   vUpdate();
   return tFakeDeviceConfig;
};

