#ifndef _DP_FI_SRV_IF_H
#define _DP_FI_SRV_IF_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif

#define DP_FI_TRACE_CLASS              (tU16)(TR_COMP_DATAPOOL + 0x03) 
    
class dp_tclSrvIf{
private:
   tU16 _u16AccessId;
   tVoid vInit();
public:
   //dp_tclSpmEngResetStatistic(TSpmResetStatistics tResetStatParam);
   dp_tclSrvIf(){
       _u16AccessId DP_DATAPOOL_ID;
   };
   virtual ~dp_tclSrvIf();
   
   //trace functions
   tVoid vTracePoolElement(tVoid) const;
   tVoid vTracePoolElement(tU32 u32PoolId) const;
   tVoid vTracePoolElementByName(const tChar* pcName) const;
   tVoid vTracePoolHistory() const;
   tVoid vTraceNonPoolElements(tU32 u32PoolId=0x47114711) const;
   //spm,diagnose functions for store, set to default, set/update all coding data, calc hash
   tS32 s32StoreNow(tU32 u32Timeout = 5000) const;
   tS32 s32SetDefault(tU32 u32DefType, tU32 u32Timeout = 5000) const;
   tS32 s32SetConfig(tU32 u32PoolId, tU32 u32Timeout = 5000) const;
   tS32 s32CalcHash(tU32* pu32Data, tU32 u32DataLen, tU32 u32Timeout = 5000) const;
   //store pool now
   tS32 s32StorePoolNow(tU32 u32PoolId) const;
   //spm,diagnose and usermanager functions for lock and unlock pool
   tS32 s32Lock(tU32 u32LockType, tU32 u32Timeout = 5000) const;
   tS32 s32Unlock(tU32 u32Timeout = 5000) const;
   // user manager functions for manage end user and this banks
   tS32 s32SetEndUser(tU8 u8EndUser) const;
   tS32 s32GetEndUser(tU8& u8EndUser) const;
   tS32 s32CopyEndUser(tU8 u8EndUserFrom, tU8 u8EndUserTo , tU32 u32Timeout = 5000) const;
   tS32 s32LoadBankToCurrentEndUser(tU8 u8Bank, tU32 u32Timeout = 5000) const;
   tS32 s32SaveCurrentEndUserToBank(tU8 u8Bank, tU32 u32Timeout = 5000) const;
   tS32 s32GetBank(tU8& u8Bank) const;
   tS32 s32SetEndUserDefault(tU8 u8EndUser, tU32 u32Timeout = 5000) const;
   tS32 s32SetBankDefault(tU8 u8Bank, tU32 u32Timeout = 5000) const;
  
};

#endif
