#ifndef _DP_FI_EMP_LH_H
#define _DP_FI_EMP_LH_H

extern tVoid vInitEMP_LH(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclEMP_LHSelectedMediaLanguages_CMP{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclEMP_LHSelectedMediaLanguages_CMP(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEMP_LHSelectedMediaLanguages_CMP() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tSelectedMediaLanguages_CMPParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tSelectedMediaLanguages_CMPParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tSelectedMediaLanguages_CMPParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclEMP_LHSelectedMediaLanguages_CMPSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tSelectedMediaLanguages_CMPSize;
   
public:
   dp_tclEMP_LHSelectedMediaLanguages_CMPSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEMP_LHSelectedMediaLanguages_CMPSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tSelectedMediaLanguages_CMPSizeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tSelectedMediaLanguages_CMPSizeParam);
   tS32  s32SetData(const tU16 &tSelectedMediaLanguages_CMPSizeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tSelectedMediaLanguages_CMPSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tSelectedMediaLanguages_CMPSizeParam);
   tVoid vSetData(const tU16& tSelectedMediaLanguages_CMPSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEMP_LHSelectedMediaLanguages_CMR{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclEMP_LHSelectedMediaLanguages_CMR(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEMP_LHSelectedMediaLanguages_CMR() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tSelectedMediaLanguages_CMRParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tSelectedMediaLanguages_CMRParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tSelectedMediaLanguages_CMRParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclEMP_LHSelectedMediaLanguages_CMRSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tSelectedMediaLanguages_CMRSize;
   
public:
   dp_tclEMP_LHSelectedMediaLanguages_CMRSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEMP_LHSelectedMediaLanguages_CMRSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tSelectedMediaLanguages_CMRSizeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tSelectedMediaLanguages_CMRSizeParam);
   tS32  s32SetData(const tU16 &tSelectedMediaLanguages_CMRSizeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tSelectedMediaLanguages_CMRSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tSelectedMediaLanguages_CMRSizeParam);
   tVoid vSetData(const tU16& tSelectedMediaLanguages_CMRSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
