
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"
   
#include "dp_tclKdsProd.h"


//##########################################################
//#######  AesSecurityKey  (Key: 0x1215)          
//##########################################################

dp_tclKdsAesSecurityKey::dp_tclKdsAesSecurityKey() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_AESSECURITYKEY_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsAesSecurityKey::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsAesSecurityKey::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x1215, 0x10, pu8CurPos)) {
      pu8CurPos += 0x10;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsAesSecurityKey::u8GetAesSecurityKey(tU8* pu8Data, tU16 u16BufLen) {
   if (0x10<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_AESSECURITYKEY_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsAesSecurityKey::u8DataValid() const {return _u8DataStatus;};


//##########################################################
//#######  DimmingCalibrationParameterSet  (Key: 0x0D09)          
//##########################################################

dp_tclKdsDimmingCalibrationParameterSet::dp_tclKdsDimmingCalibrationParameterSet() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsDimmingCalibrationParameterSet::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsDimmingCalibrationParameterSet::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0D09, 0xa, pu8CurPos)) {
      pu8CurPos += 0xa;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsDimmingCalibrationParameterSet::u8GetDimmingCalibrationParameterSet(tU8* pu8Data, tU16 u16BufLen) {
   if (0xa<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_DIMMINGCALIBRATIONPARAMETERSET_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsDimmingCalibrationParameterSet::u8DataValid() const {return _u8DataStatus;};
//Key 'KEYBLED0CALIBRATIONVALUE':  [0,0] -> [1,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingCalibrationParameterSet::u8GetKEYBLED0CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYBLED1CALIBRATIONVALUE':  [2,0] -> [3,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingCalibrationParameterSet::u8GetKEYBLED1CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[2], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYBLED2CALIBRATIONVALUE':  [4,0] -> [5,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingCalibrationParameterSet::u8GetKEYBLED2CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[4], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYBLED3CALIBRATIONVALUE':  [6,0] -> [7,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingCalibrationParameterSet::u8GetKEYBLED3CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[6], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYBLED4CALIBRATIONVALUE':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingCalibrationParameterSet::u8GetKEYBLED4CALIBRATIONVALUE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  ECUSerialNumber  (Key: 0x0106)          
//##########################################################

dp_tclKdsECUSerialNumber::dp_tclKdsECUSerialNumber() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_ECUSERIALNUMBER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsECUSerialNumber::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsECUSerialNumber::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0106, 0x7, pu8CurPos)) {
      pu8CurPos += 0x7;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsECUSerialNumber::u8GetECUSerialNumber(tU8* pu8Data, tU16 u16BufLen) {
   if (0x7<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_ECUSERIALNUMBER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsECUSerialNumber::u8DataValid() const {return _u8DataStatus;};


//##########################################################
//#######  NavUnitID  (Key: 0x2010)          
//##########################################################

dp_tclKdsNavUnitID::dp_tclKdsNavUnitID() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_NAVUNITID_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsNavUnitID::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsNavUnitID::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x2010, 0x8, pu8CurPos)) {
      pu8CurPos += 0x8;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsNavUnitID::u8GetNavUnitID(tU8* pu8Data, tU16 u16BufLen) {
   if (0x8<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_NAVUNITID_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsNavUnitID::u8DataValid() const {return _u8DataStatus;};


//##########################################################
//#######  Vin  (Key: 0xA1C8)          
//##########################################################

dp_tclKdsVin::dp_tclKdsVin() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_VIN_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsVin::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsVin::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA1C8, 0x11, pu8CurPos)) {
      pu8CurPos += 0x11;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsVin::u8GetVin(tU8* pu8Data, tU16 u16BufLen) {
   if (0x11<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_VIN_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsVin::u8DataValid() const {return _u8DataStatus;};
