
#ifndef KDSCM
#define KDSCM



//##########################################################
//#######  AIVIVariantCoding  (Key: 0xA114)          
//##########################################################
#define DP_U16_KDSADR_AIVIVARIANTCODING                                             0xA114

#define DP_U8_KDSLEN_AIVIVARIANTCODING_COMPLETE                                     32

#define DP_U8_KDSLEN_AIVIVARIANTCODING_TOUCHI2CADDRESS                              2
#define DP_U8_KDSLEN_AIVIVARIANTCODING_SPREADSPECTRUMCLOCKGENERATIONLVDS            2
#define DP_U8_KDSLEN_AIVIVARIANTCODING_STANDBYTIMEOUT                               2


class dp_tclKdsAIVIVariantCoding{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_AIVIVARIANTCODING_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsAIVIVariantCoding();
   virtual ~dp_tclKdsAIVIVariantCoding() {};
   
   tU8 u8GetVariantSelection(tU8& ru8Data);
   tU8 u8GetActiveConfigurationSet(tU8& ru8Data);
   tU8 u8GetDisplayOutput(tU8& ru8Data);
   tU8 u8GetDisplayOrientation(tU8& ru8Data);
   tU8 u8GetDisplayAspectRatio(tU8& ru8Data);
   tU8 u8GetDispTrClockEdgeSelectLVDS1(tU8& ru8Data);
   tU8 u8GetDispTrClockEdgeSelectLVDS2(tU8& ru8Data);
   tU8 u8GetFM(tU8& ru8Data);
   tU8 u8GetDAB(tU8& ru8Data);
   tU8 u8GetDRM(tU8& ru8Data);
   tU8 u8GetAM(tU8& ru8Data);
   tU8 u8GetDTVType(tU8& ru8Data);
   tU8 u8GetExtendedDTVMountInformation(tU8& ru8Data);
   tU8 u8GetSigma(tU8& ru8Data);
   tU8 u8GetSecurityAccessKeySelector(tU8& ru8Data);
   tU8 u8GetConsistencyCheckSupport(tU8& ru8Data);
   tU8 u8GetHDMI(tU8& ru8Data);
   tU8 u8GetLVDS1(tU8& ru8Data);
   tU8 u8GetLVDS2(tU8& ru8Data);
   tU8 u8GetVGA(tU8& ru8Data);
   tU8 u8GetSoftkeysConfiguration(tU8& ru8Data);
   tU8 u8GetDualDisplaySupport(tU8& ru8Data);
   tU8 u8GetEncoderMirroring(tU8& ru8Data);
   tU8 u8Get2ndEncoderMissing(tU8& ru8Data);
   tU8 u8GetManagedApp(tU8& ru8Data);
   tU8 u8GetSystemTypeSelector(tU8& ru8Data);
   tU8 u8GetBeaconSupport(tU8& ru8Data);
   tU8 u8GetExtendedDVDMountInformation(tU8& ru8Data);
   tU8 u8GetHDMIApp(tU8& ru8Data);
   tU8 u8GetVDIAG(tU8& ru8Data);
   tU8 u8GetCVBS(tU8& ru8Data);
   tU8 u8GetLVDS(tU8& ru8Data);
   tU8 u8GetEthernet(tU8& ru8Data);
   tU8 u8GetTouchI2CAddress(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSpreadSpectrumClockGenerationLVDS(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetVRProcessStartAllowed(tU8& ru8Data);
   tU8 u8GetTTSProcessStartAllowed(tU8& ru8Data);
   tU8 u8GetHourLogicEnabled(tU8& ru8Data);
   tU8 u8GetHourLogicTimeRange(tU8& ru8Data);
   tU8 u8GetMFICertified(tU8& ru8Data);
   tU8 u8GetIOSMySpin(tU8& ru8Data);
   tU8 u8GetStandbyTimeout(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetAIVIVariantCoding(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  SensorConfigACC  (Key: 0x0780)          
//##########################################################
#define DP_U16_KDSADR_SENSORCONFIGACC                                             0x0780

#define DP_U8_KDSLEN_SENSORCONFIGACC_COMPLETE                                     203

#define DP_U8_KDSLEN_SENSORCONFIGACC_TAG                                          8
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINORVERSION                                 2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ADCRANGEMIN                                  4
#define DP_U8_KDSLEN_SENSORCONFIGACC_ADCRANGEMAX                                  4
#define DP_U8_KDSLEN_SENSORCONFIGACC_SAMPLEMIN                                    4
#define DP_U8_KDSLEN_SENSORCONFIGACC_SAMPLEMAX                                    4
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINNOISEVALUEM                               2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ESTIMOFFSETM                                 2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINOFFSETM                                   2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXOFFSETM                                   2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTOFFSETM                                 2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXUNSTEADOFFSETM                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_BESTCALIBOFFSETM                             2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ESTIMSCALEFACTORM                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINSCALEFACTORM                              2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXSCALEFACTORM                              2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTSCALEFACTORM                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXUNSTEADSCALEFACTORM                       2
#define DP_U8_KDSLEN_SENSORCONFIGACC_BESTCALIBSCALEFACTORM                        2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTOFFSETTIMEM                             2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTSCALEFACTORTIMEM                        2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ADCRANGEMIN2                                 4
#define DP_U8_KDSLEN_SENSORCONFIGACC_ADCRANGEMAX2                                 4
#define DP_U8_KDSLEN_SENSORCONFIGACC_SAMPLEMIN2                                   4
#define DP_U8_KDSLEN_SENSORCONFIGACC_SAMPLEMAX2                                   4
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINNOISEVALUEM2                              2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ESTIMOFFSETM2                                2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINOFFSETM2                                  2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXOFFSETM2                                  2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTOFFSETM2                                2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXUNSTEADOFFSETM2                           2
#define DP_U8_KDSLEN_SENSORCONFIGACC_BESTCALIBOFFSETM2                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ESTIMSCALEFACTORM2                           2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINSCALEFACTORM2                             2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXSCALEFACTORM2                             2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTSCALEFACTORM2                           2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXUNSTEADSCALEFACTORM2                      2
#define DP_U8_KDSLEN_SENSORCONFIGACC_BESTCALIBSCALEFACTORM2                       2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTOFFSETTIMEM2                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTSCALEFACTORTIMEM2                       2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ADCRANGEMIN3                                 4
#define DP_U8_KDSLEN_SENSORCONFIGACC_ADCRANGEMAX3                                 4
#define DP_U8_KDSLEN_SENSORCONFIGACC_SAMPLEMIN3                                   4
#define DP_U8_KDSLEN_SENSORCONFIGACC_SAMPLEMAX3                                   4
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINNOISEVALUEM3                              2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ESTIMOFFSETM3                                2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINOFFSETM3                                  2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXOFFSETM3                                  2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTOFFSETM3                                2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXUNSTEADOFFSETM3                           2
#define DP_U8_KDSLEN_SENSORCONFIGACC_BESTCALIBOFFSETM3                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_ESTIMSCALEFACTORM3                           2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MINSCALEFACTORM3                             2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXSCALEFACTORM3                             2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTSCALEFACTORM3                           2
#define DP_U8_KDSLEN_SENSORCONFIGACC_MAXUNSTEADSCALEFACTORM3                      2
#define DP_U8_KDSLEN_SENSORCONFIGACC_BESTCALIBSCALEFACTORM3                       2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTOFFSETTIMEM3                            2
#define DP_U8_KDSLEN_SENSORCONFIGACC_DRIFTSCALEFACTORTIMEM3                       2


class dp_tclKdsSensorConfigACC{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_SENSORCONFIGACC_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsSensorConfigACC();
   virtual ~dp_tclKdsSensorConfigACC() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetACCAngRX(tU8& ru8Data);
   tU8 u8GetACCAngRY(tU8& ru8Data);
   tU8 u8GetACCAngRZ(tU8& ru8Data);
   tU8 u8GetACCAngSX(tU8& ru8Data);
   tU8 u8GetACCAngSY(tU8& ru8Data);
   tU8 u8GetACCAngSZ(tU8& ru8Data);
   tU8 u8GetACCAngTX(tU8& ru8Data);
   tU8 u8GetACCAngTY(tU8& ru8Data);
   tU8 u8GetACCAngTZ(tU8& ru8Data);
   tU8 u8GetAdcRangeMin(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAdcRangeMax(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMin(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMax(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueE(tU8& ru8Data);
   tU8 u8GetEstimOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimOffsetE(tU8& ru8Data);
   tU8 u8GetMinOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinOffsetE(tU8& ru8Data);
   tU8 u8GetMaxOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxOffsetE(tU8& ru8Data);
   tU8 u8GetDriftOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetE(tU8& ru8Data);
   tU8 u8GetMaxUnsteadOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadOffsetE(tU8& ru8Data);
   tU8 u8GetBestCalibOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibOffsetE(tU8& ru8Data);
   tU8 u8GetEstimScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimScaleFactorE(tU8& ru8Data);
   tU8 u8GetMinScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinScaleFactorE(tU8& ru8Data);
   tU8 u8GetMaxScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxScaleFactorE(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorE(tU8& ru8Data);
   tU8 u8GetMaxUnsteadScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadScaleFactorE(tU8& ru8Data);
   tU8 u8GetBestCalibScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibScaleFactorE(tU8& ru8Data);
   tU8 u8GetDriftOffsetTimeM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetTimeE(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorTimeM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorTimeE(tU8& ru8Data);
   tU8 u8GetAdcRangeMin2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAdcRangeMax2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMin2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMax2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueE2(tU8& ru8Data);
   tU8 u8GetEstimOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimOffsetE2(tU8& ru8Data);
   tU8 u8GetMinOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinOffsetE2(tU8& ru8Data);
   tU8 u8GetMaxOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxOffsetE2(tU8& ru8Data);
   tU8 u8GetDriftOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetE2(tU8& ru8Data);
   tU8 u8GetMaxUnsteadOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadOffsetE2(tU8& ru8Data);
   tU8 u8GetBestCalibOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibOffsetE2(tU8& ru8Data);
   tU8 u8GetEstimScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimScaleFactorE2(tU8& ru8Data);
   tU8 u8GetMinScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinScaleFactorE2(tU8& ru8Data);
   tU8 u8GetMaxScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxScaleFactorE2(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorE2(tU8& ru8Data);
   tU8 u8GetMaxUnsteadScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadScaleFactorE2(tU8& ru8Data);
   tU8 u8GetBestCalibScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibScaleFactorE2(tU8& ru8Data);
   tU8 u8GetDriftOffsetTimeM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetTimeE2(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorTimeM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorTimeE2(tU8& ru8Data);
   tU8 u8GetAdcRangeMin3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAdcRangeMax3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMin3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMax3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueE3(tU8& ru8Data);
   tU8 u8GetEstimOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimOffsetE3(tU8& ru8Data);
   tU8 u8GetMinOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinOffsetE3(tU8& ru8Data);
   tU8 u8GetMaxOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxOffsetE3(tU8& ru8Data);
   tU8 u8GetDriftOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetE3(tU8& ru8Data);
   tU8 u8GetMaxUnsteadOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadOffsetE3(tU8& ru8Data);
   tU8 u8GetBestCalibOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibOffsetE3(tU8& ru8Data);
   tU8 u8GetEstimScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimScaleFactorE3(tU8& ru8Data);
   tU8 u8GetMinScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinScaleFactorE3(tU8& ru8Data);
   tU8 u8GetMaxScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxScaleFactorE3(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorE3(tU8& ru8Data);
   tU8 u8GetMaxUnsteadScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadScaleFactorE3(tU8& ru8Data);
   tU8 u8GetBestCalibScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibScaleFactorE3(tU8& ru8Data);
   tU8 u8GetDriftOffsetTimeM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetTimeE3(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorTimeM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorTimeE3(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetSensorConfigACC(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  SensorConfigGNSS  (Key: 0x0530)          
//##########################################################
#define DP_U16_KDSADR_SENSORCONFIGGNSS                                             0x0530

#define DP_U8_KDSLEN_SENSORCONFIGGNSS_COMPLETE                                     12

#define DP_U8_KDSLEN_SENSORCONFIGGNSS_TAG                                          8
#define DP_U8_KDSLEN_SENSORCONFIGGNSS_MINORVERSION                                 2


class dp_tclKdsSensorConfigGNSS{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_SENSORCONFIGGNSS_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsSensorConfigGNSS();
   virtual ~dp_tclKdsSensorConfigGNSS() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetGPS(tU8& ru8Data);
   tU8 u8GetGLONASS(tU8& ru8Data);
   tU8 u8GetGALILEO(tU8& ru8Data);
   tU8 u8GetCOMPASS(tU8& ru8Data);
   tU8 u8GetSBAS(tU8& ru8Data);
   tU8 u8GetQZSS(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetSensorConfigGNSS(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  SensorConfigGyro  (Key: 0x0700)          
//##########################################################
#define DP_U16_KDSADR_SENSORCONFIGGYRO                                             0x0700

#define DP_U8_KDSLEN_SENSORCONFIGGYRO_COMPLETE                                     203

#define DP_U8_KDSLEN_SENSORCONFIGGYRO_TAG                                          8
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINORVERSION                                 2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ADCRANGEMIN                                  4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ADCRANGEMAX                                  4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_SAMPLEMIN                                    4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_SAMPLEMAX                                    4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINNOISEVALUEM                               2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ESTIMOFFSETM                                 2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINOFFSETM                                   2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXOFFSETM                                   2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTOFFSETM                                 2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXUNSTEADOFFSETM                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_BESTCALIBOFFSETM                             2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ESTIMSCALEFACTORM                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINSCALEFACTORM                              2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXSCALEFACTORM                              2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTSCALEFACTORM                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXUNSTEADSCALEFACTORM                       2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_BESTCALIBSCALEFACTORM                        2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTOFFSETTIMEM                             2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTSCALEFACTORTIMEM                        2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ADCRANGEMIN2                                 4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ADCRANGEMAX2                                 4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_SAMPLEMIN2                                   4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_SAMPLEMAX2                                   4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINNOISEVALUEM2                              2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ESTIMOFFSETM2                                2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINOFFSETM2                                  2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXOFFSETM2                                  2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTOFFSETM2                                2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXUNSTEADOFFSETM2                           2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_BESTCALIBOFFSETM2                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ESTIMSCALEFACTORM2                           2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINSCALEFACTORM2                             2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXSCALEFACTORM2                             2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTSCALEFACTORM2                           2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXUNSTEADSCALEFACTORM2                      2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_BESTCALIBSCALEFACTORM2                       2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTOFFSETTIMEM2                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTSCALEFACTORTIMEM2                       2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ADCRANGEMIN3                                 4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ADCRANGEMAX3                                 4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_SAMPLEMIN3                                   4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_SAMPLEMAX3                                   4
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINNOISEVALUEM3                              2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ESTIMOFFSETM3                                2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINOFFSETM3                                  2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXOFFSETM3                                  2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTOFFSETM3                                2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXUNSTEADOFFSETM3                           2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_BESTCALIBOFFSETM3                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_ESTIMSCALEFACTORM3                           2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MINSCALEFACTORM3                             2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXSCALEFACTORM3                             2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTSCALEFACTORM3                           2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_MAXUNSTEADSCALEFACTORM3                      2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_BESTCALIBSCALEFACTORM3                       2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTOFFSETTIMEM3                            2
#define DP_U8_KDSLEN_SENSORCONFIGGYRO_DRIFTSCALEFACTORTIMEM3                       2


class dp_tclKdsSensorConfigGyro{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_SENSORCONFIGGYRO_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsSensorConfigGyro();
   virtual ~dp_tclKdsSensorConfigGyro() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetGyroAngRX(tU8& ru8Data);
   tU8 u8GetGyroAngRY(tU8& ru8Data);
   tU8 u8GetGyroAngRZ(tU8& ru8Data);
   tU8 u8GetGyroAngSX(tU8& ru8Data);
   tU8 u8GetGyroAngSY(tU8& ru8Data);
   tU8 u8GetGyroAngSZ(tU8& ru8Data);
   tU8 u8GetGyroAngTX(tU8& ru8Data);
   tU8 u8GetGyroAngTY(tU8& ru8Data);
   tU8 u8GetGyroAngTZ(tU8& ru8Data);
   tU8 u8GetAdcRangeMin(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAdcRangeMax(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMin(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMax(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueE(tU8& ru8Data);
   tU8 u8GetEstimOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimOffsetE(tU8& ru8Data);
   tU8 u8GetMinOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinOffsetE(tU8& ru8Data);
   tU8 u8GetMaxOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxOffsetE(tU8& ru8Data);
   tU8 u8GetDriftOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetE(tU8& ru8Data);
   tU8 u8GetMaxUnsteadOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadOffsetE(tU8& ru8Data);
   tU8 u8GetBestCalibOffsetM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibOffsetE(tU8& ru8Data);
   tU8 u8GetEstimScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimScaleFactorE(tU8& ru8Data);
   tU8 u8GetMinScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinScaleFactorE(tU8& ru8Data);
   tU8 u8GetMaxScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxScaleFactorE(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorE(tU8& ru8Data);
   tU8 u8GetMaxUnsteadScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadScaleFactorE(tU8& ru8Data);
   tU8 u8GetBestCalibScaleFactorM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibScaleFactorE(tU8& ru8Data);
   tU8 u8GetDriftOffsetTimeM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetTimeE(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorTimeM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorTimeE(tU8& ru8Data);
   tU8 u8GetAdcRangeMin2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAdcRangeMax2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMin2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMax2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueE2(tU8& ru8Data);
   tU8 u8GetEstimOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimOffsetE2(tU8& ru8Data);
   tU8 u8GetMinOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinOffsetE2(tU8& ru8Data);
   tU8 u8GetMaxOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxOffsetE2(tU8& ru8Data);
   tU8 u8GetDriftOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetE2(tU8& ru8Data);
   tU8 u8GetMaxUnsteadOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadOffsetE2(tU8& ru8Data);
   tU8 u8GetBestCalibOffsetM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibOffsetE2(tU8& ru8Data);
   tU8 u8GetEstimScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimScaleFactorE2(tU8& ru8Data);
   tU8 u8GetMinScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinScaleFactorE2(tU8& ru8Data);
   tU8 u8GetMaxScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxScaleFactorE2(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorE2(tU8& ru8Data);
   tU8 u8GetMaxUnsteadScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadScaleFactorE2(tU8& ru8Data);
   tU8 u8GetBestCalibScaleFactorM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibScaleFactorE2(tU8& ru8Data);
   tU8 u8GetDriftOffsetTimeM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetTimeE2(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorTimeM2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorTimeE2(tU8& ru8Data);
   tU8 u8GetAdcRangeMin3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAdcRangeMax3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMin3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSampleMax3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinNoiseValueE3(tU8& ru8Data);
   tU8 u8GetEstimOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimOffsetE3(tU8& ru8Data);
   tU8 u8GetMinOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinOffsetE3(tU8& ru8Data);
   tU8 u8GetMaxOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxOffsetE3(tU8& ru8Data);
   tU8 u8GetDriftOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetE3(tU8& ru8Data);
   tU8 u8GetMaxUnsteadOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadOffsetE3(tU8& ru8Data);
   tU8 u8GetBestCalibOffsetM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibOffsetE3(tU8& ru8Data);
   tU8 u8GetEstimScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetEstimScaleFactorE3(tU8& ru8Data);
   tU8 u8GetMinScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinScaleFactorE3(tU8& ru8Data);
   tU8 u8GetMaxScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxScaleFactorE3(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorE3(tU8& ru8Data);
   tU8 u8GetMaxUnsteadScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxUnsteadScaleFactorE3(tU8& ru8Data);
   tU8 u8GetBestCalibScaleFactorM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBestCalibScaleFactorE3(tU8& ru8Data);
   tU8 u8GetDriftOffsetTimeM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftOffsetTimeE3(tU8& ru8Data);
   tU8 u8GetDriftScaleFactorTimeM3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDriftScaleFactorTimeE3(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetSensorConfigGyro(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  GenericTunerParameter  (Key: 0x0421)          
//##########################################################
#define DP_U16_KDSADR_GENERICTUNERPARAMETER                                             0x0421

#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_COMPLETE                                     417

#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_TAG                                          8
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_MINORVERSION                                 2
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET0                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET1                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET2                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET3                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET4                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET5                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET6                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET7                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET8                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET9                                      4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET10                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET11                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET12                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET13                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET14                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET15                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET16                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET17                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET18                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET19                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET20                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET21                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET22                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET23                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET24                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET25                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET26                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET27                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET28                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET29                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET30                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET2031                                   4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET32                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET33                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET34                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET35                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET36                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET37                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET38                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET39                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET40                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET41                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET42                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET43                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET44                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET45                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET46                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET47                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET48                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET49                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET50                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET51                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET52                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET53                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET54                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET55                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET56                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET57                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET58                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET59                                     4
#define DP_U8_KDSLEN_GENERICTUNERPARAMETER_PRESET60                                     4


class dp_tclKdsGenericTunerParameter{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_GENERICTUNERPARAMETER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsGenericTunerParameter();
   virtual ~dp_tclKdsGenericTunerParameter() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetFM1List(tU8& ru8Data);
   tU8 u8GetFM2List(tU8& ru8Data);
   tU8 u8GetFM3List(tU8& ru8Data);
   tU8 u8GetFMASTList(tU8& ru8Data);
   tU8 u8GetAMMW1List(tU8& ru8Data);
   tU8 u8GetAMMW2List(tU8& ru8Data);
   tU8 u8GetAMMW3List(tU8& ru8Data);
   tU8 u8GetAMMWASTList(tU8& ru8Data);
   tU8 u8GetAMLW1List(tU8& ru8Data);
   tU8 u8GetAMLW2List(tU8& ru8Data);
   tU8 u8GetAMLW3List(tU8& ru8Data);
   tU8 u8GetAMLWASTList(tU8& ru8Data);
   tU8 u8GetDAB1List(tU8& ru8Data);
   tU8 u8GetDAB2List(tU8& ru8Data);
   tU8 u8GetDAB3List(tU8& ru8Data);
   tU8 u8GetDABASTList(tU8& ru8Data);
   tU8 u8GetMIX1List(tU8& ru8Data);
   tU8 u8GetMIX2List(tU8& ru8Data);
   tU8 u8GetMIX3List(tU8& ru8Data);
   tU8 u8GetMIXASTList(tU8& ru8Data);
   tU8 u8GetAutostoreUnusedPresetParameter(tU8& ru8Data);
   tU8 u8GetInitialAutostoreNoOfStations(tU8& ru8Data);
   tU8 u8GetUserAutostoreNoOfStations(tU8& ru8Data);
   tU8 u8GetAutostoreSortingCriteriaFM(tU8& ru8Data);
   tU8 u8GetAutostoreSortingCriteriaAM(tU8& ru8Data);
   tU8 u8GetAutostoreSortingCriteriaDAB(tU8& ru8Data);
   tU8 u8GetShowFrequencyUpdates(tU8& ru8Data);
   tU8 u8GetNoLearnSeek(tU8& ru8Data);
   tU8 u8GetTunnelCheck(tU8& ru8Data);
   tU8 u8GetInitialAutostoreBehavior(tU8& ru8Data);
   tU8 u8GetDefaultBandAfterInitialAutostore(tU8& ru8Data);
   tU8 u8GetUserAutostoreBehavior(tU8& ru8Data);
   tU8 u8GetDefaultBandAfterUserAutostore(tU8& ru8Data);
   tU8 u8GetMuteOrAttenuationForAbsoluteStationChangeAMFM(tU8& ru8Data);
   tU8 u8GetMuteOrAttenuationForSeekAMFM(tU8& ru8Data);
   tU8 u8GetMuteOrAttenuationForManualTuningAMFM(tU8& ru8Data);
   tU8 u8GetTimeToReleaseAttenuationAMFM(tU8& ru8Data);
   tU8 u8GetConsiderLevelCompensationForPresetLoad(tU8& ru8Data);
   tU8 u8GetConsiderLevelCompensationForListLoad(tU8& ru8Data);
   tU8 u8GetMonitorFMTAInAMWithTuner2(tU8& ru8Data);
   tU8 u8GetFMTAMonitorTuner2(tU8& ru8Data);
   tU8 u8GetAudioTunerTPSeek(tU8& ru8Data);
   tU8 u8GetAnnouncementRequestHandling(tU8& ru8Data);
   tU8 u8GetFMTPseekStrategy(tU8& ru8Data);
   tU8 u8GetTimeDelayFMTPStationAfterVolumeZero(tU8& ru8Data);
   tU8 u8GetTimeDelayNoFMTPStationFound(tU8& ru8Data);
   tU8 u8GetTimeDelayFMTPStationSelectAfterRDSLost(tU8& ru8Data);
   tU8 u8GetTimeFMTAEndAfterRDSLost(tU8& ru8Data);
   tU8 u8GetBackgroundTA(tU8& ru8Data);
   tU8 u8GetFMTAInDABIfNoDABTA(tU8& ru8Data);
   tU8 u8GetDABTAInFMIfNoFMTA(tU8& ru8Data);
   tU8 u8GetPreferedTASource(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioFMTA(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioFMPTY31(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioFMNEWS(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABAlarm(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABRoadTrafficFlash(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABTransportFlash(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABWarningService(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABNewsFlash(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABAreaWeatherFlash(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABEventAnnouncement(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABSpecialEvent(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABProgramInformation(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABSportReport(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABFinantialReport(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABReserved1(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABReserved2(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABReserved3(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABReserved4(tU8& ru8Data);
   tU8 u8GetAnnouncementPrioDABReserved5(tU8& ru8Data);
   tU8 u8GetTimeDelayNoDABTPStationFound(tU8& ru8Data);
   tU8 u8GetTimeDABAnnoEndAfterReceptionLost(tU8& ru8Data);
   tU8 u8GetFM(tU8& ru8Data);
   tU8 u8GetDAB(tU8& ru8Data);
   tU8 u8GetXM(tU8& ru8Data);
   tU8 u8GetNumberOfPresetListSXM(tU8& ru8Data);
   tU8 u8GetNumberOfPresetsPerBankSXM(tU8& ru8Data);
   tU8 u8GetPresetListType(tU8& ru8Data);
   tU8 u8GetNumberOfPresetListFM(tU8& ru8Data);
   tU8 u8GetNumberOfBanksHmiFM(tU8& ru8Data);
   tU8 u8GetNumberOfPresetsPerBankFM(tU8& ru8Data);
   tU8 u8GetNumberOfPresetListMW(tU8& ru8Data);
   tU8 u8GetNumberOfBanksHmiMW(tU8& ru8Data);
   tU8 u8GetNumberOfPresetsPerBankMW(tU8& ru8Data);
   tU8 u8GetNumberOfPresetListLW(tU8& ru8Data);
   tU8 u8GetNumberOfBanksHmiLW(tU8& ru8Data);
   tU8 u8GetNumberOfPresetsPerBankLW(tU8& ru8Data);
   tU8 u8GetNumberOfPresetListDAB(tU8& ru8Data);
   tU8 u8GetNumberOfBanksHmiDAB(tU8& ru8Data);
   tU8 u8GetNumberOfPresetsPerBankDAB(tU8& ru8Data);
   tU8 u8GetNumberOfPresetListForMixedAllBands(tU8& ru8Data);
   tU8 u8GetNumberOfBanksHmiForMixedAllBands(tU8& ru8Data);
   tU8 u8GetNumberOfPresetsPerBankForMixedAllBands(tU8& ru8Data);
   tU8 u8GetPreset0(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset6(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset7(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset8(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset9(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset10(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset11(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset12(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset13(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset14(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset15(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset16(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset17(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset18(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset19(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset20(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset21(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset22(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset23(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset24(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset25(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset26(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset27(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset28(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset29(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset30(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset2031(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset32(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset33(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset34(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset35(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset36(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset37(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset38(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset39(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset40(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset41(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset42(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset43(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset44(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset45(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset46(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset47(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset48(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset49(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset50(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset51(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset52(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset53(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset54(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset55(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset56(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset57(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset58(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset59(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPreset60(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetGenericTunerParameter(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  AMFMTunerParameter  (Key: 0x0411)          
//##########################################################
#define DP_U16_KDSADR_AMFMTUNERPARAMETER                                             0x0411

#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_COMPLETE                                     288

#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_TAG                                          8
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_MINORVERSION                                 2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_LOWFM                                        4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_HIGHFM                                       4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_LOWMW                                        4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_HIGHMW                                       4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_LOWLW                                        4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_HIGHLW                                       4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_FMLSM                                        4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_MWLSM                                        4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_LWLSM                                        4
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_TMINIMUMDISPLAYDURATIONPERRADIOTEXTPAGE      2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_AUTOSEEKSTEPDELAY                            2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_PERMANENTMANUALSTEPDELAY                     2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_MUTERAMP1                                    2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_DEMUTERAMP1                                  2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_MUTERAMP2                                    2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_DEMUTERAMP2                                  2
#define DP_U8_KDSLEN_AMFMTUNERPARAMETER_WEATHERBANDLSM                               4


class dp_tclKdsAMFMTunerParameter{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_AMFMTUNERPARAMETER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsAMFMTunerParameter();
   virtual ~dp_tclKdsAMFMTunerParameter() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowFM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighFM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetStepSizeFM(tU8& ru8Data);
   tU8 u8GetManualStepSizeFM(tU8& ru8Data);
   tU8 u8GetLowMW(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighMW(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetStepSizeMW(tU8& ru8Data);
   tU8 u8GetManualStepSizeMW(tU8& ru8Data);
   tU8 u8GetLowLW(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighLW(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetStepSizeLW(tU8& ru8Data);
   tU8 u8GetManualStepSizeLW(tU8& ru8Data);
   tU8 u8GetRDS(tU8& ru8Data);
   tU8 u8GetAF(tU8& ru8Data);
   tU8 u8GetREG(tU8& ru8Data);
   tU8 u8GetPS(tU8& ru8Data);
   tU8 u8GetRadiotext(tU8& ru8Data);
   tU8 u8GetDDA(tU8& ru8Data);
   tU8 u8GetDDS(tU8& ru8Data);
   tU8 u8GetDatascan(tU8& ru8Data);
   tU8 u8GetTA(tU8& ru8Data);
   tU8 u8GetPTY31(tU8& ru8Data);
   tU8 u8GetAFTemporaryONOFF(tU8& ru8Data);
   tU8 u8GetFMLSM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMWLSM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLWLSM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetShowTextWaitingForRadioText(tU8& ru8Data);
   tU8 u8GetShowTextNoRadioTextAvailable1(tU8& ru8Data);
   tU8 u8GetShowTextWaitingForRadioTextWithRDSTimeout(tU8& ru8Data);
   tU8 u8GetTRadioTextNotAvailable(tU8& ru8Data);
   tU8 u8GetTTimeoutStatusRT(tU8& ru8Data);
   tU8 u8GetTShowTextMin(tU8& ru8Data);
   tU8 u8GetTMinimumDisplayDurationPerRadiotextPage(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRadioTextMinimumLength(tU8& ru8Data);
   tU8 u8GetRadioTextSpeedThreshold(tU8& ru8Data);
   tU8 u8GetRadioTextSpeedThresholdHysteresis(tU8& ru8Data);
   tU8 u8GetEmergenySeekScanNumberOfStations(tU8& ru8Data);
   tU8 u8GetShowFrequencyDuringFrequencyScan(tU8& ru8Data);
   tU8 u8GetSeekMode(tU8& ru8Data);
   tU8 u8GetNumberOfSeekPeriods(tU8& ru8Data);
   tU8 u8GetScanTime(tU8& ru8Data);
   tU8 u8GetAFBestDelayTimeAfterManualTuning(tU8& ru8Data);
   tU8 u8GetAFBestDisplayFreezeAfterManualTuning(tU8& ru8Data);
   tU8 u8GetAutoSeekStepDelay(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPermanentManualStepDelay(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetWrongPiAcceptDelayAfterStationSelection(tU8& ru8Data);
   tU8 u8GetWrongPiAcceptAfterStationLost(tU8& ru8Data);
   tU8 u8GetMultiManualStepsWithIntermediateFrequencies(tU8& ru8Data);
   tU8 u8GetStationListsFM(tU8& ru8Data);
   tU8 u8GetStationListsMW(tU8& ru8Data);
   tU8 u8GetStationListsLW(tU8& ru8Data);
   tU8 u8GetStationListsMWLW(tU8& ru8Data);
   tU8 u8GetFMListSortingDefault(tU8& ru8Data);
   tU8 u8GetAMListSortingDefault(tU8& ru8Data);
   tU8 u8GetTInhibitListSortAfterSkip(tU8& ru8Data);
   tU8 u8GetTCursorDelayAfterStationSelect(tU8& ru8Data);
   tU8 u8GetTIMEAMMINTUNELISTREMOVE(tU8& ru8Data);
   tU8 u8GetTIMEAMSTATIONREMOVEAFTERDESELECT(tU8& ru8Data);
   tU8 u8GetAMStationListUpdateStrategy(tU8& ru8Data);
   tU8 u8GetTestmodeUpdateCycle(tU8& ru8Data);
   tU8 u8GetAFListUpdateCycle(tU8& ru8Data);
   tU8 u8GetResortingOfAFList(tU8& ru8Data);
   tU8 u8GetAFlistReleaseBehavior(tU8& ru8Data);
   tU8 u8GetFM2(tU8& ru8Data);
   tU8 u8GetMW2(tU8& ru8Data);
   tU8 u8GetLW2(tU8& ru8Data);
   tU8 u8GetMWLWCombined(tU8& ru8Data);
   tU8 u8GetStartPISeek(tU8& ru8Data);
   tU8 u8GetLastPassedFrequency(tU8& ru8Data);
   tU8 u8GetADRFMChannelSeparation(tU8& ru8Data);
   tU8 u8GetADRFMLimitation(tU8& ru8Data);
   tU8 u8GetADRFMMultipath(tU8& ru8Data);
   tU8 u8GetADRFMHighcut(tU8& ru8Data);
   tU8 u8GetADRFMSoftmute(tU8& ru8Data);
   tU8 u8GetADRAMSoftmute(tU8& ru8Data);
   tU8 u8GetADRFMDeemphasis(tU8& ru8Data);
   tU8 u8GetADRFMFrequencyResponse(tU8& ru8Data);
   tU8 u8GetADRAMFrequencyResponse(tU8& ru8Data);
   tU8 u8GetADRFMMisc(tU8& ru8Data);
   tU8 u8GetADRAMMisc(tU8& ru8Data);
   tU8 u8GetADRFMAntennaAttenuation(tU8& ru8Data);
   tU8 u8GetADRAMAntennaAnttenuation(tU8& ru8Data);
   tU8 u8GetADRAMHicutConfiguration(tU8& ru8Data);
   tU8 u8GetADRAMDeemphasis(tU8& ru8Data);
   tU8 u8GetMuteRamp1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDemuteRamp1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMuteRamp2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDemuteRamp2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetTriggerNotificationOnFieldstrenghtQualityChange(tU8& ru8Data);
   tU8 u8GetSeekLevelFMRDSFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelFMRDSQuality(tU8& ru8Data);
   tU8 u8GetSeekLevelFMNonRDSFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelFMNonRDSQuality(tU8& ru8Data);
   tU8 u8GetSeekLevelLWFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelLWQuality(tU8& ru8Data);
   tU8 u8GetSeekLevelMWFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelMWQuality(tU8& ru8Data);
   tU8 u8GetSeekLevelSWFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelSWQuality(tU8& ru8Data);
   tU8 u8GetSeekLevelTRFFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelTRFQuality(tU8& ru8Data);
   tU8 u8GetSeekLevelWBFieldstrength(tU8& ru8Data);
   tU8 u8GetSeekLevelWBQuality(tU8& ru8Data);
   tU8 u8GetListLevelFMRDSFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelFMRDSQualify(tU8& ru8Data);
   tU8 u8GetListLevelFMNonRDSFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelFMNonRDSQuality(tU8& ru8Data);
   tU8 u8GetListLevelLWFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelLWQuality(tU8& ru8Data);
   tU8 u8GetListLevelMWFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelMWQuality(tU8& ru8Data);
   tU8 u8GetListLevelSWFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelSWQuality(tU8& ru8Data);
   tU8 u8GetListLevelTRFFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelTRFQuality(tU8& ru8Data);
   tU8 u8GetListLevelWBFieldstrength(tU8& ru8Data);
   tU8 u8GetListLevelWBQuality(tU8& ru8Data);
   tU8 u8GetSharxFM(tU8& ru8Data);
   tU8 u8GetSharxAM(tU8& ru8Data);
   tU8 u8GetHicutFM(tU8& ru8Data);
   tU8 u8GetHicutAM(tU8& ru8Data);
   tU8 u8GetAvailableBandsFM(tU8& ru8Data);
   tU8 u8GetAvailableBandsLW(tU8& ru8Data);
   tU8 u8GetAvailableBandsMW(tU8& ru8Data);
   tU8 u8GetAvailableBandsWB(tU8& ru8Data);
   tU8 u8GetAvailableBandsTRF(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW1(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW2(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW3(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW4(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW5(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW6(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW7(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW8(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW9(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW10(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW11(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW12(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW13(tU8& ru8Data);
   tU8 u8GetAvailableBandsSW14(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationFM(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationLW(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationMW(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationWB(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationTRF(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW1(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW2(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW3(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW4(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW5(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW6(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW7(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW8(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW9(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW10(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW11(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW12(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW13(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationSW14(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationCB1(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationFMAndAMSwitchEnabled(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationFMHDSwitchEnabled(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationAMHDSwitchEnabled(tU8& ru8Data);
   tU8 u8GetCombiBandConfigurationDRMSwitchEnabled(tU8& ru8Data);
   tU8 u8GetTPAudioTuner1(tU8& ru8Data);
   tU8 u8GetTPAudioTuner2(tU8& ru8Data);
   tU8 u8GetAFAudioTuner1(tU8& ru8Data);
   tU8 u8GetAFAudioTuner2(tU8& ru8Data);
   tU8 u8GetDDAAudioTuner1(tU8& ru8Data);
   tU8 u8GetDDAAudioTuner2(tU8& ru8Data);
   tU8 u8GetRDSAudioTuner1(tU8& ru8Data);
   tU8 u8GetRDSAudioTuner2(tU8& ru8Data);
   tU8 u8GetPSFixAudioTuner1(tU8& ru8Data);
   tU8 u8GetPSFixAudioTuner2(tU8& ru8Data);
   tU8 u8GetStereoAudioTuner1(tU8& ru8Data);
   tU8 u8GetStereoAudioTuner2(tU8& ru8Data);
   tU8 u8GetREGAudioTuner1(tU8& ru8Data);
   tU8 u8GetREGAudioTuner2(tU8& ru8Data);
   tU8 u8GetPTY31ForAudioTuner1(tU8& ru8Data);
   tU8 u8GetPTY31ForAudioTuner2(tU8& ru8Data);
   tU8 u8GetDDSAudioTuner1(tU8& ru8Data);
   tU8 u8GetDDSAudioTuner2(tU8& ru8Data);
   tU8 u8GetDMQAudioTuner1(tU8& ru8Data);
   tU8 u8GetDMQAudioTuner2(tU8& ru8Data);
   tU8 u8GetADRPhysicalTunerConfigId(tU8& ru8Data);
   tU8 u8GetADRAntennaConfigId(tU8& ru8Data);
   tU8 u8GetExchangeAntennaLevel(tU8& ru8Data);
   tU8 u8GetPITestLevel(tU8& ru8Data);
   tU8 u8GetNRDSLevel(tU8& ru8Data);
   tU8 u8GetEONLevel(tU8& ru8Data);
   tU8 u8GetFMMemoLevel(tU8& ru8Data);
   tU8 u8GetPanicFieldstLevel(tU8& ru8Data);
   tU8 u8GetParamRDSLevel(tU8& ru8Data);
   tU8 u8GetRDSDataAccept(tU8& ru8Data);
   tU8 u8GetPIStepLevel(tU8& ru8Data);
   tU8 u8GetDDAAntennaDistLevel(tU8& ru8Data);
   tU8 u8GetRDSSynDelayCounter(tU8& ru8Data);
   tU8 u8GetMPMeasureLevel(tU8& ru8Data);
   tU8 u8GetMPRestrictionLevel(tU8& ru8Data);
   tU8 u8GetMPVeryBadLevel(tU8& ru8Data);
   tU8 u8GetMPMediumLevel(tU8& ru8Data);
   tU8 u8GetRDSBadLevel(tU8& ru8Data);
   tU8 u8GetIllegalAF(tU8& ru8Data);
   tU8 u8GetAFSaveLevel(tU8& ru8Data);
   tU8 u8GetFirstRundum(tU8& ru8Data);
   tU8 u8GetSecondRundum(tU8& ru8Data);
   tU8 u8GetThirdRundum(tU8& ru8Data);
   tU8 u8GetPIStepWithNoPICheck(tU8& ru8Data);
   tU8 u8GetAudioOffScanMode(tU8& ru8Data);
   tU8 u8GetAMLearnCycle(tU8& ru8Data);
   tU8 u8GetPIIgnore(tU8& ru8Data);
   tU8 u8GetPISearchTime(tU8& ru8Data);
   tU8 u8GetDisableSeamlessBlending(tU8& ru8Data);
   tU8 u8GetSLAdjThreshold(tU8& ru8Data);
   tU8 u8GetSLMpThreshold(tU8& ru8Data);
   tU8 u8GetSpecialFmStartFrequency(tU8& ru8Data);
   tU8 u8GetFMSharxLimit(tU8& ru8Data);
   tU8 u8GetHDScanEveryFrequency(tU8& ru8Data);
   tU8 u8GetHWSubConfig(tU8& ru8Data);
   tU8 u8GetFM2DABDelayTime(tU8& ru8Data);
   tU8 u8GetWeatherBandLSM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAMFMHicutExtender(tU8& ru8Data);
   tU8 u8GetFMSoftmuteTiming(tU8& ru8Data);
   tU8 u8GetAMFMMisscellaneous2(tU8& ru8Data);
   tU8 u8GetFMHicutExtenderFieldstrengthThreshold(tU8& ru8Data);
   tU8 u8GetFMHicutExtenderFilterOffset(tU8& ru8Data);
   tU8 u8GetFMChannelSeparationMaximum(tU8& ru8Data);
   tU8 u8GetFMChannelSeparationTiming(tU8& ru8Data);
   tU8 u8GetFMHicutFieldstrengthThreshold(tU8& ru8Data);
   tU8 u8GetFMHicutTiming(tU8& ru8Data);
   tU8 u8GetFMDMQSensitivity(tU8& ru8Data);
   tU8 u8GetFMDeviationAdaption(tU8& ru8Data);
   tU8 u8GetAMNoiseBlanker228KHzSensitivity(tU8& ru8Data);
   tU8 u8GetAMNoiseBlanker456KHzSensitivity(tU8& ru8Data);
   tU8 u8GetAMHicutExtenderFieldstrengthThreshold(tU8& ru8Data);
   tU8 u8GetAMHicutExtenderFilterOffset(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner1FMAM(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner1FMHD(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner1AMHD(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner1DRM(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner2FMAM(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner2FMHD(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner2AMHD(tU8& ru8Data);
   tU8 u8GetDemodAudioTuner2DRM(tU8& ru8Data);
   tU8 u8GetTimeNonRdsDetect(tU8& ru8Data);
   tU8 u8GetTimePsDeleteAfterRdsLost(tU8& ru8Data);
   tU8 u8GetTimeScrollPsDetect(tU8& ru8Data);
   tU8 u8GetTSpeedTuneTrigger(tU8& ru8Data);
   tU8 u8GetNSpeedTuneTrigger(tU8& ru8Data);
   tU8 u8GetNSpeedTuneMultipierFM(tU8& ru8Data);
   tU8 u8GetNSpeedTuneMultipierAM(tU8& ru8Data);
   tU8 u8GetNumberOfPsChangesForScrollDetect(tU8& ru8Data);
   tU8 u8GetTimePTYHold(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetAMFMTunerParameter(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  HDRadioParameterSet  (Key: 0x0450)          
//##########################################################
#define DP_U16_KDSADR_HDRADIOPARAMETERSET                                             0x0450

#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_COMPLETE                                     64

#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_TAG                                          8
#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_MINORVERSION                                 2
#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_DIGITALAUDIOSCALINGFORFMHYBRID               2
#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_DIGITALAUDIODELAYFORFMHYBRIDPRIMARYBBRATE    2
#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_AMMPSAUDIOSCALING                            2
#define DP_U8_KDSLEN_HDRADIOPARAMETERSET_DIGITALAUDIODELAYFORAMMPSPRIMARYBBRATE       2


class dp_tclKdsHDRadioParameterSet{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_HDRADIOPARAMETERSET_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsHDRadioParameterSet();
   virtual ~dp_tclKdsHDRadioParameterSet() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBlendThresholdFMHybrid(tU8& ru8Data);
   tU8 u8GetDigitalAudioScalingForFMHybrid(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDigitalAudioDelayForFMHybridPrimaryBBRate(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBlendRateFMHybrid(tU8& ru8Data);
   tU8 u8GetBlendThresholdAMHybrid(tU8& ru8Data);
   tU8 u8GetAMMPSAudioScaling(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAMMPSBlendRate(tU8& ru8Data);
   tU8 u8GetDigitalAudioDelayForAMMPSPrimaryBBRate(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDigitalAudioPhaseInversion(tU8& ru8Data);
   tU8 u8GetBlendDecision(tU8& ru8Data);
   tU8 u8GetFMCdN0BlendDecision(tU8& ru8Data);
   tU8 u8GetAMCdN0BlendDecision(tU8& ru8Data);
   tU8 u8GetTimer1(tU8& ru8Data);
   tU8 u8GetTimer2(tU8& ru8Data);
   tU8 u8GetTimer3(tU8& ru8Data);
   tU8 u8GetTimer4(tU8& ru8Data);
   tU8 u8GetTimer5(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetHDRadioParameterSet(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  DABParameterSet  (Key: 0x0440)          
//##########################################################
#define DP_U16_KDSADR_DABPARAMETERSET                                             0x0440

#define DP_U8_KDSLEN_DABPARAMETERSET_COMPLETE                                     230

#define DP_U8_KDSLEN_DABPARAMETERSET_TAG                                          8
#define DP_U8_KDSLEN_DABPARAMETERSET_MINORVERSION                                 2
#define DP_U8_KDSLEN_DABPARAMETERSET_TSUMATRIXDABFM                               32
#define DP_U8_KDSLEN_DABPARAMETERSET_TSUMATRIXFMDAB                               32
#define DP_U8_KDSLEN_DABPARAMETERSET_MAXIMUMNUMBEROFSTATION                       2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGEID                                 2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGENSEMBLELABEL                       16
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGENSEMBLESHORTLABELMASK              2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGSID                                 2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGSERVICELABEL                        16
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGSERVICESHORTLABELMASK               2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGCOMPONENTID                         2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGCOMPONENTLABEL                      16
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGCOMPONENTSHORTLABELMASK             2
#define DP_U8_KDSLEN_DABPARAMETERSET_LSMCONFIGCHANNEL                             3


class dp_tclKdsDABParameterSet{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_DABPARAMETERSET_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsDABParameterSet();
   virtual ~dp_tclKdsDABParameterSet() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSFDABDAB(tU8& ru8Data);
   tU8 u8GetSFDABFM(tU8& ru8Data);
   tU8 u8GetSFFMDAB(tU8& ru8Data);
   tU8 u8GetDMBA(tU8& ru8Data);
   tU8 u8GetTPEG(tU8& ru8Data);
   tU8 u8GetEPG(tU8& ru8Data);
   tU8 u8GetSLS(tU8& ru8Data);
   tU8 u8GetBWS(tU8& ru8Data);
   tU8 u8GetIntellitext(tU8& ru8Data);
   tU8 u8GetJournaline(tU8& ru8Data);
   tU8 u8GetSFAlternativeFrequency(tU8& ru8Data);
   tU8 u8GetSFAlternativeEnsemble(tU8& ru8Data);
   tU8 u8GetSFHardLinking(tU8& ru8Data);
   tU8 u8GetSFSearch(tU8& ru8Data);
   tU8 u8GetSFStickyComponent(tU8& ru8Data);
   tU8 u8GetConcealmentLevel(tU8& ru8Data);
   tU8 u8GetTSUMatrixDABFM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetTSUMatrixFMDAB(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDABFMLinkingSwitchBackDelay(tU8& ru8Data);
   tU8 u8GetDABFMLinkingSmoothingTUp(tU8& ru8Data);
   tU8 u8GetDABFMLinkingSmoothingTDown(tU8& ru8Data);
   tU8 u8GetDABFMLinkingComparisonDelay(tU8& ru8Data);
   tU8 u8GetDABFMLinkingSmoothingTLong(tU8& ru8Data);
   tU8 u8GetDABFMLinkingFMQualityThreshold(tU8& ru8Data);
   tU8 u8GetFMDABLinkingSwitchBackDelay(tU8& ru8Data);
   tU8 u8GetFMDABLinkingSmoothingTUp(tU8& ru8Data);
   tU8 u8GetFMDABLinkingSmoothingTDown(tU8& ru8Data);
   tU8 u8GetFMDABLinkingPSIDChangedDelay(tU8& ru8Data);
   tU8 u8GetFMDABLinkingSmoothingTLong(tU8& ru8Data);
   tU8 u8GetFMDABLinkingDABQualityThreshold(tU8& ru8Data);
   tU8 u8GetRDMQualityConfigQualityDecreaseSpeedFactor(tU8& ru8Data);
   tU8 u8GetRDMQualityConfigMode(tU8& ru8Data);
   tU8 u8GetRDMQualityConfigCount(tU8& ru8Data);
   tU8 u8GetEnsembleRecIndicator(tU8& ru8Data);
   tU8 u8GetEnsembleRecIndicatorSyncDelay(tU8& ru8Data);
   tU8 u8GetEnsembleVerificationAlgorithmTimeTickDivider(tU8& ru8Data);
   tU8 u8GetEnsembleVerificationAlgorithmTimePeriod(tU8& ru8Data);
   tU8 u8GetEnsembleVerificationAlgorithmMinGoodFICBERTime(tU8& ru8Data);
   tU8 u8GetEnsembleVerificationAlgorithmMinGoodFICBERLevel(tU8& ru8Data);
   tU8 u8GetEnsembleVerificationAlgorithmTargetCounterValue(tU8& ru8Data);
   tU8 u8GetEnsembleQualityAlgorithmMinGoodFICBERTime(tU8& ru8Data);
   tU8 u8GetEnsembleQualityAlgorithmMinGoodFICBERLevel(tU8& ru8Data);
   tU8 u8GetEnable(tU8& ru8Data);
   tU8 u8GetQuickHideEnsemble(tU8& ru8Data);
   tU8 u8GetRealUnlearnEnsemble(tU8& ru8Data);
   tU8 u8GetUseForShowingNotReceiveableIndicator(tU8& ru8Data);
   tU8 u8GetUseForClearingNotReceiveableIndicator(tU8& ru8Data);
   tU8 u8GetBackgroundSnooping2(tU8& ru8Data);
   tU8 u8GetBackgroundSnoopingUnlearnFieldstrength(tU8& ru8Data);
   tU8 u8GetBackgroundSnoopingLearnCounterMaxValue(tU8& ru8Data);
   tU8 u8GetBackgroundSnoopingLearnCounterValue(tU8& ru8Data);
   tU8 u8GetBackgroundSnoopingUnlearnCounterValue(tU8& ru8Data);
   tU8 u8GetBackgroundSnoopingUnlearnCounterMinValue(tU8& ru8Data);
   tU8 u8GetResumeInterruptedAnnouncement(tU8& ru8Data);
   tU8 u8GetSearchUpScan(tU8& ru8Data);
   tU8 u8GetScanStationList(tU8& ru8Data);
   tU8 u8GetSupressDoubleServices(tU8& ru8Data);
   tU8 u8GetUseMinSignalQuality(tU8& ru8Data);
   tU8 u8GetUseMinAudioQuality(tU8& ru8Data);
   tU8 u8GetUseMinPlayDuration(tU8& ru8Data);
   tU8 u8GetScanForever(tU8& ru8Data);
   tU8 u8GetSelectLastScannedServiceWhenLSMIsNotAvailable1(tU8& ru8Data);
   tU8 u8GetScanMinSignalQuality(tU8& ru8Data);
   tU8 u8GetScanAudioThreshold(tU8& ru8Data);
   tU8 u8GetPlayDuration(tU8& ru8Data);
   tU8 u8GetEnsembleListSorting(tU8& ru8Data);
   tU8 u8GetServiceListSorting(tU8& ru8Data);
   tU8 u8GetComponentListSorting(tU8& ru8Data);
   tU8 u8GetMaximumNumberOfStation(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetComponentsIncludedInStationList(tU8& ru8Data);
   tU8 u8Get32x32(tU8& ru8Data);
   tU8 u8Get112x32(tU8& ru8Data);
   tU8 u8Get128x128(tU8& ru8Data);
   tU8 u8Get320x240(tU8& ru8Data);
   tU8 u8GetTimerConfigTFMDABSWITCHMUTEDABMs(tU8& ru8Data);
   tU8 u8GetTimerConfigTFMDABSWITCHMUTEDABPLUSMs(tU8& ru8Data);
   tU8 u8GetTimerConfigTFMDABSWITCHMUTEDMBAMs(tU8& ru8Data);
   tU8 u8GetTimerConfigTBGLEARNSTARTS(tU8& ru8Data);
   tU8 u8GetTimerConfigTLEARNSTARTSFOFFS(tU8& ru8Data);
   tU8 u8GetTimerConfigTMANMODESFOFFS(tU8& ru8Data);
   tU8 u8GetTimerConfigTSTATIONSELECTSFOFFS(tU8& ru8Data);
   tU8 u8GetTimerConfigTSLSSIGNALLOSTS(tU8& ru8Data);
   tU8 u8GetTimerConfigTCLEARRTDELAYS(tU8& ru8Data);
   tU8 u8GetTimerConfigTCLEARRTAFTERSYNCLOSTS(tU8& ru8Data);
   tU8 u8GetLSMConfigEID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigEnsembleLabel(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigEnsembleShortLabelMask(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigSID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigServiceLabel(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigServiceShortLabelMask(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigComponentID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigComponentLabel(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigComponentShortLabelMask(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLSMConfigChannel(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetTunerBand1(tU8& ru8Data);
   tU8 u8GetTunerBand2(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetDABParameterSet(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  AntennaParameter  (Key: 0x0430)          
//##########################################################
#define DP_U16_KDSADR_ANTENNAPARAMETER                                             0x0430

#define DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE                                     131

#define DP_U8_KDSLEN_ANTENNAPARAMETER_TAG                                          8
#define DP_U8_KDSLEN_ANTENNAPARAMETER_MINORVERSION                                 2


class dp_tclKdsAntennaParameter{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsAntennaParameter();
   virtual ~dp_tclKdsAntennaParameter() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetAntennaFM1Type(tU8& ru8Data);
   tU8 u8GetAntennaFM1Open(tU8& ru8Data);
   tU8 u8GetAntennaFM1OpenClear(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderVoltageForOpen(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderIgnitionForOpen(tU8& ru8Data);
   tU8 u8GetAntennaFM1OpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaFM1OpenAmplifierClearLow(tU8& ru8Data);
   tU8 u8GetAntennaFM1OpenAmplifierClearHigh(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderVoltageForOpenAmplidier(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderIgnitionForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaFM1Short(tU8& ru8Data);
   tU8 u8GetAntennaFM1ShortClear(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderVoltageForShort(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderIgnitionForShort(tU8& ru8Data);
   tU8 u8GetAntennaFM1MonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaFM1NoOfMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaFM1ShortCircuitWait(tU8& ru8Data);
   tU8 u8GetAntennaFM1ConsiderCriticalHighVoltage(tU8& ru8Data);
   tU8 u8GetAntennaFM2Type(tU8& ru8Data);
   tU8 u8GetAntennaFM2Open(tU8& ru8Data);
   tU8 u8GetAntennaFM2OpenClear(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderVoltageForOpen(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderIgnitionForOpen(tU8& ru8Data);
   tU8 u8GetAntennaFM2OpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaFM2OpenAmplifierClearLow(tU8& ru8Data);
   tU8 u8GetAntennaFM2OpenAmplifierClearHigh(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderVoltageForOpenAmplidier(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderIgnitionForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaFM2Short(tU8& ru8Data);
   tU8 u8GetAntennaFM2ShortClear(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderVoltageForShort(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderIgnitionForShort(tU8& ru8Data);
   tU8 u8GetAntennaFM2MonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaFM2NoOfMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaFM2ShortCircuitWait(tU8& ru8Data);
   tU8 u8GetAntennaFM2ConsiderCriticalHighVoltage(tU8& ru8Data);
   tU8 u8GetAntennaDAB1Type(tU8& ru8Data);
   tU8 u8GetAntennaDAB1Open(tU8& ru8Data);
   tU8 u8GetAntennaDAB1OpenClear(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderVoltageForOpen(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderIgnitionForOpen(tU8& ru8Data);
   tU8 u8GetAntennaDAB1OpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaDAB1OpenAmplifierClearLow(tU8& ru8Data);
   tU8 u8GetAntennaDAB1OpenAmplifierClearHigh(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderVoltageForOpenAmplidier(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderIgnitionForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaDAB1Short(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ShortClear(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderVoltageForShort(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderIgnitionForShort(tU8& ru8Data);
   tU8 u8GetAntennaDAB1MonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaDAB1NoOfMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ShortCircuitWait(tU8& ru8Data);
   tU8 u8GetAntennaDAB1ConsiderCriticalHighVoltage(tU8& ru8Data);
   tU8 u8GetAntennaGPSType(tU8& ru8Data);
   tU8 u8GetAntennaGPSOpen(tU8& ru8Data);
   tU8 u8GetAntennaGPSOpenClear(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderVoltageForOpen(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderIgnitionForOpen(tU8& ru8Data);
   tU8 u8GetAntennaGPSOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaGPSOpenAmplifierClearLow(tU8& ru8Data);
   tU8 u8GetAntennaGPSOpenAmplifierClearHigh(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderVoltageForOpenAmplidier(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderIgnitionForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaGPSShort(tU8& ru8Data);
   tU8 u8GetAntennaGPSShortClear(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderVoltageForShort(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderIgnitionForShort(tU8& ru8Data);
   tU8 u8GetAntennaGPSMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaGPSNoOfMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaGPSShortCircuitWait(tU8& ru8Data);
   tU8 u8GetAntennaGPSConsiderCriticalHighVoltage(tU8& ru8Data);
   tU8 u8GetAntennaTV12Type(tU8& ru8Data);
   tU8 u8GetAntennaTV12Open(tU8& ru8Data);
   tU8 u8GetAntennaTV12OpenClear(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderVoltageForOpen(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderIgnitionForOpen(tU8& ru8Data);
   tU8 u8GetAntennaTV12OpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaTV12OpenAmplifierClearLow(tU8& ru8Data);
   tU8 u8GetAntennaTV12OpenAmplifierClearHigh(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderVoltageForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderIgnitionForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaTV12Short(tU8& ru8Data);
   tU8 u8GetAntennaTV12ShortClear(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderVoltageForShort(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderIgnitionForShort(tU8& ru8Data);
   tU8 u8GetAntennaTV12MonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaTV12NoOfMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaTV12ShortCircuitWait(tU8& ru8Data);
   tU8 u8GetAntennaTV12ConsiderCriticalHighVoltage(tU8& ru8Data);
   tU8 u8GetAntennaTV34Type(tU8& ru8Data);
   tU8 u8GetAntennaTV34Open(tU8& ru8Data);
   tU8 u8GetAntennaTV34OpenClear(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderVoltageForOpen(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderIgnitionForOpen(tU8& ru8Data);
   tU8 u8GetAntennaTV34OpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaTV34OpenAmplifierClearLow(tU8& ru8Data);
   tU8 u8GetAntennaTV34OpenAmplifierClearHigh(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderVoltageForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderIgnitionForOpenAmplifier(tU8& ru8Data);
   tU8 u8GetAntennaTV34Short(tU8& ru8Data);
   tU8 u8GetAntennaTV34ShortClear(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderVoltageForShort(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderIgnitionForShort(tU8& ru8Data);
   tU8 u8GetAntennaTV34MonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaTV34NoOfMonitorCycle(tU8& ru8Data);
   tU8 u8GetAntennaTV34ShortCircuitWait(tU8& ru8Data);
   tU8 u8GetAntennaTV34ConsiderCriticalHighVoltage(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetAntennaParameter(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  SystemConfiguration1  (Key: 0xA110)          
//##########################################################
#define DP_U16_KDSADR_SYSTEMCONFIGURATION1                                             0xA110

#define DP_U8_KDSLEN_SYSTEMCONFIGURATION1_COMPLETE                                     64

#define DP_U8_KDSLEN_SYSTEMCONFIGURATION1_PORT                                         2


class dp_tclKdsSystemConfiguration1{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_SYSTEMCONFIGURATION1_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsSystemConfiguration1();
   virtual ~dp_tclKdsSystemConfiguration1() {};
   
   tU8 u8GetUCANUpdateMethod(tU8& ru8Data);
   tU8 u8GetSupportedDistanceUnits(tU8& ru8Data);
   tU8 u8GetDefaultDistanceUnits(tU8& ru8Data);
   tU8 u8GetSupportedTemperatureUnit(tU8& ru8Data);
   tU8 u8GetDefaultTemperatureUnit(tU8& ru8Data);
   tU8 u8GetDefaultLanguage(tU8& ru8Data);
   tU8 u8GetShowClock(tU8& ru8Data);
   tU8 u8GetClock1224h(tU8& ru8Data);
   tU8 u8GetMeterClockSynchronisation(tU8& ru8Data);
   tU8 u8GetClockSynchronisationSource(tU8& ru8Data);
   tU8 u8GetEcoScoreDisplay(tU8& ru8Data);
   tU8 u8GetOffRoadInformation(tU8& ru8Data);
   tU8 u8GetBrand(tU8& ru8Data);
   tU8 u8GetOpeningAnimation(tU8& ru8Data);
   tU8 u8GetHEVInformationFunction(tU8& ru8Data);
   tU8 u8GetHEVDriveType(tU8& ru8Data);
   tU8 u8GetSoundOnEncoderPress(tU8& ru8Data);
   tU8 u8GetEcoChallenge(tU8& ru8Data);
   tU8 u8GetEcoFunction(tU8& ru8Data);
   tU8 u8GetSpeedLockRestrictions(tU8& ru8Data);
   tU8 u8GetSpeedLockMinThresholdForUseRestrictionKmH(tU8& ru8Data);
   tU8 u8GetSpeedLockMaxThresholdForUseRestrictionKmH(tU8& ru8Data);
   tU8 u8GetTyrePressureResetRestriction(tU8& ru8Data);
   tU8 u8GetSeatRestriction(tU8& ru8Data);
   tU8 u8GetDisplayActivation(tU8& ru8Data);
   tU8 u8GetExtTempDisplayCfg(tU8& ru8Data);
   tU8 u8GetPORT(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetANCActivation(tU8& ru8Data);
   tU8 u8GetESEActivation(tU8& ru8Data);
   tU8 u8GetVoiceRecognition(tU8& ru8Data);
   tU8 u8GetVRBeepOnly(tU8& ru8Data);
   tU8 u8GetVRShortPrompts(tU8& ru8Data);
   tU8 u8GetTTS(tU8& ru8Data);
   tU8 u8GetAutoBargeIn(tU8& ru8Data);
   tU8 u8GetOutputInformation(tU8& ru8Data);
   tU8 u8GetTweeterSetup(tU8& ru8Data);
   tU8 u8GetSonarVolume(tU8& ru8Data);
   tU8 u8GetSpeedCurve(tU8& ru8Data);
   tU8 u8GetAudioConfiguration(tU8& ru8Data);
   tU8 u8GetDVDRegionCode(tU8& ru8Data);
   tU8 u8GetBDRegionCode(tU8& ru8Data);
   tU8 u8GetAUX(tU8& ru8Data);
   tU8 u8GetMCH1MountInformation(tU8& ru8Data);
   tU8 u8GetAMTunerActivation(tU8& ru8Data);
   tU8 u8GetDAB(tU8& ru8Data);
   tU8 u8GetCMFSupportForETC(tU8& ru8Data);
   tU8 u8GetWifiFunction(tU8& ru8Data);
   tU8 u8GetBluetoothFunction(tU8& ru8Data);
   tU8 u8GetWiFiIVCTethering(tU8& ru8Data);
   tU8 u8GetCarPlay(tU8& ru8Data);
   tU8 u8GetAndroidAuto(tU8& ru8Data);
   tU8 u8GetMySPIN(tU8& ru8Data);
   tU8 u8GetATbox(tU8& ru8Data);
   tU8 u8GetModelYear(tU8& ru8Data);
   tU8 u8GetWifi5GHZSupport(tU8& ru8Data);
   tU8 u8GetOnCar(tU8& ru8Data);
   tU8 u8GetTruckLCVRoute(tU8& ru8Data);
   tU8 u8GetVehicleFleet(tU8& ru8Data);
   tU8 u8GetMinimizeUnpavedRoads(tU8& ru8Data);
   tU8 u8GetKindOfDestinationEntry(tU8& ru8Data);
   tU8 u8GetDisclaimer(tU8& ru8Data);
   tU8 u8GetMapZoom(tU8& ru8Data);
   tU8 u8GetMQTTPayloadCompression(tU8& ru8Data);
   tU8 u8GetAutomaticPhoneBookTransfer(tU8& ru8Data);
   tU8 u8GetVA(tU8& ru8Data);
   tU8 u8GetBTVR(tU8& ru8Data);
   tU8 u8GetWBS(tU8& ru8Data);
   tU8 u8GetVAOnShortpress(tU8& ru8Data);
   tU8 u8GetMQTTSessionType(tU8& ru8Data);
   tU8 u8GetCNFCHGSTNFIND(tU8& ru8Data);
   tU8 u8GetCNFCHGSTNSORT(tU8& ru8Data);
   tU8 u8GetCNFLOWBATALT(tU8& ru8Data);
   tU8 u8GetCNFGUARDANG(tU8& ru8Data);
   tU8 u8GetCNFCHGTIMEFORECAST(tU8& ru8Data);
   tU8 u8GetCNFPSOC(tU8& ru8Data);
   tU8 u8GetCNFREROUTEALT(tU8& ru8Data);
   tU8 u8GetCNFREACHAREA(tU8& ru8Data);
   tU8 u8GetInfoFromMeterLimitedPower(tU8& ru8Data);
   tU8 u8GetInfoFromMeterDCDCCaution(tU8& ru8Data);
   tU8 u8GetTIMERCHARGING(tU8& ru8Data);
   tU8 u8GetTIMERPREAIRCONDITIONING(tU8& ru8Data);
   tU8 u8GetEnergyHistoryConsumption(tU8& ru8Data);
   tU8 u8GetRemoteApplicationSupport(tU8& ru8Data);
   tU8 u8GetEVPHEVRealTimeEnergyFlowDisplay(tU8& ru8Data);
   tU8 u8GetEVPHEVEnergyFlow15mnHistoricalGraph(tU8& ru8Data);
   tU8 u8GetEnergyInformation(tU8& ru8Data);
   tU8 u8GetPowerConsumptionInformation(tU8& ru8Data);
   tU8 u8GetPreConditioningDurationVehicleNotPlugged(tU8& ru8Data);
   tU8 u8GetPreConditioningMedianTemperatureRequest(tU8& ru8Data);
   tU8 u8GetSkinChoiceComfort1(tU8& ru8Data);
   tU8 u8GetCarType(tU8& ru8Data);
   tU8 u8GetSkinChoiceComfort12(tU8& ru8Data);
   tU8 u8GetSkinChoiceEco1(tU8& ru8Data);
   tU8 u8GetSkinChoiceDynamic1(tU8& ru8Data);
   tU8 u8GetSkinChoiceNormal1(tU8& ru8Data);
   tU8 u8GetSkinChoicePerso1(tU8& ru8Data);
   tU8 u8GetMexSwitchIntensityWithoutAmbientLighting(tU8& ru8Data);
   tU8 u8GetPreferentialMode2(tU8& ru8Data);
   tU8 u8GetPreferentialMode1(tU8& ru8Data);
   tU8 u8GetDualModeMgt(tU8& ru8Data);
   tU8 u8GetESESoundVolumeComfort(tU8& ru8Data);
   tU8 u8GetESESoundVolumeEco1(tU8& ru8Data);
   tU8 u8GetESESoundVolumeDynamic1(tU8& ru8Data);
   tU8 u8GetESESoundVolumeNormal(tU8& ru8Data);
   tU8 u8GetESESoundTypeEco1(tU8& ru8Data);
   tU8 u8GetESESoundVolumePerso1(tU8& ru8Data);
   tU8 u8GetESESoundTypePerso1(tU8& ru8Data);
   tU8 u8GetESESoundTypeDynamic1(tU8& ru8Data);
   tU8 u8GetESESoundTypeNormal1(tU8& ru8Data);
   tU8 u8GetESESoundTypeComfort1(tU8& ru8Data);
   tU8 u8GetESESound1Name(tU8& ru8Data);
   tU8 u8GetESESound2Name(tU8& ru8Data);
   tU8 u8GetESESound1VolumeHMI(tU8& ru8Data);
   tU8 u8GetESESound2VolumeHMI(tU8& ru8Data);
   tU8 u8GetESESoundVolumeRace(tU8& ru8Data);
   tU8 u8GetESEHMI(tU8& ru8Data);
   tU8 u8GetWirelessAndroidAutoFunction(tU8& ru8Data);
   tU8 u8GetCNFVPA(tU8& ru8Data);
   tU8 u8GetESESoundTypeRace1(tU8& ru8Data);
   tU8 u8GetTouchScreenConfiguration(tU8& ru8Data);
   tU8 u8GetBaiduCarLifeFunction(tU8& ru8Data);
   tU8 u8GetWirelessCarPlayFunction(tU8& ru8Data);
   tU8 u8GetHVACType(tU8& ru8Data);
   tU8 u8GetMaintenanceInfoFunction(tU8& ru8Data);
   tU8 u8GetVDCSetting(tU8& ru8Data);
   tU8 u8GetVehicleSetting(tU8& ru8Data);
   tU8 u8GetDigitalAssistant(tU8& ru8Data);
   tU8 u8GetHVACTemperature(tU8& ru8Data);
   tU8 u8GetFOTABearer(tU8& ru8Data);
   tU8 u8GetDisplayType(tU8& ru8Data);
   tU8 u8GetMassageBehaviorInPowerState(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetSystemConfiguration1(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  ThermalManagmentTemperatureThresholds  (Key: 0x1310)          
//##########################################################
#define DP_U16_KDSADR_THERMALMANAGMENTTEMPERATURETHRESHOLDS                                             0x1310

#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_COMPLETE                                     126

#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MAXIMUMTEMPERATURE1                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MINIMUMTEMPERATURE1                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURE1                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURETIMEDELAY1            2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURE1                             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURETIMEDELAY1                    2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURE1                              2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURETIMEDELAY1                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURE1                      2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURETIMEDELAY1             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MAXIMUMTEMPERATURE2                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MINIMUMTEMPERATURE2                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURE2                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURETIMEDELAY2            2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURE2                             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURETIMEDELAY2                    2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURE2                              2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURETIMEDELAY2                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURE2                      2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURETIMEDELAY2             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MAXIMUMTEMPERATURE3                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MINIMUMTEMPERATURE3                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURE3                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURETIMEDELAY3            2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURE3                             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURETIMEDELAY3                    2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURE3                              2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURETIMEDELAY3                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURE3                      2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURETIMEDELAY3             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MAXIMUMTEMPERATURE4                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MINIMUMTEMPERATURE4                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURE4                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURETIMEDELAY4            2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURE4                             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURETIMEDELAY4                    2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURE4                              2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURETIMEDELAY4                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURE4                      2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURETIMEDELAY4             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MAXIMUMTEMPERATURE5                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_MINIMUMTEMPERATURE5                          2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURE5                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALHIGHTEMPERATURETIMEDELAY5            2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURE5                             2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_HIGHTEMPERATURETIMEDELAY5                    2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURE5                              2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_LOWTEMPERATURETIMEDELAY5                     2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURE5                      2
#define DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_CRITICALLOWTEMPERATURETIMEDELAY5             2


class dp_tclKdsThermalManagmentTemperatureThresholds{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsThermalManagmentTemperatureThresholds();
   virtual ~dp_tclKdsThermalManagmentTemperatureThresholds() {};
   
   tU8 u8GetVersion(tU8& ru8Data);
   tU8 u8GetSensorID1(tU8& ru8Data);
   tU8 u8GetMaximumTemperature1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinimumTemperature1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperature1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperatureHysteresis1(tU8& ru8Data);
   tU8 u8GetCriticalHighTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperature1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperatureHysteresis1(tU8& ru8Data);
   tU8 u8GetHighTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperature1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperatureHysteresis1(tU8& ru8Data);
   tU8 u8GetLowTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperature1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperatureHysteresis1(tU8& ru8Data);
   tU8 u8GetCriticalLowTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSensorID2(tU8& ru8Data);
   tU8 u8GetMaximumTemperature2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinimumTemperature2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperature2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperatureHysteresis2(tU8& ru8Data);
   tU8 u8GetCriticalHighTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperature2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperatureHysteresis2(tU8& ru8Data);
   tU8 u8GetHighTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperature2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperatureHysteresis2(tU8& ru8Data);
   tU8 u8GetLowTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperature2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperatureHysteresis2(tU8& ru8Data);
   tU8 u8GetCriticalLowTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSensorID3(tU8& ru8Data);
   tU8 u8GetMaximumTemperature3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinimumTemperature3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperature3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperatureHysteresis3(tU8& ru8Data);
   tU8 u8GetCriticalHighTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperature3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperatureHysteresis3(tU8& ru8Data);
   tU8 u8GetHighTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperature3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperatureHysteresis3(tU8& ru8Data);
   tU8 u8GetLowTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperature3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperatureHysteresis3(tU8& ru8Data);
   tU8 u8GetCriticalLowTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSensorID4(tU8& ru8Data);
   tU8 u8GetMaximumTemperature4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinimumTemperature4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperature4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperatureHysteresis4(tU8& ru8Data);
   tU8 u8GetCriticalHighTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperature4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperatureHysteresis4(tU8& ru8Data);
   tU8 u8GetHighTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperature4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperatureHysteresis4(tU8& ru8Data);
   tU8 u8GetLowTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperature4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperatureHysteresis4(tU8& ru8Data);
   tU8 u8GetCriticalLowTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSensorID5(tU8& ru8Data);
   tU8 u8GetMaximumTemperature5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMinimumTemperature5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperature5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalHighTemperatureHysteresis5(tU8& ru8Data);
   tU8 u8GetCriticalHighTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperature5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHighTemperatureHysteresis5(tU8& ru8Data);
   tU8 u8GetHighTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperature5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowTemperatureHysteresis5(tU8& ru8Data);
   tU8 u8GetLowTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperature5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCriticalLowTemperatureHysteresis5(tU8& ru8Data);
   tU8 u8GetCriticalLowTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetThermalManagmentTemperatureThresholds(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  DimmingParameter  (Key: 0x0D08)          
//##########################################################
#define DP_U16_KDSADR_DIMMINGPARAMETER                                             0x0D08

#define DP_U8_KDSLEN_DIMMINGPARAMETER_COMPLETE                                     230

#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC1                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC2                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC3                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC4                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC5                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC6                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC7                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC8                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC9                    2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC10                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC11                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC12                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC13                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC14                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC15                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC16                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC17                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC18                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC19                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC20                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC21                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC22                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC23                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC24                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC25                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC26                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC27                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC28                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC29                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC30                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC31                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC32                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMINIGHTC33                   2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC1                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC2                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC3                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC4                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC5                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC6                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC7                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC8                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC9                      2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC10                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC11                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC12                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC13                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC14                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC15                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC16                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC17                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC18                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC19                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC20                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC21                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC22                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC23                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC24                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC25                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC26                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC27                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC28                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC29                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC30                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC31                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC32                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSCURVEHMIDAYC33                     2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_DISPLAYILLUMINATIONOUTPUTFREQUENCY           2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_KEYSENCODERILLUMINATIONOUTPUTFREQUENCY       2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_TEMPCOMPENSATIONPWMMIN                       2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_HIGHTEMPERATURE                              2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_CRITICALTEMPERATURE                          2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_LOWTEMPERATURE                               2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_LIGHTNINGTIMINGDELAY                         2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSBACKLIGHTDAYBUTTONSDAY1            2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSBACKLIGHTDAYBUTTONSNIGHT1          2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSBACKLIGHTNIGHTBUTTONSNIGHT1        2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSBACKLIGHTDAYBUTTONSON              2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSBACKLIGHTDAYBUTTONSOFF1            2
#define DP_U8_KDSLEN_DIMMINGPARAMETER_BRIGTHNESSBACKLIGHTNIGHTBUTTONSON21          42


class dp_tclKdsDimmingParameter{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_DIMMINGPARAMETER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsDimmingParameter();
   virtual ~dp_tclKdsDimmingParameter() {};
   
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8& ru8Data);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC6(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC7(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC8(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC9(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC10(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC11(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC12(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC13(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC14(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC15(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC16(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC17(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC18(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC19(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC20(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC21(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC22(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC23(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC24(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC25(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC26(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC27(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC28(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC29(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC30(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC31(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC32(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMINIGHTC33(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC6(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC7(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC8(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC9(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC10(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC11(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC12(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC13(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC14(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC15(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC16(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC17(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC18(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC19(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC20(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC21(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC22(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC23(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC24(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC25(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC26(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC27(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC28(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC29(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC30(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC31(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC32(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSCURVEHMIDAYC33(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDISPLAYILLUMINATIONOUTPUTFREQUENCY(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYSENCODERILLUMINATIONOUTPUTFREQUENCY(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetTEMPCOMPENSATIONPWMMIN(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNUMBEROFKEYS(tU8& ru8Data);
   tU8 u8GetHIGHTEMPERATURE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCRITICALTEMPERATURE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLOWTEMPERATURE(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSNOOFHMIOFFSET(tU8& ru8Data);
   tU8 u8GetTEMPHYSTERESIS(tU8& ru8Data);
   tU8 u8GetLIGHTNINGTIMINGDELAY(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYBRIGHTNESSNUMOFOFFSETS(tU8& ru8Data);
   tU8 u8GetSOFTDIMMINGENABLED(tU8& ru8Data);
   tU8 u8GetSOFTDIMMINGSAMPLINGTIME(tU8& ru8Data);
   tU8 u8GetSOFTDIMMINGCONSTANTK(tU8& ru8Data);
   tU8 u8GetSOFTDIMMINGCONSTANTJ(tU8& ru8Data);
   tU8 u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSDAY1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSNIGHT1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSBACKLIGHTNIGHTBUTTONSNIGHT1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSON(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSOFF1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBRIGTHNESSBACKLIGHTNIGHTBUTTONSON21(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetKEYILLUMINATIONMODE(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetDimmingParameter(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  InputKeyMappingTable_1  (Key: 0xA080)          
//##########################################################
#define DP_U16_KDSADR_INPUTKEYMAPPINGTABLE_1                                             0xA080

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_COMPLETE                                     230

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_MINORVERSION                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID2                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID3                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID4                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID5                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID6                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID7                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID8                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID9                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID10                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID11                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID12                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID13                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID14                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID15                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID16                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID17                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID18                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID19                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID20                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID21                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID22                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID23                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID24                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID25                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID26                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID27                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID28                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID29                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID30                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID31                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_LOGICALKEYID32                               2


class dp_tclKdsInputKeyMappingTable_1{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsInputKeyMappingTable_1();
   virtual ~dp_tclKdsInputKeyMappingTable_1() {};
   
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNrOfEntries(tU8& ru8Data);
   tU8 u8GetRawKeyID(tU8& ru8Data);
   tU8 u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID2(tU8& ru8Data);
   tU8 u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID3(tU8& ru8Data);
   tU8 u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID4(tU8& ru8Data);
   tU8 u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID5(tU8& ru8Data);
   tU8 u8GetLogicalKeyID5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID6(tU8& ru8Data);
   tU8 u8GetLogicalKeyID6(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID7(tU8& ru8Data);
   tU8 u8GetLogicalKeyID7(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID8(tU8& ru8Data);
   tU8 u8GetLogicalKeyID8(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID9(tU8& ru8Data);
   tU8 u8GetLogicalKeyID9(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID10(tU8& ru8Data);
   tU8 u8GetLogicalKeyID10(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID11(tU8& ru8Data);
   tU8 u8GetLogicalKeyID11(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID12(tU8& ru8Data);
   tU8 u8GetLogicalKeyID12(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID13(tU8& ru8Data);
   tU8 u8GetLogicalKeyID13(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID14(tU8& ru8Data);
   tU8 u8GetLogicalKeyID14(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID15(tU8& ru8Data);
   tU8 u8GetLogicalKeyID15(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID16(tU8& ru8Data);
   tU8 u8GetLogicalKeyID16(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID17(tU8& ru8Data);
   tU8 u8GetLogicalKeyID17(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID18(tU8& ru8Data);
   tU8 u8GetLogicalKeyID18(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID19(tU8& ru8Data);
   tU8 u8GetLogicalKeyID19(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID20(tU8& ru8Data);
   tU8 u8GetLogicalKeyID20(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID21(tU8& ru8Data);
   tU8 u8GetLogicalKeyID21(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID22(tU8& ru8Data);
   tU8 u8GetLogicalKeyID22(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID23(tU8& ru8Data);
   tU8 u8GetLogicalKeyID23(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID24(tU8& ru8Data);
   tU8 u8GetLogicalKeyID24(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID25(tU8& ru8Data);
   tU8 u8GetLogicalKeyID25(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID26(tU8& ru8Data);
   tU8 u8GetLogicalKeyID26(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID27(tU8& ru8Data);
   tU8 u8GetLogicalKeyID27(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID28(tU8& ru8Data);
   tU8 u8GetLogicalKeyID28(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID29(tU8& ru8Data);
   tU8 u8GetLogicalKeyID29(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID30(tU8& ru8Data);
   tU8 u8GetLogicalKeyID30(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID31(tU8& ru8Data);
   tU8 u8GetLogicalKeyID31(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID32(tU8& ru8Data);
   tU8 u8GetLogicalKeyID32(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetInputKeyMappingTable_1(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  CMVariantCoding  (Key: 0x0DF4)          
//##########################################################
#define DP_U16_KDSADR_CMVARIANTCODING                                             0x0DF4

#define DP_U8_KDSLEN_CMVARIANTCODING_COMPLETE                                     32



class dp_tclKdsCMVariantCoding{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_CMVARIANTCODING_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsCMVariantCoding();
   virtual ~dp_tclKdsCMVariantCoding() {};
   
   tU8 u8GetDiagnosisExtendedDataConsistencyCheck(tU8& ru8Data);
   tU8 u8GetInterfaceLock(tU8& ru8Data);
   tU8 u8GetOEMType(tU8& ru8Data);
   tU8 u8GetBluetooth(tU8& ru8Data);
   tU8 u8GetRVC(tU8& ru8Data);
   tU8 u8GetCD(tU8& ru8Data);
   tU8 u8GetXMTuner(tU8& ru8Data);
   tU8 u8GetDAB(tU8& ru8Data);
   tU8 u8GetHDRadio(tU8& ru8Data);
   tU8 u8GetDVD(tU8& ru8Data);
   tU8 u8GetADR3VariantInfo(tU8& ru8Data);
   tU8 u8GetADR3FlashVariantInfo(tU8& ru8Data);
   tU8 u8GetUSBInfo(tU8& ru8Data);
   tU8 u8GetAUXInfo(tU8& ru8Data);
   tU8 u8GetFMAntenna1Info(tU8& ru8Data);
   tU8 u8GetFMAntenna2Info(tU8& ru8Data);
   tU8 u8GetDABAntenna1Info(tU8& ru8Data);
   tU8 u8GetDABAntenna2Info(tU8& ru8Data);
   tU8 u8GetGPSAntenna1Info(tU8& ru8Data);
   tU8 u8GetUSB1ExtendedInfo(tU8& ru8Data);
   tU8 u8GetUSB2ExtendedInfo(tU8& ru8Data);
   tU8 u8GetFAN(tU8& ru8Data);
   tU8 u8GetGNSS(tU8& ru8Data);
   tU8 u8GetGYRO(tU8& ru8Data);
   tU8 u8GetACC(tU8& ru8Data);
   tU8 u8GetBDDrive(tU8& ru8Data);
   tU8 u8GetDRM(tU8& ru8Data);
   tU8 u8GetRTC(tU8& ru8Data);
   tU8 u8GetWIFI(tU8& ru8Data);
   tU8 u8GetDTV(tU8& ru8Data);
   tU8 u8GetArkamysClassicSupport(tU8& ru8Data);
   tU8 u8GetArkamysAuditoriumSupport(tU8& ru8Data);
   tU8 u8GetESESupport(tU8& ru8Data);
   tU8 u8GetSensorGyroSource(tU8& ru8Data);
   tU8 u8GetSensorACCSource(tU8& ru8Data);
   tU8 u8GetTVAntenna1Info(tU8& ru8Data);
   tU8 u8GetTVAntenna2Info(tU8& ru8Data);
   tU8 u8GetTVAntenna3Info(tU8& ru8Data);
   tU8 u8GetTVAntenna4Info(tU8& ru8Data);
   tU8 u8GetSensorOdoSource(tU8& ru8Data);
   tU8 u8GetSensorReverseSource(tU8& ru8Data);
   tU8 u8GetSensorGnssSource(tU8& ru8Data);
   tU8 u8GetDVDRegionCode(tU8& ru8Data);
   tU8 u8GetBDRegionCode(tU8& ru8Data);
   tU8 u8GetWIFIFCCType(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetCMVariantCoding(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  NavDefaultPos  (Key: 0x0D05)          
//##########################################################
#define DP_U16_KDSADR_NAVDEFAULTPOS                                             0x0D05

#define DP_U8_KDSLEN_NAVDEFAULTPOS_COMPLETE                                     9

#define DP_U8_KDSLEN_NAVDEFAULTPOS_LONGITUDE                                    4
#define DP_U8_KDSLEN_NAVDEFAULTPOS_LATITUDE                                     4


class dp_tclKdsNavDefaultPos{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_NAVDEFAULTPOS_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsNavDefaultPos();
   virtual ~dp_tclKdsNavDefaultPos() {};
   
   tU8 u8GetLongitude(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLatitude(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHeading(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetNavDefaultPos(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  NavigationDataCopyProtectionSecurityECCKey  (Key: 0x1214)          
//##########################################################
#define DP_U16_KDSADR_NAVIGATIONDATACOPYPROTECTIONSECURITYECCKEY                                             0x1214

#define DP_U8_KDSLEN_NAVIGATIONDATACOPYPROTECTIONSECURITYECCKEY_COMPLETE                                     40

#define DP_U8_KDSLEN_NAVIGATIONDATACOPYPROTECTIONSECURITYECCKEY_KEY                                          40


class dp_tclKdsNavigationDataCopyProtectionSecurityECCKey{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_NAVIGATIONDATACOPYPROTECTIONSECURITYECCKEY_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsNavigationDataCopyProtectionSecurityECCKey();
   virtual ~dp_tclKdsNavigationDataCopyProtectionSecurityECCKey() {};
   
   tU8 u8GetKey(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetNavigationDataCopyProtectionSecurityECCKey(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  SWUPD_VariantInfo  (Key: 0xA070)          
//##########################################################
#define DP_U16_KDSADR_SWUPD_VARIANTINFO                                             0xA070

#define DP_U8_KDSLEN_SWUPD_VARIANTINFO_COMPLETE                                     16

#define DP_U8_KDSLEN_SWUPD_VARIANTINFO_SOFTWAREVARIANTTAG                           4


class dp_tclKdsSWUPD_VariantInfo{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_SWUPD_VARIANTINFO_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsSWUPD_VariantInfo();
   virtual ~dp_tclKdsSWUPD_VariantInfo() {};
   
   tU8 u8GetConfigurationVersion(tU8& ru8Data);
   tU8 u8GetSoftwareVariantTag(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetSWUPD_VariantInfo(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  DeviceManager  (Key: 0xA0B0)          
//##########################################################
#define DP_U16_KDSADR_DEVICEMANAGER                                             0xA0B0

#define DP_U8_KDSLEN_DEVICEMANAGER_COMPLETE                                     92

#define DP_U8_KDSLEN_DEVICEMANAGER_TAG                                          8
#define DP_U8_KDSLEN_DEVICEMANAGER_MINORVERSION                                 2
#define DP_U8_KDSLEN_DEVICEMANAGER_SUBVARIANT                                   32


class dp_tclKdsDeviceManager{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_DEVICEMANAGER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsDeviceManager();
   virtual ~dp_tclKdsDeviceManager() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSubvariant(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetIndividualSettingsFollows(tU8& ru8Data);
   tU8 u8GetChipConnector1(tU8& ru8Data);
   tU8 u8GetChipConnector2(tU8& ru8Data);
   tU8 u8GetChipConnector3(tU8& ru8Data);
   tU8 u8GetChipConnector4(tU8& ru8Data);
   tU8 u8GetHwUSB1(tU8& ru8Data);
   tU8 u8GetHwUSB2(tU8& ru8Data);
   tU8 u8GetHwUSB3(tU8& ru8Data);
   tU8 u8GetHwUSB4(tU8& ru8Data);
   tU8 u8GetUSB1(tU8& ru8Data);
   tU8 u8GetUSB2(tU8& ru8Data);
   tU8 u8GetUSB3(tU8& ru8Data);
   tU8 u8GetUSB4(tU8& ru8Data);
   tU8 u8GetChipConnector1AllowHub(tU8& ru8Data);
   tU8 u8GetChipConnector2AllowHub(tU8& ru8Data);
   tU8 u8GetChipConnector3AllowHub(tU8& ru8Data);
   tU8 u8GetChipConnector4AllowHub(tU8& ru8Data);
   tU8 u8GetUSB12(tU8& ru8Data);
   tU8 u8GetUSB22(tU8& ru8Data);
   tU8 u8GetUSB32(tU8& ru8Data);
   tU8 u8GetUSB42(tU8& ru8Data);
   tU8 u8GetUSB13(tU8& ru8Data);
   tU8 u8GetUSB23(tU8& ru8Data);
   tU8 u8GetUSB33(tU8& ru8Data);
   tU8 u8GetUSB43(tU8& ru8Data);
   tU8 u8GetUSB14(tU8& ru8Data);
   tU8 u8GetUSB24(tU8& ru8Data);
   tU8 u8GetUSB34(tU8& ru8Data);
   tU8 u8GetUSB44(tU8& ru8Data);
   tU8 u8GetUSB15(tU8& ru8Data);
   tU8 u8GetUSB25(tU8& ru8Data);
   tU8 u8GetUSB35(tU8& ru8Data);
   tU8 u8GetUSB45(tU8& ru8Data);
   tU8 u8GetMonitoring(tU8& ru8Data);
   tU8 u8GetUSB16(tU8& ru8Data);
   tU8 u8GetUSB26(tU8& ru8Data);
   tU8 u8GetUSB36(tU8& ru8Data);
   tU8 u8GetUSB46(tU8& ru8Data);
   tU8 u8GetUSB17(tU8& ru8Data);
   tU8 u8GetUSB27(tU8& ru8Data);
   tU8 u8GetUSB37(tU8& ru8Data);
   tU8 u8GetUSB47(tU8& ru8Data);
   tU8 u8GetFAT(tU8& ru8Data);
   tU8 u8GetNTFS(tU8& ru8Data);
   tU8 u8GetEXTFAT(tU8& ru8Data);
   tU8 u8GetHFSPlus(tU8& ru8Data);
   tU8 u8GetExt34FS(tU8& ru8Data);
   tU8 u8GetISO9660(tU8& ru8Data);
   tU8 u8GetUDF(tU8& ru8Data);
   tU8 u8GetUnsupportedDeviceType(tU8& ru8Data);
   tU8 u8GetUnsupportedFileSystem(tU8& ru8Data);
   tU8 u8GetUnsupportedHub(tU8& ru8Data);
   tU8 u8GetAllPartitions(tU8& ru8Data);
   tU8 u8GetMSDBiggestPartition(tU8& ru8Data);
   tU8 u8GetSortAllPartitions(tU8& ru8Data);
   tU8 u8GetExternalSD(tU8& ru8Data);
   tU8 u8GetExternalUSB(tU8& ru8Data);
   tU8 u8GetExternalMTP(tU8& ru8Data);
   tU8 u8GetExternalIPOD(tU8& ru8Data);
   tU8 u8GetExternalIPAD(tU8& ru8Data);
   tU8 u8GetExternalIPHONE(tU8& ru8Data);
   tU8 u8GetInternalCDROM(tU8& ru8Data);
   tU8 u8GetInternalCDDA(tU8& ru8Data);
   tU8 u8GetInternalSDCARD(tU8& ru8Data);
   tU8 u8GetExternalDIGIAUX(tU8& ru8Data);
   tU8 u8GetExternalBTA(tU8& ru8Data);
   tU8 u8GetExternalUnsupported(tU8& ru8Data);
   tU8 u8GetChargeAppledevs(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetDeviceManager(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  MediaPlayer  (Key: 0xA0C1)          
//##########################################################
#define DP_U16_KDSADR_MEDIAPLAYER                                             0xA0C1

#define DP_U8_KDSLEN_MEDIAPLAYER_COMPLETE                                     32

#define DP_U8_KDSLEN_MEDIAPLAYER_REGISTRYFILE                                 32


class dp_tclKdsMediaPlayer{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_MEDIAPLAYER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsMediaPlayer();
   virtual ~dp_tclKdsMediaPlayer() {};
   
   tU8 u8GetRegistryFile(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetMediaPlayer(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  Display  (Key: 0xA0C2)          
//##########################################################
#define DP_U16_KDSADR_DISPLAY                                             0xA0C2

#define DP_U8_KDSLEN_DISPLAY_COMPLETE                                     160

#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSX                                 2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSY                                 2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEX                                   2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEY                                   2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEX                                 2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEY                                 2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSX2                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSY2                                2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEX2                                  2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEY2                                  2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEX2                                2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEY2                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSX3                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSY3                                2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEX3                                  2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEY3                                  2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEX3                                2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEY3                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSX4                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSY4                                2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEX4                                  2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEY4                                  2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEX4                                2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEY4                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSX5                                2
#define DP_U8_KDSLEN_DISPLAY_NUMOFPIXELSY5                                2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEX5                                  2
#define DP_U8_KDSLEN_DISPLAY_PIXELSIZEY5                                  2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEX5                                2
#define DP_U8_KDSLEN_DISPLAY_DISPLAYSIZEY5                                2


class dp_tclKdsDisplay{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_DISPLAY_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsDisplay();
   virtual ~dp_tclKdsDisplay() {};
   
   tU8 u8GetDisplayType(tU8& ru8Data);
   tU8 u8GetDisplayOrientation(tU8& ru8Data);
   tU8 u8GetNumOfPixelsX(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNumOfPixelsY(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeX(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeY(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeX(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeY(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplayTouchTechnology(tU8& ru8Data);
   tU8 u8GetDisplayTouchFeature(tU8& ru8Data);
   tU8 u8GetDisplayType2(tU8& ru8Data);
   tU8 u8GetDisplayOrientation2(tU8& ru8Data);
   tU8 u8GetNumOfPixelsX2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNumOfPixelsY2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeX2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeY2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeX2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeY2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplayTouchTechnology2(tU8& ru8Data);
   tU8 u8GetDisplayTouchFeature2(tU8& ru8Data);
   tU8 u8GetDisplayType3(tU8& ru8Data);
   tU8 u8GetDisplayOrientation3(tU8& ru8Data);
   tU8 u8GetNumOfPixelsX3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNumOfPixelsY3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeX3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeY3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeX3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeY3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplayTouchTechnology3(tU8& ru8Data);
   tU8 u8GetDisplayTouchFeature3(tU8& ru8Data);
   tU8 u8GetDisplayType4(tU8& ru8Data);
   tU8 u8GetDisplayOrientation4(tU8& ru8Data);
   tU8 u8GetNumOfPixelsX4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNumOfPixelsY4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeX4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeY4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeX4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeY4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplayTouchTechnology4(tU8& ru8Data);
   tU8 u8GetDisplayTouchFeature4(tU8& ru8Data);
   tU8 u8GetDisplayType5(tU8& ru8Data);
   tU8 u8GetDisplayOrientation5(tU8& ru8Data);
   tU8 u8GetNumOfPixelsX5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNumOfPixelsY5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeX5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPixelSizeY5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeX5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplaySizeY5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetDisplayTouchTechnology5(tU8& ru8Data);
   tU8 u8GetDisplayTouchFeature5(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetDisplay(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  CameraSystem  (Key: 0xA111)          
//##########################################################
#define DP_U16_KDSADR_CAMERASYSTEM                                             0xA111

#define DP_U8_KDSLEN_CAMERASYSTEM_COMPLETE                                     88

#define DP_U8_KDSLEN_CAMERASYSTEM_VEHICLEWIDTH                                 2
#define DP_U8_KDSLEN_CAMERASYSTEM_WHEELBASE                                    2
#define DP_U8_KDSLEN_CAMERASYSTEM_REAROVERHANG                                 2
#define DP_U8_KDSLEN_CAMERASYSTEM_STEERWHEELCALIBF1                            2
#define DP_U8_KDSLEN_CAMERASYSTEM_STEERWHEELCALIBF3                            2
#define DP_U8_KDSLEN_CAMERASYSTEM_MAXSTEERWHEELANGLE                           2
#define DP_U8_KDSLEN_CAMERASYSTEM_MAXREARWHEELANGLE                            2
#define DP_U8_KDSLEN_CAMERASYSTEM_RADIUSTUNINGFACT                             2
#define DP_U8_KDSLEN_CAMERASYSTEM_CAMXOFFSET                                   2
#define DP_U8_KDSLEN_CAMERASYSTEM_CAMYOFFSET                                   2
#define DP_U8_KDSLEN_CAMERASYSTEM_CAMZOFFSET                                   2
#define DP_U8_KDSLEN_CAMERASYSTEM_CAMYAW                                       2
#define DP_U8_KDSLEN_CAMERASYSTEM_CAMPITCH                                     2
#define DP_U8_KDSLEN_CAMERASYSTEM_CAMROLL                                      2


class dp_tclKdsCameraSystem{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_CAMERASYSTEM_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsCameraSystem();
   virtual ~dp_tclKdsCameraSystem() {};
   
   tU8 u8GetConfigStringVersionMajor(tU8& ru8Data);
   tU8 u8GetConfigStringVersionMinor(tU8& ru8Data);
   tU8 u8GetVehicleWidth(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetWheelBase(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRearOverhang(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSteerWheelCalibF1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetSteerWheelCalibF3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxSteerWheelAngle(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxRearWheelAngle(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRadiusTuningFact(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetFourWheelSteering(tU8& ru8Data);
   tU8 u8GetTireAngleTurnSense(tU8& ru8Data);
   tU8 u8GetTireAngleReferencePoint(tU8& ru8Data);
   tU8 u8GetGuidelineStyle(tU8& ru8Data);
   tU8 u8GetTestConfigOnlyFlag(tU8& ru8Data);
   tU8 u8GetCamXOffset(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCamYOffset(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCamZOffset(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCamYaw(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCamPitch(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCamRoll(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetFrontTireThresh(tU8& ru8Data);
   tU8 u8GetMinFrontTireChange(tU8& ru8Data);
   tU8 u8GetRearTireThresh(tU8& ru8Data);
   tU8 u8GetMinRearTireChange(tU8& ru8Data);
   tU8 u8GetGuidelineStartDistance(tU8& ru8Data);
   tU8 u8GetGuidelineSideMargin(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideNearR(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideNearG(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideNearB(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideMidR(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideMidG(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideMidB(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideFarR(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideFarG(tU8& ru8Data);
   tU8 u8GetRgbColorStaticSideFarB(tU8& ru8Data);
   tU8 u8GetRgbColorStaticCenterR(tU8& ru8Data);
   tU8 u8GetRgbColorStaticCenterG(tU8& ru8Data);
   tU8 u8GetRgbColorStaticCenterB(tU8& ru8Data);
   tU8 u8GetRgbColorDynamicR(tU8& ru8Data);
   tU8 u8GetRgbColorDynamicG(tU8& ru8Data);
   tU8 u8GetRgbColorDynamicB(tU8& ru8Data);
   tU8 u8GetLineWidthStaticSideNear(tU8& ru8Data);
   tU8 u8GetLineWidthStaticSideFar(tU8& ru8Data);
   tU8 u8GetLineWidthDynamicNear(tU8& ru8Data);
   tU8 u8GetLineWidthDynamicFar(tU8& ru8Data);
   tU8 u8GetLineWidthStaticCenterNear(tU8& ru8Data);
   tU8 u8GetLineWidthStaticCenterFar(tU8& ru8Data);
   tU8 u8GetStaticLineLengthNear(tU8& ru8Data);
   tU8 u8GetStaticLineLengthMid(tU8& ru8Data);
   tU8 u8GetStaticLineLengthFar1(tU8& ru8Data);
   tU8 u8GetStaticLineLengthFar2(tU8& ru8Data);
   tU8 u8GetStaticHorizLineLength(tU8& ru8Data);
   tU8 u8GetLineWidthFactorNearHLine(tU8& ru8Data);
   tU8 u8GetTuningStringVersion(tU8& ru8Data);
   tU8 u8GetTuningMethod(tU8& ru8Data);
   tU8 u8GetTuningDeltaCamYaw(tU8& ru8Data);
   tU8 u8GetTuningDeltaCamPitch(tU8& ru8Data);
   tU8 u8GetTuningDeltaCamRoll(tU8& ru8Data);
   tU8 u8GetTuningDeltaXNearLeft(tU8& ru8Data);
   tU8 u8GetTuningDeltaYNearLeft(tU8& ru8Data);
   tU8 u8GetTuningDeltaXFarLeft(tU8& ru8Data);
   tU8 u8GetTuningDeltaXNearRight(tU8& ru8Data);
   tU8 u8GetTuningDeltaYNearRight(tU8& ru8Data);
   tU8 u8GetTuningDeltaXFarRight(tU8& ru8Data);
   tU8 u8GetTuningNearLineLengthLeft(tU8& ru8Data);
   tU8 u8GetTuningNearLineLengthRight(tU8& ru8Data);
   tU8 u8GetTuningSwaZeroPointOffset(tU8& ru8Data);
   tU8 u8GetTuningRwaZeroPointOffset(tU8& ru8Data);
   tU8 u8GetAnticipatoryLine(tU8& ru8Data);
   tU8 u8GetCameraSystem(tU8& ru8Data);
   tU8 u8GetCameraConnection(tU8& ru8Data);
   tU8 u8GetSonarSystemAvailability(tU8& ru8Data);
   tU8 u8GetSonarSwitchDisplay(tU8& ru8Data);
   tU8 u8GetSonarMenu(tU8& ru8Data);
   tU8 u8GetSonarType(tU8& ru8Data);
   tU8 u8GetSonarAVM(tU8& ru8Data);
   tU8 u8GetSonarDisplay(tU8& ru8Data);
   tU8 u8GetSonarSound(tU8& ru8Data);
   tU8 u8GetSonarFKP(tU8& ru8Data);
   tU8 u8GetSonarVehicleImage(tU8& ru8Data);
   tU8 u8GetCameraBrightnessDay(tU8& ru8Data);
   tU8 u8GetCameraBrightnessNight(tU8& ru8Data);
   tU8 u8GetCameraSteeringMessage(tU8& ru8Data);
   tU8 u8GetRVCLensParameter(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetCameraSystem(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  VehicleInformation  (Key: 0xA112)          
//##########################################################
#define DP_U16_KDSADR_VEHICLEINFORMATION                                             0xA112

#define DP_U8_KDSLEN_VEHICLEINFORMATION_COMPLETE                                     65

#define DP_U8_KDSLEN_VEHICLEINFORMATION_VEHICLETYPE                                  2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_WEIGHTOFVEHICLE                              2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_WIDTHOFVEHICLE                               2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_HEIGHTOFVEHICLE                              2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_LENGTHOFVEHICLE                              2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_MOTOREFFICIENCY                              2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_REDUCTIONGEAREFFICIENCY                      2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_CDVALUE                                      2
#define DP_U8_KDSLEN_VEHICLEINFORMATION_MAXIMUMLOADPERAXLE                           2


class dp_tclKdsVehicleInformation{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_VEHICLEINFORMATION_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsVehicleInformation();
   virtual ~dp_tclKdsVehicleInformation() {};
   
   tU8 u8GetDestinationRegion1(tU8& ru8Data);
   tU8 u8GetVehicleType(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetWeightOfVehicle(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetWidthOfVehicle(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHeightOfVehicle(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLengthOfVehicle(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetVehicleBodyShape(tU8& ru8Data);
   tU8 u8GetSteeringPosition(tU8& ru8Data);
   tU8 u8GetDrivingType(tU8& ru8Data);
   tU8 u8GetTPMS(tU8& ru8Data);
   tU8 u8GetFuelType(tU8& ru8Data);
   tU8 u8GetPetrolType(tU8& ru8Data);
   tU8 u8GetPowerPlatform(tU8& ru8Data);
   tU8 u8GetVCANSupervision(tU8& ru8Data);
   tU8 u8GetTypeOfMeter(tU8& ru8Data);
   tU8 u8GetVCANMCANGatewayForANCASC(tU8& ru8Data);
   tU8 u8GetVCANDiversity(tU8& ru8Data);
   tU8 u8GetSteeringSW(tU8& ru8Data);
   tU8 u8GetIntelligentSpeedAssist(tU8& ru8Data);
   tU8 u8GetIPAHFP(tU8& ru8Data);
   tU8 u8GetCANActivationC1A(tU8& ru8Data);
   tU8 u8GetRCSRearArmrestSwitch(tU8& ru8Data);
   tU8 u8GetMicrophone(tU8& ru8Data);
   tU8 u8GetTrafficSignRecognition(tU8& ru8Data);
   tU8 u8GetITCommanderCentralSwitch(tU8& ru8Data);
   tU8 u8GetExternalCDDrive(tU8& ru8Data);
   tU8 u8GetETC20(tU8& ru8Data);
   tU8 u8GetMediaPlayerExternalBDDVDCDPlayer(tU8& ru8Data);
   tU8 u8GetRSE(tU8& ru8Data);
   tU8 u8GetTCU(tU8& ru8Data);
   tU8 u8GetEVHVAC(tU8& ru8Data);
   tU8 u8GetHEVShapeOfBody(tU8& ru8Data);
   tU8 u8GetCPWakeUpStrategy(tU8& ru8Data);
   tU8 u8GetMotorEfficiency(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetReductionGearEfficiency(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCdValue(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetChargingCableConnector(tU8& ru8Data);
   tU8 u8GetChargingCableSpotSidePlug(tU8& ru8Data);
   tU8 u8GetVehicleInlet(tU8& ru8Data);
   tU8 u8GetCNFCHGFACTYPE(tU8& ru8Data);
   tU8 u8GetMaxMotorPowerOutput(tU8& ru8Data);
   tU8 u8GetMaxMotorRegenerativePower(tU8& ru8Data);
   tU8 u8GetBlowerReductionRequest(tU8& ru8Data);
   tU8 u8GetEthernetInterface(tU8& ru8Data);
   tU8 u8GetRADIOSATELLITESWITCH(tU8& ru8Data);
   tU8 u8GetHUD(tU8& ru8Data);
   tU8 u8GetInductiveCharger(tU8& ru8Data);
   tU8 u8GetFuelConsumptionInfo(tU8& ru8Data);
   tU8 u8GetHUDSetting(tU8& ru8Data);
   tU8 u8GetNaviAvailableSettingHUD(tU8& ru8Data);
   tU8 u8GetLearningParkFunction(tU8& ru8Data);
   tU8 u8GetRemoteParkFunction(tU8& ru8Data);
   tU8 u8GetTransmissionType(tU8& ru8Data);
   tU8 u8GetMeterSeetingIcon(tU8& ru8Data);
   tU8 u8GetSendingCountryInformation(tU8& ru8Data);
   tU8 u8GetSmartCharging(tU8& ru8Data);
   tU8 u8GetChargingCableGrouping(tU8& ru8Data);
   tU8 u8GetUnballastWarningTime(tU8& ru8Data);
   tU8 u8GetMinTimeBeforeUnballast(tU8& ru8Data);
   tU8 u8GetUnballastCounter(tU8& ru8Data);
   tU8 u8GetADFunction(tU8& ru8Data);
   tU8 u8GetCameraPictureColor(tU8& ru8Data);
   tU8 u8GetDynamicLength(tU8& ru8Data);
   tU8 u8GetTuningDeltaXFarLeftDyn(tU8& ru8Data);
   tU8 u8GetWarningTextPos(tU8& ru8Data);
   tU8 u8GetTuningDeltaXFarRightDyn(tU8& ru8Data);
   tU8 u8GetRearCameraActivation(tU8& ru8Data);
   tU8 u8GetCropUp(tU8& ru8Data);
   tU8 u8GetAdditionalRVCConfigurationItems(tU8& ru8Data);
   tU8 u8GetCropDown(tU8& ru8Data);
   tU8 u8GetCropLeft(tU8& ru8Data);
   tU8 u8GetCropRight(tU8& ru8Data);
   tU8 u8GetReverseGearDebouncing(tU8& ru8Data);
   tU8 u8GetCameraPictureHoldingTime(tU8& ru8Data);
   tU8 u8GetCameraPictureContrast(tU8& ru8Data);
   tU8 u8GetCameraRearTrunkBehaviour(tU8& ru8Data);
   tU8 u8GetCameraPictureTint(tU8& ru8Data);
   tU8 u8GetVehicleSpeedTooHigh(tU8& ru8Data);
   tU8 u8GetCameraImageMirror(tU8& ru8Data);
   tU8 u8GetCameraPictureBlackLevelDay(tU8& ru8Data);
   tU8 u8GetCameraPictureBlackLevelNight(tU8& ru8Data);
   tU8 u8GetSeatGuidanceDR(tU8& ru8Data);
   tU8 u8GetSeatGuidancePS(tU8& ru8Data);
   tU8 u8GetTrailerType(tU8& ru8Data);
   tU8 u8GetNumberOfAxes(tU8& ru8Data);
   tU8 u8GetMaximumLoadPerAxle(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetVehicleInformation(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  SoundVolumeConfig  (Key: 0xA12B)          
//##########################################################
#define DP_U16_KDSADR_SOUNDVOLUMECONFIG                                             0xA12B

#define DP_U8_KDSLEN_SOUNDVOLUMECONFIG_COMPLETE                                     17



class dp_tclKdsSoundVolumeConfig{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_SOUNDVOLUMECONFIG_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsSoundVolumeConfig();
   virtual ~dp_tclKdsSoundVolumeConfig() {};
   
   tU8 u8GetCptMinVolMinVal(tU8& ru8Data);
   tU8 u8GetCptMinVolMaxVal(tU8& ru8Data);
   tU8 u8GetCptMaxVolMinVal(tU8& ru8Data);
   tU8 u8GetCptMaxVolMaxVal(tU8& ru8Data);
   tU8 u8GetCabMinVolMinVal(tU8& ru8Data);
   tU8 u8GetCabMinVolMaxVal(tU8& ru8Data);
   tU8 u8GetCabMaxVolMinVal(tU8& ru8Data);
   tU8 u8GetCabMaxVolMaxVal(tU8& ru8Data);
   tU8 u8GetLoudness(tU8& ru8Data);
   tU8 u8GetBeepClicLevel(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetSoundVolumeConfig(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  HMIConfig  (Key: 0xA12A)          
//##########################################################
#define DP_U16_KDSADR_HMICONFIG                                             0xA12A

#define DP_U8_KDSLEN_HMICONFIG_COMPLETE                                     21



class dp_tclKdsHMIConfig{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_HMICONFIG_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsHMIConfig();
   virtual ~dp_tclKdsHMIConfig() {};
   
   tU8 u8GetCFGClusterStyle(tU8& ru8Data);
   tU8 u8GetCFGColorSelection(tU8& ru8Data);
   tU8 u8GetCFGDualzoneMonozone(tU8& ru8Data);
   tU8 u8GetCFGRearClim(tU8& ru8Data);
   tU8 u8GetCFGHeatedWindscreen(tU8& ru8Data);
   tU8 u8GetAIRFRESHNERCF(tU8& ru8Data);
   tU8 u8GetCFGSailingSettings(tU8& ru8Data);
   tU8 u8GetCFGDSISettings(tU8& ru8Data);
   tU8 u8GetCFGSynchronize(tU8& ru8Data);
   tU8 u8GetCFGRVCFixedGuidelines(tU8& ru8Data);
   tU8 u8GetCFGRVCDynamicGuidelines(tU8& ru8Data);
   tU8 u8GetCFGHMD(tU8& ru8Data);
   tU8 u8GetCFGHeatedVentilatedSeats(tU8& ru8Data);
   tU8 u8GetCFGSeatMassage(tU8& ru8Data);
   tU8 u8GetCFGMagicFolding(tU8& ru8Data);
   tU8 u8GetCFGMemoSeat(tU8& ru8Data);
   tU8 u8GetCFGFLOWSEDACTIVATION(tU8& ru8Data);
   tU8 u8GetCFGIonizer(tU8& ru8Data);
   tU8 u8GetCFGFragance(tU8& ru8Data);
   tU8 u8GetCFGAQSHistogram(tU8& ru8Data);
   tU8 u8GetCFGAmbientLighting(tU8& ru8Data);
   tU8 u8GetCFGRemoteEngineStart(tU8& ru8Data);
   tU8 u8GetCFGDimmingStrategy(tU8& ru8Data);
   tU8 u8GetCFGOffBoardConsulting(tU8& ru8Data);
   tU8 u8GetCFGEcoMode(tU8& ru8Data);
   tU8 u8GetCFGSS(tU8& ru8Data);
   tU8 u8GetCFGVehicleMode(tU8& ru8Data);
   tU8 u8GetCFGDRIVECO(tU8& ru8Data);
   tU8 u8GetCfMPURearWiper(tU8& ru8Data);
   tU8 u8GetCfMPUAutoFrontWiper(tU8& ru8Data);
   tU8 u8GetCfMPUFlashersVolumeSelection(tU8& ru8Data);
   tU8 u8GetCfMPUMotorwayFlashersNb(tU8& ru8Data);
   tU8 u8GetCfMPUFRWiperDrop(tU8& ru8Data);
   tU8 u8GetCfMPUSingleDoorOpening(tU8& ru8Data);
   tU8 u8GetCfMPUAutoLockUp(tU8& ru8Data);
   tU8 u8GetCfMPUHandFreeLockUnlock(tU8& ru8Data);
   tU8 u8GetCfMPUWACSilentMode(tU8& ru8Data);
   tU8 u8GetCfMPUWACAPRUN(tU8& ru8Data);
   tU8 u8GetCfMPUMirrorsFolding(tU8& ru8Data);
   tU8 u8GetCfMPUAutoRelock(tU8& ru8Data);
   tU8 u8GetCfMPUAutoFMH(tU8& ru8Data);
   tU8 u8GetCfMPUWGS(tU8& ru8Data);
   tU8 u8GetCfMPUDrivingSide(tU8& ru8Data);
   tU8 u8GetCfMPUAFS(tU8& ru8Data);
   tU8 u8GetCfMPUADB(tU8& ru8Data);
   tU8 u8GetCfMPUAHLFunction(tU8& ru8Data);
   tU8 u8GetCfMPUALSThreshold(tU8& ru8Data);
   tU8 u8GetTPMSMMICF(tU8& ru8Data);
   tU8 u8GetCFG4WDHMI(tU8& ru8Data);
   tU8 u8GetADASSR(tU8& ru8Data);
   tU8 u8GetADASUTA(tU8& ru8Data);
   tU8 u8GetADASDW(tU8& ru8Data);
   tU8 u8GetADASDangerousArea(tU8& ru8Data);
   tU8 u8GetADASAEB(tU8& ru8Data);
   tU8 u8GetADASOSP(tU8& ru8Data);
   tU8 u8GetADASLKA(tU8& ru8Data);
   tU8 u8GetADASLDW(tU8& ru8Data);
   tU8 u8GetADASBSW(tU8& ru8Data);
   tU8 u8GetADASPSM(tU8& ru8Data);
   tU8 u8GetCFGADASAPA(tU8& ru8Data);
   tU8 u8GetADASFKP(tU8& ru8Data);
   tU8 u8GetADASUPAAudio(tU8& ru8Data);
   tU8 u8GetDisplayFormat(tU8& ru8Data);
   tU8 u8GetADASUPAVisual(tU8& ru8Data);
   tU8 u8GetCFGAM(tU8& ru8Data);
   tU8 u8GetVolumePopupPosition(tU8& ru8Data);
   tU8 u8GetCFGAUDIOSpeakers(tU8& ru8Data);
   tU8 u8GetTyrePressureUnitCF(tU8& ru8Data);
   tU8 u8GetCFGSMARTINTLIGHT(tU8& ru8Data);
   tU8 u8GetCFGHMIDATEDISPLAY(tU8& ru8Data);
   tU8 u8GetCFGSPVR(tU8& ru8Data);
   tU8 u8GetCFGAM2(tU8& ru8Data);
   tU8 u8GetCFGForgotPhonePopup(tU8& ru8Data);
   tU8 u8GetCFGDRECOSALING(tU8& ru8Data);
   tU8 u8GetCFGDRECOSTOPANDSTART(tU8& ru8Data);
   tU8 u8GetCFGDRECOECOMode(tU8& ru8Data);
   tU8 u8GetCFGDRECOTTS(tU8& ru8Data);
   tU8 u8GetCFGClim(tU8& ru8Data);
   tU8 u8GetCFGSeatCourtesy(tU8& ru8Data);
   tU8 u8GetREMOTESTART2HOURSCF(tU8& ru8Data);
   tU8 u8GetCFGADASUPAMute(tU8& ru8Data);
   tU8 u8GetCFGEasyAccess(tU8& ru8Data);
   tU8 u8GetCFGTIMEAUTO(tU8& ru8Data);
   tU8 u8GetTPMSAutolocCF(tU8& ru8Data);
   tU8 u8GetCFGHome(tU8& ru8Data);
   tU8 u8GetCFGEditHome(tU8& ru8Data);
   tU8 u8GetCFGFavorite(tU8& ru8Data);
   tU8 u8GetCFGEnergyInfo(tU8& ru8Data);
   tU8 u8GetCFGGSICONTACTBREAKERBUZZERRST(tU8& ru8Data);
   tU8 u8GetCFGDRECODistanceWoAccel(tU8& ru8Data);
   tU8 u8GetCFGDRECORangeIncrease(tU8& ru8Data);
   tU8 u8GetCFGDRECOCMI(tU8& ru8Data);
   tU8 u8GetCFGDRECOEcoNav(tU8& ru8Data);
   tU8 u8GetCFGDRECOResetType(tU8& ru8Data);
   tU8 u8GetCFGDRECODistanceWoCons(tU8& ru8Data);
   tU8 u8GetCFGELFNOTIFNUMBER(tU8& ru8Data);
   tU8 u8GetCFGALDynamicPattern(tU8& ru8Data);
   tU8 u8GetCFGALAREA1(tU8& ru8Data);
   tU8 u8GetCFGALAREA2(tU8& ru8Data);
   tU8 u8GetCFGALAREA3(tU8& ru8Data);
   tU8 u8GetCFGALCOL1(tU8& ru8Data);
   tU8 u8GetCFGALCOL2(tU8& ru8Data);
   tU8 u8GetCFGALCOL3(tU8& ru8Data);
   tU8 u8GetCFGALCOL4(tU8& ru8Data);
   tU8 u8GetCFGALCOL5(tU8& ru8Data);
   tU8 u8GetCFGALCOL6(tU8& ru8Data);
   tU8 u8GetCFGALCOL7(tU8& ru8Data);
   tU8 u8GetCFGALCOL8(tU8& ru8Data);
   tU8 u8GetCFGALCOL9(tU8& ru8Data);
   tU8 u8GetCFGALCOL10(tU8& ru8Data);
   tU8 u8GetCFGALCOL11(tU8& ru8Data);
   tU8 u8GetCFGALCOL12(tU8& ru8Data);
   tU8 u8GetCFGALCOL13(tU8& ru8Data);
   tU8 u8GetCFGALCOL14(tU8& ru8Data);
   tU8 u8GetCFGALCOL15(tU8& ru8Data);
   tU8 u8GetCFGFLOWPHEVACTIVATION(tU8& ru8Data);
   tU8 u8GetCFGUserProfile(tU8& ru8Data);
   tU8 u8GetCFGAQSClim(tU8& ru8Data);
   tU8 u8GetCFGDualSyncClim(tU8& ru8Data);
   tU8 u8GetWelcomeSequence(tU8& ru8Data);
   tU8 u8GetCFGHeatedSteeringWheelClim(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetHMIConfig(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  ConfigPartNumber  (Key: 0xA116)          
//##########################################################
#define DP_U16_KDSADR_CONFIGPARTNUMBER                                             0xA116

#define DP_U8_KDSLEN_CONFIGPARTNUMBER_COMPLETE                                     10

#define DP_U8_KDSLEN_CONFIGPARTNUMBER_DATARECORD                                   10


class dp_tclKdsConfigPartNumber{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_CONFIGPARTNUMBER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsConfigPartNumber();
   virtual ~dp_tclKdsConfigPartNumber() {};
   
   tU8 u8GetDataRecord(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetConfigPartNumber(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  CustomerECUPartNumber  (Key: 0xA124)          
//##########################################################
#define DP_U16_KDSADR_CUSTOMERECUPARTNUMBER                                             0xA124

#define DP_U8_KDSLEN_CUSTOMERECUPARTNUMBER_COMPLETE                                     10

#define DP_U8_KDSLEN_CUSTOMERECUPARTNUMBER_ECUPARTNUMBER                                10


class dp_tclKdsCustomerECUPartNumber{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_CUSTOMERECUPARTNUMBER_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsCustomerECUPartNumber();
   virtual ~dp_tclKdsCustomerECUPartNumber() {};
   
   tU8 u8GetECUPartNumber(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetCustomerECUPartNumber(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  EarlyConfig_Display  (Key: 0xA090)          
//##########################################################
#define DP_U16_KDSADR_EARLYCONFIG_DISPLAY                                             0xA090

#define DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_COMPLETE                                     40

#define DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_RESOLUTION                                   32
#define DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_BACKWARDCOMPATIBILITY                        4
#define DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_LOWFREQUENCY                                 4


class dp_tclKdsEarlyConfig_Display{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsEarlyConfig_Display();
   virtual ~dp_tclKdsEarlyConfig_Display() {};
   
   tU8 u8GetResolution(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetBackwardCompatibility(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetLowFrequency(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetEarlyConfig_Display(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  EarlyConfig2Displays  (Key: 0xA092)          
//##########################################################
#define DP_U16_KDSADR_EARLYCONFIG2DISPLAYS                                             0xA092

#define DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE                                     64

#define DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS1                                32
#define DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_TRTIMINGLVDS2                                32


class dp_tclKdsEarlyConfig2Displays{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsEarlyConfig2Displays();
   virtual ~dp_tclKdsEarlyConfig2Displays() {};
   
   tU8 u8GetTrTimingLVDS1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetTrTimingLVDS2(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetEarlyConfig2Displays(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  EarlyConfig_Touch  (Key: 0xA091)          
//##########################################################
#define DP_U16_KDSADR_EARLYCONFIG_TOUCH                                             0xA091

#define DP_U8_KDSLEN_EARLYCONFIG_TOUCH_COMPLETE                                     128

#define DP_U8_KDSLEN_EARLYCONFIG_TOUCH_TOUCHDRIVERNAME                              64
#define DP_U8_KDSLEN_EARLYCONFIG_TOUCH_TOUCHCONFIGFILENAME                          64


class dp_tclKdsEarlyConfig_Touch{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_EARLYCONFIG_TOUCH_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsEarlyConfig_Touch();
   virtual ~dp_tclKdsEarlyConfig_Touch() {};
   
   tU8 u8GetTouchDriverName(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetTouchConfigFileName(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetEarlyConfig_Touch(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  InputKeyMappingTable_2  (Key: 0xA081)          
//##########################################################
#define DP_U16_KDSADR_INPUTKEYMAPPINGTABLE_2                                             0xA081

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_COMPLETE                                     230

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_MINORVERSION                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_LOGICALKEYID                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_LOGICALKEYID2                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_LOGICALKEYID3                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_LOGICALKEYID4                                2


class dp_tclKdsInputKeyMappingTable_2{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsInputKeyMappingTable_2();
   virtual ~dp_tclKdsInputKeyMappingTable_2() {};
   
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNrOfEntries1(tU8& ru8Data);
   tU8 u8GetRawKeyID(tU8& ru8Data);
   tU8 u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID2(tU8& ru8Data);
   tU8 u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID3(tU8& ru8Data);
   tU8 u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID4(tU8& ru8Data);
   tU8 u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetInputKeyMappingTable_2(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  InputKeyMappingTable_3  (Key: 0xA082)          
//##########################################################
#define DP_U16_KDSADR_INPUTKEYMAPPINGTABLE_3                                             0xA082

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_COMPLETE                                     230

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_MINORVERSION                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID2                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID3                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID4                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID5                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID6                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID7                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID8                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID9                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID10                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID11                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID12                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID13                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID14                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID15                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID16                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID17                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID18                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID19                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID20                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID21                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID22                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID23                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID24                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID25                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID26                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID27                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID28                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID29                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID30                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID31                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_LOGICALKEYID32                               2


class dp_tclKdsInputKeyMappingTable_3{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsInputKeyMappingTable_3();
   virtual ~dp_tclKdsInputKeyMappingTable_3() {};
   
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNrOfEntries(tU8& ru8Data);
   tU8 u8GetRawKeyID(tU8& ru8Data);
   tU8 u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID2(tU8& ru8Data);
   tU8 u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID3(tU8& ru8Data);
   tU8 u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID4(tU8& ru8Data);
   tU8 u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID5(tU8& ru8Data);
   tU8 u8GetLogicalKeyID5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID6(tU8& ru8Data);
   tU8 u8GetLogicalKeyID6(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID7(tU8& ru8Data);
   tU8 u8GetLogicalKeyID7(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID8(tU8& ru8Data);
   tU8 u8GetLogicalKeyID8(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID9(tU8& ru8Data);
   tU8 u8GetLogicalKeyID9(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID10(tU8& ru8Data);
   tU8 u8GetLogicalKeyID10(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID11(tU8& ru8Data);
   tU8 u8GetLogicalKeyID11(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID12(tU8& ru8Data);
   tU8 u8GetLogicalKeyID12(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID13(tU8& ru8Data);
   tU8 u8GetLogicalKeyID13(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID14(tU8& ru8Data);
   tU8 u8GetLogicalKeyID14(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID15(tU8& ru8Data);
   tU8 u8GetLogicalKeyID15(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID16(tU8& ru8Data);
   tU8 u8GetLogicalKeyID16(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID17(tU8& ru8Data);
   tU8 u8GetLogicalKeyID17(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID18(tU8& ru8Data);
   tU8 u8GetLogicalKeyID18(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID19(tU8& ru8Data);
   tU8 u8GetLogicalKeyID19(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID20(tU8& ru8Data);
   tU8 u8GetLogicalKeyID20(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID21(tU8& ru8Data);
   tU8 u8GetLogicalKeyID21(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID22(tU8& ru8Data);
   tU8 u8GetLogicalKeyID22(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID23(tU8& ru8Data);
   tU8 u8GetLogicalKeyID23(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID24(tU8& ru8Data);
   tU8 u8GetLogicalKeyID24(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID25(tU8& ru8Data);
   tU8 u8GetLogicalKeyID25(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID26(tU8& ru8Data);
   tU8 u8GetLogicalKeyID26(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID27(tU8& ru8Data);
   tU8 u8GetLogicalKeyID27(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID28(tU8& ru8Data);
   tU8 u8GetLogicalKeyID28(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID29(tU8& ru8Data);
   tU8 u8GetLogicalKeyID29(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID30(tU8& ru8Data);
   tU8 u8GetLogicalKeyID30(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID31(tU8& ru8Data);
   tU8 u8GetLogicalKeyID31(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID32(tU8& ru8Data);
   tU8 u8GetLogicalKeyID32(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetInputKeyMappingTable_3(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  InputKeyMappingTable_4  (Key: 0xA083)          
//##########################################################
#define DP_U16_KDSADR_INPUTKEYMAPPINGTABLE_4                                             0xA083

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_COMPLETE                                     230

#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_MINORVERSION                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID                                 2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID2                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID3                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID4                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID5                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID6                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID7                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID8                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID9                                2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID10                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID11                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID12                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID13                               2
#define DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_LOGICALKEYID14                               2


class dp_tclKdsInputKeyMappingTable_4{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsInputKeyMappingTable_4();
   virtual ~dp_tclKdsInputKeyMappingTable_4() {};
   
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetNrOfEntries(tU8& ru8Data);
   tU8 u8GetRawKeyID(tU8& ru8Data);
   tU8 u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID2(tU8& ru8Data);
   tU8 u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID3(tU8& ru8Data);
   tU8 u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID4(tU8& ru8Data);
   tU8 u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID5(tU8& ru8Data);
   tU8 u8GetLogicalKeyID5(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID6(tU8& ru8Data);
   tU8 u8GetLogicalKeyID6(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID7(tU8& ru8Data);
   tU8 u8GetLogicalKeyID7(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID8(tU8& ru8Data);
   tU8 u8GetLogicalKeyID8(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID9(tU8& ru8Data);
   tU8 u8GetLogicalKeyID9(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID10(tU8& ru8Data);
   tU8 u8GetLogicalKeyID10(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID11(tU8& ru8Data);
   tU8 u8GetLogicalKeyID11(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID12(tU8& ru8Data);
   tU8 u8GetLogicalKeyID12(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID13(tU8& ru8Data);
   tU8 u8GetLogicalKeyID13(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetRawKeyID14(tU8& ru8Data);
   tU8 u8GetLogicalKeyID14(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetInputKeyMappingTable_4(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  Lockout  (Key: 0xA0C0)          
//##########################################################
#define DP_U16_KDSADR_LOCKOUT                                             0xA0C0

#define DP_U8_KDSLEN_LOCKOUT_COMPLETE                                     5



class dp_tclKdsLockout{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_LOCKOUT_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsLockout();
   virtual ~dp_tclKdsLockout() {};
   
   tU8 u8GetVideoPlayingRestriction(tU8& ru8Data);
   tU8 u8GetPictureSlideshowRestriction(tU8& ru8Data);
   tU8 u8GetSMSTextInputRestriction(tU8& ru8Data);
   tU8 u8GetFeaturesTutorialsRestriction(tU8& ru8Data);
   tU8 u8GetSystemUserHandbookRestriction(tU8& ru8Data);
   tU8 u8GetTextInputRestriction(tU8& ru8Data);
   tU8 u8GetPhoneDialInputRestriction(tU8& ru8Data);
   tU8 u8GetNavigationDestinationInputRestriction(tU8& ru8Data);
   tU8 u8GetMusicRadioCoverDsplayRestriction(tU8& ru8Data);
   tU8 u8GetGeneralHMIRestriction(tU8& ru8Data);
   tU8 u8GetServiceActivationRestriction(tU8& ru8Data);
   tU8 u8GetDisplayedTextLenghtRestriction(tU8& ru8Data);
   tU8 u8GetHMIAnimationsRestriction(tU8& ru8Data);
   tU8 u8GetStationaryPictureIndictionRestriction(tU8& ru8Data);
   tU8 u8GetOneByOneLineOperationNonMusicListScrollRestriction(tU8& ru8Data);
   tU8 u8GetSmoothMapScroolOperationRestriction(tU8& ru8Data);
   tU8 u8GetDraggingOperationRestriction(tU8& ru8Data);
   tU8 u8GetPinchInOutOperationRestriction(tU8& ru8Data);
   tU8 u8GetUserProfileRestriction(tU8& ru8Data);
   tU8 u8GetHomeMenuEditionRestriction(tU8& ru8Data);
   tU8 u8GetCameraSettingsRestriction(tU8& ru8Data);
   tU8 u8GetMapRotationRestriction(tU8& ru8Data);
   tU8 u8GetPictureTextBackgroundDisplayRestriction(tU8& ru8Data);
   tU8 u8GetNissan5OperationCountRestriction(tU8& ru8Data);
   tU8 u8GetNissan8OperationCountRestriction(tU8& ru8Data);
   tU8 u8GetRenault5OperationCountRestriction(tU8& ru8Data);
   tU8 u8GetRenault8OperationCountRestriction(tU8& ru8Data);
   tU8 u8GetAudioPlayAutomaticallyRestriction(tU8& ru8Data);
   tU8 u8GetSystemUpdateRestriction(tU8& ru8Data);
   tU8 u8GetSXMStock(tU8& ru8Data);
   tU8 u8GetOneByOneLineOperationMusicListScrollRestriction(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetLockout(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  BlockingTestMode  (Key: 0xA1D4)          
//##########################################################
#define DP_U16_KDSADR_BLOCKINGTESTMODE                                             0xA1D4

#define DP_U8_KDSLEN_BLOCKINGTESTMODE_COMPLETE                                     1



class dp_tclKdsBlockingTestMode{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_BLOCKINGTESTMODE_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsBlockingTestMode();
   virtual ~dp_tclKdsBlockingTestMode() {};
   
   tU8 u8GetBlockingTestModeApplicationSwitch(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetBlockingTestMode(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  Audio_Parameter_Set  (Key: 0xA182)          
//##########################################################
#define DP_U16_KDSADR_AUDIO_PARAMETER_SET                                             0xA182

#define DP_U8_KDSLEN_AUDIO_PARAMETER_SET_COMPLETE                                     230

#define DP_U8_KDSLEN_AUDIO_PARAMETER_SET_TAG                                          8
#define DP_U8_KDSLEN_AUDIO_PARAMETER_SET_MINORVERSION                                 2
#define DP_U8_KDSLEN_AUDIO_PARAMETER_SET_PARAMETER1                                   217
#define DP_U8_KDSLEN_AUDIO_PARAMETER_SET_CRC                                          2


class dp_tclKdsAudio_Parameter_Set{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_AUDIO_PARAMETER_SET_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsAudio_Parameter_Set();
   virtual ~dp_tclKdsAudio_Parameter_Set() {};
   
   tU8 u8GetTag(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMajorVersion(tU8& ru8Data);
   tU8 u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetParameter1(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCRC(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetAudio_Parameter_Set(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  NVM_Configuration  (Key: 0xA1D5)          
//##########################################################
#define DP_U16_KDSADR_NVM_CONFIGURATION                                             0xA1D5

#define DP_U8_KDSLEN_NVM_CONFIGURATION_COMPLETE                                     8



class dp_tclKdsNVM_Configuration{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_NVM_CONFIGURATION_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsNVM_Configuration();
   virtual ~dp_tclKdsNVM_Configuration() {};
   
   tU8 u8GetPNMGroup10Switch(tU8& ru8Data);
   tU8 u8GetVCANBaudrate(tU8& ru8Data);
   tU8 u8GetMCANBaudrate(tU8& ru8Data);
   tU8 u8GetPrimaryWakeup(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetNVM_Configuration(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  AVDECC_Config  (Key: 0xA1D6)          
//##########################################################
#define DP_U16_KDSADR_AVDECC_CONFIG                                             0xA1D6

#define DP_U8_KDSLEN_AVDECC_CONFIG_COMPLETE                                     32

#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEGLASSUSBVIDEO                2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEGLASSHDMI                    2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEGLASSANALOGUECAMERA          2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEGLASSIPCAMERA                2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEAMPLIFIERUSBVIDEO            2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEAMPLIFIERHDMI                2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEAMPLIFIERAUDIO               2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEGLASSCMRDRM                  2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEAMPLIFIERCMRDRM              2
#define DP_U8_KDSLEN_AVDECC_CONFIG_PRESENTATIONTIMEAMPLIFIERCMRAUDIO            2


class dp_tclKdsAVDECC_Config{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_AVDECC_CONFIG_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsAVDECC_Config();
   virtual ~dp_tclKdsAVDECC_Config() {};
   
   tU8 u8GetPresentationTimeGlassUSBVideo(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeGlassHDMI(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeGlassAnalogueCamera(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeGlassIPCamera(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeAmplifierUSBVideo(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeAmplifierHDMI(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeAmplifierAudio(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetMaxTransitTimeCamportStream1AVBHDMI(tU8& ru8Data);
   tU8 u8GetMaxTransitTimeCamportStream2IPCAM(tU8& ru8Data);
   tU8 u8GetMaxTransitTimeCamportStream3AUDIO(tU8& ru8Data);
   tU8 u8GetPresentationTimeGlassCMRDRM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeAmplifierCMRDRM(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetPresentationTimeAmplifierCMRAudio(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetAVDECC_Config(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  CIS_Configuration  (Key: 0xA1D7)          
//##########################################################
#define DP_U16_KDSADR_CIS_CONFIGURATION                                             0xA1D7

#define DP_U8_KDSLEN_CIS_CONFIGURATION_COMPLETE                                     230

#define DP_U8_KDSLEN_CIS_CONFIGURATION_HEALTHCAREMESSAGEINTERVAL                    2
#define DP_U8_KDSLEN_CIS_CONFIGURATION_CAMERABLACKSCREENTIME                        2


class dp_tclKdsCIS_Configuration{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_CIS_CONFIGURATION_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsCIS_Configuration();
   virtual ~dp_tclKdsCIS_Configuration() {};
   
   tU8 u8GetControlPanelAvailability(tU8& ru8Data);
   tU8 u8GetIPCameraAvailablitiy(tU8& ru8Data);
   tU8 u8GetMinOnVolumeCockpit(tU8& ru8Data);
   tU8 u8GetMaxOnVolumeCockpit(tU8& ru8Data);
   tU8 u8GetMinOnVolumeCabinA(tU8& ru8Data);
   tU8 u8GetMaxOnVolumeCabinA(tU8& ru8Data);
   tU8 u8GetMinOnVolumeCabinB(tU8& ru8Data);
   tU8 u8GetMaxOnVolumeCabinB(tU8& ru8Data);
   tU8 u8GetMinOnVolumeMIC1(tU8& ru8Data);
   tU8 u8GetMaxOnVolumeMIC1(tU8& ru8Data);
   tU8 u8GetMinOnVolumeMIC2(tU8& ru8Data);
   tU8 u8GetMaxOnVolumeMIC2(tU8& ru8Data);
   tU8 u8GetMinOnVolumeMIC3(tU8& ru8Data);
   tU8 u8GetMaxOnVolumeMIC3(tU8& ru8Data);
   tU8 u8GetDoorUnlockTime(tU8& ru8Data);
   tU8 u8GetHealthcareEnabled(tU8& ru8Data);
   tU8 u8GetHealthcareMessageInterval(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetHealthcareMessageCount(tU8& ru8Data);
   tU8 u8GetCameraTileInCabinHomescreen(tU8& ru8Data);
   tU8 u8GetCameraportUSB(tU8& ru8Data);
   tU8 u8GetHourLogicEnabled(tU8& ru8Data);
   tU8 u8GetHourLogicTimeRange(tU8& ru8Data);
   tU8 u8GetHealthcareDTCPopupSeverity(tU8& ru8Data);
   tU8 u8GetSafeShutdownTimer(tU8& ru8Data);
   tU8 u8GetCameraActivation(tU8& ru8Data);
   tU8 u8GetRVCTextPosition(tU8& ru8Data);
   tU8 u8GetPrivateModeSpeakerAvailability(tU8& ru8Data);
   tU8 u8GetCameraBlackScreenTime(tU8* pu8Data, tU16 u16BufLen);
   tU8 u8GetCameraBlackScreenFeature(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8GetCIS_Configuration(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  dev_NVM_Configuration  (Key: 0x0DC4)          
//##########################################################
#define DP_U16_KDSADR_DEV_NVM_CONFIGURATION                                             0x0DC4

#define DP_U8_KDSLEN_DEV_NVM_CONFIGURATION_COMPLETE                                     8



class dp_tclKdsdev_NVM_Configuration{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_DEV_NVM_CONFIGURATION_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsdev_NVM_Configuration();
   virtual ~dp_tclKdsdev_NVM_Configuration() {};
   
   tU8 u8GetPNMGroup10Switch(tU8& ru8Data);
   tU8 u8GetVCANBaudrate(tU8& ru8Data);
   tU8 u8GetMCANBaudrate(tU8& ru8Data);
   tU8 u8GetPrimaryWakeup(tU8& ru8Data);
   
   tU8 u8DataValid() const;
   tU8 u8Getdev_NVM_Configuration(tU8* pu8Data, tU16 u16BufLen);
};


//##########################################################
//#######  CMConfigurationInformation  (Key: 0x0D30)          
//##########################################################
#define DP_U16_KDSADR_CMCONFIGURATIONINFORMATION                                             0x0D30

#define DP_U8_KDSLEN_CMCONFIGURATIONINFORMATION_COMPLETE                                     20

#define DP_U8_KDSLEN_CMCONFIGURATIONINFORMATION_CONFIGURATIONHASH                            20


class dp_tclKdsCMConfigurationInformation{
private:
   tU8   _u8DataStatus;
   tU8   _au8data[DP_U8_KDSLEN_CMCONFIGURATIONINFORMATION_COMPLETE];

   tVoid vUpdate(tVoid);
   tBool bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const;
   
public:
   dp_tclKdsCMConfigurationInformation();
   virtual ~dp_tclKdsCMConfigurationInformation() {};
   
   tU8 u8GetConfigurationHash(tU8* pu8Data, tU16 u16BufLen);
   
   tU8 u8DataValid() const;
   tU8 u8GetCMConfigurationInformation(tU8* pu8Data, tU16 u16BufLen);
};


#endif
