
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_Sxm.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SXMAudioAlert"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSXMAudioAlert::dp_tclAppHmi_SxmSXMAudioAlert(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSXMAudioAlert,0,sizeof(HmiAppSxm::AlertSetting));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSXMAudioAlert::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SXMAudioAlert",(tS32) 0xef9f08d2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(HmiAppSxm::AlertSetting)) 
      {
         tSXMAudioAlert = *((HmiAppSxm::AlertSetting*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSXMAudioAlert::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SXMAudioAlert", (tS32)0xef9f08d2);
   (tVoid)myDpElem.bFillData((tVoid*)&tSXMAudioAlert, (tU32)sizeof(HmiAppSxm::AlertSetting));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSXMAudioAlert::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSXMAudioAlert::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
HmiAppSxm::AlertSetting dp_tclAppHmi_SxmSXMAudioAlert::tGetData() {
   vUpdate();
   return tSXMAudioAlert;
};
tS32 dp_tclAppHmi_SxmSXMAudioAlert::s32GetData(HmiAppSxm::AlertSetting& tSXMAudioAlertParam) { 
   vUpdate();
   tSXMAudioAlertParam = tSXMAudioAlert;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSXMAudioAlert::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SXMAudioAlert", (tS32)0xef9f08d2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSXMAudioAlert::operator>>(HmiAppSxm::AlertSetting& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSXMAudioAlert::operator<<(HmiAppSxm::AlertSetting oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSXMAudioAlert::s32SetData(HmiAppSxm::AlertSetting &tSXMAudioAlertParam) {
   //init parameter
   (tVoid)memcpy(&tSXMAudioAlert,(tVoid*)&tSXMAudioAlertParam, sizeof(HmiAppSxm::AlertSetting));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSXMAudioAlertParam' in function 'dp_tclAppHmi_SxmSXMAudioAlert::vSetData(HmiAppSxm::AlertSetting)' could be made const reference
tS32 dp_tclAppHmi_SxmSXMAudioAlert::s32SetData(const HmiAppSxm::AlertSetting &tSXMAudioAlertParam) {
   //init parameter
   (tVoid)memcpy(&tSXMAudioAlert,(tVoid*)&tSXMAudioAlertParam, sizeof(HmiAppSxm::AlertSetting));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSXMAudioAlertParam' in function 'dp_tclAppHmi_SxmSXMAudioAlert::vSetData(HmiAppSxm::AlertSetting)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSXMAudioAlert::u8GetData(HmiAppSxm::AlertSetting& tSXMAudioAlertParam) {  
   vUpdate();
   tSXMAudioAlertParam = tSXMAudioAlert;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSXMAudioAlert::vSetData(HmiAppSxm::AlertSetting &tSXMAudioAlertParam) { 
   //init parameter
   (tVoid)memcpy(&tSXMAudioAlert,(tVoid*)&tSXMAudioAlertParam, sizeof(HmiAppSxm::AlertSetting));
   vStore();
}//lint !e1746: parameter 'tSXMAudioAlertParam' in function 'dp_tclAppHmi_SxmSXMAudioAlert::vSetData(HmiAppSxm::AlertSetting)' could be made const reference
tVoid dp_tclAppHmi_SxmSXMAudioAlert::vSetData(const HmiAppSxm::AlertSetting &tSXMAudioAlertParam) { 
   //init parameter
   (tVoid)memcpy(&tSXMAudioAlert,(tVoid*)&tSXMAudioAlertParam, sizeof(HmiAppSxm::AlertSetting));
   vStore();
}//lint !e1746: parameter 'tSXMAudioAlertParam' in function 'dp_tclAppHmi_SxmSXMAudioAlert::vSetData(HmiAppSxm::AlertSetting)' could be made const reference
tU8   dp_tclAppHmi_SxmSXMAudioAlert::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSXMAudioAlert::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SXMAudioAlert", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSXMAudioAlert::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SXMAudioAlert", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSXMAudioAlert::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SXMAudioAlert", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SXMAudioAlert has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageCodeSXM"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmLanguageCodeSXM::dp_tclAppHmi_SxmLanguageCodeSXM(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageCodeSXM,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmLanguageCodeSXM::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageCodeSXM",(tS32) 0x51263d9f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageCodeSXM = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmLanguageCodeSXM::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageCodeSXM", (tS32)0x51263d9f);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageCodeSXM, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmLanguageCodeSXM::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmLanguageCodeSXM::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SxmLanguageCodeSXM::tGetData() {
   vUpdate();
   return tLanguageCodeSXM;
};
tS32 dp_tclAppHmi_SxmLanguageCodeSXM::s32GetData(tU8& tLanguageCodeSXMParam) { 
   vUpdate();
   tLanguageCodeSXMParam = tLanguageCodeSXM;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmLanguageCodeSXM::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageCodeSXM", (tS32)0x51263d9f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmLanguageCodeSXM::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmLanguageCodeSXM::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmLanguageCodeSXM::s32SetData(tU8 &tLanguageCodeSXMParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageCodeSXM,(tVoid*)&tLanguageCodeSXMParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageCodeSXMParam' in function 'dp_tclAppHmi_SxmLanguageCodeSXM::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SxmLanguageCodeSXM::s32SetData(const tU8 &tLanguageCodeSXMParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageCodeSXM,(tVoid*)&tLanguageCodeSXMParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageCodeSXMParam' in function 'dp_tclAppHmi_SxmLanguageCodeSXM::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmLanguageCodeSXM::u8GetData(tU8& tLanguageCodeSXMParam) {  
   vUpdate();
   tLanguageCodeSXMParam = tLanguageCodeSXM;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmLanguageCodeSXM::vSetData(tU8 &tLanguageCodeSXMParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageCodeSXM,(tVoid*)&tLanguageCodeSXMParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageCodeSXMParam' in function 'dp_tclAppHmi_SxmLanguageCodeSXM::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SxmLanguageCodeSXM::vSetData(const tU8 &tLanguageCodeSXMParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageCodeSXM,(tVoid*)&tLanguageCodeSXMParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageCodeSXMParam' in function 'dp_tclAppHmi_SxmLanguageCodeSXM::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SxmLanguageCodeSXM::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmLanguageCodeSXM::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "LanguageCodeSXM", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmLanguageCodeSXM::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "LanguageCodeSXM", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmLanguageCodeSXM::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageCodeSXM", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element LanguageCodeSXM has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SxmAudioTuneStartStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSxmAudioTuneStartStatus::dp_tclAppHmi_SxmSxmAudioTuneStartStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSxmAudioTuneStartStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SxmAudioTuneStartStatus",(tS32) 0xc5736304);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSxmAudioTuneStartStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SxmAudioTuneStartStatus", (tS32)0xc5736304);
   (tVoid)myDpElem.bFillData((tVoid*)&tSxmAudioTuneStartStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSxmAudioTuneStartStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSxmAudioTuneStartStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_SxmSxmAudioTuneStartStatus::tGetData() {
   vUpdate();
   return tSxmAudioTuneStartStatus;
};
tS32 dp_tclAppHmi_SxmSxmAudioTuneStartStatus::s32GetData(tBool& tSxmAudioTuneStartStatusParam) { 
   vUpdate();
   tSxmAudioTuneStartStatusParam = tSxmAudioTuneStartStatus;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSxmAudioTuneStartStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SxmAudioTuneStartStatus", (tS32)0xc5736304);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSxmAudioTuneStartStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSxmAudioTuneStartStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSxmAudioTuneStartStatus::s32SetData(tBool &tSxmAudioTuneStartStatusParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioTuneStartStatus,(tVoid*)&tSxmAudioTuneStartStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioTuneStartStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_SxmSxmAudioTuneStartStatus::s32SetData(const tBool &tSxmAudioTuneStartStatusParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioTuneStartStatus,(tVoid*)&tSxmAudioTuneStartStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioTuneStartStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSxmAudioTuneStartStatus::u8GetData(tBool& tSxmAudioTuneStartStatusParam) {  
   vUpdate();
   tSxmAudioTuneStartStatusParam = tSxmAudioTuneStartStatus;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vSetData(tBool &tSxmAudioTuneStartStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioTuneStartStatus,(tVoid*)&tSxmAudioTuneStartStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmAudioTuneStartStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vSetData(const tBool &tSxmAudioTuneStartStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioTuneStartStatus,(tVoid*)&tSxmAudioTuneStartStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmAudioTuneStartStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioTuneStartStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_SxmSxmAudioTuneStartStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSxmAudioTuneStartStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioTuneStartStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioTuneStartStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioTuneStartStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioTuneStartStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SxmAudioTuneStartStatus", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SxmAudioTuneStartStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SxmAudioActivePresetBand"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSxmAudioActivePresetBand::dp_tclAppHmi_SxmSxmAudioActivePresetBand(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSxmAudioActivePresetBand,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSxmAudioActivePresetBand::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SxmAudioActivePresetBand",(tS32) 0x8ff80a9a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSxmAudioActivePresetBand = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSxmAudioActivePresetBand::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SxmAudioActivePresetBand", (tS32)0x8ff80a9a);
   (tVoid)myDpElem.bFillData((tVoid*)&tSxmAudioActivePresetBand, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSxmAudioActivePresetBand::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSxmAudioActivePresetBand::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SxmSxmAudioActivePresetBand::tGetData() {
   vUpdate();
   return tSxmAudioActivePresetBand;
};
tS32 dp_tclAppHmi_SxmSxmAudioActivePresetBand::s32GetData(tU8& tSxmAudioActivePresetBandParam) { 
   vUpdate();
   tSxmAudioActivePresetBandParam = tSxmAudioActivePresetBand;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSxmAudioActivePresetBand::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SxmAudioActivePresetBand", (tS32)0x8ff80a9a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSxmAudioActivePresetBand::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSxmAudioActivePresetBand::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSxmAudioActivePresetBand::s32SetData(tU8 &tSxmAudioActivePresetBandParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioActivePresetBand,(tVoid*)&tSxmAudioActivePresetBandParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioActivePresetBandParam' in function 'dp_tclAppHmi_SxmSxmAudioActivePresetBand::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SxmSxmAudioActivePresetBand::s32SetData(const tU8 &tSxmAudioActivePresetBandParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioActivePresetBand,(tVoid*)&tSxmAudioActivePresetBandParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioActivePresetBandParam' in function 'dp_tclAppHmi_SxmSxmAudioActivePresetBand::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSxmAudioActivePresetBand::u8GetData(tU8& tSxmAudioActivePresetBandParam) {  
   vUpdate();
   tSxmAudioActivePresetBandParam = tSxmAudioActivePresetBand;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSxmAudioActivePresetBand::vSetData(tU8 &tSxmAudioActivePresetBandParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioActivePresetBand,(tVoid*)&tSxmAudioActivePresetBandParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSxmAudioActivePresetBandParam' in function 'dp_tclAppHmi_SxmSxmAudioActivePresetBand::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SxmSxmAudioActivePresetBand::vSetData(const tU8 &tSxmAudioActivePresetBandParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioActivePresetBand,(tVoid*)&tSxmAudioActivePresetBandParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSxmAudioActivePresetBandParam' in function 'dp_tclAppHmi_SxmSxmAudioActivePresetBand::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SxmSxmAudioActivePresetBand::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSxmAudioActivePresetBand::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioActivePresetBand", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioActivePresetBand::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioActivePresetBand", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioActivePresetBand::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SxmAudioActivePresetBand", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SxmAudioActivePresetBand has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SxmSportsFlashNotification"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSxmSportsFlashNotification::dp_tclAppHmi_SxmSxmSportsFlashNotification(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSxmSportsFlashNotification,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSxmSportsFlashNotification::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SxmSportsFlashNotification",(tS32) 0x55a49520L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSxmSportsFlashNotification = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSxmSportsFlashNotification::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SxmSportsFlashNotification", (tS32)0x55a49520L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSxmSportsFlashNotification, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSxmSportsFlashNotification::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSxmSportsFlashNotification::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_SxmSxmSportsFlashNotification::tGetData() {
   vUpdate();
   return tSxmSportsFlashNotification;
};
tS32 dp_tclAppHmi_SxmSxmSportsFlashNotification::s32GetData(tBool& tSxmSportsFlashNotificationParam) { 
   vUpdate();
   tSxmSportsFlashNotificationParam = tSxmSportsFlashNotification;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSxmSportsFlashNotification::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SxmSportsFlashNotification", (tS32)0x55a49520L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSxmSportsFlashNotification::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSxmSportsFlashNotification::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSxmSportsFlashNotification::s32SetData(tBool &tSxmSportsFlashNotificationParam) {
   //init parameter
   (tVoid)memcpy(&tSxmSportsFlashNotification,(tVoid*)&tSxmSportsFlashNotificationParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmSportsFlashNotificationParam' in function 'dp_tclAppHmi_SxmSxmSportsFlashNotification::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_SxmSxmSportsFlashNotification::s32SetData(const tBool &tSxmSportsFlashNotificationParam) {
   //init parameter
   (tVoid)memcpy(&tSxmSportsFlashNotification,(tVoid*)&tSxmSportsFlashNotificationParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmSportsFlashNotificationParam' in function 'dp_tclAppHmi_SxmSxmSportsFlashNotification::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSxmSportsFlashNotification::u8GetData(tBool& tSxmSportsFlashNotificationParam) {  
   vUpdate();
   tSxmSportsFlashNotificationParam = tSxmSportsFlashNotification;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSxmSportsFlashNotification::vSetData(tBool &tSxmSportsFlashNotificationParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmSportsFlashNotification,(tVoid*)&tSxmSportsFlashNotificationParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmSportsFlashNotificationParam' in function 'dp_tclAppHmi_SxmSxmSportsFlashNotification::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_SxmSxmSportsFlashNotification::vSetData(const tBool &tSxmSportsFlashNotificationParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmSportsFlashNotification,(tVoid*)&tSxmSportsFlashNotificationParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmSportsFlashNotificationParam' in function 'dp_tclAppHmi_SxmSxmSportsFlashNotification::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_SxmSxmSportsFlashNotification::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSxmSportsFlashNotification::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmSportsFlashNotification", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmSportsFlashNotification::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmSportsFlashNotification", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmSportsFlashNotification::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SxmSportsFlashNotification", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SxmSportsFlashNotification has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SXMSportsFlashTeams"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSXMSportsFlashTeams::dp_tclAppHmi_SxmSXMSportsFlashTeams(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSXMSportsFlashTeams,0,sizeof(HmiAppSxm::SXMSportsFlashFavTeams));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSXMSportsFlashTeams::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SXMSportsFlashTeams",(tS32) 0xe72c6a0f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(HmiAppSxm::SXMSportsFlashFavTeams)) 
      {
         tSXMSportsFlashTeams = *((HmiAppSxm::SXMSportsFlashFavTeams*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSXMSportsFlashTeams::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SXMSportsFlashTeams", (tS32)0xe72c6a0f);
   (tVoid)myDpElem.bFillData((tVoid*)&tSXMSportsFlashTeams, (tU32)sizeof(HmiAppSxm::SXMSportsFlashFavTeams));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSXMSportsFlashTeams::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSXMSportsFlashTeams::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
HmiAppSxm::SXMSportsFlashFavTeams dp_tclAppHmi_SxmSXMSportsFlashTeams::tGetData() {
   vUpdate();
   return tSXMSportsFlashTeams;
};
tS32 dp_tclAppHmi_SxmSXMSportsFlashTeams::s32GetData(HmiAppSxm::SXMSportsFlashFavTeams& tSXMSportsFlashTeamsParam) { 
   vUpdate();
   tSXMSportsFlashTeamsParam = tSXMSportsFlashTeams;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSXMSportsFlashTeams::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SXMSportsFlashTeams", (tS32)0xe72c6a0f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSXMSportsFlashTeams::operator>>(HmiAppSxm::SXMSportsFlashFavTeams& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSXMSportsFlashTeams::operator<<(HmiAppSxm::SXMSportsFlashFavTeams oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSXMSportsFlashTeams::s32SetData(HmiAppSxm::SXMSportsFlashFavTeams &tSXMSportsFlashTeamsParam) {
   //init parameter
   (tVoid)memcpy(&tSXMSportsFlashTeams,(tVoid*)&tSXMSportsFlashTeamsParam, sizeof(HmiAppSxm::SXMSportsFlashFavTeams));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSXMSportsFlashTeamsParam' in function 'dp_tclAppHmi_SxmSXMSportsFlashTeams::vSetData(HmiAppSxm::SXMSportsFlashFavTeams)' could be made const reference
tS32 dp_tclAppHmi_SxmSXMSportsFlashTeams::s32SetData(const HmiAppSxm::SXMSportsFlashFavTeams &tSXMSportsFlashTeamsParam) {
   //init parameter
   (tVoid)memcpy(&tSXMSportsFlashTeams,(tVoid*)&tSXMSportsFlashTeamsParam, sizeof(HmiAppSxm::SXMSportsFlashFavTeams));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSXMSportsFlashTeamsParam' in function 'dp_tclAppHmi_SxmSXMSportsFlashTeams::vSetData(HmiAppSxm::SXMSportsFlashFavTeams)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSXMSportsFlashTeams::u8GetData(HmiAppSxm::SXMSportsFlashFavTeams& tSXMSportsFlashTeamsParam) {  
   vUpdate();
   tSXMSportsFlashTeamsParam = tSXMSportsFlashTeams;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSXMSportsFlashTeams::vSetData(HmiAppSxm::SXMSportsFlashFavTeams &tSXMSportsFlashTeamsParam) { 
   //init parameter
   (tVoid)memcpy(&tSXMSportsFlashTeams,(tVoid*)&tSXMSportsFlashTeamsParam, sizeof(HmiAppSxm::SXMSportsFlashFavTeams));
   vStore();
}//lint !e1746: parameter 'tSXMSportsFlashTeamsParam' in function 'dp_tclAppHmi_SxmSXMSportsFlashTeams::vSetData(HmiAppSxm::SXMSportsFlashFavTeams)' could be made const reference
tVoid dp_tclAppHmi_SxmSXMSportsFlashTeams::vSetData(const HmiAppSxm::SXMSportsFlashFavTeams &tSXMSportsFlashTeamsParam) { 
   //init parameter
   (tVoid)memcpy(&tSXMSportsFlashTeams,(tVoid*)&tSXMSportsFlashTeamsParam, sizeof(HmiAppSxm::SXMSportsFlashFavTeams));
   vStore();
}//lint !e1746: parameter 'tSXMSportsFlashTeamsParam' in function 'dp_tclAppHmi_SxmSXMSportsFlashTeams::vSetData(HmiAppSxm::SXMSportsFlashFavTeams)' could be made const reference
tU8   dp_tclAppHmi_SxmSXMSportsFlashTeams::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSXMSportsFlashTeams::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SXMSportsFlashTeams", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSXMSportsFlashTeams::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SXMSportsFlashTeams", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSXMSportsFlashTeams::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SXMSportsFlashTeams", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SXMSportsFlashTeams has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SxmAudioArtistFavoriteStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSxmAudioArtistFavoriteStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SxmAudioArtistFavoriteStatus",(tS32) 0x8b5c9a91L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSxmAudioArtistFavoriteStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SxmAudioArtistFavoriteStatus", (tS32)0x8b5c9a91L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSxmAudioArtistFavoriteStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::tGetData() {
   vUpdate();
   return tSxmAudioArtistFavoriteStatus;
};
tS32 dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::s32GetData(tBool& tSxmAudioArtistFavoriteStatusParam) { 
   vUpdate();
   tSxmAudioArtistFavoriteStatusParam = tSxmAudioArtistFavoriteStatus;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SxmAudioArtistFavoriteStatus", (tS32)0x8b5c9a91L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::s32SetData(tBool &tSxmAudioArtistFavoriteStatusParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioArtistFavoriteStatus,(tVoid*)&tSxmAudioArtistFavoriteStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioArtistFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::s32SetData(const tBool &tSxmAudioArtistFavoriteStatusParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioArtistFavoriteStatus,(tVoid*)&tSxmAudioArtistFavoriteStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioArtistFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::u8GetData(tBool& tSxmAudioArtistFavoriteStatusParam) {  
   vUpdate();
   tSxmAudioArtistFavoriteStatusParam = tSxmAudioArtistFavoriteStatus;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vSetData(tBool &tSxmAudioArtistFavoriteStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioArtistFavoriteStatus,(tVoid*)&tSxmAudioArtistFavoriteStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmAudioArtistFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vSetData(const tBool &tSxmAudioArtistFavoriteStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioArtistFavoriteStatus,(tVoid*)&tSxmAudioArtistFavoriteStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmAudioArtistFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioArtistFavoriteStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioArtistFavoriteStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SxmAudioArtistFavoriteStatus", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SxmAudioArtistFavoriteStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SxmAudioSongFavoriteStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSxmAudioSongFavoriteStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SxmAudioSongFavoriteStatus",(tS32) 0xe9cec6cdL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tSxmAudioSongFavoriteStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SxmAudioSongFavoriteStatus", (tS32)0xe9cec6cdL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSxmAudioSongFavoriteStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::tGetData() {
   vUpdate();
   return tSxmAudioSongFavoriteStatus;
};
tS32 dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::s32GetData(tBool& tSxmAudioSongFavoriteStatusParam) { 
   vUpdate();
   tSxmAudioSongFavoriteStatusParam = tSxmAudioSongFavoriteStatus;
   return _s32Status;
}
tS32 dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SxmAudioSongFavoriteStatus", (tS32)0xe9cec6cdL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SXM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::s32SetData(tBool &tSxmAudioSongFavoriteStatusParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioSongFavoriteStatus,(tVoid*)&tSxmAudioSongFavoriteStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioSongFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::s32SetData(const tBool &tSxmAudioSongFavoriteStatusParam) {
   //init parameter
   (tVoid)memcpy(&tSxmAudioSongFavoriteStatus,(tVoid*)&tSxmAudioSongFavoriteStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSxmAudioSongFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::u8GetData(tBool& tSxmAudioSongFavoriteStatusParam) {  
   vUpdate();
   tSxmAudioSongFavoriteStatusParam = tSxmAudioSongFavoriteStatus;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vSetData(tBool &tSxmAudioSongFavoriteStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioSongFavoriteStatus,(tVoid*)&tSxmAudioSongFavoriteStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmAudioSongFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vSetData(const tBool &tSxmAudioSongFavoriteStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tSxmAudioSongFavoriteStatus,(tVoid*)&tSxmAudioSongFavoriteStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tSxmAudioSongFavoriteStatusParam' in function 'dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioSongFavoriteStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SXM, "SxmAudioSongFavoriteStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SxmAudioSongFavoriteStatus", DP_U32_POOL_ID_APPHMI_SXM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SXM);
   }
   else
   {
      fprintf(stdout,"Element SxmAudioSongFavoriteStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
