
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_Tuner.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DPShowTAinApps"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerDPShowTAinApps::dp_tclAppHmi_TunerDPShowTAinApps(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDPShowTAinApps,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerDPShowTAinApps::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DPShowTAinApps",(tS32) 0x1e122bbd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDPShowTAinApps = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerDPShowTAinApps::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DPShowTAinApps", (tS32)0x1e122bbd);
   (tVoid)myDpElem.bFillData((tVoid*)&tDPShowTAinApps, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerDPShowTAinApps::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerDPShowTAinApps::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_TunerDPShowTAinApps::tGetData() {
   vUpdate();
   return tDPShowTAinApps;
};
tS32 dp_tclAppHmi_TunerDPShowTAinApps::s32GetData(tU8& tDPShowTAinAppsParam) { 
   vUpdate();
   tDPShowTAinAppsParam = tDPShowTAinApps;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerDPShowTAinApps::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DPShowTAinApps", (tS32)0x1e122bbd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerDPShowTAinApps::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerDPShowTAinApps::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerDPShowTAinApps::s32SetData(tU8 &tDPShowTAinAppsParam) {
   //init parameter
   (tVoid)memcpy(&tDPShowTAinApps,(tVoid*)&tDPShowTAinAppsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPShowTAinAppsParam' in function 'dp_tclAppHmi_TunerDPShowTAinApps::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_TunerDPShowTAinApps::s32SetData(const tU8 &tDPShowTAinAppsParam) {
   //init parameter
   (tVoid)memcpy(&tDPShowTAinApps,(tVoid*)&tDPShowTAinAppsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPShowTAinAppsParam' in function 'dp_tclAppHmi_TunerDPShowTAinApps::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerDPShowTAinApps::u8GetData(tU8& tDPShowTAinAppsParam) {  
   vUpdate();
   tDPShowTAinAppsParam = tDPShowTAinApps;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerDPShowTAinApps::vSetData(tU8 &tDPShowTAinAppsParam) { 
   //init parameter
   (tVoid)memcpy(&tDPShowTAinApps,(tVoid*)&tDPShowTAinAppsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDPShowTAinAppsParam' in function 'dp_tclAppHmi_TunerDPShowTAinApps::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_TunerDPShowTAinApps::vSetData(const tU8 &tDPShowTAinAppsParam) { 
   //init parameter
   (tVoid)memcpy(&tDPShowTAinApps,(tVoid*)&tDPShowTAinAppsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDPShowTAinAppsParam' in function 'dp_tclAppHmi_TunerDPShowTAinApps::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_TunerDPShowTAinApps::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerDPShowTAinApps::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DPShowTAinApps", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDPShowTAinApps::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DPShowTAinApps", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDPShowTAinApps::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DPShowTAinApps", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element DPShowTAinApps has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DPRadiotext"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerDPRadiotext::dp_tclAppHmi_TunerDPRadiotext(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDPRadiotext,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerDPRadiotext::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DPRadiotext",(tS32) 0x335f8b60);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDPRadiotext = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerDPRadiotext::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DPRadiotext", (tS32)0x335f8b60);
   (tVoid)myDpElem.bFillData((tVoid*)&tDPRadiotext, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerDPRadiotext::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerDPRadiotext::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_TunerDPRadiotext::tGetData() {
   vUpdate();
   return tDPRadiotext;
};
tS32 dp_tclAppHmi_TunerDPRadiotext::s32GetData(tU8& tDPRadiotextParam) { 
   vUpdate();
   tDPRadiotextParam = tDPRadiotext;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerDPRadiotext::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DPRadiotext", (tS32)0x335f8b60);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerDPRadiotext::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerDPRadiotext::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerDPRadiotext::s32SetData(tU8 &tDPRadiotextParam) {
   //init parameter
   (tVoid)memcpy(&tDPRadiotext,(tVoid*)&tDPRadiotextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPRadiotextParam' in function 'dp_tclAppHmi_TunerDPRadiotext::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_TunerDPRadiotext::s32SetData(const tU8 &tDPRadiotextParam) {
   //init parameter
   (tVoid)memcpy(&tDPRadiotext,(tVoid*)&tDPRadiotextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPRadiotextParam' in function 'dp_tclAppHmi_TunerDPRadiotext::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerDPRadiotext::u8GetData(tU8& tDPRadiotextParam) {  
   vUpdate();
   tDPRadiotextParam = tDPRadiotext;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerDPRadiotext::vSetData(tU8 &tDPRadiotextParam) { 
   //init parameter
   (tVoid)memcpy(&tDPRadiotext,(tVoid*)&tDPRadiotextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDPRadiotextParam' in function 'dp_tclAppHmi_TunerDPRadiotext::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_TunerDPRadiotext::vSetData(const tU8 &tDPRadiotextParam) { 
   //init parameter
   (tVoid)memcpy(&tDPRadiotext,(tVoid*)&tDPRadiotextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDPRadiotextParam' in function 'dp_tclAppHmi_TunerDPRadiotext::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_TunerDPRadiotext::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerDPRadiotext::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DPRadiotext", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDPRadiotext::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DPRadiotext", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDPRadiotext::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DPRadiotext", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element DPRadiotext has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Ptymask"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerPtymask::dp_tclAppHmi_TunerPtymask(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPtymask,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerPtymask::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Ptymask",(tS32) 0x1a0399);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tPtymask = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerPtymask::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Ptymask", (tS32)0x1a0399);
   (tVoid)myDpElem.bFillData((tVoid*)&tPtymask, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerPtymask::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerPtymask::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_TunerPtymask::tGetData() {
   vUpdate();
   return tPtymask;
};
tS32 dp_tclAppHmi_TunerPtymask::s32GetData(tU32& tPtymaskParam) { 
   vUpdate();
   tPtymaskParam = tPtymask;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerPtymask::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Ptymask", (tS32)0x1a0399);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerPtymask::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerPtymask::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerPtymask::s32SetData(tU32 &tPtymaskParam) {
   //init parameter
   (tVoid)memcpy(&tPtymask,(tVoid*)&tPtymaskParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPtymaskParam' in function 'dp_tclAppHmi_TunerPtymask::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_TunerPtymask::s32SetData(const tU32 &tPtymaskParam) {
   //init parameter
   (tVoid)memcpy(&tPtymask,(tVoid*)&tPtymaskParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPtymaskParam' in function 'dp_tclAppHmi_TunerPtymask::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerPtymask::u8GetData(tU32& tPtymaskParam) {  
   vUpdate();
   tPtymaskParam = tPtymask;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerPtymask::vSetData(tU32 &tPtymaskParam) { 
   //init parameter
   (tVoid)memcpy(&tPtymask,(tVoid*)&tPtymaskParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPtymaskParam' in function 'dp_tclAppHmi_TunerPtymask::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_TunerPtymask::vSetData(const tU32 &tPtymaskParam) { 
   //init parameter
   (tVoid)memcpy(&tPtymask,(tVoid*)&tPtymaskParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPtymaskParam' in function 'dp_tclAppHmi_TunerPtymask::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_TunerPtymask::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerPtymask::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "Ptymask", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerPtymask::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "Ptymask", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerPtymask::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Ptymask", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element Ptymask has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAB_DynamicText"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerDAB_DynamicText::dp_tclAppHmi_TunerDAB_DynamicText(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAB_DynamicText,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerDAB_DynamicText::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAB_DynamicText",(tS32) 0x2958d52c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAB_DynamicText = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerDAB_DynamicText::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAB_DynamicText", (tS32)0x2958d52c);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAB_DynamicText, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerDAB_DynamicText::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerDAB_DynamicText::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_TunerDAB_DynamicText::tGetData() {
   vUpdate();
   return tDAB_DynamicText;
};
tS32 dp_tclAppHmi_TunerDAB_DynamicText::s32GetData(tU8& tDAB_DynamicTextParam) { 
   vUpdate();
   tDAB_DynamicTextParam = tDAB_DynamicText;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerDAB_DynamicText::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAB_DynamicText", (tS32)0x2958d52c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerDAB_DynamicText::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerDAB_DynamicText::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerDAB_DynamicText::s32SetData(tU8 &tDAB_DynamicTextParam) {
   //init parameter
   (tVoid)memcpy(&tDAB_DynamicText,(tVoid*)&tDAB_DynamicTextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAB_DynamicTextParam' in function 'dp_tclAppHmi_TunerDAB_DynamicText::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_TunerDAB_DynamicText::s32SetData(const tU8 &tDAB_DynamicTextParam) {
   //init parameter
   (tVoid)memcpy(&tDAB_DynamicText,(tVoid*)&tDAB_DynamicTextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAB_DynamicTextParam' in function 'dp_tclAppHmi_TunerDAB_DynamicText::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerDAB_DynamicText::u8GetData(tU8& tDAB_DynamicTextParam) {  
   vUpdate();
   tDAB_DynamicTextParam = tDAB_DynamicText;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerDAB_DynamicText::vSetData(tU8 &tDAB_DynamicTextParam) { 
   //init parameter
   (tVoid)memcpy(&tDAB_DynamicText,(tVoid*)&tDAB_DynamicTextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAB_DynamicTextParam' in function 'dp_tclAppHmi_TunerDAB_DynamicText::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_TunerDAB_DynamicText::vSetData(const tU8 &tDAB_DynamicTextParam) { 
   //init parameter
   (tVoid)memcpy(&tDAB_DynamicText,(tVoid*)&tDAB_DynamicTextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAB_DynamicTextParam' in function 'dp_tclAppHmi_TunerDAB_DynamicText::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_TunerDAB_DynamicText::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerDAB_DynamicText::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DAB_DynamicText", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDAB_DynamicText::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DAB_DynamicText", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDAB_DynamicText::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAB_DynamicText", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element DAB_DynamicText has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAB_FMFollowing"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerDAB_FMFollowing::dp_tclAppHmi_TunerDAB_FMFollowing(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAB_FMFollowing,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerDAB_FMFollowing::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAB_FMFollowing",(tS32) 0x2485e92e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAB_FMFollowing = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerDAB_FMFollowing::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAB_FMFollowing", (tS32)0x2485e92e);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAB_FMFollowing, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerDAB_FMFollowing::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerDAB_FMFollowing::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_TunerDAB_FMFollowing::tGetData() {
   vUpdate();
   return tDAB_FMFollowing;
};
tS32 dp_tclAppHmi_TunerDAB_FMFollowing::s32GetData(tU8& tDAB_FMFollowingParam) { 
   vUpdate();
   tDAB_FMFollowingParam = tDAB_FMFollowing;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerDAB_FMFollowing::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAB_FMFollowing", (tS32)0x2485e92e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerDAB_FMFollowing::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerDAB_FMFollowing::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerDAB_FMFollowing::s32SetData(tU8 &tDAB_FMFollowingParam) {
   //init parameter
   (tVoid)memcpy(&tDAB_FMFollowing,(tVoid*)&tDAB_FMFollowingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAB_FMFollowingParam' in function 'dp_tclAppHmi_TunerDAB_FMFollowing::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_TunerDAB_FMFollowing::s32SetData(const tU8 &tDAB_FMFollowingParam) {
   //init parameter
   (tVoid)memcpy(&tDAB_FMFollowing,(tVoid*)&tDAB_FMFollowingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAB_FMFollowingParam' in function 'dp_tclAppHmi_TunerDAB_FMFollowing::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerDAB_FMFollowing::u8GetData(tU8& tDAB_FMFollowingParam) {  
   vUpdate();
   tDAB_FMFollowingParam = tDAB_FMFollowing;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerDAB_FMFollowing::vSetData(tU8 &tDAB_FMFollowingParam) { 
   //init parameter
   (tVoid)memcpy(&tDAB_FMFollowing,(tVoid*)&tDAB_FMFollowingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAB_FMFollowingParam' in function 'dp_tclAppHmi_TunerDAB_FMFollowing::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_TunerDAB_FMFollowing::vSetData(const tU8 &tDAB_FMFollowingParam) { 
   //init parameter
   (tVoid)memcpy(&tDAB_FMFollowing,(tVoid*)&tDAB_FMFollowingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAB_FMFollowingParam' in function 'dp_tclAppHmi_TunerDAB_FMFollowing::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_TunerDAB_FMFollowing::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerDAB_FMFollowing::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DAB_FMFollowing", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDAB_FMFollowing::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DAB_FMFollowing", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDAB_FMFollowing::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAB_FMFollowing", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element DAB_FMFollowing has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageDP"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerLanguageDP::dp_tclAppHmi_TunerLanguageDP(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageDP,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerLanguageDP::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageDP",(tS32) 0xbbd9308);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageDP = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerLanguageDP::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageDP", (tS32)0xbbd9308);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageDP, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerLanguageDP::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerLanguageDP::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_TunerLanguageDP::tGetData() {
   vUpdate();
   return tLanguageDP;
};
tS32 dp_tclAppHmi_TunerLanguageDP::s32GetData(tU8& tLanguageDPParam) { 
   vUpdate();
   tLanguageDPParam = tLanguageDP;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerLanguageDP::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageDP", (tS32)0xbbd9308);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerLanguageDP::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerLanguageDP::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerLanguageDP::s32SetData(tU8 &tLanguageDPParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageDP,(tVoid*)&tLanguageDPParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageDPParam' in function 'dp_tclAppHmi_TunerLanguageDP::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_TunerLanguageDP::s32SetData(const tU8 &tLanguageDPParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageDP,(tVoid*)&tLanguageDPParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageDPParam' in function 'dp_tclAppHmi_TunerLanguageDP::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerLanguageDP::u8GetData(tU8& tLanguageDPParam) {  
   vUpdate();
   tLanguageDPParam = tLanguageDP;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerLanguageDP::vSetData(tU8 &tLanguageDPParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageDP,(tVoid*)&tLanguageDPParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageDPParam' in function 'dp_tclAppHmi_TunerLanguageDP::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_TunerLanguageDP::vSetData(const tU8 &tLanguageDPParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageDP,(tVoid*)&tLanguageDPParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageDPParam' in function 'dp_tclAppHmi_TunerLanguageDP::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_TunerLanguageDP::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerLanguageDP::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "LanguageDP", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerLanguageDP::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "LanguageDP", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerLanguageDP::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageDP", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element LanguageDP has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAB_DABLinking"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_TunerDAB_DABLinking::dp_tclAppHmi_TunerDAB_DABLinking(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAB_DABLinking,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_TunerDAB_DABLinking::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAB_DABLinking",(tS32) 0x6bd9a19);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAB_DABLinking = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_TunerDAB_DABLinking::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAB_DABLinking", (tS32)0x6bd9a19);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAB_DABLinking, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_TunerDAB_DABLinking::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_TunerDAB_DABLinking::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_TunerDAB_DABLinking::tGetData() {
   vUpdate();
   return tDAB_DABLinking;
};
tS32 dp_tclAppHmi_TunerDAB_DABLinking::s32GetData(tU8& tDAB_DABLinkingParam) { 
   vUpdate();
   tDAB_DABLinkingParam = tDAB_DABLinking;
   return _s32Status;
}
tS32 dp_tclAppHmi_TunerDAB_DABLinking::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAB_DABLinking", (tS32)0x6bd9a19);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_TUNER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_TunerDAB_DABLinking::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_TunerDAB_DABLinking::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_TunerDAB_DABLinking::s32SetData(tU8 &tDAB_DABLinkingParam) {
   //init parameter
   (tVoid)memcpy(&tDAB_DABLinking,(tVoid*)&tDAB_DABLinkingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAB_DABLinkingParam' in function 'dp_tclAppHmi_TunerDAB_DABLinking::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_TunerDAB_DABLinking::s32SetData(const tU8 &tDAB_DABLinkingParam) {
   //init parameter
   (tVoid)memcpy(&tDAB_DABLinking,(tVoid*)&tDAB_DABLinkingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAB_DABLinkingParam' in function 'dp_tclAppHmi_TunerDAB_DABLinking::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_TunerDAB_DABLinking::u8GetData(tU8& tDAB_DABLinkingParam) {  
   vUpdate();
   tDAB_DABLinkingParam = tDAB_DABLinking;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_TunerDAB_DABLinking::vSetData(tU8 &tDAB_DABLinkingParam) { 
   //init parameter
   (tVoid)memcpy(&tDAB_DABLinking,(tVoid*)&tDAB_DABLinkingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAB_DABLinkingParam' in function 'dp_tclAppHmi_TunerDAB_DABLinking::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_TunerDAB_DABLinking::vSetData(const tU8 &tDAB_DABLinkingParam) { 
   //init parameter
   (tVoid)memcpy(&tDAB_DABLinking,(tVoid*)&tDAB_DABLinkingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAB_DABLinkingParam' in function 'dp_tclAppHmi_TunerDAB_DABLinking::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_TunerDAB_DABLinking::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_TunerDAB_DABLinking::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DAB_DABLinking", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDAB_DABLinking::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_TUNER, "DAB_DABLinking", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_TunerDAB_DABLinking::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAB_DABLinking", DP_U32_POOL_ID_APPHMI_TUNER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_TUNER);
   }
   else
   {
      fprintf(stdout,"Element DAB_DABLinking has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
