#ifndef _DP_FI_VEHFUNC_H
#define _DP_FI_VEHFUNC_H

extern tVoid vInitVehFunc(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_VEHICLE_FUNCTION_S_IMPORT_INTERFACE_DP 
#include "../../di_cfc/components/FC_VehicleFunctions/interfaces/vehfunc_dp_if.h"
//lint +e750



#define SYSTEM_S_IMPORT_INTERFACE_DEQUE
#include "stl_pif.h"


class dp_tclVehFuncEcoScoreHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TEcoScoreHistory> TListEcoScoreHistory;
    #else
    typedef std::deque<TEcoScoreHistory> TListEcoScoreHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListEcoScoreHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncEcoScoreHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncEcoScoreHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TEcoScoreHistory& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TEcoScoreHistory &tElem);
    tVoid vPushBack(const TEcoScoreHistory &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncHEVHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<THEVConsumptionHistory> TListHEVHistory;
    #else
    typedef std::deque<THEVConsumptionHistory> TListHEVHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListHEVHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncHEVHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncHEVHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, THEVConsumptionHistory& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(THEVConsumptionHistory &tElem);
    tVoid vPushBack(const THEVConsumptionHistory &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncMexRestartMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMexRestartMode;
   
public:
   dp_tclVehFuncMexRestartMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncMexRestartMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMexRestartModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMexRestartModeParam);
   tS32  s32SetData(const tU8 &tMexRestartModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMexRestartModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMexRestartModeParam);
   tVoid vSetData(const tU8& tMexRestartModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncVehicleMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVehicleMode;
   
public:
   dp_tclVehFuncVehicleMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncVehicleMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVehicleModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVehicleModeParam);
   tS32  s32SetData(const tU8 &tVehicleModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVehicleModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVehicleModeParam);
   tVoid vSetData(const tU8& tVehicleModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncEcoTripData{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TEcoTripData tEcoTripData;
   
public:
   dp_tclVehFuncEcoTripData(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncEcoTripData() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TEcoTripData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TEcoTripData& tEcoTripDataParam);
   tVoid operator>>(TEcoTripData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TEcoTripData &tEcoTripDataParam);
   tS32  s32SetData(const TEcoTripData &tEcoTripDataParam);
   tVoid operator<<(TEcoTripData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TEcoTripData& tEcoTripDataParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TEcoTripData& tEcoTripDataParam);
   tVoid vSetData(const TEcoTripData& tEcoTripDataParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncDrivingEcoData{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TEcoData tDrivingEcoData;
   
public:
   dp_tclVehFuncDrivingEcoData(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncDrivingEcoData() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TEcoData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TEcoData& tDrivingEcoDataParam);
   tVoid operator>>(TEcoData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TEcoData &tDrivingEcoDataParam);
   tS32  s32SetData(const TEcoData &tDrivingEcoDataParam);
   tVoid operator<<(TEcoData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TEcoData& tDrivingEcoDataParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TEcoData& tDrivingEcoDataParam);
   tVoid vSetData(const TEcoData& tDrivingEcoDataParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncDrivingEcoHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TDrivingEcoHistory> TListDrivingEcoHistory;
    #else
    typedef std::deque<TDrivingEcoHistory> TListDrivingEcoHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListDrivingEcoHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncDrivingEcoHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncDrivingEcoHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TDrivingEcoHistory &tElem);
    tVoid vPushBack(const TDrivingEcoHistory &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncDrivingEcoTripHistory_Home_Work{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TDrivingEcoHistory> TListDrivingEcoTripHistory_Home_Work;
    #else
    typedef std::deque<TDrivingEcoHistory> TListDrivingEcoTripHistory_Home_Work;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListDrivingEcoTripHistory_Home_Work _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncDrivingEcoTripHistory_Home_Work(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncDrivingEcoTripHistory_Home_Work() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TDrivingEcoHistory &tElem);
    tVoid vPushBack(const TDrivingEcoHistory &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncDrivingEcoTripHistory_Journey{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TDrivingEcoHistory> TListDrivingEcoTripHistory_Journey;
    #else
    typedef std::deque<TDrivingEcoHistory> TListDrivingEcoTripHistory_Journey;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListDrivingEcoTripHistory_Journey _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncDrivingEcoTripHistory_Journey(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncDrivingEcoTripHistory_Journey() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TDrivingEcoHistory &tElem);
    tVoid vPushBack(const TDrivingEcoHistory &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncDrivingEcoTripHistory_Personal{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TDrivingEcoHistory> TListDrivingEcoTripHistory_Personal;
    #else
    typedef std::deque<TDrivingEcoHistory> TListDrivingEcoTripHistory_Personal;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListDrivingEcoTripHistory_Personal _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncDrivingEcoTripHistory_Personal(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncDrivingEcoTripHistory_Personal() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TDrivingEcoHistory &tElem);
    tVoid vPushBack(const TDrivingEcoHistory &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncEcoChallengeData_Home_Work{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TEcoChallengeScreenData tEcoChallengeData_Home_Work;
   
public:
   dp_tclVehFuncEcoChallengeData_Home_Work(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncEcoChallengeData_Home_Work() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TEcoChallengeScreenData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TEcoChallengeScreenData& tEcoChallengeData_Home_WorkParam);
   tVoid operator>>(TEcoChallengeScreenData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TEcoChallengeScreenData &tEcoChallengeData_Home_WorkParam);
   tS32  s32SetData(const TEcoChallengeScreenData &tEcoChallengeData_Home_WorkParam);
   tVoid operator<<(TEcoChallengeScreenData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TEcoChallengeScreenData& tEcoChallengeData_Home_WorkParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TEcoChallengeScreenData& tEcoChallengeData_Home_WorkParam);
   tVoid vSetData(const TEcoChallengeScreenData& tEcoChallengeData_Home_WorkParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncEcoChallengeData_Journey{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TEcoChallengeScreenData tEcoChallengeData_Journey;
   
public:
   dp_tclVehFuncEcoChallengeData_Journey(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncEcoChallengeData_Journey() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TEcoChallengeScreenData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TEcoChallengeScreenData& tEcoChallengeData_JourneyParam);
   tVoid operator>>(TEcoChallengeScreenData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TEcoChallengeScreenData &tEcoChallengeData_JourneyParam);
   tS32  s32SetData(const TEcoChallengeScreenData &tEcoChallengeData_JourneyParam);
   tVoid operator<<(TEcoChallengeScreenData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TEcoChallengeScreenData& tEcoChallengeData_JourneyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TEcoChallengeScreenData& tEcoChallengeData_JourneyParam);
   tVoid vSetData(const TEcoChallengeScreenData& tEcoChallengeData_JourneyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncEcoChallengeData_Personal{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TEcoChallengeScreenData tEcoChallengeData_Personal;
   
public:
   dp_tclVehFuncEcoChallengeData_Personal(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncEcoChallengeData_Personal() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TEcoChallengeScreenData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TEcoChallengeScreenData& tEcoChallengeData_PersonalParam);
   tVoid operator>>(TEcoChallengeScreenData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TEcoChallengeScreenData &tEcoChallengeData_PersonalParam);
   tS32  s32SetData(const TEcoChallengeScreenData &tEcoChallengeData_PersonalParam);
   tVoid operator<<(TEcoChallengeScreenData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TEcoChallengeScreenData& tEcoChallengeData_PersonalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TEcoChallengeScreenData& tEcoChallengeData_PersonalParam);
   tVoid vSetData(const TEcoChallengeScreenData& tEcoChallengeData_PersonalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncLast_EcoTrip_Reset_Time{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TLastResetTime tLast_EcoTrip_Reset_Time;
   
public:
   dp_tclVehFuncLast_EcoTrip_Reset_Time(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncLast_EcoTrip_Reset_Time() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TLastResetTime tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TLastResetTime& tLast_EcoTrip_Reset_TimeParam);
   tVoid operator>>(TLastResetTime& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TLastResetTime &tLast_EcoTrip_Reset_TimeParam);
   tS32  s32SetData(const TLastResetTime &tLast_EcoTrip_Reset_TimeParam);
   tVoid operator<<(TLastResetTime oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TLastResetTime& tLast_EcoTrip_Reset_TimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TLastResetTime& tLast_EcoTrip_Reset_TimeParam);
   tVoid vSetData(const TLastResetTime& tLast_EcoTrip_Reset_TimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncMainInfoData_OilFilter{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TMainInfoData tMainInfoData_OilFilter;
   
public:
   dp_tclVehFuncMainInfoData_OilFilter(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncMainInfoData_OilFilter() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TMainInfoData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TMainInfoData& tMainInfoData_OilFilterParam);
   tVoid operator>>(TMainInfoData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TMainInfoData &tMainInfoData_OilFilterParam);
   tS32  s32SetData(const TMainInfoData &tMainInfoData_OilFilterParam);
   tVoid operator<<(TMainInfoData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TMainInfoData& tMainInfoData_OilFilterParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TMainInfoData& tMainInfoData_OilFilterParam);
   tVoid vSetData(const TMainInfoData& tMainInfoData_OilFilterParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncMainInfoData_Tire{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TMainInfoData tMainInfoData_Tire;
   
public:
   dp_tclVehFuncMainInfoData_Tire(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncMainInfoData_Tire() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TMainInfoData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TMainInfoData& tMainInfoData_TireParam);
   tVoid operator>>(TMainInfoData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TMainInfoData &tMainInfoData_TireParam);
   tS32  s32SetData(const TMainInfoData &tMainInfoData_TireParam);
   tVoid operator<<(TMainInfoData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TMainInfoData& tMainInfoData_TireParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TMainInfoData& tMainInfoData_TireParam);
   tVoid vSetData(const TMainInfoData& tMainInfoData_TireParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncMainInfoData_User{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TMainInfoData tMainInfoData_User;
   
public:
   dp_tclVehFuncMainInfoData_User(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncMainInfoData_User() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TMainInfoData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TMainInfoData& tMainInfoData_UserParam);
   tVoid operator>>(TMainInfoData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TMainInfoData &tMainInfoData_UserParam);
   tS32  s32SetData(const TMainInfoData &tMainInfoData_UserParam);
   tVoid operator<<(TMainInfoData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TMainInfoData& tMainInfoData_UserParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TMainInfoData& tMainInfoData_UserParam);
   tVoid vSetData(const TMainInfoData& tMainInfoData_UserParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncMainInfoData_Mileage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tMainInfoData_Mileage;
   
public:
   dp_tclVehFuncMainInfoData_Mileage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncMainInfoData_Mileage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tMainInfoData_MileageParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tMainInfoData_MileageParam);
   tS32  s32SetData(const tU32 &tMainInfoData_MileageParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tMainInfoData_MileageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tMainInfoData_MileageParam);
   tVoid vSetData(const tU32& tMainInfoData_MileageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncMainInfoResetFlag{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tMainInfoResetFlag;
   
public:
   dp_tclVehFuncMainInfoResetFlag(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncMainInfoResetFlag() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tMainInfoResetFlagParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tMainInfoResetFlagParam);
   tS32  s32SetData(const tBool &tMainInfoResetFlagParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tMainInfoResetFlagParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tMainInfoResetFlagParam);
   tVoid vSetData(const tBool& tMainInfoResetFlagParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncClinoMeter_AngleValues{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TClinometerAngleData tClinoMeter_AngleValues;
   
public:
   dp_tclVehFuncClinoMeter_AngleValues(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncClinoMeter_AngleValues() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TClinometerAngleData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TClinometerAngleData& tClinoMeter_AngleValuesParam);
   tVoid operator>>(TClinometerAngleData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TClinometerAngleData &tClinoMeter_AngleValuesParam);
   tS32  s32SetData(const TClinometerAngleData &tClinoMeter_AngleValuesParam);
   tVoid operator<<(TClinometerAngleData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TClinometerAngleData& tClinoMeter_AngleValuesParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TClinometerAngleData& tClinoMeter_AngleValuesParam);
   tVoid vSetData(const TClinometerAngleData& tClinoMeter_AngleValuesParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncDriverAssistMemDisState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDriverAssistMemDisState tDriverAssistMemDisState;
   
public:
   dp_tclVehFuncDriverAssistMemDisState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncDriverAssistMemDisState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDriverAssistMemDisState tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDriverAssistMemDisState& tDriverAssistMemDisStateParam);
   tVoid operator>>(TDriverAssistMemDisState& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDriverAssistMemDisState &tDriverAssistMemDisStateParam);
   tS32  s32SetData(const TDriverAssistMemDisState &tDriverAssistMemDisStateParam);
   tVoid operator<<(TDriverAssistMemDisState oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDriverAssistMemDisState& tDriverAssistMemDisStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDriverAssistMemDisState& tDriverAssistMemDisStateParam);
   tVoid vSetData(const TDriverAssistMemDisState& tDriverAssistMemDisStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncFuelConsumptionAverage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tFuelConsumptionAverage;
   
public:
   dp_tclVehFuncFuelConsumptionAverage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncFuelConsumptionAverage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tFuelConsumptionAverageParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tFuelConsumptionAverageParam);
   tS32  s32SetData(const tU32 &tFuelConsumptionAverageParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tFuelConsumptionAverageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tFuelConsumptionAverageParam);
   tVoid vSetData(const tU32& tFuelConsumptionAverageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncConsumptionHistory{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TVehFuncConsumption> TListConsumptionHistory;
    #else
    typedef std::deque<TVehFuncConsumption> TListConsumptionHistory;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListConsumptionHistory _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncConsumptionHistory(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncConsumptionHistory() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TVehFuncConsumption& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TVehFuncConsumption &tElem);
    tVoid vPushBack(const TVehFuncConsumption &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncDistance_Without_Acc_Current_Trip{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDistance_Without_Acc_Current_Trip;
   
public:
   dp_tclVehFuncDistance_Without_Acc_Current_Trip(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncDistance_Without_Acc_Current_Trip() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDistance_Without_Acc_Current_TripParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDistance_Without_Acc_Current_TripParam);
   tS32  s32SetData(const tU8 &tDistance_Without_Acc_Current_TripParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDistance_Without_Acc_Current_TripParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDistance_Without_Acc_Current_TripParam);
   tVoid vSetData(const tU8& tDistance_Without_Acc_Current_TripParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncDistance_Without_Acc_History{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TDistance_WO_Acc_History> TListDistance_Without_Acc_History;
    #else
    typedef std::deque<TDistance_WO_Acc_History> TListDistance_Without_Acc_History;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListDistance_Without_Acc_History _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclVehFuncDistance_Without_Acc_History(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclVehFuncDistance_Without_Acc_History() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TDistance_WO_Acc_History& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TDistance_WO_Acc_History &tElem);
    tVoid vPushBack(const TDistance_WO_Acc_History &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclVehFuncEV_CatalogBatteryCharge{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tEV_CatalogBatteryCharge;
   
public:
   dp_tclVehFuncEV_CatalogBatteryCharge(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncEV_CatalogBatteryCharge() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tEV_CatalogBatteryChargeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tEV_CatalogBatteryChargeParam);
   tS32  s32SetData(const tU16 &tEV_CatalogBatteryChargeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tEV_CatalogBatteryChargeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tEV_CatalogBatteryChargeParam);
   tVoid vSetData(const tU16& tEV_CatalogBatteryChargeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingResetActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingResetActivation;
   
public:
   dp_tclVehFuncSettingResetActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingResetActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingResetActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingResetActivationParam);
   tS32  s32SetData(const tU8 &tSettingResetActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingResetActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingResetActivationParam);
   tVoid vSetData(const tU8& tSettingResetActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingADB{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingADB;
   
public:
   dp_tclVehFuncSettingADB(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingADB() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingADBParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingADBParam);
   tS32  s32SetData(const tU8 &tSettingADBParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingADBParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingADBParam);
   tVoid vSetData(const tU8& tSettingADBParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingDrivingSide{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDrivingSide;
   
public:
   dp_tclVehFuncSettingDrivingSide(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingDrivingSide() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDrivingSideParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDrivingSideParam);
   tS32  s32SetData(const tU8 &tSettingDrivingSideParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDrivingSideParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDrivingSideParam);
   tVoid vSetData(const tU8& tSettingDrivingSideParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingRearWiper{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingRearWiper;
   
public:
   dp_tclVehFuncSettingRearWiper(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingRearWiper() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingRearWiperParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingRearWiperParam);
   tS32  s32SetData(const tU8 &tSettingRearWiperParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingRearWiperParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingRearWiperParam);
   tVoid vSetData(const tU8& tSettingRearWiperParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAutoRelock{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAutoRelock;
   
public:
   dp_tclVehFuncSettingAutoRelock(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAutoRelock() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAutoRelockParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAutoRelockParam);
   tS32  s32SetData(const tU8 &tSettingAutoRelockParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAutoRelockParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAutoRelockParam);
   tVoid vSetData(const tU8& tSettingAutoRelockParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingIkeyAccess{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingIkeyAccess;
   
public:
   dp_tclVehFuncSettingIkeyAccess(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingIkeyAccess() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingIkeyAccessParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingIkeyAccessParam);
   tS32  s32SetData(const tU8 &tSettingIkeyAccessParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingIkeyAccessParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingIkeyAccessParam);
   tVoid vSetData(const tU8& tSettingIkeyAccessParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSingleDoorOpening{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSingleDoorOpening;
   
public:
   dp_tclVehFuncSettingSingleDoorOpening(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSingleDoorOpening() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSingleDoorOpeningParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSingleDoorOpeningParam);
   tS32  s32SetData(const tU8 &tSettingSingleDoorOpeningParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSingleDoorOpeningParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSingleDoorOpeningParam);
   tVoid vSetData(const tU8& tSettingSingleDoorOpeningParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingStorageFormat{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingStorageFormat;
   
public:
   dp_tclVehFuncSettingStorageFormat(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingStorageFormat() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingStorageFormatParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingStorageFormatParam);
   tS32  s32SetData(const tU8 &tSettingStorageFormatParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingStorageFormatParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingStorageFormatParam);
   tVoid vSetData(const tU8& tSettingStorageFormatParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingDayIntensity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingDayIntensity;
   
public:
   dp_tclVehFuncSettingAmbientLightingDayIntensity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingDayIntensity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingDayIntensityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingDayIntensityParam);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingDayIntensityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingDayIntensityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingDayIntensityParam);
   tVoid vSetData(const tU8& tSettingAmbientLightingDayIntensityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingNightIntensity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingNightIntensity;
   
public:
   dp_tclVehFuncSettingAmbientLightingNightIntensity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingNightIntensity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingNightIntensityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingNightIntensityParam);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingNightIntensityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingNightIntensityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingNightIntensityParam);
   tVoid vSetData(const tU8& tSettingAmbientLightingNightIntensityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingArea1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingArea1;
   
public:
   dp_tclVehFuncSettingAmbientLightingArea1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingArea1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingArea1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingArea1Param);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingArea1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingArea1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingArea1Param);
   tVoid vSetData(const tU8& tSettingAmbientLightingArea1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingArea2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingArea2;
   
public:
   dp_tclVehFuncSettingAmbientLightingArea2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingArea2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingArea2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingArea2Param);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingArea2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingArea2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingArea2Param);
   tVoid vSetData(const tU8& tSettingAmbientLightingArea2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingArea3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingArea3;
   
public:
   dp_tclVehFuncSettingAmbientLightingArea3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingArea3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingArea3Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingArea3Param);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingArea3Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingArea3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingArea3Param);
   tVoid vSetData(const tU8& tSettingAmbientLightingArea3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingPattern{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingPattern;
   
public:
   dp_tclVehFuncSettingAmbientLightingPattern(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingPattern() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingPatternParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingPatternParam);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingPatternParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingPatternParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingPatternParam);
   tVoid vSetData(const tU8& tSettingAmbientLightingPatternParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingActivation;
   
public:
   dp_tclVehFuncSettingAmbientLightingActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingActivationParam);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingActivationParam);
   tVoid vSetData(const tU8& tSettingAmbientLightingActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAmbientLightingColor{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAmbientLightingColor;
   
public:
   dp_tclVehFuncSettingAmbientLightingColor(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAmbientLightingColor() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAmbientLightingColorParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAmbientLightingColorParam);
   tS32  s32SetData(const tU8 &tSettingAmbientLightingColorParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAmbientLightingColorParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAmbientLightingColorParam);
   tVoid vSetData(const tU8& tSettingAmbientLightingColorParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingClusterSkin{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingClusterSkin;
   
public:
   dp_tclVehFuncSettingClusterSkin(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingClusterSkin() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingClusterSkinParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingClusterSkinParam);
   tS32  s32SetData(const tU8 &tSettingClusterSkinParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingClusterSkinParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingClusterSkinParam);
   tVoid vSetData(const tU8& tSettingClusterSkinParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSailingActivationIdle{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSailingActivationIdle;
   
public:
   dp_tclVehFuncSettingSailingActivationIdle(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSailingActivationIdle() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSailingActivationIdleParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSailingActivationIdleParam);
   tS32  s32SetData(const tU8 &tSettingSailingActivationIdleParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSailingActivationIdleParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSailingActivationIdleParam);
   tVoid vSetData(const tU8& tSettingSailingActivationIdleParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingLKA{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingLKA;
   
public:
   dp_tclVehFuncSettingLKA(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingLKA() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingLKAParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingLKAParam);
   tS32  s32SetData(const tU8 &tSettingLKAParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingLKAParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingLKAParam);
   tVoid vSetData(const tU8& tSettingLKAParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingAutoInternalLights{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAutoInternalLights;
   
public:
   dp_tclVehFuncSettingAutoInternalLights(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingAutoInternalLights() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAutoInternalLightsParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAutoInternalLightsParam);
   tS32  s32SetData(const tU8 &tSettingAutoInternalLightsParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAutoInternalLightsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAutoInternalLightsParam);
   tVoid vSetData(const tU8& tSettingAutoInternalLightsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingDriverMassageActivationSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverMassageActivationSetting;
   
public:
   dp_tclVehFuncSettingDriverMassageActivationSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingDriverMassageActivationSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverMassageActivationSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverMassageActivationSettingParam);
   tS32  s32SetData(const tU8 &tSettingDriverMassageActivationSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverMassageActivationSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverMassageActivationSettingParam);
   tVoid vSetData(const tU8& tSettingDriverMassageActivationSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingDriverEasyAccess{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverEasyAccess;
   
public:
   dp_tclVehFuncSettingDriverEasyAccess(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingDriverEasyAccess() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverEasyAccessParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverEasyAccessParam);
   tS32  s32SetData(const tU8 &tSettingDriverEasyAccessParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverEasyAccessParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverEasyAccessParam);
   tVoid vSetData(const tU8& tSettingDriverEasyAccessParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerMassageActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerMassageActivation;
   
public:
   dp_tclVehFuncSettingPassengerMassageActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerMassageActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerMassageActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerMassageActivationParam);
   tS32  s32SetData(const tU8 &tSettingPassengerMassageActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerMassageActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerMassageActivationParam);
   tVoid vSetData(const tU8& tSettingPassengerMassageActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerMassageProgramState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerMassageProgramState;
   
public:
   dp_tclVehFuncSettingPassengerMassageProgramState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerMassageProgramState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerMassageProgramStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerMassageProgramStateParam);
   tS32  s32SetData(const tU8 &tSettingPassengerMassageProgramStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerMassageProgramStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerMassageProgramStateParam);
   tVoid vSetData(const tU8& tSettingPassengerMassageProgramStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerMassageVelocity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerMassageVelocity;
   
public:
   dp_tclVehFuncSettingPassengerMassageVelocity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerMassageVelocity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerMassageVelocityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerMassageVelocityParam);
   tS32  s32SetData(const tU8 &tSettingPassengerMassageVelocityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerMassageVelocityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerMassageVelocityParam);
   tVoid vSetData(const tU8& tSettingPassengerMassageVelocityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerMassageIntensity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerMassageIntensity;
   
public:
   dp_tclVehFuncSettingPassengerMassageIntensity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerMassageIntensity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerMassageIntensityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerMassageIntensityParam);
   tS32  s32SetData(const tU8 &tSettingPassengerMassageIntensityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerMassageIntensityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerMassageIntensityParam);
   tVoid vSetData(const tU8& tSettingPassengerMassageIntensityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerVentil{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerVentil;
   
public:
   dp_tclVehFuncSettingPassengerVentil(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerVentil() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerVentilParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerVentilParam);
   tS32  s32SetData(const tU8 &tSettingPassengerVentilParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerVentilParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerVentilParam);
   tVoid vSetData(const tU8& tSettingPassengerVentilParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerHeating{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerHeating;
   
public:
   dp_tclVehFuncSettingPassengerHeating(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerHeating() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerHeatingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerHeatingParam);
   tS32  s32SetData(const tU8 &tSettingPassengerHeatingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerHeatingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerHeatingParam);
   tVoid vSetData(const tU8& tSettingPassengerHeatingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingPassengerEasyAccess{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingPassengerEasyAccess;
   
public:
   dp_tclVehFuncSettingPassengerEasyAccess(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingPassengerEasyAccess() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingPassengerEasyAccessParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingPassengerEasyAccessParam);
   tS32  s32SetData(const tU8 &tSettingPassengerEasyAccessParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingPassengerEasyAccessParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingPassengerEasyAccessParam);
   tVoid vSetData(const tU8& tSettingPassengerEasyAccessParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSeat1_Folding{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSeat1_Folding;
   
public:
   dp_tclVehFuncSettingSeat1_Folding(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSeat1_Folding() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSeat1_FoldingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSeat1_FoldingParam);
   tS32  s32SetData(const tU8 &tSettingSeat1_FoldingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSeat1_FoldingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSeat1_FoldingParam);
   tVoid vSetData(const tU8& tSettingSeat1_FoldingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSeat2_Folding{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSeat2_Folding;
   
public:
   dp_tclVehFuncSettingSeat2_Folding(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSeat2_Folding() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSeat2_FoldingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSeat2_FoldingParam);
   tS32  s32SetData(const tU8 &tSettingSeat2_FoldingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSeat2_FoldingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSeat2_FoldingParam);
   tVoid vSetData(const tU8& tSettingSeat2_FoldingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSeat3_Folding{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSeat3_Folding;
   
public:
   dp_tclVehFuncSettingSeat3_Folding(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSeat3_Folding() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSeat3_FoldingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSeat3_FoldingParam);
   tS32  s32SetData(const tU8 &tSettingSeat3_FoldingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSeat3_FoldingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSeat3_FoldingParam);
   tVoid vSetData(const tU8& tSettingSeat3_FoldingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSeat4_Folding{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSeat4_Folding;
   
public:
   dp_tclVehFuncSettingSeat4_Folding(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSeat4_Folding() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSeat4_FoldingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSeat4_FoldingParam);
   tS32  s32SetData(const tU8 &tSettingSeat4_FoldingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSeat4_FoldingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSeat4_FoldingParam);
   tVoid vSetData(const tU8& tSettingSeat4_FoldingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingSeat5_Folding{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSeat5_Folding;
   
public:
   dp_tclVehFuncSettingSeat5_Folding(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingSeat5_Folding() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSeat5_FoldingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSeat5_FoldingParam);
   tS32  s32SetData(const tU8 &tSettingSeat5_FoldingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSeat5_FoldingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSeat5_FoldingParam);
   tVoid vSetData(const tU8& tSettingSeat5_FoldingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncSettingCourtesyActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingCourtesyActivation;
   
public:
   dp_tclVehFuncSettingCourtesyActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncSettingCourtesyActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingCourtesyActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingCourtesyActivationParam);
   tS32  s32SetData(const tU8 &tSettingCourtesyActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingCourtesyActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingCourtesyActivationParam);
   tVoid vSetData(const tU8& tSettingCourtesyActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
