#ifndef _DP_FI_PROFILEMNGR_H
#define _DP_FI_PROFILEMNGR_H

extern tVoid vInitprofileMngr(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclprofileMngrProfiles{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclprofileMngrProfiles(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrProfiles() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tProfilesParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tProfilesParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tProfilesParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclprofileMngrStartClients{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclprofileMngrStartClients(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrStartClients() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tStartClientsParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tStartClientsParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tStartClientsParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclprofileMngrPrivacyMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tPrivacyMode;
   
public:
   dp_tclprofileMngrPrivacyMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrPrivacyMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tPrivacyModeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tPrivacyModeParam);
   tS32  s32SetData(const tU32 &tPrivacyModeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tPrivacyModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tPrivacyModeParam);
   tVoid vSetData(const tU32& tPrivacyModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrPinHash{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclprofileMngrPinHash(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrPinHash() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tPinHashParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tPinHashParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tPinHashParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclprofileMngrPinCounter{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclprofileMngrPinCounter(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrPinCounter() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tPinCounterParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tPinCounterParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tPinCounterParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclprofileMngrMaxPINAttemptsTotal{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMaxPINAttemptsTotal;
   
public:
   dp_tclprofileMngrMaxPINAttemptsTotal(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrMaxPINAttemptsTotal() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMaxPINAttemptsTotalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMaxPINAttemptsTotalParam);
   tS32  s32SetData(const tU8 &tMaxPINAttemptsTotalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMaxPINAttemptsTotalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMaxPINAttemptsTotalParam);
   tVoid vSetData(const tU8& tMaxPINAttemptsTotalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrMaxPINAttemptsBeforeDelay{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMaxPINAttemptsBeforeDelay;
   
public:
   dp_tclprofileMngrMaxPINAttemptsBeforeDelay(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrMaxPINAttemptsBeforeDelay() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMaxPINAttemptsBeforeDelayParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMaxPINAttemptsBeforeDelayParam);
   tS32  s32SetData(const tU8 &tMaxPINAttemptsBeforeDelayParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMaxPINAttemptsBeforeDelayParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMaxPINAttemptsBeforeDelayParam);
   tVoid vSetData(const tU8& tMaxPINAttemptsBeforeDelayParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrPINAuthenticationDelay{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tPINAuthenticationDelay;
   
public:
   dp_tclprofileMngrPINAuthenticationDelay(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrPINAuthenticationDelay() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tPINAuthenticationDelayParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tPINAuthenticationDelayParam);
   tS32  s32SetData(const tU32 &tPINAuthenticationDelayParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tPINAuthenticationDelayParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tPINAuthenticationDelayParam);
   tVoid vSetData(const tU32& tPINAuthenticationDelayParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrPinVerificationValidity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tPinVerificationValidity;
   
public:
   dp_tclprofileMngrPinVerificationValidity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrPinVerificationValidity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tPinVerificationValidityParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tPinVerificationValidityParam);
   tS32  s32SetData(const tU32 &tPinVerificationValidityParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tPinVerificationValidityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tPinVerificationValidityParam);
   tVoid vSetData(const tU32& tPinVerificationValidityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrAuthenticationValidTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   uint32_t tAuthenticationValidTime;
   
public:
   dp_tclprofileMngrAuthenticationValidTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrAuthenticationValidTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   uint32_t tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(uint32_t& tAuthenticationValidTimeParam);
   tVoid operator>>(uint32_t& oParam);
   
   //write access for pool element 
   tS32  s32SetData(uint32_t &tAuthenticationValidTimeParam);
   tS32  s32SetData(const uint32_t &tAuthenticationValidTimeParam);
   tVoid operator<<(uint32_t oParam);
   
   // do not use --> old interface
   tU8   u8GetData(uint32_t& tAuthenticationValidTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(uint32_t& tAuthenticationValidTimeParam);
   tVoid vSetData(const uint32_t& tAuthenticationValidTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrprofileOperation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tprofileOperation;
   
public:
   dp_tclprofileMngrprofileOperation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrprofileOperation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tprofileOperationParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tprofileOperationParam);
   tS32  s32SetData(const tU32 &tprofileOperationParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tprofileOperationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tprofileOperationParam);
   tVoid vSetData(const tU32& tprofileOperationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrValetModeStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tValetModeStatus;
   
public:
   dp_tclprofileMngrValetModeStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrValetModeStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tValetModeStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tValetModeStatusParam);
   tS32  s32SetData(const tBool &tValetModeStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tValetModeStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tValetModeStatusParam);
   tVoid vSetData(const tBool& tValetModeStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrLastActiveUser{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLastActiveUser;
   
public:
   dp_tclprofileMngrLastActiveUser(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrLastActiveUser() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLastActiveUserParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLastActiveUserParam);
   tS32  s32SetData(const tU8 &tLastActiveUserParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLastActiveUserParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLastActiveUserParam);
   tVoid vSetData(const tU8& tLastActiveUserParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclprofileMngrlogoffTimestamp{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   uint64_t tlogoffTimestamp;
   
public:
   dp_tclprofileMngrlogoffTimestamp(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclprofileMngrlogoffTimestamp() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   uint64_t tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(uint64_t& tlogoffTimestampParam);
   tVoid operator>>(uint64_t& oParam);
   
   //write access for pool element 
   tS32  s32SetData(uint64_t &tlogoffTimestampParam);
   tS32  s32SetData(const uint64_t &tlogoffTimestampParam);
   tVoid operator<<(uint64_t oParam);
   
   // do not use --> old interface
   tU8   u8GetData(uint64_t& tlogoffTimestampParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(uint64_t& tlogoffTimestampParam);
   tVoid vSetData(const uint64_t& tlogoffTimestampParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
