#ifndef _DP_FI_FCUSBTCUDP_H
#define _DP_FI_FCUSBTCUDP_H

extern tVoid vInitFCUsbTcuDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_USB_TCU_S_IMPORT_INTERFACE_DP 
#include "../../di_middleware_server/components/fc_usb_tcu/interfaces/fc_usb_tcu_dp_if.h"
//lint +e750




class dp_tclFCUsbTcuDpAutoDownloadInterval{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAutoDownloadInterval;
   
public:
   dp_tclFCUsbTcuDpAutoDownloadInterval(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpAutoDownloadInterval() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAutoDownloadIntervalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAutoDownloadIntervalParam);
   tS32  s32SetData(const tU8 &tAutoDownloadIntervalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAutoDownloadIntervalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAutoDownloadIntervalParam);
   tVoid vSetData(const tU8& tAutoDownloadIntervalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpAuthenticationResult{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAuthenticationResult;
   
public:
   dp_tclFCUsbTcuDpAuthenticationResult(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpAuthenticationResult() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAuthenticationResultParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAuthenticationResultParam);
   tS32  s32SetData(const tU8 &tAuthenticationResultParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAuthenticationResultParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAuthenticationResultParam);
   tVoid vSetData(const tU8& tAuthenticationResultParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpMonthlyProbeData{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDPMonthlyProbeData tMonthlyProbeData;
   
public:
   dp_tclFCUsbTcuDpMonthlyProbeData(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpMonthlyProbeData() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDPMonthlyProbeData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDPMonthlyProbeData& tMonthlyProbeDataParam);
   tVoid operator>>(TDPMonthlyProbeData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDPMonthlyProbeData &tMonthlyProbeDataParam);
   tS32  s32SetData(const TDPMonthlyProbeData &tMonthlyProbeDataParam);
   tVoid operator<<(TDPMonthlyProbeData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDPMonthlyProbeData& tMonthlyProbeDataParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDPMonthlyProbeData& tMonthlyProbeDataParam);
   tVoid vSetData(const TDPMonthlyProbeData& tMonthlyProbeDataParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpLifeTimeProbeData{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDPLifeTimeProbeData tLifeTimeProbeData;
   
public:
   dp_tclFCUsbTcuDpLifeTimeProbeData(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpLifeTimeProbeData() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDPLifeTimeProbeData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDPLifeTimeProbeData& tLifeTimeProbeDataParam);
   tVoid operator>>(TDPLifeTimeProbeData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDPLifeTimeProbeData &tLifeTimeProbeDataParam);
   tS32  s32SetData(const TDPLifeTimeProbeData &tLifeTimeProbeDataParam);
   tVoid operator<<(TDPLifeTimeProbeData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDPLifeTimeProbeData& tLifeTimeProbeDataParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDPLifeTimeProbeData& tLifeTimeProbeDataParam);
   tVoid vSetData(const TDPLifeTimeProbeData& tLifeTimeProbeDataParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpTripProbeData{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDPTripData tTripProbeData;
   
public:
   dp_tclFCUsbTcuDpTripProbeData(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpTripProbeData() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDPTripData tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDPTripData& tTripProbeDataParam);
   tVoid operator>>(TDPTripData& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDPTripData &tTripProbeDataParam);
   tS32  s32SetData(const TDPTripData &tTripProbeDataParam);
   tVoid operator<<(TDPTripData oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDPTripData& tTripProbeDataParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDPTripData& tTripProbeDataParam);
   tVoid vSetData(const TDPTripData& tTripProbeDataParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpFirstStarup{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tFirstStarup;
   
public:
   dp_tclFCUsbTcuDpFirstStarup(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpFirstStarup() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tFirstStarupParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tFirstStarupParam);
   tS32  s32SetData(const tBool &tFirstStarupParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tFirstStarupParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tFirstStarupParam);
   tVoid vSetData(const tBool& tFirstStarupParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpSystemTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDatetime tSystemTime;
   
public:
   dp_tclFCUsbTcuDpSystemTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpSystemTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDatetime tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDatetime& tSystemTimeParam);
   tVoid operator>>(TDatetime& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDatetime &tSystemTimeParam);
   tS32  s32SetData(const TDatetime &tSystemTimeParam);
   tVoid operator<<(TDatetime oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDatetime& tSystemTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDatetime& tSystemTimeParam);
   tVoid vSetData(const TDatetime& tSystemTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpLastSystemDate{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDate tLastSystemDate;
   
public:
   dp_tclFCUsbTcuDpLastSystemDate(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpLastSystemDate() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDate tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDate& tLastSystemDateParam);
   tVoid operator>>(TDate& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDate &tLastSystemDateParam);
   tS32  s32SetData(const TDate &tLastSystemDateParam);
   tVoid operator<<(TDate oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDate& tLastSystemDateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDate& tLastSystemDateParam);
   tVoid vSetData(const TDate& tLastSystemDateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpProbeSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tProbeSetting;
   
public:
   dp_tclFCUsbTcuDpProbeSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpProbeSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tProbeSettingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tProbeSettingParam);
   tS32  s32SetData(const tBool &tProbeSettingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tProbeSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tProbeSettingParam);
   tVoid vSetData(const tBool& tProbeSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpCautionHaltStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCautionHaltStatus;
   
public:
   dp_tclFCUsbTcuDpCautionHaltStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpCautionHaltStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCautionHaltStatusParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCautionHaltStatusParam);
   tS32  s32SetData(const tU8 &tCautionHaltStatusParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCautionHaltStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCautionHaltStatusParam);
   tVoid vSetData(const tU8& tCautionHaltStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpCautionHaltCause{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCautionHaltCause;
   
public:
   dp_tclFCUsbTcuDpCautionHaltCause(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpCautionHaltCause() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCautionHaltCauseParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCautionHaltCauseParam);
   tS32  s32SetData(const tU8 &tCautionHaltCauseParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCautionHaltCauseParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCautionHaltCauseParam);
   tVoid vSetData(const tU8& tCautionHaltCauseParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpUserAuthentication_UserID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCUsbTcuDpUserAuthentication_UserID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpUserAuthentication_UserID() {};

   //read access for pool element 
   tS32  s32GetData(tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tUserAuthentication_UserIDParam);
   tS32 s32SetData(const tString &tUserAuthentication_UserIDParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tUserAuthentication_UserIDParam);
   tVoid vSetData(const tString &tUserAuthentication_UserIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpUserAuthentication_Password{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCUsbTcuDpUserAuthentication_Password(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpUserAuthentication_Password() {};

   //read access for pool element 
   tS32  s32GetData(tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tUserAuthentication_PasswordParam);
   tS32 s32SetData(const tString &tUserAuthentication_PasswordParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tUserAuthentication_PasswordParam);
   tVoid vSetData(const tString &tUserAuthentication_PasswordParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpPartAuthentication_PartID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCUsbTcuDpPartAuthentication_PartID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpPartAuthentication_PartID() {};

   //read access for pool element 
   tS32  s32GetData(tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tPartAuthentication_PartIDParam);
   tS32 s32SetData(const tString &tPartAuthentication_PartIDParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tPartAuthentication_PartIDParam);
   tVoid vSetData(const tString &tPartAuthentication_PartIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpPartAuthentication_Region{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCUsbTcuDpPartAuthentication_Region(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpPartAuthentication_Region() {};

   //read access for pool element 
   tS32  s32GetData(tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tPartAuthentication_RegionParam);
   tS32 s32SetData(const tString &tPartAuthentication_RegionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tPartAuthentication_RegionParam);
   tVoid vSetData(const tString &tPartAuthentication_RegionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tPartAuthentication_Bootstrapping;
   
public:
   dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tPartAuthentication_BootstrappingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tPartAuthentication_BootstrappingParam);
   tS32  s32SetData(const tBool &tPartAuthentication_BootstrappingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tPartAuthentication_BootstrappingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tPartAuthentication_BootstrappingParam);
   tVoid vSetData(const tBool& tPartAuthentication_BootstrappingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpCredentialsValidationTimeout{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCredentialsValidationTimeout;
   
public:
   dp_tclFCUsbTcuDpCredentialsValidationTimeout(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpCredentialsValidationTimeout() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCredentialsValidationTimeoutParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCredentialsValidationTimeoutParam);
   tS32  s32SetData(const tU8 &tCredentialsValidationTimeoutParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCredentialsValidationTimeoutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCredentialsValidationTimeoutParam);
   tVoid vSetData(const tU8& tCredentialsValidationTimeoutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCUsbTcuDpRefreshAccessTokenTimeout{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRefreshAccessTokenTimeout;
   
public:
   dp_tclFCUsbTcuDpRefreshAccessTokenTimeout(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCUsbTcuDpRefreshAccessTokenTimeout() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRefreshAccessTokenTimeoutParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRefreshAccessTokenTimeoutParam);
   tS32  s32SetData(const tU8 &tRefreshAccessTokenTimeoutParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRefreshAccessTokenTimeoutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRefreshAccessTokenTimeoutParam);
   tVoid vSetData(const tU8& tRefreshAccessTokenTimeoutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
