
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclFcSxmDP.h"



tU8 dp_tclFcSxmDPRADIOID::u8GetData(tString &tRADIOIDParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SXM_SERIALNO_VER", tRADIOIDParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclFcSxmDPRADIOID::u8GetData(const tString &tRADIOIDParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SXM_SERIALNO_VER", tRADIOIDParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclFcSxmDPRADIOID::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclFcSxmDPRADIOID::vSetData(tString &tRADIOIDParam) {
   tU32 u32Len = (tU32)strlen(tRADIOIDParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SXM_SERIALNO_VER", tRADIOIDParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFcSxmDPRADIOID::vSetData(const tString &tRADIOIDParam) {
   tU32 u32Len = (tU32)strlen(tRADIOIDParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SXM_SERIALNO_VER", tRADIOIDParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFcSxmDPRADIOID::vSetData(tString &tRADIOIDParam, tU16 u16Len) 
{
    vSetData(tRADIOIDParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclFcSxmDPRADIOID::vSetData(const tString &tRADIOIDParam, tU16 u16Len) 
{
    vSetData(tRADIOIDParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclFcSxmDPHWREV::u8GetData(tString &tHWREVParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SXM_HW_VER", tHWREVParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclFcSxmDPHWREV::u8GetData(const tString &tHWREVParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SXM_HW_VER", tHWREVParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclFcSxmDPHWREV::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclFcSxmDPHWREV::vSetData(tString &tHWREVParam) {
   tU32 u32Len = (tU32)strlen(tHWREVParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SXM_HW_VER", tHWREVParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFcSxmDPHWREV::vSetData(const tString &tHWREVParam) {
   tU32 u32Len = (tU32)strlen(tHWREVParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SXM_HW_VER", tHWREVParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFcSxmDPHWREV::vSetData(tString &tHWREVParam, tU16 u16Len) 
{
    vSetData(tHWREVParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclFcSxmDPHWREV::vSetData(const tString &tHWREVParam, tU16 u16Len) 
{
    vSetData(tHWREVParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclFcSxmDPSWREV::u8GetData(tString &tSWREVParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SXM_SW_VER", tSWREVParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclFcSxmDPSWREV::u8GetData(const tString &tSWREVParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SXM_SW_VER", tSWREVParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclFcSxmDPSWREV::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclFcSxmDPSWREV::vSetData(tString &tSWREVParam) {
   tU32 u32Len = (tU32)strlen(tSWREVParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SXM_SW_VER", tSWREVParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFcSxmDPSWREV::vSetData(const tString &tSWREVParam) {
   tU32 u32Len = (tU32)strlen(tSWREVParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCSXM/FC_SXM";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SXM_SW_VER", tSWREVParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFcSxmDPSWREV::vSetData(tString &tSWREVParam, tU16 u16Len) 
{
    vSetData(tSWREVParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclFcSxmDPSWREV::vSetData(const tString &tSWREVParam, tU16 u16Len) 
{
    vSetData(tSWREVParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsListSize::dp_tclFcSxmDPSportsListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSportsListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPSportsListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SportsListSize",(tS32) 0x8aedb5ea);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSportsListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPSportsListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SportsListSize", (tS32)0x8aedb5ea);
   (tVoid)myDpElem.bFillData((tVoid*)&tSportsListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPSportsListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPSportsListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPSportsListSize::tGetData() {
   vUpdate();
   return tSportsListSize;
};
tS32 dp_tclFcSxmDPSportsListSize::s32GetData(tU32& tSportsListSizeParam) { 
   vUpdate();
   tSportsListSizeParam = tSportsListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPSportsListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SportsListSize", (tS32)0x8aedb5ea);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPSportsListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPSportsListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPSportsListSize::s32SetData(tU32 &tSportsListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tSportsListSize,(tVoid*)&tSportsListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsListSizeParam' in function 'dp_tclFcSxmDPSportsListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPSportsListSize::s32SetData(const tU32 &tSportsListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tSportsListSize,(tVoid*)&tSportsListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsListSizeParam' in function 'dp_tclFcSxmDPSportsListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPSportsListSize::u8GetData(tU32& tSportsListSizeParam) {  
   vUpdate();
   tSportsListSizeParam = tSportsListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPSportsListSize::vSetData(tU32 &tSportsListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsListSize,(tVoid*)&tSportsListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsListSizeParam' in function 'dp_tclFcSxmDPSportsListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPSportsListSize::vSetData(const tU32 &tSportsListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsListSize,(tVoid*)&tSportsListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsListSizeParam' in function 'dp_tclFcSxmDPSportsListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPSportsListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPSportsListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element SportsListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsList::dp_tclFcSxmDPSportsList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPSportsList::s32SetData( dpSportListElement* tSportsListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SportsList", (tS32)0xceb7d8b);
   (tVoid)myDpElem.bFillData((tVoid*)tSportsListParam, ((tU32)sizeof(dpSportListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPSportsList::s32GetData(dpSportListElement* tSportsListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SportsList", (tS32)0xceb7d8b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpSportListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpSportListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSportsListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpSportListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPSportsList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPSportsList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPSportsList::u16GetData(dpSportListElement* tSportsListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSportsListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPSportsList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPSportsList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPSportsList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element SportsList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsRootListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsRootListSize::dp_tclFcSxmDPSportsRootListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSportsRootListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPSportsRootListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SportsRootListSize",(tS32) 0x42ce023a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSportsRootListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPSportsRootListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SportsRootListSize", (tS32)0x42ce023a);
   (tVoid)myDpElem.bFillData((tVoid*)&tSportsRootListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPSportsRootListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPSportsRootListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPSportsRootListSize::tGetData() {
   vUpdate();
   return tSportsRootListSize;
};
tS32 dp_tclFcSxmDPSportsRootListSize::s32GetData(tU32& tSportsRootListSizeParam) { 
   vUpdate();
   tSportsRootListSizeParam = tSportsRootListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPSportsRootListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SportsRootListSize", (tS32)0x42ce023a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPSportsRootListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPSportsRootListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPSportsRootListSize::s32SetData(tU32 &tSportsRootListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tSportsRootListSize,(tVoid*)&tSportsRootListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsRootListSizeParam' in function 'dp_tclFcSxmDPSportsRootListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPSportsRootListSize::s32SetData(const tU32 &tSportsRootListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tSportsRootListSize,(tVoid*)&tSportsRootListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsRootListSizeParam' in function 'dp_tclFcSxmDPSportsRootListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPSportsRootListSize::u8GetData(tU32& tSportsRootListSizeParam) {  
   vUpdate();
   tSportsRootListSizeParam = tSportsRootListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPSportsRootListSize::vSetData(tU32 &tSportsRootListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsRootListSize,(tVoid*)&tSportsRootListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsRootListSizeParam' in function 'dp_tclFcSxmDPSportsRootListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPSportsRootListSize::vSetData(const tU32 &tSportsRootListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsRootListSize,(tVoid*)&tSportsRootListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsRootListSizeParam' in function 'dp_tclFcSxmDPSportsRootListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPSportsRootListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPSportsRootListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsRootListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsRootListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsRootListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsRootListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsRootListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element SportsRootListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsRootList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsRootList::dp_tclFcSxmDPSportsRootList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPSportsRootList::s32SetData( dpRootListElement* tSportsRootListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SportsRootList", (tS32)0x8af616db);
   (tVoid)myDpElem.bFillData((tVoid*)tSportsRootListParam, ((tU32)sizeof(dpRootListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPSportsRootList::s32GetData(dpRootListElement* tSportsRootListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SportsRootList", (tS32)0x8af616db);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpRootListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpRootListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSportsRootListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpRootListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPSportsRootList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPSportsRootList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPSportsRootList::u16GetData(dpRootListElement* tSportsRootListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSportsRootListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPSportsRootList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsRootList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPSportsRootList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsRootList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPSportsRootList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsRootList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element SportsRootList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsFavoriteListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsFavoriteListSize::dp_tclFcSxmDPSportsFavoriteListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSportsFavoriteListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPSportsFavoriteListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SportsFavoriteListSize",(tS32) 0x12cb5e42);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSportsFavoriteListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPSportsFavoriteListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SportsFavoriteListSize", (tS32)0x12cb5e42);
   (tVoid)myDpElem.bFillData((tVoid*)&tSportsFavoriteListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPSportsFavoriteListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPSportsFavoriteListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPSportsFavoriteListSize::tGetData() {
   vUpdate();
   return tSportsFavoriteListSize;
};
tS32 dp_tclFcSxmDPSportsFavoriteListSize::s32GetData(tU32& tSportsFavoriteListSizeParam) { 
   vUpdate();
   tSportsFavoriteListSizeParam = tSportsFavoriteListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPSportsFavoriteListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SportsFavoriteListSize", (tS32)0x12cb5e42);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPSportsFavoriteListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPSportsFavoriteListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPSportsFavoriteListSize::s32SetData(tU32 &tSportsFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tSportsFavoriteListSize,(tVoid*)&tSportsFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsFavoriteListSizeParam' in function 'dp_tclFcSxmDPSportsFavoriteListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPSportsFavoriteListSize::s32SetData(const tU32 &tSportsFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tSportsFavoriteListSize,(tVoid*)&tSportsFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsFavoriteListSizeParam' in function 'dp_tclFcSxmDPSportsFavoriteListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPSportsFavoriteListSize::u8GetData(tU32& tSportsFavoriteListSizeParam) {  
   vUpdate();
   tSportsFavoriteListSizeParam = tSportsFavoriteListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPSportsFavoriteListSize::vSetData(tU32 &tSportsFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsFavoriteListSize,(tVoid*)&tSportsFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsFavoriteListSizeParam' in function 'dp_tclFcSxmDPSportsFavoriteListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPSportsFavoriteListSize::vSetData(const tU32 &tSportsFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsFavoriteListSize,(tVoid*)&tSportsFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsFavoriteListSizeParam' in function 'dp_tclFcSxmDPSportsFavoriteListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPSportsFavoriteListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPSportsFavoriteListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsFavoriteListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsFavoriteListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsFavoriteListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element SportsFavoriteListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsFavoriteList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsFavoriteList::dp_tclFcSxmDPSportsFavoriteList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPSportsFavoriteList::s32SetData( dpFavoriteListElement* tSportsFavoriteListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SportsFavoriteList", (tS32)0x189b2763);
   (tVoid)myDpElem.bFillData((tVoid*)tSportsFavoriteListParam, ((tU32)sizeof(dpFavoriteListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPSportsFavoriteList::s32GetData(dpFavoriteListElement* tSportsFavoriteListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SportsFavoriteList", (tS32)0x189b2763);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpFavoriteListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpFavoriteListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSportsFavoriteListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpFavoriteListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPSportsFavoriteList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPSportsFavoriteList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPSportsFavoriteList::u16GetData(dpFavoriteListElement* tSportsFavoriteListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSportsFavoriteListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPSportsFavoriteList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsFavoriteList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPSportsFavoriteList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsFavoriteList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPSportsFavoriteList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsFavoriteList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element SportsFavoriteList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DBErrorConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPDBErrorConfig::dp_tclFcSxmDPDBErrorConfig(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPDBErrorConfig::s32SetData( tU8* tDBErrorConfigParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DBErrorConfig", (tS32)0xd658584a);
   (tVoid)myDpElem.bFillData((tVoid*)tDBErrorConfigParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPDBErrorConfig::s32GetData(tU8* tDBErrorConfigParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DBErrorConfig", (tS32)0xd658584a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDBErrorConfigParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPDBErrorConfig::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPDBErrorConfig::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPDBErrorConfig::u16GetData(tU8* tDBErrorConfigParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDBErrorConfigParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPDBErrorConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "DBErrorConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPDBErrorConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "DBErrorConfig", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPDBErrorConfig::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DBErrorConfig", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element DBErrorConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MoviesFavoriteList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPMoviesFavoriteList::dp_tclFcSxmDPMoviesFavoriteList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPMoviesFavoriteList::s32SetData( dpAppListElement* tMoviesFavoriteListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MoviesFavoriteList", (tS32)0x70998af3);
   (tVoid)myDpElem.bFillData((tVoid*)tMoviesFavoriteListParam, ((tU32)sizeof(dpAppListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPMoviesFavoriteList::s32GetData(dpAppListElement* tMoviesFavoriteListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MoviesFavoriteList", (tS32)0x70998af3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpAppListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpAppListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMoviesFavoriteListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpAppListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPMoviesFavoriteList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPMoviesFavoriteList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPMoviesFavoriteList::u16GetData(dpAppListElement* tMoviesFavoriteListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMoviesFavoriteListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPMoviesFavoriteList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "MoviesFavoriteList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPMoviesFavoriteList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "MoviesFavoriteList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPMoviesFavoriteList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MoviesFavoriteList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element MoviesFavoriteList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MoviesFavoriteListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPMoviesFavoriteListSize::dp_tclFcSxmDPMoviesFavoriteListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMoviesFavoriteListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPMoviesFavoriteListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MoviesFavoriteListSize",(tS32) 0xe6dc70d2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tMoviesFavoriteListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPMoviesFavoriteListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MoviesFavoriteListSize", (tS32)0xe6dc70d2);
   (tVoid)myDpElem.bFillData((tVoid*)&tMoviesFavoriteListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPMoviesFavoriteListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPMoviesFavoriteListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPMoviesFavoriteListSize::tGetData() {
   vUpdate();
   return tMoviesFavoriteListSize;
};
tS32 dp_tclFcSxmDPMoviesFavoriteListSize::s32GetData(tU32& tMoviesFavoriteListSizeParam) { 
   vUpdate();
   tMoviesFavoriteListSizeParam = tMoviesFavoriteListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPMoviesFavoriteListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MoviesFavoriteListSize", (tS32)0xe6dc70d2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPMoviesFavoriteListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPMoviesFavoriteListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPMoviesFavoriteListSize::s32SetData(tU32 &tMoviesFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tMoviesFavoriteListSize,(tVoid*)&tMoviesFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMoviesFavoriteListSizeParam' in function 'dp_tclFcSxmDPMoviesFavoriteListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPMoviesFavoriteListSize::s32SetData(const tU32 &tMoviesFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tMoviesFavoriteListSize,(tVoid*)&tMoviesFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMoviesFavoriteListSizeParam' in function 'dp_tclFcSxmDPMoviesFavoriteListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPMoviesFavoriteListSize::u8GetData(tU32& tMoviesFavoriteListSizeParam) {  
   vUpdate();
   tMoviesFavoriteListSizeParam = tMoviesFavoriteListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPMoviesFavoriteListSize::vSetData(tU32 &tMoviesFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tMoviesFavoriteListSize,(tVoid*)&tMoviesFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tMoviesFavoriteListSizeParam' in function 'dp_tclFcSxmDPMoviesFavoriteListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPMoviesFavoriteListSize::vSetData(const tU32 &tMoviesFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tMoviesFavoriteListSize,(tVoid*)&tMoviesFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tMoviesFavoriteListSizeParam' in function 'dp_tclFcSxmDPMoviesFavoriteListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPMoviesFavoriteListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPMoviesFavoriteListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "MoviesFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPMoviesFavoriteListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "MoviesFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPMoviesFavoriteListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MoviesFavoriteListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element MoviesFavoriteListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelFavoriteList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPFuelFavoriteList::dp_tclFcSxmDPFuelFavoriteList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPFuelFavoriteList::s32SetData( dpAppListElement* tFuelFavoriteListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("FuelFavoriteList", (tS32)0x93194948);
   (tVoid)myDpElem.bFillData((tVoid*)tFuelFavoriteListParam, ((tU32)sizeof(dpAppListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPFuelFavoriteList::s32GetData(dpAppListElement* tFuelFavoriteListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("FuelFavoriteList", (tS32)0x93194948);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpAppListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpAppListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFuelFavoriteListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpAppListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPFuelFavoriteList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPFuelFavoriteList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPFuelFavoriteList::u16GetData(dpAppListElement* tFuelFavoriteListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFuelFavoriteListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPFuelFavoriteList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "FuelFavoriteList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPFuelFavoriteList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "FuelFavoriteList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPFuelFavoriteList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelFavoriteList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element FuelFavoriteList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelFavoriteListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPFuelFavoriteListSize::dp_tclFcSxmDPFuelFavoriteListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFuelFavoriteListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPFuelFavoriteListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FuelFavoriteListSize",(tS32) 0x20bc1e57);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tFuelFavoriteListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPFuelFavoriteListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FuelFavoriteListSize", (tS32)0x20bc1e57);
   (tVoid)myDpElem.bFillData((tVoid*)&tFuelFavoriteListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPFuelFavoriteListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPFuelFavoriteListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPFuelFavoriteListSize::tGetData() {
   vUpdate();
   return tFuelFavoriteListSize;
};
tS32 dp_tclFcSxmDPFuelFavoriteListSize::s32GetData(tU32& tFuelFavoriteListSizeParam) { 
   vUpdate();
   tFuelFavoriteListSizeParam = tFuelFavoriteListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPFuelFavoriteListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FuelFavoriteListSize", (tS32)0x20bc1e57);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPFuelFavoriteListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPFuelFavoriteListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPFuelFavoriteListSize::s32SetData(tU32 &tFuelFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tFuelFavoriteListSize,(tVoid*)&tFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPFuelFavoriteListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPFuelFavoriteListSize::s32SetData(const tU32 &tFuelFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tFuelFavoriteListSize,(tVoid*)&tFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPFuelFavoriteListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPFuelFavoriteListSize::u8GetData(tU32& tFuelFavoriteListSizeParam) {  
   vUpdate();
   tFuelFavoriteListSizeParam = tFuelFavoriteListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPFuelFavoriteListSize::vSetData(tU32 &tFuelFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelFavoriteListSize,(tVoid*)&tFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPFuelFavoriteListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPFuelFavoriteListSize::vSetData(const tU32 &tFuelFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelFavoriteListSize,(tVoid*)&tFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPFuelFavoriteListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPFuelFavoriteListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPFuelFavoriteListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "FuelFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPFuelFavoriteListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "FuelFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPFuelFavoriteListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelFavoriteListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element FuelFavoriteListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CanadianFuelFavoriteList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPCanadianFuelFavoriteList::dp_tclFcSxmDPCanadianFuelFavoriteList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPCanadianFuelFavoriteList::s32SetData( dpAppListElement* tCanadianFuelFavoriteListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("CanadianFuelFavoriteList", (tS32)0x6c2f35b7);
   (tVoid)myDpElem.bFillData((tVoid*)tCanadianFuelFavoriteListParam, ((tU32)sizeof(dpAppListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPCanadianFuelFavoriteList::s32GetData(dpAppListElement* tCanadianFuelFavoriteListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("CanadianFuelFavoriteList", (tS32)0x6c2f35b7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpAppListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpAppListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tCanadianFuelFavoriteListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpAppListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPCanadianFuelFavoriteList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPCanadianFuelFavoriteList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPCanadianFuelFavoriteList::u16GetData(dpAppListElement* tCanadianFuelFavoriteListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tCanadianFuelFavoriteListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPCanadianFuelFavoriteList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "CanadianFuelFavoriteList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPCanadianFuelFavoriteList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "CanadianFuelFavoriteList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPCanadianFuelFavoriteList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CanadianFuelFavoriteList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element CanadianFuelFavoriteList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CanadianFuelFavoriteListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPCanadianFuelFavoriteListSize::dp_tclFcSxmDPCanadianFuelFavoriteListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCanadianFuelFavoriteListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPCanadianFuelFavoriteListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CanadianFuelFavoriteListSize",(tS32) 0x1f425956L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCanadianFuelFavoriteListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPCanadianFuelFavoriteListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CanadianFuelFavoriteListSize", (tS32)0x1f425956L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCanadianFuelFavoriteListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPCanadianFuelFavoriteListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPCanadianFuelFavoriteListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPCanadianFuelFavoriteListSize::tGetData() {
   vUpdate();
   return tCanadianFuelFavoriteListSize;
};
tS32 dp_tclFcSxmDPCanadianFuelFavoriteListSize::s32GetData(tU32& tCanadianFuelFavoriteListSizeParam) { 
   vUpdate();
   tCanadianFuelFavoriteListSizeParam = tCanadianFuelFavoriteListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPCanadianFuelFavoriteListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CanadianFuelFavoriteListSize", (tS32)0x1f425956L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPCanadianFuelFavoriteListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPCanadianFuelFavoriteListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPCanadianFuelFavoriteListSize::s32SetData(tU32 &tCanadianFuelFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tCanadianFuelFavoriteListSize,(tVoid*)&tCanadianFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCanadianFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPCanadianFuelFavoriteListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPCanadianFuelFavoriteListSize::s32SetData(const tU32 &tCanadianFuelFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tCanadianFuelFavoriteListSize,(tVoid*)&tCanadianFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCanadianFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPCanadianFuelFavoriteListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPCanadianFuelFavoriteListSize::u8GetData(tU32& tCanadianFuelFavoriteListSizeParam) {  
   vUpdate();
   tCanadianFuelFavoriteListSizeParam = tCanadianFuelFavoriteListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPCanadianFuelFavoriteListSize::vSetData(tU32 &tCanadianFuelFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tCanadianFuelFavoriteListSize,(tVoid*)&tCanadianFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCanadianFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPCanadianFuelFavoriteListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPCanadianFuelFavoriteListSize::vSetData(const tU32 &tCanadianFuelFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tCanadianFuelFavoriteListSize,(tVoid*)&tCanadianFuelFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCanadianFuelFavoriteListSizeParam' in function 'dp_tclFcSxmDPCanadianFuelFavoriteListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPCanadianFuelFavoriteListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPCanadianFuelFavoriteListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "CanadianFuelFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPCanadianFuelFavoriteListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "CanadianFuelFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPCanadianFuelFavoriteListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CanadianFuelFavoriteListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element CanadianFuelFavoriteListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StocksFavoriteList"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPStocksFavoriteList::dp_tclFcSxmDPStocksFavoriteList(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPStocksFavoriteList::s32SetData( dpStockListElement* tStocksFavoriteListParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("StocksFavoriteList", (tS32)0x5496f983);
   (tVoid)myDpElem.bFillData((tVoid*)tStocksFavoriteListParam, ((tU32)sizeof(dpStockListElement))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPStocksFavoriteList::s32GetData(dpStockListElement* tStocksFavoriteListParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("StocksFavoriteList", (tS32)0x5496f983);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpStockListElement)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpStockListElement));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tStocksFavoriteListParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpStockListElement));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPStocksFavoriteList::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPStocksFavoriteList::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPStocksFavoriteList::u16GetData(dpStockListElement* tStocksFavoriteListParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tStocksFavoriteListParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPStocksFavoriteList::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "StocksFavoriteList", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPStocksFavoriteList::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "StocksFavoriteList", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPStocksFavoriteList::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StocksFavoriteList", DP_U32_POOL_ID_FCSXMDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
		}
		else
		{
			fprintf(stdout,"Element StocksFavoriteList has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StocksFavoriteListSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPStocksFavoriteListSize::dp_tclFcSxmDPStocksFavoriteListSize(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStocksFavoriteListSize,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPStocksFavoriteListSize::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StocksFavoriteListSize",(tS32) 0x84975e62);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tStocksFavoriteListSize = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPStocksFavoriteListSize::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StocksFavoriteListSize", (tS32)0x84975e62);
   (tVoid)myDpElem.bFillData((tVoid*)&tStocksFavoriteListSize, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPStocksFavoriteListSize::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPStocksFavoriteListSize::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPStocksFavoriteListSize::tGetData() {
   vUpdate();
   return tStocksFavoriteListSize;
};
tS32 dp_tclFcSxmDPStocksFavoriteListSize::s32GetData(tU32& tStocksFavoriteListSizeParam) { 
   vUpdate();
   tStocksFavoriteListSizeParam = tStocksFavoriteListSize;
   return _s32Status;
}
tS32 dp_tclFcSxmDPStocksFavoriteListSize::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StocksFavoriteListSize", (tS32)0x84975e62);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPStocksFavoriteListSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPStocksFavoriteListSize::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPStocksFavoriteListSize::s32SetData(tU32 &tStocksFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tStocksFavoriteListSize,(tVoid*)&tStocksFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStocksFavoriteListSizeParam' in function 'dp_tclFcSxmDPStocksFavoriteListSize::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPStocksFavoriteListSize::s32SetData(const tU32 &tStocksFavoriteListSizeParam) {
   //init parameter
   (tVoid)memcpy(&tStocksFavoriteListSize,(tVoid*)&tStocksFavoriteListSizeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStocksFavoriteListSizeParam' in function 'dp_tclFcSxmDPStocksFavoriteListSize::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPStocksFavoriteListSize::u8GetData(tU32& tStocksFavoriteListSizeParam) {  
   vUpdate();
   tStocksFavoriteListSizeParam = tStocksFavoriteListSize;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPStocksFavoriteListSize::vSetData(tU32 &tStocksFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tStocksFavoriteListSize,(tVoid*)&tStocksFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStocksFavoriteListSizeParam' in function 'dp_tclFcSxmDPStocksFavoriteListSize::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPStocksFavoriteListSize::vSetData(const tU32 &tStocksFavoriteListSizeParam) { 
   //init parameter
   (tVoid)memcpy(&tStocksFavoriteListSize,(tVoid*)&tStocksFavoriteListSizeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStocksFavoriteListSizeParam' in function 'dp_tclFcSxmDPStocksFavoriteListSize::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPStocksFavoriteListSize::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPStocksFavoriteListSize::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "StocksFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPStocksFavoriteListSize::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "StocksFavoriteListSize", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPStocksFavoriteListSize::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StocksFavoriteListSize", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element StocksFavoriteListSize has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SmsCfgVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSmsCfgVersion::dp_tclFcSxmDPSmsCfgVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSmsCfgVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPSmsCfgVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SmsCfgVersion",(tS32) 0x42bcf1a9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSmsCfgVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPSmsCfgVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SmsCfgVersion", (tS32)0x42bcf1a9);
   (tVoid)myDpElem.bFillData((tVoid*)&tSmsCfgVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPSmsCfgVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPSmsCfgVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPSmsCfgVersion::tGetData() {
   vUpdate();
   return tSmsCfgVersion;
};
tS32 dp_tclFcSxmDPSmsCfgVersion::s32GetData(tU32& tSmsCfgVersionParam) { 
   vUpdate();
   tSmsCfgVersionParam = tSmsCfgVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPSmsCfgVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SmsCfgVersion", (tS32)0x42bcf1a9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPSmsCfgVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPSmsCfgVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPSmsCfgVersion::s32SetData(tU32 &tSmsCfgVersionParam) {
   //init parameter
   (tVoid)memcpy(&tSmsCfgVersion,(tVoid*)&tSmsCfgVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSmsCfgVersionParam' in function 'dp_tclFcSxmDPSmsCfgVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPSmsCfgVersion::s32SetData(const tU32 &tSmsCfgVersionParam) {
   //init parameter
   (tVoid)memcpy(&tSmsCfgVersion,(tVoid*)&tSmsCfgVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSmsCfgVersionParam' in function 'dp_tclFcSxmDPSmsCfgVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPSmsCfgVersion::u8GetData(tU32& tSmsCfgVersionParam) {  
   vUpdate();
   tSmsCfgVersionParam = tSmsCfgVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPSmsCfgVersion::vSetData(tU32 &tSmsCfgVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tSmsCfgVersion,(tVoid*)&tSmsCfgVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSmsCfgVersionParam' in function 'dp_tclFcSxmDPSmsCfgVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPSmsCfgVersion::vSetData(const tU32 &tSmsCfgVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tSmsCfgVersion,(tVoid*)&tSmsCfgVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSmsCfgVersionParam' in function 'dp_tclFcSxmDPSmsCfgVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPSmsCfgVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPSmsCfgVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SmsCfgVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSmsCfgVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SmsCfgVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSmsCfgVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SmsCfgVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element SmsCfgVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPFuelVersion::dp_tclFcSxmDPFuelVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFuelVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPFuelVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FuelVersion",(tS32) 0x39531d42);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tFuelVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPFuelVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FuelVersion", (tS32)0x39531d42);
   (tVoid)myDpElem.bFillData((tVoid*)&tFuelVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPFuelVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPFuelVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPFuelVersion::tGetData() {
   vUpdate();
   return tFuelVersion;
};
tS32 dp_tclFcSxmDPFuelVersion::s32GetData(tU32& tFuelVersionParam) { 
   vUpdate();
   tFuelVersionParam = tFuelVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPFuelVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FuelVersion", (tS32)0x39531d42);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPFuelVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPFuelVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPFuelVersion::s32SetData(tU32 &tFuelVersionParam) {
   //init parameter
   (tVoid)memcpy(&tFuelVersion,(tVoid*)&tFuelVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelVersionParam' in function 'dp_tclFcSxmDPFuelVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPFuelVersion::s32SetData(const tU32 &tFuelVersionParam) {
   //init parameter
   (tVoid)memcpy(&tFuelVersion,(tVoid*)&tFuelVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelVersionParam' in function 'dp_tclFcSxmDPFuelVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPFuelVersion::u8GetData(tU32& tFuelVersionParam) {  
   vUpdate();
   tFuelVersionParam = tFuelVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPFuelVersion::vSetData(tU32 &tFuelVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelVersion,(tVoid*)&tFuelVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tFuelVersionParam' in function 'dp_tclFcSxmDPFuelVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPFuelVersion::vSetData(const tU32 &tFuelVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelVersion,(tVoid*)&tFuelVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tFuelVersionParam' in function 'dp_tclFcSxmDPFuelVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPFuelVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPFuelVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "FuelVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPFuelVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "FuelVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPFuelVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element FuelVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrafficVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPTrafficVersion::dp_tclFcSxmDPTrafficVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrafficVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPTrafficVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrafficVersion",(tS32) 0xbf493719);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tTrafficVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPTrafficVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrafficVersion", (tS32)0xbf493719);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrafficVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPTrafficVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPTrafficVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPTrafficVersion::tGetData() {
   vUpdate();
   return tTrafficVersion;
};
tS32 dp_tclFcSxmDPTrafficVersion::s32GetData(tU32& tTrafficVersionParam) { 
   vUpdate();
   tTrafficVersionParam = tTrafficVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPTrafficVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrafficVersion", (tS32)0xbf493719);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPTrafficVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPTrafficVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPTrafficVersion::s32SetData(tU32 &tTrafficVersionParam) {
   //init parameter
   (tVoid)memcpy(&tTrafficVersion,(tVoid*)&tTrafficVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrafficVersionParam' in function 'dp_tclFcSxmDPTrafficVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPTrafficVersion::s32SetData(const tU32 &tTrafficVersionParam) {
   //init parameter
   (tVoid)memcpy(&tTrafficVersion,(tVoid*)&tTrafficVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrafficVersionParam' in function 'dp_tclFcSxmDPTrafficVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPTrafficVersion::u8GetData(tU32& tTrafficVersionParam) {  
   vUpdate();
   tTrafficVersionParam = tTrafficVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPTrafficVersion::vSetData(tU32 &tTrafficVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tTrafficVersion,(tVoid*)&tTrafficVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tTrafficVersionParam' in function 'dp_tclFcSxmDPTrafficVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPTrafficVersion::vSetData(const tU32 &tTrafficVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tTrafficVersion,(tVoid*)&tTrafficVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tTrafficVersionParam' in function 'dp_tclFcSxmDPTrafficVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPTrafficVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPTrafficVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "TrafficVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPTrafficVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "TrafficVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPTrafficVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrafficVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element TrafficVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MoviesVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPMoviesVersion::dp_tclFcSxmDPMoviesVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMoviesVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPMoviesVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MoviesVersion",(tS32) 0xf7732fa1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tMoviesVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPMoviesVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MoviesVersion", (tS32)0xf7732fa1);
   (tVoid)myDpElem.bFillData((tVoid*)&tMoviesVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPMoviesVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPMoviesVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPMoviesVersion::tGetData() {
   vUpdate();
   return tMoviesVersion;
};
tS32 dp_tclFcSxmDPMoviesVersion::s32GetData(tU32& tMoviesVersionParam) { 
   vUpdate();
   tMoviesVersionParam = tMoviesVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPMoviesVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MoviesVersion", (tS32)0xf7732fa1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPMoviesVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPMoviesVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPMoviesVersion::s32SetData(tU32 &tMoviesVersionParam) {
   //init parameter
   (tVoid)memcpy(&tMoviesVersion,(tVoid*)&tMoviesVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMoviesVersionParam' in function 'dp_tclFcSxmDPMoviesVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPMoviesVersion::s32SetData(const tU32 &tMoviesVersionParam) {
   //init parameter
   (tVoid)memcpy(&tMoviesVersion,(tVoid*)&tMoviesVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMoviesVersionParam' in function 'dp_tclFcSxmDPMoviesVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPMoviesVersion::u8GetData(tU32& tMoviesVersionParam) {  
   vUpdate();
   tMoviesVersionParam = tMoviesVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPMoviesVersion::vSetData(tU32 &tMoviesVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tMoviesVersion,(tVoid*)&tMoviesVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tMoviesVersionParam' in function 'dp_tclFcSxmDPMoviesVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPMoviesVersion::vSetData(const tU32 &tMoviesVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tMoviesVersion,(tVoid*)&tMoviesVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tMoviesVersionParam' in function 'dp_tclFcSxmDPMoviesVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPMoviesVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPMoviesVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "MoviesVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPMoviesVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "MoviesVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPMoviesVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MoviesVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element MoviesVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AgwVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPAgwVersion::dp_tclFcSxmDPAgwVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAgwVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPAgwVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AgwVersion",(tS32) 0xa9f9d59);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tAgwVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPAgwVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AgwVersion", (tS32)0xa9f9d59);
   (tVoid)myDpElem.bFillData((tVoid*)&tAgwVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPAgwVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPAgwVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPAgwVersion::tGetData() {
   vUpdate();
   return tAgwVersion;
};
tS32 dp_tclFcSxmDPAgwVersion::s32GetData(tU32& tAgwVersionParam) { 
   vUpdate();
   tAgwVersionParam = tAgwVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPAgwVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AgwVersion", (tS32)0xa9f9d59);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPAgwVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPAgwVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPAgwVersion::s32SetData(tU32 &tAgwVersionParam) {
   //init parameter
   (tVoid)memcpy(&tAgwVersion,(tVoid*)&tAgwVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAgwVersionParam' in function 'dp_tclFcSxmDPAgwVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPAgwVersion::s32SetData(const tU32 &tAgwVersionParam) {
   //init parameter
   (tVoid)memcpy(&tAgwVersion,(tVoid*)&tAgwVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAgwVersionParam' in function 'dp_tclFcSxmDPAgwVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPAgwVersion::u8GetData(tU32& tAgwVersionParam) {  
   vUpdate();
   tAgwVersionParam = tAgwVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPAgwVersion::vSetData(tU32 &tAgwVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tAgwVersion,(tVoid*)&tAgwVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tAgwVersionParam' in function 'dp_tclFcSxmDPAgwVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPAgwVersion::vSetData(const tU32 &tAgwVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tAgwVersion,(tVoid*)&tAgwVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tAgwVersionParam' in function 'dp_tclFcSxmDPAgwVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPAgwVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPAgwVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "AgwVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPAgwVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "AgwVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPAgwVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AgwVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element AgwVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TabWeatherVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPTabWeatherVersion::dp_tclFcSxmDPTabWeatherVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTabWeatherVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPTabWeatherVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TabWeatherVersion",(tS32) 0xaa765f35);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tTabWeatherVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPTabWeatherVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TabWeatherVersion", (tS32)0xaa765f35);
   (tVoid)myDpElem.bFillData((tVoid*)&tTabWeatherVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPTabWeatherVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPTabWeatherVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPTabWeatherVersion::tGetData() {
   vUpdate();
   return tTabWeatherVersion;
};
tS32 dp_tclFcSxmDPTabWeatherVersion::s32GetData(tU32& tTabWeatherVersionParam) { 
   vUpdate();
   tTabWeatherVersionParam = tTabWeatherVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPTabWeatherVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TabWeatherVersion", (tS32)0xaa765f35);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPTabWeatherVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPTabWeatherVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPTabWeatherVersion::s32SetData(tU32 &tTabWeatherVersionParam) {
   //init parameter
   (tVoid)memcpy(&tTabWeatherVersion,(tVoid*)&tTabWeatherVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTabWeatherVersionParam' in function 'dp_tclFcSxmDPTabWeatherVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPTabWeatherVersion::s32SetData(const tU32 &tTabWeatherVersionParam) {
   //init parameter
   (tVoid)memcpy(&tTabWeatherVersion,(tVoid*)&tTabWeatherVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTabWeatherVersionParam' in function 'dp_tclFcSxmDPTabWeatherVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPTabWeatherVersion::u8GetData(tU32& tTabWeatherVersionParam) {  
   vUpdate();
   tTabWeatherVersionParam = tTabWeatherVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPTabWeatherVersion::vSetData(tU32 &tTabWeatherVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tTabWeatherVersion,(tVoid*)&tTabWeatherVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tTabWeatherVersionParam' in function 'dp_tclFcSxmDPTabWeatherVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPTabWeatherVersion::vSetData(const tU32 &tTabWeatherVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tTabWeatherVersion,(tVoid*)&tTabWeatherVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tTabWeatherVersionParam' in function 'dp_tclFcSxmDPTabWeatherVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPTabWeatherVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPTabWeatherVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "TabWeatherVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPTabWeatherVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "TabWeatherVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPTabWeatherVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TabWeatherVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element TabWeatherVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StocksVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPStocksVersion::dp_tclFcSxmDPStocksVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStocksVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPStocksVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StocksVersion",(tS32) 0x58ae15f1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tStocksVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPStocksVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StocksVersion", (tS32)0x58ae15f1);
   (tVoid)myDpElem.bFillData((tVoid*)&tStocksVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPStocksVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPStocksVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPStocksVersion::tGetData() {
   vUpdate();
   return tStocksVersion;
};
tS32 dp_tclFcSxmDPStocksVersion::s32GetData(tU32& tStocksVersionParam) { 
   vUpdate();
   tStocksVersionParam = tStocksVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPStocksVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StocksVersion", (tS32)0x58ae15f1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPStocksVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPStocksVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPStocksVersion::s32SetData(tU32 &tStocksVersionParam) {
   //init parameter
   (tVoid)memcpy(&tStocksVersion,(tVoid*)&tStocksVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStocksVersionParam' in function 'dp_tclFcSxmDPStocksVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPStocksVersion::s32SetData(const tU32 &tStocksVersionParam) {
   //init parameter
   (tVoid)memcpy(&tStocksVersion,(tVoid*)&tStocksVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStocksVersionParam' in function 'dp_tclFcSxmDPStocksVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPStocksVersion::u8GetData(tU32& tStocksVersionParam) {  
   vUpdate();
   tStocksVersionParam = tStocksVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPStocksVersion::vSetData(tU32 &tStocksVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tStocksVersion,(tVoid*)&tStocksVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStocksVersionParam' in function 'dp_tclFcSxmDPStocksVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPStocksVersion::vSetData(const tU32 &tStocksVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tStocksVersion,(tVoid*)&tStocksVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStocksVersionParam' in function 'dp_tclFcSxmDPStocksVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPStocksVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPStocksVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "StocksVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPStocksVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "StocksVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPStocksVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StocksVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element StocksVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SportsVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPSportsVersion::dp_tclFcSxmDPSportsVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSportsVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPSportsVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SportsVersion",(tS32) 0x4efe8851);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSportsVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPSportsVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SportsVersion", (tS32)0x4efe8851);
   (tVoid)myDpElem.bFillData((tVoid*)&tSportsVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPSportsVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPSportsVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPSportsVersion::tGetData() {
   vUpdate();
   return tSportsVersion;
};
tS32 dp_tclFcSxmDPSportsVersion::s32GetData(tU32& tSportsVersionParam) { 
   vUpdate();
   tSportsVersionParam = tSportsVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPSportsVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SportsVersion", (tS32)0x4efe8851);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPSportsVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPSportsVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPSportsVersion::s32SetData(tU32 &tSportsVersionParam) {
   //init parameter
   (tVoid)memcpy(&tSportsVersion,(tVoid*)&tSportsVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsVersionParam' in function 'dp_tclFcSxmDPSportsVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPSportsVersion::s32SetData(const tU32 &tSportsVersionParam) {
   //init parameter
   (tVoid)memcpy(&tSportsVersion,(tVoid*)&tSportsVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSportsVersionParam' in function 'dp_tclFcSxmDPSportsVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPSportsVersion::u8GetData(tU32& tSportsVersionParam) {  
   vUpdate();
   tSportsVersionParam = tSportsVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPSportsVersion::vSetData(tU32 &tSportsVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsVersion,(tVoid*)&tSportsVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsVersionParam' in function 'dp_tclFcSxmDPSportsVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPSportsVersion::vSetData(const tU32 &tSportsVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tSportsVersion,(tVoid*)&tSportsVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSportsVersionParam' in function 'dp_tclFcSxmDPSportsVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPSportsVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPSportsVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "SportsVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "SportsVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPSportsVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SportsVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element SportsVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CanadianFuelVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPCanadianFuelVersion::dp_tclFcSxmDPCanadianFuelVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCanadianFuelVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPCanadianFuelVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CanadianFuelVersion",(tS32) 0xc43f9fd5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCanadianFuelVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPCanadianFuelVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CanadianFuelVersion", (tS32)0xc43f9fd5);
   (tVoid)myDpElem.bFillData((tVoid*)&tCanadianFuelVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPCanadianFuelVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPCanadianFuelVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPCanadianFuelVersion::tGetData() {
   vUpdate();
   return tCanadianFuelVersion;
};
tS32 dp_tclFcSxmDPCanadianFuelVersion::s32GetData(tU32& tCanadianFuelVersionParam) { 
   vUpdate();
   tCanadianFuelVersionParam = tCanadianFuelVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPCanadianFuelVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CanadianFuelVersion", (tS32)0xc43f9fd5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPCanadianFuelVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPCanadianFuelVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPCanadianFuelVersion::s32SetData(tU32 &tCanadianFuelVersionParam) {
   //init parameter
   (tVoid)memcpy(&tCanadianFuelVersion,(tVoid*)&tCanadianFuelVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCanadianFuelVersionParam' in function 'dp_tclFcSxmDPCanadianFuelVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPCanadianFuelVersion::s32SetData(const tU32 &tCanadianFuelVersionParam) {
   //init parameter
   (tVoid)memcpy(&tCanadianFuelVersion,(tVoid*)&tCanadianFuelVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCanadianFuelVersionParam' in function 'dp_tclFcSxmDPCanadianFuelVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPCanadianFuelVersion::u8GetData(tU32& tCanadianFuelVersionParam) {  
   vUpdate();
   tCanadianFuelVersionParam = tCanadianFuelVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPCanadianFuelVersion::vSetData(tU32 &tCanadianFuelVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tCanadianFuelVersion,(tVoid*)&tCanadianFuelVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCanadianFuelVersionParam' in function 'dp_tclFcSxmDPCanadianFuelVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPCanadianFuelVersion::vSetData(const tU32 &tCanadianFuelVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tCanadianFuelVersion,(tVoid*)&tCanadianFuelVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCanadianFuelVersionParam' in function 'dp_tclFcSxmDPCanadianFuelVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPCanadianFuelVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPCanadianFuelVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "CanadianFuelVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPCanadianFuelVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "CanadianFuelVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPCanadianFuelVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CanadianFuelVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element CanadianFuelVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "WsAlertsVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPWsAlertsVersion::dp_tclFcSxmDPWsAlertsVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tWsAlertsVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPWsAlertsVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("WsAlertsVersion",(tS32) 0x895d478f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tWsAlertsVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPWsAlertsVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("WsAlertsVersion", (tS32)0x895d478f);
   (tVoid)myDpElem.bFillData((tVoid*)&tWsAlertsVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPWsAlertsVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPWsAlertsVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPWsAlertsVersion::tGetData() {
   vUpdate();
   return tWsAlertsVersion;
};
tS32 dp_tclFcSxmDPWsAlertsVersion::s32GetData(tU32& tWsAlertsVersionParam) { 
   vUpdate();
   tWsAlertsVersionParam = tWsAlertsVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPWsAlertsVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("WsAlertsVersion", (tS32)0x895d478f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPWsAlertsVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPWsAlertsVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPWsAlertsVersion::s32SetData(tU32 &tWsAlertsVersionParam) {
   //init parameter
   (tVoid)memcpy(&tWsAlertsVersion,(tVoid*)&tWsAlertsVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tWsAlertsVersionParam' in function 'dp_tclFcSxmDPWsAlertsVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPWsAlertsVersion::s32SetData(const tU32 &tWsAlertsVersionParam) {
   //init parameter
   (tVoid)memcpy(&tWsAlertsVersion,(tVoid*)&tWsAlertsVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tWsAlertsVersionParam' in function 'dp_tclFcSxmDPWsAlertsVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPWsAlertsVersion::u8GetData(tU32& tWsAlertsVersionParam) {  
   vUpdate();
   tWsAlertsVersionParam = tWsAlertsVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPWsAlertsVersion::vSetData(tU32 &tWsAlertsVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tWsAlertsVersion,(tVoid*)&tWsAlertsVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tWsAlertsVersionParam' in function 'dp_tclFcSxmDPWsAlertsVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPWsAlertsVersion::vSetData(const tU32 &tWsAlertsVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tWsAlertsVersion,(tVoid*)&tWsAlertsVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tWsAlertsVersionParam' in function 'dp_tclFcSxmDPWsAlertsVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPWsAlertsVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPWsAlertsVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "WsAlertsVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPWsAlertsVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "WsAlertsVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPWsAlertsVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: WsAlertsVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element WsAlertsVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ParkingVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPParkingVersion::dp_tclFcSxmDPParkingVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tParkingVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPParkingVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ParkingVersion",(tS32) 0xd9bc7f36);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tParkingVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPParkingVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ParkingVersion", (tS32)0xd9bc7f36);
   (tVoid)myDpElem.bFillData((tVoid*)&tParkingVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPParkingVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPParkingVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPParkingVersion::tGetData() {
   vUpdate();
   return tParkingVersion;
};
tS32 dp_tclFcSxmDPParkingVersion::s32GetData(tU32& tParkingVersionParam) { 
   vUpdate();
   tParkingVersionParam = tParkingVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPParkingVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ParkingVersion", (tS32)0xd9bc7f36);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPParkingVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPParkingVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPParkingVersion::s32SetData(tU32 &tParkingVersionParam) {
   //init parameter
   (tVoid)memcpy(&tParkingVersion,(tVoid*)&tParkingVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tParkingVersionParam' in function 'dp_tclFcSxmDPParkingVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPParkingVersion::s32SetData(const tU32 &tParkingVersionParam) {
   //init parameter
   (tVoid)memcpy(&tParkingVersion,(tVoid*)&tParkingVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tParkingVersionParam' in function 'dp_tclFcSxmDPParkingVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPParkingVersion::u8GetData(tU32& tParkingVersionParam) {  
   vUpdate();
   tParkingVersionParam = tParkingVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPParkingVersion::vSetData(tU32 &tParkingVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tParkingVersion,(tVoid*)&tParkingVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tParkingVersionParam' in function 'dp_tclFcSxmDPParkingVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPParkingVersion::vSetData(const tU32 &tParkingVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tParkingVersion,(tVoid*)&tParkingVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tParkingVersionParam' in function 'dp_tclFcSxmDPParkingVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPParkingVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPParkingVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "ParkingVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPParkingVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "ParkingVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPParkingVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ParkingVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element ParkingVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PhoneticsVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPPhoneticsVersion::dp_tclFcSxmDPPhoneticsVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPhoneticsVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPPhoneticsVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PhoneticsVersion",(tS32) 0x7fcb1e0f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tPhoneticsVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPPhoneticsVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PhoneticsVersion", (tS32)0x7fcb1e0f);
   (tVoid)myDpElem.bFillData((tVoid*)&tPhoneticsVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPPhoneticsVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPPhoneticsVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPPhoneticsVersion::tGetData() {
   vUpdate();
   return tPhoneticsVersion;
};
tS32 dp_tclFcSxmDPPhoneticsVersion::s32GetData(tU32& tPhoneticsVersionParam) { 
   vUpdate();
   tPhoneticsVersionParam = tPhoneticsVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPPhoneticsVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PhoneticsVersion", (tS32)0x7fcb1e0f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPPhoneticsVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPPhoneticsVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPPhoneticsVersion::s32SetData(tU32 &tPhoneticsVersionParam) {
   //init parameter
   (tVoid)memcpy(&tPhoneticsVersion,(tVoid*)&tPhoneticsVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPhoneticsVersionParam' in function 'dp_tclFcSxmDPPhoneticsVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPPhoneticsVersion::s32SetData(const tU32 &tPhoneticsVersionParam) {
   //init parameter
   (tVoid)memcpy(&tPhoneticsVersion,(tVoid*)&tPhoneticsVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPhoneticsVersionParam' in function 'dp_tclFcSxmDPPhoneticsVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPPhoneticsVersion::u8GetData(tU32& tPhoneticsVersionParam) {  
   vUpdate();
   tPhoneticsVersionParam = tPhoneticsVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPPhoneticsVersion::vSetData(tU32 &tPhoneticsVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tPhoneticsVersion,(tVoid*)&tPhoneticsVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPhoneticsVersionParam' in function 'dp_tclFcSxmDPPhoneticsVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPPhoneticsVersion::vSetData(const tU32 &tPhoneticsVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tPhoneticsVersion,(tVoid*)&tPhoneticsVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPhoneticsVersionParam' in function 'dp_tclFcSxmDPPhoneticsVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPPhoneticsVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPPhoneticsVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "PhoneticsVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPPhoneticsVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "PhoneticsVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPPhoneticsVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PhoneticsVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element PhoneticsVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ChannelArtVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPChannelArtVersion::dp_tclFcSxmDPChannelArtVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tChannelArtVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPChannelArtVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ChannelArtVersion",(tS32) 0x14af6ba2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tChannelArtVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPChannelArtVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ChannelArtVersion", (tS32)0x14af6ba2);
   (tVoid)myDpElem.bFillData((tVoid*)&tChannelArtVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPChannelArtVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPChannelArtVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPChannelArtVersion::tGetData() {
   vUpdate();
   return tChannelArtVersion;
};
tS32 dp_tclFcSxmDPChannelArtVersion::s32GetData(tU32& tChannelArtVersionParam) { 
   vUpdate();
   tChannelArtVersionParam = tChannelArtVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPChannelArtVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ChannelArtVersion", (tS32)0x14af6ba2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPChannelArtVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPChannelArtVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPChannelArtVersion::s32SetData(tU32 &tChannelArtVersionParam) {
   //init parameter
   (tVoid)memcpy(&tChannelArtVersion,(tVoid*)&tChannelArtVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tChannelArtVersionParam' in function 'dp_tclFcSxmDPChannelArtVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPChannelArtVersion::s32SetData(const tU32 &tChannelArtVersionParam) {
   //init parameter
   (tVoid)memcpy(&tChannelArtVersion,(tVoid*)&tChannelArtVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tChannelArtVersionParam' in function 'dp_tclFcSxmDPChannelArtVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPChannelArtVersion::u8GetData(tU32& tChannelArtVersionParam) {  
   vUpdate();
   tChannelArtVersionParam = tChannelArtVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPChannelArtVersion::vSetData(tU32 &tChannelArtVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tChannelArtVersion,(tVoid*)&tChannelArtVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tChannelArtVersionParam' in function 'dp_tclFcSxmDPChannelArtVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPChannelArtVersion::vSetData(const tU32 &tChannelArtVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tChannelArtVersion,(tVoid*)&tChannelArtVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tChannelArtVersionParam' in function 'dp_tclFcSxmDPChannelArtVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPChannelArtVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPChannelArtVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "ChannelArtVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPChannelArtVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "ChannelArtVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPChannelArtVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ChannelArtVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element ChannelArtVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StatesVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPStatesVersion::dp_tclFcSxmDPStatesVersion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStatesVersion,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPStatesVersion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StatesVersion",(tS32) 0x525eccc2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tStatesVersion = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPStatesVersion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StatesVersion", (tS32)0x525eccc2);
   (tVoid)myDpElem.bFillData((tVoid*)&tStatesVersion, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPStatesVersion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPStatesVersion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclFcSxmDPStatesVersion::tGetData() {
   vUpdate();
   return tStatesVersion;
};
tS32 dp_tclFcSxmDPStatesVersion::s32GetData(tU32& tStatesVersionParam) { 
   vUpdate();
   tStatesVersionParam = tStatesVersion;
   return _s32Status;
}
tS32 dp_tclFcSxmDPStatesVersion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StatesVersion", (tS32)0x525eccc2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPStatesVersion::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPStatesVersion::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPStatesVersion::s32SetData(tU32 &tStatesVersionParam) {
   //init parameter
   (tVoid)memcpy(&tStatesVersion,(tVoid*)&tStatesVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStatesVersionParam' in function 'dp_tclFcSxmDPStatesVersion::vSetData(tU32)' could be made const reference
tS32 dp_tclFcSxmDPStatesVersion::s32SetData(const tU32 &tStatesVersionParam) {
   //init parameter
   (tVoid)memcpy(&tStatesVersion,(tVoid*)&tStatesVersionParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStatesVersionParam' in function 'dp_tclFcSxmDPStatesVersion::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPStatesVersion::u8GetData(tU32& tStatesVersionParam) {  
   vUpdate();
   tStatesVersionParam = tStatesVersion;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPStatesVersion::vSetData(tU32 &tStatesVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tStatesVersion,(tVoid*)&tStatesVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStatesVersionParam' in function 'dp_tclFcSxmDPStatesVersion::vSetData(tU32)' could be made const reference
tVoid dp_tclFcSxmDPStatesVersion::vSetData(const tU32 &tStatesVersionParam) { 
   //init parameter
   (tVoid)memcpy(&tStatesVersion,(tVoid*)&tStatesVersionParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStatesVersionParam' in function 'dp_tclFcSxmDPStatesVersion::vSetData(tU32)' could be made const reference
tU8   dp_tclFcSxmDPStatesVersion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPStatesVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "StatesVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPStatesVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "StatesVersion", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPStatesVersion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StatesVersion", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element StatesVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PresetType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPPresetType::dp_tclFcSxmDPPresetType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPresetType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPPresetType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PresetType",(tS32) 0xc91a315);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPresetType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPPresetType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PresetType", (tS32)0xc91a315);
   (tVoid)myDpElem.bFillData((tVoid*)&tPresetType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPPresetType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPPresetType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFcSxmDPPresetType::tGetData() {
   vUpdate();
   return tPresetType;
};
tS32 dp_tclFcSxmDPPresetType::s32GetData(tU8& tPresetTypeParam) { 
   vUpdate();
   tPresetTypeParam = tPresetType;
   return _s32Status;
}
tS32 dp_tclFcSxmDPPresetType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PresetType", (tS32)0xc91a315);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPPresetType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPPresetType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPPresetType::s32SetData(tU8 &tPresetTypeParam) {
   //init parameter
   (tVoid)memcpy(&tPresetType,(tVoid*)&tPresetTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPresetTypeParam' in function 'dp_tclFcSxmDPPresetType::vSetData(tU8)' could be made const reference
tS32 dp_tclFcSxmDPPresetType::s32SetData(const tU8 &tPresetTypeParam) {
   //init parameter
   (tVoid)memcpy(&tPresetType,(tVoid*)&tPresetTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPresetTypeParam' in function 'dp_tclFcSxmDPPresetType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPPresetType::u8GetData(tU8& tPresetTypeParam) {  
   vUpdate();
   tPresetTypeParam = tPresetType;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPPresetType::vSetData(tU8 &tPresetTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tPresetType,(tVoid*)&tPresetTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPresetTypeParam' in function 'dp_tclFcSxmDPPresetType::vSetData(tU8)' could be made const reference
tVoid dp_tclFcSxmDPPresetType::vSetData(const tU8 &tPresetTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tPresetType,(tVoid*)&tPresetTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPresetTypeParam' in function 'dp_tclFcSxmDPPresetType::vSetData(tU8)' could be made const reference
tU8   dp_tclFcSxmDPPresetType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPPresetType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "PresetType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPPresetType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "PresetType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPPresetType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PresetType", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element PresetType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DpEndUserCurrent"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPDpEndUserCurrent::dp_tclFcSxmDPDpEndUserCurrent(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDpEndUserCurrent,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFcSxmDPDpEndUserCurrent::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DpEndUserCurrent",(tS32) 0x96a35491);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDpEndUserCurrent = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFcSxmDPDpEndUserCurrent::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DpEndUserCurrent", (tS32)0x96a35491);
   (tVoid)myDpElem.bFillData((tVoid*)&tDpEndUserCurrent, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFcSxmDPDpEndUserCurrent::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFcSxmDPDpEndUserCurrent::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFcSxmDPDpEndUserCurrent::tGetData() {
   vUpdate();
   return tDpEndUserCurrent;
};
tS32 dp_tclFcSxmDPDpEndUserCurrent::s32GetData(tU8& tDpEndUserCurrentParam) { 
   vUpdate();
   tDpEndUserCurrentParam = tDpEndUserCurrent;
   return _s32Status;
}
tS32 dp_tclFcSxmDPDpEndUserCurrent::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DpEndUserCurrent", (tS32)0x96a35491);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFcSxmDPDpEndUserCurrent::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFcSxmDPDpEndUserCurrent::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFcSxmDPDpEndUserCurrent::s32SetData(tU8 &tDpEndUserCurrentParam) {
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclFcSxmDPDpEndUserCurrent::vSetData(tU8)' could be made const reference
tS32 dp_tclFcSxmDPDpEndUserCurrent::s32SetData(const tU8 &tDpEndUserCurrentParam) {
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclFcSxmDPDpEndUserCurrent::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFcSxmDPDpEndUserCurrent::u8GetData(tU8& tDpEndUserCurrentParam) {  
   vUpdate();
   tDpEndUserCurrentParam = tDpEndUserCurrent;
   return _u8DataStatus;
}
tVoid dp_tclFcSxmDPDpEndUserCurrent::vSetData(tU8 &tDpEndUserCurrentParam) { 
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclFcSxmDPDpEndUserCurrent::vSetData(tU8)' could be made const reference
tVoid dp_tclFcSxmDPDpEndUserCurrent::vSetData(const tU8 &tDpEndUserCurrentParam) { 
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclFcSxmDPDpEndUserCurrent::vSetData(tU8)' could be made const reference
tU8   dp_tclFcSxmDPDpEndUserCurrent::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFcSxmDPDpEndUserCurrent::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDP, "DpEndUserCurrent", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPDpEndUserCurrent::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDP, "DpEndUserCurrent", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFcSxmDPDpEndUserCurrent::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DpEndUserCurrent", DP_U32_POOL_ID_FCSXMDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDP);
   }
   else
   {
      fprintf(stdout,"Element DpEndUserCurrent has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
