#ifndef _DP_FI_FCMCANTCUDP_H
#define _DP_FI_FCMCANTCUDP_H

extern tVoid vInitFCMcanTcuDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);





//lint -e750
#define FC_MCAN_TCU_S_IMPORT_INTERFACE_DP 
#include "../../di_middleware_server/components/fc_mcan_tcu/config/Interfaces/fc_mcan_tcu_dp_if.h"
//lint +e750




class dp_tclFCMcanTcuDpDriverUploadPermitDate{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TDriverUploadPermitDate tDriverUploadPermitDate;
   
public:
   dp_tclFCMcanTcuDpDriverUploadPermitDate(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpDriverUploadPermitDate() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TDriverUploadPermitDate tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TDriverUploadPermitDate& tDriverUploadPermitDateParam);
   tVoid operator>>(TDriverUploadPermitDate& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TDriverUploadPermitDate &tDriverUploadPermitDateParam);
   tS32  s32SetData(const TDriverUploadPermitDate &tDriverUploadPermitDateParam);
   tVoid operator<<(TDriverUploadPermitDate oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TDriverUploadPermitDate& tDriverUploadPermitDateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TDriverUploadPermitDate& tDriverUploadPermitDateParam);
   tVoid vSetData(const TDriverUploadPermitDate& tDriverUploadPermitDateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpDriverUploadPermitStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tDriverUploadPermitStatus;
   
public:
   dp_tclFCMcanTcuDpDriverUploadPermitStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpDriverUploadPermitStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tDriverUploadPermitStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tDriverUploadPermitStatusParam);
   tS32  s32SetData(const tBool &tDriverUploadPermitStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tDriverUploadPermitStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tDriverUploadPermitStatusParam);
   tVoid vSetData(const tBool& tDriverUploadPermitStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpPrivacyModeStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tPrivacyModeStatus;
   
public:
   dp_tclFCMcanTcuDpPrivacyModeStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpPrivacyModeStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tPrivacyModeStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tPrivacyModeStatusParam);
   tS32  s32SetData(const tBool &tPrivacyModeStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tPrivacyModeStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tPrivacyModeStatusParam);
   tVoid vSetData(const tBool& tPrivacyModeStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpConnectionHistory{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tConnectionHistory;
   
public:
   dp_tclFCMcanTcuDpConnectionHistory(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpConnectionHistory() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tConnectionHistoryParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tConnectionHistoryParam);
   tS32  s32SetData(const tBool &tConnectionHistoryParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tConnectionHistoryParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tConnectionHistoryParam);
   tVoid vSetData(const tBool& tConnectionHistoryParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpSimulatedDate{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSimulatedDate tSimulatedDate;
   
public:
   dp_tclFCMcanTcuDpSimulatedDate(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpSimulatedDate() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSimulatedDate tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSimulatedDate& tSimulatedDateParam);
   tVoid operator>>(TSimulatedDate& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSimulatedDate &tSimulatedDateParam);
   tS32  s32SetData(const TSimulatedDate &tSimulatedDateParam);
   tVoid operator<<(TSimulatedDate oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSimulatedDate& tSimulatedDateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSimulatedDate& tSimulatedDateParam);
   tVoid vSetData(const TSimulatedDate& tSimulatedDateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpDistanceUnit{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDistanceUnit;
   
public:
   dp_tclFCMcanTcuDpDistanceUnit(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpDistanceUnit() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDistanceUnitParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDistanceUnitParam);
   tS32  s32SetData(const tU8 &tDistanceUnitParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDistanceUnitParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDistanceUnitParam);
   tVoid vSetData(const tU8& tDistanceUnitParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpMapVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCMcanTcuDpMapVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCMcanTcuDpMapVersion() {};

   //read access for pool element 
   tS32  s32GetData(tString &tMapVersionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tMapVersionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tMapVersionParam);
   tS32 s32SetData(const tString &tMapVersionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tMapVersionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tMapVersionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tMapVersionParam);
   tVoid vSetData(const tString &tMapVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCMcanTcuDpTcuHw{
private:
   tU8 _u8DataStatus;
public:
   dp_tclFCMcanTcuDpTcuHw(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclFCMcanTcuDpTcuHw(){
   };
   
   tU8   u8GetData(tString &tTcuHwParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tTcuHwParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tTcuHwParam);
    tVoid vSetData(const tString &tTcuHwParam);
    tVoid vSetData(tString &tTcuHwParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tTcuHwParam, tU16 u16Len);

};

class dp_tclFCMcanTcuDpTcuSw{
private:
   tU8 _u8DataStatus;
public:
   dp_tclFCMcanTcuDpTcuSw(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclFCMcanTcuDpTcuSw(){
   };
   
   tU8   u8GetData(tString &tTcuSwParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tTcuSwParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tTcuSwParam);
    tVoid vSetData(const tString &tTcuSwParam);
    tVoid vSetData(tString &tTcuSwParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tTcuSwParam, tU16 u16Len);

};

#endif
