#ifndef _DP_FI_METERDP_H
#define _DP_FI_METERDP_H

extern tVoid vInitmeterDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclmeterDpAudioChannel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tAudioChannel;
   
public:
   dp_tclmeterDpAudioChannel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclmeterDpAudioChannel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tAudioChannelParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tAudioChannelParam);
   tS32  s32SetData(const tBool &tAudioChannelParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tAudioChannelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tAudioChannelParam);
   tVoid vSetData(const tBool& tAudioChannelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclmeterDpNaviGen1Channel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tNaviGen1Channel;
   
public:
   dp_tclmeterDpNaviGen1Channel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclmeterDpNaviGen1Channel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tNaviGen1ChannelParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tNaviGen1ChannelParam);
   tS32  s32SetData(const tBool &tNaviGen1ChannelParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tNaviGen1ChannelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tNaviGen1ChannelParam);
   tVoid vSetData(const tBool& tNaviGen1ChannelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclmeterDpNaviGen2Channel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tNaviGen2Channel;
   
public:
   dp_tclmeterDpNaviGen2Channel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclmeterDpNaviGen2Channel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tNaviGen2ChannelParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tNaviGen2ChannelParam);
   tS32  s32SetData(const tBool &tNaviGen2ChannelParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tNaviGen2ChannelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tNaviGen2ChannelParam);
   tVoid vSetData(const tBool& tNaviGen2ChannelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclmeterDpDistanceUnit{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDistanceUnit;
   
public:
   dp_tclmeterDpDistanceUnit(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclmeterDpDistanceUnit() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDistanceUnitParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDistanceUnitParam);
   tS32  s32SetData(const tU8 &tDistanceUnitParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDistanceUnitParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDistanceUnitParam);
   tVoid vSetData(const tU8& tDistanceUnitParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
