
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclmeterDp.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioChannel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclmeterDpAudioChannel::dp_tclmeterDpAudioChannel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioChannel,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclmeterDpAudioChannel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioChannel",(tS32) 0xff7a7b7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tAudioChannel = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclmeterDpAudioChannel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioChannel", (tS32)0xff7a7b7);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioChannel, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclmeterDpAudioChannel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclmeterDpAudioChannel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclmeterDpAudioChannel::tGetData() {
   vUpdate();
   return tAudioChannel;
};
tS32 dp_tclmeterDpAudioChannel::s32GetData(tBool& tAudioChannelParam) { 
   vUpdate();
   tAudioChannelParam = tAudioChannel;
   return _s32Status;
}
tS32 dp_tclmeterDpAudioChannel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioChannel", (tS32)0xff7a7b7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclmeterDpAudioChannel::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclmeterDpAudioChannel::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclmeterDpAudioChannel::s32SetData(tBool &tAudioChannelParam) {
   //init parameter
   (tVoid)memcpy(&tAudioChannel,(tVoid*)&tAudioChannelParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioChannelParam' in function 'dp_tclmeterDpAudioChannel::vSetData(tBool)' could be made const reference
tS32 dp_tclmeterDpAudioChannel::s32SetData(const tBool &tAudioChannelParam) {
   //init parameter
   (tVoid)memcpy(&tAudioChannel,(tVoid*)&tAudioChannelParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioChannelParam' in function 'dp_tclmeterDpAudioChannel::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclmeterDpAudioChannel::u8GetData(tBool& tAudioChannelParam) {  
   vUpdate();
   tAudioChannelParam = tAudioChannel;
   return _u8DataStatus;
}
tVoid dp_tclmeterDpAudioChannel::vSetData(tBool &tAudioChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioChannel,(tVoid*)&tAudioChannelParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioChannelParam' in function 'dp_tclmeterDpAudioChannel::vSetData(tBool)' could be made const reference
tVoid dp_tclmeterDpAudioChannel::vSetData(const tBool &tAudioChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioChannel,(tVoid*)&tAudioChannelParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioChannelParam' in function 'dp_tclmeterDpAudioChannel::vSetData(tBool)' could be made const reference
tU8   dp_tclmeterDpAudioChannel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclmeterDpAudioChannel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_METERDP, "AudioChannel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpAudioChannel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_METERDP, "AudioChannel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpAudioChannel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioChannel", DP_U32_POOL_ID_METERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_METERDP);
   }
   else
   {
      fprintf(stdout,"Element AudioChannel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NaviGen1Channel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclmeterDpNaviGen1Channel::dp_tclmeterDpNaviGen1Channel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNaviGen1Channel,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclmeterDpNaviGen1Channel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NaviGen1Channel",(tS32) 0x8897452e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tNaviGen1Channel = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclmeterDpNaviGen1Channel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NaviGen1Channel", (tS32)0x8897452e);
   (tVoid)myDpElem.bFillData((tVoid*)&tNaviGen1Channel, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclmeterDpNaviGen1Channel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclmeterDpNaviGen1Channel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclmeterDpNaviGen1Channel::tGetData() {
   vUpdate();
   return tNaviGen1Channel;
};
tS32 dp_tclmeterDpNaviGen1Channel::s32GetData(tBool& tNaviGen1ChannelParam) { 
   vUpdate();
   tNaviGen1ChannelParam = tNaviGen1Channel;
   return _s32Status;
}
tS32 dp_tclmeterDpNaviGen1Channel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NaviGen1Channel", (tS32)0x8897452e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclmeterDpNaviGen1Channel::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclmeterDpNaviGen1Channel::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclmeterDpNaviGen1Channel::s32SetData(tBool &tNaviGen1ChannelParam) {
   //init parameter
   (tVoid)memcpy(&tNaviGen1Channel,(tVoid*)&tNaviGen1ChannelParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviGen1ChannelParam' in function 'dp_tclmeterDpNaviGen1Channel::vSetData(tBool)' could be made const reference
tS32 dp_tclmeterDpNaviGen1Channel::s32SetData(const tBool &tNaviGen1ChannelParam) {
   //init parameter
   (tVoid)memcpy(&tNaviGen1Channel,(tVoid*)&tNaviGen1ChannelParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviGen1ChannelParam' in function 'dp_tclmeterDpNaviGen1Channel::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclmeterDpNaviGen1Channel::u8GetData(tBool& tNaviGen1ChannelParam) {  
   vUpdate();
   tNaviGen1ChannelParam = tNaviGen1Channel;
   return _u8DataStatus;
}
tVoid dp_tclmeterDpNaviGen1Channel::vSetData(tBool &tNaviGen1ChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviGen1Channel,(tVoid*)&tNaviGen1ChannelParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNaviGen1ChannelParam' in function 'dp_tclmeterDpNaviGen1Channel::vSetData(tBool)' could be made const reference
tVoid dp_tclmeterDpNaviGen1Channel::vSetData(const tBool &tNaviGen1ChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviGen1Channel,(tVoid*)&tNaviGen1ChannelParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNaviGen1ChannelParam' in function 'dp_tclmeterDpNaviGen1Channel::vSetData(tBool)' could be made const reference
tU8   dp_tclmeterDpNaviGen1Channel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclmeterDpNaviGen1Channel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_METERDP, "NaviGen1Channel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpNaviGen1Channel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_METERDP, "NaviGen1Channel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpNaviGen1Channel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NaviGen1Channel", DP_U32_POOL_ID_METERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_METERDP);
   }
   else
   {
      fprintf(stdout,"Element NaviGen1Channel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NaviGen2Channel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclmeterDpNaviGen2Channel::dp_tclmeterDpNaviGen2Channel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNaviGen2Channel,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclmeterDpNaviGen2Channel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NaviGen2Channel",(tS32) 0x8898765b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tNaviGen2Channel = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclmeterDpNaviGen2Channel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NaviGen2Channel", (tS32)0x8898765b);
   (tVoid)myDpElem.bFillData((tVoid*)&tNaviGen2Channel, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclmeterDpNaviGen2Channel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclmeterDpNaviGen2Channel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclmeterDpNaviGen2Channel::tGetData() {
   vUpdate();
   return tNaviGen2Channel;
};
tS32 dp_tclmeterDpNaviGen2Channel::s32GetData(tBool& tNaviGen2ChannelParam) { 
   vUpdate();
   tNaviGen2ChannelParam = tNaviGen2Channel;
   return _s32Status;
}
tS32 dp_tclmeterDpNaviGen2Channel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NaviGen2Channel", (tS32)0x8898765b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclmeterDpNaviGen2Channel::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclmeterDpNaviGen2Channel::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclmeterDpNaviGen2Channel::s32SetData(tBool &tNaviGen2ChannelParam) {
   //init parameter
   (tVoid)memcpy(&tNaviGen2Channel,(tVoid*)&tNaviGen2ChannelParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviGen2ChannelParam' in function 'dp_tclmeterDpNaviGen2Channel::vSetData(tBool)' could be made const reference
tS32 dp_tclmeterDpNaviGen2Channel::s32SetData(const tBool &tNaviGen2ChannelParam) {
   //init parameter
   (tVoid)memcpy(&tNaviGen2Channel,(tVoid*)&tNaviGen2ChannelParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviGen2ChannelParam' in function 'dp_tclmeterDpNaviGen2Channel::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclmeterDpNaviGen2Channel::u8GetData(tBool& tNaviGen2ChannelParam) {  
   vUpdate();
   tNaviGen2ChannelParam = tNaviGen2Channel;
   return _u8DataStatus;
}
tVoid dp_tclmeterDpNaviGen2Channel::vSetData(tBool &tNaviGen2ChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviGen2Channel,(tVoid*)&tNaviGen2ChannelParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNaviGen2ChannelParam' in function 'dp_tclmeterDpNaviGen2Channel::vSetData(tBool)' could be made const reference
tVoid dp_tclmeterDpNaviGen2Channel::vSetData(const tBool &tNaviGen2ChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviGen2Channel,(tVoid*)&tNaviGen2ChannelParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNaviGen2ChannelParam' in function 'dp_tclmeterDpNaviGen2Channel::vSetData(tBool)' could be made const reference
tU8   dp_tclmeterDpNaviGen2Channel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclmeterDpNaviGen2Channel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_METERDP, "NaviGen2Channel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpNaviGen2Channel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_METERDP, "NaviGen2Channel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpNaviGen2Channel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NaviGen2Channel", DP_U32_POOL_ID_METERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_METERDP);
   }
   else
   {
      fprintf(stdout,"Element NaviGen2Channel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DistanceUnit"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclmeterDpDistanceUnit::dp_tclmeterDpDistanceUnit(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDistanceUnit,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclmeterDpDistanceUnit::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DistanceUnit",(tS32) 0x13b09ae7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDistanceUnit = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclmeterDpDistanceUnit::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DistanceUnit", (tS32)0x13b09ae7);
   (tVoid)myDpElem.bFillData((tVoid*)&tDistanceUnit, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclmeterDpDistanceUnit::s32GetStatus() const {return _s32Status;};
tU8   dp_tclmeterDpDistanceUnit::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclmeterDpDistanceUnit::tGetData() {
   vUpdate();
   return tDistanceUnit;
};
tS32 dp_tclmeterDpDistanceUnit::s32GetData(tU8& tDistanceUnitParam) { 
   vUpdate();
   tDistanceUnitParam = tDistanceUnit;
   return _s32Status;
}
tS32 dp_tclmeterDpDistanceUnit::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DistanceUnit", (tS32)0x13b09ae7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_METERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclmeterDpDistanceUnit::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclmeterDpDistanceUnit::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclmeterDpDistanceUnit::s32SetData(tU8 &tDistanceUnitParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclmeterDpDistanceUnit::vSetData(tU8)' could be made const reference
tS32 dp_tclmeterDpDistanceUnit::s32SetData(const tU8 &tDistanceUnitParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclmeterDpDistanceUnit::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclmeterDpDistanceUnit::u8GetData(tU8& tDistanceUnitParam) {  
   vUpdate();
   tDistanceUnitParam = tDistanceUnit;
   return _u8DataStatus;
}
tVoid dp_tclmeterDpDistanceUnit::vSetData(tU8 &tDistanceUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclmeterDpDistanceUnit::vSetData(tU8)' could be made const reference
tVoid dp_tclmeterDpDistanceUnit::vSetData(const tU8 &tDistanceUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclmeterDpDistanceUnit::vSetData(tU8)' could be made const reference
tU8   dp_tclmeterDpDistanceUnit::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclmeterDpDistanceUnit::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_METERDP, "DistanceUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpDistanceUnit::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_METERDP, "DistanceUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmeterDpDistanceUnit::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DistanceUnit", DP_U32_POOL_ID_METERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_METERDP);
   }
   else
   {
      fprintf(stdout,"Element DistanceUnit has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
