#ifndef _DP_FI_FCDUMM_H
#define _DP_FI_FCDUMM_H

extern tVoid vInitFCDumm(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclFCDummMQTTSessionType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTSessionType;
   
public:
   dp_tclFCDummMQTTSessionType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTSessionType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTSessionTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTSessionTypeParam);
   tS32  s32SetData(const tU8 &tMQTTSessionTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTSessionTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTSessionTypeParam);
   tVoid vSetData(const tU8& tMQTTSessionTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTkeepAlive{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tMQTTkeepAlive;
   
public:
   dp_tclFCDummMQTTkeepAlive(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTkeepAlive() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tMQTTkeepAliveParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tMQTTkeepAliveParam);
   tS32  s32SetData(const tU16 &tMQTTkeepAliveParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tMQTTkeepAliveParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tMQTTkeepAliveParam);
   tVoid vSetData(const tU16& tMQTTkeepAliveParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTperiodicConnectInterval{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTperiodicConnectInterval;
   
public:
   dp_tclFCDummMQTTperiodicConnectInterval(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTperiodicConnectInterval() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTperiodicConnectIntervalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTperiodicConnectIntervalParam);
   tS32  s32SetData(const tU8 &tMQTTperiodicConnectIntervalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTperiodicConnectIntervalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTperiodicConnectIntervalParam);
   tVoid vSetData(const tU8& tMQTTperiodicConnectIntervalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTPayloadCompression{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTPayloadCompression;
   
public:
   dp_tclFCDummMQTTPayloadCompression(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTPayloadCompression() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTPayloadCompressionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTPayloadCompressionParam);
   tS32  s32SetData(const tU8 &tMQTTPayloadCompressionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTPayloadCompressionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTPayloadCompressionParam);
   tVoid vSetData(const tU8& tMQTTPayloadCompressionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTPasswordConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummMQTTPasswordConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTPasswordConfig() {};

   //read access for pool element 
   tS32  s32GetData(tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tMQTTPasswordConfigParam);
   tS32 s32SetData(const tString &tMQTTPasswordConfigParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tMQTTPasswordConfigParam);
   tVoid vSetData(const tString &tMQTTPasswordConfigParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummURL{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummURL(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummURL() {};

   //read access for pool element 
   tS32  s32GetData(tString &tURLParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tURLParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tURLParam);
   tS32 s32SetData(const tString &tURLParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tURLParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tURLParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tURLParam);
   tVoid vSetData(const tString &tURLParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummPORT{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPORT;
   
public:
   dp_tclFCDummPORT(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummPORT() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPORTParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPORTParam);
   tS32  s32SetData(const tU16 &tPORTParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPORTParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPORTParam);
   tVoid vSetData(const tU16& tPORTParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTRetryCONNECTInterval{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTRetryCONNECTInterval;
   
public:
   dp_tclFCDummMQTTRetryCONNECTInterval(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTRetryCONNECTInterval() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTRetryCONNECTIntervalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTRetryCONNECTIntervalParam);
   tS32  s32SetData(const tU8 &tMQTTRetryCONNECTIntervalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTRetryCONNECTIntervalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTRetryCONNECTIntervalParam);
   tVoid vSetData(const tU8& tMQTTRetryCONNECTIntervalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTRetryCONNECTOccurrence{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTRetryCONNECTOccurrence;
   
public:
   dp_tclFCDummMQTTRetryCONNECTOccurrence(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTRetryCONNECTOccurrence() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTRetryCONNECTOccurrenceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTRetryCONNECTOccurrenceParam);
   tS32  s32SetData(const tU8 &tMQTTRetryCONNECTOccurrenceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTRetryCONNECTOccurrenceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTRetryCONNECTOccurrenceParam);
   tVoid vSetData(const tU8& tMQTTRetryCONNECTOccurrenceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTConnectionTimeOut{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTConnectionTimeOut;
   
public:
   dp_tclFCDummMQTTConnectionTimeOut(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTConnectionTimeOut() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTConnectionTimeOutParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTConnectionTimeOutParam);
   tS32  s32SetData(const tU8 &tMQTTConnectionTimeOutParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTConnectionTimeOutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTConnectionTimeOutParam);
   tVoid vSetData(const tU8& tMQTTConnectionTimeOutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTRetryPUBLISHInterval{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTRetryPUBLISHInterval;
   
public:
   dp_tclFCDummMQTTRetryPUBLISHInterval(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTRetryPUBLISHInterval() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTRetryPUBLISHIntervalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTRetryPUBLISHIntervalParam);
   tS32  s32SetData(const tU8 &tMQTTRetryPUBLISHIntervalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTRetryPUBLISHIntervalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTRetryPUBLISHIntervalParam);
   tVoid vSetData(const tU8& tMQTTRetryPUBLISHIntervalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTRetryPUBLISHOccurrence{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTRetryPUBLISHOccurrence;
   
public:
   dp_tclFCDummMQTTRetryPUBLISHOccurrence(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTRetryPUBLISHOccurrence() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTRetryPUBLISHOccurrenceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTRetryPUBLISHOccurrenceParam);
   tS32  s32SetData(const tU8 &tMQTTRetryPUBLISHOccurrenceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTRetryPUBLISHOccurrenceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTRetryPUBLISHOccurrenceParam);
   tVoid vSetData(const tU8& tMQTTRetryPUBLISHOccurrenceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTPublishTimeOut{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTPublishTimeOut;
   
public:
   dp_tclFCDummMQTTPublishTimeOut(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTPublishTimeOut() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTPublishTimeOutParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTPublishTimeOutParam);
   tS32  s32SetData(const tU8 &tMQTTPublishTimeOutParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTPublishTimeOutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTPublishTimeOutParam);
   tVoid vSetData(const tU8& tMQTTPublishTimeOutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTRetrySUBSCRIBEInterval{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTRetrySUBSCRIBEInterval;
   
public:
   dp_tclFCDummMQTTRetrySUBSCRIBEInterval(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTRetrySUBSCRIBEInterval() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTRetrySUBSCRIBEIntervalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTRetrySUBSCRIBEIntervalParam);
   tS32  s32SetData(const tU8 &tMQTTRetrySUBSCRIBEIntervalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTRetrySUBSCRIBEIntervalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTRetrySUBSCRIBEIntervalParam);
   tVoid vSetData(const tU8& tMQTTRetrySUBSCRIBEIntervalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTRetrySUBSCRIBEOccurrence;
   
public:
   dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTRetrySUBSCRIBEOccurrenceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTRetrySUBSCRIBEOccurrenceParam);
   tS32  s32SetData(const tU8 &tMQTTRetrySUBSCRIBEOccurrenceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTRetrySUBSCRIBEOccurrenceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTRetrySUBSCRIBEOccurrenceParam);
   tVoid vSetData(const tU8& tMQTTRetrySUBSCRIBEOccurrenceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTSubscribeTimeOut{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTSubscribeTimeOut;
   
public:
   dp_tclFCDummMQTTSubscribeTimeOut(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTSubscribeTimeOut() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTSubscribeTimeOutParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTSubscribeTimeOutParam);
   tS32  s32SetData(const tU8 &tMQTTSubscribeTimeOutParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTSubscribeTimeOutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTSubscribeTimeOutParam);
   tVoid vSetData(const tU8& tMQTTSubscribeTimeOutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTCleanSwitchToZlib{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tMQTTCleanSwitchToZlib;
   
public:
   dp_tclFCDummMQTTCleanSwitchToZlib(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTCleanSwitchToZlib() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tMQTTCleanSwitchToZlibParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tMQTTCleanSwitchToZlibParam);
   tS32  s32SetData(const tBool &tMQTTCleanSwitchToZlibParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tMQTTCleanSwitchToZlibParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tMQTTCleanSwitchToZlibParam);
   tVoid vSetData(const tBool& tMQTTCleanSwitchToZlibParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTCleanSwitchFromZlib{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tMQTTCleanSwitchFromZlib;
   
public:
   dp_tclFCDummMQTTCleanSwitchFromZlib(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTCleanSwitchFromZlib() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tMQTTCleanSwitchFromZlibParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tMQTTCleanSwitchFromZlibParam);
   tS32  s32SetData(const tBool &tMQTTCleanSwitchFromZlibParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tMQTTCleanSwitchFromZlibParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tMQTTCleanSwitchFromZlibParam);
   tVoid vSetData(const tBool& tMQTTCleanSwitchFromZlibParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummTLS_EXPBackOffStartDelay{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tTLS_EXPBackOffStartDelay;
   
public:
   dp_tclFCDummTLS_EXPBackOffStartDelay(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummTLS_EXPBackOffStartDelay() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tTLS_EXPBackOffStartDelayParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tTLS_EXPBackOffStartDelayParam);
   tS32  s32SetData(const tU16 &tTLS_EXPBackOffStartDelayParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tTLS_EXPBackOffStartDelayParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tTLS_EXPBackOffStartDelayParam);
   tVoid vSetData(const tU16& tTLS_EXPBackOffStartDelayParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTUsernameConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummMQTTUsernameConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTUsernameConfig() {};

   //read access for pool element 
   tS32  s32GetData(tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tMQTTUsernameConfigParam);
   tS32 s32SetData(const tString &tMQTTUsernameConfigParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tMQTTUsernameConfigParam);
   tVoid vSetData(const tString &tMQTTUsernameConfigParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTConnectionType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTConnectionType;
   
public:
   dp_tclFCDummMQTTConnectionType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTConnectionType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTConnectionTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTConnectionTypeParam);
   tS32  s32SetData(const tU8 &tMQTTConnectionTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTConnectionTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTConnectionTypeParam);
   tVoid vSetData(const tU8& tMQTTConnectionTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummVIN{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummVIN(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummVIN() {};

   //read access for pool element 
   tS32  s32GetData(tString &tVINParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tVINParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tVINParam);
   tS32 s32SetData(const tString &tVINParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tVINParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tVINParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tVINParam);
   tVoid vSetData(const tString &tVINParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummBIN{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummBIN(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummBIN() {};

   //read access for pool element 
   tS32  s32GetData(tString &tBINParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tBINParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tBINParam);
   tS32 s32SetData(const tString &tBINParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tBINParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tBINParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tBINParam);
   tVoid vSetData(const tString &tBINParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummDCMVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummDCMVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummDCMVersion() {};

   //read access for pool element 
   tS32  s32GetData(tString &tDCMVersionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tDCMVersionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tDCMVersionParam);
   tS32 s32SetData(const tString &tDCMVersionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tDCMVersionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tDCMVersionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tDCMVersionParam);
   tVoid vSetData(const tString &tDCMVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummUserID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummUserID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummUserID() {};

   //read access for pool element 
   tS32  s32GetData(tString &tUserIDParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tUserIDParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tUserIDParam);
   tS32 s32SetData(const tString &tUserIDParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tUserIDParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tUserIDParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tUserIDParam);
   tVoid vSetData(const tString &tUserIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummDRMdataReqTimeout{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tDRMdataReqTimeout;
   
public:
   dp_tclFCDummDRMdataReqTimeout(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummDRMdataReqTimeout() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tDRMdataReqTimeoutParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tDRMdataReqTimeoutParam);
   tS32  s32SetData(const tU16 &tDRMdataReqTimeoutParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tDRMdataReqTimeoutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tDRMdataReqTimeoutParam);
   tVoid vSetData(const tU16& tDRMdataReqTimeoutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummDataDictionaryVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummDataDictionaryVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummDataDictionaryVersion() {};

   //read access for pool element 
   tS32  s32GetData(tString &tDataDictionaryVersionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tDataDictionaryVersionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tDataDictionaryVersionParam);
   tS32 s32SetData(const tString &tDataDictionaryVersionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tDataDictionaryVersionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tDataDictionaryVersionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tDataDictionaryVersionParam);
   tVoid vSetData(const tString &tDataDictionaryVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummDevType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummDevType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummDevType() {};

   //read access for pool element 
   tS32  s32GetData(tString &tDevTypeParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tDevTypeParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tDevTypeParam);
   tS32 s32SetData(const tString &tDevTypeParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tDevTypeParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tDevTypeParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tDevTypeParam);
   tVoid vSetData(const tString &tDevTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTSessionTimeOut{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tMQTTSessionTimeOut;
   
public:
   dp_tclFCDummMQTTSessionTimeOut(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTSessionTimeOut() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tMQTTSessionTimeOutParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tMQTTSessionTimeOutParam);
   tS32  s32SetData(const tU16 &tMQTTSessionTimeOutParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tMQTTSessionTimeOutParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tMQTTSessionTimeOutParam);
   tVoid vSetData(const tU16& tMQTTSessionTimeOutParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummNaviUnitId{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclFCDummNaviUnitId(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummNaviUnitId() {};

   //read access for pool element 
   tS32  s32GetData(tString &tNaviUnitIdParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tNaviUnitIdParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tNaviUnitIdParam);
   tS32 s32SetData(const tString &tNaviUnitIdParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tNaviUnitIdParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tNaviUnitIdParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tNaviUnitIdParam);
   tVoid vSetData(const tString &tNaviUnitIdParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMqttLastCompressionMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMqttLastCompressionMode;
   
public:
   dp_tclFCDummMqttLastCompressionMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMqttLastCompressionMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMqttLastCompressionModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMqttLastCompressionModeParam);
   tS32  s32SetData(const tU8 &tMqttLastCompressionModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMqttLastCompressionModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMqttLastCompressionModeParam);
   tVoid vSetData(const tU8& tMqttLastCompressionModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMqttStunnelStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMqttStunnelStatus;
   
public:
   dp_tclFCDummMqttStunnelStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMqttStunnelStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMqttStunnelStatusParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMqttStunnelStatusParam);
   tS32  s32SetData(const tU8 &tMqttStunnelStatusParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMqttStunnelStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMqttStunnelStatusParam);
   tVoid vSetData(const tU8& tMqttStunnelStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummMQTTChannel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMQTTChannel;
   
public:
   dp_tclFCDummMQTTChannel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummMQTTChannel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMQTTChannelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMQTTChannelParam);
   tS32  s32SetData(const tU8 &tMQTTChannelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMQTTChannelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMQTTChannelParam);
   tVoid vSetData(const tU8& tMQTTChannelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFCDummAuthEngine{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tAuthEngine;
   
public:
   dp_tclFCDummAuthEngine(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFCDummAuthEngine() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tAuthEngineParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tAuthEngineParam);
   tS32  s32SetData(const tBool &tAuthEngineParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tAuthEngineParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tAuthEngineParam);
   tVoid vSetData(const tBool& tAuthEngineParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
