
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclFCDumm.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTSessionType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTSessionType::dp_tclFCDummMQTTSessionType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTSessionType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTSessionType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTSessionType",(tS32) 0x6c33cad4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTSessionType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTSessionType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTSessionType", (tS32)0x6c33cad4);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTSessionType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTSessionType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTSessionType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTSessionType::tGetData() {
   vUpdate();
   return tMQTTSessionType;
};
tS32 dp_tclFCDummMQTTSessionType::s32GetData(tU8& tMQTTSessionTypeParam) { 
   vUpdate();
   tMQTTSessionTypeParam = tMQTTSessionType;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTSessionType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTSessionType", (tS32)0x6c33cad4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTSessionType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTSessionType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTSessionType::s32SetData(tU8 &tMQTTSessionTypeParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTSessionType,(tVoid*)&tMQTTSessionTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTSessionTypeParam' in function 'dp_tclFCDummMQTTSessionType::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTSessionType::s32SetData(const tU8 &tMQTTSessionTypeParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTSessionType,(tVoid*)&tMQTTSessionTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTSessionTypeParam' in function 'dp_tclFCDummMQTTSessionType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTSessionType::u8GetData(tU8& tMQTTSessionTypeParam) {  
   vUpdate();
   tMQTTSessionTypeParam = tMQTTSessionType;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTSessionType::vSetData(tU8 &tMQTTSessionTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTSessionType,(tVoid*)&tMQTTSessionTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTSessionTypeParam' in function 'dp_tclFCDummMQTTSessionType::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTSessionType::vSetData(const tU8 &tMQTTSessionTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTSessionType,(tVoid*)&tMQTTSessionTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTSessionTypeParam' in function 'dp_tclFCDummMQTTSessionType::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTSessionType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTSessionType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTSessionType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTSessionType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTSessionType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTSessionType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTSessionType", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTSessionType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTkeepAlive"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTkeepAlive::dp_tclFCDummMQTTkeepAlive(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTkeepAlive,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTkeepAlive::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTkeepAlive",(tS32) 0x89fde50c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tMQTTkeepAlive = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTkeepAlive::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTkeepAlive", (tS32)0x89fde50c);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTkeepAlive, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTkeepAlive::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTkeepAlive::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclFCDummMQTTkeepAlive::tGetData() {
   vUpdate();
   return tMQTTkeepAlive;
};
tS32 dp_tclFCDummMQTTkeepAlive::s32GetData(tU16& tMQTTkeepAliveParam) { 
   vUpdate();
   tMQTTkeepAliveParam = tMQTTkeepAlive;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTkeepAlive::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTkeepAlive", (tS32)0x89fde50c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTkeepAlive::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTkeepAlive::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTkeepAlive::s32SetData(tU16 &tMQTTkeepAliveParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTkeepAlive,(tVoid*)&tMQTTkeepAliveParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTkeepAliveParam' in function 'dp_tclFCDummMQTTkeepAlive::vSetData(tU16)' could be made const reference
tS32 dp_tclFCDummMQTTkeepAlive::s32SetData(const tU16 &tMQTTkeepAliveParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTkeepAlive,(tVoid*)&tMQTTkeepAliveParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTkeepAliveParam' in function 'dp_tclFCDummMQTTkeepAlive::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTkeepAlive::u8GetData(tU16& tMQTTkeepAliveParam) {  
   vUpdate();
   tMQTTkeepAliveParam = tMQTTkeepAlive;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTkeepAlive::vSetData(tU16 &tMQTTkeepAliveParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTkeepAlive,(tVoid*)&tMQTTkeepAliveParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMQTTkeepAliveParam' in function 'dp_tclFCDummMQTTkeepAlive::vSetData(tU16)' could be made const reference
tVoid dp_tclFCDummMQTTkeepAlive::vSetData(const tU16 &tMQTTkeepAliveParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTkeepAlive,(tVoid*)&tMQTTkeepAliveParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMQTTkeepAliveParam' in function 'dp_tclFCDummMQTTkeepAlive::vSetData(tU16)' could be made const reference
tU8   dp_tclFCDummMQTTkeepAlive::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTkeepAlive::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTkeepAlive", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTkeepAlive::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTkeepAlive", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTkeepAlive::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTkeepAlive", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTkeepAlive has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTperiodicConnectInterval"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTperiodicConnectInterval::dp_tclFCDummMQTTperiodicConnectInterval(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTperiodicConnectInterval,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTperiodicConnectInterval::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTperiodicConnectInterval",(tS32) 0xa5ad184L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTperiodicConnectInterval = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTperiodicConnectInterval::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTperiodicConnectInterval", (tS32)0xa5ad184L);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTperiodicConnectInterval, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTperiodicConnectInterval::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTperiodicConnectInterval::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTperiodicConnectInterval::tGetData() {
   vUpdate();
   return tMQTTperiodicConnectInterval;
};
tS32 dp_tclFCDummMQTTperiodicConnectInterval::s32GetData(tU8& tMQTTperiodicConnectIntervalParam) { 
   vUpdate();
   tMQTTperiodicConnectIntervalParam = tMQTTperiodicConnectInterval;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTperiodicConnectInterval::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTperiodicConnectInterval", (tS32)0xa5ad184L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTperiodicConnectInterval::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTperiodicConnectInterval::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTperiodicConnectInterval::s32SetData(tU8 &tMQTTperiodicConnectIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTperiodicConnectInterval,(tVoid*)&tMQTTperiodicConnectIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTperiodicConnectIntervalParam' in function 'dp_tclFCDummMQTTperiodicConnectInterval::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTperiodicConnectInterval::s32SetData(const tU8 &tMQTTperiodicConnectIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTperiodicConnectInterval,(tVoid*)&tMQTTperiodicConnectIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTperiodicConnectIntervalParam' in function 'dp_tclFCDummMQTTperiodicConnectInterval::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTperiodicConnectInterval::u8GetData(tU8& tMQTTperiodicConnectIntervalParam) {  
   vUpdate();
   tMQTTperiodicConnectIntervalParam = tMQTTperiodicConnectInterval;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTperiodicConnectInterval::vSetData(tU8 &tMQTTperiodicConnectIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTperiodicConnectInterval,(tVoid*)&tMQTTperiodicConnectIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTperiodicConnectIntervalParam' in function 'dp_tclFCDummMQTTperiodicConnectInterval::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTperiodicConnectInterval::vSetData(const tU8 &tMQTTperiodicConnectIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTperiodicConnectInterval,(tVoid*)&tMQTTperiodicConnectIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTperiodicConnectIntervalParam' in function 'dp_tclFCDummMQTTperiodicConnectInterval::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTperiodicConnectInterval::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTperiodicConnectInterval::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTperiodicConnectInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTperiodicConnectInterval::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTperiodicConnectInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTperiodicConnectInterval::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTperiodicConnectInterval", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTperiodicConnectInterval has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTPayloadCompression"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTPayloadCompression::dp_tclFCDummMQTTPayloadCompression(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTPayloadCompression,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTPayloadCompression::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTPayloadCompression",(tS32) 0x25e44bce);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTPayloadCompression = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTPayloadCompression::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTPayloadCompression", (tS32)0x25e44bce);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTPayloadCompression, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTPayloadCompression::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTPayloadCompression::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTPayloadCompression::tGetData() {
   vUpdate();
   return tMQTTPayloadCompression;
};
tS32 dp_tclFCDummMQTTPayloadCompression::s32GetData(tU8& tMQTTPayloadCompressionParam) { 
   vUpdate();
   tMQTTPayloadCompressionParam = tMQTTPayloadCompression;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTPayloadCompression::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTPayloadCompression", (tS32)0x25e44bce);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTPayloadCompression::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTPayloadCompression::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTPayloadCompression::s32SetData(tU8 &tMQTTPayloadCompressionParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTPayloadCompression,(tVoid*)&tMQTTPayloadCompressionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTPayloadCompressionParam' in function 'dp_tclFCDummMQTTPayloadCompression::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTPayloadCompression::s32SetData(const tU8 &tMQTTPayloadCompressionParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTPayloadCompression,(tVoid*)&tMQTTPayloadCompressionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTPayloadCompressionParam' in function 'dp_tclFCDummMQTTPayloadCompression::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTPayloadCompression::u8GetData(tU8& tMQTTPayloadCompressionParam) {  
   vUpdate();
   tMQTTPayloadCompressionParam = tMQTTPayloadCompression;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTPayloadCompression::vSetData(tU8 &tMQTTPayloadCompressionParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTPayloadCompression,(tVoid*)&tMQTTPayloadCompressionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTPayloadCompressionParam' in function 'dp_tclFCDummMQTTPayloadCompression::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTPayloadCompression::vSetData(const tU8 &tMQTTPayloadCompressionParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTPayloadCompression,(tVoid*)&tMQTTPayloadCompressionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTPayloadCompressionParam' in function 'dp_tclFCDummMQTTPayloadCompression::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTPayloadCompression::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTPayloadCompression::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTPayloadCompression", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTPayloadCompression::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTPayloadCompression", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTPayloadCompression::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTPayloadCompression", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTPayloadCompression has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTPasswordConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTPasswordConfig::dp_tclFCDummMQTTPasswordConfig(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummMQTTPasswordConfig::s32SetData(tString &tMQTTPasswordConfigParam) {
   tU32 u32Len = (tU32)strlen(tMQTTPasswordConfigParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("MQTTPasswordConfig", (tS32)0xc274d17b);
      (tVoid)myDpElem.bFillData((tVoid*)tMQTTPasswordConfigParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummMQTTPasswordConfig::s32SetData(const tString &tMQTTPasswordConfigParam) {
   tU32 u32Len = (tU32)strlen(tMQTTPasswordConfigParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("MQTTPasswordConfig", (tS32)0xc274d17b);
      (tVoid)myDpElem.bFillData((tVoid*)tMQTTPasswordConfigParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummMQTTPasswordConfig::s32GetData(tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("MQTTPasswordConfig", (tS32)0xc274d17b);
   (tVoid)memset(tMQTTPasswordConfigParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tMQTTPasswordConfigParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummMQTTPasswordConfig::s32GetData(const tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("MQTTPasswordConfig", (tS32)0xc274d17b);
   (tVoid)memset(tMQTTPasswordConfigParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tMQTTPasswordConfigParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummMQTTPasswordConfig::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummMQTTPasswordConfig::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummMQTTPasswordConfig::u32GetData(tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tMQTTPasswordConfigParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummMQTTPasswordConfig::u32GetData(const tString &tMQTTPasswordConfigParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tMQTTPasswordConfigParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummMQTTPasswordConfig::vSetData(tString &tMQTTPasswordConfigParam){(tVoid)s32SetData(tMQTTPasswordConfigParam);};
   tVoid dp_tclFCDummMQTTPasswordConfig::vSetData(const tString &tMQTTPasswordConfigParam){(tVoid)s32SetData(tMQTTPasswordConfigParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummMQTTPasswordConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTPasswordConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummMQTTPasswordConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTPasswordConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummMQTTPasswordConfig::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTPasswordConfig", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element MQTTPasswordConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "URL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummURL::dp_tclFCDummURL(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummURL::s32SetData(tString &tURLParam) {
   tU32 u32Len = (tU32)strlen(tURLParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("URL", (tS32)0xa33);
      (tVoid)myDpElem.bFillData((tVoid*)tURLParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummURL::s32SetData(const tString &tURLParam) {
   tU32 u32Len = (tU32)strlen(tURLParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("URL", (tS32)0xa33);
      (tVoid)myDpElem.bFillData((tVoid*)tURLParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummURL::s32GetData(tString &tURLParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("URL", (tS32)0xa33);
   (tVoid)memset(tURLParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tURLParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummURL::s32GetData(const tString &tURLParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("URL", (tS32)0xa33);
   (tVoid)memset(tURLParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tURLParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummURL::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummURL::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummURL::u32GetData(tString &tURLParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tURLParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummURL::u32GetData(const tString &tURLParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tURLParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummURL::vSetData(tString &tURLParam){(tVoid)s32SetData(tURLParam);};
   tVoid dp_tclFCDummURL::vSetData(const tString &tURLParam){(tVoid)s32SetData(tURLParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummURL::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "URL", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummURL::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "URL", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummURL::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: URL", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element URL has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PORT"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummPORT::dp_tclFCDummPORT(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPORT,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummPORT::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PORT",(tS32) 0x30b5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPORT = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummPORT::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PORT", (tS32)0x30b5);
   (tVoid)myDpElem.bFillData((tVoid*)&tPORT, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummPORT::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummPORT::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclFCDummPORT::tGetData() {
   vUpdate();
   return tPORT;
};
tS32 dp_tclFCDummPORT::s32GetData(tU16& tPORTParam) { 
   vUpdate();
   tPORTParam = tPORT;
   return _s32Status;
}
tS32 dp_tclFCDummPORT::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PORT", (tS32)0x30b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummPORT::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummPORT::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummPORT::s32SetData(tU16 &tPORTParam) {
   //init parameter
   (tVoid)memcpy(&tPORT,(tVoid*)&tPORTParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPORTParam' in function 'dp_tclFCDummPORT::vSetData(tU16)' could be made const reference
tS32 dp_tclFCDummPORT::s32SetData(const tU16 &tPORTParam) {
   //init parameter
   (tVoid)memcpy(&tPORT,(tVoid*)&tPORTParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPORTParam' in function 'dp_tclFCDummPORT::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummPORT::u8GetData(tU16& tPORTParam) {  
   vUpdate();
   tPORTParam = tPORT;
   return _u8DataStatus;
}
tVoid dp_tclFCDummPORT::vSetData(tU16 &tPORTParam) { 
   //init parameter
   (tVoid)memcpy(&tPORT,(tVoid*)&tPORTParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPORTParam' in function 'dp_tclFCDummPORT::vSetData(tU16)' could be made const reference
tVoid dp_tclFCDummPORT::vSetData(const tU16 &tPORTParam) { 
   //init parameter
   (tVoid)memcpy(&tPORT,(tVoid*)&tPORTParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPORTParam' in function 'dp_tclFCDummPORT::vSetData(tU16)' could be made const reference
tU8   dp_tclFCDummPORT::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummPORT::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "PORT", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummPORT::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "PORT", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummPORT::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PORT", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element PORT has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTRetryCONNECTInterval"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTRetryCONNECTInterval::dp_tclFCDummMQTTRetryCONNECTInterval(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTRetryCONNECTInterval,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTRetryCONNECTInterval::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTRetryCONNECTInterval",(tS32) 0xc56fea83);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTRetryCONNECTInterval = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTRetryCONNECTInterval::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTRetryCONNECTInterval", (tS32)0xc56fea83);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTRetryCONNECTInterval, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTRetryCONNECTInterval::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTRetryCONNECTInterval::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTRetryCONNECTInterval::tGetData() {
   vUpdate();
   return tMQTTRetryCONNECTInterval;
};
tS32 dp_tclFCDummMQTTRetryCONNECTInterval::s32GetData(tU8& tMQTTRetryCONNECTIntervalParam) { 
   vUpdate();
   tMQTTRetryCONNECTIntervalParam = tMQTTRetryCONNECTInterval;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTRetryCONNECTInterval::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTRetryCONNECTInterval", (tS32)0xc56fea83);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTRetryCONNECTInterval::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTRetryCONNECTInterval::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTRetryCONNECTInterval::s32SetData(tU8 &tMQTTRetryCONNECTIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTInterval,(tVoid*)&tMQTTRetryCONNECTIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryCONNECTIntervalParam' in function 'dp_tclFCDummMQTTRetryCONNECTInterval::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTRetryCONNECTInterval::s32SetData(const tU8 &tMQTTRetryCONNECTIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTInterval,(tVoid*)&tMQTTRetryCONNECTIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryCONNECTIntervalParam' in function 'dp_tclFCDummMQTTRetryCONNECTInterval::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTRetryCONNECTInterval::u8GetData(tU8& tMQTTRetryCONNECTIntervalParam) {  
   vUpdate();
   tMQTTRetryCONNECTIntervalParam = tMQTTRetryCONNECTInterval;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTRetryCONNECTInterval::vSetData(tU8 &tMQTTRetryCONNECTIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTInterval,(tVoid*)&tMQTTRetryCONNECTIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryCONNECTIntervalParam' in function 'dp_tclFCDummMQTTRetryCONNECTInterval::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTRetryCONNECTInterval::vSetData(const tU8 &tMQTTRetryCONNECTIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTInterval,(tVoid*)&tMQTTRetryCONNECTIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryCONNECTIntervalParam' in function 'dp_tclFCDummMQTTRetryCONNECTInterval::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTRetryCONNECTInterval::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTRetryCONNECTInterval::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryCONNECTInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryCONNECTInterval::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryCONNECTInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryCONNECTInterval::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTRetryCONNECTInterval", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTRetryCONNECTInterval has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTRetryCONNECTOccurrence"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTRetryCONNECTOccurrence::dp_tclFCDummMQTTRetryCONNECTOccurrence(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTRetryCONNECTOccurrence,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTRetryCONNECTOccurrence::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTRetryCONNECTOccurrence",(tS32) 0x484eadc7L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTRetryCONNECTOccurrence = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTRetryCONNECTOccurrence::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTRetryCONNECTOccurrence", (tS32)0x484eadc7L);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTRetryCONNECTOccurrence, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTRetryCONNECTOccurrence::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTRetryCONNECTOccurrence::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTRetryCONNECTOccurrence::tGetData() {
   vUpdate();
   return tMQTTRetryCONNECTOccurrence;
};
tS32 dp_tclFCDummMQTTRetryCONNECTOccurrence::s32GetData(tU8& tMQTTRetryCONNECTOccurrenceParam) { 
   vUpdate();
   tMQTTRetryCONNECTOccurrenceParam = tMQTTRetryCONNECTOccurrence;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTRetryCONNECTOccurrence::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTRetryCONNECTOccurrence", (tS32)0x484eadc7L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTRetryCONNECTOccurrence::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTRetryCONNECTOccurrence::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTRetryCONNECTOccurrence::s32SetData(tU8 &tMQTTRetryCONNECTOccurrenceParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTOccurrence,(tVoid*)&tMQTTRetryCONNECTOccurrenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryCONNECTOccurrenceParam' in function 'dp_tclFCDummMQTTRetryCONNECTOccurrence::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTRetryCONNECTOccurrence::s32SetData(const tU8 &tMQTTRetryCONNECTOccurrenceParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTOccurrence,(tVoid*)&tMQTTRetryCONNECTOccurrenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryCONNECTOccurrenceParam' in function 'dp_tclFCDummMQTTRetryCONNECTOccurrence::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTRetryCONNECTOccurrence::u8GetData(tU8& tMQTTRetryCONNECTOccurrenceParam) {  
   vUpdate();
   tMQTTRetryCONNECTOccurrenceParam = tMQTTRetryCONNECTOccurrence;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTRetryCONNECTOccurrence::vSetData(tU8 &tMQTTRetryCONNECTOccurrenceParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTOccurrence,(tVoid*)&tMQTTRetryCONNECTOccurrenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryCONNECTOccurrenceParam' in function 'dp_tclFCDummMQTTRetryCONNECTOccurrence::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTRetryCONNECTOccurrence::vSetData(const tU8 &tMQTTRetryCONNECTOccurrenceParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryCONNECTOccurrence,(tVoid*)&tMQTTRetryCONNECTOccurrenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryCONNECTOccurrenceParam' in function 'dp_tclFCDummMQTTRetryCONNECTOccurrence::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTRetryCONNECTOccurrence::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTRetryCONNECTOccurrence::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryCONNECTOccurrence", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryCONNECTOccurrence::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryCONNECTOccurrence", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryCONNECTOccurrence::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTRetryCONNECTOccurrence", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTRetryCONNECTOccurrence has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTConnectionTimeOut"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTConnectionTimeOut::dp_tclFCDummMQTTConnectionTimeOut(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTConnectionTimeOut,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTConnectionTimeOut::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTConnectionTimeOut",(tS32) 0xe5ad49d1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTConnectionTimeOut = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTConnectionTimeOut::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTConnectionTimeOut", (tS32)0xe5ad49d1);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTConnectionTimeOut, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTConnectionTimeOut::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTConnectionTimeOut::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTConnectionTimeOut::tGetData() {
   vUpdate();
   return tMQTTConnectionTimeOut;
};
tS32 dp_tclFCDummMQTTConnectionTimeOut::s32GetData(tU8& tMQTTConnectionTimeOutParam) { 
   vUpdate();
   tMQTTConnectionTimeOutParam = tMQTTConnectionTimeOut;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTConnectionTimeOut::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTConnectionTimeOut", (tS32)0xe5ad49d1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTConnectionTimeOut::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTConnectionTimeOut::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTConnectionTimeOut::s32SetData(tU8 &tMQTTConnectionTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionTimeOut,(tVoid*)&tMQTTConnectionTimeOutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTConnectionTimeOutParam' in function 'dp_tclFCDummMQTTConnectionTimeOut::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTConnectionTimeOut::s32SetData(const tU8 &tMQTTConnectionTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionTimeOut,(tVoid*)&tMQTTConnectionTimeOutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTConnectionTimeOutParam' in function 'dp_tclFCDummMQTTConnectionTimeOut::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTConnectionTimeOut::u8GetData(tU8& tMQTTConnectionTimeOutParam) {  
   vUpdate();
   tMQTTConnectionTimeOutParam = tMQTTConnectionTimeOut;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTConnectionTimeOut::vSetData(tU8 &tMQTTConnectionTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionTimeOut,(tVoid*)&tMQTTConnectionTimeOutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTConnectionTimeOutParam' in function 'dp_tclFCDummMQTTConnectionTimeOut::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTConnectionTimeOut::vSetData(const tU8 &tMQTTConnectionTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionTimeOut,(tVoid*)&tMQTTConnectionTimeOutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTConnectionTimeOutParam' in function 'dp_tclFCDummMQTTConnectionTimeOut::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTConnectionTimeOut::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTConnectionTimeOut::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTConnectionTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTConnectionTimeOut::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTConnectionTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTConnectionTimeOut::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTConnectionTimeOut", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTConnectionTimeOut has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTRetryPUBLISHInterval"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTRetryPUBLISHInterval::dp_tclFCDummMQTTRetryPUBLISHInterval(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTRetryPUBLISHInterval,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTRetryPUBLISHInterval::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTRetryPUBLISHInterval",(tS32) 0x42d5baf8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTRetryPUBLISHInterval = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTRetryPUBLISHInterval::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTRetryPUBLISHInterval", (tS32)0x42d5baf8);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTRetryPUBLISHInterval, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTRetryPUBLISHInterval::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTRetryPUBLISHInterval::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTRetryPUBLISHInterval::tGetData() {
   vUpdate();
   return tMQTTRetryPUBLISHInterval;
};
tS32 dp_tclFCDummMQTTRetryPUBLISHInterval::s32GetData(tU8& tMQTTRetryPUBLISHIntervalParam) { 
   vUpdate();
   tMQTTRetryPUBLISHIntervalParam = tMQTTRetryPUBLISHInterval;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTRetryPUBLISHInterval::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTRetryPUBLISHInterval", (tS32)0x42d5baf8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTRetryPUBLISHInterval::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTRetryPUBLISHInterval::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTRetryPUBLISHInterval::s32SetData(tU8 &tMQTTRetryPUBLISHIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHInterval,(tVoid*)&tMQTTRetryPUBLISHIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryPUBLISHIntervalParam' in function 'dp_tclFCDummMQTTRetryPUBLISHInterval::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTRetryPUBLISHInterval::s32SetData(const tU8 &tMQTTRetryPUBLISHIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHInterval,(tVoid*)&tMQTTRetryPUBLISHIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryPUBLISHIntervalParam' in function 'dp_tclFCDummMQTTRetryPUBLISHInterval::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTRetryPUBLISHInterval::u8GetData(tU8& tMQTTRetryPUBLISHIntervalParam) {  
   vUpdate();
   tMQTTRetryPUBLISHIntervalParam = tMQTTRetryPUBLISHInterval;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTRetryPUBLISHInterval::vSetData(tU8 &tMQTTRetryPUBLISHIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHInterval,(tVoid*)&tMQTTRetryPUBLISHIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryPUBLISHIntervalParam' in function 'dp_tclFCDummMQTTRetryPUBLISHInterval::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTRetryPUBLISHInterval::vSetData(const tU8 &tMQTTRetryPUBLISHIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHInterval,(tVoid*)&tMQTTRetryPUBLISHIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryPUBLISHIntervalParam' in function 'dp_tclFCDummMQTTRetryPUBLISHInterval::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTRetryPUBLISHInterval::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTRetryPUBLISHInterval::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryPUBLISHInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryPUBLISHInterval::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryPUBLISHInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryPUBLISHInterval::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTRetryPUBLISHInterval", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTRetryPUBLISHInterval has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTRetryPUBLISHOccurrence"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTRetryPUBLISHOccurrence::dp_tclFCDummMQTTRetryPUBLISHOccurrence(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTRetryPUBLISHOccurrence,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTRetryPUBLISHOccurrence::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTRetryPUBLISHOccurrence",(tS32) 0x87400934L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTRetryPUBLISHOccurrence = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTRetryPUBLISHOccurrence::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTRetryPUBLISHOccurrence", (tS32)0x87400934L);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTRetryPUBLISHOccurrence, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTRetryPUBLISHOccurrence::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTRetryPUBLISHOccurrence::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTRetryPUBLISHOccurrence::tGetData() {
   vUpdate();
   return tMQTTRetryPUBLISHOccurrence;
};
tS32 dp_tclFCDummMQTTRetryPUBLISHOccurrence::s32GetData(tU8& tMQTTRetryPUBLISHOccurrenceParam) { 
   vUpdate();
   tMQTTRetryPUBLISHOccurrenceParam = tMQTTRetryPUBLISHOccurrence;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTRetryPUBLISHOccurrence::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTRetryPUBLISHOccurrence", (tS32)0x87400934L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTRetryPUBLISHOccurrence::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTRetryPUBLISHOccurrence::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTRetryPUBLISHOccurrence::s32SetData(tU8 &tMQTTRetryPUBLISHOccurrenceParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHOccurrence,(tVoid*)&tMQTTRetryPUBLISHOccurrenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryPUBLISHOccurrenceParam' in function 'dp_tclFCDummMQTTRetryPUBLISHOccurrence::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTRetryPUBLISHOccurrence::s32SetData(const tU8 &tMQTTRetryPUBLISHOccurrenceParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHOccurrence,(tVoid*)&tMQTTRetryPUBLISHOccurrenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetryPUBLISHOccurrenceParam' in function 'dp_tclFCDummMQTTRetryPUBLISHOccurrence::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTRetryPUBLISHOccurrence::u8GetData(tU8& tMQTTRetryPUBLISHOccurrenceParam) {  
   vUpdate();
   tMQTTRetryPUBLISHOccurrenceParam = tMQTTRetryPUBLISHOccurrence;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTRetryPUBLISHOccurrence::vSetData(tU8 &tMQTTRetryPUBLISHOccurrenceParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHOccurrence,(tVoid*)&tMQTTRetryPUBLISHOccurrenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryPUBLISHOccurrenceParam' in function 'dp_tclFCDummMQTTRetryPUBLISHOccurrence::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTRetryPUBLISHOccurrence::vSetData(const tU8 &tMQTTRetryPUBLISHOccurrenceParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetryPUBLISHOccurrence,(tVoid*)&tMQTTRetryPUBLISHOccurrenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetryPUBLISHOccurrenceParam' in function 'dp_tclFCDummMQTTRetryPUBLISHOccurrence::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTRetryPUBLISHOccurrence::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTRetryPUBLISHOccurrence::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryPUBLISHOccurrence", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryPUBLISHOccurrence::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetryPUBLISHOccurrence", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetryPUBLISHOccurrence::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTRetryPUBLISHOccurrence", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTRetryPUBLISHOccurrence has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTPublishTimeOut"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTPublishTimeOut::dp_tclFCDummMQTTPublishTimeOut(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTPublishTimeOut,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTPublishTimeOut::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTPublishTimeOut",(tS32) 0xae5a32a0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTPublishTimeOut = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTPublishTimeOut::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTPublishTimeOut", (tS32)0xae5a32a0);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTPublishTimeOut, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTPublishTimeOut::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTPublishTimeOut::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTPublishTimeOut::tGetData() {
   vUpdate();
   return tMQTTPublishTimeOut;
};
tS32 dp_tclFCDummMQTTPublishTimeOut::s32GetData(tU8& tMQTTPublishTimeOutParam) { 
   vUpdate();
   tMQTTPublishTimeOutParam = tMQTTPublishTimeOut;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTPublishTimeOut::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTPublishTimeOut", (tS32)0xae5a32a0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTPublishTimeOut::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTPublishTimeOut::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTPublishTimeOut::s32SetData(tU8 &tMQTTPublishTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTPublishTimeOut,(tVoid*)&tMQTTPublishTimeOutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTPublishTimeOutParam' in function 'dp_tclFCDummMQTTPublishTimeOut::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTPublishTimeOut::s32SetData(const tU8 &tMQTTPublishTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTPublishTimeOut,(tVoid*)&tMQTTPublishTimeOutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTPublishTimeOutParam' in function 'dp_tclFCDummMQTTPublishTimeOut::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTPublishTimeOut::u8GetData(tU8& tMQTTPublishTimeOutParam) {  
   vUpdate();
   tMQTTPublishTimeOutParam = tMQTTPublishTimeOut;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTPublishTimeOut::vSetData(tU8 &tMQTTPublishTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTPublishTimeOut,(tVoid*)&tMQTTPublishTimeOutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTPublishTimeOutParam' in function 'dp_tclFCDummMQTTPublishTimeOut::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTPublishTimeOut::vSetData(const tU8 &tMQTTPublishTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTPublishTimeOut,(tVoid*)&tMQTTPublishTimeOutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTPublishTimeOutParam' in function 'dp_tclFCDummMQTTPublishTimeOut::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTPublishTimeOut::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTPublishTimeOut::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTPublishTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTPublishTimeOut::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTPublishTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTPublishTimeOut::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTPublishTimeOut", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTPublishTimeOut has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTRetrySUBSCRIBEInterval"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTRetrySUBSCRIBEInterval::dp_tclFCDummMQTTRetrySUBSCRIBEInterval(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTRetrySUBSCRIBEInterval,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTRetrySUBSCRIBEInterval",(tS32) 0xbd6dcf3bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTRetrySUBSCRIBEInterval = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTRetrySUBSCRIBEInterval", (tS32)0xbd6dcf3bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTRetrySUBSCRIBEInterval, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTRetrySUBSCRIBEInterval::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTRetrySUBSCRIBEInterval::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTRetrySUBSCRIBEInterval::tGetData() {
   vUpdate();
   return tMQTTRetrySUBSCRIBEInterval;
};
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEInterval::s32GetData(tU8& tMQTTRetrySUBSCRIBEIntervalParam) { 
   vUpdate();
   tMQTTRetrySUBSCRIBEIntervalParam = tMQTTRetrySUBSCRIBEInterval;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEInterval::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTRetrySUBSCRIBEInterval", (tS32)0xbd6dcf3bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEInterval::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEInterval::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEInterval::s32SetData(tU8 &tMQTTRetrySUBSCRIBEIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEInterval,(tVoid*)&tMQTTRetrySUBSCRIBEIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEIntervalParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEInterval::s32SetData(const tU8 &tMQTTRetrySUBSCRIBEIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEInterval,(tVoid*)&tMQTTRetrySUBSCRIBEIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEIntervalParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTRetrySUBSCRIBEInterval::u8GetData(tU8& tMQTTRetrySUBSCRIBEIntervalParam) {  
   vUpdate();
   tMQTTRetrySUBSCRIBEIntervalParam = tMQTTRetrySUBSCRIBEInterval;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vSetData(tU8 &tMQTTRetrySUBSCRIBEIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEInterval,(tVoid*)&tMQTTRetrySUBSCRIBEIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEIntervalParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vSetData(const tU8 &tMQTTRetrySUBSCRIBEIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEInterval,(tVoid*)&tMQTTRetrySUBSCRIBEIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEIntervalParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEInterval::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTRetrySUBSCRIBEInterval::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTRetrySUBSCRIBEInterval::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetrySUBSCRIBEInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetrySUBSCRIBEInterval::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetrySUBSCRIBEInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetrySUBSCRIBEInterval::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTRetrySUBSCRIBEInterval", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTRetrySUBSCRIBEInterval has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTRetrySUBSCRIBEOccurrence"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTRetrySUBSCRIBEOccurrence,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTRetrySUBSCRIBEOccurrence",(tS32) 0x801a03bfL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTRetrySUBSCRIBEOccurrence = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTRetrySUBSCRIBEOccurrence", (tS32)0x801a03bfL);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTRetrySUBSCRIBEOccurrence, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::tGetData() {
   vUpdate();
   return tMQTTRetrySUBSCRIBEOccurrence;
};
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::s32GetData(tU8& tMQTTRetrySUBSCRIBEOccurrenceParam) { 
   vUpdate();
   tMQTTRetrySUBSCRIBEOccurrenceParam = tMQTTRetrySUBSCRIBEOccurrence;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTRetrySUBSCRIBEOccurrence", (tS32)0x801a03bfL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::s32SetData(tU8 &tMQTTRetrySUBSCRIBEOccurrenceParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEOccurrence,(tVoid*)&tMQTTRetrySUBSCRIBEOccurrenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEOccurrenceParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::s32SetData(const tU8 &tMQTTRetrySUBSCRIBEOccurrenceParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEOccurrence,(tVoid*)&tMQTTRetrySUBSCRIBEOccurrenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEOccurrenceParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::u8GetData(tU8& tMQTTRetrySUBSCRIBEOccurrenceParam) {  
   vUpdate();
   tMQTTRetrySUBSCRIBEOccurrenceParam = tMQTTRetrySUBSCRIBEOccurrence;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vSetData(tU8 &tMQTTRetrySUBSCRIBEOccurrenceParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEOccurrence,(tVoid*)&tMQTTRetrySUBSCRIBEOccurrenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEOccurrenceParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vSetData(const tU8 &tMQTTRetrySUBSCRIBEOccurrenceParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTRetrySUBSCRIBEOccurrence,(tVoid*)&tMQTTRetrySUBSCRIBEOccurrenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTRetrySUBSCRIBEOccurrenceParam' in function 'dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetrySUBSCRIBEOccurrence", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTRetrySUBSCRIBEOccurrence", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTRetrySUBSCRIBEOccurrence::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTRetrySUBSCRIBEOccurrence", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTRetrySUBSCRIBEOccurrence has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTSubscribeTimeOut"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTSubscribeTimeOut::dp_tclFCDummMQTTSubscribeTimeOut(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTSubscribeTimeOut,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTSubscribeTimeOut::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTSubscribeTimeOut",(tS32) 0xabff70d7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTSubscribeTimeOut = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTSubscribeTimeOut::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTSubscribeTimeOut", (tS32)0xabff70d7);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTSubscribeTimeOut, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTSubscribeTimeOut::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTSubscribeTimeOut::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTSubscribeTimeOut::tGetData() {
   vUpdate();
   return tMQTTSubscribeTimeOut;
};
tS32 dp_tclFCDummMQTTSubscribeTimeOut::s32GetData(tU8& tMQTTSubscribeTimeOutParam) { 
   vUpdate();
   tMQTTSubscribeTimeOutParam = tMQTTSubscribeTimeOut;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTSubscribeTimeOut::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTSubscribeTimeOut", (tS32)0xabff70d7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTSubscribeTimeOut::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTSubscribeTimeOut::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTSubscribeTimeOut::s32SetData(tU8 &tMQTTSubscribeTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTSubscribeTimeOut,(tVoid*)&tMQTTSubscribeTimeOutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTSubscribeTimeOutParam' in function 'dp_tclFCDummMQTTSubscribeTimeOut::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTSubscribeTimeOut::s32SetData(const tU8 &tMQTTSubscribeTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTSubscribeTimeOut,(tVoid*)&tMQTTSubscribeTimeOutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTSubscribeTimeOutParam' in function 'dp_tclFCDummMQTTSubscribeTimeOut::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTSubscribeTimeOut::u8GetData(tU8& tMQTTSubscribeTimeOutParam) {  
   vUpdate();
   tMQTTSubscribeTimeOutParam = tMQTTSubscribeTimeOut;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTSubscribeTimeOut::vSetData(tU8 &tMQTTSubscribeTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTSubscribeTimeOut,(tVoid*)&tMQTTSubscribeTimeOutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTSubscribeTimeOutParam' in function 'dp_tclFCDummMQTTSubscribeTimeOut::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTSubscribeTimeOut::vSetData(const tU8 &tMQTTSubscribeTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTSubscribeTimeOut,(tVoid*)&tMQTTSubscribeTimeOutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTSubscribeTimeOutParam' in function 'dp_tclFCDummMQTTSubscribeTimeOut::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTSubscribeTimeOut::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTSubscribeTimeOut::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTSubscribeTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTSubscribeTimeOut::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTSubscribeTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTSubscribeTimeOut::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTSubscribeTimeOut", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTSubscribeTimeOut has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTCleanSwitchToZlib"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTCleanSwitchToZlib::dp_tclFCDummMQTTCleanSwitchToZlib(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTCleanSwitchToZlib,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTCleanSwitchToZlib::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTCleanSwitchToZlib",(tS32) 0x6ee16c37);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tMQTTCleanSwitchToZlib = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTCleanSwitchToZlib::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTCleanSwitchToZlib", (tS32)0x6ee16c37);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTCleanSwitchToZlib, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTCleanSwitchToZlib::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTCleanSwitchToZlib::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCDummMQTTCleanSwitchToZlib::tGetData() {
   vUpdate();
   return tMQTTCleanSwitchToZlib;
};
tS32 dp_tclFCDummMQTTCleanSwitchToZlib::s32GetData(tBool& tMQTTCleanSwitchToZlibParam) { 
   vUpdate();
   tMQTTCleanSwitchToZlibParam = tMQTTCleanSwitchToZlib;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTCleanSwitchToZlib::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTCleanSwitchToZlib", (tS32)0x6ee16c37);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTCleanSwitchToZlib::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTCleanSwitchToZlib::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTCleanSwitchToZlib::s32SetData(tBool &tMQTTCleanSwitchToZlibParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchToZlib,(tVoid*)&tMQTTCleanSwitchToZlibParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTCleanSwitchToZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchToZlib::vSetData(tBool)' could be made const reference
tS32 dp_tclFCDummMQTTCleanSwitchToZlib::s32SetData(const tBool &tMQTTCleanSwitchToZlibParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchToZlib,(tVoid*)&tMQTTCleanSwitchToZlibParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTCleanSwitchToZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchToZlib::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTCleanSwitchToZlib::u8GetData(tBool& tMQTTCleanSwitchToZlibParam) {  
   vUpdate();
   tMQTTCleanSwitchToZlibParam = tMQTTCleanSwitchToZlib;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTCleanSwitchToZlib::vSetData(tBool &tMQTTCleanSwitchToZlibParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchToZlib,(tVoid*)&tMQTTCleanSwitchToZlibParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMQTTCleanSwitchToZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchToZlib::vSetData(tBool)' could be made const reference
tVoid dp_tclFCDummMQTTCleanSwitchToZlib::vSetData(const tBool &tMQTTCleanSwitchToZlibParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchToZlib,(tVoid*)&tMQTTCleanSwitchToZlibParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMQTTCleanSwitchToZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchToZlib::vSetData(tBool)' could be made const reference
tU8   dp_tclFCDummMQTTCleanSwitchToZlib::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTCleanSwitchToZlib::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTCleanSwitchToZlib", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTCleanSwitchToZlib::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTCleanSwitchToZlib", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTCleanSwitchToZlib::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTCleanSwitchToZlib", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTCleanSwitchToZlib has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTCleanSwitchFromZlib"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTCleanSwitchFromZlib::dp_tclFCDummMQTTCleanSwitchFromZlib(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTCleanSwitchFromZlib,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTCleanSwitchFromZlib::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTCleanSwitchFromZlib",(tS32) 0xd3f496e4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tMQTTCleanSwitchFromZlib = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTCleanSwitchFromZlib::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTCleanSwitchFromZlib", (tS32)0xd3f496e4);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTCleanSwitchFromZlib, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTCleanSwitchFromZlib::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTCleanSwitchFromZlib::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCDummMQTTCleanSwitchFromZlib::tGetData() {
   vUpdate();
   return tMQTTCleanSwitchFromZlib;
};
tS32 dp_tclFCDummMQTTCleanSwitchFromZlib::s32GetData(tBool& tMQTTCleanSwitchFromZlibParam) { 
   vUpdate();
   tMQTTCleanSwitchFromZlibParam = tMQTTCleanSwitchFromZlib;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTCleanSwitchFromZlib::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTCleanSwitchFromZlib", (tS32)0xd3f496e4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTCleanSwitchFromZlib::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTCleanSwitchFromZlib::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTCleanSwitchFromZlib::s32SetData(tBool &tMQTTCleanSwitchFromZlibParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchFromZlib,(tVoid*)&tMQTTCleanSwitchFromZlibParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTCleanSwitchFromZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchFromZlib::vSetData(tBool)' could be made const reference
tS32 dp_tclFCDummMQTTCleanSwitchFromZlib::s32SetData(const tBool &tMQTTCleanSwitchFromZlibParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchFromZlib,(tVoid*)&tMQTTCleanSwitchFromZlibParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTCleanSwitchFromZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchFromZlib::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTCleanSwitchFromZlib::u8GetData(tBool& tMQTTCleanSwitchFromZlibParam) {  
   vUpdate();
   tMQTTCleanSwitchFromZlibParam = tMQTTCleanSwitchFromZlib;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTCleanSwitchFromZlib::vSetData(tBool &tMQTTCleanSwitchFromZlibParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchFromZlib,(tVoid*)&tMQTTCleanSwitchFromZlibParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMQTTCleanSwitchFromZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchFromZlib::vSetData(tBool)' could be made const reference
tVoid dp_tclFCDummMQTTCleanSwitchFromZlib::vSetData(const tBool &tMQTTCleanSwitchFromZlibParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTCleanSwitchFromZlib,(tVoid*)&tMQTTCleanSwitchFromZlibParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMQTTCleanSwitchFromZlibParam' in function 'dp_tclFCDummMQTTCleanSwitchFromZlib::vSetData(tBool)' could be made const reference
tU8   dp_tclFCDummMQTTCleanSwitchFromZlib::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTCleanSwitchFromZlib::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTCleanSwitchFromZlib", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTCleanSwitchFromZlib::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTCleanSwitchFromZlib", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTCleanSwitchFromZlib::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTCleanSwitchFromZlib", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTCleanSwitchFromZlib has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TLS_EXPBackOffStartDelay"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummTLS_EXPBackOffStartDelay::dp_tclFCDummTLS_EXPBackOffStartDelay(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTLS_EXPBackOffStartDelay,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummTLS_EXPBackOffStartDelay::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TLS_EXPBackOffStartDelay",(tS32) 0x1e188380);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tTLS_EXPBackOffStartDelay = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummTLS_EXPBackOffStartDelay::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TLS_EXPBackOffStartDelay", (tS32)0x1e188380);
   (tVoid)myDpElem.bFillData((tVoid*)&tTLS_EXPBackOffStartDelay, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummTLS_EXPBackOffStartDelay::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummTLS_EXPBackOffStartDelay::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclFCDummTLS_EXPBackOffStartDelay::tGetData() {
   vUpdate();
   return tTLS_EXPBackOffStartDelay;
};
tS32 dp_tclFCDummTLS_EXPBackOffStartDelay::s32GetData(tU16& tTLS_EXPBackOffStartDelayParam) { 
   vUpdate();
   tTLS_EXPBackOffStartDelayParam = tTLS_EXPBackOffStartDelay;
   return _s32Status;
}
tS32 dp_tclFCDummTLS_EXPBackOffStartDelay::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TLS_EXPBackOffStartDelay", (tS32)0x1e188380);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummTLS_EXPBackOffStartDelay::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummTLS_EXPBackOffStartDelay::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummTLS_EXPBackOffStartDelay::s32SetData(tU16 &tTLS_EXPBackOffStartDelayParam) {
   //init parameter
   (tVoid)memcpy(&tTLS_EXPBackOffStartDelay,(tVoid*)&tTLS_EXPBackOffStartDelayParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTLS_EXPBackOffStartDelayParam' in function 'dp_tclFCDummTLS_EXPBackOffStartDelay::vSetData(tU16)' could be made const reference
tS32 dp_tclFCDummTLS_EXPBackOffStartDelay::s32SetData(const tU16 &tTLS_EXPBackOffStartDelayParam) {
   //init parameter
   (tVoid)memcpy(&tTLS_EXPBackOffStartDelay,(tVoid*)&tTLS_EXPBackOffStartDelayParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTLS_EXPBackOffStartDelayParam' in function 'dp_tclFCDummTLS_EXPBackOffStartDelay::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummTLS_EXPBackOffStartDelay::u8GetData(tU16& tTLS_EXPBackOffStartDelayParam) {  
   vUpdate();
   tTLS_EXPBackOffStartDelayParam = tTLS_EXPBackOffStartDelay;
   return _u8DataStatus;
}
tVoid dp_tclFCDummTLS_EXPBackOffStartDelay::vSetData(tU16 &tTLS_EXPBackOffStartDelayParam) { 
   //init parameter
   (tVoid)memcpy(&tTLS_EXPBackOffStartDelay,(tVoid*)&tTLS_EXPBackOffStartDelayParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tTLS_EXPBackOffStartDelayParam' in function 'dp_tclFCDummTLS_EXPBackOffStartDelay::vSetData(tU16)' could be made const reference
tVoid dp_tclFCDummTLS_EXPBackOffStartDelay::vSetData(const tU16 &tTLS_EXPBackOffStartDelayParam) { 
   //init parameter
   (tVoid)memcpy(&tTLS_EXPBackOffStartDelay,(tVoid*)&tTLS_EXPBackOffStartDelayParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tTLS_EXPBackOffStartDelayParam' in function 'dp_tclFCDummTLS_EXPBackOffStartDelay::vSetData(tU16)' could be made const reference
tU8   dp_tclFCDummTLS_EXPBackOffStartDelay::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummTLS_EXPBackOffStartDelay::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "TLS_EXPBackOffStartDelay", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummTLS_EXPBackOffStartDelay::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "TLS_EXPBackOffStartDelay", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummTLS_EXPBackOffStartDelay::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TLS_EXPBackOffStartDelay", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element TLS_EXPBackOffStartDelay has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTUsernameConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTUsernameConfig::dp_tclFCDummMQTTUsernameConfig(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummMQTTUsernameConfig::s32SetData(tString &tMQTTUsernameConfigParam) {
   tU32 u32Len = (tU32)strlen(tMQTTUsernameConfigParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("MQTTUsernameConfig", (tS32)0x9771654);
      (tVoid)myDpElem.bFillData((tVoid*)tMQTTUsernameConfigParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummMQTTUsernameConfig::s32SetData(const tString &tMQTTUsernameConfigParam) {
   tU32 u32Len = (tU32)strlen(tMQTTUsernameConfigParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("MQTTUsernameConfig", (tS32)0x9771654);
      (tVoid)myDpElem.bFillData((tVoid*)tMQTTUsernameConfigParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummMQTTUsernameConfig::s32GetData(tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("MQTTUsernameConfig", (tS32)0x9771654);
   (tVoid)memset(tMQTTUsernameConfigParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tMQTTUsernameConfigParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummMQTTUsernameConfig::s32GetData(const tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("MQTTUsernameConfig", (tS32)0x9771654);
   (tVoid)memset(tMQTTUsernameConfigParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tMQTTUsernameConfigParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummMQTTUsernameConfig::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummMQTTUsernameConfig::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummMQTTUsernameConfig::u32GetData(tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tMQTTUsernameConfigParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummMQTTUsernameConfig::u32GetData(const tString &tMQTTUsernameConfigParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tMQTTUsernameConfigParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummMQTTUsernameConfig::vSetData(tString &tMQTTUsernameConfigParam){(tVoid)s32SetData(tMQTTUsernameConfigParam);};
   tVoid dp_tclFCDummMQTTUsernameConfig::vSetData(const tString &tMQTTUsernameConfigParam){(tVoid)s32SetData(tMQTTUsernameConfigParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummMQTTUsernameConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTUsernameConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummMQTTUsernameConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTUsernameConfig", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummMQTTUsernameConfig::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTUsernameConfig", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element MQTTUsernameConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTConnectionType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTConnectionType::dp_tclFCDummMQTTConnectionType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTConnectionType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTConnectionType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTConnectionType",(tS32) 0xc87e5200);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTConnectionType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTConnectionType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTConnectionType", (tS32)0xc87e5200);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTConnectionType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTConnectionType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTConnectionType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTConnectionType::tGetData() {
   vUpdate();
   return tMQTTConnectionType;
};
tS32 dp_tclFCDummMQTTConnectionType::s32GetData(tU8& tMQTTConnectionTypeParam) { 
   vUpdate();
   tMQTTConnectionTypeParam = tMQTTConnectionType;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTConnectionType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTConnectionType", (tS32)0xc87e5200);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTConnectionType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTConnectionType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTConnectionType::s32SetData(tU8 &tMQTTConnectionTypeParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionType,(tVoid*)&tMQTTConnectionTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTConnectionTypeParam' in function 'dp_tclFCDummMQTTConnectionType::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTConnectionType::s32SetData(const tU8 &tMQTTConnectionTypeParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionType,(tVoid*)&tMQTTConnectionTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTConnectionTypeParam' in function 'dp_tclFCDummMQTTConnectionType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTConnectionType::u8GetData(tU8& tMQTTConnectionTypeParam) {  
   vUpdate();
   tMQTTConnectionTypeParam = tMQTTConnectionType;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTConnectionType::vSetData(tU8 &tMQTTConnectionTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionType,(tVoid*)&tMQTTConnectionTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTConnectionTypeParam' in function 'dp_tclFCDummMQTTConnectionType::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTConnectionType::vSetData(const tU8 &tMQTTConnectionTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTConnectionType,(tVoid*)&tMQTTConnectionTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTConnectionTypeParam' in function 'dp_tclFCDummMQTTConnectionType::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTConnectionType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTConnectionType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTConnectionType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTConnectionType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTConnectionType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTConnectionType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTConnectionType", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTConnectionType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VIN"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummVIN::dp_tclFCDummVIN(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummVIN::s32SetData(tString &tVINParam) {
   tU32 u32Len = (tU32)strlen(tVINParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("VIN", (tS32)0xa21);
      (tVoid)myDpElem.bFillData((tVoid*)tVINParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummVIN::s32SetData(const tString &tVINParam) {
   tU32 u32Len = (tU32)strlen(tVINParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("VIN", (tS32)0xa21);
      (tVoid)myDpElem.bFillData((tVoid*)tVINParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummVIN::s32GetData(tString &tVINParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("VIN", (tS32)0xa21);
   (tVoid)memset(tVINParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tVINParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummVIN::s32GetData(const tString &tVINParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("VIN", (tS32)0xa21);
   (tVoid)memset(tVINParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tVINParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummVIN::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummVIN::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummVIN::u32GetData(tString &tVINParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tVINParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummVIN::u32GetData(const tString &tVINParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tVINParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummVIN::vSetData(tString &tVINParam){(tVoid)s32SetData(tVINParam);};
   tVoid dp_tclFCDummVIN::vSetData(const tString &tVINParam){(tVoid)s32SetData(tVINParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummVIN::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "VIN", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummVIN::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "VIN", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummVIN::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VIN", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element VIN has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BIN"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummBIN::dp_tclFCDummBIN(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummBIN::s32SetData(tString &tBINParam) {
   tU32 u32Len = (tU32)strlen(tBINParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("BIN", (tS32)0x82d);
      (tVoid)myDpElem.bFillData((tVoid*)tBINParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummBIN::s32SetData(const tString &tBINParam) {
   tU32 u32Len = (tU32)strlen(tBINParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("BIN", (tS32)0x82d);
      (tVoid)myDpElem.bFillData((tVoid*)tBINParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummBIN::s32GetData(tString &tBINParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("BIN", (tS32)0x82d);
   (tVoid)memset(tBINParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tBINParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummBIN::s32GetData(const tString &tBINParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("BIN", (tS32)0x82d);
   (tVoid)memset(tBINParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tBINParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummBIN::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummBIN::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummBIN::u32GetData(tString &tBINParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tBINParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummBIN::u32GetData(const tString &tBINParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tBINParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummBIN::vSetData(tString &tBINParam){(tVoid)s32SetData(tBINParam);};
   tVoid dp_tclFCDummBIN::vSetData(const tString &tBINParam){(tVoid)s32SetData(tBINParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummBIN::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "BIN", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummBIN::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "BIN", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummBIN::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BIN", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element BIN has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DCMVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummDCMVersion::dp_tclFCDummDCMVersion(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummDCMVersion::s32SetData(tString &tDCMVersionParam) {
   tU32 u32Len = (tU32)strlen(tDCMVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("DCMVersion", (tS32)0x9f06082);
      (tVoid)myDpElem.bFillData((tVoid*)tDCMVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummDCMVersion::s32SetData(const tString &tDCMVersionParam) {
   tU32 u32Len = (tU32)strlen(tDCMVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("DCMVersion", (tS32)0x9f06082);
      (tVoid)myDpElem.bFillData((tVoid*)tDCMVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummDCMVersion::s32GetData(tString &tDCMVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("DCMVersion", (tS32)0x9f06082);
   (tVoid)memset(tDCMVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tDCMVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummDCMVersion::s32GetData(const tString &tDCMVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("DCMVersion", (tS32)0x9f06082);
   (tVoid)memset(tDCMVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tDCMVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummDCMVersion::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummDCMVersion::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummDCMVersion::u32GetData(tString &tDCMVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tDCMVersionParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummDCMVersion::u32GetData(const tString &tDCMVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tDCMVersionParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummDCMVersion::vSetData(tString &tDCMVersionParam){(tVoid)s32SetData(tDCMVersionParam);};
   tVoid dp_tclFCDummDCMVersion::vSetData(const tString &tDCMVersionParam){(tVoid)s32SetData(tDCMVersionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummDCMVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "DCMVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummDCMVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "DCMVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummDCMVersion::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DCMVersion", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element DCMVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UserID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummUserID::dp_tclFCDummUserID(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummUserID::s32SetData(tString &tUserIDParam) {
   tU32 u32Len = (tU32)strlen(tUserIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("UserID", (tS32)0x56480);
      (tVoid)myDpElem.bFillData((tVoid*)tUserIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummUserID::s32SetData(const tString &tUserIDParam) {
   tU32 u32Len = (tU32)strlen(tUserIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("UserID", (tS32)0x56480);
      (tVoid)myDpElem.bFillData((tVoid*)tUserIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummUserID::s32GetData(tString &tUserIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("UserID", (tS32)0x56480);
   (tVoid)memset(tUserIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tUserIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummUserID::s32GetData(const tString &tUserIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("UserID", (tS32)0x56480);
   (tVoid)memset(tUserIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tUserIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummUserID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummUserID::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummUserID::u32GetData(tString &tUserIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tUserIDParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummUserID::u32GetData(const tString &tUserIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tUserIDParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummUserID::vSetData(tString &tUserIDParam){(tVoid)s32SetData(tUserIDParam);};
   tVoid dp_tclFCDummUserID::vSetData(const tString &tUserIDParam){(tVoid)s32SetData(tUserIDParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummUserID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "UserID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummUserID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "UserID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummUserID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UserID", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element UserID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DRMdataReqTimeout"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummDRMdataReqTimeout::dp_tclFCDummDRMdataReqTimeout(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDRMdataReqTimeout,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummDRMdataReqTimeout::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DRMdataReqTimeout",(tS32) 0x700d0f94);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDRMdataReqTimeout = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummDRMdataReqTimeout::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DRMdataReqTimeout", (tS32)0x700d0f94);
   (tVoid)myDpElem.bFillData((tVoid*)&tDRMdataReqTimeout, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummDRMdataReqTimeout::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummDRMdataReqTimeout::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclFCDummDRMdataReqTimeout::tGetData() {
   vUpdate();
   return tDRMdataReqTimeout;
};
tS32 dp_tclFCDummDRMdataReqTimeout::s32GetData(tU16& tDRMdataReqTimeoutParam) { 
   vUpdate();
   tDRMdataReqTimeoutParam = tDRMdataReqTimeout;
   return _s32Status;
}
tS32 dp_tclFCDummDRMdataReqTimeout::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DRMdataReqTimeout", (tS32)0x700d0f94);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummDRMdataReqTimeout::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummDRMdataReqTimeout::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummDRMdataReqTimeout::s32SetData(tU16 &tDRMdataReqTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tDRMdataReqTimeout,(tVoid*)&tDRMdataReqTimeoutParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDRMdataReqTimeoutParam' in function 'dp_tclFCDummDRMdataReqTimeout::vSetData(tU16)' could be made const reference
tS32 dp_tclFCDummDRMdataReqTimeout::s32SetData(const tU16 &tDRMdataReqTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tDRMdataReqTimeout,(tVoid*)&tDRMdataReqTimeoutParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDRMdataReqTimeoutParam' in function 'dp_tclFCDummDRMdataReqTimeout::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummDRMdataReqTimeout::u8GetData(tU16& tDRMdataReqTimeoutParam) {  
   vUpdate();
   tDRMdataReqTimeoutParam = tDRMdataReqTimeout;
   return _u8DataStatus;
}
tVoid dp_tclFCDummDRMdataReqTimeout::vSetData(tU16 &tDRMdataReqTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tDRMdataReqTimeout,(tVoid*)&tDRMdataReqTimeoutParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDRMdataReqTimeoutParam' in function 'dp_tclFCDummDRMdataReqTimeout::vSetData(tU16)' could be made const reference
tVoid dp_tclFCDummDRMdataReqTimeout::vSetData(const tU16 &tDRMdataReqTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tDRMdataReqTimeout,(tVoid*)&tDRMdataReqTimeoutParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDRMdataReqTimeoutParam' in function 'dp_tclFCDummDRMdataReqTimeout::vSetData(tU16)' could be made const reference
tU8   dp_tclFCDummDRMdataReqTimeout::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummDRMdataReqTimeout::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "DRMdataReqTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummDRMdataReqTimeout::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "DRMdataReqTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummDRMdataReqTimeout::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DRMdataReqTimeout", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element DRMdataReqTimeout has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DataDictionaryVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummDataDictionaryVersion::dp_tclFCDummDataDictionaryVersion(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummDataDictionaryVersion::s32SetData(tString &tDataDictionaryVersionParam) {
   tU32 u32Len = (tU32)strlen(tDataDictionaryVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("DataDictionaryVersion", (tS32)0x5087c3da);
      (tVoid)myDpElem.bFillData((tVoid*)tDataDictionaryVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummDataDictionaryVersion::s32SetData(const tString &tDataDictionaryVersionParam) {
   tU32 u32Len = (tU32)strlen(tDataDictionaryVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("DataDictionaryVersion", (tS32)0x5087c3da);
      (tVoid)myDpElem.bFillData((tVoid*)tDataDictionaryVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummDataDictionaryVersion::s32GetData(tString &tDataDictionaryVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("DataDictionaryVersion", (tS32)0x5087c3da);
   (tVoid)memset(tDataDictionaryVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tDataDictionaryVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummDataDictionaryVersion::s32GetData(const tString &tDataDictionaryVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("DataDictionaryVersion", (tS32)0x5087c3da);
   (tVoid)memset(tDataDictionaryVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tDataDictionaryVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummDataDictionaryVersion::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummDataDictionaryVersion::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummDataDictionaryVersion::u32GetData(tString &tDataDictionaryVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tDataDictionaryVersionParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummDataDictionaryVersion::u32GetData(const tString &tDataDictionaryVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tDataDictionaryVersionParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummDataDictionaryVersion::vSetData(tString &tDataDictionaryVersionParam){(tVoid)s32SetData(tDataDictionaryVersionParam);};
   tVoid dp_tclFCDummDataDictionaryVersion::vSetData(const tString &tDataDictionaryVersionParam){(tVoid)s32SetData(tDataDictionaryVersionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummDataDictionaryVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "DataDictionaryVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummDataDictionaryVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "DataDictionaryVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummDataDictionaryVersion::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DataDictionaryVersion", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element DataDictionaryVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DevType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummDevType::dp_tclFCDummDevType(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummDevType::s32SetData(tString &tDevTypeParam) {
   tU32 u32Len = (tU32)strlen(tDevTypeParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("DevType", (tS32)0x165ecd);
      (tVoid)myDpElem.bFillData((tVoid*)tDevTypeParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummDevType::s32SetData(const tString &tDevTypeParam) {
   tU32 u32Len = (tU32)strlen(tDevTypeParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("DevType", (tS32)0x165ecd);
      (tVoid)myDpElem.bFillData((tVoid*)tDevTypeParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummDevType::s32GetData(tString &tDevTypeParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("DevType", (tS32)0x165ecd);
   (tVoid)memset(tDevTypeParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tDevTypeParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummDevType::s32GetData(const tString &tDevTypeParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("DevType", (tS32)0x165ecd);
   (tVoid)memset(tDevTypeParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tDevTypeParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummDevType::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummDevType::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummDevType::u32GetData(tString &tDevTypeParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tDevTypeParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummDevType::u32GetData(const tString &tDevTypeParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tDevTypeParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummDevType::vSetData(tString &tDevTypeParam){(tVoid)s32SetData(tDevTypeParam);};
   tVoid dp_tclFCDummDevType::vSetData(const tString &tDevTypeParam){(tVoid)s32SetData(tDevTypeParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummDevType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "DevType", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummDevType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "DevType", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummDevType::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DevType", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element DevType has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTSessionTimeOut"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTSessionTimeOut::dp_tclFCDummMQTTSessionTimeOut(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTSessionTimeOut,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTSessionTimeOut::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTSessionTimeOut",(tS32) 0xd5494955);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tMQTTSessionTimeOut = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTSessionTimeOut::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTSessionTimeOut", (tS32)0xd5494955);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTSessionTimeOut, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTSessionTimeOut::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTSessionTimeOut::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclFCDummMQTTSessionTimeOut::tGetData() {
   vUpdate();
   return tMQTTSessionTimeOut;
};
tS32 dp_tclFCDummMQTTSessionTimeOut::s32GetData(tU16& tMQTTSessionTimeOutParam) { 
   vUpdate();
   tMQTTSessionTimeOutParam = tMQTTSessionTimeOut;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTSessionTimeOut::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTSessionTimeOut", (tS32)0xd5494955);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTSessionTimeOut::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTSessionTimeOut::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTSessionTimeOut::s32SetData(tU16 &tMQTTSessionTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTSessionTimeOut,(tVoid*)&tMQTTSessionTimeOutParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTSessionTimeOutParam' in function 'dp_tclFCDummMQTTSessionTimeOut::vSetData(tU16)' could be made const reference
tS32 dp_tclFCDummMQTTSessionTimeOut::s32SetData(const tU16 &tMQTTSessionTimeOutParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTSessionTimeOut,(tVoid*)&tMQTTSessionTimeOutParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTSessionTimeOutParam' in function 'dp_tclFCDummMQTTSessionTimeOut::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTSessionTimeOut::u8GetData(tU16& tMQTTSessionTimeOutParam) {  
   vUpdate();
   tMQTTSessionTimeOutParam = tMQTTSessionTimeOut;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTSessionTimeOut::vSetData(tU16 &tMQTTSessionTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTSessionTimeOut,(tVoid*)&tMQTTSessionTimeOutParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMQTTSessionTimeOutParam' in function 'dp_tclFCDummMQTTSessionTimeOut::vSetData(tU16)' could be made const reference
tVoid dp_tclFCDummMQTTSessionTimeOut::vSetData(const tU16 &tMQTTSessionTimeOutParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTSessionTimeOut,(tVoid*)&tMQTTSessionTimeOutParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMQTTSessionTimeOutParam' in function 'dp_tclFCDummMQTTSessionTimeOut::vSetData(tU16)' could be made const reference
tU8   dp_tclFCDummMQTTSessionTimeOut::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTSessionTimeOut::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTSessionTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTSessionTimeOut::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTSessionTimeOut", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTSessionTimeOut::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTSessionTimeOut", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTSessionTimeOut has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NaviUnitId"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummNaviUnitId::dp_tclFCDummNaviUnitId(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCDummNaviUnitId::s32SetData(tString &tNaviUnitIdParam) {
   tU32 u32Len = (tU32)strlen(tNaviUnitIdParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("NaviUnitId", (tS32)0xc01cd07);
      (tVoid)myDpElem.bFillData((tVoid*)tNaviUnitIdParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummNaviUnitId::s32SetData(const tString &tNaviUnitIdParam) {
   tU32 u32Len = (tU32)strlen(tNaviUnitIdParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("NaviUnitId", (tS32)0xc01cd07);
      (tVoid)myDpElem.bFillData((tVoid*)tNaviUnitIdParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCDummNaviUnitId::s32GetData(tString &tNaviUnitIdParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("NaviUnitId", (tS32)0xc01cd07);
   (tVoid)memset(tNaviUnitIdParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tNaviUnitIdParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCDummNaviUnitId::s32GetData(const tString &tNaviUnitIdParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("NaviUnitId", (tS32)0xc01cd07);
   (tVoid)memset(tNaviUnitIdParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tNaviUnitIdParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCDummNaviUnitId::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCDummNaviUnitId::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCDummNaviUnitId::u32GetData(tString &tNaviUnitIdParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tNaviUnitIdParam, u32StringBufLen);
   };
    tU32  dp_tclFCDummNaviUnitId::u32GetData(const tString &tNaviUnitIdParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tNaviUnitIdParam, u32StringBufLen);
   };
   tVoid dp_tclFCDummNaviUnitId::vSetData(tString &tNaviUnitIdParam){(tVoid)s32SetData(tNaviUnitIdParam);};
   tVoid dp_tclFCDummNaviUnitId::vSetData(const tString &tNaviUnitIdParam){(tVoid)s32SetData(tNaviUnitIdParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCDummNaviUnitId::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "NaviUnitId", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummNaviUnitId::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "NaviUnitId", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCDummNaviUnitId::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NaviUnitId", DP_U32_POOL_ID_FCDUMM);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
		}
		else
		{
			fprintf(stdout,"Element NaviUnitId has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MqttLastCompressionMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMqttLastCompressionMode::dp_tclFCDummMqttLastCompressionMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMqttLastCompressionMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMqttLastCompressionMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MqttLastCompressionMode",(tS32) 0x258adfe5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMqttLastCompressionMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMqttLastCompressionMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MqttLastCompressionMode", (tS32)0x258adfe5);
   (tVoid)myDpElem.bFillData((tVoid*)&tMqttLastCompressionMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMqttLastCompressionMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMqttLastCompressionMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMqttLastCompressionMode::tGetData() {
   vUpdate();
   return tMqttLastCompressionMode;
};
tS32 dp_tclFCDummMqttLastCompressionMode::s32GetData(tU8& tMqttLastCompressionModeParam) { 
   vUpdate();
   tMqttLastCompressionModeParam = tMqttLastCompressionMode;
   return _s32Status;
}
tS32 dp_tclFCDummMqttLastCompressionMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MqttLastCompressionMode", (tS32)0x258adfe5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMqttLastCompressionMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMqttLastCompressionMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMqttLastCompressionMode::s32SetData(tU8 &tMqttLastCompressionModeParam) {
   //init parameter
   (tVoid)memcpy(&tMqttLastCompressionMode,(tVoid*)&tMqttLastCompressionModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMqttLastCompressionModeParam' in function 'dp_tclFCDummMqttLastCompressionMode::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMqttLastCompressionMode::s32SetData(const tU8 &tMqttLastCompressionModeParam) {
   //init parameter
   (tVoid)memcpy(&tMqttLastCompressionMode,(tVoid*)&tMqttLastCompressionModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMqttLastCompressionModeParam' in function 'dp_tclFCDummMqttLastCompressionMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMqttLastCompressionMode::u8GetData(tU8& tMqttLastCompressionModeParam) {  
   vUpdate();
   tMqttLastCompressionModeParam = tMqttLastCompressionMode;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMqttLastCompressionMode::vSetData(tU8 &tMqttLastCompressionModeParam) { 
   //init parameter
   (tVoid)memcpy(&tMqttLastCompressionMode,(tVoid*)&tMqttLastCompressionModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMqttLastCompressionModeParam' in function 'dp_tclFCDummMqttLastCompressionMode::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMqttLastCompressionMode::vSetData(const tU8 &tMqttLastCompressionModeParam) { 
   //init parameter
   (tVoid)memcpy(&tMqttLastCompressionMode,(tVoid*)&tMqttLastCompressionModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMqttLastCompressionModeParam' in function 'dp_tclFCDummMqttLastCompressionMode::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMqttLastCompressionMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMqttLastCompressionMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MqttLastCompressionMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMqttLastCompressionMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MqttLastCompressionMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMqttLastCompressionMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MqttLastCompressionMode", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MqttLastCompressionMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MqttStunnelStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMqttStunnelStatus::dp_tclFCDummMqttStunnelStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMqttStunnelStatus,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMqttStunnelStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MqttStunnelStatus",(tS32) 0xaedcde07);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMqttStunnelStatus = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMqttStunnelStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MqttStunnelStatus", (tS32)0xaedcde07);
   (tVoid)myDpElem.bFillData((tVoid*)&tMqttStunnelStatus, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMqttStunnelStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMqttStunnelStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMqttStunnelStatus::tGetData() {
   vUpdate();
   return tMqttStunnelStatus;
};
tS32 dp_tclFCDummMqttStunnelStatus::s32GetData(tU8& tMqttStunnelStatusParam) { 
   vUpdate();
   tMqttStunnelStatusParam = tMqttStunnelStatus;
   return _s32Status;
}
tS32 dp_tclFCDummMqttStunnelStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MqttStunnelStatus", (tS32)0xaedcde07);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMqttStunnelStatus::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMqttStunnelStatus::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMqttStunnelStatus::s32SetData(tU8 &tMqttStunnelStatusParam) {
   //init parameter
   (tVoid)memcpy(&tMqttStunnelStatus,(tVoid*)&tMqttStunnelStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMqttStunnelStatusParam' in function 'dp_tclFCDummMqttStunnelStatus::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMqttStunnelStatus::s32SetData(const tU8 &tMqttStunnelStatusParam) {
   //init parameter
   (tVoid)memcpy(&tMqttStunnelStatus,(tVoid*)&tMqttStunnelStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMqttStunnelStatusParam' in function 'dp_tclFCDummMqttStunnelStatus::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMqttStunnelStatus::u8GetData(tU8& tMqttStunnelStatusParam) {  
   vUpdate();
   tMqttStunnelStatusParam = tMqttStunnelStatus;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMqttStunnelStatus::vSetData(tU8 &tMqttStunnelStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tMqttStunnelStatus,(tVoid*)&tMqttStunnelStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMqttStunnelStatusParam' in function 'dp_tclFCDummMqttStunnelStatus::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMqttStunnelStatus::vSetData(const tU8 &tMqttStunnelStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tMqttStunnelStatus,(tVoid*)&tMqttStunnelStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMqttStunnelStatusParam' in function 'dp_tclFCDummMqttStunnelStatus::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMqttStunnelStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMqttStunnelStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MqttStunnelStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMqttStunnelStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MqttStunnelStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMqttStunnelStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MqttStunnelStatus", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MqttStunnelStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MQTTChannel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummMQTTChannel::dp_tclFCDummMQTTChannel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMQTTChannel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummMQTTChannel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MQTTChannel",(tS32) 0x38aed0ff);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMQTTChannel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummMQTTChannel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MQTTChannel", (tS32)0x38aed0ff);
   (tVoid)myDpElem.bFillData((tVoid*)&tMQTTChannel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummMQTTChannel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummMQTTChannel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCDummMQTTChannel::tGetData() {
   vUpdate();
   return tMQTTChannel;
};
tS32 dp_tclFCDummMQTTChannel::s32GetData(tU8& tMQTTChannelParam) { 
   vUpdate();
   tMQTTChannelParam = tMQTTChannel;
   return _s32Status;
}
tS32 dp_tclFCDummMQTTChannel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MQTTChannel", (tS32)0x38aed0ff);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummMQTTChannel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummMQTTChannel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummMQTTChannel::s32SetData(tU8 &tMQTTChannelParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTChannel,(tVoid*)&tMQTTChannelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTChannelParam' in function 'dp_tclFCDummMQTTChannel::vSetData(tU8)' could be made const reference
tS32 dp_tclFCDummMQTTChannel::s32SetData(const tU8 &tMQTTChannelParam) {
   //init parameter
   (tVoid)memcpy(&tMQTTChannel,(tVoid*)&tMQTTChannelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMQTTChannelParam' in function 'dp_tclFCDummMQTTChannel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummMQTTChannel::u8GetData(tU8& tMQTTChannelParam) {  
   vUpdate();
   tMQTTChannelParam = tMQTTChannel;
   return _u8DataStatus;
}
tVoid dp_tclFCDummMQTTChannel::vSetData(tU8 &tMQTTChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTChannel,(tVoid*)&tMQTTChannelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTChannelParam' in function 'dp_tclFCDummMQTTChannel::vSetData(tU8)' could be made const reference
tVoid dp_tclFCDummMQTTChannel::vSetData(const tU8 &tMQTTChannelParam) { 
   //init parameter
   (tVoid)memcpy(&tMQTTChannel,(tVoid*)&tMQTTChannelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMQTTChannelParam' in function 'dp_tclFCDummMQTTChannel::vSetData(tU8)' could be made const reference
tU8   dp_tclFCDummMQTTChannel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummMQTTChannel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "MQTTChannel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTChannel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "MQTTChannel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummMQTTChannel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MQTTChannel", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element MQTTChannel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AuthEngine"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCDummAuthEngine::dp_tclFCDummAuthEngine(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAuthEngine,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCDummAuthEngine::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AuthEngine",(tS32) 0xaf23074);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tAuthEngine = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCDummAuthEngine::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AuthEngine", (tS32)0xaf23074);
   (tVoid)myDpElem.bFillData((tVoid*)&tAuthEngine, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCDummAuthEngine::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCDummAuthEngine::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCDummAuthEngine::tGetData() {
   vUpdate();
   return tAuthEngine;
};
tS32 dp_tclFCDummAuthEngine::s32GetData(tBool& tAuthEngineParam) { 
   vUpdate();
   tAuthEngineParam = tAuthEngine;
   return _s32Status;
}
tS32 dp_tclFCDummAuthEngine::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AuthEngine", (tS32)0xaf23074);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCDUMM, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCDummAuthEngine::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCDummAuthEngine::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCDummAuthEngine::s32SetData(tBool &tAuthEngineParam) {
   //init parameter
   (tVoid)memcpy(&tAuthEngine,(tVoid*)&tAuthEngineParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuthEngineParam' in function 'dp_tclFCDummAuthEngine::vSetData(tBool)' could be made const reference
tS32 dp_tclFCDummAuthEngine::s32SetData(const tBool &tAuthEngineParam) {
   //init parameter
   (tVoid)memcpy(&tAuthEngine,(tVoid*)&tAuthEngineParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuthEngineParam' in function 'dp_tclFCDummAuthEngine::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCDummAuthEngine::u8GetData(tBool& tAuthEngineParam) {  
   vUpdate();
   tAuthEngineParam = tAuthEngine;
   return _u8DataStatus;
}
tVoid dp_tclFCDummAuthEngine::vSetData(tBool &tAuthEngineParam) { 
   //init parameter
   (tVoid)memcpy(&tAuthEngine,(tVoid*)&tAuthEngineParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAuthEngineParam' in function 'dp_tclFCDummAuthEngine::vSetData(tBool)' could be made const reference
tVoid dp_tclFCDummAuthEngine::vSetData(const tBool &tAuthEngineParam) { 
   //init parameter
   (tVoid)memcpy(&tAuthEngine,(tVoid*)&tAuthEngineParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAuthEngineParam' in function 'dp_tclFCDummAuthEngine::vSetData(tBool)' could be made const reference
tU8   dp_tclFCDummAuthEngine::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCDummAuthEngine::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCDUMM, "AuthEngine", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummAuthEngine::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCDUMM, "AuthEngine", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCDummAuthEngine::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AuthEngine", DP_U32_POOL_ID_FCDUMM);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCDUMM);
   }
   else
   {
      fprintf(stdout,"Element AuthEngine has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
