
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDABTunerDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AnnoUserSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerDPAnnoUserSetting::dp_tclDABTunerDPAnnoUserSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAnnoUserSetting,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerDPAnnoUserSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AnnoUserSetting",(tS32) 0x6806eb25);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tAnnoUserSetting = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerDPAnnoUserSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AnnoUserSetting", (tS32)0x6806eb25);
   (tVoid)myDpElem.bFillData((tVoid*)&tAnnoUserSetting, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerDPAnnoUserSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerDPAnnoUserSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDABTunerDPAnnoUserSetting::tGetData() {
   vUpdate();
   return tAnnoUserSetting;
};
tS32 dp_tclDABTunerDPAnnoUserSetting::s32GetData(tU16& tAnnoUserSettingParam) { 
   vUpdate();
   tAnnoUserSettingParam = tAnnoUserSetting;
   return _s32Status;
}
tS32 dp_tclDABTunerDPAnnoUserSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AnnoUserSetting", (tS32)0x6806eb25);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerDPAnnoUserSetting::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerDPAnnoUserSetting::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerDPAnnoUserSetting::s32SetData(tU16 &tAnnoUserSettingParam) {
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerDPAnnoUserSetting::vSetData(tU16)' could be made const reference
tS32 dp_tclDABTunerDPAnnoUserSetting::s32SetData(const tU16 &tAnnoUserSettingParam) {
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerDPAnnoUserSetting::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerDPAnnoUserSetting::u8GetData(tU16& tAnnoUserSettingParam) {  
   vUpdate();
   tAnnoUserSettingParam = tAnnoUserSetting;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerDPAnnoUserSetting::vSetData(tU16 &tAnnoUserSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerDPAnnoUserSetting::vSetData(tU16)' could be made const reference
tVoid dp_tclDABTunerDPAnnoUserSetting::vSetData(const tU16 &tAnnoUserSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerDPAnnoUserSetting::vSetData(tU16)' could be made const reference
tU8   dp_tclDABTunerDPAnnoUserSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerDPAnnoUserSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERDP, "AnnoUserSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPAnnoUserSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERDP, "AnnoUserSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPAnnoUserSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AnnoUserSetting", DP_U32_POOL_ID_DABTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element AnnoUserSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ServiceLinkingMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerDPServiceLinkingMode::dp_tclDABTunerDPServiceLinkingMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tServiceLinkingMode,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerDPServiceLinkingMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ServiceLinkingMode",(tS32) 0x8f973062);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tServiceLinkingMode = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerDPServiceLinkingMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ServiceLinkingMode", (tS32)0x8f973062);
   (tVoid)myDpElem.bFillData((tVoid*)&tServiceLinkingMode, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerDPServiceLinkingMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerDPServiceLinkingMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDABTunerDPServiceLinkingMode::tGetData() {
   vUpdate();
   return tServiceLinkingMode;
};
tS32 dp_tclDABTunerDPServiceLinkingMode::s32GetData(tU16& tServiceLinkingModeParam) { 
   vUpdate();
   tServiceLinkingModeParam = tServiceLinkingMode;
   return _s32Status;
}
tS32 dp_tclDABTunerDPServiceLinkingMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ServiceLinkingMode", (tS32)0x8f973062);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerDPServiceLinkingMode::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerDPServiceLinkingMode::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerDPServiceLinkingMode::s32SetData(tU16 &tServiceLinkingModeParam) {
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerDPServiceLinkingMode::vSetData(tU16)' could be made const reference
tS32 dp_tclDABTunerDPServiceLinkingMode::s32SetData(const tU16 &tServiceLinkingModeParam) {
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerDPServiceLinkingMode::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerDPServiceLinkingMode::u8GetData(tU16& tServiceLinkingModeParam) {  
   vUpdate();
   tServiceLinkingModeParam = tServiceLinkingMode;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerDPServiceLinkingMode::vSetData(tU16 &tServiceLinkingModeParam) { 
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerDPServiceLinkingMode::vSetData(tU16)' could be made const reference
tVoid dp_tclDABTunerDPServiceLinkingMode::vSetData(const tU16 &tServiceLinkingModeParam) { 
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerDPServiceLinkingMode::vSetData(tU16)' could be made const reference
tU8   dp_tclDABTunerDPServiceLinkingMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerDPServiceLinkingMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERDP, "ServiceLinkingMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPServiceLinkingMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERDP, "ServiceLinkingMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPServiceLinkingMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ServiceLinkingMode", DP_U32_POOL_ID_DABTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element ServiceLinkingMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MTCMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerDPMTCMode::dp_tclDABTunerDPMTCMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMTCMode,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerDPMTCMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MTCMode",(tS32) 0x173375);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tMTCMode = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerDPMTCMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MTCMode", (tS32)0x173375);
   (tVoid)myDpElem.bFillData((tVoid*)&tMTCMode, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerDPMTCMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerDPMTCMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDABTunerDPMTCMode::tGetData() {
   vUpdate();
   return tMTCMode;
};
tS32 dp_tclDABTunerDPMTCMode::s32GetData(tU16& tMTCModeParam) { 
   vUpdate();
   tMTCModeParam = tMTCMode;
   return _s32Status;
}
tS32 dp_tclDABTunerDPMTCMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MTCMode", (tS32)0x173375);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerDPMTCMode::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerDPMTCMode::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerDPMTCMode::s32SetData(tU16 &tMTCModeParam) {
   //init parameter
   (tVoid)memcpy(&tMTCMode,(tVoid*)&tMTCModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMTCModeParam' in function 'dp_tclDABTunerDPMTCMode::vSetData(tU16)' could be made const reference
tS32 dp_tclDABTunerDPMTCMode::s32SetData(const tU16 &tMTCModeParam) {
   //init parameter
   (tVoid)memcpy(&tMTCMode,(tVoid*)&tMTCModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMTCModeParam' in function 'dp_tclDABTunerDPMTCMode::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerDPMTCMode::u8GetData(tU16& tMTCModeParam) {  
   vUpdate();
   tMTCModeParam = tMTCMode;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerDPMTCMode::vSetData(tU16 &tMTCModeParam) { 
   //init parameter
   (tVoid)memcpy(&tMTCMode,(tVoid*)&tMTCModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMTCModeParam' in function 'dp_tclDABTunerDPMTCMode::vSetData(tU16)' could be made const reference
tVoid dp_tclDABTunerDPMTCMode::vSetData(const tU16 &tMTCModeParam) { 
   //init parameter
   (tVoid)memcpy(&tMTCMode,(tVoid*)&tMTCModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMTCModeParam' in function 'dp_tclDABTunerDPMTCMode::vSetData(tU16)' could be made const reference
tU8   dp_tclDABTunerDPMTCMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerDPMTCMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERDP, "MTCMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPMTCMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERDP, "MTCMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPMTCMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MTCMode", DP_U32_POOL_ID_DABTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element MTCMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DABAvailability"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerDPDABAvailability::dp_tclDABTunerDPDABAvailability(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDABAvailability,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerDPDABAvailability::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DABAvailability",(tS32) 0xec44a2ce);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tDABAvailability = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerDPDABAvailability::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DABAvailability", (tS32)0xec44a2ce);
   (tVoid)myDpElem.bFillData((tVoid*)&tDABAvailability, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerDPDABAvailability::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerDPDABAvailability::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclDABTunerDPDABAvailability::tGetData() {
   vUpdate();
   return tDABAvailability;
};
tS32 dp_tclDABTunerDPDABAvailability::s32GetData(tBool& tDABAvailabilityParam) { 
   vUpdate();
   tDABAvailabilityParam = tDABAvailability;
   return _s32Status;
}
tS32 dp_tclDABTunerDPDABAvailability::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DABAvailability", (tS32)0xec44a2ce);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerDPDABAvailability::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerDPDABAvailability::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerDPDABAvailability::s32SetData(tBool &tDABAvailabilityParam) {
   //init parameter
   (tVoid)memcpy(&tDABAvailability,(tVoid*)&tDABAvailabilityParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDABAvailabilityParam' in function 'dp_tclDABTunerDPDABAvailability::vSetData(tBool)' could be made const reference
tS32 dp_tclDABTunerDPDABAvailability::s32SetData(const tBool &tDABAvailabilityParam) {
   //init parameter
   (tVoid)memcpy(&tDABAvailability,(tVoid*)&tDABAvailabilityParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDABAvailabilityParam' in function 'dp_tclDABTunerDPDABAvailability::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerDPDABAvailability::u8GetData(tBool& tDABAvailabilityParam) {  
   vUpdate();
   tDABAvailabilityParam = tDABAvailability;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerDPDABAvailability::vSetData(tBool &tDABAvailabilityParam) { 
   //init parameter
   (tVoid)memcpy(&tDABAvailability,(tVoid*)&tDABAvailabilityParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDABAvailabilityParam' in function 'dp_tclDABTunerDPDABAvailability::vSetData(tBool)' could be made const reference
tVoid dp_tclDABTunerDPDABAvailability::vSetData(const tBool &tDABAvailabilityParam) { 
   //init parameter
   (tVoid)memcpy(&tDABAvailability,(tVoid*)&tDABAvailabilityParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDABAvailabilityParam' in function 'dp_tclDABTunerDPDABAvailability::vSetData(tBool)' could be made const reference
tU8   dp_tclDABTunerDPDABAvailability::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerDPDABAvailability::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERDP, "DABAvailability", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPDABAvailability::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERDP, "DABAvailability", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPDABAvailability::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DABAvailability", DP_U32_POOL_ID_DABTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element DABAvailability has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CountryZone"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerDPCountryZone::dp_tclDABTunerDPCountryZone(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCountryZone,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerDPCountryZone::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CountryZone",(tS32) 0x374acf8c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tCountryZone = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerDPCountryZone::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CountryZone", (tS32)0x374acf8c);
   (tVoid)myDpElem.bFillData((tVoid*)&tCountryZone, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerDPCountryZone::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerDPCountryZone::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDABTunerDPCountryZone::tGetData() {
   vUpdate();
   return tCountryZone;
};
tS32 dp_tclDABTunerDPCountryZone::s32GetData(tU16& tCountryZoneParam) { 
   vUpdate();
   tCountryZoneParam = tCountryZone;
   return _s32Status;
}
tS32 dp_tclDABTunerDPCountryZone::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CountryZone", (tS32)0x374acf8c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerDPCountryZone::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerDPCountryZone::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerDPCountryZone::s32SetData(tU16 &tCountryZoneParam) {
   //init parameter
   (tVoid)memcpy(&tCountryZone,(tVoid*)&tCountryZoneParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCountryZoneParam' in function 'dp_tclDABTunerDPCountryZone::vSetData(tU16)' could be made const reference
tS32 dp_tclDABTunerDPCountryZone::s32SetData(const tU16 &tCountryZoneParam) {
   //init parameter
   (tVoid)memcpy(&tCountryZone,(tVoid*)&tCountryZoneParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCountryZoneParam' in function 'dp_tclDABTunerDPCountryZone::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerDPCountryZone::u8GetData(tU16& tCountryZoneParam) {  
   vUpdate();
   tCountryZoneParam = tCountryZone;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerDPCountryZone::vSetData(tU16 &tCountryZoneParam) { 
   //init parameter
   (tVoid)memcpy(&tCountryZone,(tVoid*)&tCountryZoneParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCountryZoneParam' in function 'dp_tclDABTunerDPCountryZone::vSetData(tU16)' could be made const reference
tVoid dp_tclDABTunerDPCountryZone::vSetData(const tU16 &tCountryZoneParam) { 
   //init parameter
   (tVoid)memcpy(&tCountryZone,(tVoid*)&tCountryZoneParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCountryZoneParam' in function 'dp_tclDABTunerDPCountryZone::vSetData(tU16)' could be made const reference
tU8   dp_tclDABTunerDPCountryZone::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerDPCountryZone::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERDP, "CountryZone", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPCountryZone::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERDP, "CountryZone", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPCountryZone::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CountryZone", DP_U32_POOL_ID_DABTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element CountryZone has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RdsStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerDPRdsStatus::dp_tclDABTunerDPRdsStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRdsStatus,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerDPRdsStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RdsStatus",(tS32) 0x280b081);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRdsStatus = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerDPRdsStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RdsStatus", (tS32)0x280b081);
   (tVoid)myDpElem.bFillData((tVoid*)&tRdsStatus, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerDPRdsStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerDPRdsStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDABTunerDPRdsStatus::tGetData() {
   vUpdate();
   return tRdsStatus;
};
tS32 dp_tclDABTunerDPRdsStatus::s32GetData(tU8& tRdsStatusParam) { 
   vUpdate();
   tRdsStatusParam = tRdsStatus;
   return _s32Status;
}
tS32 dp_tclDABTunerDPRdsStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RdsStatus", (tS32)0x280b081);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerDPRdsStatus::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerDPRdsStatus::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerDPRdsStatus::s32SetData(tU8 &tRdsStatusParam) {
   //init parameter
   (tVoid)memcpy(&tRdsStatus,(tVoid*)&tRdsStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRdsStatusParam' in function 'dp_tclDABTunerDPRdsStatus::vSetData(tU8)' could be made const reference
tS32 dp_tclDABTunerDPRdsStatus::s32SetData(const tU8 &tRdsStatusParam) {
   //init parameter
   (tVoid)memcpy(&tRdsStatus,(tVoid*)&tRdsStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRdsStatusParam' in function 'dp_tclDABTunerDPRdsStatus::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerDPRdsStatus::u8GetData(tU8& tRdsStatusParam) {  
   vUpdate();
   tRdsStatusParam = tRdsStatus;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerDPRdsStatus::vSetData(tU8 &tRdsStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tRdsStatus,(tVoid*)&tRdsStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRdsStatusParam' in function 'dp_tclDABTunerDPRdsStatus::vSetData(tU8)' could be made const reference
tVoid dp_tclDABTunerDPRdsStatus::vSetData(const tU8 &tRdsStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tRdsStatus,(tVoid*)&tRdsStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRdsStatusParam' in function 'dp_tclDABTunerDPRdsStatus::vSetData(tU8)' could be made const reference
tU8   dp_tclDABTunerDPRdsStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerDPRdsStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERDP, "RdsStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPRdsStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERDP, "RdsStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerDPRdsStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RdsStatus", DP_U32_POOL_ID_DABTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element RdsStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
