#ifndef _DP_FI_DPINTERNDATA_H
#define _DP_FI_DPINTERNDATA_H

extern tVoid vInitDpInternData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDpInternDataTrElements{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDpInternDataTrElements(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpInternDataTrElements() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tTrElementsParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tTrElementsParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tTrElementsParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDpInternDataTrPools{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDpInternDataTrPools(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpInternDataTrPools() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tTrPoolsParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tTrPoolsParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tTrPoolsParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
