#ifndef _DP_FI_DPENDUSERMODE_H
#define _DP_FI_DPENDUSERMODE_H

extern tVoid vInitDpEndUserMode(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDpEndUserModeDpEndUserCurrent{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDpEndUserCurrent;
   
public:
   dp_tclDpEndUserModeDpEndUserCurrent(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpEndUserModeDpEndUserCurrent() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDpEndUserCurrentParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDpEndUserCurrentParam);
   tS32  s32SetData(const tU8 &tDpEndUserCurrentParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDpEndUserCurrentParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDpEndUserCurrentParam);
   tVoid vSetData(const tU8& tDpEndUserCurrentParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDpEndUserModeDpEndUserUsed{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDpEndUserModeDpEndUserUsed(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpEndUserModeDpEndUserUsed() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tDpEndUserUsedParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tDpEndUserUsedParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tDpEndUserUsedParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDpEndUserModeDpEndUserBank{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDpEndUserModeDpEndUserBank(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpEndUserModeDpEndUserBank() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tDpEndUserBankParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tDpEndUserBankParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tDpEndUserBankParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDpEndUserModeDpEndUserBankUsed{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDpEndUserModeDpEndUserBankUsed(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpEndUserModeDpEndUserBankUsed() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tDpEndUserBankUsedParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tDpEndUserBankUsedParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tDpEndUserBankUsedParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
