#ifndef _DP_FI_CSMDPPDD_H
#define _DP_FI_CSMDPPDD_H

extern tVoid vInitCsmDpPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define CSM_S_IMPORT_INTERFACE_DP_CSM_PDD 
#include "../../di_can/csm_dp_if.h"
//lint +e750




class dp_tclCsmDpPDDSlotNr{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSlotNr;
   
public:
   dp_tclCsmDpPDDSlotNr(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDSlotNr() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSlotNrParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSlotNrParam);
   tS32  s32SetData(const tU8 &tSlotNrParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSlotNrParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSlotNrParam);
   tVoid vSetData(const tU8& tSlotNrParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDSteeringWheelType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSteeringWheelType;
   
public:
   dp_tclCsmDpPDDSteeringWheelType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDSteeringWheelType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSteeringWheelTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSteeringWheelTypeParam);
   tS32  s32SetData(const tU8 &tSteeringWheelTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSteeringWheelTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSteeringWheelTypeParam);
   tVoid vSetData(const tU8& tSteeringWheelTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDVoiceRec{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVoiceRec;
   
public:
   dp_tclCsmDpPDDVoiceRec(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDVoiceRec() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVoiceRecParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVoiceRecParam);
   tS32  s32SetData(const tU8 &tVoiceRecParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVoiceRecParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVoiceRecParam);
   tVoid vSetData(const tU8& tVoiceRecParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDFuelType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tFuelType;
   
public:
   dp_tclCsmDpPDDFuelType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDFuelType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tFuelTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tFuelTypeParam);
   tS32  s32SetData(const tU8 &tFuelTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tFuelTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tFuelTypeParam);
   tVoid vSetData(const tU8& tFuelTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDCameraSystem{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCameraSystem;
   
public:
   dp_tclCsmDpPDDCameraSystem(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDCameraSystem() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCameraSystemParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCameraSystemParam);
   tS32  s32SetData(const tU8 &tCameraSystemParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCameraSystemParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCameraSystemParam);
   tVoid vSetData(const tU8& tCameraSystemParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDIpaHfp{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tIpaHfp;
   
public:
   dp_tclCsmDpPDDIpaHfp(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDIpaHfp() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tIpaHfpParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tIpaHfpParam);
   tS32  s32SetData(const tU8 &tIpaHfpParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tIpaHfpParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tIpaHfpParam);
   tVoid vSetData(const tU8& tIpaHfpParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDSonar{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSonar;
   
public:
   dp_tclCsmDpPDDSonar(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDSonar() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSonarParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSonarParam);
   tS32  s32SetData(const tU8 &tSonarParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSonarParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSonarParam);
   tVoid vSetData(const tU8& tSonarParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDAntiTheft{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAntiTheft;
   
public:
   dp_tclCsmDpPDDAntiTheft(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDAntiTheft() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAntiTheftParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAntiTheftParam);
   tS32  s32SetData(const tU8 &tAntiTheftParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAntiTheftParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAntiTheftParam);
   tVoid vSetData(const tU8& tAntiTheftParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDAnticipatoryLine{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAnticipatoryLine;
   
public:
   dp_tclCsmDpPDDAnticipatoryLine(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDAnticipatoryLine() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAnticipatoryLineParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAnticipatoryLineParam);
   tS32  s32SetData(const tU8 &tAnticipatoryLineParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAnticipatoryLineParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAnticipatoryLineParam);
   tVoid vSetData(const tU8& tAnticipatoryLineParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDSteeringMsg{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSteeringMsg;
   
public:
   dp_tclCsmDpPDDSteeringMsg(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDSteeringMsg() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSteeringMsgParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSteeringMsgParam);
   tS32  s32SetData(const tU8 &tSteeringMsgParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSteeringMsgParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSteeringMsgParam);
   tVoid vSetData(const tU8& tSteeringMsgParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDTrafficSignRec{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTrafficSignRec;
   
public:
   dp_tclCsmDpPDDTrafficSignRec(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDTrafficSignRec() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTrafficSignRecParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTrafficSignRecParam);
   tS32  s32SetData(const tU8 &tTrafficSignRecParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTrafficSignRecParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTrafficSignRecParam);
   tVoid vSetData(const tU8& tTrafficSignRecParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDNaviFunc{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tNaviFunc;
   
public:
   dp_tclCsmDpPDDNaviFunc(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDNaviFunc() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tNaviFuncParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tNaviFuncParam);
   tS32  s32SetData(const tU8 &tNaviFuncParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tNaviFuncParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tNaviFuncParam);
   tVoid vSetData(const tU8& tNaviFuncParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDRCSType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRCSType;
   
public:
   dp_tclCsmDpPDDRCSType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDRCSType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRCSTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRCSTypeParam);
   tS32  s32SetData(const tU8 &tRCSTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRCSTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRCSTypeParam);
   tVoid vSetData(const tU8& tRCSTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDITCommanderType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tITCommanderType;
   
public:
   dp_tclCsmDpPDDITCommanderType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDITCommanderType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tITCommanderTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tITCommanderTypeParam);
   tS32  s32SetData(const tU8 &tITCommanderTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tITCommanderTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tITCommanderTypeParam);
   tVoid vSetData(const tU8& tITCommanderTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDVCANMCANGateway{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVCANMCANGateway;
   
public:
   dp_tclCsmDpPDDVCANMCANGateway(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDVCANMCANGateway() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVCANMCANGatewayParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVCANMCANGatewayParam);
   tS32  s32SetData(const tU8 &tVCANMCANGatewayParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVCANMCANGatewayParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVCANMCANGatewayParam);
   tVoid vSetData(const tU8& tVCANMCANGatewayParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDFuelConsumptionInfo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tFuelConsumptionInfo;
   
public:
   dp_tclCsmDpPDDFuelConsumptionInfo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDFuelConsumptionInfo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tFuelConsumptionInfoParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tFuelConsumptionInfoParam);
   tS32  s32SetData(const tU8 &tFuelConsumptionInfoParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tFuelConsumptionInfoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tFuelConsumptionInfoParam);
   tVoid vSetData(const tU8& tFuelConsumptionInfoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDTPMS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTPMS;
   
public:
   dp_tclCsmDpPDDTPMS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDTPMS() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTPMSParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTPMSParam);
   tS32  s32SetData(const tU8 &tTPMSParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTPMSParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTPMSParam);
   tVoid vSetData(const tU8& tTPMSParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDVDC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVDC;
   
public:
   dp_tclCsmDpPDDVDC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDVDC() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVDCParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVDCParam);
   tS32  s32SetData(const tU8 &tVDCParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVDCParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVDCParam);
   tVoid vSetData(const tU8& tVDCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDAdFunction{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdFunction;
   
public:
   dp_tclCsmDpPDDAdFunction(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDAdFunction() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdFunctionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdFunctionParam);
   tS32  s32SetData(const tU8 &tAdFunctionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdFunctionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdFunctionParam);
   tVoid vSetData(const tU8& tAdFunctionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDVehicleSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVehicleSetting;
   
public:
   dp_tclCsmDpPDDVehicleSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDVehicleSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVehicleSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVehicleSettingParam);
   tS32  s32SetData(const tU8 &tVehicleSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVehicleSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVehicleSettingParam);
   tVoid vSetData(const tU8& tVehicleSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDHudSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tHudSetting;
   
public:
   dp_tclCsmDpPDDHudSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDHudSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tHudSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tHudSettingParam);
   tS32  s32SetData(const tU8 &tHudSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tHudSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tHudSettingParam);
   tVoid vSetData(const tU8& tHudSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDHvacType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tHvacType;
   
public:
   dp_tclCsmDpPDDHvacType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDHvacType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tHvacTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tHvacTypeParam);
   tS32  s32SetData(const tU8 &tHvacTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tHvacTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tHvacTypeParam);
   tVoid vSetData(const tU8& tHvacTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDDigitalAssi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDigitalAssi;
   
public:
   dp_tclCsmDpPDDDigitalAssi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDDigitalAssi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDigitalAssiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDigitalAssiParam);
   tS32  s32SetData(const tU8 &tDigitalAssiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDigitalAssiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDigitalAssiParam);
   tVoid vSetData(const tU8& tDigitalAssiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCsmDpPDDSendCountryInfo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSendCountryInfo;
   
public:
   dp_tclCsmDpPDDSendCountryInfo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCsmDpPDDSendCountryInfo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSendCountryInfoParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSendCountryInfoParam);
   tS32  s32SetData(const tU8 &tSendCountryInfoParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSendCountryInfoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSendCountryInfoParam);
   tVoid vSetData(const tU8& tSendCountryInfoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
