
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclCsmDpPDD.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SlotNr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDSlotNr::dp_tclCsmDpPDDSlotNr(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSlotNr,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDSlotNr::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SlotNr",(tS32) 0x5405a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSlotNr = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDSlotNr::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SlotNr", (tS32)0x5405a);
   (tVoid)myDpElem.bFillData((tVoid*)&tSlotNr, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDSlotNr::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDSlotNr::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDSlotNr::tGetData() {
   vUpdate();
   return tSlotNr;
};
tS32 dp_tclCsmDpPDDSlotNr::s32GetData(tU8& tSlotNrParam) { 
   vUpdate();
   tSlotNrParam = tSlotNr;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDSlotNr::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SlotNr", (tS32)0x5405a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDSlotNr::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDSlotNr::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDSlotNr::s32SetData(tU8 &tSlotNrParam) {
   //init parameter
   (tVoid)memcpy(&tSlotNr,(tVoid*)&tSlotNrParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSlotNrParam' in function 'dp_tclCsmDpPDDSlotNr::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDSlotNr::s32SetData(const tU8 &tSlotNrParam) {
   //init parameter
   (tVoid)memcpy(&tSlotNr,(tVoid*)&tSlotNrParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSlotNrParam' in function 'dp_tclCsmDpPDDSlotNr::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDSlotNr::u8GetData(tU8& tSlotNrParam) {  
   vUpdate();
   tSlotNrParam = tSlotNr;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDSlotNr::vSetData(tU8 &tSlotNrParam) { 
   //init parameter
   (tVoid)memcpy(&tSlotNr,(tVoid*)&tSlotNrParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSlotNrParam' in function 'dp_tclCsmDpPDDSlotNr::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDSlotNr::vSetData(const tU8 &tSlotNrParam) { 
   //init parameter
   (tVoid)memcpy(&tSlotNr,(tVoid*)&tSlotNrParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSlotNrParam' in function 'dp_tclCsmDpPDDSlotNr::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDSlotNr::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDSlotNr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "SlotNr", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSlotNr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "SlotNr", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSlotNr::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SlotNr", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element SlotNr has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SteeringWheelType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDSteeringWheelType::dp_tclCsmDpPDDSteeringWheelType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSteeringWheelType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDSteeringWheelType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SteeringWheelType",(tS32) 0x32d4f3d0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSteeringWheelType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDSteeringWheelType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SteeringWheelType", (tS32)0x32d4f3d0);
   (tVoid)myDpElem.bFillData((tVoid*)&tSteeringWheelType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDSteeringWheelType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDSteeringWheelType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDSteeringWheelType::tGetData() {
   vUpdate();
   return tSteeringWheelType;
};
tS32 dp_tclCsmDpPDDSteeringWheelType::s32GetData(tU8& tSteeringWheelTypeParam) { 
   vUpdate();
   tSteeringWheelTypeParam = tSteeringWheelType;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDSteeringWheelType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SteeringWheelType", (tS32)0x32d4f3d0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDSteeringWheelType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDSteeringWheelType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDSteeringWheelType::s32SetData(tU8 &tSteeringWheelTypeParam) {
   //init parameter
   (tVoid)memcpy(&tSteeringWheelType,(tVoid*)&tSteeringWheelTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSteeringWheelTypeParam' in function 'dp_tclCsmDpPDDSteeringWheelType::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDSteeringWheelType::s32SetData(const tU8 &tSteeringWheelTypeParam) {
   //init parameter
   (tVoid)memcpy(&tSteeringWheelType,(tVoid*)&tSteeringWheelTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSteeringWheelTypeParam' in function 'dp_tclCsmDpPDDSteeringWheelType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDSteeringWheelType::u8GetData(tU8& tSteeringWheelTypeParam) {  
   vUpdate();
   tSteeringWheelTypeParam = tSteeringWheelType;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDSteeringWheelType::vSetData(tU8 &tSteeringWheelTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tSteeringWheelType,(tVoid*)&tSteeringWheelTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSteeringWheelTypeParam' in function 'dp_tclCsmDpPDDSteeringWheelType::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDSteeringWheelType::vSetData(const tU8 &tSteeringWheelTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tSteeringWheelType,(tVoid*)&tSteeringWheelTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSteeringWheelTypeParam' in function 'dp_tclCsmDpPDDSteeringWheelType::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDSteeringWheelType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDSteeringWheelType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "SteeringWheelType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSteeringWheelType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "SteeringWheelType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSteeringWheelType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SteeringWheelType", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element SteeringWheelType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VoiceRec"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDVoiceRec::dp_tclCsmDpPDDVoiceRec(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVoiceRec,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDVoiceRec::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VoiceRec",(tS32) 0x872b24);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVoiceRec = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDVoiceRec::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VoiceRec", (tS32)0x872b24);
   (tVoid)myDpElem.bFillData((tVoid*)&tVoiceRec, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDVoiceRec::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDVoiceRec::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDVoiceRec::tGetData() {
   vUpdate();
   return tVoiceRec;
};
tS32 dp_tclCsmDpPDDVoiceRec::s32GetData(tU8& tVoiceRecParam) { 
   vUpdate();
   tVoiceRecParam = tVoiceRec;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDVoiceRec::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VoiceRec", (tS32)0x872b24);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDVoiceRec::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDVoiceRec::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDVoiceRec::s32SetData(tU8 &tVoiceRecParam) {
   //init parameter
   (tVoid)memcpy(&tVoiceRec,(tVoid*)&tVoiceRecParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVoiceRecParam' in function 'dp_tclCsmDpPDDVoiceRec::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDVoiceRec::s32SetData(const tU8 &tVoiceRecParam) {
   //init parameter
   (tVoid)memcpy(&tVoiceRec,(tVoid*)&tVoiceRecParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVoiceRecParam' in function 'dp_tclCsmDpPDDVoiceRec::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDVoiceRec::u8GetData(tU8& tVoiceRecParam) {  
   vUpdate();
   tVoiceRecParam = tVoiceRec;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDVoiceRec::vSetData(tU8 &tVoiceRecParam) { 
   //init parameter
   (tVoid)memcpy(&tVoiceRec,(tVoid*)&tVoiceRecParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVoiceRecParam' in function 'dp_tclCsmDpPDDVoiceRec::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDVoiceRec::vSetData(const tU8 &tVoiceRecParam) { 
   //init parameter
   (tVoid)memcpy(&tVoiceRec,(tVoid*)&tVoiceRecParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVoiceRecParam' in function 'dp_tclCsmDpPDDVoiceRec::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDVoiceRec::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDVoiceRec::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "VoiceRec", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVoiceRec::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "VoiceRec", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVoiceRec::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VoiceRec", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element VoiceRec has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDFuelType::dp_tclCsmDpPDDFuelType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFuelType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDFuelType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FuelType",(tS32) 0x75676a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFuelType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDFuelType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FuelType", (tS32)0x75676a);
   (tVoid)myDpElem.bFillData((tVoid*)&tFuelType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDFuelType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDFuelType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDFuelType::tGetData() {
   vUpdate();
   return tFuelType;
};
tS32 dp_tclCsmDpPDDFuelType::s32GetData(tU8& tFuelTypeParam) { 
   vUpdate();
   tFuelTypeParam = tFuelType;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDFuelType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FuelType", (tS32)0x75676a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDFuelType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDFuelType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDFuelType::s32SetData(tU8 &tFuelTypeParam) {
   //init parameter
   (tVoid)memcpy(&tFuelType,(tVoid*)&tFuelTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelTypeParam' in function 'dp_tclCsmDpPDDFuelType::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDFuelType::s32SetData(const tU8 &tFuelTypeParam) {
   //init parameter
   (tVoid)memcpy(&tFuelType,(tVoid*)&tFuelTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelTypeParam' in function 'dp_tclCsmDpPDDFuelType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDFuelType::u8GetData(tU8& tFuelTypeParam) {  
   vUpdate();
   tFuelTypeParam = tFuelType;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDFuelType::vSetData(tU8 &tFuelTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelType,(tVoid*)&tFuelTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFuelTypeParam' in function 'dp_tclCsmDpPDDFuelType::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDFuelType::vSetData(const tU8 &tFuelTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelType,(tVoid*)&tFuelTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFuelTypeParam' in function 'dp_tclCsmDpPDDFuelType::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDFuelType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDFuelType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "FuelType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDFuelType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "FuelType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDFuelType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelType", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element FuelType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CameraSystem"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDCameraSystem::dp_tclCsmDpPDDCameraSystem(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCameraSystem,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDCameraSystem::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CameraSystem",(tS32) 0xb23e2e2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCameraSystem = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDCameraSystem::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CameraSystem", (tS32)0xb23e2e2);
   (tVoid)myDpElem.bFillData((tVoid*)&tCameraSystem, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDCameraSystem::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDCameraSystem::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDCameraSystem::tGetData() {
   vUpdate();
   return tCameraSystem;
};
tS32 dp_tclCsmDpPDDCameraSystem::s32GetData(tU8& tCameraSystemParam) { 
   vUpdate();
   tCameraSystemParam = tCameraSystem;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDCameraSystem::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CameraSystem", (tS32)0xb23e2e2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDCameraSystem::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDCameraSystem::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDCameraSystem::s32SetData(tU8 &tCameraSystemParam) {
   //init parameter
   (tVoid)memcpy(&tCameraSystem,(tVoid*)&tCameraSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCameraSystemParam' in function 'dp_tclCsmDpPDDCameraSystem::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDCameraSystem::s32SetData(const tU8 &tCameraSystemParam) {
   //init parameter
   (tVoid)memcpy(&tCameraSystem,(tVoid*)&tCameraSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCameraSystemParam' in function 'dp_tclCsmDpPDDCameraSystem::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDCameraSystem::u8GetData(tU8& tCameraSystemParam) {  
   vUpdate();
   tCameraSystemParam = tCameraSystem;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDCameraSystem::vSetData(tU8 &tCameraSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tCameraSystem,(tVoid*)&tCameraSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCameraSystemParam' in function 'dp_tclCsmDpPDDCameraSystem::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDCameraSystem::vSetData(const tU8 &tCameraSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tCameraSystem,(tVoid*)&tCameraSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCameraSystemParam' in function 'dp_tclCsmDpPDDCameraSystem::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDCameraSystem::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDCameraSystem::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "CameraSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDCameraSystem::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "CameraSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDCameraSystem::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CameraSystem", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element CameraSystem has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "IpaHfp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDIpaHfp::dp_tclCsmDpPDDIpaHfp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tIpaHfp,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDIpaHfp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("IpaHfp",(tS32) 0x4c560);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tIpaHfp = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDIpaHfp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("IpaHfp", (tS32)0x4c560);
   (tVoid)myDpElem.bFillData((tVoid*)&tIpaHfp, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDIpaHfp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDIpaHfp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDIpaHfp::tGetData() {
   vUpdate();
   return tIpaHfp;
};
tS32 dp_tclCsmDpPDDIpaHfp::s32GetData(tU8& tIpaHfpParam) { 
   vUpdate();
   tIpaHfpParam = tIpaHfp;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDIpaHfp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("IpaHfp", (tS32)0x4c560);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDIpaHfp::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDIpaHfp::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDIpaHfp::s32SetData(tU8 &tIpaHfpParam) {
   //init parameter
   (tVoid)memcpy(&tIpaHfp,(tVoid*)&tIpaHfpParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tIpaHfpParam' in function 'dp_tclCsmDpPDDIpaHfp::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDIpaHfp::s32SetData(const tU8 &tIpaHfpParam) {
   //init parameter
   (tVoid)memcpy(&tIpaHfp,(tVoid*)&tIpaHfpParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tIpaHfpParam' in function 'dp_tclCsmDpPDDIpaHfp::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDIpaHfp::u8GetData(tU8& tIpaHfpParam) {  
   vUpdate();
   tIpaHfpParam = tIpaHfp;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDIpaHfp::vSetData(tU8 &tIpaHfpParam) { 
   //init parameter
   (tVoid)memcpy(&tIpaHfp,(tVoid*)&tIpaHfpParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tIpaHfpParam' in function 'dp_tclCsmDpPDDIpaHfp::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDIpaHfp::vSetData(const tU8 &tIpaHfpParam) { 
   //init parameter
   (tVoid)memcpy(&tIpaHfp,(tVoid*)&tIpaHfpParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tIpaHfpParam' in function 'dp_tclCsmDpPDDIpaHfp::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDIpaHfp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDIpaHfp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "IpaHfp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDIpaHfp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "IpaHfp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDIpaHfp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: IpaHfp", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element IpaHfp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDSonar::dp_tclCsmDpPDDSonar(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDSonar::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar",(tS32) 0x10deb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSonar = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDSonar::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar", (tS32)0x10deb);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDSonar::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDSonar::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDSonar::tGetData() {
   vUpdate();
   return tSonar;
};
tS32 dp_tclCsmDpPDDSonar::s32GetData(tU8& tSonarParam) { 
   vUpdate();
   tSonarParam = tSonar;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDSonar::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar", (tS32)0x10deb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDSonar::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDSonar::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDSonar::s32SetData(tU8 &tSonarParam) {
   //init parameter
   (tVoid)memcpy(&tSonar,(tVoid*)&tSonarParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonarParam' in function 'dp_tclCsmDpPDDSonar::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDSonar::s32SetData(const tU8 &tSonarParam) {
   //init parameter
   (tVoid)memcpy(&tSonar,(tVoid*)&tSonarParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonarParam' in function 'dp_tclCsmDpPDDSonar::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDSonar::u8GetData(tU8& tSonarParam) {  
   vUpdate();
   tSonarParam = tSonar;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDSonar::vSetData(tU8 &tSonarParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar,(tVoid*)&tSonarParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSonarParam' in function 'dp_tclCsmDpPDDSonar::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDSonar::vSetData(const tU8 &tSonarParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar,(tVoid*)&tSonarParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSonarParam' in function 'dp_tclCsmDpPDDSonar::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDSonar::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDSonar::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "Sonar", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSonar::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "Sonar", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSonar::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element Sonar has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AntiTheft"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDAntiTheft::dp_tclCsmDpPDDAntiTheft(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAntiTheft,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDAntiTheft::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AntiTheft",(tS32) 0x2284573);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAntiTheft = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDAntiTheft::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AntiTheft", (tS32)0x2284573);
   (tVoid)myDpElem.bFillData((tVoid*)&tAntiTheft, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDAntiTheft::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDAntiTheft::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDAntiTheft::tGetData() {
   vUpdate();
   return tAntiTheft;
};
tS32 dp_tclCsmDpPDDAntiTheft::s32GetData(tU8& tAntiTheftParam) { 
   vUpdate();
   tAntiTheftParam = tAntiTheft;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDAntiTheft::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AntiTheft", (tS32)0x2284573);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDAntiTheft::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDAntiTheft::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDAntiTheft::s32SetData(tU8 &tAntiTheftParam) {
   //init parameter
   (tVoid)memcpy(&tAntiTheft,(tVoid*)&tAntiTheftParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAntiTheftParam' in function 'dp_tclCsmDpPDDAntiTheft::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDAntiTheft::s32SetData(const tU8 &tAntiTheftParam) {
   //init parameter
   (tVoid)memcpy(&tAntiTheft,(tVoid*)&tAntiTheftParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAntiTheftParam' in function 'dp_tclCsmDpPDDAntiTheft::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDAntiTheft::u8GetData(tU8& tAntiTheftParam) {  
   vUpdate();
   tAntiTheftParam = tAntiTheft;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDAntiTheft::vSetData(tU8 &tAntiTheftParam) { 
   //init parameter
   (tVoid)memcpy(&tAntiTheft,(tVoid*)&tAntiTheftParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAntiTheftParam' in function 'dp_tclCsmDpPDDAntiTheft::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDAntiTheft::vSetData(const tU8 &tAntiTheftParam) { 
   //init parameter
   (tVoid)memcpy(&tAntiTheft,(tVoid*)&tAntiTheftParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAntiTheftParam' in function 'dp_tclCsmDpPDDAntiTheft::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDAntiTheft::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDAntiTheft::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "AntiTheft", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDAntiTheft::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "AntiTheft", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDAntiTheft::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AntiTheft", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element AntiTheft has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AnticipatoryLine"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDAnticipatoryLine::dp_tclCsmDpPDDAnticipatoryLine(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAnticipatoryLine,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDAnticipatoryLine::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AnticipatoryLine",(tS32) 0x895a5fe7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAnticipatoryLine = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDAnticipatoryLine::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AnticipatoryLine", (tS32)0x895a5fe7);
   (tVoid)myDpElem.bFillData((tVoid*)&tAnticipatoryLine, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDAnticipatoryLine::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDAnticipatoryLine::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDAnticipatoryLine::tGetData() {
   vUpdate();
   return tAnticipatoryLine;
};
tS32 dp_tclCsmDpPDDAnticipatoryLine::s32GetData(tU8& tAnticipatoryLineParam) { 
   vUpdate();
   tAnticipatoryLineParam = tAnticipatoryLine;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDAnticipatoryLine::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AnticipatoryLine", (tS32)0x895a5fe7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDAnticipatoryLine::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDAnticipatoryLine::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDAnticipatoryLine::s32SetData(tU8 &tAnticipatoryLineParam) {
   //init parameter
   (tVoid)memcpy(&tAnticipatoryLine,(tVoid*)&tAnticipatoryLineParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAnticipatoryLineParam' in function 'dp_tclCsmDpPDDAnticipatoryLine::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDAnticipatoryLine::s32SetData(const tU8 &tAnticipatoryLineParam) {
   //init parameter
   (tVoid)memcpy(&tAnticipatoryLine,(tVoid*)&tAnticipatoryLineParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAnticipatoryLineParam' in function 'dp_tclCsmDpPDDAnticipatoryLine::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDAnticipatoryLine::u8GetData(tU8& tAnticipatoryLineParam) {  
   vUpdate();
   tAnticipatoryLineParam = tAnticipatoryLine;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDAnticipatoryLine::vSetData(tU8 &tAnticipatoryLineParam) { 
   //init parameter
   (tVoid)memcpy(&tAnticipatoryLine,(tVoid*)&tAnticipatoryLineParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAnticipatoryLineParam' in function 'dp_tclCsmDpPDDAnticipatoryLine::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDAnticipatoryLine::vSetData(const tU8 &tAnticipatoryLineParam) { 
   //init parameter
   (tVoid)memcpy(&tAnticipatoryLine,(tVoid*)&tAnticipatoryLineParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAnticipatoryLineParam' in function 'dp_tclCsmDpPDDAnticipatoryLine::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDAnticipatoryLine::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDAnticipatoryLine::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "AnticipatoryLine", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDAnticipatoryLine::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "AnticipatoryLine", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDAnticipatoryLine::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AnticipatoryLine", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element AnticipatoryLine has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SteeringMsg"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDSteeringMsg::dp_tclCsmDpPDDSteeringMsg(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSteeringMsg,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDSteeringMsg::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SteeringMsg",(tS32) 0x40c4e9c8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSteeringMsg = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDSteeringMsg::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SteeringMsg", (tS32)0x40c4e9c8);
   (tVoid)myDpElem.bFillData((tVoid*)&tSteeringMsg, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDSteeringMsg::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDSteeringMsg::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDSteeringMsg::tGetData() {
   vUpdate();
   return tSteeringMsg;
};
tS32 dp_tclCsmDpPDDSteeringMsg::s32GetData(tU8& tSteeringMsgParam) { 
   vUpdate();
   tSteeringMsgParam = tSteeringMsg;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDSteeringMsg::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SteeringMsg", (tS32)0x40c4e9c8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDSteeringMsg::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDSteeringMsg::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDSteeringMsg::s32SetData(tU8 &tSteeringMsgParam) {
   //init parameter
   (tVoid)memcpy(&tSteeringMsg,(tVoid*)&tSteeringMsgParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSteeringMsgParam' in function 'dp_tclCsmDpPDDSteeringMsg::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDSteeringMsg::s32SetData(const tU8 &tSteeringMsgParam) {
   //init parameter
   (tVoid)memcpy(&tSteeringMsg,(tVoid*)&tSteeringMsgParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSteeringMsgParam' in function 'dp_tclCsmDpPDDSteeringMsg::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDSteeringMsg::u8GetData(tU8& tSteeringMsgParam) {  
   vUpdate();
   tSteeringMsgParam = tSteeringMsg;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDSteeringMsg::vSetData(tU8 &tSteeringMsgParam) { 
   //init parameter
   (tVoid)memcpy(&tSteeringMsg,(tVoid*)&tSteeringMsgParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSteeringMsgParam' in function 'dp_tclCsmDpPDDSteeringMsg::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDSteeringMsg::vSetData(const tU8 &tSteeringMsgParam) { 
   //init parameter
   (tVoid)memcpy(&tSteeringMsg,(tVoid*)&tSteeringMsgParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSteeringMsgParam' in function 'dp_tclCsmDpPDDSteeringMsg::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDSteeringMsg::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDSteeringMsg::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "SteeringMsg", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSteeringMsg::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "SteeringMsg", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSteeringMsg::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SteeringMsg", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element SteeringMsg has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrafficSignRec"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDTrafficSignRec::dp_tclCsmDpPDDTrafficSignRec(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrafficSignRec,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDTrafficSignRec::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrafficSignRec",(tS32) 0xbf48910a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTrafficSignRec = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDTrafficSignRec::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrafficSignRec", (tS32)0xbf48910a);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrafficSignRec, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDTrafficSignRec::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDTrafficSignRec::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDTrafficSignRec::tGetData() {
   vUpdate();
   return tTrafficSignRec;
};
tS32 dp_tclCsmDpPDDTrafficSignRec::s32GetData(tU8& tTrafficSignRecParam) { 
   vUpdate();
   tTrafficSignRecParam = tTrafficSignRec;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDTrafficSignRec::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrafficSignRec", (tS32)0xbf48910a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDTrafficSignRec::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDTrafficSignRec::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDTrafficSignRec::s32SetData(tU8 &tTrafficSignRecParam) {
   //init parameter
   (tVoid)memcpy(&tTrafficSignRec,(tVoid*)&tTrafficSignRecParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrafficSignRecParam' in function 'dp_tclCsmDpPDDTrafficSignRec::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDTrafficSignRec::s32SetData(const tU8 &tTrafficSignRecParam) {
   //init parameter
   (tVoid)memcpy(&tTrafficSignRec,(tVoid*)&tTrafficSignRecParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrafficSignRecParam' in function 'dp_tclCsmDpPDDTrafficSignRec::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDTrafficSignRec::u8GetData(tU8& tTrafficSignRecParam) {  
   vUpdate();
   tTrafficSignRecParam = tTrafficSignRec;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDTrafficSignRec::vSetData(tU8 &tTrafficSignRecParam) { 
   //init parameter
   (tVoid)memcpy(&tTrafficSignRec,(tVoid*)&tTrafficSignRecParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTrafficSignRecParam' in function 'dp_tclCsmDpPDDTrafficSignRec::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDTrafficSignRec::vSetData(const tU8 &tTrafficSignRecParam) { 
   //init parameter
   (tVoid)memcpy(&tTrafficSignRec,(tVoid*)&tTrafficSignRecParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTrafficSignRecParam' in function 'dp_tclCsmDpPDDTrafficSignRec::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDTrafficSignRec::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDTrafficSignRec::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "TrafficSignRec", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDTrafficSignRec::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "TrafficSignRec", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDTrafficSignRec::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrafficSignRec", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element TrafficSignRec has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NaviFunc"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDNaviFunc::dp_tclCsmDpPDDNaviFunc(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNaviFunc,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDNaviFunc::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NaviFunc",(tS32) 0x7aed0a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tNaviFunc = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDNaviFunc::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NaviFunc", (tS32)0x7aed0a);
   (tVoid)myDpElem.bFillData((tVoid*)&tNaviFunc, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDNaviFunc::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDNaviFunc::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDNaviFunc::tGetData() {
   vUpdate();
   return tNaviFunc;
};
tS32 dp_tclCsmDpPDDNaviFunc::s32GetData(tU8& tNaviFuncParam) { 
   vUpdate();
   tNaviFuncParam = tNaviFunc;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDNaviFunc::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NaviFunc", (tS32)0x7aed0a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDNaviFunc::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDNaviFunc::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDNaviFunc::s32SetData(tU8 &tNaviFuncParam) {
   //init parameter
   (tVoid)memcpy(&tNaviFunc,(tVoid*)&tNaviFuncParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviFuncParam' in function 'dp_tclCsmDpPDDNaviFunc::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDNaviFunc::s32SetData(const tU8 &tNaviFuncParam) {
   //init parameter
   (tVoid)memcpy(&tNaviFunc,(tVoid*)&tNaviFuncParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNaviFuncParam' in function 'dp_tclCsmDpPDDNaviFunc::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDNaviFunc::u8GetData(tU8& tNaviFuncParam) {  
   vUpdate();
   tNaviFuncParam = tNaviFunc;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDNaviFunc::vSetData(tU8 &tNaviFuncParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviFunc,(tVoid*)&tNaviFuncParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNaviFuncParam' in function 'dp_tclCsmDpPDDNaviFunc::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDNaviFunc::vSetData(const tU8 &tNaviFuncParam) { 
   //init parameter
   (tVoid)memcpy(&tNaviFunc,(tVoid*)&tNaviFuncParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNaviFuncParam' in function 'dp_tclCsmDpPDDNaviFunc::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDNaviFunc::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDNaviFunc::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "NaviFunc", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDNaviFunc::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "NaviFunc", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDNaviFunc::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NaviFunc", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element NaviFunc has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RCSType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDRCSType::dp_tclCsmDpPDDRCSType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRCSType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDRCSType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RCSType",(tS32) 0x17c0ce);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRCSType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDRCSType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RCSType", (tS32)0x17c0ce);
   (tVoid)myDpElem.bFillData((tVoid*)&tRCSType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDRCSType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDRCSType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDRCSType::tGetData() {
   vUpdate();
   return tRCSType;
};
tS32 dp_tclCsmDpPDDRCSType::s32GetData(tU8& tRCSTypeParam) { 
   vUpdate();
   tRCSTypeParam = tRCSType;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDRCSType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RCSType", (tS32)0x17c0ce);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDRCSType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDRCSType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDRCSType::s32SetData(tU8 &tRCSTypeParam) {
   //init parameter
   (tVoid)memcpy(&tRCSType,(tVoid*)&tRCSTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRCSTypeParam' in function 'dp_tclCsmDpPDDRCSType::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDRCSType::s32SetData(const tU8 &tRCSTypeParam) {
   //init parameter
   (tVoid)memcpy(&tRCSType,(tVoid*)&tRCSTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRCSTypeParam' in function 'dp_tclCsmDpPDDRCSType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDRCSType::u8GetData(tU8& tRCSTypeParam) {  
   vUpdate();
   tRCSTypeParam = tRCSType;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDRCSType::vSetData(tU8 &tRCSTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tRCSType,(tVoid*)&tRCSTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRCSTypeParam' in function 'dp_tclCsmDpPDDRCSType::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDRCSType::vSetData(const tU8 &tRCSTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tRCSType,(tVoid*)&tRCSTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRCSTypeParam' in function 'dp_tclCsmDpPDDRCSType::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDRCSType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDRCSType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "RCSType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDRCSType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "RCSType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDRCSType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RCSType", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element RCSType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ITCommanderType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDITCommanderType::dp_tclCsmDpPDDITCommanderType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tITCommanderType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDITCommanderType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ITCommanderType",(tS32) 0xfe1a9721);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tITCommanderType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDITCommanderType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ITCommanderType", (tS32)0xfe1a9721);
   (tVoid)myDpElem.bFillData((tVoid*)&tITCommanderType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDITCommanderType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDITCommanderType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDITCommanderType::tGetData() {
   vUpdate();
   return tITCommanderType;
};
tS32 dp_tclCsmDpPDDITCommanderType::s32GetData(tU8& tITCommanderTypeParam) { 
   vUpdate();
   tITCommanderTypeParam = tITCommanderType;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDITCommanderType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ITCommanderType", (tS32)0xfe1a9721);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDITCommanderType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDITCommanderType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDITCommanderType::s32SetData(tU8 &tITCommanderTypeParam) {
   //init parameter
   (tVoid)memcpy(&tITCommanderType,(tVoid*)&tITCommanderTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tITCommanderTypeParam' in function 'dp_tclCsmDpPDDITCommanderType::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDITCommanderType::s32SetData(const tU8 &tITCommanderTypeParam) {
   //init parameter
   (tVoid)memcpy(&tITCommanderType,(tVoid*)&tITCommanderTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tITCommanderTypeParam' in function 'dp_tclCsmDpPDDITCommanderType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDITCommanderType::u8GetData(tU8& tITCommanderTypeParam) {  
   vUpdate();
   tITCommanderTypeParam = tITCommanderType;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDITCommanderType::vSetData(tU8 &tITCommanderTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tITCommanderType,(tVoid*)&tITCommanderTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tITCommanderTypeParam' in function 'dp_tclCsmDpPDDITCommanderType::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDITCommanderType::vSetData(const tU8 &tITCommanderTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tITCommanderType,(tVoid*)&tITCommanderTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tITCommanderTypeParam' in function 'dp_tclCsmDpPDDITCommanderType::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDITCommanderType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDITCommanderType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "ITCommanderType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDITCommanderType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "ITCommanderType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDITCommanderType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ITCommanderType", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element ITCommanderType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VCANMCANGateway"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDVCANMCANGateway::dp_tclCsmDpPDDVCANMCANGateway(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVCANMCANGateway,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDVCANMCANGateway::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VCANMCANGateway",(tS32) 0xcfac26d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVCANMCANGateway = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDVCANMCANGateway::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VCANMCANGateway", (tS32)0xcfac26d);
   (tVoid)myDpElem.bFillData((tVoid*)&tVCANMCANGateway, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDVCANMCANGateway::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDVCANMCANGateway::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDVCANMCANGateway::tGetData() {
   vUpdate();
   return tVCANMCANGateway;
};
tS32 dp_tclCsmDpPDDVCANMCANGateway::s32GetData(tU8& tVCANMCANGatewayParam) { 
   vUpdate();
   tVCANMCANGatewayParam = tVCANMCANGateway;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDVCANMCANGateway::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VCANMCANGateway", (tS32)0xcfac26d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDVCANMCANGateway::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDVCANMCANGateway::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDVCANMCANGateway::s32SetData(tU8 &tVCANMCANGatewayParam) {
   //init parameter
   (tVoid)memcpy(&tVCANMCANGateway,(tVoid*)&tVCANMCANGatewayParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVCANMCANGatewayParam' in function 'dp_tclCsmDpPDDVCANMCANGateway::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDVCANMCANGateway::s32SetData(const tU8 &tVCANMCANGatewayParam) {
   //init parameter
   (tVoid)memcpy(&tVCANMCANGateway,(tVoid*)&tVCANMCANGatewayParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVCANMCANGatewayParam' in function 'dp_tclCsmDpPDDVCANMCANGateway::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDVCANMCANGateway::u8GetData(tU8& tVCANMCANGatewayParam) {  
   vUpdate();
   tVCANMCANGatewayParam = tVCANMCANGateway;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDVCANMCANGateway::vSetData(tU8 &tVCANMCANGatewayParam) { 
   //init parameter
   (tVoid)memcpy(&tVCANMCANGateway,(tVoid*)&tVCANMCANGatewayParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVCANMCANGatewayParam' in function 'dp_tclCsmDpPDDVCANMCANGateway::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDVCANMCANGateway::vSetData(const tU8 &tVCANMCANGatewayParam) { 
   //init parameter
   (tVoid)memcpy(&tVCANMCANGateway,(tVoid*)&tVCANMCANGatewayParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVCANMCANGatewayParam' in function 'dp_tclCsmDpPDDVCANMCANGateway::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDVCANMCANGateway::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDVCANMCANGateway::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "VCANMCANGateway", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVCANMCANGateway::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "VCANMCANGateway", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVCANMCANGateway::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VCANMCANGateway", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element VCANMCANGateway has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelConsumptionInfo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDFuelConsumptionInfo::dp_tclCsmDpPDDFuelConsumptionInfo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFuelConsumptionInfo,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDFuelConsumptionInfo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FuelConsumptionInfo",(tS32) 0x2407a557);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFuelConsumptionInfo = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDFuelConsumptionInfo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FuelConsumptionInfo", (tS32)0x2407a557);
   (tVoid)myDpElem.bFillData((tVoid*)&tFuelConsumptionInfo, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDFuelConsumptionInfo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDFuelConsumptionInfo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDFuelConsumptionInfo::tGetData() {
   vUpdate();
   return tFuelConsumptionInfo;
};
tS32 dp_tclCsmDpPDDFuelConsumptionInfo::s32GetData(tU8& tFuelConsumptionInfoParam) { 
   vUpdate();
   tFuelConsumptionInfoParam = tFuelConsumptionInfo;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDFuelConsumptionInfo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FuelConsumptionInfo", (tS32)0x2407a557);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDFuelConsumptionInfo::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDFuelConsumptionInfo::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDFuelConsumptionInfo::s32SetData(tU8 &tFuelConsumptionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionInfo,(tVoid*)&tFuelConsumptionInfoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelConsumptionInfoParam' in function 'dp_tclCsmDpPDDFuelConsumptionInfo::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDFuelConsumptionInfo::s32SetData(const tU8 &tFuelConsumptionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionInfo,(tVoid*)&tFuelConsumptionInfoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelConsumptionInfoParam' in function 'dp_tclCsmDpPDDFuelConsumptionInfo::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDFuelConsumptionInfo::u8GetData(tU8& tFuelConsumptionInfoParam) {  
   vUpdate();
   tFuelConsumptionInfoParam = tFuelConsumptionInfo;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDFuelConsumptionInfo::vSetData(tU8 &tFuelConsumptionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionInfo,(tVoid*)&tFuelConsumptionInfoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFuelConsumptionInfoParam' in function 'dp_tclCsmDpPDDFuelConsumptionInfo::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDFuelConsumptionInfo::vSetData(const tU8 &tFuelConsumptionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionInfo,(tVoid*)&tFuelConsumptionInfoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFuelConsumptionInfoParam' in function 'dp_tclCsmDpPDDFuelConsumptionInfo::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDFuelConsumptionInfo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDFuelConsumptionInfo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "FuelConsumptionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDFuelConsumptionInfo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "FuelConsumptionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDFuelConsumptionInfo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelConsumptionInfo", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element FuelConsumptionInfo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TPMS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDTPMS::dp_tclCsmDpPDDTPMS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTPMS,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDTPMS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TPMS",(tS32) 0x32a8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTPMS = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDTPMS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TPMS", (tS32)0x32a8);
   (tVoid)myDpElem.bFillData((tVoid*)&tTPMS, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDTPMS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDTPMS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDTPMS::tGetData() {
   vUpdate();
   return tTPMS;
};
tS32 dp_tclCsmDpPDDTPMS::s32GetData(tU8& tTPMSParam) { 
   vUpdate();
   tTPMSParam = tTPMS;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDTPMS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TPMS", (tS32)0x32a8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDTPMS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDTPMS::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDTPMS::s32SetData(tU8 &tTPMSParam) {
   //init parameter
   (tVoid)memcpy(&tTPMS,(tVoid*)&tTPMSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTPMSParam' in function 'dp_tclCsmDpPDDTPMS::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDTPMS::s32SetData(const tU8 &tTPMSParam) {
   //init parameter
   (tVoid)memcpy(&tTPMS,(tVoid*)&tTPMSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTPMSParam' in function 'dp_tclCsmDpPDDTPMS::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDTPMS::u8GetData(tU8& tTPMSParam) {  
   vUpdate();
   tTPMSParam = tTPMS;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDTPMS::vSetData(tU8 &tTPMSParam) { 
   //init parameter
   (tVoid)memcpy(&tTPMS,(tVoid*)&tTPMSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTPMSParam' in function 'dp_tclCsmDpPDDTPMS::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDTPMS::vSetData(const tU8 &tTPMSParam) { 
   //init parameter
   (tVoid)memcpy(&tTPMS,(tVoid*)&tTPMSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTPMSParam' in function 'dp_tclCsmDpPDDTPMS::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDTPMS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDTPMS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "TPMS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDTPMS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "TPMS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDTPMS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TPMS", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element TPMS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VDC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDVDC::dp_tclCsmDpPDDVDC(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVDC,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDVDC::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VDC",(tS32) 0x9fd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVDC = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDVDC::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VDC", (tS32)0x9fd);
   (tVoid)myDpElem.bFillData((tVoid*)&tVDC, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDVDC::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDVDC::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDVDC::tGetData() {
   vUpdate();
   return tVDC;
};
tS32 dp_tclCsmDpPDDVDC::s32GetData(tU8& tVDCParam) { 
   vUpdate();
   tVDCParam = tVDC;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDVDC::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VDC", (tS32)0x9fd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDVDC::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDVDC::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDVDC::s32SetData(tU8 &tVDCParam) {
   //init parameter
   (tVoid)memcpy(&tVDC,(tVoid*)&tVDCParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDCParam' in function 'dp_tclCsmDpPDDVDC::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDVDC::s32SetData(const tU8 &tVDCParam) {
   //init parameter
   (tVoid)memcpy(&tVDC,(tVoid*)&tVDCParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDCParam' in function 'dp_tclCsmDpPDDVDC::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDVDC::u8GetData(tU8& tVDCParam) {  
   vUpdate();
   tVDCParam = tVDC;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDVDC::vSetData(tU8 &tVDCParam) { 
   //init parameter
   (tVoid)memcpy(&tVDC,(tVoid*)&tVDCParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDCParam' in function 'dp_tclCsmDpPDDVDC::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDVDC::vSetData(const tU8 &tVDCParam) { 
   //init parameter
   (tVoid)memcpy(&tVDC,(tVoid*)&tVDCParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDCParam' in function 'dp_tclCsmDpPDDVDC::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDVDC::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDVDC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "VDC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVDC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "VDC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVDC::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VDC", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element VDC has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AdFunction"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDAdFunction::dp_tclCsmDpPDDAdFunction(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdFunction,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDAdFunction::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AdFunction",(tS32) 0xa5affeb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdFunction = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDAdFunction::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AdFunction", (tS32)0xa5affeb);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdFunction, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDAdFunction::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDAdFunction::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDAdFunction::tGetData() {
   vUpdate();
   return tAdFunction;
};
tS32 dp_tclCsmDpPDDAdFunction::s32GetData(tU8& tAdFunctionParam) { 
   vUpdate();
   tAdFunctionParam = tAdFunction;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDAdFunction::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AdFunction", (tS32)0xa5affeb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDAdFunction::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDAdFunction::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDAdFunction::s32SetData(tU8 &tAdFunctionParam) {
   //init parameter
   (tVoid)memcpy(&tAdFunction,(tVoid*)&tAdFunctionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdFunctionParam' in function 'dp_tclCsmDpPDDAdFunction::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDAdFunction::s32SetData(const tU8 &tAdFunctionParam) {
   //init parameter
   (tVoid)memcpy(&tAdFunction,(tVoid*)&tAdFunctionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdFunctionParam' in function 'dp_tclCsmDpPDDAdFunction::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDAdFunction::u8GetData(tU8& tAdFunctionParam) {  
   vUpdate();
   tAdFunctionParam = tAdFunction;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDAdFunction::vSetData(tU8 &tAdFunctionParam) { 
   //init parameter
   (tVoid)memcpy(&tAdFunction,(tVoid*)&tAdFunctionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdFunctionParam' in function 'dp_tclCsmDpPDDAdFunction::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDAdFunction::vSetData(const tU8 &tAdFunctionParam) { 
   //init parameter
   (tVoid)memcpy(&tAdFunction,(tVoid*)&tAdFunctionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdFunctionParam' in function 'dp_tclCsmDpPDDAdFunction::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDAdFunction::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDAdFunction::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "AdFunction", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDAdFunction::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "AdFunction", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDAdFunction::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AdFunction", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element AdFunction has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VehicleSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDVehicleSetting::dp_tclCsmDpPDDVehicleSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVehicleSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDVehicleSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VehicleSetting",(tS32) 0xa979f322);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVehicleSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDVehicleSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VehicleSetting", (tS32)0xa979f322);
   (tVoid)myDpElem.bFillData((tVoid*)&tVehicleSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDVehicleSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDVehicleSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDVehicleSetting::tGetData() {
   vUpdate();
   return tVehicleSetting;
};
tS32 dp_tclCsmDpPDDVehicleSetting::s32GetData(tU8& tVehicleSettingParam) { 
   vUpdate();
   tVehicleSettingParam = tVehicleSetting;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDVehicleSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VehicleSetting", (tS32)0xa979f322);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDVehicleSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDVehicleSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDVehicleSetting::s32SetData(tU8 &tVehicleSettingParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleSetting,(tVoid*)&tVehicleSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleSettingParam' in function 'dp_tclCsmDpPDDVehicleSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDVehicleSetting::s32SetData(const tU8 &tVehicleSettingParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleSetting,(tVoid*)&tVehicleSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleSettingParam' in function 'dp_tclCsmDpPDDVehicleSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDVehicleSetting::u8GetData(tU8& tVehicleSettingParam) {  
   vUpdate();
   tVehicleSettingParam = tVehicleSetting;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDVehicleSetting::vSetData(tU8 &tVehicleSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleSetting,(tVoid*)&tVehicleSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVehicleSettingParam' in function 'dp_tclCsmDpPDDVehicleSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDVehicleSetting::vSetData(const tU8 &tVehicleSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleSetting,(tVoid*)&tVehicleSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVehicleSettingParam' in function 'dp_tclCsmDpPDDVehicleSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDVehicleSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDVehicleSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "VehicleSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVehicleSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "VehicleSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDVehicleSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VehicleSetting", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element VehicleSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HudSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDHudSetting::dp_tclCsmDpPDDHudSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tHudSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDHudSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("HudSetting",(tS32) 0xbac554b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tHudSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDHudSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("HudSetting", (tS32)0xbac554b);
   (tVoid)myDpElem.bFillData((tVoid*)&tHudSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDHudSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDHudSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDHudSetting::tGetData() {
   vUpdate();
   return tHudSetting;
};
tS32 dp_tclCsmDpPDDHudSetting::s32GetData(tU8& tHudSettingParam) { 
   vUpdate();
   tHudSettingParam = tHudSetting;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDHudSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("HudSetting", (tS32)0xbac554b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDHudSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDHudSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDHudSetting::s32SetData(tU8 &tHudSettingParam) {
   //init parameter
   (tVoid)memcpy(&tHudSetting,(tVoid*)&tHudSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHudSettingParam' in function 'dp_tclCsmDpPDDHudSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDHudSetting::s32SetData(const tU8 &tHudSettingParam) {
   //init parameter
   (tVoid)memcpy(&tHudSetting,(tVoid*)&tHudSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHudSettingParam' in function 'dp_tclCsmDpPDDHudSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDHudSetting::u8GetData(tU8& tHudSettingParam) {  
   vUpdate();
   tHudSettingParam = tHudSetting;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDHudSetting::vSetData(tU8 &tHudSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tHudSetting,(tVoid*)&tHudSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHudSettingParam' in function 'dp_tclCsmDpPDDHudSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDHudSetting::vSetData(const tU8 &tHudSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tHudSetting,(tVoid*)&tHudSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHudSettingParam' in function 'dp_tclCsmDpPDDHudSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDHudSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDHudSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "HudSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDHudSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "HudSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDHudSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HudSetting", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element HudSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HvacType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDHvacType::dp_tclCsmDpPDDHvacType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tHvacType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDHvacType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("HvacType",(tS32) 0x77c000);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tHvacType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDHvacType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("HvacType", (tS32)0x77c000);
   (tVoid)myDpElem.bFillData((tVoid*)&tHvacType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDHvacType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDHvacType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDHvacType::tGetData() {
   vUpdate();
   return tHvacType;
};
tS32 dp_tclCsmDpPDDHvacType::s32GetData(tU8& tHvacTypeParam) { 
   vUpdate();
   tHvacTypeParam = tHvacType;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDHvacType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("HvacType", (tS32)0x77c000);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDHvacType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDHvacType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDHvacType::s32SetData(tU8 &tHvacTypeParam) {
   //init parameter
   (tVoid)memcpy(&tHvacType,(tVoid*)&tHvacTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHvacTypeParam' in function 'dp_tclCsmDpPDDHvacType::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDHvacType::s32SetData(const tU8 &tHvacTypeParam) {
   //init parameter
   (tVoid)memcpy(&tHvacType,(tVoid*)&tHvacTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHvacTypeParam' in function 'dp_tclCsmDpPDDHvacType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDHvacType::u8GetData(tU8& tHvacTypeParam) {  
   vUpdate();
   tHvacTypeParam = tHvacType;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDHvacType::vSetData(tU8 &tHvacTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tHvacType,(tVoid*)&tHvacTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHvacTypeParam' in function 'dp_tclCsmDpPDDHvacType::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDHvacType::vSetData(const tU8 &tHvacTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tHvacType,(tVoid*)&tHvacTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHvacTypeParam' in function 'dp_tclCsmDpPDDHvacType::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDHvacType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDHvacType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "HvacType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDHvacType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "HvacType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDHvacType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HvacType", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element HvacType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DigitalAssi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDDigitalAssi::dp_tclCsmDpPDDDigitalAssi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDigitalAssi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDDigitalAssi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DigitalAssi",(tS32) 0x36d29f02);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDigitalAssi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDDigitalAssi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DigitalAssi", (tS32)0x36d29f02);
   (tVoid)myDpElem.bFillData((tVoid*)&tDigitalAssi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDDigitalAssi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDDigitalAssi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDDigitalAssi::tGetData() {
   vUpdate();
   return tDigitalAssi;
};
tS32 dp_tclCsmDpPDDDigitalAssi::s32GetData(tU8& tDigitalAssiParam) { 
   vUpdate();
   tDigitalAssiParam = tDigitalAssi;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDDigitalAssi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DigitalAssi", (tS32)0x36d29f02);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDDigitalAssi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDDigitalAssi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDDigitalAssi::s32SetData(tU8 &tDigitalAssiParam) {
   //init parameter
   (tVoid)memcpy(&tDigitalAssi,(tVoid*)&tDigitalAssiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDigitalAssiParam' in function 'dp_tclCsmDpPDDDigitalAssi::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDDigitalAssi::s32SetData(const tU8 &tDigitalAssiParam) {
   //init parameter
   (tVoid)memcpy(&tDigitalAssi,(tVoid*)&tDigitalAssiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDigitalAssiParam' in function 'dp_tclCsmDpPDDDigitalAssi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDDigitalAssi::u8GetData(tU8& tDigitalAssiParam) {  
   vUpdate();
   tDigitalAssiParam = tDigitalAssi;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDDigitalAssi::vSetData(tU8 &tDigitalAssiParam) { 
   //init parameter
   (tVoid)memcpy(&tDigitalAssi,(tVoid*)&tDigitalAssiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDigitalAssiParam' in function 'dp_tclCsmDpPDDDigitalAssi::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDDigitalAssi::vSetData(const tU8 &tDigitalAssiParam) { 
   //init parameter
   (tVoid)memcpy(&tDigitalAssi,(tVoid*)&tDigitalAssiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDigitalAssiParam' in function 'dp_tclCsmDpPDDDigitalAssi::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDDigitalAssi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDDigitalAssi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "DigitalAssi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDDigitalAssi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "DigitalAssi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDDigitalAssi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DigitalAssi", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DigitalAssi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SendCountryInfo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmDpPDDSendCountryInfo::dp_tclCsmDpPDDSendCountryInfo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSendCountryInfo,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmDpPDDSendCountryInfo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SendCountryInfo",(tS32) 0x42fb7c7e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSendCountryInfo = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmDpPDDSendCountryInfo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SendCountryInfo", (tS32)0x42fb7c7e);
   (tVoid)myDpElem.bFillData((tVoid*)&tSendCountryInfo, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmDpPDDSendCountryInfo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmDpPDDSendCountryInfo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCsmDpPDDSendCountryInfo::tGetData() {
   vUpdate();
   return tSendCountryInfo;
};
tS32 dp_tclCsmDpPDDSendCountryInfo::s32GetData(tU8& tSendCountryInfoParam) { 
   vUpdate();
   tSendCountryInfoParam = tSendCountryInfo;
   return _s32Status;
}
tS32 dp_tclCsmDpPDDSendCountryInfo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SendCountryInfo", (tS32)0x42fb7c7e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmDpPDDSendCountryInfo::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmDpPDDSendCountryInfo::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmDpPDDSendCountryInfo::s32SetData(tU8 &tSendCountryInfoParam) {
   //init parameter
   (tVoid)memcpy(&tSendCountryInfo,(tVoid*)&tSendCountryInfoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSendCountryInfoParam' in function 'dp_tclCsmDpPDDSendCountryInfo::vSetData(tU8)' could be made const reference
tS32 dp_tclCsmDpPDDSendCountryInfo::s32SetData(const tU8 &tSendCountryInfoParam) {
   //init parameter
   (tVoid)memcpy(&tSendCountryInfo,(tVoid*)&tSendCountryInfoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSendCountryInfoParam' in function 'dp_tclCsmDpPDDSendCountryInfo::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmDpPDDSendCountryInfo::u8GetData(tU8& tSendCountryInfoParam) {  
   vUpdate();
   tSendCountryInfoParam = tSendCountryInfo;
   return _u8DataStatus;
}
tVoid dp_tclCsmDpPDDSendCountryInfo::vSetData(tU8 &tSendCountryInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tSendCountryInfo,(tVoid*)&tSendCountryInfoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSendCountryInfoParam' in function 'dp_tclCsmDpPDDSendCountryInfo::vSetData(tU8)' could be made const reference
tVoid dp_tclCsmDpPDDSendCountryInfo::vSetData(const tU8 &tSendCountryInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tSendCountryInfo,(tVoid*)&tSendCountryInfoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSendCountryInfoParam' in function 'dp_tclCsmDpPDDSendCountryInfo::vSetData(tU8)' could be made const reference
tU8   dp_tclCsmDpPDDSendCountryInfo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmDpPDDSendCountryInfo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMDPPDD, "SendCountryInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSendCountryInfo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMDPPDD, "SendCountryInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmDpPDDSendCountryInfo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SendCountryInfo", DP_U32_POOL_ID_CSMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element SendCountryInfo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
