
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAudioStackMultiDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioStack_LastSource_Class"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPAudioStack_LastSource_Class::dp_tclAudioStackMultiDPAudioStack_LastSource_Class(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPAudioStack_LastSource_Class::s32SetData( tU8* tAudioStack_LastSource_ClassParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AudioStack_LastSource_Class", (tS32)0x186aaf9dL);
   (tVoid)myDpElem.bFillData((tVoid*)tAudioStack_LastSource_ClassParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPAudioStack_LastSource_Class::s32GetData(tU8* tAudioStack_LastSource_ClassParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AudioStack_LastSource_Class", (tS32)0x186aaf9dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAudioStack_LastSource_ClassParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPAudioStack_LastSource_Class::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPAudioStack_LastSource_Class::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPAudioStack_LastSource_Class::u16GetData(tU8* tAudioStack_LastSource_ClassParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAudioStack_LastSource_ClassParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPAudioStack_LastSource_Class::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AudioStack_LastSource_Class", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPAudioStack_LastSource_Class::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AudioStack_LastSource_Class", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPAudioStack_LastSource_Class::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioStack_LastSource_Class", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element AudioStack_LastSource_Class has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioStack_LastSource_SubID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::dp_tclAudioStackMultiDPAudioStack_LastSource_SubID(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::s32SetData( tU16* tAudioStack_LastSource_SubIDParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AudioStack_LastSource_SubID", (tS32)0x186ada2aL);
   (tVoid)myDpElem.bFillData((tVoid*)tAudioStack_LastSource_SubIDParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::s32GetData(tU16* tAudioStack_LastSource_SubIDParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AudioStack_LastSource_SubID", (tS32)0x186ada2aL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAudioStack_LastSource_SubIDParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::u16GetData(tU16* tAudioStack_LastSource_SubIDParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAudioStack_LastSource_SubIDParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AudioStack_LastSource_SubID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AudioStack_LastSource_SubID", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPAudioStack_LastSource_SubID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioStack_LastSource_SubID", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element AudioStack_LastSource_SubID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioStack_PersistentMute"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPAudioStack_PersistentMute::dp_tclAudioStackMultiDPAudioStack_PersistentMute(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioStack_PersistentMute,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioStackMultiDPAudioStack_PersistentMute::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioStack_PersistentMute",(tS32) 0x48e3e61f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAudioStack_PersistentMute = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioStackMultiDPAudioStack_PersistentMute::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioStack_PersistentMute", (tS32)0x48e3e61f);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioStack_PersistentMute, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioStackMultiDPAudioStack_PersistentMute::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioStackMultiDPAudioStack_PersistentMute::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioStackMultiDPAudioStack_PersistentMute::tGetData() {
   vUpdate();
   return tAudioStack_PersistentMute;
};
tS32 dp_tclAudioStackMultiDPAudioStack_PersistentMute::s32GetData(tU8& tAudioStack_PersistentMuteParam) { 
   vUpdate();
   tAudioStack_PersistentMuteParam = tAudioStack_PersistentMute;
   return _s32Status;
}
tS32 dp_tclAudioStackMultiDPAudioStack_PersistentMute::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioStack_PersistentMute", (tS32)0x48e3e61f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioStackMultiDPAudioStack_PersistentMute::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioStackMultiDPAudioStack_PersistentMute::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioStackMultiDPAudioStack_PersistentMute::s32SetData(tU8 &tAudioStack_PersistentMuteParam) {
   //init parameter
   (tVoid)memcpy(&tAudioStack_PersistentMute,(tVoid*)&tAudioStack_PersistentMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioStack_PersistentMuteParam' in function 'dp_tclAudioStackMultiDPAudioStack_PersistentMute::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioStackMultiDPAudioStack_PersistentMute::s32SetData(const tU8 &tAudioStack_PersistentMuteParam) {
   //init parameter
   (tVoid)memcpy(&tAudioStack_PersistentMute,(tVoid*)&tAudioStack_PersistentMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioStack_PersistentMuteParam' in function 'dp_tclAudioStackMultiDPAudioStack_PersistentMute::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioStackMultiDPAudioStack_PersistentMute::u8GetData(tU8& tAudioStack_PersistentMuteParam) {  
   vUpdate();
   tAudioStack_PersistentMuteParam = tAudioStack_PersistentMute;
   return _u8DataStatus;
}
tVoid dp_tclAudioStackMultiDPAudioStack_PersistentMute::vSetData(tU8 &tAudioStack_PersistentMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioStack_PersistentMute,(tVoid*)&tAudioStack_PersistentMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioStack_PersistentMuteParam' in function 'dp_tclAudioStackMultiDPAudioStack_PersistentMute::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioStackMultiDPAudioStack_PersistentMute::vSetData(const tU8 &tAudioStack_PersistentMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioStack_PersistentMute,(tVoid*)&tAudioStack_PersistentMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioStack_PersistentMuteParam' in function 'dp_tclAudioStackMultiDPAudioStack_PersistentMute::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioStackMultiDPAudioStack_PersistentMute::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioStackMultiDPAudioStack_PersistentMute::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AudioStack_PersistentMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiDPAudioStack_PersistentMute::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AudioStack_PersistentMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiDPAudioStack_PersistentMute::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioStack_PersistentMute", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
   }
   else
   {
      fprintf(stdout,"Element AudioStack_PersistentMute has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PrivateMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPPrivateMode::dp_tclAudioStackMultiDPPrivateMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPrivateMode,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioStackMultiDPPrivateMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PrivateMode",(tS32) 0x3ef2ba9c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPrivateMode = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioStackMultiDPPrivateMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PrivateMode", (tS32)0x3ef2ba9c);
   (tVoid)myDpElem.bFillData((tVoid*)&tPrivateMode, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioStackMultiDPPrivateMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioStackMultiDPPrivateMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclAudioStackMultiDPPrivateMode::tGetData() {
   vUpdate();
   return tPrivateMode;
};
tS32 dp_tclAudioStackMultiDPPrivateMode::s32GetData(tU16& tPrivateModeParam) { 
   vUpdate();
   tPrivateModeParam = tPrivateMode;
   return _s32Status;
}
tS32 dp_tclAudioStackMultiDPPrivateMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PrivateMode", (tS32)0x3ef2ba9c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioStackMultiDPPrivateMode::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioStackMultiDPPrivateMode::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioStackMultiDPPrivateMode::s32SetData(tU16 &tPrivateModeParam) {
   //init parameter
   (tVoid)memcpy(&tPrivateMode,(tVoid*)&tPrivateModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPrivateModeParam' in function 'dp_tclAudioStackMultiDPPrivateMode::vSetData(tU16)' could be made const reference
tS32 dp_tclAudioStackMultiDPPrivateMode::s32SetData(const tU16 &tPrivateModeParam) {
   //init parameter
   (tVoid)memcpy(&tPrivateMode,(tVoid*)&tPrivateModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPrivateModeParam' in function 'dp_tclAudioStackMultiDPPrivateMode::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioStackMultiDPPrivateMode::u8GetData(tU16& tPrivateModeParam) {  
   vUpdate();
   tPrivateModeParam = tPrivateMode;
   return _u8DataStatus;
}
tVoid dp_tclAudioStackMultiDPPrivateMode::vSetData(tU16 &tPrivateModeParam) { 
   //init parameter
   (tVoid)memcpy(&tPrivateMode,(tVoid*)&tPrivateModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPrivateModeParam' in function 'dp_tclAudioStackMultiDPPrivateMode::vSetData(tU16)' could be made const reference
tVoid dp_tclAudioStackMultiDPPrivateMode::vSetData(const tU16 &tPrivateModeParam) { 
   //init parameter
   (tVoid)memcpy(&tPrivateMode,(tVoid*)&tPrivateModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPrivateModeParam' in function 'dp_tclAudioStackMultiDPPrivateMode::vSetData(tU16)' could be made const reference
tU8   dp_tclAudioStackMultiDPPrivateMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioStackMultiDPPrivateMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "PrivateMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiDPPrivateMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "PrivateMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiDPPrivateMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PrivateMode", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
   }
   else
   {
      fprintf(stdout,"Element PrivateMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PrivateModeMixVolume"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPPrivateModeMixVolume::dp_tclAudioStackMultiDPPrivateModeMixVolume(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPPrivateModeMixVolume::s32SetData( tU16* tPrivateModeMixVolumeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("PrivateModeMixVolume", (tS32)0x5b48b362);
   (tVoid)myDpElem.bFillData((tVoid*)tPrivateModeMixVolumeParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPPrivateModeMixVolume::s32GetData(tU16* tPrivateModeMixVolumeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("PrivateModeMixVolume", (tS32)0x5b48b362);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tPrivateModeMixVolumeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPPrivateModeMixVolume::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPPrivateModeMixVolume::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPPrivateModeMixVolume::u16GetData(tU16* tPrivateModeMixVolumeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tPrivateModeMixVolumeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPPrivateModeMixVolume::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "PrivateModeMixVolume", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPPrivateModeMixVolume::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "PrivateModeMixVolume", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPPrivateModeMixVolume::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PrivateModeMixVolume", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element PrivateModeMixVolume has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Number_of_Sinks"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPNumber_of_Sinks::dp_tclAudioStackMultiDPNumber_of_Sinks(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNumber_of_Sinks,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioStackMultiDPNumber_of_Sinks::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Number_of_Sinks",(tS32) 0xb36355d8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tNumber_of_Sinks = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioStackMultiDPNumber_of_Sinks::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Number_of_Sinks", (tS32)0xb36355d8);
   (tVoid)myDpElem.bFillData((tVoid*)&tNumber_of_Sinks, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioStackMultiDPNumber_of_Sinks::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioStackMultiDPNumber_of_Sinks::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioStackMultiDPNumber_of_Sinks::tGetData() {
   vUpdate();
   return tNumber_of_Sinks;
};
tS32 dp_tclAudioStackMultiDPNumber_of_Sinks::s32GetData(tU8& tNumber_of_SinksParam) { 
   vUpdate();
   tNumber_of_SinksParam = tNumber_of_Sinks;
   return _s32Status;
}
tS32 dp_tclAudioStackMultiDPNumber_of_Sinks::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Number_of_Sinks", (tS32)0xb36355d8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioStackMultiDPNumber_of_Sinks::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioStackMultiDPNumber_of_Sinks::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioStackMultiDPNumber_of_Sinks::s32SetData(tU8 &tNumber_of_SinksParam) {
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioStackMultiDPNumber_of_Sinks::s32SetData(const tU8 &tNumber_of_SinksParam) {
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioStackMultiDPNumber_of_Sinks::u8GetData(tU8& tNumber_of_SinksParam) {  
   vUpdate();
   tNumber_of_SinksParam = tNumber_of_Sinks;
   return _u8DataStatus;
}
tVoid dp_tclAudioStackMultiDPNumber_of_Sinks::vSetData(tU8 &tNumber_of_SinksParam) { 
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioStackMultiDPNumber_of_Sinks::vSetData(const tU8 &tNumber_of_SinksParam) { 
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioStackMultiDPNumber_of_Sinks::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioStackMultiDPNumber_of_Sinks::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Number_of_Sinks", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiDPNumber_of_Sinks::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Number_of_Sinks", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiDPNumber_of_Sinks::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Number_of_Sinks", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
   }
   else
   {
      fprintf(stdout,"Element Number_of_Sinks has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPTreble::dp_tclAudioStackMultiDPTreble(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPTreble::s32SetData( tS8* tTrebleParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Treble", (tS32)0x5551a);
   (tVoid)myDpElem.bFillData((tVoid*)tTrebleParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPTreble::s32GetData(tS8* tTrebleParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Treble", (tS32)0x5551a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrebleParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPTreble::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPTreble::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPTreble::u16GetData(tS8* tTrebleParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrebleParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPTreble::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Treble", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPTreble::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Treble", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPTreble::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Treble has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrebleMic1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPTrebleMic1::dp_tclAudioStackMultiDPTrebleMic1(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPTrebleMic1::s32SetData( tS8* tTrebleMic1Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("TrebleMic1", (tS32)0xd04f674);
   (tVoid)myDpElem.bFillData((tVoid*)tTrebleMic1Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPTrebleMic1::s32GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("TrebleMic1", (tS32)0xd04f674);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrebleMic1Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPTrebleMic1::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPTrebleMic1::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPTrebleMic1::u16GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrebleMic1Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPTrebleMic1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "TrebleMic1", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPTrebleMic1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "TrebleMic1", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPTrebleMic1::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrebleMic1", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element TrebleMic1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixTrebleMic2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMixTrebleMic2::dp_tclAudioStackMultiDPMixTrebleMic2(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMixTrebleMic2::s32SetData( tS8* tMixTrebleMic2Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixTrebleMic2", (tS32)0xe4f4ce2f);
   (tVoid)myDpElem.bFillData((tVoid*)tMixTrebleMic2Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMixTrebleMic2::s32GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixTrebleMic2", (tS32)0xe4f4ce2f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixTrebleMic2Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMixTrebleMic2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMixTrebleMic2::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMixTrebleMic2::u16GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixTrebleMic2Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMixTrebleMic2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixTrebleMic2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMixTrebleMic2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixTrebleMic2", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMixTrebleMic2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixTrebleMic2", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MixTrebleMic2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixTrebleMic3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMixTrebleMic3::dp_tclAudioStackMultiDPMixTrebleMic3(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMixTrebleMic3::s32SetData( tS8* tMixTrebleMic3Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixTrebleMic3", (tS32)0xe4f4ce30);
   (tVoid)myDpElem.bFillData((tVoid*)tMixTrebleMic3Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMixTrebleMic3::s32GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixTrebleMic3", (tS32)0xe4f4ce30);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixTrebleMic3Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMixTrebleMic3::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMixTrebleMic3::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMixTrebleMic3::u16GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixTrebleMic3Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMixTrebleMic3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixTrebleMic3", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMixTrebleMic3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixTrebleMic3", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMixTrebleMic3::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixTrebleMic3", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MixTrebleMic3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBass::dp_tclAudioStackMultiDPBass(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBass::s32SetData( tS8* tBassParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Bass", (tS32)0x2c65);
   (tVoid)myDpElem.bFillData((tVoid*)tBassParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBass::s32GetData(tS8* tBassParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Bass", (tS32)0x2c65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBassParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBass::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBass::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBass::u16GetData(tS8* tBassParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBassParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBass::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Bass", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBass::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Bass", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBass::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Bass has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BassMic1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBassMic1::dp_tclAudioStackMultiDPBassMic1(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBassMic1::s32SetData( tS8* tBassMic1Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BassMic1", (tS32)0x6c948f);
   (tVoid)myDpElem.bFillData((tVoid*)tBassMic1Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBassMic1::s32GetData(tS8* tBassMic1Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BassMic1", (tS32)0x6c948f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBassMic1Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBassMic1::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBassMic1::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBassMic1::u16GetData(tS8* tBassMic1Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tBassMic1Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBassMic1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "BassMic1", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBassMic1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "BassMic1", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBassMic1::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BassMic1", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element BassMic1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixBassMic2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMixBassMic2::dp_tclAudioStackMultiDPMixBassMic2(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMixBassMic2::s32SetData( tS8* tMixBassMic2Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixBassMic2", (tS32)0x3c42f95a);
   (tVoid)myDpElem.bFillData((tVoid*)tMixBassMic2Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMixBassMic2::s32GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixBassMic2", (tS32)0x3c42f95a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixBassMic2Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMixBassMic2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMixBassMic2::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMixBassMic2::u16GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixBassMic2Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMixBassMic2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixBassMic2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMixBassMic2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixBassMic2", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMixBassMic2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixBassMic2", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MixBassMic2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixBassMic3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMixBassMic3::dp_tclAudioStackMultiDPMixBassMic3(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMixBassMic3::s32SetData( tS8* tMixBassMic3Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixBassMic3", (tS32)0x3c42f95b);
   (tVoid)myDpElem.bFillData((tVoid*)tMixBassMic3Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMixBassMic3::s32GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixBassMic3", (tS32)0x3c42f95b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixBassMic3Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMixBassMic3::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMixBassMic3::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMixBassMic3::u16GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixBassMic3Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMixBassMic3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixBassMic3", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMixBassMic3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MixBassMic3", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMixBassMic3::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixBassMic3", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MixBassMic3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPFader::dp_tclAudioStackMultiDPFader(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPFader::s32SetData( tS8* tFaderParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Fader", (tS32)0xe672);
   (tVoid)myDpElem.bFillData((tVoid*)tFaderParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPFader::s32GetData(tS8* tFaderParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Fader", (tS32)0xe672);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFaderParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPFader::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPFader::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPFader::u16GetData(tS8* tFaderParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFaderParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPFader::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Fader", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPFader::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Fader", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPFader::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Fader has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBalance::dp_tclAudioStackMultiDPBalance(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBalance::s32SetData( tS8* tBalanceParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Balance", (tS32)0x15a082);
   (tVoid)myDpElem.bFillData((tVoid*)tBalanceParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBalance::s32GetData(tS8* tBalanceParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Balance", (tS32)0x15a082);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBalanceParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBalance::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBalance::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBalance::u16GetData(tS8* tBalanceParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBalanceParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBalance::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Balance", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBalance::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Balance", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBalance::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Balance has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMidRange::dp_tclAudioStackMultiDPMidRange(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMidRange::s32SetData( tS8* tMidRangeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MidRange", (tS32)0x7a9ca3);
   (tVoid)myDpElem.bFillData((tVoid*)tMidRangeParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMidRange::s32GetData(tS8* tMidRangeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MidRange", (tS32)0x7a9ca3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMidRangeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMidRange::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMidRange::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMidRange::u16GetData(tS8* tMidRangeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMidRangeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMidRange::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MidRange", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMidRange::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MidRange", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMidRange::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MidRange has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AuxInLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPAuxInLevel::dp_tclAudioStackMultiDPAuxInLevel(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPAuxInLevel::s32SetData( tU8* tAuxInLevelParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AuxInLevel", (tS32)0xaf132b1);
   (tVoid)myDpElem.bFillData((tVoid*)tAuxInLevelParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPAuxInLevel::s32GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AuxInLevel", (tS32)0xaf132b1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAuxInLevelParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPAuxInLevel::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPAuxInLevel::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPAuxInLevel::u16GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAuxInLevelParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPAuxInLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AuxInLevel", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPAuxInLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "AuxInLevel", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPAuxInLevel::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AuxInLevel", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element AuxInLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBass_Max::dp_tclAudioStackMultiDPBass_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBass_Max::s32SetData( tS8* tBass_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Bass_Max", (tS32)0x6c9ada);
   (tVoid)myDpElem.bFillData((tVoid*)tBass_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBass_Max::s32GetData(tS8* tBass_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Bass_Max", (tS32)0x6c9ada);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBass_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBass_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBass_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBass_Max::u16GetData(tS8* tBass_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBass_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBass_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Bass_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBass_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Bass_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBass_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Bass_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPTreble_Max::dp_tclAudioStackMultiDPTreble_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPTreble_Max::s32SetData( tS8* tTreble_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Treble_Max", (tS32)0xd04fcbf);
   (tVoid)myDpElem.bFillData((tVoid*)tTreble_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPTreble_Max::s32GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Treble_Max", (tS32)0xd04fcbf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTreble_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPTreble_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPTreble_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPTreble_Max::u16GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTreble_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPTreble_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Treble_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPTreble_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Treble_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPTreble_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Treble_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPFader_Max::dp_tclAudioStackMultiDPFader_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPFader_Max::s32SetData( tS8* tFader_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Fader_Max", (tS32)0x232d497);
   (tVoid)myDpElem.bFillData((tVoid*)tFader_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPFader_Max::s32GetData(tS8* tFader_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Fader_Max", (tS32)0x232d497);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFader_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPFader_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPFader_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPFader_Max::u16GetData(tS8* tFader_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFader_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPFader_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Fader_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPFader_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Fader_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPFader_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Fader_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBalance_Max::dp_tclAudioStackMultiDPBalance_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBalance_Max::s32SetData( tS8* tBalance_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Balance_Max", (tS32)0x34cd15a7);
   (tVoid)myDpElem.bFillData((tVoid*)tBalance_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBalance_Max::s32GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Balance_Max", (tS32)0x34cd15a7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBalance_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBalance_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBalance_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBalance_Max::u16GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBalance_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBalance_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Balance_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBalance_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Balance_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBalance_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Balance_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMidRange_Max::dp_tclAudioStackMultiDPMidRange_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMidRange_Max::s32SetData( tS8* tMidRange_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MidRange_Max", (tS32)0x2b58a238);
   (tVoid)myDpElem.bFillData((tVoid*)tMidRange_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMidRange_Max::s32GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MidRange_Max", (tS32)0x2b58a238);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMidRange_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMidRange_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMidRange_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMidRange_Max::u16GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMidRange_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMidRange_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MidRange_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMidRange_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MidRange_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMidRange_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MidRange_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBass_Min::dp_tclAudioStackMultiDPBass_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBass_Min::s32SetData( tS8* tBass_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Bass_Min", (tS32)0x6c9af8);
   (tVoid)myDpElem.bFillData((tVoid*)tBass_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBass_Min::s32GetData(tS8* tBass_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Bass_Min", (tS32)0x6c9af8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBass_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBass_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBass_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBass_Min::u16GetData(tS8* tBass_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBass_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBass_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Bass_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBass_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Bass_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBass_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Bass_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPTreble_Min::dp_tclAudioStackMultiDPTreble_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPTreble_Min::s32SetData( tS8* tTreble_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Treble_Min", (tS32)0xd04fcdd);
   (tVoid)myDpElem.bFillData((tVoid*)tTreble_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPTreble_Min::s32GetData(tS8* tTreble_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Treble_Min", (tS32)0xd04fcdd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTreble_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPTreble_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPTreble_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPTreble_Min::u16GetData(tS8* tTreble_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTreble_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPTreble_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Treble_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPTreble_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Treble_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPTreble_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Treble_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPFader_Min::dp_tclAudioStackMultiDPFader_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPFader_Min::s32SetData( tS8* tFader_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Fader_Min", (tS32)0x232d4b5);
   (tVoid)myDpElem.bFillData((tVoid*)tFader_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPFader_Min::s32GetData(tS8* tFader_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Fader_Min", (tS32)0x232d4b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFader_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPFader_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPFader_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPFader_Min::u16GetData(tS8* tFader_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFader_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPFader_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Fader_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPFader_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Fader_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPFader_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Fader_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPBalance_Min::dp_tclAudioStackMultiDPBalance_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPBalance_Min::s32SetData( tS8* tBalance_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Balance_Min", (tS32)0x34cd15c5);
   (tVoid)myDpElem.bFillData((tVoid*)tBalance_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPBalance_Min::s32GetData(tS8* tBalance_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Balance_Min", (tS32)0x34cd15c5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBalance_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPBalance_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPBalance_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPBalance_Min::u16GetData(tS8* tBalance_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBalance_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPBalance_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Balance_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPBalance_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "Balance_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPBalance_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element Balance_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPMidRange_Min::dp_tclAudioStackMultiDPMidRange_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPMidRange_Min::s32SetData( tS8* tMidRange_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MidRange_Min", (tS32)0x2b58a256);
   (tVoid)myDpElem.bFillData((tVoid*)tMidRange_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPMidRange_Min::s32GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MidRange_Min", (tS32)0x2b58a256);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMidRange_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPMidRange_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPMidRange_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPMidRange_Min::u16GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMidRange_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPMidRange_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MidRange_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPMidRange_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "MidRange_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPMidRange_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element MidRange_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "OnVolume_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPOnVolume_Max::dp_tclAudioStackMultiDPOnVolume_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPOnVolume_Max::s32SetData( tU8* tOnVolume_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("OnVolume_Max", (tS32)0x332e7f32);
   (tVoid)myDpElem.bFillData((tVoid*)tOnVolume_MaxParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPOnVolume_Max::s32GetData(tU8* tOnVolume_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("OnVolume_Max", (tS32)0x332e7f32);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tOnVolume_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPOnVolume_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPOnVolume_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPOnVolume_Max::u16GetData(tU8* tOnVolume_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tOnVolume_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPOnVolume_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "OnVolume_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPOnVolume_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "OnVolume_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPOnVolume_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: OnVolume_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element OnVolume_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "OnVolume_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPOnVolume_Min::dp_tclAudioStackMultiDPOnVolume_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPOnVolume_Min::s32SetData( tU8* tOnVolume_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("OnVolume_Min", (tS32)0x332e7f50);
   (tVoid)myDpElem.bFillData((tVoid*)tOnVolume_MinParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPOnVolume_Min::s32GetData(tU8* tOnVolume_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("OnVolume_Min", (tS32)0x332e7f50);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tOnVolume_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPOnVolume_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPOnVolume_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPOnVolume_Min::u16GetData(tU8* tOnVolume_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tOnVolume_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPOnVolume_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "OnVolume_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPOnVolume_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "OnVolume_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPOnVolume_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: OnVolume_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element OnVolume_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "group_volume_list_for_amp_a"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::s32SetData( tU8* tgroup_volume_list_for_amp_aParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("group_volume_list_for_amp_a", (tS32)0x76e4787eL);
   (tVoid)myDpElem.bFillData((tVoid*)tgroup_volume_list_for_amp_aParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::s32GetData(tU8* tgroup_volume_list_for_amp_aParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("group_volume_list_for_amp_a", (tS32)0x76e4787eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tgroup_volume_list_for_amp_aParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::u16GetData(tU8* tgroup_volume_list_for_amp_aParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tgroup_volume_list_for_amp_aParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "group_volume_list_for_amp_a", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "group_volume_list_for_amp_a", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: group_volume_list_for_amp_a", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element group_volume_list_for_amp_a has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "group_volume_list_for_amp_b"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::s32SetData( tU8* tgroup_volume_list_for_amp_bParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("group_volume_list_for_amp_b", (tS32)0x76e4787fL);
   (tVoid)myDpElem.bFillData((tVoid*)tgroup_volume_list_for_amp_bParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::s32GetData(tU8* tgroup_volume_list_for_amp_bParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("group_volume_list_for_amp_b", (tS32)0x76e4787fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tgroup_volume_list_for_amp_bParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::u16GetData(tU8* tgroup_volume_list_for_amp_bParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tgroup_volume_list_for_amp_bParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "group_volume_list_for_amp_b", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIDP, "group_volume_list_for_amp_b", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: group_volume_list_for_amp_b", DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIDP);
		}
		else
		{
			fprintf(stdout,"Element group_volume_list_for_amp_b has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

