#ifndef _DP_FI_EARLYCONFIGTOUCHDRIVER_H
#define _DP_FI_EARLYCONFIGTOUCHDRIVER_H

extern tVoid vInitEarlyConfigTouchDriver(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclEarlyConfigTouchDriverTrTouchDriverName{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigTouchDriverTrTouchDriverName(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTouchDriverTrTouchDriverName() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrTouchDriverNameParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrTouchDriverNameParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrTouchDriverNameParam);
   tS32 s32SetData(const tString &tTrTouchDriverNameParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrTouchDriverNameParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrTouchDriverNameParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrTouchDriverNameParam);
   tVoid vSetData(const tString &tTrTouchDriverNameParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTouchDriverTrTouchConfigFileName{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigTouchDriverTrTouchConfigFileName(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTouchDriverTrTouchConfigFileName() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrTouchConfigFileNameParam);
   tS32 s32SetData(const tString &tTrTouchConfigFileNameParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrTouchConfigFileNameParam);
   tVoid vSetData(const tString &tTrTouchConfigFileNameParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTouchDriverTrTouchI2CAddr{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigTouchDriverTrTouchI2CAddr(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTouchDriverTrTouchI2CAddr() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrTouchI2CAddrParam);
   tS32 s32SetData(const tString &tTrTouchI2CAddrParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrTouchI2CAddrParam);
   tVoid vSetData(const tString &tTrTouchI2CAddrParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
