#ifndef _DP_FI_EARLYCONFIGRTCDRIVER_H
#define _DP_FI_EARLYCONFIGRTCDRIVER_H

extern tVoid vInitEarlyConfigRTCDriver(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclEarlyConfigRTCDriverTrRtcDriverName{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigRTCDriverTrRtcDriverName(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigRTCDriverTrRtcDriverName() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrRtcDriverNameParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrRtcDriverNameParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrRtcDriverNameParam);
   tS32 s32SetData(const tString &tTrRtcDriverNameParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrRtcDriverNameParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrRtcDriverNameParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrRtcDriverNameParam);
   tVoid vSetData(const tString &tTrRtcDriverNameParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
