
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigRTCDriver.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrRtcDriverName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigRTCDriverTrRtcDriverName::dp_tclEarlyConfigRTCDriverTrRtcDriverName(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigRTCDriverTrRtcDriverName::s32SetData(tString &tTrRtcDriverNameParam) {
   tU32 u32Len = (tU32)strlen(tTrRtcDriverNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrRtcDriverName", (tS32)0x54b3d20);
      (tVoid)myDpElem.bFillData((tVoid*)tTrRtcDriverNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigRTCDriverTrRtcDriverName::s32SetData(const tString &tTrRtcDriverNameParam) {
   tU32 u32Len = (tU32)strlen(tTrRtcDriverNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrRtcDriverName", (tS32)0x54b3d20);
      (tVoid)myDpElem.bFillData((tVoid*)tTrRtcDriverNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigRTCDriverTrRtcDriverName::s32GetData(tString &tTrRtcDriverNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrRtcDriverName", (tS32)0x54b3d20);
   (tVoid)memset(tTrRtcDriverNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrRtcDriverNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigRTCDriverTrRtcDriverName::s32GetData(const tString &tTrRtcDriverNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrRtcDriverName", (tS32)0x54b3d20);
   (tVoid)memset(tTrRtcDriverNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrRtcDriverNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigRTCDriverTrRtcDriverName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigRTCDriverTrRtcDriverName::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigRTCDriverTrRtcDriverName::u32GetData(tString &tTrRtcDriverNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrRtcDriverNameParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigRTCDriverTrRtcDriverName::u32GetData(const tString &tTrRtcDriverNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrRtcDriverNameParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigRTCDriverTrRtcDriverName::vSetData(tString &tTrRtcDriverNameParam){(tVoid)s32SetData(tTrRtcDriverNameParam);};
   tVoid dp_tclEarlyConfigRTCDriverTrRtcDriverName::vSetData(const tString &tTrRtcDriverNameParam){(tVoid)s32SetData(tTrRtcDriverNameParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigRTCDriverTrRtcDriverName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER, "TrRtcDriverName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigRTCDriverTrRtcDriverName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER, "TrRtcDriverName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigRTCDriverTrRtcDriverName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrRtcDriverName", DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGRTCDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrRtcDriverName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 

