#ifndef _DP_FI_EARLYCONFIGDISPLAY_H
#define _DP_FI_EARLYCONFIGDISPLAY_H

extern tVoid vInitEarlyConfigDisplay(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclEarlyConfigDisplayTrResolution{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigDisplayTrResolution(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigDisplayTrResolution() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrResolutionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrResolutionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrResolutionParam);
   tS32 s32SetData(const tString &tTrResolutionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrResolutionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrResolutionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrResolutionParam);
   tVoid vSetData(const tString &tTrResolutionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigDisplayTrBackwardComp{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tTrBackwardComp;
   
public:
   dp_tclEarlyConfigDisplayTrBackwardComp(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigDisplayTrBackwardComp() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tTrBackwardCompParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tTrBackwardCompParam);
   tS32  s32SetData(const tS32 &tTrBackwardCompParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tTrBackwardCompParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tTrBackwardCompParam);
   tVoid vSetData(const tS32& tTrBackwardCompParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigDisplayTrLowFrequency{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tTrLowFrequency;
   
public:
   dp_tclEarlyConfigDisplayTrLowFrequency(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigDisplayTrLowFrequency() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tTrLowFrequencyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tTrLowFrequencyParam);
   tS32  s32SetData(const tS32 &tTrLowFrequencyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tTrLowFrequencyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tTrLowFrequencyParam);
   tVoid vSetData(const tS32& tTrLowFrequencyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tTrFlagManualDisplaySetting;
   
public:
   dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tTrFlagManualDisplaySettingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tTrFlagManualDisplaySettingParam);
   tS32  s32SetData(const tBool &tTrFlagManualDisplaySettingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tTrFlagManualDisplaySettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tTrFlagManualDisplaySettingParam);
   tVoid vSetData(const tBool& tTrFlagManualDisplaySettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
