
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigDisplay.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrResolution"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigDisplayTrResolution::dp_tclEarlyConfigDisplayTrResolution(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigDisplayTrResolution::s32SetData(tString &tTrResolutionParam) {
   tU32 u32Len = (tU32)strlen(tTrResolutionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrResolution", (tS32)0x43641722);
      (tVoid)myDpElem.bFillData((tVoid*)tTrResolutionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigDisplayTrResolution::s32SetData(const tString &tTrResolutionParam) {
   tU32 u32Len = (tU32)strlen(tTrResolutionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrResolution", (tS32)0x43641722);
      (tVoid)myDpElem.bFillData((tVoid*)tTrResolutionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigDisplayTrResolution::s32GetData(tString &tTrResolutionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrResolution", (tS32)0x43641722);
   (tVoid)memset(tTrResolutionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrResolutionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigDisplayTrResolution::s32GetData(const tString &tTrResolutionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrResolution", (tS32)0x43641722);
   (tVoid)memset(tTrResolutionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrResolutionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigDisplayTrResolution::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigDisplayTrResolution::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigDisplayTrResolution::u32GetData(tString &tTrResolutionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrResolutionParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigDisplayTrResolution::u32GetData(const tString &tTrResolutionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrResolutionParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigDisplayTrResolution::vSetData(tString &tTrResolutionParam){(tVoid)s32SetData(tTrResolutionParam);};
   tVoid dp_tclEarlyConfigDisplayTrResolution::vSetData(const tString &tTrResolutionParam){(tVoid)s32SetData(tTrResolutionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigDisplayTrResolution::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrResolution", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigDisplayTrResolution::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrResolution", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigDisplayTrResolution::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrResolution", DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
		}
		else
		{
			fprintf(stdout,"Element TrResolution has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrBackwardComp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigDisplayTrBackwardComp::dp_tclEarlyConfigDisplayTrBackwardComp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrBackwardComp,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigDisplayTrBackwardComp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrBackwardComp",(tS32) 0x61f4bb94);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tTrBackwardComp = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigDisplayTrBackwardComp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrBackwardComp", (tS32)0x61f4bb94);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrBackwardComp, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigDisplayTrBackwardComp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigDisplayTrBackwardComp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclEarlyConfigDisplayTrBackwardComp::tGetData() {
   vUpdate();
   return tTrBackwardComp;
};
tS32 dp_tclEarlyConfigDisplayTrBackwardComp::s32GetData(tS32& tTrBackwardCompParam) { 
   vUpdate();
   tTrBackwardCompParam = tTrBackwardComp;
   return _s32Status;
}
tS32 dp_tclEarlyConfigDisplayTrBackwardComp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrBackwardComp", (tS32)0x61f4bb94);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigDisplayTrBackwardComp::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigDisplayTrBackwardComp::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigDisplayTrBackwardComp::s32SetData(tS32 &tTrBackwardCompParam) {
   //init parameter
   (tVoid)memcpy(&tTrBackwardComp,(tVoid*)&tTrBackwardCompParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrBackwardCompParam' in function 'dp_tclEarlyConfigDisplayTrBackwardComp::vSetData(tS32)' could be made const reference
tS32 dp_tclEarlyConfigDisplayTrBackwardComp::s32SetData(const tS32 &tTrBackwardCompParam) {
   //init parameter
   (tVoid)memcpy(&tTrBackwardComp,(tVoid*)&tTrBackwardCompParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrBackwardCompParam' in function 'dp_tclEarlyConfigDisplayTrBackwardComp::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigDisplayTrBackwardComp::u8GetData(tS32& tTrBackwardCompParam) {  
   vUpdate();
   tTrBackwardCompParam = tTrBackwardComp;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigDisplayTrBackwardComp::vSetData(tS32 &tTrBackwardCompParam) { 
   //init parameter
   (tVoid)memcpy(&tTrBackwardComp,(tVoid*)&tTrBackwardCompParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrBackwardCompParam' in function 'dp_tclEarlyConfigDisplayTrBackwardComp::vSetData(tS32)' could be made const reference
tVoid dp_tclEarlyConfigDisplayTrBackwardComp::vSetData(const tS32 &tTrBackwardCompParam) { 
   //init parameter
   (tVoid)memcpy(&tTrBackwardComp,(tVoid*)&tTrBackwardCompParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrBackwardCompParam' in function 'dp_tclEarlyConfigDisplayTrBackwardComp::vSetData(tS32)' could be made const reference
tU8   dp_tclEarlyConfigDisplayTrBackwardComp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigDisplayTrBackwardComp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrBackwardComp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigDisplayTrBackwardComp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrBackwardComp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigDisplayTrBackwardComp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrBackwardComp", DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
   }
   else
   {
      fprintf(stdout,"Element TrBackwardComp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrLowFrequency"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigDisplayTrLowFrequency::dp_tclEarlyConfigDisplayTrLowFrequency(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrLowFrequency,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigDisplayTrLowFrequency::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrLowFrequency",(tS32) 0x88a8281a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tTrLowFrequency = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigDisplayTrLowFrequency::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrLowFrequency", (tS32)0x88a8281a);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrLowFrequency, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigDisplayTrLowFrequency::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigDisplayTrLowFrequency::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclEarlyConfigDisplayTrLowFrequency::tGetData() {
   vUpdate();
   return tTrLowFrequency;
};
tS32 dp_tclEarlyConfigDisplayTrLowFrequency::s32GetData(tS32& tTrLowFrequencyParam) { 
   vUpdate();
   tTrLowFrequencyParam = tTrLowFrequency;
   return _s32Status;
}
tS32 dp_tclEarlyConfigDisplayTrLowFrequency::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrLowFrequency", (tS32)0x88a8281a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigDisplayTrLowFrequency::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigDisplayTrLowFrequency::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigDisplayTrLowFrequency::s32SetData(tS32 &tTrLowFrequencyParam) {
   //init parameter
   (tVoid)memcpy(&tTrLowFrequency,(tVoid*)&tTrLowFrequencyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrLowFrequencyParam' in function 'dp_tclEarlyConfigDisplayTrLowFrequency::vSetData(tS32)' could be made const reference
tS32 dp_tclEarlyConfigDisplayTrLowFrequency::s32SetData(const tS32 &tTrLowFrequencyParam) {
   //init parameter
   (tVoid)memcpy(&tTrLowFrequency,(tVoid*)&tTrLowFrequencyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrLowFrequencyParam' in function 'dp_tclEarlyConfigDisplayTrLowFrequency::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigDisplayTrLowFrequency::u8GetData(tS32& tTrLowFrequencyParam) {  
   vUpdate();
   tTrLowFrequencyParam = tTrLowFrequency;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigDisplayTrLowFrequency::vSetData(tS32 &tTrLowFrequencyParam) { 
   //init parameter
   (tVoid)memcpy(&tTrLowFrequency,(tVoid*)&tTrLowFrequencyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrLowFrequencyParam' in function 'dp_tclEarlyConfigDisplayTrLowFrequency::vSetData(tS32)' could be made const reference
tVoid dp_tclEarlyConfigDisplayTrLowFrequency::vSetData(const tS32 &tTrLowFrequencyParam) { 
   //init parameter
   (tVoid)memcpy(&tTrLowFrequency,(tVoid*)&tTrLowFrequencyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrLowFrequencyParam' in function 'dp_tclEarlyConfigDisplayTrLowFrequency::vSetData(tS32)' could be made const reference
tU8   dp_tclEarlyConfigDisplayTrLowFrequency::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigDisplayTrLowFrequency::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrLowFrequency", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigDisplayTrLowFrequency::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrLowFrequency", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigDisplayTrLowFrequency::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrLowFrequency", DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
   }
   else
   {
      fprintf(stdout,"Element TrLowFrequency has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrFlagManualDisplaySetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrFlagManualDisplaySetting,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrFlagManualDisplaySetting",(tS32) 0x7608c2L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tTrFlagManualDisplaySetting = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrFlagManualDisplaySetting", (tS32)0x7608c2L);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrFlagManualDisplaySetting, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::tGetData() {
   vUpdate();
   return tTrFlagManualDisplaySetting;
};
tS32 dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::s32GetData(tBool& tTrFlagManualDisplaySettingParam) { 
   vUpdate();
   tTrFlagManualDisplaySettingParam = tTrFlagManualDisplaySetting;
   return _s32Status;
}
tS32 dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrFlagManualDisplaySetting", (tS32)0x7608c2L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::s32SetData(tBool &tTrFlagManualDisplaySettingParam) {
   //init parameter
   (tVoid)memcpy(&tTrFlagManualDisplaySetting,(tVoid*)&tTrFlagManualDisplaySettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrFlagManualDisplaySettingParam' in function 'dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vSetData(tBool)' could be made const reference
tS32 dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::s32SetData(const tBool &tTrFlagManualDisplaySettingParam) {
   //init parameter
   (tVoid)memcpy(&tTrFlagManualDisplaySetting,(tVoid*)&tTrFlagManualDisplaySettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrFlagManualDisplaySettingParam' in function 'dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::u8GetData(tBool& tTrFlagManualDisplaySettingParam) {  
   vUpdate();
   tTrFlagManualDisplaySettingParam = tTrFlagManualDisplaySetting;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vSetData(tBool &tTrFlagManualDisplaySettingParam) { 
   //init parameter
   (tVoid)memcpy(&tTrFlagManualDisplaySetting,(tVoid*)&tTrFlagManualDisplaySettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tTrFlagManualDisplaySettingParam' in function 'dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vSetData(tBool)' could be made const reference
tVoid dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vSetData(const tBool &tTrFlagManualDisplaySettingParam) { 
   //init parameter
   (tVoid)memcpy(&tTrFlagManualDisplaySetting,(tVoid*)&tTrFlagManualDisplaySettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tTrFlagManualDisplaySettingParam' in function 'dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::vSetData(tBool)' could be made const reference
tU8   dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrFlagManualDisplaySetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGDISPLAY, "TrFlagManualDisplaySetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigDisplayTrFlagManualDisplaySetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrFlagManualDisplaySetting", DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGDISPLAY);
   }
   else
   {
      fprintf(stdout,"Element TrFlagManualDisplaySetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
