#ifndef _DP_FI_EARLYCONFIGCSC_H
#define _DP_FI_EARLYCONFIGCSC_H

extern tVoid vInitEarlyConfigCSC(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclEarlyConfigCSCTrCurrentProfile{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTrCurrentProfile;
   
public:
   dp_tclEarlyConfigCSCTrCurrentProfile(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrCurrentProfile() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTrCurrentProfileParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTrCurrentProfileParam);
   tS32  s32SetData(const tU8 &tTrCurrentProfileParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTrCurrentProfileParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTrCurrentProfileParam);
   tVoid vSetData(const tU8& tTrCurrentProfileParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrHueValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrHueValue;
   
public:
   dp_tclEarlyConfigCSCTrHueValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrHueValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrHueValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrHueValueParam);
   tS32  s32SetData(const tS16 &tTrHueValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrHueValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrHueValueParam);
   tVoid vSetData(const tS16& tTrHueValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrContrastValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrContrastValue;
   
public:
   dp_tclEarlyConfigCSCTrContrastValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrContrastValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrContrastValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrContrastValueParam);
   tS32  s32SetData(const tS16 &tTrContrastValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrContrastValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrContrastValueParam);
   tVoid vSetData(const tS16& tTrContrastValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrSaturationValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrSaturationValue;
   
public:
   dp_tclEarlyConfigCSCTrSaturationValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrSaturationValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrSaturationValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrSaturationValueParam);
   tS32  s32SetData(const tS16 &tTrSaturationValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrSaturationValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrSaturationValueParam);
   tVoid vSetData(const tS16& tTrSaturationValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrBrightnessValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrBrightnessValue;
   
public:
   dp_tclEarlyConfigCSCTrBrightnessValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrBrightnessValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrBrightnessValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrBrightnessValueParam);
   tS32  s32SetData(const tS16 &tTrBrightnessValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrBrightnessValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrBrightnessValueParam);
   tVoid vSetData(const tS16& tTrBrightnessValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrHueOffsetValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrHueOffsetValue;
   
public:
   dp_tclEarlyConfigCSCTrHueOffsetValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrHueOffsetValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrHueOffsetValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrHueOffsetValueParam);
   tS32  s32SetData(const tS16 &tTrHueOffsetValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrHueOffsetValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrHueOffsetValueParam);
   tVoid vSetData(const tS16& tTrHueOffsetValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrSaturationOffsetValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrSaturationOffsetValue;
   
public:
   dp_tclEarlyConfigCSCTrSaturationOffsetValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrSaturationOffsetValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrSaturationOffsetValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrSaturationOffsetValueParam);
   tS32  s32SetData(const tS16 &tTrSaturationOffsetValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrSaturationOffsetValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrSaturationOffsetValueParam);
   tVoid vSetData(const tS16& tTrSaturationOffsetValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrBrightnessOffsetValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tTrBrightnessOffsetValue;
   
public:
   dp_tclEarlyConfigCSCTrBrightnessOffsetValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrBrightnessOffsetValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tTrBrightnessOffsetValueParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tTrBrightnessOffsetValueParam);
   tS32  s32SetData(const tS16 &tTrBrightnessOffsetValueParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tTrBrightnessOffsetValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tTrBrightnessOffsetValueParam);
   tVoid vSetData(const tS16& tTrBrightnessOffsetValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigCSCTrGammaFactor{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tF64 tTrGammaFactor;
   
public:
   dp_tclEarlyConfigCSCTrGammaFactor(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigCSCTrGammaFactor() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tF64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tF64& tTrGammaFactorParam);
   tVoid operator>>(tF64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tF64 &tTrGammaFactorParam);
   tS32  s32SetData(const tF64 &tTrGammaFactorParam);
   tVoid operator<<(tF64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tF64& tTrGammaFactorParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tF64& tTrGammaFactorParam);
   tVoid vSetData(const tF64& tTrGammaFactorParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
