
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDATASET_VD_EARLY_CONFIG.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyNorConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyNorConfig,0,sizeof(TEarlyNorConfiguration));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyNorConfig",(tS32) 0xbb23321e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TEarlyNorConfiguration)) 
      {
         tEarlyNorConfig = *((TEarlyNorConfiguration*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyNorConfig", (tS32)0xbb23321e);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyNorConfig, (tU32)sizeof(TEarlyNorConfiguration));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TEarlyNorConfiguration dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::tGetData() {
   vUpdate();
   return tEarlyNorConfig;
};
tS32 dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::s32GetData(TEarlyNorConfiguration& tEarlyNorConfigParam) { 
   vUpdate();
   tEarlyNorConfigParam = tEarlyNorConfig;
   return _s32Status;
}
tS32 dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyNorConfig", (tS32)0xbb23321e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::operator>>(TEarlyNorConfiguration& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::operator<<(TEarlyNorConfiguration oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::s32SetData(TEarlyNorConfiguration &tEarlyNorConfigParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyNorConfig,(tVoid*)&tEarlyNorConfigParam, sizeof(TEarlyNorConfiguration));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyNorConfigParam' in function 'dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vSetData(TEarlyNorConfiguration)' could be made const reference
tS32 dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::s32SetData(const TEarlyNorConfiguration &tEarlyNorConfigParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyNorConfig,(tVoid*)&tEarlyNorConfigParam, sizeof(TEarlyNorConfiguration));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyNorConfigParam' in function 'dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vSetData(TEarlyNorConfiguration)' could be made const reference
// do not use --> old interface
tU8 dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::u8GetData(TEarlyNorConfiguration& tEarlyNorConfigParam) {  
   vUpdate();
   tEarlyNorConfigParam = tEarlyNorConfig;
   return _u8DataStatus;
}
tVoid dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vSetData(TEarlyNorConfiguration &tEarlyNorConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyNorConfig,(tVoid*)&tEarlyNorConfigParam, sizeof(TEarlyNorConfiguration));
   vStore();
}//lint !e1746: parameter 'tEarlyNorConfigParam' in function 'dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vSetData(TEarlyNorConfiguration)' could be made const reference
tVoid dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vSetData(const TEarlyNorConfiguration &tEarlyNorConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyNorConfig,(tVoid*)&tEarlyNorConfigParam, sizeof(TEarlyNorConfiguration));
   vStore();
}//lint !e1746: parameter 'tEarlyNorConfigParam' in function 'dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::vSetData(TEarlyNorConfiguration)' could be made const reference
tU8   dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG, "EarlyNorConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG, "EarlyNorConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDATASET_VD_EARLY_CONFIGEarlyNorConfig::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyNorConfig", DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DATASET_VD_EARLY_CONFIG);
   }
   else
   {
      fprintf(stdout,"Element EarlyNorConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
