#ifndef _DP_FI_ENGINESOUNDDP_H
#define _DP_FI_ENGINESOUNDDP_H

extern tVoid vInitEngineSoundDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER 
#include "fc_audiomanager_if.h"
//lint +e750




class dp_tclEngineSoundDPEngineSound_Data{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclEngineSoundDPEngineSound_Data(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundDPEngineSound_Data() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tEngineSound_DataParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tEngineSound_DataParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tEngineSound_DataParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
