
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDpPddKernel.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SynergyDriver"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpPddKernelSynergyDriver::dp_tclDpPddKernelSynergyDriver(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSynergyDriver,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDpPddKernelSynergyDriver::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SynergyDriver",(tS32) 0x670424b9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPPDDKERNEL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSynergyDriver = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDpPddKernelSynergyDriver::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SynergyDriver", (tS32)0x670424b9);
   (tVoid)myDpElem.bFillData((tVoid*)&tSynergyDriver, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPPDDKERNEL, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDpPddKernelSynergyDriver::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDpPddKernelSynergyDriver::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclDpPddKernelSynergyDriver::tGetData() {
   vUpdate();
   return tSynergyDriver;
};
tS32 dp_tclDpPddKernelSynergyDriver::s32GetData(tU32& tSynergyDriverParam) { 
   vUpdate();
   tSynergyDriverParam = tSynergyDriver;
   return _s32Status;
}
tS32 dp_tclDpPddKernelSynergyDriver::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SynergyDriver", (tS32)0x670424b9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPPDDKERNEL, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDpPddKernelSynergyDriver::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDpPddKernelSynergyDriver::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDpPddKernelSynergyDriver::s32SetData(tU32 &tSynergyDriverParam) {
   //init parameter
   (tVoid)memcpy(&tSynergyDriver,(tVoid*)&tSynergyDriverParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSynergyDriverParam' in function 'dp_tclDpPddKernelSynergyDriver::vSetData(tU32)' could be made const reference
tS32 dp_tclDpPddKernelSynergyDriver::s32SetData(const tU32 &tSynergyDriverParam) {
   //init parameter
   (tVoid)memcpy(&tSynergyDriver,(tVoid*)&tSynergyDriverParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSynergyDriverParam' in function 'dp_tclDpPddKernelSynergyDriver::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDpPddKernelSynergyDriver::u8GetData(tU32& tSynergyDriverParam) {  
   vUpdate();
   tSynergyDriverParam = tSynergyDriver;
   return _u8DataStatus;
}
tVoid dp_tclDpPddKernelSynergyDriver::vSetData(tU32 &tSynergyDriverParam) { 
   //init parameter
   (tVoid)memcpy(&tSynergyDriver,(tVoid*)&tSynergyDriverParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSynergyDriverParam' in function 'dp_tclDpPddKernelSynergyDriver::vSetData(tU32)' could be made const reference
tVoid dp_tclDpPddKernelSynergyDriver::vSetData(const tU32 &tSynergyDriverParam) { 
   //init parameter
   (tVoid)memcpy(&tSynergyDriver,(tVoid*)&tSynergyDriverParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSynergyDriverParam' in function 'dp_tclDpPddKernelSynergyDriver::vSetData(tU32)' could be made const reference
tU8   dp_tclDpPddKernelSynergyDriver::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDpPddKernelSynergyDriver::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DPPDDKERNEL, "SynergyDriver", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDpPddKernelSynergyDriver::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DPPDDKERNEL, "SynergyDriver", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDpPddKernelSynergyDriver::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SynergyDriver", DP_U32_POOL_ID_DPPDDKERNEL);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DPPDDKERNEL);
   }
   else
   {
      fprintf(stdout,"Element SynergyDriver has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DisplayTiming"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpPddKernelDisplayTiming::dp_tclDpPddKernelDisplayTiming(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDpPddKernelDisplayTiming::s32SetData( tU8* tDisplayTimingParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DisplayTiming", (tS32)0x62328232);
   (tVoid)myDpElem.bFillData((tVoid*)tDisplayTimingParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPPDDKERNEL, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDpPddKernelDisplayTiming::s32GetData(tU8* tDisplayTimingParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DisplayTiming", (tS32)0x62328232);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPPDDKERNEL, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDisplayTimingParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDpPddKernelDisplayTiming::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDpPddKernelDisplayTiming::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDpPddKernelDisplayTiming::u16GetData(tU8* tDisplayTimingParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDisplayTimingParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDpPddKernelDisplayTiming::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DPPDDKERNEL, "DisplayTiming", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDpPddKernelDisplayTiming::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DPPDDKERNEL, "DisplayTiming", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDpPddKernelDisplayTiming::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DisplayTiming", DP_U32_POOL_ID_DPPDDKERNEL);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DPPDDKERNEL);
		}
		else
		{
			fprintf(stdout,"Element DisplayTiming has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

